/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.util.validation;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.springframework.util.StringUtils;

public class ValidationUtils {
    private static final Pattern PATTERN_MOBILE = Pattern.compile("^(?:(?:\\+|00)86)?1(?:(?:3[\\d])|(?:4[5-79])|(?:5[0-35-9])|(?:6[5-7])|(?:7[0-8])|(?:8[\\d])|(?:9[189]))\\d{8}$");
    private static final Pattern PATTERN_URL = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    private static final Pattern PATTERN_XML_NCNAME = Pattern.compile("[a-zA-Z_][\\-_.0-9_a-zA-Z$]*");

    public static boolean isMobile(String mobile) {
        return StringUtils.hasText((String)mobile) && PATTERN_MOBILE.matcher(mobile).matches();
    }

    public static boolean isURL(String url) {
        return StringUtils.hasText((String)url) && PATTERN_URL.matcher(url).matches();
    }

    public static boolean isXmlNCName(String str) {
        return StringUtils.hasText((String)str) && PATTERN_XML_NCNAME.matcher(str).matches();
    }

    public static void validate(Validator validator, Object object, Class<?> ... groups) {
        Set constraintViolations = validator.validate(object, (Class[])groups);
        if (CollUtil.isNotEmpty((Collection)constraintViolations)) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }
}

