/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.api.dept;

import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.flowable.api.dept.PostApi;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApiImpl;
import com.yqbsoft.laser.service.flowable.enums.CommonStatusEnum;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.organize.model.OrgPosition;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostApiImpl
implements PostApi {
    @Autowired
    InternalRouter internalRouter;

    @Override
    public void validPostList(Collection<String> ids) {
        String positionCodes = AdminUserApiImpl.extracted(ids);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("positionCode", positionCodes);
        map.put("tenantCode", "733997198045540435");
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String s = (String)this.internalRouter.inInvoke("org.position.queryPositionPage", parma);
        SupQueryResult positionPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(s, QueryResult.class);
        List positions = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)positionPage.getList()), OrgPosition.class);
        Map<String, OrgPosition> positionMap = CollectionUtils.convertMap(positions, OrgPosition::getPositionCode);
        ids.forEach(id -> {
            OrgPosition orgPosition = (OrgPosition)positionMap.get(id);
            if (orgPosition == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.POSITION_NOT_EXISTS);
            }
            if (!CommonStatusEnum.ENABLE.getStatus().equals(orgPosition.getDataState())) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.POSITION_IS_DISABLE, orgPosition.getPositionName());
            }
        });
    }
}

