/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.util;

import cn.hutool.core.collection.CollUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;

public class BpmnModelUtils {
    public static String formatCollectionVariable(String activityId) {
        return activityId + "_assignees";
    }

    public static String formatCollectionElementVariable(String activityId) {
        return activityId + "_assignee";
    }

    public static List<SequenceFlow> getElementIncomingFlows(FlowElement source) {
        if (source instanceof FlowNode) {
            return ((FlowNode)source).getIncomingFlows();
        }
        return new ArrayList<SequenceFlow>();
    }

    public static List<SequenceFlow> getElementOutgoingFlows(FlowElement source) {
        if (source instanceof FlowNode) {
            return ((FlowNode)source).getOutgoingFlows();
        }
        return new ArrayList<SequenceFlow>();
    }

    public static FlowElement getFlowElementById(BpmnModel model, String flowElementId) {
        Process process = model.getMainProcess();
        return process.getFlowElement(flowElementId);
    }

    public static <T extends FlowElement> List<T> getBpmnModelElements(BpmnModel model, Class<T> clazz) {
        ArrayList result = new ArrayList();
        model.getProcesses().forEach(process -> process.getFlowElements().forEach(flowElement -> {
            if (flowElement.getClass().isAssignableFrom(clazz)) {
                result.add(flowElement);
            }
        }));
        return result;
    }

    public static boolean equals(BpmnModel oldModel, BpmnModel newModel) {
        return Arrays.equals(BpmnModelUtils.getBpmnBytes(oldModel), BpmnModelUtils.getBpmnBytes(newModel));
    }

    public static byte[] getBpmnBytes(BpmnModel model) {
        if (model == null) {
            return new byte[0];
        }
        BpmnXMLConverter converter = new BpmnXMLConverter();
        return converter.convertToXML(model);
    }

    public static List<UserTask> getPreviousUserTaskList(FlowElement source, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        List<SequenceFlow> sequenceFlows;
        userTaskList = userTaskList == null ? new ArrayList<UserTask>() : userTaskList;
        HashSet<String> hashSet = hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            userTaskList = BpmnModelUtils.getPreviousUserTaskList((FlowElement)source.getSubProcess(), hasSequenceFlow, userTaskList);
        }
        if ((sequenceFlows = BpmnModelUtils.getElementIncomingFlows(source)) == null) {
            return userTaskList;
        }
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            List<UserTask> childUserTaskList;
            if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
            hasSequenceFlow.add(sequenceFlow.getId());
            if (sequenceFlow.getSourceFlowElement() instanceof UserTask) {
                userTaskList.add((UserTask)sequenceFlow.getSourceFlowElement());
            }
            if (sequenceFlow.getSourceFlowElement() instanceof SubProcess && CollUtil.isNotEmpty(childUserTaskList = BpmnModelUtils.findChildProcessUserTaskList((FlowElement)((StartEvent)((SubProcess)sequenceFlow.getSourceFlowElement()).getFlowElements().toArray()[0]), null, null))) {
                userTaskList.addAll(childUserTaskList);
            }
            userTaskList = BpmnModelUtils.getPreviousUserTaskList(sequenceFlow.getSourceFlowElement(), hasSequenceFlow, userTaskList);
        }
        return userTaskList;
    }

    public static List<UserTask> findChildProcessUserTaskList(FlowElement source, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        userTaskList = userTaskList == null ? new ArrayList<UserTask>() : userTaskList;
        List<SequenceFlow> sequenceFlows = BpmnModelUtils.getElementOutgoingFlows(source);
        if (sequenceFlows == null) {
            return userTaskList;
        }
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            List<UserTask> childUserTaskList;
            if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
            hasSequenceFlow.add(sequenceFlow.getId());
            if (sequenceFlow.getTargetFlowElement() instanceof UserTask) {
                userTaskList.add((UserTask)sequenceFlow.getTargetFlowElement());
                continue;
            }
            if (sequenceFlow.getTargetFlowElement() instanceof SubProcess && CollUtil.isNotEmpty(childUserTaskList = BpmnModelUtils.findChildProcessUserTaskList((FlowElement)((SubProcess)sequenceFlow.getTargetFlowElement()).getFlowElements().toArray()[0], hasSequenceFlow, null))) {
                userTaskList.addAll(childUserTaskList);
                continue;
            }
            userTaskList = BpmnModelUtils.findChildProcessUserTaskList(sequenceFlow.getTargetFlowElement(), hasSequenceFlow, userTaskList);
        }
        return userTaskList;
    }

    public static boolean isSequentialReachable(FlowElement source, FlowElement target, Set<String> visitedElements) {
        HashSet<String> hashSet = visitedElements = visitedElements == null ? new HashSet<String>() : visitedElements;
        if (source instanceof StartEvent && BpmnModelUtils.isInEventSubprocess(source)) {
            return false;
        }
        List<SequenceFlow> sequenceFlows = BpmnModelUtils.getElementIncomingFlows(source);
        if (CollUtil.isEmpty(sequenceFlows)) {
            return true;
        }
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            if (visitedElements.contains(sequenceFlow.getId())) continue;
            visitedElements.add(sequenceFlow.getId());
            FlowElement sourceFlowElement = sequenceFlow.getSourceFlowElement();
            if (target.getId().equals(sourceFlowElement.getId())) continue;
            if (sourceFlowElement instanceof ParallelGateway) {
                return false;
            }
            if (BpmnModelUtils.isSequentialReachable(sourceFlowElement, target, visitedElements)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInEventSubprocess(FlowElement flowElement) {
        FlowElementsContainer flowElementsContainer = flowElement.getParentContainer();
        while (flowElementsContainer != null) {
            if (flowElementsContainer instanceof EventSubProcess) {
                return true;
            }
            if (flowElementsContainer instanceof FlowElement) {
                flowElementsContainer = ((FlowElement)flowElementsContainer).getParentContainer();
                continue;
            }
            flowElementsContainer = null;
        }
        return false;
    }

    public static List<UserTask> iteratorFindChildUserTasks(FlowElement source, List<String> runTaskKeyList, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        List<SequenceFlow> sequenceFlows;
        hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        List<UserTask> list = userTaskList = userTaskList == null ? new ArrayList<UserTask>() : userTaskList;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            userTaskList = BpmnModelUtils.iteratorFindChildUserTasks((FlowElement)source.getSubProcess(), runTaskKeyList, hasSequenceFlow, userTaskList);
        }
        if ((sequenceFlows = BpmnModelUtils.getElementOutgoingFlows(source)) == null) {
            return userTaskList;
        }
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            List<UserTask> childUserTaskList;
            if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
            hasSequenceFlow.add(sequenceFlow.getId());
            if (sequenceFlow.getTargetFlowElement() instanceof UserTask && runTaskKeyList.contains(sequenceFlow.getTargetFlowElement().getId())) {
                userTaskList.add((UserTask)sequenceFlow.getTargetFlowElement());
                continue;
            }
            if (sequenceFlow.getTargetFlowElement() instanceof SubProcess && CollUtil.isNotEmpty(childUserTaskList = BpmnModelUtils.iteratorFindChildUserTasks((FlowElement)((SubProcess)sequenceFlow.getTargetFlowElement()).getFlowElements().toArray()[0], runTaskKeyList, hasSequenceFlow, null))) {
                userTaskList.addAll(childUserTaskList);
                continue;
            }
            userTaskList = BpmnModelUtils.iteratorFindChildUserTasks(sequenceFlow.getTargetFlowElement(), runTaskKeyList, hasSequenceFlow, userTaskList);
        }
        return userTaskList;
    }
}

