/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.dao.WlExptimeMapper;
import com.yqbsoft.laser.service.logistics.domain.WlExptimeDomain;
import com.yqbsoft.laser.service.logistics.domain.WlExptimeReDomain;
import com.yqbsoft.laser.service.logistics.model.WlExptime;
import com.yqbsoft.laser.service.logistics.service.WlExptimeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WlExptimeServiceImpl
extends BaseServiceImpl
implements WlExptimeService {
    private static final String SYS_CODE = "wl.LOGISTICS.WlExptimeServiceImpl";
    private WlExptimeMapper wlExptimeMapper;

    public void setWlExptimeMapper(WlExptimeMapper wlExptimeMapper) {
        this.wlExptimeMapper = wlExptimeMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlExptimeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExptimeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkExptime(WlExptimeDomain wlExptimeDomain) {
        if (null == wlExptimeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlExptimeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setExptimeDefault(WlExptime wlExptime) {
        if (null == wlExptime) {
            return;
        }
        if (null == wlExptime.getDataState()) {
            wlExptime.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == wlExptime.getGmtCreate()) {
            wlExptime.setGmtCreate(date);
        }
        wlExptime.setGmtModified(date);
        if (StringUtils.isBlank((String)wlExptime.getExptimeCode())) {
            wlExptime.setExptimeCode(this.createUUIDString());
        }
    }

    private int getExptimeMaxCode() {
        int code = 0;
        try {
            return this.wlExptimeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExptimeServiceImpl.getExptimeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setExptimeUpdataDefault(WlExptime wlExptime) {
        if (null == wlExptime) {
            return;
        }
        wlExptime.setGmtModified(this.getSysDate());
    }

    private void saveExptimeModel(WlExptime wlExptime) throws ApiException {
        if (null == wlExptime) {
            return;
        }
        try {
            this.wlExptimeMapper.insert(wlExptime);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.saveExptimeModel.ex", (Throwable)e);
        }
    }

    private void saveExptimeBatchModel(List<WlExptime> wlExptimeList) throws ApiException {
        if (null == wlExptimeList || wlExptimeList.isEmpty()) {
            return;
        }
        try {
            this.wlExptimeMapper.insertBatch(wlExptimeList);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.saveExptimeBatchModel.ex", (Throwable)e);
        }
    }

    private WlExptime getExptimeModelById(Integer exptimeId) {
        if (null == exptimeId) {
            return null;
        }
        try {
            return this.wlExptimeMapper.selectByPrimaryKey(exptimeId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExptimeServiceImpl.getExptimeModelById", (Throwable)e);
            return null;
        }
    }

    private WlExptime getExptimeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlExptimeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExptimeServiceImpl.getExptimeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delExptimeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExptimeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.delExptimeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.delExptimeModelByCode.num");
        }
    }

    private void deleteExptimeModel(Integer exptimeId) throws ApiException {
        if (null == exptimeId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExptimeMapper.deleteByPrimaryKey(exptimeId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.deleteExptimeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.deleteExptimeModel.num");
        }
    }

    private void updateExptimeModel(WlExptime wlExptime) throws ApiException {
        if (null == wlExptime) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExptimeMapper.updateByPrimaryKeySelective(wlExptime);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateExptimeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateExptimeModel.num");
        }
    }

    private void updateStateExptimeModel(Integer exptimeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == exptimeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exptimeId", exptimeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlExptimeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateStateExptimeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateStateExptimeModel.null");
        }
    }

    private void updateStateExptimeModelByCode(String tenantCode, String exptimeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)exptimeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exptimeCode", exptimeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlExptimeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateStateExptimeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateStateExptimeModelByCode.null");
        }
    }

    private WlExptime makeExptime(WlExptimeDomain wlExptimeDomain, WlExptime wlExptime) {
        if (null == wlExptimeDomain) {
            return null;
        }
        if (null == wlExptime) {
            wlExptime = new WlExptime();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlExptime, (Object)wlExptimeDomain);
            return wlExptime;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExptimeServiceImpl.makeExptime", (Throwable)e);
            return null;
        }
    }

    private WlExptimeReDomain makeWlExptimeReDomain(WlExptime wlExptime) {
        if (null == wlExptime) {
            return null;
        }
        WlExptimeReDomain wlExptimeReDomain = new WlExptimeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlExptimeReDomain, (Object)wlExptime);
            return wlExptimeReDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExptimeServiceImpl.makeWlExptimeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WlExptime> queryExptimeModelPage(Map<String, Object> parammap) {
        try {
            if (parammap.get("type") != null && StringUtils.isNotBlank((String)((String)parammap.get("type"))) && "member".equals((String)parammap.get("type"))) {
                return this.wlExptimeMapper.queryMemberCode(parammap);
            }
            return this.wlExptimeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExptimeServiceImpl.queryExptimeModel", (Throwable)e);
            return null;
        }
    }

    private int countExptime(Map<String, Object> map) {
        int i = 0;
        try {
            i = map.get("type") != null && StringUtils.isNotBlank((String)((String)map.get("type"))) && "member".equals((String)map.get("type")) ? this.wlExptimeMapper.countMemberCode(map) : this.wlExptimeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlExptimeServiceImpl.countExptime", (Throwable)e);
        }
        return i;
    }

    private WlExptime createWlExptime(WlExptimeDomain wlExptimeDomain) {
        String msg = this.checkExptime(wlExptimeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.saveExptime.checkExptime", msg);
        }
        WlExptime wlExptime = this.makeExptime(wlExptimeDomain, null);
        this.setExptimeDefault(wlExptime);
        return wlExptime;
    }

    @Override
    public String saveExptime(WlExptimeDomain wlExptimeDomain) throws ApiException {
        WlExptime wlExptime = this.createWlExptime(wlExptimeDomain);
        this.saveExptimeModel(wlExptime);
        return wlExptime.getExptimeCode();
    }

    @Override
    public String saveExptimeBatch(List<WlExptimeDomain> wlExptimeDomainList) throws ApiException {
        if (null == wlExptimeDomainList || wlExptimeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WlExptime> wlExptimeList = new ArrayList<WlExptime>();
        String code = "";
        for (WlExptimeDomain wlExptimeDomain : wlExptimeDomainList) {
            WlExptime wlExptime = this.createWlExptime(wlExptimeDomain);
            code = wlExptime.getExptimeCode();
            wlExptimeList.add(wlExptime);
        }
        this.saveExptimeBatchModel(wlExptimeList);
        return code;
    }

    @Override
    public void updateExptimeState(Integer exptimeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == exptimeId) {
            return;
        }
        this.updateStateExptimeModel(exptimeId, dataState, oldDataState, map);
    }

    @Override
    public void updateExptimeStateByCode(String tenantCode, String exptimeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)exptimeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateExptimeModelByCode(tenantCode, exptimeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateExptime(WlExptimeDomain wlExptimeDomain) throws ApiException {
        String msg = this.checkExptime(wlExptimeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateExptime.checkExptime", msg);
        }
        WlExptime oldWlExptime = this.getExptimeModelById(wlExptimeDomain.getExptimeId());
        if (null == oldWlExptime) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateExptime.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlExptime wlExptime = this.makeExptime(wlExptimeDomain, oldWlExptime);
        this.setExptimeUpdataDefault(wlExptime);
        this.updateExptimeModel(wlExptime);
    }

    @Override
    public WlExptime getExptime(Integer exptimeId) {
        if (null == exptimeId) {
            return null;
        }
        return this.getExptimeModelById(exptimeId);
    }

    @Override
    public void deleteExptime(Integer exptimeId) throws ApiException {
        if (null == exptimeId) {
            return;
        }
        this.deleteExptimeModel(exptimeId);
    }

    @Override
    public QueryResult<WlExptime> queryExptimePage(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        List<WlExptime> wlExptimeList = this.queryExptimeModelPage(map);
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countExptime(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlExptimeList);
        return queryResult;
    }

    @Override
    public WlExptime getExptimeByCode(String tenantCode, String exptimeCode) throws ApiException {
        if (StringUtils.isBlank((String)exptimeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exptimeCode", exptimeCode);
        return this.getExptimeModelByCode(map);
    }

    @Override
    public void deleteExptimeByCode(String tenantCode, String exptimeCode) throws ApiException {
        if (StringUtils.isBlank((String)exptimeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exptimeCode", exptimeCode);
        this.delExptimeModelByCode(map);
    }

    @Override
    public List<WlExptime> getExpTimes(Map<String, Object> map) {
        String channelCode = map.get("channelCode") != null ? (String)map.get("channelCode") : null;
        String goodsClass = map.get("goodsClass") != null ? (String)map.get("goodsClass") : null;
        String memberMcode = map.get("memberMcode") != null ? (String)map.get("memberMcode") : null;
        String memberCode = map.get("memberCode") != null ? (String)map.get("memberCode") : null;
        List<Object> wlExptimeList = new ArrayList();
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)channelCode)) {
            param.put("tenantCode", (String)map.get("tenantCode"));
            param.put("channelCode", channelCode);
            wlExptimeList = this.wlExptimeMapper.getExpTimes(param);
        }
        if (ListUtil.isEmpty(wlExptimeList) && StringUtils.isNotBlank((String)goodsClass)) {
            param.put("tenantCode", (String)map.get("tenantCode"));
            param.put("goodsClass", goodsClass);
            wlExptimeList = this.wlExptimeMapper.getExpTimes(param);
        }
        if (ListUtil.isEmpty(wlExptimeList) && StringUtils.isNotBlank((String)memberMcode)) {
            param.put("tenantCode", (String)map.get("tenantCode"));
            param.put("memberMcode", memberMcode);
            wlExptimeList = this.wlExptimeMapper.getExpTimes(param);
        }
        if (ListUtil.isEmpty(wlExptimeList) && StringUtils.isNotBlank((String)memberCode)) {
            param.put("tenantCode", (String)map.get("tenantCode"));
            param.put("memberCode", memberCode);
            wlExptimeList = this.wlExptimeMapper.getExpTimes(param);
        }
        this.logger.error("param----" + param);
        return wlExptimeList;
    }

    @Override
    public void updateExptimeTime(String tenantCode, String exptimeTime) throws ApiException {
        if (StringUtils.isBlank((String)exptimeTime) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exptimeTime", exptimeTime);
        int i = 0;
        try {
            i = this.wlExptimeMapper.updateExptimeTime(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateExptimeTime.ex", (Throwable)e);
        }
        if (0 == i) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.updateExptimeTime.num");
        }
    }

    @Override
    public void deleteExptimeByMemeberCode(String memberCode) throws ApiException {
        if (StringUtils.isBlank((String)memberCode)) {
            return;
        }
        int i = 0;
        try {
            i = this.wlExptimeMapper.deleteExptimeByMemeberCode(memberCode);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlExptimeServiceImpl.deleteExptimeByMemeberCode.ex", (Throwable)e);
        }
    }
}

