/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.dao.WlFreightExptagMapper;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExptagDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExptagReDomain;
import com.yqbsoft.laser.service.logistics.model.WlFreightExptag;
import com.yqbsoft.laser.service.logistics.service.WlFreightExptagService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WlFreightExptagServiceImpl
extends BaseServiceImpl
implements WlFreightExptagService {
    private static final String SYS_CODE = "wl.LOGISTICS.WlFreightExptagMapperServiceImpl";
    private WlFreightExptagMapper wlFreightExptagMapper;

    public void setWlFreightExptagMapper(WlFreightExptagMapper wlFreightExptagMapper) {
        this.wlFreightExptagMapper = wlFreightExptagMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlFreightExptagMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFreightExptag(WlFreightExptagDomain wlFreightExptagDomain) {
        if (null == wlFreightExptagDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlFreightExptagDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFreightExptagDefault(WlFreightExptag wlFreightExptag) {
        if (null == wlFreightExptag) {
            return;
        }
        if (null == wlFreightExptag.getDataState()) {
            wlFreightExptag.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == wlFreightExptag.getGmtCreate()) {
            wlFreightExptag.setGmtCreate(date);
        }
        wlFreightExptag.setGmtModified(date);
        if (StringUtils.isBlank((String)wlFreightExptag.getFreightExptagCode())) {
            wlFreightExptag.setFreightExptagCode(this.getNo(null, "WlFreightExptag", "wlFreightExptag", wlFreightExptag.getTenantCode()));
        }
    }

    private int getFreightExptagMaxCode() {
        int code = 0;
        try {
            return this.wlFreightExptagMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.getFreightExptagMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFreightExptagUpdataDefault(WlFreightExptag wlFreightExptag) {
        if (null == wlFreightExptag) {
            return;
        }
        wlFreightExptag.setGmtModified(this.getSysDate());
    }

    private void saveFreightExptagModel(WlFreightExptag wlFreightExptag) throws ApiException {
        if (null == wlFreightExptag) {
            return;
        }
        try {
            this.wlFreightExptagMapper.insert(wlFreightExptag);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.saveFreightExptagModel.ex", (Throwable)e);
        }
    }

    private void saveFreightExptagBatchModel(List<WlFreightExptag> wlFreightExptagList) throws ApiException {
        if (null == wlFreightExptagList || wlFreightExptagList.isEmpty()) {
            return;
        }
        try {
            this.wlFreightExptagMapper.insertBatch(wlFreightExptagList);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.saveFreightExptagBatchModel.ex", (Throwable)e);
        }
    }

    private WlFreightExptag getFreightExptagModelById(Integer freightExptagId) {
        if (null == freightExptagId) {
            return null;
        }
        try {
            return this.wlFreightExptagMapper.selectByPrimaryKey(freightExptagId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.getFreightExptagModelById", (Throwable)e);
            return null;
        }
    }

    private WlFreightExptag getFreightExptagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlFreightExptagMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.getFreightExptagModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delFreightExptagModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExptagMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.delFreightExptagModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.delFreightExptagModelByCode.num");
        }
    }

    private void deleteFreightExptagModel(Integer freightExptagId) throws ApiException {
        if (null == freightExptagId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExptagMapper.deleteByPrimaryKey(freightExptagId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.deleteFreightExptagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.deleteFreightExptagModel.num");
        }
    }

    private void updateFreightExptagModel(WlFreightExptag wlFreightExptag) throws ApiException {
        if (null == wlFreightExptag) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExptagMapper.updateByPrimaryKey(wlFreightExptag);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.updateFreightExptagModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.updateFreightExptagModel.num");
        }
    }

    private void updateStateFreightExptagModel(Integer freightExptagId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == freightExptagId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightExptagId", freightExptagId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlFreightExptagMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.updateStateFreightExptagModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.updateStateFreightExptagModel.null");
        }
    }

    private void updateStateFreightExptagModelByCode(String tenantCode, String freightExptagCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)freightExptagCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("freightExptagCode", freightExptagCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlFreightExptagMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.updateStateFreightExptagModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.updateStateFreightExptagModelByCode.null");
        }
    }

    private WlFreightExptag makeFreightExptag(WlFreightExptagDomain wlFreightExptagDomain, WlFreightExptag wlFreightExptag) {
        if (null == wlFreightExptagDomain) {
            return null;
        }
        if (null == wlFreightExptag) {
            wlFreightExptag = new WlFreightExptag();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExptag, (Object)wlFreightExptagDomain);
            return wlFreightExptag;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.makeFreightExptag", (Throwable)e);
            return null;
        }
    }

    private WlFreightExptagReDomain makeWlFreightExptagReDomain(WlFreightExptag wlFreightExptag) {
        if (null == wlFreightExptag) {
            return null;
        }
        WlFreightExptagReDomain wlFreightExptagReDomain = new WlFreightExptagReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExptagReDomain, (Object)wlFreightExptag);
            return wlFreightExptagReDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.makeWlFreightExptagReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightExptag> queryFreightExptagModelPage(Map<String, Object> parammap) {
        try {
            return this.wlFreightExptagMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.queryFreightExptagModel", (Throwable)e);
            return null;
        }
    }

    private int countFreightExptag(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlFreightExptagMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.countFreightExptag", (Throwable)e);
        }
        return i;
    }

    private WlFreightExptag createWlFreightExptag(WlFreightExptagDomain wlFreightExptagDomain) {
        String msg = this.checkFreightExptag(wlFreightExptagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.saveFreightExptag.checkFreightExptag", msg);
        }
        WlFreightExptag wlFreightExptag = this.makeFreightExptag(wlFreightExptagDomain, null);
        this.setFreightExptagDefault(wlFreightExptag);
        return wlFreightExptag;
    }

    @Override
    public String saveFreightExptag(WlFreightExptagDomain wlFreightExptagDomain) throws ApiException {
        WlFreightExptag wlFreightExptag = this.createWlFreightExptag(wlFreightExptagDomain);
        this.saveFreightExptagModel(wlFreightExptag);
        return wlFreightExptag.getFreightExptagCode();
    }

    @Override
    public String saveFreightExptagBatch(List<WlFreightExptagDomain> wlFreightExptagDomainList) throws ApiException {
        if (null == wlFreightExptagDomainList || wlFreightExptagDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WlFreightExptag> wlFreightExptagList = new ArrayList<WlFreightExptag>();
        String code = "";
        for (WlFreightExptagDomain wlFreightExptagDomain : wlFreightExptagDomainList) {
            WlFreightExptag wlFreightExptag = this.createWlFreightExptag(wlFreightExptagDomain);
            code = wlFreightExptag.getFreightExptagCode();
            wlFreightExptagList.add(wlFreightExptag);
        }
        this.saveFreightExptagBatchModel(wlFreightExptagList);
        return code;
    }

    @Override
    public void updateFreightExptagState(Integer freightExptagId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == freightExptagId) {
            return;
        }
        this.updateStateFreightExptagModel(freightExptagId, dataState, oldDataState, map);
    }

    @Override
    public void updateFreightExptagStateByCode(String tenantCode, String freightExptagCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)freightExptagCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateFreightExptagModelByCode(tenantCode, freightExptagCode, dataState, oldDataState, map);
    }

    @Override
    public void updateFreightExptag(WlFreightExptagDomain wlFreightExptagDomain) throws ApiException {
        String msg = this.checkFreightExptag(wlFreightExptagDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.updateFreightExptag.checkFreightExptag", msg);
        }
        WlFreightExptag oldWlFreightExptag = this.getFreightExptagModelById(wlFreightExptagDomain.getFreightExptagId());
        if (null == oldWlFreightExptag) {
            throw new ApiException("wl.LOGISTICS.WlFreightExptagMapperServiceImpl.updateFreightExptag.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightExptag wlFreightExptag = this.makeFreightExptag(wlFreightExptagDomain, oldWlFreightExptag);
        this.setFreightExptagUpdataDefault(wlFreightExptag);
        this.updateFreightExptagModel(wlFreightExptag);
    }

    @Override
    public WlFreightExptag getFreightExptag(Integer freightExptagId) {
        if (null == freightExptagId) {
            return null;
        }
        return this.getFreightExptagModelById(freightExptagId);
    }

    @Override
    public void deleteFreightExptag(Integer freightExptagId) throws ApiException {
        if (null == freightExptagId) {
            return;
        }
        this.deleteFreightExptagModel(freightExptagId);
    }

    @Override
    public QueryResult<WlFreightExptag> queryFreightExptagPage(Map<String, Object> map) {
        List<WlFreightExptag> wlFreightExptagList = this.queryFreightExptagModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFreightExptag(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlFreightExptagList);
        return queryResult;
    }

    @Override
    public WlFreightExptag getFreightExptagByCode(String tenantCode, String freightExptagCode) throws ApiException {
        if (StringUtils.isBlank((String)freightExptagCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("freightExptagCode", freightExptagCode);
        return this.getFreightExptagModelByCode(map);
    }

    @Override
    public void deleteFreightExptagByCode(String tenantCode, String freightExptagCode) throws ApiException {
        if (StringUtils.isBlank((String)freightExptagCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("freightExptagCode", freightExptagCode);
        this.delFreightExptagModelByCode(map);
    }
}

