/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.dao.WlTraceMapper;
import com.yqbsoft.laser.service.logistics.domain.WlTraceDomain;
import com.yqbsoft.laser.service.logistics.model.WlTrace;
import com.yqbsoft.laser.service.logistics.service.WlThirdService;
import com.yqbsoft.laser.service.logistics.service.WlTraceService;
import com.yqbsoft.laser.service.logistics.service.impl.TracePollThread;
import com.yqbsoft.laser.service.logistics.service.impl.TraceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class WlTraceServiceImpl
extends BaseServiceImpl
implements WlTraceService {
    public static final String SYS_CODE = "wl.LOGISTICS.WlTraceServiceImpl";
    private WlTraceMapper wlTraceMapper;
    private static Object lock = new Object();
    private static TraceService traceService;

    public void setWlTraceMapper(WlTraceMapper wlTraceMapper) {
        this.wlTraceMapper = wlTraceMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlTraceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlTraceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTrace(WlTraceDomain wlTraceDomain) {
        if (null == wlTraceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtil.isBlank((String)wlTraceDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a!";
        }
        if (wlTraceDomain.getTracePaytype() == null) {
            msg = msg + "\u90ae\u8d39\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getExpressCode())) {
            msg = msg + "\u5feb\u9012\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getExpressName())) {
            msg = msg + "\u5feb\u9012\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceRName())) {
            msg = msg + "\u6536\u4ef6\u4eba\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceRTel()) && StringUtil.isBlank((String)wlTraceDomain.getTraceRMobile())) {
            msg = msg + "\u6536\u4ef6\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceRProvincecode())) {
            msg = msg + "\u6536\u4ef6\u7701\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceRCitycode())) {
            msg = msg + "\u6536\u4ef6\u5e02\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceRAddress())) {
            msg = msg + "\u6536\u4ef6\u4eba\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceSName())) {
            msg = msg + "\u53d1\u4ef6\u4eba\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceSTel()) && StringUtil.isBlank((String)wlTraceDomain.getTraceSMobile())) {
            msg = msg + "\u53d1\u4ef6\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceSProvincecode())) {
            msg = msg + "\u53d1\u4ef6\u7701\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceSCitycode())) {
            msg = msg + "\u53d1\u4ef6\u5e02\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceSAddress())) {
            msg = msg + "\u53d1\u4ef6\u4eba\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a!";
        }
        if (StringUtil.isBlank((String)wlTraceDomain.getTraceGoods())) {
            msg = msg + "\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a!";
        }
        return msg;
    }

    private void setTraceDefault(WlTrace wlTrace) {
        if (null == wlTrace) {
            return;
        }
        if (null == wlTrace.getDataState()) {
            wlTrace.setDataState(0);
        }
        if (null == wlTrace.getGmtCreate()) {
            wlTrace.setGmtCreate(this.getSysDate());
        }
        wlTrace.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlTrace.getTraceCode())) {
            wlTrace.setTraceCode(this.createUUIDString());
        }
    }

    private int getTraceMaxCode() {
        int code = 0;
        try {
            return this.wlTraceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlTraceServiceImpl.getTraceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTraceUpdataDefault(WlTrace wlTrace) {
        if (null == wlTrace) {
            return;
        }
        wlTrace.setGmtModified(this.getSysDate());
    }

    private void saveTraceModel(WlTrace wlTrace) throws ApiException {
        if (null == wlTrace) {
            return;
        }
        try {
            this.wlTraceMapper.insert(wlTrace);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.saveTraceModel.ex", (Throwable)e);
        }
    }

    private WlTrace getTraceModelById(Integer traceId) {
        if (null == traceId) {
            return null;
        }
        try {
            return this.wlTraceMapper.selectByPrimaryKey(traceId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlTraceServiceImpl.getTraceModelById", (Throwable)e);
            return null;
        }
    }

    public WlTrace getTraceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlTraceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlTraceServiceImpl.getTraceModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delTraceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlTraceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.delTraceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.delTraceModelByCode.num");
        }
    }

    private void deleteTraceModel(Integer traceId) throws ApiException {
        if (null == traceId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlTraceMapper.deleteByPrimaryKey(traceId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.deleteTraceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.deleteTraceModel.num");
        }
    }

    private void updateTraceModel(WlTrace wlTrace) throws ApiException {
        if (null == wlTrace) {
            return;
        }
        try {
            this.wlTraceMapper.updateByPrimaryKeySelective(wlTrace);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.updateTraceModel.ex", (Throwable)e);
        }
    }

    private void updateStateTraceModel(Integer traceId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == traceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("traceId", traceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlTraceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.updateStateTraceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.updateStateTraceModel.null");
        }
    }

    private Integer updateStateTraceModelById(Integer traceId, Integer oldDataState, Map<String, Object> setMap) throws ApiException {
        if (null == traceId || null == oldDataState || setMap == null || setMap.isEmpty()) {
            return -1;
        }
        setMap.put("traceId", traceId);
        setMap.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlTraceMapper.updateStateByPrimaryKey(setMap);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.updateStateTraceModelById.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.updateStateTraceModelById.null");
        }
        return i;
    }

    private WlTrace makeTrace(WlTraceDomain wlTraceDomain, WlTrace wlTrace) {
        if (null == wlTraceDomain) {
            return null;
        }
        if (null == wlTrace) {
            wlTrace = new WlTrace();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlTrace, (Object)wlTraceDomain);
            return wlTrace;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlTraceServiceImpl.makeTrace", (Throwable)e);
            return null;
        }
    }

    private List<WlTrace> queryTraceModelPage(Map<String, Object> parammap) {
        try {
            return this.wlTraceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlTraceServiceImpl.queryTraceModel", (Throwable)e);
            return null;
        }
    }

    private int countTrace(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlTraceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlTraceServiceImpl.countTrace", (Throwable)e);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceService getTraceService() {
        Object object = lock;
        synchronized (object) {
            if (null == traceService) {
                traceService = new TraceService((WlThirdService)SpringApplicationContextUtil.getBean((String)"wlThirdService"));
                for (int i = 0; i < 5; ++i) {
                    traceService.addPollPool(new TracePollThread(traceService));
                }
            }
            return traceService;
        }
    }

    @Override
    public void saveTrace(WlTraceDomain wlTraceDomain) throws ApiException {
        String msg = this.checkTrace(wlTraceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.saveTrace.checkTrace", msg);
        }
        WlTrace wlTrace = this.makeTrace(wlTraceDomain, null);
        this.setTraceDefault(wlTrace);
        this.saveTraceModel(wlTrace);
        this.getTraceService().putQueue(wlTrace);
    }

    @Override
    public void updateTraceState(Integer traceId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTraceModel(traceId, dataState, oldDataState);
    }

    @Override
    public void updateTrace(WlTraceDomain wlTraceDomain) throws ApiException {
        String msg = this.checkTrace(wlTraceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.updateTrace.checkTrace", msg);
        }
        WlTrace oldWlTrace = this.getTraceModelById(wlTraceDomain.getTraceId());
        if (null == oldWlTrace) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.updateTrace.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlTrace wlTrace = this.makeTrace(wlTraceDomain, oldWlTrace);
        this.setTraceUpdataDefault(wlTrace);
        this.updateTraceModel(wlTrace);
    }

    @Override
    public WlTrace getTrace(Integer traceId) {
        return this.getTraceModelById(traceId);
    }

    @Override
    public void deleteTrace(Integer traceId) throws ApiException {
        this.deleteTraceModel(traceId);
    }

    @Override
    public QueryResult<WlTrace> queryTracePage(Map<String, Object> map) {
        List<WlTrace> wlTraceList = this.queryTraceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTrace(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlTraceList);
        return queryResult;
    }

    @Override
    public WlTrace getTraceByCode(Map<String, Object> map) {
        return this.getTraceModelByCode(map);
    }

    @Override
    public void delTraceByCode(Map<String, Object> map) throws ApiException {
        this.delTraceModelByCode(map);
    }

    @Override
    public void updateTraceMap(Integer traceId, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateTraceModelById(traceId, oldDataState, map);
    }

    @Override
    public void updateTraceList(List<WlTraceDomain> wlTraceList) throws ApiException {
        if (wlTraceList == null || wlTraceList.isEmpty()) {
            return;
        }
        for (WlTraceDomain wlTraceDomain : wlTraceList) {
            this.updateTraceCallback(wlTraceDomain);
        }
    }

    public void updateTraceCallback(WlTraceDomain wlTraceDomain) throws ApiException {
        if (wlTraceDomain == null) {
            throw new ApiException("wl.LOGISTICS.WlTraceServiceImpl.updateTrace.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String expressCode = wlTraceDomain.getExpressCode();
        String traceBillno = wlTraceDomain.getTraceBillno();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("expressCode", expressCode);
        map.put("traceBillno", traceBillno);
        WlTrace wlTrace = this.getTraceByCode(map);
        if (null == wlTrace) {
            this.logger.error("wl.LOGISTICS.WlTraceServiceImpl.updateTrace.null", (Object)("\u3010expressCode\u3011\uff1a" + expressCode + ",\u3010traceBillno\u3011:" + traceBillno + "-->\u6570\u636e\u4e0d\u5b58\u5728"));
            return;
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)wlTrace, (Object)wlTraceDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTraceUpdataDefault(wlTrace);
        this.updateTraceModel(wlTrace);
        map.clear();
    }
}

