/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.nm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.nm.NmUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.nm.dao.NmNoMapper;
import com.yqbsoft.laser.service.nm.domain.NmNoDomain;
import com.yqbsoft.laser.service.nm.model.NmNo;
import com.yqbsoft.laser.service.nm.send.SendPollThread;
import com.yqbsoft.laser.service.nm.send.SendPutThread;
import com.yqbsoft.laser.service.nm.send.SendService;
import com.yqbsoft.laser.service.nm.service.NmNoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DoubleUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NmNoServiceImpl
extends BaseServiceImpl
implements NmNoService {
    public static final String SYS_CODE = "NO.NmNoServiceImpl";
    public static final int DEFAULT_CACHE_NUM = 100;
    private NmNoMapper nmNoMapper;
    private static SendService sendService;
    private static Object lock;
    String cacheKey = "NmNo";

    public void setNmNoMapper(NmNoMapper nmNoMapper) {
        this.nmNoMapper = nmNoMapper;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("NO.NmNoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkNo(NmNoDomain nmNoDomain) {
        if (null == nmNoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)nmNoDomain.getNoColumn())) {
            msg = msg + "NoColumn\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)nmNoDomain.getNoTable())) {
            msg = msg + "NoTable\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)nmNoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setNoDefault(NmNo nmNo) {
        if (null == nmNo) {
            return;
        }
        if (StringUtils.isBlank((String)nmNo.getNoType())) {
            nmNo.setNoType("0");
        }
    }

    private int getNoMaxCode() {
        int code = 0;
        try {
            return this.nmNoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("NO.NmNoServiceImpl.getNoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void saveNoModel(NmNo nmNo) throws ApiException {
        if (null == nmNo) {
            return;
        }
        try {
            this.nmNoMapper.insert(nmNo);
        }
        catch (Exception e) {
            throw new ApiException("NO.NmNoServiceImpl.saveNoModel.ex", (Throwable)e);
        }
    }

    private NmNo getNoModelById(Integer noId) {
        if (null == noId) {
            return null;
        }
        try {
            return this.nmNoMapper.selectByPrimaryKey(noId);
        }
        catch (Exception e) {
            this.logger.error("NO.NmNoServiceImpl.getNoModelById", (Throwable)e);
            return null;
        }
    }

    public NmNo getNoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.nmNoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("NO.NmNoServiceImpl.getNoModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delNoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.nmNoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("NO.NmNoServiceImpl.delNoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("NO.NmNoServiceImpl.delNoModelByCode.num");
        }
    }

    private void deleteNoModel(Integer noId) throws ApiException {
        if (null == noId) {
            return;
        }
        int i = 0;
        try {
            i = this.nmNoMapper.deleteByPrimaryKey(noId);
        }
        catch (Exception e) {
            throw new ApiException("NO.NmNoServiceImpl.deleteNoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("NO.NmNoServiceImpl.deleteNoModel.num");
        }
    }

    private void updateNoModel(NmNo nmNo) throws ApiException {
        if (null == nmNo) {
            return;
        }
        try {
            this.nmNoMapper.updateByPrimaryKeySelective(nmNo);
        }
        catch (Exception e) {
            throw new ApiException("NO.NmNoServiceImpl.updateNoModel.ex", (Throwable)e);
        }
    }

    private void updateStateNoModel(Integer noId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == noId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("noId", noId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.nmNoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("NO.NmNoServiceImpl.updateStateNoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("NO.NmNoServiceImpl.updateStateNoModel.null");
        }
    }

    private NmNo makeNo(NmNoDomain nmNoDomain, NmNo nmNo) {
        if (null == nmNoDomain) {
            return null;
        }
        if (null == nmNo) {
            nmNo = new NmNo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)nmNo, (Object)nmNoDomain);
            return nmNo;
        }
        catch (Exception e) {
            this.logger.error("NO.NmNoServiceImpl.makeNo", (Throwable)e);
            return null;
        }
    }

    private List<NmNo> queryNoModelPage(Map<String, Object> parammap) {
        try {
            return this.nmNoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("NO.NmNoServiceImpl.queryNoModel", (Throwable)e);
            return null;
        }
    }

    private int countNo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.nmNoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("NO.NmNoServiceImpl.countNo", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveNo(NmNoDomain nmNoDomain) throws ApiException {
        String msg = this.checkNo(nmNoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("NO.NmNoServiceImpl.saveNo.checkNo", msg);
        }
        NmNo nmNo = this.makeNo(nmNoDomain, null);
        this.setNoDefault(nmNo);
        this.saveNoModel(nmNo);
    }

    @Override
    public void updateNoState(Integer noId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateNoModel(noId, dataState, oldDataState);
    }

    @Override
    public void updateNo(NmNoDomain nmNoDomain) throws ApiException {
        String msg = this.checkNo(nmNoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("NO.NmNoServiceImpl.updateNo.checkNo", msg);
        }
        NmNo oldNmNo = this.getNoModelById(nmNoDomain.getNoId());
        if (null == oldNmNo) {
            throw new ApiException("NO.NmNoServiceImpl.updateNo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        NmNo nmNo = this.makeNo(nmNoDomain, oldNmNo);
        this.updateNoModel(nmNo);
    }

    @Override
    public NmNo getNo(Integer noId) {
        return this.getNoModelById(noId);
    }

    @Override
    public void deleteNo(Integer noId) throws ApiException {
        this.deleteNoModel(noId);
    }

    @Override
    public QueryResult<NmNo> queryNoPage(Map<String, Object> map) {
        List<NmNo> nmNoList = this.queryNoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countNo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(nmNoList);
        return queryResult;
    }

    @Override
    public NmNo getNoByCode(Map<String, Object> map) {
        return this.getNoModelByCode(map);
    }

    @Override
    public void delNoByCode(Map<String, Object> map) throws ApiException {
        this.delNoModelByCode(map);
    }

    @Override
    public void clearNocacheProcess() {
        this.loadDb();
    }

    private void loadDb() {
        this.logger.error("=============================");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("noCache", "1");
            int startRow = 0;
            boolean flag = true;
            QueryResult<NmNo> result = null;
            do {
                startRow = NmNoServiceImpl.getSendService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", NmNoServiceImpl.getSendService().getPage());
                result = this.queryNoPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    NmNoServiceImpl.getSendService().addPutPool(new SendPutThread(NmNoServiceImpl.getSendService(), result.getRows()));
                    if (result.getRows().size() != NmNoServiceImpl.getSendService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            NmNoServiceImpl.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("NO.NmNoServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((NmNoService)SpringApplicationContextUtil.getBean((String)"nmNoService"));
                for (int i = 0; i < 10; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public void clearNocache(NmNo nmNo) {
        if (null == nmNo) {
            return;
        }
        String type = nmNo.getNoType();
        String tableName = nmNo.getNoTable();
        String columnName = nmNo.getNoColumn();
        String tenantCode = nmNo.getTenantCode();
        String key = tenantCode + type + tableName + columnName;
        DisUtil.del((String)key);
        this.logger.info("NO.NmNoServiceImpl.clearNocache", (Object)key);
    }

    @Override
    public String createMaxBillNumber(String type, String tableName, String columnName, String tenantCode) {
        return this.createNo(type, tableName, columnName, 1, null, tenantCode);
    }

    @Override
    public String createBatchMaxBillNumber(String type, String tableName, String columnName, int num, String tenantCode) {
        ArrayList<String> list = new ArrayList<String>();
        this.createNo(type, tableName, columnName, num, list, tenantCode);
        String s = "";
        for (String string : list) {
            if (!"".equals(s)) {
                s = s + ",";
            }
            s = s + string;
        }
        return s;
    }

    private void updateLock(String type, String tableName, String columnName, String tenantCode) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("noType", type);
            map.put("noTable", tableName);
            map.put("noColum", columnName);
            map.put("tenantCode", tenantCode);
            this.nmNoMapper.updateLock(map);
        }
        catch (Exception e) {
            throw new ApiException("NO.NmNoServiceImpl.updateLock", type + "=" + tableName + "=" + columnName + "=" + tenantCode, (Throwable)e);
        }
    }

    private void updateLockNum(String type, String tableName, String columnName, String tenantCode, String maxNo) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("noType", type);
            map.put("noTable", tableName);
            map.put("noColum", columnName);
            map.put("tenantCode", tenantCode);
            map.put("noMaxnum", maxNo);
            this.nmNoMapper.updateLock(map);
        }
        catch (Exception e) {
            throw new ApiException("NO.NmNoServiceImpl.updateLock", type + "=" + tableName + "=" + columnName + "=" + tenantCode, (Throwable)e);
        }
    }

    private NmNo getModelNo(String type, String tableName, String columnName, String tenantCode) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("noType", type);
            map.put("noTable", tableName);
            map.put("noColum", columnName);
            map.put("tenantCode", tenantCode);
            return this.nmNoMapper.getNo(map);
        }
        catch (Exception e) {
            throw new ApiException("NO.NmNoServiceImpl.getModelNo", type + "=" + tableName + "=" + columnName + "=" + tenantCode, (Throwable)e);
        }
    }

    private String createNo(String type, String tableName, String columnName, int num, List<String> list, String tenantCode) {
        if (StringUtils.isBlank((String)type)) {
            type = "0";
        }
        if (list == null) {
            // empty if block
        }
        if (StringUtils.isBlank((String)tableName)) {
            throw new ApiException("NO.NmNoServiceImpl.createNo", "\u53c2\u6570tableName\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)columnName)) {
            throw new ApiException("NO.NmNoServiceImpl.createNo", "\u53c2\u6570columnName\u4e3a\u7a7a");
        }
        String key = tenantCode + type + tableName + columnName;
        this.updateLock(type, tableName, columnName, tenantCode);
        String no = DisUtil.spop((String)key);
        if (StringUtils.isNotBlank((String)no)) {
            return no;
        }
        NmNo mod = this.getNmNo(type, tableName, columnName, tenantCode);
        String maxBillNum = this.getMaxNo(mod, num, list);
        if (StringUtils.isBlank((String)maxBillNum)) {
            throw new ApiException("NO.NmNoServiceImpl.createNo", "\u8fd4\u56demaxBillNum\u4e3a\u7a7a");
        }
        DisUtil.setMap((String)this.cacheKey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)mod));
        maxBillNum = DisUtil.spop((String)key);
        return maxBillNum;
    }

    private NmNo getNmNo(String type, String tableName, String columnName, String tenantCode) {
        String key = tenantCode + type + tableName + columnName;
        String json = DisUtil.getRemotMap((String)this.cacheKey, (String)key);
        NmNo mod = null;
        if (StringUtils.isNotBlank((String)json)) {
            mod = (NmNo)JsonUtil.buildNormalBinder().getJsonToObject(json, NmNo.class);
        }
        if (null == mod) {
            try {
                NmNo newmod1 = this.getModelNo(type, tableName, columnName, tenantCode);
                if (null != newmod1) {
                    mod = newmod1;
                    DisUtil.setMap((String)this.cacheKey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)newmod1));
                    return mod;
                }
                NmNo newmod = this.getModelNo(type, tableName, columnName, "00000000");
                if (null == newmod) {
                    newmod = new NmNo();
                    String rule = "";
                    rule = "0".equals(type) ? "snowflake" : ("1".equals(type) ? "snowflake" : "snowflake");
                    newmod.setNoRule(rule);
                    newmod.setNoColumn(columnName);
                    newmod.setNoTable(tableName);
                    newmod.setNoType(type);
                }
                newmod.setNoId(null);
                newmod.setTenantCode(tenantCode);
                this.saveNoModel(newmod);
                DisUtil.setMap((String)this.cacheKey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)newmod));
                mod = newmod;
            }
            catch (Exception e) {
                throw new ApiException("NO.NmNoServiceImpl0101", "\u83b7\u53d6\u6700\u5927\u53f7\u7801\u5931\u8d25", "\u63d2\u5165\u5f02\u5e38:" + e.getMessage());
            }
        }
        return mod;
    }

    private String getMaxNo(NmNo mod, int num, List<String> list) {
        String maxBillNum = "";
        String rule = mod.getNoRule();
        String oldrule = mod.getNoRule();
        String oldMaxBillNum = mod.getNoMaxnum();
        if (null == oldMaxBillNum) {
            oldMaxBillNum = "";
        }
        if (StringUtils.isBlank((String)(rule = rule.trim()))) {
            rule = "yymmdd8";
        }
        String oldMaxBillNum1 = "";
        String glideLen = null;
        int len = 0;
        glideLen = rule.substring(rule.length() - 1);
        len = rule.length() - 1;
        if (!DoubleUtil.isNumber((String)glideLen)) {
            len = -1;
        }
        String glideStr = "";
        if (len > 0 || len == -1) {
            if (len > 0) {
                rule = rule.substring(0, len);
            }
            rule = NmUtil.getRelRule((String)mod.getTenantCode(), (String)rule);
            if (len == -1) {
                oldMaxBillNum1 = rule;
            } else if (StringUtils.isNotBlank((String)oldMaxBillNum) && oldMaxBillNum.length() > rule.length()) {
                oldMaxBillNum1 = oldMaxBillNum.substring(0, rule.length());
                glideStr = oldMaxBillNum.substring(rule.length());
            } else {
                oldMaxBillNum1 = rule;
                glideStr = "0";
            }
        } else {
            glideStr = StringUtils.isNotBlank((String)oldMaxBillNum) ? oldMaxBillNum : "0";
            rule = "";
        }
        String key = mod.getTenantCode() + mod.getNoType() + mod.getNoTable() + mod.getNoColumn();
        String maxNo = "";
        if (StringUtils.isBlank((String)mod.getNoCache())) {
            mod.setNoCache("1");
        }
        if (mod.getNoCacheNum() == null) {
            mod.setNoCacheNum(100);
        }
        int cacheNum = mod.getNoCacheNum();
        String[] nos = new String[cacheNum];
        if (!DoubleUtil.isNumber((String)glideLen)) {
            maxBillNum = oldMaxBillNum1;
            String oldrule1 = "";
            if ("1".equals(mod.getNoCache())) {
                for (int i = 1; i < cacheNum + 1; ++i) {
                    nos[i - 1] = oldrule1 = NmUtil.getRelRule((String)mod.getTenantCode(), (String)oldrule);
                    if (list != null) {
                        list.add(oldrule1);
                    }
                    maxNo = oldrule1;
                }
                if (list == null) {
                    DisUtil.sadd((String)key, (String[])nos);
                }
            }
        } else {
            if ("1".equals(mod.getNoCache())) {
                for (int i = 1; i < cacheNum + 1; ++i) {
                    Long glide = new Long(glideStr) + (long)i;
                    maxBillNum = StringUtils.isNotBlank((String)oldMaxBillNum1) ? (oldMaxBillNum1.equals(rule) ? oldMaxBillNum1 + StringUtils.fillLeft((String)glide.toString(), (char)'0', (int)Integer.valueOf(glideLen)) : (len > 0 ? rule + StringUtils.fillLeft((String)"1", (char)'0', (int)Integer.valueOf(glideLen)) : rule + StringUtils.fillLeft((String)glide.toString(), (char)'0', (int)Integer.valueOf(glideLen)))) : (len > 0 ? rule + StringUtils.fillLeft((String)"1", (char)'0', (int)Integer.valueOf(glideLen)) : rule + StringUtils.fillLeft((String)glide.toString(), (char)'0', (int)Integer.valueOf(glideLen)));
                    nos[i - 1] = maxBillNum;
                    if (list != null) {
                        list.add(maxBillNum);
                    }
                    maxNo = maxBillNum;
                }
                if (list == null) {
                    DisUtil.sadd((String)key, (String[])nos);
                }
            } else {
                for (int i = 1; i < num + 1; ++i) {
                    Long glide = new Long(glideStr) + (long)i;
                    maxBillNum = StringUtils.isNotBlank((String)oldMaxBillNum1) ? (oldMaxBillNum1.equals(rule) ? oldMaxBillNum1 + StringUtils.fillLeft((String)glide.toString(), (char)'0', (int)Integer.valueOf(glideLen)) : rule + StringUtils.fillLeft((String)"1", (char)'0', (int)Integer.valueOf(glideLen))) : StringUtils.fillLeft((String)"1", (char)'0', (int)Integer.valueOf(glideLen));
                    maxNo = maxBillNum;
                    if (list == null) continue;
                    list.add(maxBillNum);
                }
            }
            mod.setNoMaxnum(maxNo);
            this.updateLockNum(mod.getNoType(), mod.getNoTable(), mod.getNoColumn(), mod.getTenantCode(), maxNo);
            DisUtil.setMap((String)this.cacheKey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)mod));
        }
        return maxBillNum;
    }

    @Override
    public void loadNocacheProcess() {
        List<NmNo> list = this.queryNoModelPage(null);
        if (ListUtil.isEmpty(list)) {
            DisUtil.del((String)this.cacheKey);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (NmNo nmNo : list) {
            String key = nmNo.getTenantCode() + nmNo.getNoType() + nmNo.getNoTable() + nmNo.getNoColumn();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)nmNo));
        }
        DisUtil.setMap((String)this.cacheKey, map);
    }

    static {
        lock = new Object();
    }
}

