/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.nm.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnowflakeNo {
    private static final long START_TIMESTAMP = 1609459200L;
    private static final long TIMESTAMP_BIT = 32L;
    private static final long MACHINE_BIT = 10L;
    private static final long SEQUENCE_BIT = 16L;
    private static final long MAX_MACHINE = 512L;
    private static final long MAX_SEQUENCE = 32768L;
    private static final long MACHINE_LEFT = 16L;
    private static final long TIMESTAMP_LEFT = 26L;
    private static long machineId = 1L;
    private static boolean machineInitialized = false;
    private static long sequence = 0L;
    private static long lastTimestamp = -1L;

    public static long nextId() {
        return SnowflakeNo.nextId(SnowflakeNo.getNowSeconds());
    }

    private static synchronized long nextId(long nowSeconds) {
        long currentTimestamp = nowSeconds;
        if (currentTimestamp < lastTimestamp) {
            currentTimestamp = lastTimestamp;
        }
        if (currentTimestamp == lastTimestamp) {
            long nextSequence = sequence + 1L;
            if (nextSequence >= 32768L) {
                return SnowflakeNo.nextId(nowSeconds + 1L);
            }
            sequence = nextSequence;
        } else {
            sequence = 0L;
        }
        lastTimestamp = currentTimestamp;
        long timeDelta = currentTimestamp - 1609459200L;
        return timeDelta << 26 | machineId << 16 | sequence;
    }

    private static long getNowSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMachineId() {
        try {
            if (!machineInitialized) {
                String hostname = InetAddress.getLocalHost().getHostName();
                char[] hostnameChars = hostname.toCharArray();
                int sumOfHostname = 0;
                int length = hostnameChars.length;
                for (int i = 0; i < length; ++i) {
                    sumOfHostname += hostnameChars[i];
                }
                machineId = (long)sumOfHostname % 512L;
                System.out.println("====> Init machineId. hostname[" + hostname + "], machineId[" + machineId + "]");
            }
        }
        catch (UnknownHostException e) {
            System.out.println("====> Init machineId failure");
            e.printStackTrace();
        }
        finally {
            machineInitialized = true;
        }
    }

    public static void setMachineId(long mid) {
        if (mid > 0L) {
            machineId = mid;
        }
    }

    public static void main(String[] args) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            long id = SnowflakeNo.nextId();
            Thread.sleep(1L);
            System.out.println(id);
        }
    }

    static {
        SnowflakeNo.initMachineId();
    }
}

