/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oauthserver.dao.OsOAuthEnvMapper;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthEnvDomain;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthEnv;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthEnvService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OsOAuthEnvServiceImpl
extends BaseServiceImpl
implements OsOAuthEnvService {
    private static final String SYS_CODE = "os.OAUTHSERVER.OsOAuthEnvServiceImpl";
    private OsOAuthEnvMapper osOAuthEnvMapper;

    public void setOsOAuthEnvMapper(OsOAuthEnvMapper osOAuthEnvMapper) {
        this.osOAuthEnvMapper = osOAuthEnvMapper;
    }

    private Date getSysDate() {
        try {
            return this.osOAuthEnvMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOAuthEnv(OsOAuthEnvDomain osOAuthEnvDomain) {
        if (null == osOAuthEnvDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)osOAuthEnvDomain.getOauthEnvMat())) {
            msg = msg + "OauthEnvMat\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)osOAuthEnvDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOAuthEnvDefault(OsOAuthEnv osOAuthEnv) {
        if (null == osOAuthEnv) {
            return;
        }
        if (null == osOAuthEnv.getDataState()) {
            osOAuthEnv.setDataState(0);
        }
        if (null == osOAuthEnv.getGmtCreate()) {
            osOAuthEnv.setGmtCreate(this.getSysDate());
        }
        osOAuthEnv.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)osOAuthEnv.getOauthEnvCode())) {
            osOAuthEnv.setOauthEnvCode(this.createUUIDString());
        }
    }

    private int getOAuthEnvMaxCode() {
        int code = 0;
        try {
            return this.osOAuthEnvMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvServiceImpl.getOAuthEnvMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOAuthEnvUpdataDefault(OsOAuthEnv osOAuthEnv) {
        if (null == osOAuthEnv) {
            return;
        }
        osOAuthEnv.setGmtModified(this.getSysDate());
    }

    private void saveOAuthEnvModel(OsOAuthEnv osOAuthEnv) throws ApiException {
        if (null == osOAuthEnv) {
            return;
        }
        try {
            this.osOAuthEnvMapper.insert(osOAuthEnv);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.saveOAuthEnvModel.ex", (Throwable)e);
        }
    }

    private OsOAuthEnv getOAuthEnvModelById(Integer oauthEnvId) {
        if (null == oauthEnvId) {
            return null;
        }
        try {
            return this.osOAuthEnvMapper.selectByPrimaryKey(oauthEnvId);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvServiceImpl.getOAuthEnvModelById", (Throwable)e);
            return null;
        }
    }

    public OsOAuthEnv getOAuthEnvModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.osOAuthEnvMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvServiceImpl.getOAuthEnvModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delOAuthEnvModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthEnvMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.delOAuthEnvModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.delOAuthEnvModelByCode.num");
        }
    }

    private void deleteOAuthEnvModel(Integer oauthEnvId) throws ApiException {
        if (null == oauthEnvId) {
            return;
        }
        int i = 0;
        try {
            i = this.osOAuthEnvMapper.deleteByPrimaryKey(oauthEnvId);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.deleteOAuthEnvModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.deleteOAuthEnvModel.num");
        }
    }

    private void updateOAuthEnvModel(OsOAuthEnv osOAuthEnv) throws ApiException {
        if (null == osOAuthEnv) {
            return;
        }
        try {
            this.osOAuthEnvMapper.updateByPrimaryKeySelective(osOAuthEnv);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.updateOAuthEnvModel.ex", (Throwable)e);
        }
    }

    private void updateStateOAuthEnvModel(Integer oauthEnvId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == oauthEnvId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("oauthEnvId", oauthEnvId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.osOAuthEnvMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.updateStateOAuthEnvModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.updateStateOAuthEnvModel.null");
        }
    }

    private OsOAuthEnv makeOAuthEnv(OsOAuthEnvDomain osOAuthEnvDomain, OsOAuthEnv osOAuthEnv) {
        if (null == osOAuthEnvDomain) {
            return null;
        }
        if (null == osOAuthEnv) {
            osOAuthEnv = new OsOAuthEnv();
        }
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthEnv, (Object)osOAuthEnvDomain);
            return osOAuthEnv;
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvServiceImpl.makeOAuthEnv", (Throwable)e);
            return null;
        }
    }

    private List<OsOAuthEnv> queryOAuthEnvModelPage(Map<String, Object> parammap) {
        try {
            return this.osOAuthEnvMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvServiceImpl.queryOAuthEnvModel", (Throwable)e);
            return null;
        }
    }

    private int countOAuthEnv(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.osOAuthEnvMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("os.OAUTHSERVER.OsOAuthEnvServiceImpl.countOAuthEnv", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveOAuthEnv(OsOAuthEnvDomain osOAuthEnvDomain) throws ApiException {
        String msg = this.checkOAuthEnv(osOAuthEnvDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.saveOAuthEnv.checkOAuthEnv", msg);
        }
        OsOAuthEnv osOAuthEnv = this.makeOAuthEnv(osOAuthEnvDomain, null);
        this.setOAuthEnvDefault(osOAuthEnv);
        this.saveOAuthEnvModel(osOAuthEnv);
        return osOAuthEnv.getOauthEnvCode();
    }

    @Override
    public void updateOAuthEnvState(Integer oauthEnvId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateOAuthEnvModel(oauthEnvId, dataState, oldDataState);
    }

    @Override
    public void updateOAuthEnv(OsOAuthEnvDomain osOAuthEnvDomain) throws ApiException {
        String msg = this.checkOAuthEnv(osOAuthEnvDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.updateOAuthEnv.checkOAuthEnv", msg);
        }
        OsOAuthEnv oldOsOAuthEnv = this.getOAuthEnvModelById(osOAuthEnvDomain.getOauthEnvId());
        if (null == oldOsOAuthEnv) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthEnvServiceImpl.updateOAuthEnv.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OsOAuthEnv osOAuthEnv = this.makeOAuthEnv(osOAuthEnvDomain, oldOsOAuthEnv);
        this.setOAuthEnvUpdataDefault(osOAuthEnv);
        this.updateOAuthEnvModel(osOAuthEnv);
    }

    @Override
    public OsOAuthEnv getOAuthEnv(Integer oauthEnvId) {
        return this.getOAuthEnvModelById(oauthEnvId);
    }

    @Override
    public void deleteOAuthEnv(Integer oauthEnvId) throws ApiException {
        this.deleteOAuthEnvModel(oauthEnvId);
    }

    @Override
    public QueryResult<OsOAuthEnv> queryOAuthEnvPage(Map<String, Object> map) {
        List<OsOAuthEnv> osOAuthEnvList = this.queryOAuthEnvModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOAuthEnv(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(osOAuthEnvList);
        return queryResult;
    }

    @Override
    public OsOAuthEnv getOAuthEnvByCode(Map<String, Object> map) {
        return this.getOAuthEnvModelByCode(map);
    }

    @Override
    public void delOAuthEnvByCode(Map<String, Object> map) throws ApiException {
        this.delOAuthEnvModelByCode(map);
    }

    @Override
    public void queryLoadCache() {
        this.logger.info("OsOAuthEnv.queryLoadCache", (Object)"===========start==============");
        ConcurrentHashMap<String, Object> param = new ConcurrentHashMap<String, Object>();
        param.put("order", "true");
        param.put("orderStr", " OAUTH_ENV_ID desc ");
        List<OsOAuthEnv> list = this.queryOAuthEnvModelPage(param);
        String cachekey = "OsOAuthEnv-oauthEnvMat";
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)cachekey);
            this.logger.info("OsOAuthEnv.queryLoadCache", (Object)"===========del-end==========");
            return;
        }
        DisUtil.setVer((String)cachekey, (String)JsonUtil.buildNormalBinder().toJson(list));
        this.logger.info("OsOAuthEnv.queryLoadCache", (Object)"===========add-end==========");
    }
}

