/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tool.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PhoneFormatCheckUtils {
    public static boolean isPhoneLegal(String str) throws PatternSyntaxException {
        return PhoneFormatCheckUtils.isChinaPhoneLegal(str) || PhoneFormatCheckUtils.isHKPhoneLegal(str);
    }

    public static boolean isChinaPhoneLegal(String str) throws PatternSyntaxException {
        String regExp = "^((13[0-9])|(15[^4])|(18[0-9])|(17[0-8])|(14[5,7,9])|(19[5,8,9])|(166))\\d{8}$";
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isHKPhoneLegal(String str) throws PatternSyntaxException {
        String regExp = "^(5|6|8|9)\\d{7}$";
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static void main(String[] args) {
        String[] arr = new String[]{"133", "149", "153", "173", "177", "180", "181", "189", "199", "130", "131", "132", "145", "155", "156", "166", "171", "175", "176", "185", "186", "134", "135", "136", "137", "138", "139", "147", "150", "151", "152", "157", "158", "159", "178", "182", "183", "184", "187", "188", "198", "195"};
        for (int i = 0; i < arr.length; ++i) {
            String s = arr[i];
            String phone = s + "21687677";
            if (PhoneFormatCheckUtils.isPhoneLegal(phone)) continue;
            System.out.println(s);
        }
    }
}

