/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.organize.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.organize.dao.OrgPositionMapper;
import com.yqbsoft.laser.service.organize.domain.OrgPositionDomain;
import com.yqbsoft.laser.service.organize.domain.OrgPositionReDomain;
import com.yqbsoft.laser.service.organize.model.OrgCompany;
import com.yqbsoft.laser.service.organize.model.OrgPosition;
import com.yqbsoft.laser.service.organize.service.OrgPositionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrgPositionServiceImpl
extends BaseServiceImpl
implements OrgPositionService {
    private static final String SYS_CODE = "org.OrgPositionServiceImpl";
    private OrgPositionMapper orgPositionMapper;

    public void setOrgPositionMapper(OrgPositionMapper orgPositionMapper) {
        this.orgPositionMapper = orgPositionMapper;
    }

    private Date getSysDate() {
        try {
            return this.orgPositionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("org.OrgPositionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPosition(OrgPositionDomain orgPositionDomain) {
        if (null == orgPositionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgPositionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPositionDefault(OrgPosition orgPosition) {
        if (null == orgPosition) {
            return;
        }
        if (null == orgPosition.getDataState()) {
            orgPosition.setDataState(0);
        }
        if (null == orgPosition.getGmtCreate()) {
            orgPosition.setGmtCreate(this.getSysDate());
        }
        orgPosition.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)orgPosition.getPositionCode())) {
            orgPosition.setPositionCode(this.createUUIDString());
        }
    }

    private int getPositionMaxCode() {
        int code = 0;
        try {
            return this.orgPositionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgPositionServiceImpl.getPositionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPositionUpdataDefault(OrgPosition orgPosition) {
        if (null == orgPosition) {
            return;
        }
        orgPosition.setGmtModified(this.getSysDate());
    }

    private void savePositionModel(OrgPosition orgPosition) throws ApiException {
        if (null == orgPosition) {
            return;
        }
        try {
            this.orgPositionMapper.insert(orgPosition);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgPositionServiceImpl.savePositionModel.ex", (Throwable)e);
        }
    }

    private void savePositionBatchModel(List<OrgPosition> orgPositionList) throws ApiException {
        if (null == orgPositionList || orgPositionList.isEmpty()) {
            return;
        }
        try {
            this.orgPositionMapper.insertBatch(orgPositionList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgPositionServiceImpl.savePositionBatchModel.ex", (Throwable)e);
        }
    }

    private OrgPosition getPositionModelById(Integer positionId) {
        if (null == positionId) {
            return null;
        }
        try {
            return this.orgPositionMapper.selectByPrimaryKey(positionId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgPositionServiceImpl.getPositionModelById", (Throwable)e);
            return null;
        }
    }

    private OrgPosition getPositionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgPositionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgPositionServiceImpl.getPositionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPositionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgPositionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgPositionServiceImpl.delPositionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgPositionServiceImpl.delPositionModelByCode.num");
        }
    }

    private void deletePositionModel(Integer positionId) throws ApiException {
        if (null == positionId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgPositionMapper.deleteByPrimaryKey(positionId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgPositionServiceImpl.deletePositionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgPositionServiceImpl.deletePositionModel.num");
        }
    }

    private void updatePositionModel(OrgPosition orgPosition) throws ApiException {
        if (null == orgPosition) {
            return;
        }
        int i = 0;
        try {
            i = this.orgPositionMapper.updateByPrimaryKeySelective(orgPosition);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgPositionServiceImpl.updatePositionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgPositionServiceImpl.updatePositionModel.num");
        }
    }

    private void updateStatePositionModel(Integer positionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == positionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("positionId", positionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgPositionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgPositionServiceImpl.updateStatePositionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgPositionServiceImpl.updateStatePositionModel.null");
        }
    }

    private void updateStatePositionModelByCode(String tenantCode, String positionCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)positionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("positionCode", positionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgPositionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgPositionServiceImpl.updateStatePositionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgPositionServiceImpl.updateStatePositionModelByCode.null");
        }
    }

    private OrgPosition makePosition(OrgPositionDomain orgPositionDomain, OrgPosition orgPosition) {
        if (null == orgPositionDomain) {
            return null;
        }
        if (null == orgPosition) {
            orgPosition = new OrgPosition();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgPosition, (Object)orgPositionDomain);
            return orgPosition;
        }
        catch (Exception e) {
            this.logger.error("org.OrgPositionServiceImpl.makePosition", (Throwable)e);
            return null;
        }
    }

    private OrgPositionReDomain makeOrgPositionReDomain(OrgPosition orgPosition) {
        if (null == orgPosition) {
            return null;
        }
        OrgPositionReDomain orgPositionReDomain = new OrgPositionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgPositionReDomain, (Object)orgPosition);
            return orgPositionReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgPositionServiceImpl.makeOrgPositionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgPosition> queryPositionModelPage(Map<String, Object> parammap) {
        try {
            return this.orgPositionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgPositionServiceImpl.queryPositionModel", (Throwable)e);
            return null;
        }
    }

    private int countPosition(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgPositionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgPositionServiceImpl.countPosition", (Throwable)e);
        }
        return i;
    }

    private OrgPosition createOrgPosition(OrgPositionDomain orgPositionDomain) {
        String msg = this.checkPosition(orgPositionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgPositionServiceImpl.savePosition.checkPosition", msg);
        }
        OrgPosition orgPosition = this.makePosition(orgPositionDomain, null);
        this.setPositionDefault(orgPosition);
        return orgPosition;
    }

    @Override
    public String savePosition(OrgPositionDomain orgPositionDomain) throws ApiException {
        OrgPosition orgPosition = this.createOrgPosition(orgPositionDomain);
        this.savePositionModel(orgPosition);
        return orgPosition.getPositionCode();
    }

    @Override
    public String savePositionBatch(List<OrgPositionDomain> orgPositionDomainList) throws ApiException {
        if (null == orgPositionDomainList || orgPositionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgPosition> orgPositionList = new ArrayList<OrgPosition>();
        String code = "";
        for (OrgPositionDomain orgPositionDomain : orgPositionDomainList) {
            OrgPosition orgPosition = this.createOrgPosition(orgPositionDomain);
            code = orgPosition.getPositionCode();
            orgPositionList.add(orgPosition);
        }
        this.savePositionBatchModel(orgPositionList);
        return code;
    }

    @Override
    public void updatePositionState(Integer positionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePositionModel(positionId, dataState, oldDataState);
    }

    @Override
    public void updatePositionStateByCode(String tenantCode, String positionCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePositionModelByCode(tenantCode, positionCode, dataState, oldDataState);
    }

    @Override
    public void updatePosition(OrgPositionDomain orgPositionDomain) throws ApiException {
        String msg = this.checkPosition(orgPositionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgPositionServiceImpl.updatePosition.checkPosition", msg);
        }
        OrgPosition oldOrgPosition = this.getPositionModelById(orgPositionDomain.getPositionId());
        if (null == oldOrgPosition) {
            throw new ApiException("org.OrgPositionServiceImpl.updatePosition.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgPosition orgPosition = this.makePosition(orgPositionDomain, oldOrgPosition);
        this.setPositionUpdataDefault(orgPosition);
        this.updatePositionModel(orgPosition);
    }

    @Override
    public OrgPosition getPosition(Integer positionId) {
        return this.getPositionModelById(positionId);
    }

    @Override
    public void deletePosition(Integer positionId) throws ApiException {
        this.deletePositionModel(positionId);
    }

    @Override
    public QueryResult<OrgPosition> queryPositionPage(Map<String, Object> map) {
        List<OrgPosition> orgPositionList = this.queryPositionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPosition(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgPositionList);
        return queryResult;
    }

    @Override
    public OrgPosition getPositionByCode(String tenantCode, String positionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("positionCode", positionCode);
        return this.getPositionModelByCode(map);
    }

    @Override
    public void deletePositionByCode(String tenantCode, String positionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("positionCode", positionCode);
        this.delPositionModelByCode(map);
    }

    @Override
    public void savePositions(List<OrgPositionDomain> goodsList) throws ApiException {
        if (null != goodsList && goodsList.size() > 0) {
            for (OrgPositionDomain imsgImsg : goodsList) {
                this.savePosition(imsgImsg);
            }
        }
    }

    @Override
    public void updatePositions(List<OrgPositionDomain> goodsList) throws ApiException {
        if (null != goodsList && goodsList.size() > 0) {
            for (OrgPositionDomain imsgImsg : goodsList) {
                this.updatePosition(imsgImsg);
            }
        }
    }

    @Override
    public String savePositionyByCompany(String channelCode, String tenantCode, String memberCode, OrgCompany orgCompany) throws ApiException {
        this.logger.error("org.OrgPositionServiceImpl.savePositionyByCompany", (Object)JsonUtil.buildNormalBinder().toJson((Object)orgCompany));
        if (StringUtils.isBlank((String)tenantCode) || null == orgCompany || StringUtils.isBlank((String)orgCompany.getCompanyCode())) {
            this.logger.error("org.OrgPositionServiceImpl.savePositionyByCompany", (Object)JsonUtil.buildNormalBinder().toJson((Object)orgCompany));
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyCode", orgCompany.getCompanyCode());
        map.put("tenantCode", tenantCode);
        List<OrgPosition> orgPositionsList = this.queryPositionModelPage(map);
        if (ListUtil.isNotEmpty(orgPositionsList)) {
            this.logger.error("org.OrgPositionServiceImpl.savePositionyByCompany\u3002orgPositionsList", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return "error";
        }
        HashMap<String, Object> positionMap = new HashMap<String, Object>();
        positionMap.put("companyCode", "defaultConfiguration");
        positionMap.put("tenantCode", tenantCode);
        List<OrgPosition> orgPositions = this.queryPositionModelPage(positionMap);
        if (ListUtil.isEmpty(orgPositions)) {
            positionMap.put("tenantCode", "00000000");
            orgPositions = this.queryPositionModelPage(positionMap);
        }
        if (ListUtil.isEmpty(orgPositions)) {
            this.logger.error("org.OrgPositionServiceImpl.savePositionyByCompany.orgPositions", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return "success";
        }
        ArrayList<OrgPositionDomain> orgPositionList = new ArrayList<OrgPositionDomain>();
        for (OrgPosition orgPosition : orgPositions) {
            OrgPositionDomain orgPositionDomain = new OrgPositionDomain();
            orgPositionDomain.setPositionType(orgPosition.getPositionType());
            orgPositionDomain.setRoleCode(orgPosition.getRoleCode());
            orgPositionDomain.setCompanyCode(orgCompany.getCompanyCode());
            orgPositionDomain.setPositionName(orgPosition.getPositionName());
            orgPositionDomain.setTenantCode(tenantCode);
            orgPositionList.add(orgPositionDomain);
        }
        this.savePositionBatch(orgPositionList);
        return "success";
    }
}

