/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.domain.PeProtClearinfoDomain;
import com.yqbsoft.laser.service.payengine.model.PeClearResp;
import com.yqbsoft.laser.service.payengine.model.PeProtClearinfo;
import com.yqbsoft.laser.service.payengine.service.PeClearOrderService;
import com.yqbsoft.laser.service.payengine.service.PePayClearService;
import com.yqbsoft.laser.service.payengine.service.PePaymentService;
import com.yqbsoft.laser.service.payengine.service.PeProtClearagService;
import com.yqbsoft.laser.service.payengine.service.impl.ClearInfoPollThread;
import com.yqbsoft.laser.service.payengine.service.impl.ClearInfoPutThread;
import com.yqbsoft.laser.service.payengine.service.impl.ClearInfoService;
import com.yqbsoft.laser.service.suppercore.supper.SupperRuestDomain;
import java.util.HashMap;
import java.util.List;

public class PePayClearServiceImpl
extends BaseServiceImpl
implements PePayClearService {
    public static final String SYS_CODE = "pe.PePayClearServiceImpl";
    private PeProtClearagService peProtClearagService;
    private PeClearOrderService peClearOrderService;
    private PePaymentService pePaymentService;
    private static ClearInfoService clearInfoService;
    private static Object lock;

    public void setPePaymentService(PePaymentService pePaymentService) {
        this.pePaymentService = pePaymentService;
    }

    public void setPeProtClearagService(PeProtClearagService peProtClearagService) {
        this.peProtClearagService = peProtClearagService;
    }

    public void setPeClearOrderService(PeClearOrderService peClearOrderService) {
        this.peClearOrderService = peClearOrderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClearInfoService getClearInfoServiceNew() {
        Object object = lock;
        synchronized (object) {
            if (null == clearInfoService) {
                clearInfoService = new ClearInfoService(this.peClearOrderService, this.peProtClearagService, this.pePaymentService);
                for (int i = 0; i < 100; ++i) {
                    clearInfoService.addPollPool(new ClearInfoPollThread(clearInfoService));
                }
            }
            return clearInfoService;
        }
    }

    @Override
    public List<PeProtClearinfo> saveProtClearinfoBatch(List<PeProtClearinfoDomain> peProtClearinfoDomainList) throws ApiException {
        if (null == peProtClearinfoDomainList || peProtClearinfoDomainList.isEmpty()) {
            throw new ApiException("pe.PePayClearServiceImpl.saveProtClearinfoBatch.null", "null");
        }
        List<PeProtClearinfo> peProtClearinfoList = this.peProtClearagService.saveProtClearinfoBatch(peProtClearinfoDomainList);
        if (null == peProtClearinfoList || peProtClearinfoList.isEmpty()) {
            throw new ApiException("pe.PePayClearServiceImpl.saveProtClearinfoBatch.peProtClearinfoList", "null");
        }
        return peProtClearinfoList;
    }

    @Override
    public void sendProtClearinfoBatch(List<PeProtClearinfo> peProtClearinfoList) {
        this.getClearInfoServiceNew().addPutPool(new ClearInfoPutThread(this.getClearInfoServiceNew(), peProtClearinfoList));
    }

    @Override
    public void loadEtc() {
    }

    @Override
    public void loadProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<PeProtClearinfo> result = null;
            boolean flag = true;
            int startRow = 0;
            do {
                startRow = this.getClearInfoServiceNew().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getClearInfoServiceNew().getPage());
                result = this.getClearInfoServiceNew().getPeProtClearagService().queryProtClearinfoPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getClearInfoServiceNew().addPutPool(new ClearInfoPutThread(this.getClearInfoServiceNew(), result.getRows()));
                    if (result.getRows().size() == this.getClearInfoServiceNew().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getClearInfoServiceNew().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("pe.PePayClearServiceImpl.loadDb.e", (Throwable)e);
        }
    }

    @Override
    public void sendClearOrderNext(SupperRuestDomain ruestDomain) {
        long start = System.currentTimeMillis();
        List<PeClearResp> list = this.peClearOrderService.saveClearOrderNext(ruestDomain);
        this.peClearOrderService.sendClearOrderNext(list);
        this.logger.info("======sendClearOrderNext=====time=============", (Object)(System.currentTimeMillis() - start));
    }

    static {
        lock = new Object();
    }
}

