/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.dao.PteBalanceopMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.ChannelRest;
import com.yqbsoft.laser.service.paytradeengine.domain.CmChannelClear;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistOpDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopReDomain;
import com.yqbsoft.laser.service.paytradeengine.model.OcCflowPprocess;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalance;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceop;
import com.yqbsoft.laser.service.paytradeengine.model.PteChannelsend;
import com.yqbsoft.laser.service.paytradeengine.send.SendBalancePollThread;
import com.yqbsoft.laser.service.paytradeengine.send.SendBalanceService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceBaseService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalancelistService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopGoodsService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PteBalanceopServiceImpl
extends BaseServiceImpl
implements PteBalanceopService {
    private static final String SYS_CODE = "pte.PteBalanceopServiceImpl";
    private PteBalanceopMapper pteBalanceopMapper;
    private PteBalancelistService pteBalancelistService;
    private PteBalanceService pteBalanceService;
    private PteBalanceopGoodsService pteBalanceopGoodsService;
    private static SendBalanceService sendService;
    private static Object sendlock;
    private static final DateTimeFormatter DATE_YYYYMMDD_FORMATTER;

    public void setPteBalanceopMapper(PteBalanceopMapper pteBalanceopMapper) {
        this.pteBalanceopMapper = pteBalanceopMapper;
    }

    public void setPteBalancelistService(PteBalancelistService pteBalancelistService) {
        this.pteBalancelistService = pteBalancelistService;
    }

    public void setPteBalanceopGoodsService(PteBalanceopGoodsService pteBalanceopGoodsService) {
        this.pteBalanceopGoodsService = pteBalanceopGoodsService;
    }

    public void setPteBalanceService(PteBalanceService pteBalanceService) {
        this.pteBalanceService = pteBalanceService;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBalanceop(PteBalanceopDomain pteBalanceopDomain) {
        if (null == pteBalanceopDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteBalanceopDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setBalanceopDefault(PteBalanceop pteBalanceop) {
        if (null == pteBalanceop) {
            return;
        }
        if (null == pteBalanceop.getDataState()) {
            pteBalanceop.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pteBalanceop.getGmtCreate()) {
            pteBalanceop.setGmtCreate(date);
        }
        pteBalanceop.setGmtModified(date);
        if (StringUtils.isBlank((String)pteBalanceop.getBalanceopCode())) {
            pteBalanceop.setBalanceopCode(this.getNo(null, "PteBalanceop", "pteBalanceop", pteBalanceop.getTenantCode()));
        }
    }

    private int getBalanceopMaxCode() {
        int code = 0;
        try {
            return this.pteBalanceopMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.getBalanceopMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalanceopUpdataDefault(PteBalanceop pteBalanceop) {
        if (null == pteBalanceop) {
            return;
        }
        pteBalanceop.setGmtModified(this.getSysDate());
    }

    private void saveBalanceopModel(PteBalanceop pteBalanceop) throws ApiException {
        if (null == pteBalanceop) {
            return;
        }
        try {
            this.pteBalanceopMapper.insert(pteBalanceop);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceopServiceImpl.saveBalanceopModel.ex", (Throwable)e);
        }
    }

    private void saveBalanceopBatchModel(List<PteBalanceop> pteBalanceopList) throws ApiException {
        if (null == pteBalanceopList || pteBalanceopList.isEmpty()) {
            return;
        }
        try {
            this.pteBalanceopMapper.insertBatch(pteBalanceopList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceopServiceImpl.saveBalanceopBatchModel.ex", (Throwable)e);
        }
    }

    private PteBalanceop getBalanceopModelById(Integer balanceopId) {
        if (null == balanceopId) {
            return null;
        }
        try {
            return this.pteBalanceopMapper.selectByPrimaryKey(balanceopId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.getBalanceopModelById", (Throwable)e);
            return null;
        }
    }

    private PteBalanceop getBalanceopModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteBalanceopMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.getBalanceopModelByCode", (Throwable)e);
            return null;
        }
    }

    private PteBalanceop queryBalanceopStatisticsData(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteBalanceopMapper.queryStatistics(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.getBalanceopModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBalanceopModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceopMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceopServiceImpl.delBalanceopModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalanceopServiceImpl.delBalanceopModelByCode.num");
        }
    }

    private void deleteBalanceopModel(Integer balanceopId) throws ApiException {
        if (null == balanceopId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceopMapper.deleteByPrimaryKey(balanceopId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceopServiceImpl.deleteBalanceopModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalanceopServiceImpl.deleteBalanceopModel.num");
        }
    }

    private void updateBalanceopModel(PteBalanceop pteBalanceop) throws ApiException {
        if (null == pteBalanceop) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceopMapper.updateByPrimaryKey(pteBalanceop);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceopServiceImpl.updateBalanceopModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalanceopServiceImpl.updateBalanceopModel.num");
        }
    }

    private void updateStateBalanceopModel(Integer balanceopId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == balanceopId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceopId", balanceopId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalanceopMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceopServiceImpl.updateStateBalanceopModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalanceopServiceImpl.updateStateBalanceopModel.null");
        }
    }

    private void updateStateBalanceopModelByCode(String tenantCode, String balanceopCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)balanceopCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balanceopCode", balanceopCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalanceopMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalanceopServiceImpl.updateStateBalanceopModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalanceopServiceImpl.updateStateBalanceopModelByCode.null");
        }
    }

    private PteBalanceop makeBalanceop(PteBalanceopDomain pteBalanceopDomain, PteBalanceop pteBalanceop) {
        if (null == pteBalanceopDomain) {
            return null;
        }
        if (null == pteBalanceop) {
            pteBalanceop = new PteBalanceop();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteBalanceop, (Object)pteBalanceopDomain);
            return pteBalanceop;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.makeBalanceop", (Throwable)e);
            return null;
        }
    }

    private PteBalanceopReDomain makePteBalanceopReDomain(PteBalanceop pteBalanceop) {
        if (null == pteBalanceop) {
            return null;
        }
        PteBalanceopReDomain pteBalanceopReDomain = new PteBalanceopReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalanceopReDomain, (Object)pteBalanceop);
            return pteBalanceopReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.makePteBalanceopReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteBalanceop> queryBalanceopModelPage(Map<String, Object> parammap) {
        try {
            return this.pteBalanceopMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.queryBalanceopModel", (Throwable)e);
            return null;
        }
    }

    private int countBalanceop(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteBalanceopMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.countBalanceop", (Throwable)e);
        }
        return i;
    }

    private PteBalanceop createPteBalanceop(PteBalanceopDomain pteBalanceopDomain) {
        String msg = this.checkBalanceop(pteBalanceopDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalanceopServiceImpl.saveBalanceop.checkBalanceop", msg);
        }
        PteBalanceop pteBalanceop = this.makeBalanceop(pteBalanceopDomain, null);
        this.setBalanceopDefault(pteBalanceop);
        pteBalanceopDomain.setBalanceopCode(pteBalanceop.getBalanceopCode());
        return pteBalanceop;
    }

    @Override
    public String saveBalanceop(PteBalanceopDomain pteBalanceopDomain) throws ApiException {
        PteBalanceop pteBalanceop = this.createPteBalanceop(pteBalanceopDomain);
        this.saveBalanceopModel(pteBalanceop);
        return pteBalanceop.getBalanceopCode();
    }

    @Override
    public String saveBalanceopBatch(List<PteBalanceopDomain> pteBalanceopDomainList) throws ApiException {
        if (null == pteBalanceopDomainList || pteBalanceopDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteBalanceop> pteBalanceopList = new ArrayList<PteBalanceop>();
        String code = "";
        for (PteBalanceopDomain pteBalanceopDomain : pteBalanceopDomainList) {
            PteBalanceop pteBalanceop = this.createPteBalanceop(pteBalanceopDomain);
            code = pteBalanceop.getBalanceopCode();
            pteBalanceopList.add(pteBalanceop);
        }
        this.saveBalanceopBatchModel(pteBalanceopList);
        return code;
    }

    private List<PteBalanceop> makeBalanceopBatch(List<PteBalanceopDomain> pteBalanceopDomainList) throws ApiException {
        if (null == pteBalanceopDomainList || pteBalanceopDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteBalanceop> pteBalanceopList = new ArrayList<PteBalanceop>();
        for (PteBalanceopDomain pteBalanceopDomain : pteBalanceopDomainList) {
            PteBalanceop pteBalanceop = this.createPteBalanceop(pteBalanceopDomain);
            this.saveBalanceopModel(pteBalanceop);
            this.saveBalanceopGoods(pteBalanceopDomain);
            pteBalanceopList.add(pteBalanceop);
        }
        return pteBalanceopList;
    }

    private void saveBalanceopGoods(PteBalanceopDomain pteBalanceopDomain) {
        if (ListUtil.isEmpty(pteBalanceopDomain.getPteBalanceopGoodsDomainList())) {
            return;
        }
        for (PteBalanceopGoodsDomain pteBalanceopGoodsDomain : pteBalanceopDomain.getPteBalanceopGoodsDomainList()) {
            pteBalanceopGoodsDomain.setTenantCode(pteBalanceopDomain.getTenantCode());
        }
        this.pteBalanceopGoodsService.saveBalanceopGoodsBatch(pteBalanceopDomain.getPteBalanceopGoodsDomainList());
    }

    @Override
    public List<PteChannelsend> saveBalanceopToBalancelist(PteBalanceop pteBalanceop, Map<String, Object> map) throws ApiException {
        if (null == pteBalanceop) {
            throw new ApiException("pte.PteBalanceopServiceImpl.sendBalanceopToBalancelist.null");
        }
        if (PteConstants.BalanceopData_State3 == pteBalanceop.getDataState()) {
            return null;
        }
        PteBalancelistDomain pteBalancelistDomain = this.makeBalancelistDomain(null, pteBalanceop);
        this.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), PteConstants.BalanceopData_State3, pteBalanceop.getDataState(), map);
        List<PteChannelsend> pteBalancelist = this.pteBalancelistService.savePteBalanceamtByPteBalancelist(pteBalancelistDomain);
        return pteBalancelist;
    }

    @Override
    public void updateBalanceopStateByBachCode(List<String> balanceopCodeList, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (ListUtil.isEmpty(balanceopCodeList) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        for (String balanceopCode : balanceopCodeList) {
            this.updateStateBalanceopModelByCode(tenantCode, balanceopCode, dataState, oldDataState, map);
        }
    }

    @Override
    public List<PteChannelsend> saveBalanceopToBalancelistBatch(List<String> balanceopCodeList, String tenantCode, Map<String, Object> map) throws ApiException {
        if (ListUtil.isEmpty(balanceopCodeList) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String str = "";
        for (String code : balanceopCodeList) {
            if (StringUtils.isNotBlank((String)str)) {
                str = str + ",";
            }
            str = str + code;
        }
        PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("balanceopCode", str);
        paramMap.put("dataState", String.valueOf(PteConstants.BalanceopData_State2));
        List<PteBalanceop> pteBalanceopList = this.queryBalanceopModelPage(paramMap);
        if (ListUtil.isEmpty(pteBalanceopList)) {
            throw new ApiException("pte.PteBalanceopServiceImpl.saveBalanceopToBalancelistBatch.pteBalanceopList", ((Object)paramMap).toString());
        }
        for (PteBalanceop pteBalanceop : pteBalanceopList) {
            if (PteConstants.BalanceopData_State3 == pteBalanceop.getDataState()) continue;
            pteBalancelistDomain = this.makeBalancelistDomain(pteBalancelistDomain, pteBalanceop);
            this.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), PteConstants.BalanceopData_State3, pteBalanceop.getDataState(), map);
        }
        List<PteChannelsend> pteBalancelist = this.pteBalancelistService.savePteBalanceamtByPteBalancelist(pteBalancelistDomain);
        return pteBalancelist;
    }

    @Override
    public List<PteChannelsend> sendBalanceopToBalancelistRebate(PteBalanceop pteBalanceop, Map<String, Object> map) throws ApiException {
        if (null == pteBalanceop) {
            throw new ApiException("pte.PteBalanceopServiceImpl.sendBalanceopToBalancelistRebate.null");
        }
        PteBalancelistDomain pteBalancelistDomain = this.makeBalancelistDomainRebate(pteBalanceop);
        pteBalancelistDomain.setBalanceTime("0");
        this.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), PteConstants.BalanceopData_State3, PteConstants.BalanceopData_State1, map);
        List<PteChannelsend> pteBalancelist = this.pteBalancelistService.savePteBalanceamtByPteBalancelistRebate(pteBalancelistDomain);
        return pteBalancelist;
    }

    private PteBalancelistDomain makeBalancelistDomain(PteBalancelistDomain pteBalancelistDomain, PteBalanceop pteBalanceop) {
        List<PteBalancelistOpDomain> pteBalancelistOpDomainList;
        if (null == pteBalanceop) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", pteBalanceop.getTenantCode());
        map.put("balanceType", pteBalanceop.getBalanceType());
        QueryResult<PteBalance> pteBalanceQueryResult = this.pteBalanceService.queryBalancePage(map);
        PteBalance pteBalance = null;
        if (null == pteBalanceQueryResult || !ListUtil.isNotEmpty((Collection)pteBalanceQueryResult.getList())) {
            this.logger.error("pte.PteBalanceopServiceImpl.makeBalancelistDomain.queryBalancePage.null", (Object)((Object)map).toString());
            return null;
        }
        pteBalance = (PteBalance)pteBalanceQueryResult.getList().get(0);
        if (null == pteBalancelistDomain) {
            pteBalancelistDomain = new PteBalancelistDomain();
        }
        if (null == (pteBalancelistOpDomainList = pteBalancelistDomain.getPteBalancelistOpDomainList())) {
            pteBalancelistOpDomainList = new ArrayList<PteBalancelistOpDomain>();
            pteBalancelistDomain.setPteBalancelistOpDomainList(pteBalancelistOpDomainList);
        }
        PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
        pteBalancelistOpDomainList.add(pteBalancelistOpDomain);
        BigDecimal orderOamount = null == pteBalancelistDomain.getOrderOamount() ? BigDecimal.ZERO : pteBalancelistDomain.getOrderOamount();
        BigDecimal orderPortion = null == pteBalancelistDomain.getOrderPortion() ? BigDecimal.ZERO : pteBalancelistDomain.getOrderPortion();
        BigDecimal balanceFee5 = null == pteBalancelistDomain.getBalanceFee5() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee5();
        BigDecimal balanceFee4 = null == pteBalancelistDomain.getBalanceFee4() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee4();
        BigDecimal balanceFee3 = null == pteBalancelistDomain.getBalanceFee3() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee3();
        BigDecimal balanceFee1 = null == pteBalancelistDomain.getBalanceFee1() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee1();
        BigDecimal balanceFee2 = null == pteBalancelistDomain.getBalanceFee2() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee2();
        BigDecimal balanceFee = null == pteBalancelistDomain.getBalanceFee() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee();
        BigDecimal balanceAmount5 = null == pteBalancelistDomain.getBalanceAmount5() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount5();
        BigDecimal balanceAmount4 = null == pteBalancelistDomain.getBalanceAmount4() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount4();
        BigDecimal balanceAmount3 = null == pteBalancelistDomain.getBalanceAmount3() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount3();
        BigDecimal balanceAmount2 = null == pteBalancelistDomain.getBalanceAmount2() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount2();
        BigDecimal balanceAmount1 = null == pteBalancelistDomain.getBalanceAmount1() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount1();
        BigDecimal balanceAmount = null == pteBalancelistDomain.getBalanceAmount() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount();
        BigDecimal balanceopFee = null == pteBalancelistDomain.getBalanceopFee() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceopFee();
        BigDecimal balanceopAmount = null == pteBalancelistDomain.getBalanceopAmount() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceopAmount();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalance);
            BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalanceop);
            BeanUtils.copyAllPropertys((Object)pteBalancelistOpDomain, (Object)pteBalancelistDomain);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.makeBalancelistDomain", (Throwable)e);
        }
        pteBalancelistDomain.setOrderOamount((null == pteBalancelistDomain.getOrderOamount() ? BigDecimal.ZERO : pteBalancelistDomain.getOrderOamount()).add(orderOamount));
        pteBalancelistDomain.setOrderPortion((null == pteBalancelistDomain.getOrderPortion() ? BigDecimal.ZERO : pteBalancelistDomain.getOrderPortion()).add(orderPortion));
        pteBalancelistDomain.setBalanceFee5((null == pteBalancelistDomain.getBalanceFee5() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee5()).add(balanceFee5));
        pteBalancelistDomain.setBalanceFee4((null == pteBalancelistDomain.getBalanceFee4() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee4()).add(balanceFee4));
        pteBalancelistDomain.setBalanceFee3((null == pteBalancelistDomain.getBalanceFee3() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee3()).add(balanceFee3));
        pteBalancelistDomain.setBalanceFee1((null == pteBalancelistDomain.getBalanceFee1() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee1()).add(balanceFee1));
        pteBalancelistDomain.setBalanceFee2((null == pteBalancelistDomain.getBalanceFee2() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee2()).add(balanceFee2));
        pteBalancelistDomain.setBalanceFee((null == pteBalancelistDomain.getBalanceFee() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceFee()).add(balanceFee));
        pteBalancelistDomain.setBalanceAmount5((null == pteBalancelistDomain.getBalanceAmount5() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount5()).add(balanceAmount5));
        pteBalancelistDomain.setBalanceAmount4((null == pteBalancelistDomain.getBalanceAmount4() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount4()).add(balanceAmount4));
        pteBalancelistDomain.setBalanceAmount3((null == pteBalancelistDomain.getBalanceAmount3() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount3()).add(balanceAmount3));
        pteBalancelistDomain.setBalanceAmount2((null == pteBalancelistDomain.getBalanceAmount2() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount2()).add(balanceAmount2));
        pteBalancelistDomain.setBalanceAmount1((null == pteBalancelistDomain.getBalanceAmount1() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount1()).add(balanceAmount1));
        pteBalancelistDomain.setBalanceAmount((null == pteBalancelistDomain.getBalanceAmount() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceAmount()).add(balanceAmount));
        pteBalancelistDomain.setBalanceopFee((null == pteBalancelistDomain.getBalanceopFee() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceopFee()).add(balanceopFee));
        pteBalancelistDomain.setBalanceopAmount((null == pteBalancelistDomain.getBalanceopAmount() ? BigDecimal.ZERO : pteBalancelistDomain.getBalanceopAmount()).add(balanceopAmount));
        return pteBalancelistDomain;
    }

    private PteBalancelistDomain makeBalancelistDomainRebate(PteBalanceop pteBalanceop) {
        PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalanceop);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceopServiceImpl.makeBalancelistDomain", (Throwable)e);
        }
        return pteBalancelistDomain;
    }

    @Override
    public void updateBalanceopState(Integer balanceopId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == balanceopId) {
            return;
        }
        this.updateStateBalanceopModel(balanceopId, dataState, oldDataState, map);
    }

    @Override
    public void updateBalanceopStateByCode(String tenantCode, String balanceopCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)balanceopCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateBalanceopModelByCode(tenantCode, balanceopCode, dataState, oldDataState, map);
    }

    @Override
    public void updateBalanceop(PteBalanceopDomain pteBalanceopDomain) throws ApiException {
        String msg = this.checkBalanceop(pteBalanceopDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalanceopServiceImpl.updateBalanceop.checkBalanceop", msg);
        }
        PteBalanceop oldPteBalanceop = this.getBalanceopModelById(pteBalanceopDomain.getBalanceopId());
        if (null == oldPteBalanceop) {
            throw new ApiException("pte.PteBalanceopServiceImpl.updateBalanceop.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteBalanceop pteBalanceop = this.makeBalanceop(pteBalanceopDomain, oldPteBalanceop);
        this.setBalanceopUpdataDefault(pteBalanceop);
        if (null == pteBalanceop.getBalanceopAmount()) {
            pteBalanceop.setBalanceopAmount(BigDecimal.ZERO);
        }
        this.logger.info("=======>", (Object)pteBalanceop.getBalanceopAmount());
        if (ListUtil.isNotEmpty(pteBalanceopDomain.getPteBalanceopGoodsDomainList())) {
            for (PteBalanceopGoodsDomain pteBalanceopGoodsDomain : pteBalanceopDomain.getPteBalanceopGoodsDomainList()) {
                if (null == pteBalanceopGoodsDomain.getContractGoodsMoney()) {
                    pteBalanceopGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
                }
                if (StringUtils.isBlank((Integer)pteBalanceopGoodsDomain.getContractGoodsType())) {
                    pteBalanceopGoodsDomain.setContractGoodsType(0);
                }
                this.logger.info("=====1==>", (Object)pteBalanceopGoodsDomain.getContractGoodsMoney());
                if (0 == pteBalanceopGoodsDomain.getContractGoodsType() || 1 == pteBalanceopGoodsDomain.getContractGoodsType()) {
                    pteBalanceop.setBalanceopAmount(pteBalanceop.getBalanceopAmount().add(pteBalanceopGoodsDomain.getContractGoodsMoney()));
                    continue;
                }
                pteBalanceop.setBalanceopAmount(pteBalanceop.getBalanceopAmount().subtract(pteBalanceopGoodsDomain.getContractGoodsMoney()));
            }
        }
        this.logger.info("====2===>", (Object)pteBalanceop.getBalanceopAmount());
        this.updateBalanceopModel(pteBalanceop);
        if (ListUtil.isNotEmpty(pteBalanceopDomain.getPteBalanceopGoodsDomainList())) {
            for (PteBalanceopGoodsDomain pteBalanceopGoodsDomain : pteBalanceopDomain.getPteBalanceopGoodsDomainList()) {
                if (null == pteBalanceopGoodsDomain.getBalanceopGoodsId()) {
                    this.pteBalanceopGoodsService.saveBalanceopGoods(pteBalanceopGoodsDomain);
                    continue;
                }
                this.pteBalanceopGoodsService.updateBalanceopGoods(pteBalanceopGoodsDomain);
            }
        }
    }

    @Override
    public PteBalanceop getBalanceop(Integer balanceopId) {
        if (null == balanceopId) {
            return null;
        }
        return this.getBalanceopModelById(balanceopId);
    }

    @Override
    public void deleteBalanceop(Integer balanceopId) throws ApiException {
        if (null == balanceopId) {
            return;
        }
        this.deleteBalanceopModel(balanceopId);
    }

    @Override
    public QueryResult<PteBalanceop> queryBalanceopPage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("pte.PteBalanceopServiceImpl.queryBalanceopPage.map.isEmpty");
            return null;
        }
        if (map.get("dataState") != null && StringUtils.isNotBlank((String)map.get("dataState").toString())) {
            map.put("dataState", String.valueOf(map.get("dataState")));
        }
        List<PteBalanceop> pteBalanceopList = this.queryBalanceopModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalanceop(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteBalanceopList);
        return queryResult;
    }

    @Override
    public PteBalanceop getBalanceopByCode(String tenantCode, String balanceopCode) throws ApiException {
        if (StringUtils.isBlank((String)balanceopCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balanceopCode", balanceopCode);
        return this.getBalanceopModelByCode(map);
    }

    @Override
    public PteBalanceop queryStatisticsData(Map<String, Object> map) throws ApiException {
        return this.queryBalanceopStatisticsData(map);
    }

    @Override
    public void deleteBalanceopByCode(String tenantCode, String balanceopCode) throws ApiException {
        if (StringUtils.isBlank((String)balanceopCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balanceopCode", balanceopCode);
        this.delBalanceopModelByCode(map);
    }

    @Override
    public List<PteBalanceop> savePteBalanceoplistBatchRe(List<PteBalanceopDomain> pteBalanceopDomainList) throws ApiException {
        if (ListUtil.isEmpty(pteBalanceopDomainList)) {
            return null;
        }
        return this.makeBalanceopBatch(pteBalanceopDomainList);
    }

    @Override
    public String updateBalanceopToBalance(PteBalanceopDomain pteBalanceopDomain) throws ApiException {
        if (null == pteBalanceopDomain) {
            return null;
        }
        this.updateBalanceop(pteBalanceopDomain);
        this.updateBalanceopStateByCode(pteBalanceopDomain.getTenantCode(), pteBalanceopDomain.getBalanceopCode(), PteConstants.BalanceopData_State1, null, null);
        return pteBalanceopDomain.getBalanceopCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendBalanceService getSendService() {
        Object object = sendlock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendBalanceService((PteBalanceBaseService)SpringApplicationContextUtil.getBean((String)"pteBalanceBaseService"));
                for (int i = 0; i < 5; ++i) {
                    sendService.addPollPool(new SendBalancePollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public void sendBalanceop(String tenantCode, String dataState, String gmtModifiedby, String businessOrder) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)tenantCode)) {
            map.put("tenantCode", tenantCode);
        }
        if (StringUtils.isNotBlank((String)gmtModifiedby)) {
            map.put("gmtModifiedby", gmtModifiedby);
        }
        if (StringUtils.isNotBlank((String)businessOrder)) {
            map.put("businessOrder", businessOrder);
        }
        if (StringUtils.isNotBlank((String)dataState)) {
            map.put("dataState", dataState);
        } else {
            map.put("dataState", "5");
        }
        this.logger.error("pte.PteBalanceopServiceImpl.sendBalanceop.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        List<PteBalanceop> pteBalanceopList = this.queryBalanceopModelPage(map);
        for (PteBalanceop pteBalanceop : pteBalanceopList) {
            HashMap<String, Object> opmap = new HashMap<String, Object>();
            pteBalanceop.setBusinessDes2(PteBalanceopServiceImpl.getCurrentDateYYYYMMDD());
            opmap.put("businessDes2", pteBalanceop.getBusinessDes2());
            pteBalanceop.setBusinessDes3(pteBalanceop.getBusinessDes2() + pteBalanceop.getBusinessOrder());
            opmap.put("businessDes3", pteBalanceop.getBusinessDes3());
            this.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), 6, pteBalanceop.getDataState(), opmap);
            CmChannelClear cmChannelClear = this.getCmChannelClear(pteBalanceop.getTenantCode(), pteBalanceop.getBusinessOrderno(), "PD01", "2", null);
            if (cmChannelClear == null) continue;
            Map extMap = JsonUtil.buildNormalBinder().getJsonToMap(cmChannelClear.getExtension(), String.class, String.class);
            extMap.put("pteBalanceop", JsonUtil.buildNormalBinder().toJson((Object)pteBalanceop));
            cmChannelClear.setExtension(JsonUtil.buildNormalBinder().toJson((Object)extMap));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("cmChannelClear", JsonUtil.buildNormalBinder().toJson((Object)cmChannelClear));
            paramMap.put("fchannelCode", cmChannelClear.getFchannelCode());
            String restr = "";
            try {
                restr = this.internalInvoke("cmc.channelSp.channelSpStart", paramMap);
                this.logger.error("pte.PteBalanceopServiceImpl.sendBalanceop.restr" + pteBalanceop.getBusinessOrder(), (Object)restr);
                if (StringUtils.isBlank((String)restr)) {
                    opmap.put("memo", "\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff01");
                    this.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), 5, 6, opmap);
                    continue;
                }
                ChannelRest channelRest = (ChannelRest)JsonUtil.buildNormalBinder().getJsonToObject(restr, ChannelRest.class);
                if (null == channelRest) {
                    opmap.put("memo", "\u8fd4\u56de\u6570\u636e\u89e3\u6790\u53c2\u6570\u4e3a\u7a7a\uff01");
                    this.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), 5, 6, opmap);
                    continue;
                }
                if (channelRest.getDataState() == 2) {
                    this.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), 4, 6, opmap);
                } else {
                    opmap.put("memo", channelRest.getBankResmsg());
                    this.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), 5, 6, opmap);
                }
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalanceopServiceImpl.sendBalanceop.e", (Object)pteBalanceop.getBusinessOrder(), (Throwable)e);
                opmap.put("memo", "\u8bf7\u6c42\u5f02\u5e38\uff01");
                this.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), 5, 6, opmap);
            }
        }
    }

    public static String getCurrentDateYYYYMMDD() {
        return DATE_YYYYMMDD_FORMATTER.format(LocalDateTime.now());
    }

    private CmChannelClear getCmChannelClear(String tenantCode, String businessOrderno, String dicPaypdCode, String dataState, String contractBillCode) {
        List relist;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)dataState)) {
            paramMap.put("dataState", dataState);
        }
        paramMap.put("dicPaypdCode", dicPaypdCode);
        paramMap.put("tenantCode", tenantCode);
        if ("PD20".equals(dicPaypdCode)) {
            String channelClearSeqno = this.getChannelClearSeqno(contractBillCode, tenantCode, null);
            if (null == channelClearSeqno) {
                return null;
            }
            paramMap.put("channelClearSeqno", channelClearSeqno);
        } else if ("PD21".equals(dicPaypdCode)) {
            paramMap.put("businessOrderno", businessOrderno);
        } else {
            paramMap.put("businessOrderno", businessOrderno);
        }
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        QueryResult queryResult = this.sendReSupObject("cm.channelClear.querychannelClearPage", map, CmChannelClear.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("pte.PteBalanceopServiceImpl.getCmChannelClear.queryResult1", (Object)(businessOrderno + "\uff0c\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u4fe1\u606f\uff01" + JsonUtil.buildNormalBinder().toJson(paramMap)));
            return null;
        }
        CmChannelClear cmChannelClear = (CmChannelClear)queryResult.getList().get(queryResult.getList().size() - 1);
        if (("PD20".equals(dicPaypdCode) || "PD21".equals(dicPaypdCode)) && ListUtil.isNotEmpty(relist = queryResult.getList().stream().filter(c -> c.getDataState() != 3).collect(Collectors.toList()))) {
            cmChannelClear = (CmChannelClear)relist.get(0);
        }
        return cmChannelClear;
    }

    private String getChannelClearSeqno(String contractBillCode, String tenantCode, String dataState) {
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        HashMap<String, String> map = new HashMap<String, String>(1);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("contractBillcode", contractBillCode);
        paramMap.put("cflowPserviceCode", "FYSEND");
        if (StringUtils.isNotBlank((String)dataState)) {
            paramMap.put("dataState", dataState);
        }
        map.put("map", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        QueryResult pprocessQueryResult = this.sendReSupObject("oc.cflowPprocess.queryCflowPprocessPage", map, OcCflowPprocess.class);
        if (pprocessQueryResult == null || ListUtil.isEmpty((Collection)pprocessQueryResult.getList())) {
            this.logger.error("pte.PteBalanceopServiceImpl.getChannelClearSeqno.OcCflowPprocessList", (Object)(contractBillCode + "-" + dataState + ",\u672a\u67e5\u8be2\u5230\u5206\u5e10\u786e\u8ba4\u5355\u6267\u884c\u8bb0\u5f55\uff01"));
            return null;
        }
        OcCflowPprocess ocCflowPprocess = (OcCflowPprocess)pprocessQueryResult.getList().get(0);
        if (null == ocCflowPprocess) {
            this.logger.error("pte.PteBalanceopServiceImpl.getChannelClearSeqno.ocCflowPprocess", (Object)(contractBillCode + "-" + dataState + ",\u672a\u67e5\u8be2\u5230\u5206\u5e10\u786e\u8ba4\u5355\u6267\u884c\u8bb0\u5f55\uff01"));
            return null;
        }
        return ocCflowPprocess.getCflowPprocessCode();
    }

    static {
        sendlock = new Object();
        DATE_YYYYMMDD_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    }
}

