/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcRefundDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteDpriceDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.UmUserinfo;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalance;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceop;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceopGoods;
import com.yqbsoft.laser.service.paytradeengine.model.PteChannelsend;
import com.yqbsoft.laser.service.paytradeengine.model.PteDpriceConf;
import com.yqbsoft.laser.service.paytradeengine.model.ShShsettlList;
import com.yqbsoft.laser.service.paytradeengine.send.SendBalancePutThread;
import com.yqbsoft.laser.service.paytradeengine.send.SendPutThread;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceBaseService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceamtService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalancelistService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopGoodsService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopService;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PteBalanceopServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PteChannelsendServiceImpl;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteBalanceBaseServiceImpl
extends BaseServiceImpl
implements PteBalanceBaseService {
    private static final String SYS_CODE = "pte.PteBalanceBaseServiceImpl";
    private PteBalanceService pteBalanceService;
    private PteBalanceamtService pteBalanceamtService;
    private PteBalancelistService pteBalancelistService;
    private PteBalanceopService pteBalanceopService;
    private PteBalanceopGoodsService pteBalanceopGoodsService;

    public void setPteBalanceopGoodsService(PteBalanceopGoodsService pteBalanceopGoodsService) {
        this.pteBalanceopGoodsService = pteBalanceopGoodsService;
    }

    public PteBalanceService getPteBalanceService() {
        return this.pteBalanceService;
    }

    public void setPteBalanceService(PteBalanceService pteBalanceService) {
        this.pteBalanceService = pteBalanceService;
    }

    public PteBalanceamtService getPteBalanceamtService() {
        return this.pteBalanceamtService;
    }

    public void setPteBalanceamtService(PteBalanceamtService pteBalanceamtService) {
        this.pteBalanceamtService = pteBalanceamtService;
    }

    public PteBalancelistService getPteBalancelistService() {
        return this.pteBalancelistService;
    }

    public void setPteBalancelistService(PteBalancelistService pteBalancelistService) {
        this.pteBalancelistService = pteBalancelistService;
    }

    public PteBalanceopService getPteBalanceopService() {
        return this.pteBalanceopService;
    }

    public void setPteBalanceopService(PteBalanceopService pteBalanceopService) {
        this.pteBalanceopService = pteBalanceopService;
    }

    @Override
    public String sendBalanceopToBalanceamt(PteBalanceop PteBalanceop2) {
        if (null == PteBalanceop2) {
            return "error";
        }
        List<PteChannelsend> pteBalancelist = this.pteBalanceopService.sendBalanceopToBalancelist(PteBalanceop2);
        if (ListUtil.isNotEmpty(pteBalancelist)) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
        }
        return "success";
    }

    @Override
    public String sendBalanceopToBalanceamtRebate(PteBalanceop PteBalanceop2) {
        if (null == PteBalanceop2) {
            return "error";
        }
        List<PteChannelsend> pteBalancelist = this.pteBalanceopService.sendBalanceopToBalancelistRebate(PteBalanceop2);
        if (ListUtil.isNotEmpty(pteBalancelist)) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
        }
        return "success";
    }

    @Override
    public String sendSaveBalanceop(PteBalanceopDomain pteBalanceopDomain) {
        if (null == pteBalanceopDomain) {
            return "error";
        }
        if (StringUtils.isBlank((String)pteBalanceopDomain.getMemberCode())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopDomain));
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", pteBalanceopDomain.getTenantCode());
        map.put("balanceType", pteBalanceopDomain.getBalanceType());
        map.put("dataState", 0);
        QueryResult<PteBalance> pteBalanceQueryResult = this.pteBalanceService.queryBalancePage(map);
        PteBalance pteBalance = null;
        if (null == pteBalanceQueryResult || !ListUtil.isNotEmpty((Collection)pteBalanceQueryResult.getList())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.queryBalancePage.null", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return "error";
        }
        pteBalance = (PteBalance)pteBalanceQueryResult.getList().get(0);
        if (PteConstants.BALANCE_FEE_STATE_OPEN.equals(pteBalance.getBalanceFeestate())) {
            if ("0".equals(pteBalance.getBalanceFeetype()) && null != pteBalance.getBalanceFee()) {
                pteBalanceopDomain.setBalanceopFee(pteBalance.getBalanceFee());
            } else if ("1".equals(pteBalance.getBalanceFeetype()) && null != pteBalance.getBalanceFee() && null != pteBalanceopDomain.getBalanceopAmount()) {
                pteBalanceopDomain.setBalanceopFee(pteBalanceopDomain.getBalanceopAmount().multiply(pteBalance.getBalanceFee()));
            }
        } else {
            pteBalanceopDomain.setBalanceopFee(BigDecimal.ZERO);
        }
        if ("0".equals(pteBalance.getBalanceAmounttype()) && null != pteBalance.getBalanceAmount()) {
            pteBalanceopDomain.setBalanceopAmount(pteBalance.getBalanceAmount());
        } else if ("1".equals(pteBalance.getBalanceAmounttype()) && null != pteBalance.getBalanceAmount() && null != pteBalanceopDomain.getBalanceopAmount()) {
            pteBalanceopDomain.setBalanceopAmount(pteBalanceopDomain.getBalanceopAmount().multiply(pteBalance.getBalanceAmount()));
        }
        pteBalanceopDomain.setBalanceBank(pteBalance.getBalanceBank());
        pteBalanceopDomain.setBalanceType(pteBalance.getBalanceType());
        ArrayList<PteBalanceopDomain> pteBalanceopDomains = new ArrayList<PteBalanceopDomain>();
        pteBalanceopDomains.add(pteBalanceopDomain);
        List<PteBalanceop> list = this.pteBalanceopService.savePteBalanceoplistBatchRe(pteBalanceopDomains);
        if (ListUtil.isNotEmpty(list)) {
            PteBalanceopServiceImpl.getSendService().addPutPool(new SendBalancePutThread(PteBalanceopServiceImpl.getSendService(), list));
        } else {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop.list", (Object)JsonUtil.buildNormalBinder().toJson(pteBalanceopDomains));
        }
        return "success";
    }

    public String sendSaveBalanceopFenYong(PteBalanceopDomain pteBalanceopDomain, OcContractReDomain ocContractDomain) {
        if (null == pteBalanceopDomain) {
            return "error";
        }
        if (StringUtils.isBlank((String)pteBalanceopDomain.getMemberCode())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopDomain));
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", pteBalanceopDomain.getTenantCode());
        map.put("balanceType", pteBalanceopDomain.getBalanceType());
        map.put("dataState", 1);
        QueryResult<PteBalance> pteBalanceQueryResult = this.pteBalanceService.queryBalancePage(map);
        PteBalance pteBalance = null;
        if (null == pteBalanceQueryResult || !ListUtil.isNotEmpty((Collection)pteBalanceQueryResult.getList())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.queryBalancePage.null", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return "error";
        }
        pteBalance = (PteBalance)pteBalanceQueryResult.getList().get(0);
        if (null != pteBalance.getBalanceStart() && new Date().getTime() < pteBalance.getBalanceStart().getTime()) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.pteBalance.getBalanceStart()", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalance));
            return "error";
        }
        if (null != pteBalance.getBalanceEnd() && new Date().getTime() > pteBalance.getBalanceEnd().getTime()) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.pteBalance.getBalanceEnd()", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalance));
            return "error";
        }
        List disDpriceList = DisUtil.getMapListJson((String)"PteDprice", (String)(pteBalanceopDomain.getBalanceType() + "-" + pteBalanceopDomain.getTenantCode()), PteDpriceDomain.class);
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.disDpriceList.null", (Object)(pteBalanceopDomain.getBalanceType() + "-" + pteBalanceopDomain.getTenantCode()));
            return "error";
        }
        BigDecimal balanceopFee = BigDecimal.ZERO;
        ArrayList<PteBalanceopGoodsDomain> pteBalanceopGoodsList = new ArrayList<PteBalanceopGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getPackageList().get(0).getContractGoodsList()) {
            PteBalanceopGoodsDomain pteBalanceopGoods = new PteBalanceopGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalanceopGoods, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalanceBaseServiceImpl.makeBalanceop", (Throwable)e);
            }
            this.makeDprice(pteBalanceopGoods, disDpriceList);
            pteBalanceopGoodsList.add(pteBalanceopGoods);
            balanceopFee = balanceopFee.add(pteBalanceopGoods.getPricesetRefrice());
        }
        pteBalanceopDomain.setPteBalanceopGoodsDomainList(pteBalanceopGoodsList);
        pteBalanceopDomain.setBalanceopFee(balanceopFee);
        HashMap<String, String> extMap = new HashMap<String, String>();
        extMap.put("pteBalance", JsonUtil.buildNormalBinder().toJson((Object)pteBalance));
        extMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        pteBalanceopDomain.setBalanceopExtension(JsonUtil.buildNonDefaultBinder().toJson(extMap));
        ArrayList<PteBalanceopDomain> pteBalanceopDomains = new ArrayList<PteBalanceopDomain>();
        pteBalanceopDomains.add(pteBalanceopDomain);
        this.pteBalanceopService.savePteBalanceoplistBatchRe(pteBalanceopDomains);
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettlDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        ocContractSettlDomain.setContractSettlType("4");
        ocContractSettlDomain.setContractSettlBlance("PTE");
        ocContractSettlDomain.setContractSettlPmoney(balanceopFee);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractSettlDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractSettlDomain));
        this.getInternalRouter().inInvoke("oc.contract.saveContractSettl", "1.0", "0", paramMap);
        return "success";
    }

    public void makeDprice(PteBalanceopGoodsDomain pteBalanceopGoods, List<PteDpriceDomain> pteDpriceList) {
        if (ListUtil.isEmpty(pteDpriceList)) {
            return;
        }
        Map<String, Object> objMap = this.makeObject(pteBalanceopGoods);
        for (PteDpriceDomain pteDpriceDomain : pteDpriceList) {
            Map keymap = DisUtil.getRemotMapAll((String)("PteDpriceConf-key-" + pteDpriceDomain.getDpriceCode() + "-" + pteDpriceDomain.getTenantCode()));
            String vaulemap = "PteDpriceConf-value-" + pteDpriceDomain.getDpriceCode() + "-" + pteDpriceDomain.getTenantCode();
            this.checkConf(keymap, vaulemap, objMap, (Object)pteDpriceDomain);
            HashMap<String, String> dpricemap = new HashMap<String, String>();
            if ("0".equals(pteDpriceDomain.getDpricePro())) {
                pteBalanceopGoods.setPricesetRefrice(pteDpriceDomain.getDpricePrice().divide(new BigDecimal("100"), 2, 4).multiply(pteBalanceopGoods.getContractGoodsPrice().multiply(pteBalanceopGoods.getGoodsCamount())));
            } else if ("2".equals(pteDpriceDomain.getDpricePro())) {
                pteBalanceopGoods.setPricesetRefrice(pteDpriceDomain.getDpricePrice().multiply(pteBalanceopGoods.getGoodsOrdnum()));
            }
            dpricemap.put("pteDpriceDomain", JsonUtil.buildNormalBinder().toJson((Object)pteDpriceDomain));
            dpricemap.put("goodsRemark", pteBalanceopGoods.getGoodsRemark());
            pteBalanceopGoods.setGoodsRemark(JsonUtil.buildNonDefaultBinder().toJson(dpricemap));
        }
    }

    protected boolean checkConf(Map<String, String> keymap, String valuemap, Object obj, Object mainObj) {
        boolean flag = false;
        String key = keymap.get("skuNo=");
        if (StringUtils.isNotBlank((String)key)) {
            flag = this.checkConf(key, valuemap, obj, mainObj);
        }
        if (StringUtils.isNotBlank((String)(key = keymap.get("classtreeCode="))) && !flag) {
            flag = this.checkConf(key, valuemap, obj, mainObj);
        }
        if (StringUtils.isNotBlank((String)(key = keymap.get("memberCcode="))) && !flag) {
            flag = this.checkConf(key, valuemap, obj, mainObj);
        }
        return flag;
    }

    protected boolean checkConf(String keys, String valuemap, Object obj, Object mainObj) {
        Object objValue;
        if (StringUtils.isBlank((String)keys) || StringUtils.isBlank((String)valuemap)) {
            this.logger.info("pte.PteBalanceBaseServiceImplcheckConf", (Object)("keys=" + keys + "valuemap=" + valuemap));
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        String[] keyStr = keys.split("\\-");
        if (null == keyStr || keyStr.length == 0) {
            return false;
        }
        key = keyStr[0];
        if (keyStr.length > 1) {
            term = keyStr[1];
        }
        if ((objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key)) instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
            String[] otrs = objValue.toString().split("\\,");
            flag = false;
            for (String o : otrs) {
                if (!this.cond(keys, valuemap, term, o, mainObj)) continue;
                flag = true;
                break;
            }
        } else if (!this.cond(keys, valuemap, term, objValue, mainObj)) {
            flag = false;
        }
        return flag;
    }

    protected boolean cond(String keys, String valuemap, String term, Object objValue, Object mainObj) {
        if (StringUtils.isBlank((String)valuemap)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        if (term.equals("=") || term.equals("!=")) {
            keys = keys + "-" + objValue;
        }
        String value = DisUtil.getRemotMap((String)valuemap, (String)keys);
        PteDpriceConf confObj = null;
        if (mainObj instanceof PteDpriceDomain) {
            PteDpriceConf disDpriceConf = null;
            if (StringUtils.isNotBlank((String)value)) {
                disDpriceConf = (PteDpriceConf)JsonUtil.buildNormalBinder().getJsonToObject(value, PteDpriceConf.class);
                value = disDpriceConf.getDpriceConfValue();
                confObj = disDpriceConf;
            }
        }
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue && StringUtils.isNotBlank((String)value)) {
                flag = false;
            }
        } else if (null == objValue && StringUtils.isBlank((String)value)) {
            flag = false;
        }
        if (null != mainObj && flag && null != confObj) {
            PteBalanceBaseServiceImpl.setReturn(mainObj, confObj);
        }
        return flag;
    }

    protected static void setReturn(Object mainObj, Object obj) {
        if (null == mainObj || null == obj) {
            return;
        }
        if (mainObj instanceof PteDpriceDomain && obj instanceof PteDpriceConf) {
            PteDpriceDomain pteDpriceDomain = (PteDpriceDomain)mainObj;
            PteDpriceConf pteDpriceConf = (PteDpriceConf)obj;
            pteDpriceDomain.setPteDpriceConf(pteDpriceConf);
            pteDpriceDomain.setDpricePro(pteDpriceConf.getDpriceConfPro());
            if (null != pteDpriceConf.getDpriceConfPrice() && pteDpriceConf.getDpriceConfPrice().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpricePrice(pteDpriceConf.getDpriceConfPrice());
            }
            if (null != pteDpriceConf.getDpriceConfMprice() && pteDpriceConf.getDpriceConfMprice().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpriceMprice(pteDpriceConf.getDpriceConfMprice());
            }
            if (null != pteDpriceConf.getDpriceConfPricedef() && pteDpriceConf.getDpriceConfPricedef().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpricePricedef(pteDpriceConf.getDpriceConfPricedef());
            }
            if (null != pteDpriceConf.getDpriceConfMpricedef() && pteDpriceConf.getDpriceConfMpricedef().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpriceMpricedef(pteDpriceConf.getDpriceConfMpricedef());
            }
        }
    }

    protected Map<String, Object> makeObject(PteBalanceopGoodsDomain pteBalanceopGoods) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (null != pteBalanceopGoods) {
            obj.putAll((Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopGoods), String.class, Object.class));
        }
        return obj;
    }

    @Override
    public String sendSaveBalanceopRebate(PteBalanceopDomain pteBalanceopDomain) {
        if (null == pteBalanceopDomain) {
            return "error";
        }
        if (StringUtils.isBlank((String)pteBalanceopDomain.getMemberCode())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopDomain));
            return "error";
        }
        ArrayList<PteBalanceopDomain> pteBalanceopDomains = new ArrayList<PteBalanceopDomain>();
        pteBalanceopDomains.add(pteBalanceopDomain);
        List<PteBalanceop> list = this.pteBalanceopService.savePteBalanceoplistBatchRe(pteBalanceopDomains);
        if (ListUtil.isNotEmpty(list)) {
            PteBalanceopServiceImpl.getSendService().addPutPool(new SendBalancePutThread(PteBalanceopServiceImpl.getSendService(), list));
        } else {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop.list", (Object)JsonUtil.buildNormalBinder().toJson(pteBalanceopDomains));
        }
        return "success";
    }

    @Override
    public String sendShsettlListToBalanceop(ShShsettlList shShsettlList) {
        this.logger.error("pte.PteBalanceBaseServiceImpl.sendShsettlListToBalanceop.shShsettlList", (Object)JsonUtil.buildNormalBinder().toJson((Object)shShsettlList));
        if (null == shShsettlList) {
            return "error";
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setBalanceopAmount(shShsettlList.getShsettlListAmt());
        pteBalanceopDomain.setOrderOamount(shShsettlList.getShsettlOplistOpamt());
        pteBalanceopDomain.setBalanceType("shsettl");
        pteBalanceopDomain.setMemberCode(shShsettlList.getMemberBcode());
        pteBalanceopDomain.setMemberName(shShsettlList.getMemberBname());
        pteBalanceopDomain.setMemberBcode(shShsettlList.getMemberCcode());
        pteBalanceopDomain.setMemberBname(shShsettlList.getMemberCname());
        pteBalanceopDomain.setTenantCode(shShsettlList.getTenantCode());
        pteBalanceopDomain.setBusinessOrderno(shShsettlList.getShsettlOplistOp());
        this.sendSaveBalanceop(pteBalanceopDomain);
        return "success";
    }

    @Override
    public String sendSgOccontractPoolSendgoods(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setBalanceopAmount(ocContractDomain.getDataBmoney());
        pteBalanceopDomain.setOrderOamount(ocContractDomain.getContractInmoney());
        pteBalanceopDomain.setBalanceType("oc");
        pteBalanceopDomain.setMemberCode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberName(ocContractDomain.getMemberBname());
        pteBalanceopDomain.setMemberBcode(ocContractDomain.getMemberCcode());
        pteBalanceopDomain.setMemberBname(ocContractDomain.getMemberCname());
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBbillcode());
        pteBalanceopDomain.setBalanceopExtension(JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractDomain));
        this.sendSaveBalanceop(pteBalanceopDomain);
        return "success";
    }

    @Override
    public String sendOccontractRebate(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        List<OcContractSettlDomain> ocContractSettlList = ocContractDomain.getOcContractSettlList();
        if (ListUtil.isEmpty(ocContractSettlList)) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendOccontractRebate ", (Object)("ocContractSettlList is null-" + ocContractDomain.getContractBillcode()));
            return "success";
        }
        BigDecimal balanceopAmount = BigDecimal.ZERO;
        String userinfoOcde = "";
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
            if ("RebateNum".equals(ocContractSettlDomain.getContractSettlBlance())) {
                balanceopAmount = ocContractSettlDomain.getContractSettlGmoney();
            }
            if (!"UserinfoOcode".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
            userinfoOcde = ocContractSettlDomain.getContractSettlOpemo();
        }
        if (StringUtils.isBlank((String)userinfoOcde)) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendOccontractRebate ", (Object)"userinfoOcde is null");
            return "success";
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setBalanceopAmount(balanceopAmount);
        pteBalanceopDomain.setOrderOamount(ocContractDomain.getContractInmoney());
        pteBalanceopDomain.setOrderPrice(ocContractDomain.getContractMoney());
        pteBalanceopDomain.setBalanceType("rebate");
        pteBalanceopDomain.setMemberCode(ocContractDomain.getMemberCode());
        pteBalanceopDomain.setMemberName(ocContractDomain.getMemberName());
        pteBalanceopDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberBname(ocContractDomain.getMemberBname());
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBbillcode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setBalanceopExtension(JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractDomain));
        pteBalanceopDomain.setBalanceBank("1");
        pteBalanceopDomain.setPtradeType("06");
        pteBalanceopDomain.setOpuserCode(userinfoOcde);
        this.sendSaveBalanceopRebate(pteBalanceopDomain);
        return "success";
    }

    @Override
    public String sendBalance(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setBalanceopAmount(ocContractDomain.getDataBmoney());
        pteBalanceopDomain.setOrderOamount(ocContractDomain.getContractInmoney());
        pteBalanceopDomain.setBalanceType("oc");
        pteBalanceopDomain.setMemberCode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberName(ocContractDomain.getMemberBname());
        pteBalanceopDomain.setMemberBcode(ocContractDomain.getMemberCcode());
        pteBalanceopDomain.setMemberBname(ocContractDomain.getMemberCname());
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBbillcode());
        pteBalanceopDomain.setGmtPaySubmit(ocContractDomain.getGmtCreate());
        pteBalanceopDomain.setGmtPayout(ocContractDomain.getContractPaydate());
        this.sendSaveBalanceopFenYong(pteBalanceopDomain, ocContractDomain);
        return "success";
    }

    @Override
    public String sendBalanceStart(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("businessOrderno", ocContractDomain.getContractBillcode());
        map.put("balanceType", "oc");
        map.put("dataState", PteConstants.BalanceopData_State0);
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList()) || queryResult.getList().size() > 1) {
            return "error";
        }
        PteBalanceop pteBalanceop = (PteBalanceop)queryResult.getList().get(0);
        this.pteBalanceopService.updateBalanceopState(pteBalanceop.getBalanceopId(), PteConstants.BalanceopData_State1, pteBalanceop.getDataState(), null);
        return "success";
    }

    @Override
    public void queryBalanceJob() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceType", "oc");
        map.put("gmtPaidQend", new Date());
        map.put("dataState", PteConstants.BalanceopData_State2);
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return;
        }
        for (PteBalanceop pteBalanceop : queryResult.getList()) {
            this.pteBalanceopService.updateBalanceopState(pteBalanceop.getBalanceopId(), PteConstants.BalanceopData_State3, pteBalanceop.getDataState(), null);
        }
    }

    @Override
    public String sendBalanceEnd(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("businessOrderno", ocContractDomain.getContractBillcode());
        map.put("balanceType", "oc");
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList()) || queryResult.getList().size() > 1) {
            return "error";
        }
        PteBalanceop pteBalanceop = (PteBalanceop)queryResult.getList().get(0);
        BigDecimal balanceopFee = pteBalanceop.getBalanceopFee();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getPackageList().get(0).getContractGoodsList()) {
            if (null == ocContractGoodsDomain.getContractGoodsRefnum()) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain.getContractGoodsRefnum().intValue() == 0) continue;
            HashMap<String, Object> goodsmap = new HashMap<String, Object>();
            goodsmap.put("tenantCode", ocContractDomain.getTenantCode());
            goodsmap.put("contractBillcode", ocContractDomain.getContractBillcode());
            goodsmap.put("contractGoodsCode", ocContractGoodsDomain.getContractGoodsCode());
            QueryResult<PteBalanceopGoods> goodsQueryResult = this.pteBalanceopGoodsService.queryBalanceopGoodsPage(goodsmap);
            if (null == goodsQueryResult || ListUtil.isEmpty((Collection)goodsQueryResult.getList()) || goodsQueryResult.getList().size() > 1) {
                return "error";
            }
            PteBalanceopGoods pteBalanceopGoodsOld = (PteBalanceopGoods)goodsQueryResult.getList().get(0);
            BigDecimal subtract = ocContractGoodsDomain.getGoodsCamount().subtract(ocContractGoodsDomain.getContractGoodsRefnum());
            if (subtract.intValue() != 0 || ocContractDomain.getDataBmoney().subtract(ocContractDomain.getRefundMoney()).compareTo(BigDecimal.ZERO) != 0) {
                balanceopFee = balanceopFee.subtract(pteBalanceopGoodsOld.getPricesetRefrice());
                this.pteBalanceopGoodsService.updateBalanceopGoodsState(pteBalanceopGoodsOld.getBalanceopGoodsId(), -1, 0, null);
                continue;
            }
            if (subtract.intValue() <= 0) continue;
            PteBalanceopGoodsDomain pteBalanceopGoods = new PteBalanceopGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalanceopGoods, (Object)ocContractGoodsDomain);
                pteBalanceopGoods.setBalanceopGoodsId(pteBalanceopGoodsOld.getBalanceopGoodsId());
                Map remMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(pteBalanceopGoodsOld.getGoodsRemark(), String.class, Object.class);
                PteDpriceDomain pteDpriceDomain = (PteDpriceDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(remMap.get("pteDpriceDomain")), PteDpriceDomain.class);
                if ("0".equals(pteDpriceDomain.getDpricePro())) {
                    pteBalanceopGoods.setPricesetRefrice(pteDpriceDomain.getDpricePrice().divide(new BigDecimal("100"), 2, 4).multiply(pteBalanceopGoods.getContractGoodsPrice().multiply(subtract)));
                } else if ("2".equals(pteDpriceDomain.getDpricePro())) {
                    pteBalanceopGoods.setPricesetRefrice(pteDpriceDomain.getDpricePrice().multiply(subtract));
                }
                pteBalanceopGoods.setGoodsRemark(pteBalanceopGoodsOld.getGoodsRemark());
                balanceopFee = balanceopFee.subtract(pteBalanceopGoodsOld.getPricesetRefrice());
                this.pteBalanceopGoodsService.updateBalanceopGoods(pteBalanceopGoods);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalanceBaseServiceImpl.makeBalanceop", (Throwable)e);
            }
        }
        if (pteBalanceop.getBalanceopFee().compareTo(balanceopFee) != 0) {
            PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalanceopDomain, (Object)pteBalanceop);
                pteBalanceop.setBalanceopFee(balanceopFee);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalanceBaseServiceImpl.makeBalanceop", (Throwable)e);
            }
            this.pteBalanceopService.updateBalanceop(pteBalanceopDomain);
        }
        Map remMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(pteBalanceop.getBalanceopExtension(), String.class, Object.class);
        PteBalance pteBalance = (PteBalance)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(remMap.get("pteBalance")), PteBalance.class);
        Date gmtPaid = new Date();
        if (null != pteBalance && "0".equals(pteBalance.getBalanceTime()) && StringUtils.isNumeric((Object)pteBalance.getBalanceTime())) {
            gmtPaid = PteBalanceBaseServiceImpl.getDate(Integer.parseInt(pteBalance.getBalanceTime()));
        }
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        stateMap.put("gmtPaid", gmtPaid);
        this.pteBalanceopService.updateBalanceopState(pteBalanceop.getBalanceopId(), PteConstants.BalanceopData_State2, pteBalanceop.getDataState(), stateMap);
        return "success";
    }

    private static Date getDate(int day) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, day);
        return c.getTime();
    }

    public String sendSaveBalanceoPay(PteBalanceopDomain pteBalanceopDomain, OcContractReDomain ocContractDomain) {
        if (null == pteBalanceopDomain) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceoPay.pteBalanceopDomain is null");
            return "error";
        }
        if (StringUtils.isBlank((String)pteBalanceopDomain.getMemberCode())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceoPay.pteBalanceopDomain.getMemberCode()", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopDomain));
            return "error";
        }
        BigDecimal balanceopFee = BigDecimal.ZERO;
        ArrayList<PteBalanceopGoodsDomain> pteBalanceopGoodsList = new ArrayList<PteBalanceopGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getPackageList().get(0).getContractGoodsList()) {
            PteBalanceopGoodsDomain pteBalanceopGoods = new PteBalanceopGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalanceopGoods, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalanceBaseServiceImpl.makeBalanceop", (Throwable)e);
            }
            if (null == ocContractGoodsDomain.getPricesetNprice()) {
                ocContractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getPricesetAsprice()) {
                ocContractGoodsDomain.setPricesetAsprice(BigDecimal.ZERO);
            }
            BigDecimal multiply = ocContractGoodsDomain.getPricesetAsprice().multiply(ocContractGoodsDomain.getGoodsCamount());
            balanceopFee = balanceopFee.add(multiply);
            pteBalanceopGoods.setPricesetRefrice(multiply);
            pteBalanceopGoodsList.add(pteBalanceopGoods);
        }
        pteBalanceopDomain.setPteBalanceopGoodsDomainList(pteBalanceopGoodsList);
        pteBalanceopDomain.setBalanceopFee(pteBalanceopDomain.getBalanceopAmount().subtract(balanceopFee));
        pteBalanceopDomain.setOrderDviAmt(balanceopFee);
        HashMap<String, String> extMap = new HashMap<String, String>();
        extMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        pteBalanceopDomain.setBalanceopExtension(JsonUtil.buildNonDefaultBinder().toJson(extMap));
        ArrayList<PteBalanceopDomain> pteBalanceopDomains = new ArrayList<PteBalanceopDomain>();
        pteBalanceopDomains.add(pteBalanceopDomain);
        this.pteBalanceopService.savePteBalanceoplistBatchRe(pteBalanceopDomains);
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettlDomain, (Object)ocContractDomain);
        }
        catch (Exception multiply) {
            // empty catch block
        }
        ocContractSettlDomain.setContractSettlType("4");
        ocContractSettlDomain.setContractSettlBlance("PTE");
        ocContractSettlDomain.setContractSettlPmoney(pteBalanceopDomain.getBalanceopFee());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractSettlDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractSettlDomain));
        this.getInternalRouter().inInvoke("oc.contract.saveContractSettl", "1.0", "0", paramMap);
        return "success";
    }

    @Override
    public String sendBalancePay(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendBalancePay is null");
            return "error";
        }
        this.logger.info("pte.PteBalanceBaseServiceImpl.sendBalancePay.ocContractDomain.getContractBillcode()", (Object)ocContractDomain.getContractBillcode());
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setBalanceType("oc");
        pteBalanceopDomain.setMemberCcode(ocContractDomain.getMemberCcode());
        pteBalanceopDomain.setMemberCname(ocContractDomain.getMemberCname());
        pteBalanceopDomain.setMemberCode(ocContractDomain.getMemberCode());
        pteBalanceopDomain.setMemberName(ocContractDomain.getMemberName());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", pteBalanceopDomain.getMemberCcode());
        paramMap.put("tenantCode", ocContractDomain.getTenantCode());
        String userJosn = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByCode", "1.0", "0", paramMap);
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userJosn, UmUserinfo.class);
        if (null != umUserinfo) {
            pteBalanceopDomain.setBusinessDes2(umUserinfo.getUserinfoOcode());
        }
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBbillcode());
        pteBalanceopDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberBname(ocContractDomain.getUserName());
        pteBalanceopDomain.setOrderOamount(ocContractDomain.getContractInmoney().add(ocContractDomain.getGoodsLogmoney()));
        pteBalanceopDomain.setGoodsPmoney(ocContractDomain.getGoodsPmoney());
        pteBalanceopDomain.setBalanceopAmount(ocContractDomain.getDataBmoney());
        pteBalanceopDomain.setOrderPortion(ocContractDomain.getGoodsLogmoney());
        pteBalanceopDomain.setGmtPaySubmit(ocContractDomain.getGmtCreate());
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setGmtPaySubmit(ocContractDomain.getGmtCreate());
        pteBalanceopDomain.setGmtPayout(ocContractDomain.getContractPaydate());
        this.sendSaveBalanceoPay(pteBalanceopDomain, ocContractDomain);
        return "success";
    }

    @Override
    public String sendBalanceState(OcContractReDomain ocContractDomain) throws ApiException {
        Map param = this.getQueryMapParam("tenantCode,businessOrder,businessOrderno", new Object[]{ocContractDomain.getTenantCode(), ocContractDomain.getContractBbillcode(), ocContractDomain.getContractBillcode()});
        QueryResult<PteBalanceop> pteBalanceopQueryResult = this.pteBalanceopService.queryBalanceopPage(param);
        for (PteBalanceop pteBalanceop : pteBalanceopQueryResult.getList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("gmtPaid", new Date());
            this.pteBalanceopService.updateBalanceopState(pteBalanceop.getBalanceopId(), 1, pteBalanceop.getDataState(), map);
        }
        return "success";
    }

    @Override
    public String updateBalanceRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        this.logger.error("pte.PteBalanceBaseServiceImpl.updateBalanceRefund.ocRefundDomain------\u5f00\u59cb\u9000\u5355\u7ed3\u7b97------", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        ArrayList<PteBalanceop> pteBalanceopList = new ArrayList<PteBalanceop>();
        Map param = this.getQueryMapParam("tenantCode,businessOrder,businessOrderno", new Object[]{ocRefundDomain.getTenantCode(), ocRefundDomain.getContractBbillcode(), ocRefundDomain.getContractBillcode()});
        QueryResult<PteBalanceop> pteBalanceopQueryResult = this.pteBalanceopService.queryBalanceopPage(param);
        this.logger.error("pte.PteBalanceBaseServiceImpl.updateBalanceRefund.pteBalanceopQueryResult------\u67e5\u8be2\u7ed3\u7b97\u8bb0\u5f55------", (Object)JsonUtil.buildNormalBinder().toJson(pteBalanceopQueryResult));
        for (PteBalanceop pteBalanceop : pteBalanceopQueryResult.getList()) {
            pteBalanceop.setOrderMeramt(ocRefundDomain.getGoodsNum().multiply(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getPricesetAsprice()));
            pteBalanceop.setOrderPlatamt(ocRefundDomain.getRefundMoney().subtract(pteBalanceop.getOrderMeramt()));
            pteBalanceop.setOrderPrice(pteBalanceop.getBalanceopFee().subtract(pteBalanceop.getOrderPlatamt()));
            pteBalanceop.setDataBmoney(pteBalanceop.getOrderDviAmt().subtract(pteBalanceop.getOrderMeramt()));
            pteBalanceopList.add(pteBalanceop);
        }
        this.pteBalanceopService.updatePteBalanceoplistBatch(pteBalanceopList);
        return "success";
    }
}

