/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.dao.PteBalancelistMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteChannelsendDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.UpmUpointsClearDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalancelist;
import com.yqbsoft.laser.service.paytradeengine.model.PteChannelsend;
import com.yqbsoft.laser.service.paytradeengine.send.SendPutThread;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceamtService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalancelistService;
import com.yqbsoft.laser.service.paytradeengine.service.PteChannelsendService;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PteChannelsendServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteBalancelistServiceImpl
extends BaseServiceImpl
implements PteBalancelistService {
    private static final String SYS_CODE = "pte.PteBalancelistServiceImpl";
    private PteBalancelistMapper pteBalancelistMapper;
    private PteBalanceamtService pteBalanceamtService;
    private PteChannelsendService pteChannelsendService;

    public void setPteBalancelistMapper(PteBalancelistMapper pteBalancelistMapper) {
        this.pteBalancelistMapper = pteBalancelistMapper;
    }

    public void setPteBalanceamtService(PteBalanceamtService pteBalanceamtService) {
        this.pteBalanceamtService = pteBalanceamtService;
    }

    public void setPteChannelsendService(PteChannelsendService pteChannelsendService) {
        this.pteChannelsendService = pteChannelsendService;
    }

    private Date getSysDate() {
        try {
            return this.pteBalancelistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBalancelist(PteBalancelistDomain pteBalancelistDomain) {
        if (null == pteBalancelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteBalancelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setBalancelistDefault(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return;
        }
        if (null == pteBalancelist.getDataState()) {
            pteBalancelist.setDataState(PteConstants.PTE_LIST_DATA_STATE_0);
        }
        Date date = this.getSysDate();
        if (null == pteBalancelist.getGmtCreate()) {
            pteBalancelist.setGmtCreate(date);
        }
        pteBalancelist.setGmtModified(date);
        if (StringUtils.isBlank((String)pteBalancelist.getBalancelistCode())) {
            pteBalancelist.setBalancelistCode(this.getNo(null, "PteBalancelist", "pteBalancelist", pteBalancelist.getTenantCode()));
        }
        if (null != pteBalancelist.getBalanceTime() && !"0".equals(pteBalancelist.getBalanceTime())) {
            long outDate = date.getTime() + (long)(Integer.valueOf(pteBalancelist.getBalanceTime()) * 60) * 1000L;
            pteBalancelist.setGmtPaySubmit(new Date(outDate));
        } else {
            pteBalancelist.setDataState(PteConstants.PTE_LIST_DATA_Already);
        }
    }

    private int getBalancelistMaxCode() {
        int code = 0;
        try {
            return this.pteBalancelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getBalancelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalancelistUpdataDefault(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return;
        }
        pteBalancelist.setGmtModified(this.getSysDate());
    }

    private void saveBalancelistModel(PteBalancelist pteBalancelist) throws ApiException {
        if (null == pteBalancelist) {
            return;
        }
        try {
            this.pteBalancelistMapper.insert(pteBalancelist);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.saveBalancelistModel.ex", (Throwable)e);
        }
    }

    private void saveBalancelistBatchModel(List<PteBalancelist> pteBalancelistList) throws ApiException {
        if (null == pteBalancelistList || pteBalancelistList.isEmpty()) {
            return;
        }
        try {
            this.pteBalancelistMapper.insertBatch(pteBalancelistList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.saveBalancelistBatchModel.ex", (Throwable)e);
        }
    }

    private PteBalancelist getBalancelistModelById(Integer balancelistId) {
        if (null == balancelistId) {
            return null;
        }
        try {
            return this.pteBalancelistMapper.selectByPrimaryKey(balancelistId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getBalancelistModelById", (Throwable)e);
            return null;
        }
    }

    private PteBalancelist getBalancelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteBalancelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getBalancelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBalancelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.delBalancelistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.delBalancelistModelByCode.num");
        }
    }

    private void deleteBalancelistModel(Integer balancelistId) throws ApiException {
        if (null == balancelistId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.deleteByPrimaryKey(balancelistId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.deleteBalancelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.deleteBalancelistModel.num");
        }
    }

    private void updateBalancelistModel(PteBalancelist pteBalancelist) throws ApiException {
        if (null == pteBalancelist) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateByPrimaryKey(pteBalancelist);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistModel.num");
        }
    }

    private void updateStateBalancelistModel(Integer balancelistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == balancelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balancelistId", balancelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModel.null");
        }
    }

    private void updateStateBalancelistModelByCode(String tenantCode, String balancelistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balancelistCode", balancelistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModelByCode.null");
        }
    }

    private PteBalancelist makeBalancelist(PteBalancelistDomain pteBalancelistDomain, PteBalancelist pteBalancelist) {
        if (null == pteBalancelistDomain) {
            return null;
        }
        if (null == pteBalancelist) {
            pteBalancelist = new PteBalancelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelist, (Object)pteBalancelistDomain);
            return pteBalancelist;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.makeBalancelist", (Throwable)e);
            return null;
        }
    }

    private PteBalancelistReDomain makePteBalancelistReDomain(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return null;
        }
        PteBalancelistReDomain pteBalancelistReDomain = new PteBalancelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistReDomain, (Object)pteBalancelist);
            return pteBalancelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.makePteBalancelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteBalancelist> queryBalancelistModelPage(Map<String, Object> parammap) {
        try {
            return this.pteBalancelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.queryBalancelistModel", (Throwable)e);
            return null;
        }
    }

    private int countBalancelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteBalancelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.countBalancelist", (Throwable)e);
        }
        return i;
    }

    private PteBalancelist createPteBalancelist(PteBalancelistDomain pteBalancelistDomain) {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.saveBalancelist.checkBalancelist", msg);
        }
        PteBalancelist pteBalancelist = this.makeBalancelist(pteBalancelistDomain, null);
        this.setBalancelistDefault(pteBalancelist);
        return pteBalancelist;
    }

    @Override
    public String saveBalancelist(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        PteBalancelist pteBalancelist = this.createPteBalancelist(pteBalancelistDomain);
        this.saveBalancelistModel(pteBalancelist);
        return pteBalancelist.getBalancelistCode();
    }

    private PteBalancelist saveBalancelistModel(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        PteBalancelist pteBalancelist = this.createPteBalancelist(pteBalancelistDomain);
        this.saveBalancelistModel(pteBalancelist);
        return pteBalancelist;
    }

    @Override
    public String saveBalancelistBatch(List<PteBalancelistDomain> pteBalancelistDomainList) throws ApiException {
        if (null == pteBalancelistDomainList || pteBalancelistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteBalancelist> pteBalancelistList = new ArrayList<PteBalancelist>();
        String code = "";
        for (PteBalancelistDomain pteBalancelistDomain : pteBalancelistDomainList) {
            PteBalancelist pteBalancelist = this.createPteBalancelist(pteBalancelistDomain);
            code = pteBalancelist.getBalancelistCode();
            pteBalancelistList.add(pteBalancelist);
        }
        this.saveBalancelistBatchModel(pteBalancelistList);
        return code;
    }

    @Override
    public List<PteChannelsend> savePteBalanceamtByPteBalancelist(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.savePteBalanceamtByPteBalancelist.checkBalancelist", msg);
        }
        PteBalancelistDomain balancelistDomain = this.pteBalanceamtService.saveBalanceamtByBalancelist(pteBalancelistDomain);
        PteBalancelist pteBalancelist = this.saveBalancelistModel(balancelistDomain);
        ArrayList<PteBalancelist> list = new ArrayList<PteBalancelist>();
        list.add(pteBalancelist);
        return this.buidChannelsend(list, "insert");
    }

    @Override
    public List<PteChannelsend> savePteBalanceamtByPteBalancelistRebate(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.savePteBalanceamtByPteBalancelistRebate.checkBalancelist", msg);
        }
        PteBalancelistDomain balancelistDomain = this.pteBalanceamtService.saveBalanceamtByBalancelistRebate(pteBalancelistDomain);
        PteBalancelist pteBalancelist = this.saveBalancelistModel(balancelistDomain);
        ArrayList<PteBalancelist> list = new ArrayList<PteBalancelist>();
        list.add(pteBalancelist);
        return this.buidChannelsendRebate(list, pteBalancelistDomain.getBalanceType() + pteBalancelistDomain.getPtradeType());
    }

    @Override
    public void updateBalancelistState(Integer balancelistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == balancelistId) {
            return;
        }
        map = this.makeMap(dataState, map);
        this.updateStateBalancelistModel(balancelistId, dataState, oldDataState, map);
        this.updateStateAfter(null, null, dataState, oldDataState, balancelistId);
    }

    private Map<String, Object> makeMap(Integer dataState, Map<String, Object> map) {
        if (null == dataState) {
            return map;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != map && !map.isEmpty()) {
            param.putAll(map);
        }
        if (PteConstants.PTE_LIST_DATA_Already.equals(dataState)) {
            param.put("gmtPaySubmit", this.getSysDate());
        }
        if (PteConstants.PTE_LIST_DATA_Cancel.equals(dataState)) {
            param.put("gmtPayout", this.getSysDate());
        }
        if (PteConstants.PTE_LIST_DATA_Stay.equals(dataState)) {
            param.put("gmtPaid", this.getSysDate());
        }
        return param;
    }

    @Override
    public void updateBalancelistStateByCode(String tenantCode, String balancelistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        map = this.makeMap(dataState, map);
        this.updateStateBalancelistModelByCode(tenantCode, balancelistCode, dataState, oldDataState, map);
        this.updateStateAfter(tenantCode, balancelistCode, dataState, oldDataState, null);
    }

    private void updateStateAfter(String tenantCode, String balancelistCode, Integer dataState, Integer oldDataState, Integer balancelistId) {
        PteBalancelist balancelist = null;
        if (StringUtils.isNotBlank((String)tenantCode) && StringUtils.isNotBlank((String)balancelistCode)) {
            balancelist = this.getBalancelistByCode(tenantCode, balancelistCode);
        }
        if (null == balancelist && null != balancelistId) {
            balancelist = this.getBalancelist(balancelistId);
        }
        if (null == balancelist) {
            return;
        }
        List<PteChannelsend> pteChannelsends = null;
        if (dataState.equals(balancelist.getDataState())) {
            ArrayList<PteBalancelist> list = new ArrayList<PteBalancelist>();
            list.add(balancelist);
            String old = null == oldDataState ? "all" : String.valueOf(oldDataState);
            pteChannelsends = this.buidChannelsend(list, "updateState-" + old);
        }
        if (ListUtil.isNotEmpty(pteChannelsends)) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteChannelsends));
        }
    }

    @Override
    public void updateBalancelist(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelist.checkBalancelist", msg);
        }
        PteBalancelist oldPteBalancelist = this.getBalancelistModelById(pteBalancelistDomain.getBalancelistId());
        if (null == oldPteBalancelist) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteBalancelist pteBalancelist = this.makeBalancelist(pteBalancelistDomain, oldPteBalancelist);
        this.setBalancelistUpdataDefault(pteBalancelist);
        this.updateBalancelistModel(pteBalancelist);
    }

    @Override
    public PteBalancelist getBalancelist(Integer balancelistId) {
        if (null == balancelistId) {
            return null;
        }
        return this.getBalancelistModelById(balancelistId);
    }

    @Override
    public void deleteBalancelist(Integer balancelistId) throws ApiException {
        if (null == balancelistId) {
            return;
        }
        this.deleteBalancelistModel(balancelistId);
    }

    @Override
    public QueryResult<PteBalancelist> queryBalancelistPage(Map<String, Object> map) {
        List<PteBalancelist> pteBalancelistList = this.queryBalancelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalancelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteBalancelistList);
        return queryResult;
    }

    @Override
    public PteBalancelist getBalancelistByCode(String tenantCode, String balancelistCode) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balancelistCode", balancelistCode);
        return this.getBalancelistModelByCode(map);
    }

    @Override
    public void deleteBalancelistByCode(String tenantCode, String balancelistCode) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balancelistCode", balancelistCode);
        this.delBalancelistModelByCode(map);
    }

    private List<PteChannelsend> buidChannelsend(List<PteBalancelist> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<PteChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<PteChannelsendDomain> disChannelsendDomainList = new ArrayList<PteChannelsendDomain>();
        for (PteBalancelist promotion : pmPromotionList) {
            PteChannelsendDomain pmChannelsendDomain = new PteChannelsendDomain();
            pmChannelsendDomain.setPtradeSeqno(promotion.getBalancelistCode());
            pmChannelsendDomain.setChannelsendType("pteBalancelist");
            pmChannelsendDomain.setChannelsendDir(dri + "-" + promotion.getDataState());
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.pteChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private List<PteChannelsend> buidChannelsendRebate(List<PteBalancelist> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<PteChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<PteChannelsendDomain> disChannelsendDomainList = new ArrayList<PteChannelsendDomain>();
        for (PteBalancelist promotion : pmPromotionList) {
            PteChannelsendDomain pmChannelsendDomain = new PteChannelsendDomain();
            pmChannelsendDomain.setPtradeSeqno(promotion.getBalancelistCode());
            pmChannelsendDomain.setChannelsendType("pteBalancelist");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.pteChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public String saveTransferList(PteBalancelist pteBalancelist) {
        this.logger.error("pte.PteBalancelistServiceImpl.savesendTransferList", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalancelist));
        if (null == pteBalancelist) {
            return "error";
        }
        UpmUpointsClearDomain upmUpointsClearDomain = new UpmUpointsClearDomain();
        upmUpointsClearDomain.setMemberCode(pteBalancelist.getMemberCode());
        upmUpointsClearDomain.setMemberName(pteBalancelist.getMemberName());
        upmUpointsClearDomain.setPointsRuleApi("pte.balancelist.saveTransferList");
        upmUpointsClearDomain.setTenantCode(pteBalancelist.getTenantCode());
        upmUpointsClearDomain.setUpointsClearOpcode(pteBalancelist.getBusinessOrderno());
        upmUpointsClearDomain.setUpointsClearDirection("7");
        upmUpointsClearDomain.setUpointsClearNum(pteBalancelist.getBalanceopAmount());
        upmUpointsClearDomain.setMemberCcode(pteBalancelist.getMemberBcode());
        upmUpointsClearDomain.setMemberCname(pteBalancelist.getMemberBname());
        upmUpointsClearDomain.setUpointsListExcode(pteBalancelist.getMemberBcode());
        upmUpointsClearDomain.setUpointsListExname(pteBalancelist.getMemberBname());
        upmUpointsClearDomain.setUpointsType("1");
        upmUpointsClearDomain.setLevelUserqua("dis");
        this.saveSendUpointsClear(upmUpointsClearDomain);
        return "success";
    }

    private void saveSendUpointsClear(UpmUpointsClearDomain upmUpointsClearDomain) {
        if (null == upmUpointsClearDomain) {
            return;
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsClearDomain", JsonUtil.buildNormalBinder().toJson((Object)upmUpointsClearDomain));
        String str = this.internalInvoke("upm.upointsClearBase.sendUpointsClear", pmap);
        if (!"success".equals(str)) {
            this.logger.error("pte.PteBalancelistServiceImpl.savesendTransferList" + str, (Object)JsonUtil.buildNormalBinder().toJson((Object)upmUpointsClearDomain));
        }
    }

    @Override
    public String saveBalancelistByOc(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        this.logger.error("pte.PteBalancelistServiceImpl.sendBalancelistByOc.pteBalancelistDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalancelistDomain));
        this.saveBalancelistToByOc(pteBalancelistDomain);
        return "success";
    }

    private void saveBalancelistToByOc(PteBalancelistDomain pteBalancelistDomain) {
        if (null == pteBalancelistDomain || null == pteBalancelistDomain.getTenantCode() || null == pteBalancelistDomain.getBusinessOrderno()) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("dataState", PteConstants.PTE_LIST_DATA_STATE_0);
        param.put("tenantCode", pteBalancelistDomain.getTenantCode());
        param.put("balanceType", null == pteBalancelistDomain.getBalanceType() ? "shsettl" : pteBalancelistDomain.getBalanceType());
        param.put("balanceTime", "-1");
        param.put("businessOrderno", pteBalancelistDomain.getBusinessOrderno());
        List<PteBalancelist> pteBalancelistList = this.queryBalancelistModelPage(param);
        if (ListUtil.isEmpty(pteBalancelistList)) {
            return;
        }
        for (PteBalancelist pteBalancelist : pteBalancelistList) {
            this.updateBalancelistState(pteBalancelist.getBalancelistId(), PteConstants.PTE_LIST_DATA_Already, PteConstants.PTE_LIST_DATA_STATE_0, null);
        }
    }
}

