/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.tool;

import com.aliyuncs.AcsResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.imageseg.model.v20191230.SegmentCommodityRequest;
import com.aliyuncs.imageseg.model.v20191230.SegmentCommodityResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;

public class PgCountImagesUtils {
    protected static final SupperLogUtil logger = new SupperLogUtil(PgCountImagesUtils.class);

    public static synchronized String cutoutImages(String ossUrl, String accessKeyId, String accessKeySecret) {
        if (StringUtils.isBlank((String)ossUrl) || StringUtils.isBlank((String)accessKeyId) || StringUtils.isBlank((String)accessKeySecret)) {
            return "e";
        }
        try {
            Thread.sleep(500L);
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-shanghai", (String)accessKeyId, (String)accessKeySecret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            return PgCountImagesUtils.segmentCommodity(ossUrl, (IAcsClient)client);
        }
        catch (Exception e) {
            return "e";
        }
    }

    public static String segmentCommodity(String ossUrl, IAcsClient client) throws Exception {
        SegmentCommodityRequest req = new SegmentCommodityRequest();
        req.setImageURL(ossUrl);
        SegmentCommodityResponse resp = (SegmentCommodityResponse)PgCountImagesUtils.getAcsResponse(req, client);
        return resp.getData().getImageURL();
    }

    private static <R extends RpcAcsRequest<T>, T extends AcsResponse> T getAcsResponse(R req, IAcsClient client) throws Exception {
        try {
            return (T)client.getAcsResponse(req);
        }
        catch (ServerException e) {
            logger.error("PgCountImagesUtils.cutoutImages-getAcsResponse-service", (Object)(e.getErrCode() + "-" + e.getErrMsg()));
            throw e;
        }
        catch (ClientException e) {
            logger.error("PgCountImagesUtils.cutoutImages-getAcsResponse-client", (Object)(e.getErrCode() + "-" + e.getErrMsg()));
            throw e;
        }
        catch (Exception e) {
            logger.error("PgCountImagesUtils.cutoutImages-getAcsResponse", (Throwable)e);
            throw e;
        }
    }
}

