/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.tool.ws;

import com.yqbsoft.laser.service.pg.tool.ws.entity.Instance;
import com.yqbsoft.laser.service.pg.tool.ws.entity.PlaceSquare;
import com.yqbsoft.laser.service.pg.tool.ws.entity.Solution;
import com.yqbsoft.laser.service.pg.tool.ws.model.TabuSearch;
import com.yqbsoft.laser.service.pg.tool.ws.util.ReadDataUtil;
import java.util.Random;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Application
extends javafx.application.Application {
    private int counter = 0;

    public void start(Stage primaryStage) throws Exception {
        String path = "src/main/java/com/pick/ws/data/data1.txt";
        TabuSearch model = new TabuSearch(new ReadDataUtil().getInstance(path));
        final Solution solution = model.search();
        Instance instance = solution.getInstance();
        AnchorPane pane = new AnchorPane();
        pane = this.plot(pane, solution);
        Canvas canvas = new Canvas(instance.getL(), instance.getW());
        pane.getChildren().add((Object)canvas);
        canvas.relocate(100.0, 100.0);
        canvas = this.draw(canvas, 0.0, 0.0, instance.getL(), instance.getW());
        Button nextButton = new Button("Next +1");
        final Canvas finalCanvas = canvas;
        nextButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                try {
                    PlaceSquare placeSquare = solution.getPlaceSquareList().get(Application.this.counter);
                    Application.this.draw(finalCanvas, placeSquare.getX(), placeSquare.getY(), placeSquare.getL(), placeSquare.getW());
                    Application.this.counter++;
                }
                catch (Exception e) {
                    Alert alert = new Alert(Alert.AlertType.WARNING);
                    alert.setContentText("\u5df2\u7ecf\u6ca1\u6709\u53ef\u4ee5\u653e\u7f6e\u7684\u77e9\u5f62\u4e86\uff01");
                    alert.showAndWait();
                }
            }
        });
        pane.getChildren().add((Object)nextButton);
        primaryStage.setTitle("\u4e8c\u7ef4\u4e0b\u6599\u53ef\u89c6\u5316");
        primaryStage.setScene(new Scene((Parent)pane, 1000.0, 1000.0, (Paint)Color.AQUA));
        primaryStage.show();
    }

    private AnchorPane plot(AnchorPane pane, Solution solution) {
        System.out.println(solution);
        return pane;
    }

    private Canvas draw(Canvas canvas, double x, double y, double l, double w) {
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.setStroke((Paint)Color.BLACK);
        gc.setLineWidth(2.0);
        gc.strokeRect(x, y, l, w);
        gc.setFill((Paint)new Color(new Random().nextDouble(), new Random().nextDouble(), new Random().nextDouble(), new Random().nextDouble()));
        gc.fillRect(x, y, l, w);
        return canvas;
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

