/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.tool;

import com.yqbsoft.laser.service.pg.domain.PgCclassgoodsDomain;
import com.yqbsoft.laser.service.pg.domain.PgCclasstreeDomain;
import com.yqbsoft.laser.service.pg.domain.PgConditionDomain;
import com.yqbsoft.laser.service.pg.domain.PgGcfmgoodsDomain;
import com.yqbsoft.laser.service.pg.domain.PgGgoodsDomain;
import com.yqbsoft.laser.service.pg.domain.PgGroupDomain;
import com.yqbsoft.laser.service.pg.domain.PgLabelDomain;
import com.yqbsoft.laser.service.pg.domain.PgSettingDomain;
import com.yqbsoft.laser.service.pg.domain.ProductPortfolioDo;
import com.yqbsoft.laser.service.pg.domain.ProductPriorityFixDo;
import com.yqbsoft.laser.service.pg.tool.ws.entity.Instance;
import com.yqbsoft.laser.service.pg.tool.ws.entity.Solution;
import com.yqbsoft.laser.service.pg.tool.ws.model.TabuSearch;
import com.yqbsoft.laser.service.pg.tool.ws.util.ReadDataUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class PickUtils {
    public static final Logger log = LoggerFactory.getLogger(PickUtils.class);
    private static final String ALL_GOODS = "ALL_GOODS_LIST";
    private static final String LABEL_1 = "1";
    private static final String LABEL_2 = "2";
    private static final String LABEL_3 = "3";
    private static final Integer SORT_1 = 1;
    private static final Integer SORT_2 = 2;
    private static final Integer SCORE_0 = 0;
    private static final Integer SCORE_1 = 1;
    private static final Integer SCORE_2 = 2;
    private static final Integer SCORE_3 = 3;
    private static final BigDecimal AMOUNT_100 = new BigDecimal("100.00");
    private static final BigDecimal AMOUNT_300 = new BigDecimal("300.00");
    private static final BigDecimal AMOUNT_30 = new BigDecimal("30.00");
    private static final BigDecimal AMOUNT_005 = new BigDecimal("0.05");
    private static final BigDecimal RATE_120 = new BigDecimal("1.2");
    private static final String LABEL_USER_MAN = "\u7537";
    private static final String LABEL_USER_WOMAN = "\u5973";
    private static final String LABEL_USER_CHILD = "\u513f\u7ae5";
    private static final String LABEL_SEASON_SPSU = "\u6625\u590f";
    private static final String LABEL_SEASON_AUWI = "\u79cb\u51ac";
    private static final BigDecimal AMOUNT_0 = BigDecimal.ZERO;
    private static final String[] fixClassTreeNames1 = new String[]{"\u6d17\u8863\u6db2", "\u6d17\u8863\u51dd\u73e0", "\u6d17\u53d1\u9732", "\u624b\u52a8\u7259\u5237", "\u7259\u818f", "\u9999\u7682", "\u6db2\u4f53\u6c90\u6d74\u9732", "\u6ce1\u6cab\u6c90\u6d74\u9732", "\u6db2\u4f53\u6d17\u624b\u6db2", "\u6ce1\u6cab\u6d17\u624b\u6db2"};
    private static final String[] fixClassTreeNames2 = new String[]{"\u62a4\u8863\u7559\u9999\u73e0", "\u6d17\u8863\u7682", "\u6da6\u53d1\u7d20", "\u8eab\u4f53\u4e73", "\u514d\u6d17\u6d17\u624b\u6db2", "\u5200\u67b6", "\u5200\u5934", "\u7535\u52a8\u7259\u5237", "\u987b\u6ce1", "\u5243\u987b\u556b\u55b1"};
    private static final String[] fixClassTreeNames = new String[]{"\u6d17\u8863\u51dd\u73e0", "\u62a4\u8863\u7559\u9999\u73e0", "\u6ce1\u6cab\u6c90\u6d74\u9732", "\u53d1\u819c\u7cbe\u534e", "\u8eab\u4f53\u4e73", "\u6db2\u4f53\u6d17\u624b\u6db2"};
    private static final String nature = "Promotion Pack";
    private static final String filterLaundry = "\u6d17\u8863\u7682";
    private static final String[] laundry = new String[]{"\u6d17\u8863\u6db2", "\u6d17\u8863\u51dd\u73e0", "\u62a4\u8863\u7559\u9999\u73e0"};
    private static final String[] rejectStr = new String[]{"\u6d17\u8863\u6db2", "3", "KG"};
    private static List<MutablePair<String, Integer>> classTreeGoodsNumList = new ArrayList<MutablePair<String, Integer>>(6);
    private static Map<String, Integer> unitMap = new HashMap<String, Integer>(4);
    private static List<String[]> productSizeList = new ArrayList<String[]>(2);
    private static List<String[]> classTreeVariantList = new ArrayList<String[]>(2);
    private static List<List<Integer>> GroupPriceFlagList = new ArrayList<List<Integer>>(490637);
    private static BigDecimal budgetAmount = BigDecimal.ZERO;
    private static Integer goodsNum = 0;
    private static Integer goodsMinNum = 0;
    private static List<String> classTreeNameList = new ArrayList<String>(8);
    private static Map<String, Integer> classTreeNumMap = new HashMap<String, Integer>(8);
    private static Map<String, List<String>> classTreeBrandMap = new HashMap<String, List<String>>(8);
    private static Map<String, List<String>> classTreeSkuMap = new HashMap<String, List<String>>(8);
    private static List<String> classTreeBrandList = new ArrayList<String>(8);
    private static List<String> classTreeSkuList = new ArrayList<String>(8);
    private static List<String> classTreeNameSkuList = new ArrayList<String>(8);
    private static Map<String, List<PgLabelDomain>> fullProductMap = new HashMap<String, List<PgLabelDomain>>(8);
    private static PgSettingDomain pgSettingDomain = new PgSettingDomain();
    private static int sumNum = 0;
    private static String[] table;

    public static synchronized List<PgGroupDomain> generatorGroupByCondition(List<PgLabelDomain> pgLabelList, PgConditionDomain pgCondition) {
        log.info("\u8fdb\u5165\u9009\u54c1\u7ec4\u5957\uff0c\u5546\u54c1\u6570\uff1a" + pgLabelList.size(), (Object)JsonUtil.buildNormalBinder().toJson((Object)pgCondition));
        PickUtils.initConditionData(pgCondition);
        List<PgLabelDomain> productList = PickUtils.generatorConditionFilter(pgLabelList, pgCondition);
        log.info("\u8fc7\u6ee4\u5c0f\u4e8e\u9884\u7b97\u91d1\u989d\u53ef\u7ec4\u5957\u5546\u54c1\uff0c\u5269\u4f59\u5546\u54c1\u6570\uff1a" + productList.size());
        if (productList != null && productList.size() > 0) {
            PickUtils.generatorConditionScore(productList, pgCondition);
            productList = PickUtils.productListReject(productList, pgCondition);
            log.info("\u5254\u9664\u5c5e\u4e8e\u6240\u5c5e\u54c1\u7c7b\u7684\u540e60%\u7684\u5546\u54c1\uff0c\u5269\u4f59\u5546\u54c1\u6570\uff1a" + productList.size());
            productList = PickUtils.productListScoreSort(productList, pgCondition);
            List<PgGroupDomain> pgGroupList = PickUtils.generatorGroup2(productList, pgCondition);
            pgGroupList = PickUtils.groupSupply(pgGroupList, pgCondition);
            pgGroupList = PickUtils.groupSort(pgGroupList, pgCondition);
            return pgGroupList;
        }
        return null;
    }

    private static List<PgLabelDomain> generatorConditionFilter(List<PgLabelDomain> pgLabelList, PgConditionDomain pgCondition) {
        List<PgLabelDomain> productList = pgLabelList.stream().filter(p1 -> pgCondition.getConditionBudgetAmount().multiply(RATE_120).compareTo(p1.getLabelInsideprice()) >= 0).collect(Collectors.toList());
        String cUserLabel = pgCondition.getConditionUserlabel();
        if (!LABEL_USER_CHILD.equals(cUserLabel)) {
            productList = productList.stream().filter(p1 -> !LABEL_USER_CHILD.equals(p1.getLabelUserlabel()) || classTreeSkuList.contains(p1.getSkuCode())).collect(Collectors.toList());
        }
        if (!LABEL_USER_MAN.equals(cUserLabel)) {
            productList = productList.stream().filter(p1 -> !LABEL_USER_MAN.equals(p1.getLabelUserlabel()) || classTreeNameList.contains(p1.getClasstreeName())).collect(Collectors.toList());
        }
        if (!LABEL_USER_WOMAN.equals(cUserLabel)) {
            productList = productList.stream().filter(p1 -> !LABEL_USER_WOMAN.equals(p1.getLabelUserlabel()) || classTreeNameList.contains(p1.getClasstreeName())).collect(Collectors.toList());
        }
        if (pgCondition.getNumberOfReviews() != null && pgCondition.getNumberOfReviews() > 0) {
            productList = productList.stream().filter(p1 -> p1.getNumberOfReviews() >= pgCondition.getNumberOfReviews()).collect(Collectors.toList());
        }
        if (pgCondition.getStockFlag() != null && pgCondition.getStockFlag().booleanValue()) {
            productList = productList.stream().filter(p1 -> p1.getStockFlag() == pgCondition.getStockFlag()).collect(Collectors.toList());
        }
        return productList;
    }

    private static void initConditionData(PgConditionDomain pgCondition) {
        budgetAmount = pgCondition.getConditionBudgetAmount();
        goodsNum = pgCondition.getConditionGoodsNum();
        goodsMinNum = pgCondition.getConditionGoodsMinNum();
        classTreeNameList = new ArrayList<String>(8);
        classTreeNumMap = new HashMap<String, Integer>(8);
        classTreeBrandMap = new HashMap<String, List<String>>(8);
        classTreeSkuMap = new HashMap<String, List<String>>(8);
        classTreeBrandList = new ArrayList<String>(8);
        classTreeSkuList = new ArrayList<String>(8);
        classTreeNameSkuList = new ArrayList<String>(8);
        if (PickUtils.collectIsNotBlank(pgCondition.getPgCclasstreeDomainList()).booleanValue()) {
            for (PgCclasstreeDomain pgCclasstreeDomain : pgCondition.getPgCclasstreeDomainList()) {
                List<PgCclassgoodsDomain> tempGoodsList;
                String tempName = pgCclasstreeDomain.getCclasstreeName();
                if (!StringUtils.isNotBlank((CharSequence)tempName)) continue;
                classTreeNameList.add(tempName);
                if (PickUtils.integerIsNotBlank(pgCclasstreeDomain.getCclasstreeNum()).booleanValue()) {
                    classTreeNumMap.put(tempName, pgCclasstreeDomain.getCclasstreeNum());
                }
                if (StringUtils.isNotBlank((CharSequence)pgCclasstreeDomain.getCclasstreeBrand())) {
                    classTreeBrandMap.put(tempName, Arrays.asList(pgCclasstreeDomain.getCclasstreeBrand().split(",")));
                    classTreeBrandList.addAll(Arrays.asList(pgCclasstreeDomain.getCclasstreeBrand().split(",")));
                }
                if (!PickUtils.collectIsNotBlank(tempGoodsList = pgCclasstreeDomain.getPgCclassgoodsDomainList()).booleanValue()) continue;
                classTreeSkuMap.put(tempName, tempGoodsList.stream().map(p -> p.getSkuCode()).collect(Collectors.toList()));
                classTreeSkuList.addAll(tempGoodsList.stream().map(p -> p.getSkuCode()).collect(Collectors.toList()));
                classTreeNameSkuList.add(tempName);
            }
        }
        for (Map.Entry entry : classTreeNumMap.entrySet()) {
            if (!classTreeSkuMap.keySet().contains(entry.getKey()) || classTreeSkuMap.get(entry.getKey()).size() <= (Integer)entry.getValue()) continue;
            entry.setValue(classTreeSkuMap.get(entry.getKey()).size());
        }
        sumNum = classTreeNumMap.values().stream().reduce(Integer::sum).orElse(0);
        int skuSize = classTreeSkuMap.values().size();
        int n = classTreeNameList.size();
        sumNum = sumNum < n ? n : sumNum;
        sumNum = sumNum >= skuSize ? sumNum : skuSize;
        pgSettingDomain = pgCondition.getPgSettingDomain();
    }

    private static List<PgGroupDomain> generatorGroup2(List<PgLabelDomain> productList, PgConditionDomain pgCondition) {
        List<String> classTreeNames1 = Arrays.asList(fixClassTreeNames1);
        List<String> classTreeNames2 = Arrays.asList(fixClassTreeNames2);
        List<String> classTreeNames = new ArrayList<String>(classTreeNames1);
        Map<String, List<PgLabelDomain>> classProductMap = productList.stream().collect(Collectors.groupingBy(PgLabelDomain::getClasstreeName));
        classTreeNames.removeAll(classTreeNameList);
        ArrayList<PgGroupDomain> pgGroups = new ArrayList<PgGroupDomain>(50);
        pgCondition.setConditionBudgetAmount(budgetAmount.multiply(RATE_120));
        PickUtils.generatorConditionGroupData(pgGroups, classProductMap, pgCondition, classTreeNames, classTreeNameList);
        if (!PickUtils.collectIsNotBlank(pgGroups).booleanValue() || pgGroups.size() < 10) {
            log.info("------------\u6307\u5b9a\u54c1\u7c7b + \u4f18\u5148\u54c1\u7c7b\u7ec4\u5408 ,\u672a\u627e\u5230\u5408\u9002\u7684\u6570\u636e\uff01---------------");
            classTreeNames = new ArrayList<String>(classTreeNames2);
            PickUtils.generatorConditionGroupData(pgGroups, classProductMap, pgCondition, classTreeNames, classTreeNameList);
        }
        if (!PickUtils.collectIsNotBlank(pgGroups).booleanValue() || pgGroups.size() < 10) {
            log.info("============\u6307\u5b9a\u54c1\u7c7b + \u6b21\u4f18\u5148\u54c1\u7c7b\u7ec4\u5408 ,\u672a\u627e\u5230\u5408\u9002\u7684\u6570\u636e\uff01==============");
            classTreeNames = new ArrayList<String>(classTreeNames1);
            classTreeNames.addAll(classTreeNames2);
            PickUtils.generatorConditionGroupData(pgGroups, classProductMap, pgCondition, classTreeNames, classTreeNameList);
        }
        if (!PickUtils.collectIsNotBlank(pgGroups).booleanValue() || pgGroups.size() < 10) {
            log.info("*************\u4f18\u5148\u54c1\u7c7b + \u6b21\u4f18\u5148\u54c1\u7c7b\u7ec4\u5408 ,\u672a\u627e\u5230\u5408\u9002\u7684\u6570\u636e\uff01**************");
            classTreeNames = classProductMap.keySet().stream().collect(Collectors.toList());
            classTreeNames.removeAll(classTreeNameList);
            PickUtils.generatorConditionGroupData(pgGroups, classProductMap, pgCondition, classTreeNames, classTreeNameList);
        }
        return pgGroups;
    }

    private static List<List<String>> randomClassTreeList(List<String> randomNameList, List<String> classTreeNames, int a, int cycle) {
        boolean classFlag = false;
        ArrayList<List<String>> qls = new ArrayList<List<String>>();
        List collectSku = null;
        if (randomNameList != null) {
            collectSku = randomNameList.stream().filter(p -> classTreeNameSkuList.contains(p)).collect(Collectors.toList());
        }
        while (qls.size() < cycle) {
            ArrayList<String> ql = new ArrayList(20);
            if (PickUtils.collectIsNotBlank(randomNameList).booleanValue()) {
                Collections.shuffle(randomNameList);
                if (collectSku != null && collectSku.size() > 0) {
                    randomNameList.removeAll(collectSku);
                    randomNameList.addAll(0, collectSku);
                }
                ql = new ArrayList<String>(randomNameList);
                if (sumNum >= goodsMinNum) {
                    classFlag = true;
                    classTreeNames = randomNameList;
                }
            }
            int b = 0;
            int c = sumNum;
            while (c < a) {
                String temp = classTreeNames.get((int)(Math.random() * (double)classTreeNames.size()));
                List<String> tempABList = PickUtils.generatorProductGroupClassTreeABCheck(ql, temp);
                if (PickUtils.collectIsNotBlank(tempABList).booleanValue() && !classFlag) {
                    temp = tempABList.get((int)(Math.random() * (double)tempABList.size()));
                }
                if (!ql.contains(temp) && !classFlag) {
                    ql.add(temp);
                    ++c;
                    continue;
                }
                if (ql.contains(temp) && classFlag) {
                    ql.add(temp);
                    ++c;
                    continue;
                }
                if (++b <= 100) continue;
                b = 0;
                if (--a >= goodsMinNum) continue;
                break;
            }
            qls.add(ql);
        }
        return qls;
    }

    private static void generatorConditionGroupData(List<PgGroupDomain> pgGroupList, Map<String, List<PgLabelDomain>> classProductMap, PgConditionDomain pgCondition, List<String> randomNameList, List<String> topNameList) {
        for (int a = 0; pgGroupList.size() < 50 && a < 10; ++a) {
            PickUtils.generatorConditionGroupDataInfo(pgGroupList, classProductMap, pgCondition, randomNameList, topNameList);
        }
    }

    private static void generatorConditionGroupDataInfo(List<PgGroupDomain> pgGroupList, Map<String, List<PgLabelDomain>> classProductMap, PgConditionDomain pgCondition, List<String> randomNameList, List<String> topNameList) {
        Boolean conditionFlag = true;
        List<Object> groupClassTreesList = new ArrayList(1000);
        if (sumNum > 0 && sumNum <= goodsNum && PickUtils.collectIsNotBlank(topNameList).booleanValue()) {
            groupClassTreesList = PickUtils.randomClassTreeList(topNameList, randomNameList, goodsNum, 1000);
        } else if (sumNum == 0 || !PickUtils.collectIsNotBlank(topNameList).booleanValue()) {
            groupClassTreesList = PickUtils.randomClassTreeList(null, randomNameList, goodsNum, 1000);
            conditionFlag = false;
        }
        for (int i = 0; i < groupClassTreesList.size(); ++i) {
            List tempList = (List)groupClassTreesList.get(i);
            ArrayList<PgLabelDomain> productGroup = new ArrayList<PgLabelDomain>(20);
            for (int j = 0; j < tempList.size(); ++j) {
                int b;
                long count;
                String tempClassName = (String)tempList.get(j);
                List<PgLabelDomain> pgLabelList = classProductMap.get(tempClassName);
                if (!PickUtils.collectIsNotBlank(pgLabelList).booleanValue()) continue;
                List<String> tempSkuList = classTreeSkuMap.get(tempClassName);
                Integer tempNum = classTreeNumMap.get(tempClassName);
                List<String> tempBrandList = classTreeBrandMap.get(tempClassName);
                int a = 0;
                if (PickUtils.collectIsNotBlank(tempSkuList).booleanValue() && (count = productGroup.stream().filter(p -> tempClassName.equals(p.getClasstreeName())).count()) == 0L) {
                    List tempFilterList = pgLabelList.stream().filter(p -> tempSkuList.contains(p.getSkuCode())).collect(Collectors.toList());
                    productGroup.addAll(tempFilterList);
                    int n = a = PickUtils.collectIsNotBlank(tempFilterList) != false ? tempFilterList.size() : 0;
                }
                if (PickUtils.integerIsNotBlank(tempNum) != false && a < tempNum ? (b = PickUtils.addProduct(tempClassName, productGroup, pgLabelList, tempBrandList, pgCondition, tempNum - a)) == 1 : a == 0 && (b = PickUtils.addProduct(tempClassName, productGroup, pgLabelList, tempBrandList, pgCondition, 1)) == 1) break;
            }
            if (PickUtils.groupRejectCheck(productGroup, pgCondition, conditionFlag)) continue;
            List collect = productGroup.stream().map(p -> p.getGoodsName()).collect(Collectors.toList());
            log.info("===" + Arrays.toString(collect.toArray()) + " ---- " + PickUtils.sum(productGroup));
            List<PgGgoodsDomain> pgGoodsList = productGroup.stream().sorted(Comparator.comparing(p -> PickUtils.getStr(p.getMemo()))).map(p -> PickUtils.concatLabelToGoods(p)).collect(Collectors.toList());
            PgGroupDomain pgGroup = new PgGroupDomain();
            pgGroup.setConditionAmount(pgCondition.getConditionBudgetAmount());
            PickUtils.setGroupSortParams(pgGroup, productGroup, pgCondition);
            pgGroup.setPgGgoodsDomainList(pgGoodsList);
            pgGroup.setConditionCode(pgCondition.getConditionCode());
            pgGroup.setTenantCode(pgCondition.getTenantCode());
            pgGroup.setUserCode(pgCondition.getUserCode());
            pgGroup.setGroupLevel(String.valueOf(PickUtils.sumGoodsPrice(pgGoodsList)));
            pgGroup.setGroupTitle("\u9009\u54c1\u5957\u9910" + table[i % 26] + "(" + pgGroup.getSumSize() + "ML)");
            pgGroup.setCustomerName(pgCondition.getCustomerName());
            pgGroup.setProjectName(pgCondition.getProjectName());
            pgGroup.setRetailerName(pgCondition.getRetailerName());
            pgGroup.setUserName(pgCondition.getUserName());
            pgGroupList.add(pgGroup);
            if (pgGroupList.size() == 3) {
                pgCondition.setConditionBudgetAmount(budgetAmount);
            }
            if (pgGroupList.size() >= 50) break;
        }
    }

    private static int addProduct(String tempClassName, List<PgLabelDomain> productGroup, List<PgLabelDomain> pgLabelList, List<String> tempBrandList, PgConditionDomain pgCondition, int index) {
        int random;
        PgLabelDomain tempLabel2;
        List collect;
        if (!PickUtils.collectIsNotBlank(pgLabelList).booleanValue()) {
            return 0;
        }
        if (index <= 0) {
            return 0;
        }
        if (PickUtils.collectIsNotBlank(tempBrandList).booleanValue() && PickUtils.collectIsNotBlank(collect = pgLabelList.stream().filter(p -> tempBrandList.contains(p.getBrandName())).collect(Collectors.toList())).booleanValue()) {
            pgLabelList = collect;
        }
        if (PickUtils.generatorProductGroupRuleCheck(pgCondition, productGroup, tempLabel2 = pgLabelList.get(random = (int)(Math.random() * (double)pgLabelList.size())))) {
            Boolean flag = true;
            for (PgLabelDomain tempLabel2 : pgLabelList) {
                if (PickUtils.generatorProductGroupRuleCheck(pgCondition, productGroup, tempLabel2)) continue;
                productGroup.add(tempLabel2);
                flag = false;
                break;
            }
            if (flag.booleanValue() && PickUtils.collectIsNotBlank(pgLabelList = fullProductMap.get(tempClassName)).booleanValue()) {
                for (PgLabelDomain tempLabel2 : pgLabelList) {
                    if (PickUtils.generatorProductGroupRuleCheck(pgCondition, productGroup, tempLabel2)) continue;
                    productGroup.add(tempLabel2);
                    flag = false;
                    break;
                }
            }
        } else {
            productGroup.add(tempLabel2);
        }
        if (PickUtils.sum(productGroup).compareTo(pgCondition.getConditionBudgetAmount()) == 1) {
            return 1;
        }
        return PickUtils.addProduct(tempClassName, productGroup, pgLabelList, tempBrandList, pgCondition, --index);
    }

    private static List<PgLabelDomain> productListScoreSort(List<PgLabelDomain> productList, PgConditionDomain pgCondition) {
        productList = productList.stream().sorted(Comparator.comparing(PgLabelDomain::getSort, Comparator.reverseOrder())).collect(Collectors.toList());
        return productList;
    }

    private static List<PgLabelDomain> productListReject(List<PgLabelDomain> productList, PgConditionDomain pgCondition) {
        productList = productList.stream().filter(p -> p.getDel().equals(SCORE_0)).collect(Collectors.toList());
        fullProductMap = productList.stream().collect(Collectors.groupingBy(PgLabelDomain::getClasstreeName));
        for (Map.Entry<String, List<PgLabelDomain>> stringListEntry : fullProductMap.entrySet()) {
            List classList = stringListEntry.getValue().stream().sorted(Comparator.comparing(PgLabelDomain::getSort, Comparator.reverseOrder())).collect(Collectors.toList());
            if (classList.size() <= 10) continue;
            int fromIndex = new Double((double)classList.size() * 0.4).intValue();
            List rejectClassList = classList.subList(fromIndex, classList.size());
            List collect = rejectClassList.stream().filter(p -> classTreeSkuList.contains(p.getSkuCode())).collect(Collectors.toList());
            rejectClassList.removeAll(collect);
            productList.removeAll(rejectClassList);
        }
        return productList;
    }

    private static List<PgGroupDomain> groupSort(List<PgGroupDomain> pgGroupList, PgConditionDomain pgCondition) {
        if (pgGroupList.size() > 10) {
            List<PgGroupDomain> pgGroups = pgGroupList.subList(0, 3);
            pgGroupList = pgGroupList.subList(3, pgGroupList.size());
            pgGroupList = pgGroupList.stream().sorted((p1, p2) -> p2.getPgGgoodsDomainList().size() - p1.getPgGgoodsDomainList().size()).collect(Collectors.toList());
            pgGroupList.addAll(0, pgGroups);
        }
        pgGroupList = pgGroupList.stream().limit(10L).collect(Collectors.toList());
        String orderRule = pgCondition.getPgSettingDomain().getSettingOrderRule();
        if (LABEL_1.equals(orderRule)) {
            pgGroupList = pgGroupList.stream().sorted(Comparator.comparing(PgGroupDomain::getSumSize).reversed()).collect(Collectors.toList());
        } else if (LABEL_2.equals(orderRule)) {
            pgGroupList = pgGroupList.stream().sorted(Comparator.comparing(PgGroupDomain::getSumClass).reversed()).collect(Collectors.toList());
        } else if (LABEL_3.equals(orderRule)) {
            pgGroupList = pgGroupList.stream().sorted(Comparator.comparing(PgGroupDomain::getSumRate).reversed()).collect(Collectors.toList());
        }
        return pgGroupList;
    }

    private static List<PgGroupDomain> groupSupply(List<PgGroupDomain> pgGroupList, PgConditionDomain pgCondition) {
        String[] classTreeNames = new String[]{"\u6d17\u8863\u6db2", "\u6d17\u8863\u51dd\u73e0", "\u62a4\u8863\u7559\u9999\u73e0"};
        List<String> classTreeNameList = Arrays.asList(classTreeNames);
        return pgGroupList;
    }

    private static boolean groupRejectCheck(List<PgLabelDomain> productList, PgConditionDomain pgCondition, Boolean conditionFlag) {
        if (productList.size() == 0 || productList.size() < pgCondition.getConditionGoodsMinNum()) {
            return true;
        }
        if (conditionFlag.booleanValue() && PickUtils.generatorProductGroupConditionCheck(pgCondition, productList)) {
            return true;
        }
        if (AMOUNT_30.compareTo(budgetAmount) == -1 && productList.size() < 3) {
            return true;
        }
        if (PickUtils.groupProductBottomAmountRejectCheck(productList, pgCondition)) {
            return true;
        }
        return PickUtils.groupProductJDPriceRejectCheck(productList, pgCondition);
    }

    private static boolean groupProductJDPriceRejectCheck(List<PgLabelDomain> productList, PgConditionDomain pgCondition) {
        Integer conditionComparePriceTarget = pgCondition.getConditionComparePriceTarget();
        Boolean isCP = pgCondition.getConditionComparePrice();
        BigDecimal y = pgCondition.getConditionComLowPriceRate();
        BigDecimal budgetAmount = pgCondition.getConditionBudgetAmount();
        BigDecimal groupJDSumAmount = BigDecimal.ZERO;
        BigDecimal bottomJDAmount = BigDecimal.ZERO;
        if (isCP != null && isCP.booleanValue() && y != null && y.compareTo(BigDecimal.ONE) == -1) {
            long count = productList.stream().filter(p -> conditionComparePriceTarget == 1 ? PickUtils.toBigDecimal(p.getDisCountPrice()).compareTo(BigDecimal.ZERO) == 0 : PickUtils.toBigDecimal(p.getLabelJdprice()).compareTo(BigDecimal.ZERO) == 0).count();
            if (count == 0L) {
                bottomJDAmount = budgetAmount.divide(BigDecimal.ONE.subtract(y), 2, 4);
            } else if (count >= 1L) {
                bottomJDAmount = budgetAmount.divide(BigDecimal.ONE.subtract(y).add(AMOUNT_005), 2, 4);
            }
            for (PgLabelDomain p2 : productList) {
                BigDecimal labelJDPrice = p2.getLabelJdprice();
                if (conditionComparePriceTarget == 1) {
                    labelJDPrice = p2.getDisCountPrice();
                }
                if (labelJDPrice == null || labelJDPrice.compareTo(BigDecimal.ZERO) == 0) {
                    labelJDPrice = p2.getLabelPrefprice();
                }
                if (labelJDPrice == null || labelJDPrice.compareTo(BigDecimal.ZERO) == 0) {
                    labelJDPrice = p2.getLabelInsideprice();
                }
                groupJDSumAmount = groupJDSumAmount.add(labelJDPrice);
            }
            if (groupJDSumAmount.compareTo(bottomJDAmount) < 1) {
                return true;
            }
            List collect = productList.stream().map(p -> p.getGoodsName()).collect(Collectors.toList());
            log.info(groupJDSumAmount + "," + bottomJDAmount + " ++++++ " + PickUtils.sum(productList) + "===" + Arrays.toString(collect.toArray()));
        }
        return false;
    }

    private static boolean groupProductBottomAmountRejectCheck(List<PgLabelDomain> productList, PgConditionDomain pgCondition) {
        String settingAkdb = pgCondition.getPgSettingDomain().getSettingAkdb();
        BigDecimal x = pgCondition.getPgSettingDomain().getSettingProfitRate().divide(AMOUNT_100).setScale(4, 4);
        BigDecimal productCAP = pgCondition.getConditionBudgetAmount().divide(BigDecimal.ONE.add(x), 2, 4);
        BigDecimal bottomSumPrice = BigDecimal.ZERO;
        for (PgLabelDomain p : productList) {
            BigDecimal bottomPrice = p.getLabelInsideprice().multiply(BigDecimal.ONE.subtract(p.getLabelGflabel()).subtract(p.getLabelTtlabel()));
            if (LABEL_1.equals(settingAkdb)) {
                bottomPrice = p.getLabelInsideprice().multiply(BigDecimal.ONE.subtract(p.getLabelGflabel()).subtract(p.getLabelTtlabel()).subtract(PickUtils.toBigDecimal(p.getLabelAkbdlabel())));
            }
            bottomSumPrice = bottomSumPrice.add(bottomPrice);
        }
        if (bottomSumPrice.compareTo(productCAP) > -1) {
            return true;
        }
        BigDecimal upAmount = pgCondition.getConditionBudgetAmount().multiply(BigDecimal.ONE.subtract(x));
        BigDecimal bottomAmount = upAmount.multiply(BigDecimal.ONE.subtract(new BigDecimal("0.2")));
        log.info("\u5e95\u4ef7:{},\u4e0a\u9650:{},\u4e0b\u9650{}", new Object[]{bottomSumPrice, upAmount, bottomAmount});
        if (bottomSumPrice.compareTo(upAmount) > -1 || bottomSumPrice.compareTo(bottomAmount) == -1) {
            return true;
        }
        BigDecimal sumRete = BigDecimal.ONE.subtract(bottomSumPrice.divide(pgCondition.getConditionBudgetAmount(), 4, 4));
        return sumRete.compareTo(x) == -1;
    }

    private static void generatorConditionScore(List<PgLabelDomain> productList, PgConditionDomain pgCondition) {
        log.info("\u8fdb\u5165\u9009\u54c1\u5546\u54c1\u8bc4\u5206\u7b97\u6cd5\uff0cproductList=" + productList.size());
        List<PgCclasstreeDomain> pgCClassTreeList = pgCondition.getPgCclasstreeDomainList();
        for (PgLabelDomain p2 : productList) {
            p2.setFix(SCORE_0);
            p2.setSel(SCORE_0);
            p2.setDel(SCORE_0);
            p2.setSort(SCORE_0);
            p2.setLabelTtlabel(PickUtils.toBigDecimal(p2.getLabelTtlabel()));
            p2.setLabelGflabel(PickUtils.toBigDecimal(p2.getLabelGflabel()));
            AtomicReference<Boolean> bNature = new AtomicReference<Boolean>(true);
            if (pgCClassTreeList != null && pgCClassTreeList.size() > 0) {
                pgCClassTreeList.stream().forEach(p -> {
                    String cClassTreeName = p.getCclasstreeName();
                    if (StringUtils.isNotBlank((CharSequence)cClassTreeName)) {
                        List<String> classTreeSkus;
                        List<String> classTreeBrands;
                        String selClassTreeName2;
                        String selClassTreeName1;
                        if (cClassTreeName.equals(p2.getClasstreeName())) {
                            p2.setSel(p2.getSel() + SCORE_3);
                        }
                        if ((selClassTreeName1 = "\u7535\u52a8\u7259\u5237").equals(p2.getClasstreeName()) && AMOUNT_300.compareTo(pgCondition.getConditionBudgetAmount()) == -1) {
                            p2.setSel(p2.getSel() + SCORE_2);
                        }
                        if ((selClassTreeName2 = "\u5200\u67b6").equals(p2.getClasstreeName()) && LABEL_USER_MAN.equals(pgCondition.getConditionUserlabel())) {
                            p2.setSel(p2.getSel() + SCORE_3);
                        }
                        if (PickUtils.collectIsNotBlank(classTreeBrands = classTreeBrandMap.get(p2.getClasstreeName())).booleanValue() && classTreeBrands.contains(p2.getBrandName())) {
                            p2.setSel(p2.getSel() + SCORE_1);
                        }
                        if (cClassTreeName.equals(p2.getClasstreeName())) {
                            p2.setSel(p2.getSel() + SCORE_2);
                        }
                        if (PickUtils.collectIsNotBlank(classTreeSkus = classTreeSkuMap.get(p2.getClasstreeName())).booleanValue() && classTreeSkus.contains(p2.getSkuCode())) {
                            p2.setSel(p2.getSel() + SCORE_3);
                            bNature.set(false);
                        }
                    }
                });
            }
            if (p2.getLabelNature() != null && p2.getLabelNature().indexOf(nature) >= 0 && bNature.get().booleanValue()) {
                p2.setDel(SCORE_1);
            }
            if (StringUtils.isNotBlank((CharSequence)pgCondition.getConditionUserlabel()) && pgCondition.getConditionUserlabel().equals(p2.getLabelUserlabel())) {
                p2.setSel(p2.getSel() + SCORE_3);
            }
            if (StringUtils.isNotBlank((CharSequence)pgCondition.getConditionSeasonlabel()) && pgCondition.getConditionSeasonlabel().equals(p2.getLabelSeasonlabel())) {
                p2.setSel(p2.getSel() + SCORE_3);
            }
            if (Arrays.asList(fixClassTreeNames1).contains(p2.getClasstreeName())) {
                p2.setFix(p2.getFix() + SCORE_2);
            } else if (Arrays.asList(fixClassTreeNames2).contains(p2.getClasstreeName())) {
                p2.setFix(p2.getFix() + SCORE_1);
            }
            if (!LABEL_1.equals(pgCondition.getPgSettingDomain().getSettingPspnf())) {
                if (Arrays.asList(fixClassTreeNames).contains(p2.getClasstreeName())) {
                    p2.setFix(p2.getFix() - SCORE_1);
                }
            } else if (StringUtils.isNotBlank((CharSequence)p2.getLabelPspnf())) {
                p2.setSel(p2.getSel() + SCORE_3);
            }
            if (LABEL_1.equals(pgCondition.getPgSettingDomain().getSettingAkdb()) && p2.getLabelAkbdlabel() != null && AMOUNT_0.compareTo(p2.getLabelAkbdlabel()) == -1) {
                p2.setSel(p2.getSel() + SCORE_1);
            }
            if (StringUtils.isNotBlank((CharSequence)p2.getLabelSpaced())) {
                String fixLabel3 = p2.getLabelSpaced().toUpperCase();
                Integer fixScore3 = "S".equals(fixLabel3) ? SCORE_1 : ("P".equals(fixLabel3) ? SCORE_1 : ("A".equals(fixLabel3) ? SCORE_2 : ("C".equals(fixLabel3) ? SCORE_2 : 0)));
                p2.setFix(p2.getFix() + fixScore3);
            }
            if (StringUtils.isNotBlank((CharSequence)p2.getLabelEb())) {
                p2.setFix(p2.getFix() + SCORE_1);
            }
            PickUtils.setProductPriceAndSizeFix(p2);
            p2.setSort(p2.getSel() + p2.getFix());
        }
        PickUtils.setProductLaundryFix(productList, pgCondition);
    }

    private static void setProductPriceAndSizeFix(PgLabelDomain p2) {
        List<ProductPriorityFixDo> productPriorityFixList = PickUtils.getProductPriorityFixList();
        for (ProductPriorityFixDo fixDo : productPriorityFixList) {
            if (p2.getClasstreeName().indexOf(fixDo.getClassTreeName()) < 0 || fixDo.getMaxInsidePrice().compareTo(p2.getLabelInsideprice()) < 0 || fixDo.getMinInsidePrice().compareTo(p2.getLabelInsideprice()) > 0) continue;
            if (fixDo.getMinSize() != null && fixDo.getMaxSize() != null && p2.getLabelSizeMl() != null) {
                if (fixDo.getMaxSize().compareTo(p2.getLabelSizeMl()) < 0 || fixDo.getMinSize().compareTo(p2.getLabelSizeMl()) > 0) continue;
                p2.setFix(p2.getFix() + SCORE_1);
                continue;
            }
            p2.setFix(p2.getFix() + SCORE_1);
        }
    }

    private static void setProductLaundryFix(List<PgLabelDomain> productList, PgConditionDomain pgCondition) {
        List<PgCclasstreeDomain> classTreeList = pgCondition.getPgCclasstreeDomainList();
        List<String> laundryList = Arrays.asList(laundry);
        long cCount = 0L;
        long pCount = 0L;
        if (classTreeList != null && classTreeList.size() > 0) {
            Map<String, List<PgCclasstreeDomain>> collectMap = classTreeList.stream().filter(p -> laundryList.contains(p.getCclasstreeName())).collect(Collectors.groupingBy(PgCclasstreeDomain::getCclasstreeName));
            cCount = collectMap.values().size();
            pCount = productList.stream().filter(p -> collectMap.keySet().contains(p.getClasstreeName())).count();
        }
        if (cCount > 0L && pCount == 0L) {
            productList.stream().filter(p -> filterLaundry.equals(p.getClasstreeName())).forEach(p -> {
                p.setFix(p.getFix() + SCORE_1);
                p.setSort(p.getSel() + p.getFix());
            });
        }
    }

    private static List<PgGroupDomain> generatorGroup(List<PgLabelDomain> productList, PgConditionDomain pgCondition) {
        ArrayList<PgGroupDomain> pgGroupList = new ArrayList<PgGroupDomain>();
        BigDecimal budgetAmount = pgCondition.getConditionBudgetAmount();
        Integer goodsMinNum = pgCondition.getConditionGoodsMinNum();
        while (productList.size() > goodsMinNum) {
            ArrayList<PgLabelDomain> productGroup = new ArrayList<PgLabelDomain>();
            PickUtils.generatorProductGroup(productList, productGroup, pgCondition, 0);
            if (PickUtils.groupRejectCheck(productGroup, pgCondition, true)) continue;
            List collect = productGroup.stream().map(p -> p.getGoodsName()).collect(Collectors.toList());
            log.info(productList.size() + "===" + Arrays.toString(collect.toArray()) + " ---- " + PickUtils.sum(productGroup));
            List<PgGgoodsDomain> pgGoodsList = productGroup.stream().map(p -> PickUtils.concatLabelToGoods(p)).collect(Collectors.toList());
            PgGroupDomain pgGroup = new PgGroupDomain();
            PickUtils.setGroupSortParams(pgGroup, productGroup, pgCondition);
            pgGroup.setPgGgoodsDomainList(pgGoodsList);
            pgGroup.setGroupTitle("\u4ef7\u503c" + PickUtils.sum(productGroup) + "\u5143\u5927\u793c\u5305");
            pgGroupList.add(pgGroup);
        }
        return pgGroupList;
    }

    private static void setGroupSortParams(PgGroupDomain pgGroup, List<PgLabelDomain> productGroup, PgConditionDomain pgCondition) {
        BigDecimal sumSize = productGroup.stream().map(p -> {
            if (p.getLabelSize() == null) {
                p.setLabelSize(BigDecimal.ZERO);
            }
            if ("KG".equals(p.getLabelSizeUnit())) {
                p.setLabelSize(p.getLabelSize().multiply(new BigDecimal("1000")));
                p.setLabelSizeUnit("G");
            } else if ("L".equals(p.getLabelSizeUnit())) {
                p.setLabelSize(p.getLabelSize().multiply(new BigDecimal("1000")));
                p.setLabelSizeUnit("ML");
            } else if (!"G".equals(p.getLabelSizeUnit()) && !"ML".equals(p.getLabelSizeUnit())) {
                p.setLabelSize(BigDecimal.ZERO);
            }
            return p.getLabelSize();
        }).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(0, 0);
        long sumClass = productGroup.stream().map(p -> p.getClasstreeName()).distinct().count();
        BigDecimal productBottomAmount = BigDecimal.ZERO;
        productBottomAmount = LABEL_1.equals(pgSettingDomain.getSettingAkdb()) ? productGroup.stream().map(p -> p.getLabelInsideprice().multiply(BigDecimal.ONE.subtract(p.getLabelGflabel()).subtract(p.getLabelTtlabel()).subtract(PickUtils.toBigDecimal(p.getLabelAkbdlabel())))).reduce(BigDecimal.ZERO, BigDecimal::add) : productGroup.stream().map(p -> p.getLabelInsideprice().multiply(BigDecimal.ONE.subtract(p.getLabelGflabel()).subtract(p.getLabelTtlabel()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumRete = BigDecimal.ONE.subtract(productBottomAmount.divide(pgGroup.getConditionAmount(), 4, 4));
        pgGroup.setSumSize(sumSize);
        pgGroup.setSumClass(sumClass);
        pgGroup.setSumRate(sumRete);
    }

    private static List<PgGroupDomain> generatorGroup1(List<PgLabelDomain> productList, PgConditionDomain pgCondition) {
        long startTime = System.currentTimeMillis();
        ArrayList<PgGroupDomain> pgGroupList = new ArrayList<PgGroupDomain>();
        BigDecimal budgetAmount = pgCondition.getConditionBudgetAmount();
        Integer goodsNum = pgCondition.getConditionGoodsNum();
        Integer goodsMinNum = pgCondition.getConditionGoodsMinNum();
        Map<Integer, List<PgLabelDomain>> classMap = productList.stream().collect(Collectors.groupingBy(p -> (p.getLabelInsideprice().intValue() / 3 + 1) * 3));
        List<Integer> priceList = classMap.keySet().stream().sorted().collect(Collectors.toList());
        int len = priceList.size();
        ArrayDeque<Integer> path = new ArrayDeque<Integer>(len);
        if (GroupPriceFlagList == null || GroupPriceFlagList.size() == 0 || pgCondition.getCache().equals(0)) {
            PickUtils.generatorGroupPriceFlag(priceList, len, 0, budgetAmount.multiply(new BigDecimal("1.2")).intValue(), path, GroupPriceFlagList, goodsMinNum, goodsNum);
        }
        for (int i = 0; i < GroupPriceFlagList.size(); ++i) {
            List<Integer> item = GroupPriceFlagList.get(i);
            ArrayList<PgLabelDomain> productGroup = new ArrayList<PgLabelDomain>();
            block1: for (int j = 0; j < item.size(); ++j) {
                int iv = item.get(j);
                List<PgLabelDomain> pgLabels = classMap.get(iv);
                if (pgLabels == null) continue;
                for (int k = 0; k < pgLabels.size(); ++k) {
                    PgLabelDomain tempLabel = pgLabels.get(k);
                    if (PickUtils.generatorProductGroupRuleCheck(pgCondition, productGroup, tempLabel)) continue;
                    productGroup.add(tempLabel);
                    continue block1;
                }
            }
            if (PickUtils.groupRejectCheck(productGroup, pgCondition, true)) continue;
            List collect = productGroup.stream().map(p -> p.getGoodsName()).collect(Collectors.toList());
            log.info(productList.size() + "===" + Arrays.toString(collect.toArray()) + " ---- " + PickUtils.sum(productGroup));
            List<PgGgoodsDomain> pgGoodsList = productGroup.stream().map(p -> PickUtils.concatLabelToGoods(p)).collect(Collectors.toList());
            PgGroupDomain pgGroup = new PgGroupDomain();
            PickUtils.setGroupSortParams(pgGroup, productGroup, pgCondition);
            pgGroup.setPgGgoodsDomainList(pgGoodsList);
            pgGroup.setConditionCode(pgCondition.getConditionCode());
            pgGroup.setTenantCode(pgCondition.getTenantCode());
            pgGroup.setGroupTitle("\u4ef7\u503c" + PickUtils.sum(productGroup) + "\u5143\u5927\u793c\u5305");
            pgGroupList.add(pgGroup);
            if (pgGroupList.size() > 50) break;
        }
        long endTime = System.currentTimeMillis();
        System.out.println("\u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
        return pgGroupList;
    }

    private static void generatorGroupPriceFlag(List<Integer> productList, int len, int begin, Integer target, Deque<Integer> path, List<List<Integer>> res, int min, int max) {
        if (target.doubleValue() == 0.0) {
            if (path.size() > max || path.size() < min) {
                return;
            }
            res.add(new ArrayList<Integer>(path));
            return;
        }
        for (int i = begin; i < len && target - productList.get(i) >= 0; ++i) {
            if (i > begin && productList.get(i) - productList.get(i - 1) == 0) continue;
            path.addLast(productList.get(i));
            PickUtils.generatorGroupPriceFlag(productList, len, i + 1, target - productList.get(i), path, res, min, max);
            path.removeLast();
        }
    }

    private static void generatorProductGroup(List<PgLabelDomain> productList, List<PgLabelDomain> productGroup, PgConditionDomain pgCondition, Integer index) {
        BigDecimal maxAmount = pgCondition.getConditionBudgetAmount();
        Integer goodsNum = pgCondition.getConditionGoodsNum();
        Integer goodsMinNum = pgCondition.getConditionGoodsMinNum();
        String cUserLabel = pgCondition.getConditionUserlabel();
        String cSeasonLabel = pgCondition.getConditionSeasonlabel();
        ArrayList<String> classTreeNameList = new ArrayList<String>(8);
        ArrayList<String> classTreeBrandList = new ArrayList<String>(8);
        List<PgCclasstreeDomain> classTreeList = pgCondition.getPgCclasstreeDomainList();
        if (classTreeList != null && classTreeList.size() > 0) {
            for (PgCclasstreeDomain classTree : classTreeList) {
                classTreeNameList.add(classTree.getCclasstreeName());
                if (!StringUtils.isNotBlank((CharSequence)classTree.getCclasstreeBrand())) continue;
                classTreeBrandList.addAll(Arrays.asList(classTree.getCclasstreeBrand().split(",")));
            }
        }
        if (productList.size() < goodsMinNum) {
            productList.removeAll(productGroup);
            return;
        }
        if (PickUtils.sum(productGroup).compareTo(maxAmount) == 0) {
            productList.removeAll(productGroup);
            return;
        }
        if (index.intValue() == productList.size()) {
            productList.removeAll(productGroup);
            return;
        }
        if (productGroup.size() == productList.size() && PickUtils.sum(productGroup).compareTo(maxAmount) <= 0) {
            productList.removeAll(productGroup);
            return;
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        ArrayList<PgLabelDomain> temp = new ArrayList<PgLabelDomain>();
        ArrayList<PgLabelDomain> temp2 = new ArrayList<PgLabelDomain>();
        for (int i = 0; i < productList.size(); ++i) {
            PgLabelDomain tempProduct2 = productList.get(i);
            if ((sumAmount = sumAmount.add(PickUtils.getPrice(tempProduct2))).compareTo(maxAmount) == 1) {
                sumAmount = BigDecimal.ZERO;
                continue;
            }
            if (PickUtils.generatorProductGroupRuleCheck(pgCondition, temp, tempProduct2)) continue;
            temp.add(tempProduct2);
            for (int j = index + 1; j < productList.size() && j != i; ++j) {
                PgLabelDomain tempProduct = productList.get(j);
                if (PickUtils.sum(temp).add(PickUtils.getPrice(tempProduct)).compareTo(maxAmount) == 1 || PickUtils.generatorProductGroupRuleCheck(pgCondition, temp, tempProduct)) continue;
                temp.add(tempProduct);
                if (sumAmount.subtract(maxAmount).abs().compareTo(PickUtils.sum(temp).subtract(maxAmount).abs()) == -1) {
                    temp.remove(tempProduct);
                    continue;
                }
                sumAmount = PickUtils.sum(temp);
            }
            sumAmount = BigDecimal.ZERO;
            if (PickUtils.sum(temp).subtract(maxAmount).abs().compareTo(PickUtils.sum(temp2).subtract(maxAmount).abs()) == -1) {
                temp2.clear();
                temp2.addAll(temp);
            }
            temp.clear();
        }
        if (PickUtils.sum(temp2).subtract(maxAmount).abs().compareTo(PickUtils.sum(productGroup).subtract(maxAmount).abs()) == -1) {
            productGroup.clear();
            productGroup.addAll(temp2);
        }
        index = index + 1;
        PickUtils.generatorProductGroup(productList, productGroup, pgCondition, index);
    }

    private static boolean generatorProductGroupRuleCheck(PgConditionDomain pgCondition, List<PgLabelDomain> tempList, PgLabelDomain tempProduct) {
        if (PickUtils.generatorProductGroupXYYRejectCheck(tempList, tempProduct)) {
            return true;
        }
        if (pgCondition.getConditionGoodsNum() != null && tempList.size() >= pgCondition.getConditionGoodsNum()) {
            return true;
        }
        if (PickUtils.generatorProductGroupClassTreeCheck(pgCondition, tempList, tempProduct)) {
            return true;
        }
        if (PickUtils.generatorProductGroupClassTreeNumCheck(pgCondition, tempList, tempProduct).booleanValue()) {
            return true;
        }
        if (PickUtils.generatorProductGroupVariantCheck(tempList, tempProduct).booleanValue()) {
            return true;
        }
        return PickUtils.generatorProductGroupSizeCheck(tempList, tempProduct);
    }

    private static boolean generatorProductGroupConditionCheck(PgConditionDomain pgCondition, List<PgLabelDomain> tempList) {
        int a = 0;
        List collectClass = tempList.stream().map(p -> PickUtils.getStr(p.getClasstreeName())).collect(Collectors.toList());
        for (String string : classTreeNameList) {
            if (!collectClass.contains(string)) continue;
            ++a;
        }
        if (a == 0 && !PickUtils.collectIsNotBlank(collectClass).booleanValue() || a < classTreeNameList.size()) {
            return true;
        }
        a = 0;
        List collectBrand = tempList.stream().map(p -> PickUtils.getStr(p.getBrandName())).collect(Collectors.toList());
        for (String p3 : classTreeBrandList) {
            if (!collectBrand.contains(p3)) continue;
            ++a;
        }
        if (a == 0 && !PickUtils.collectIsNotBlank(collectBrand).booleanValue() || a < classTreeBrandList.size()) {
            return true;
        }
        a = 0;
        List list = tempList.stream().map(p -> PickUtils.getStr(p.getSkuCode())).collect(Collectors.toList());
        for (String p4 : classTreeSkuList) {
            if (!list.contains(p4)) continue;
            ++a;
        }
        return a == 0 && PickUtils.collectIsNotBlank(list) == false || a < classTreeSkuList.size();
    }

    private static boolean generatorProductGroupXYYRejectCheck(List<PgLabelDomain> tempList, PgLabelDomain tempProduct) {
        String rejectName = rejectStr[0];
        BigDecimal labelSize = BigDecimal.ZERO;
        for (PgLabelDomain p2 : tempList) {
            if (!rejectName.equals(p2.getClasstreeName())) continue;
            labelSize = labelSize.add(p2.getLabelSizeMl() == null ? BigDecimal.ZERO : p2.getLabelSizeMl());
            Integer rejectSize = Integer.valueOf(rejectStr[1]) * unitMap.get(rejectStr[2].toUpperCase());
            if (BigDecimal.valueOf(rejectSize.intValue()).compareTo(labelSize) != -1) continue;
            return true;
        }
        return false;
    }

    private static boolean generatorProductGroupClassTreeCheck(PgConditionDomain pgCondition, List<PgLabelDomain> tempList, PgLabelDomain tempProduct) {
        tempList.add(tempProduct);
        Map<String, Long> collect = tempList.stream().collect(Collectors.groupingBy(p -> p.getClasstreeName(), Collectors.counting()));
        for (Map.Entry<String, Long> p2 : collect.entrySet()) {
            if (classTreeNumMap.keySet().contains(p2.getKey())) continue;
            for (MutablePair<String, Integer> p1 : classTreeGoodsNumList) {
                String left = (String)p1.left;
                Integer right = (Integer)p1.right;
                if (left.equals(p2.getKey()) && right < p2.getValue().intValue()) {
                    tempList.remove(tempProduct);
                    return true;
                }
                if (!"\u5176\u4f59\u7c7b\u76ee".equals(left) || right >= p2.getValue().intValue()) continue;
                tempList.remove(tempProduct);
                return true;
            }
        }
        tempList.remove(tempProduct);
        return false;
    }

    private static boolean generatorProductGroupClassTreeABCheck(List<PgLabelDomain> tempList, PgLabelDomain tempProduct) {
        return false;
    }

    private static List<String> generatorProductGroupClassTreeABCheck(List<String> tempList, String temp) {
        List<ProductPortfolioDo> productPortfolioList = PickUtils.getProductPortfolioList();
        for (int i = 0; i < tempList.size(); ++i) {
            String p2 = tempList.get(i);
            for (ProductPortfolioDo p1 : productPortfolioList) {
                long countP22;
                long countP12;
                List<String> tsList = Arrays.asList(p1.getSecondClassTreeName());
                List<String> firstClassTreeName = Arrays.asList(p1.getFirstClassTreeName());
                if (firstClassTreeName.contains(p2) && (countP12 = tempList.stream().filter(p12 -> tsList.contains(p12)).count()) == 0L) {
                    return tsList;
                }
                if (!tsList.contains(p2) || (countP22 = tempList.stream().filter(p12 -> firstClassTreeName.contains(p12)).count()) != 0L) continue;
                return firstClassTreeName;
            }
        }
        return null;
    }

    private static boolean generatorProductGroupSizeCheck(List<PgLabelDomain> tempList, PgLabelDomain tempProduct) {
        ArrayList<String> tsList = new ArrayList();
        for (String[] p1 : productSizeList) {
            tsList = Arrays.asList(p1);
            for (PgLabelDomain p2 : tempList) {
                Integer a = PickUtils.indexStrExistCollection(tsList, p2.getClasstreeName());
                Integer b = PickUtils.indexStrExistCollection(tsList, tempProduct.getClasstreeName());
                if (a == null || b == null) continue;
                if (a < b && PickUtils.getNum(p2.getLabelSizeMl()).compareTo(PickUtils.getNum(tempProduct.getLabelSizeMl())) != 1) {
                    return true;
                }
                if (b >= a || PickUtils.getNum(tempProduct.getLabelSizeMl()).compareTo(PickUtils.getNum(p2.getLabelSizeMl())) == 1) continue;
                return true;
            }
        }
        return false;
    }

    private static BigDecimal getMaxNum(List<PgLabelDomain> tempList) {
        return tempList.stream().max(Comparator.comparing(p -> PickUtils.getNum(p.getLabelSizeMl()))).get().getLabelSizeMl();
    }

    private static Integer indexStrExistCollection(List<String> tsList, String className) {
        for (int i = 0; i < tsList.size(); ++i) {
            if (className.indexOf(tsList.get(i)) < 0) continue;
            return i;
        }
        return null;
    }

    private static Boolean generatorProductGroupVariantCheck(List<PgLabelDomain> tempList, PgLabelDomain tempProduct) {
        int a = 0;
        for (String[] p1 : classTreeVariantList) {
            ArrayList<String> tsList = new ArrayList<String>(Arrays.asList(p1));
            for (PgLabelDomain p2 : tempList) {
                String productVariant;
                if (a != 0 || !tsList.contains(p2.getClasstreeName())) continue;
                List collect = tempList.stream().filter(p -> p2.getClasstreeName().equals(p.getClasstreeName())).map(p -> p.getProductVariant()).collect(Collectors.toList());
                ++a;
                tsList.remove(p2.getClasstreeName());
                String string = productVariant = tempProduct.getProductVariant() == null ? "" : tempProduct.getProductVariant();
                if (!tsList.contains(tempProduct.getClasstreeName()) || collect.contains(productVariant)) continue;
                return true;
            }
        }
        return false;
    }

    private static Boolean generatorProductGroupClassTreeNumCheck(PgConditionDomain pgCondition, List<PgLabelDomain> tempList, PgLabelDomain tempProduct2) {
        Boolean b = false;
        return b;
    }

    private static BigDecimal sum(List<PgLabelDomain> pgLabelList) {
        return pgLabelList.stream().map(PgLabelDomain::getLabelInsideprice).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private static BigDecimal sumGoodsPrice(List<PgGgoodsDomain> pgLabelList) {
        return pgLabelList.stream().map(PgGgoodsDomain::getPricesetNprice).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(0, 4);
    }

    private static BigDecimal getNum(BigDecimal num) {
        return num == null ? BigDecimal.ZERO : num;
    }

    private static String getStr(String strObj) {
        return strObj == null ? "" : strObj;
    }

    private static Boolean collectIsNotBlank(Collection collection) {
        return collection != null && collection.size() > 0;
    }

    private static Boolean integerIsNotBlank(Integer a) {
        return a != null && a > 0;
    }

    private static BigDecimal getPrice(PgLabelDomain pgLabel) {
        return pgLabel.getLabelInsideprice();
    }

    private static PgGgoodsDomain concatLabelToGoods(PgLabelDomain pgLabel) {
        PgGgoodsDomain pgGgoods = new PgGgoodsDomain();
        BeanUtils.copyProperties((Object)pgLabel, (Object)pgGgoods);
        BigDecimal tempPrice = BigDecimal.ZERO;
        tempPrice = LABEL_1.equals(pgSettingDomain.getSettingAkdb()) ? pgLabel.getLabelInsideprice().multiply(BigDecimal.ONE.subtract(pgLabel.getLabelGflabel()).subtract(pgLabel.getLabelTtlabel()).subtract(PickUtils.toBigDecimal(pgLabel.getLabelAkbdlabel()))) : pgLabel.getLabelInsideprice().multiply(BigDecimal.ONE.subtract(pgLabel.getLabelGflabel()).subtract(pgLabel.getLabelTtlabel()));
        pgGgoods.setLabelInsideprice(tempPrice.setScale(2, 4));
        pgGgoods.setLabelNature(pgLabel.getGoodsRemark());
        return pgGgoods;
    }

    private static List<ProductPriorityFixDo> getProductPriorityFixList() {
        ArrayList<ProductPriorityFixDo> ppFixList = new ArrayList<ProductPriorityFixDo>(9);
        ppFixList.add(new ProductPriorityFixDo("\u6d17\u53d1\u9732", new BigDecimal("30"), new BigDecimal("60"), new BigDecimal("400"), new BigDecimal("750")));
        ppFixList.add(new ProductPriorityFixDo("\u6da6\u53d1\u7d20", new BigDecimal("30"), new BigDecimal("60"), new BigDecimal("400"), new BigDecimal("750")));
        ppFixList.add(new ProductPriorityFixDo("\u6c90\u6d74\u9732", new BigDecimal("15"), new BigDecimal("45"), new BigDecimal("200"), new BigDecimal("720")));
        ppFixList.add(new ProductPriorityFixDo("\u6d17\u624b\u6db2", new BigDecimal("15"), new BigDecimal("30"), new BigDecimal("150"), new BigDecimal("500")));
        ppFixList.add(new ProductPriorityFixDo("\u9999\u7682", new BigDecimal("5"), new BigDecimal("20"), null, null));
        ppFixList.add(new ProductPriorityFixDo("\u7259\u818f", new BigDecimal("10"), new BigDecimal("15"), new BigDecimal("100"), new BigDecimal("200")));
        ppFixList.add(new ProductPriorityFixDo("\u7259\u5237", new BigDecimal("5"), new BigDecimal("20"), null, null));
        ppFixList.add(new ProductPriorityFixDo("\u6d17\u8863\u6db2", new BigDecimal("30"), new BigDecimal("60"), new BigDecimal("2000"), new BigDecimal("3000")));
        ppFixList.add(new ProductPriorityFixDo(filterLaundry, new BigDecimal("0"), new BigDecimal("10"), new BigDecimal("800"), new BigDecimal("2500")));
        return ppFixList;
    }

    private static List<ProductPortfolioDo> getProductPortfolioList() {
        ArrayList<ProductPortfolioDo> ppList = new ArrayList<ProductPortfolioDo>(10);
        ppList.add(new ProductPortfolioDo(new String[]{"\u6d17\u53d1\u9732"}, new String[]{"\u6da6\u53d1\u7d20", "\u53d1\u819c\u7cbe\u534e"}));
        ppList.add(new ProductPortfolioDo(new String[]{"\u7259\u818f"}, new String[]{"\u624b\u52a8\u7259\u5237", "\u7535\u52a8\u7259\u5237"}));
        ppList.add(new ProductPortfolioDo(new String[]{"\u6d17\u8863\u6db2", "\u6d17\u8863\u51dd\u73e0"}, new String[]{"\u62a4\u8863\u7559\u9999\u73e0", "\u8863\u7269\u9664\u83cc\u6db2"}));
        ppList.add(new ProductPortfolioDo(new String[]{"\u5200\u67b6"}, new String[]{"\u5200\u5934", "\u987b\u6ce1"}));
        ppList.add(new ProductPortfolioDo(new String[]{"\u7535\u52a8\u7259\u5237"}, new String[]{"\u5237\u5934"}));
        ppList.add(new ProductPortfolioDo(new String[]{"\u536b\u751f\u5dfe"}, new String[]{"\u536b\u751f\u6e7f\u5dfe"}));
        return ppList;
    }

    public static Double[] calculateGroupPackSize(List<PgGcfmgoodsDomain> goodsDomainList) {
        Double[] packSize = new Double[3];
        try {
            Instance instance = new ReadDataUtil().getInstance(goodsDomainList, true);
            System.out.println("packSize = " + instance);
            if (instance == null) {
                return new Double[]{0.0, 0.0, 0.0};
            }
            TabuSearch model = new TabuSearch(instance);
            Solution solution = model.search();
            packSize = new Double[]{solution.getInstance().getL(), solution.getInstance().getW(), solution.getInstance().getH()};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packSize;
    }

    public static BigDecimal toBigDecimal(Object value) {
        String str;
        BigDecimal bigDec = null;
        bigDec = value != null ? (value instanceof BigDecimal ? (BigDecimal)value : (value instanceof String ? (PickUtils.isNumeric(str = (String)value) ? new BigDecimal(str) : BigDecimal.ZERO) : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : (value instanceof Number ? new BigDecimal(((Number)value).doubleValue()) : BigDecimal.ZERO)))) : BigDecimal.ZERO;
        return bigDec;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("-?[0-9]+\\.?[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    static {
        unitMap.put("KG", 1000);
        unitMap.put("M", 1000);
        unitMap.put("G", 1);
        unitMap.put("ML", 1);
        classTreeGoodsNumList.add((MutablePair<String, Integer>)MutablePair.of((Object)"\u6da6\u53d1\u7d20", (Object)1));
        classTreeGoodsNumList.add((MutablePair<String, Integer>)MutablePair.of((Object)"\u6d17\u8863\u6db2", (Object)1));
        classTreeGoodsNumList.add((MutablePair<String, Integer>)MutablePair.of((Object)"\u624b\u52a8\u7259\u5237", (Object)1));
        classTreeGoodsNumList.add((MutablePair<String, Integer>)MutablePair.of((Object)"\u7535\u52a8\u7259\u5237", (Object)1));
        classTreeGoodsNumList.add((MutablePair<String, Integer>)MutablePair.of((Object)"\u8863\u7269\u9664\u83cc\u6db2", (Object)1));
        classTreeGoodsNumList.add((MutablePair<String, Integer>)MutablePair.of((Object)"\u6d17\u8863\u51dd\u73e0", (Object)1));
        classTreeGoodsNumList.add((MutablePair<String, Integer>)MutablePair.of((Object)"\u5176\u4f59\u7c7b\u76ee", (Object)2));
        productSizeList.add(new String[]{"\u6d17\u53d1\u9732", "\u6da6\u53d1\u7d20"});
        productSizeList.add(new String[]{"\u6c90\u6d74\u9732", "\u6d17\u624b\u6db2"});
        classTreeVariantList.add(new String[]{"\u6d17\u53d1\u9732", "\u6da6\u53d1\u7d20"});
        classTreeVariantList.add(new String[]{"\u5200\u67b6", "\u5200\u5934"});
        table = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    }
}

