/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgGgoodsMapper;
import com.yqbsoft.laser.service.pg.domain.FmFileDomainBean;
import com.yqbsoft.laser.service.pg.domain.FmFileReDomainBean;
import com.yqbsoft.laser.service.pg.domain.PgGgoodsDomain;
import com.yqbsoft.laser.service.pg.domain.PgGgoodsReDomain;
import com.yqbsoft.laser.service.pg.model.PgGgoods;
import com.yqbsoft.laser.service.pg.service.PgGgoodsService;
import com.yqbsoft.laser.service.pg.tool.PgCountImagesUtils;
import com.yqbsoft.laser.service.pg.tool.PgOssUtils;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgGgoodsServiceImpl
extends BaseServiceImpl
implements PgGgoodsService {
    private static final String SYS_CODE = "pg.PICK.PgGgoodsServiceImpl";
    private static final String prvUrl = "/paas/shop/";
    private PgGgoodsMapper pgGgoodsMapper;

    public void setPgGgoodsMapper(PgGgoodsMapper pgGgoodsMapper) {
        this.pgGgoodsMapper = pgGgoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgGgoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGgoods(PgGgoodsDomain pgGgoodsDomain) {
        if (null == pgGgoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgGgoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGgoodsDefault(PgGgoods pgGgoods) {
        if (null == pgGgoods) {
            return;
        }
        if (null == pgGgoods.getDataState()) {
            pgGgoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgGgoods.getGmtCreate()) {
            pgGgoods.setGmtCreate(date);
        }
        pgGgoods.setGmtModified(date);
        if (StringUtils.isBlank((String)pgGgoods.getGgoodsCode())) {
            pgGgoods.setGgoodsCode(this.getNo(null, "PgGgoods", "pgGgoods", pgGgoods.getTenantCode()));
        }
    }

    private int getGgoodsMaxCode() {
        int code = 0;
        try {
            return this.pgGgoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.getGgoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGgoodsUpdataDefault(PgGgoods pgGgoods) {
        if (null == pgGgoods) {
            return;
        }
        pgGgoods.setGmtModified(this.getSysDate());
    }

    private void saveGgoodsModel(PgGgoods pgGgoods) throws ApiException {
        if (null == pgGgoods) {
            return;
        }
        try {
            this.pgGgoodsMapper.insert(pgGgoods);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.saveGgoodsModel.ex", (Throwable)e);
        }
    }

    private void saveGgoodsBatchModel(List<PgGgoods> pgGgoodsList) throws ApiException {
        if (null == pgGgoodsList || pgGgoodsList.isEmpty()) {
            return;
        }
        try {
            this.pgGgoodsMapper.insertBatch(pgGgoodsList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.saveGgoodsBatchModel.ex", (Throwable)e);
        }
    }

    private PgGgoods getGgoodsModelById(Integer ggoodsId) {
        if (null == ggoodsId) {
            return null;
        }
        try {
            return this.pgGgoodsMapper.selectByPrimaryKey(ggoodsId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.getGgoodsModelById", (Throwable)e);
            return null;
        }
    }

    private PgGgoods getGgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgGgoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.getGgoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGgoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGgoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.delGgoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.delGgoodsModelByCode.num");
        }
    }

    private void deleteGgoodsModel(Integer ggoodsId) throws ApiException {
        if (null == ggoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGgoodsMapper.deleteByPrimaryKey(ggoodsId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.deleteGgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.deleteGgoodsModel.num");
        }
    }

    private void updateGgoodsModel(PgGgoods pgGgoods) throws ApiException {
        if (null == pgGgoods) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGgoodsMapper.updateByPrimaryKey(pgGgoods);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.updateGgoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.updateGgoodsModel.num");
        }
    }

    private void updateStateGgoodsModel(Integer ggoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ggoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ggoodsId", ggoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGgoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.updateStateGgoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.updateStateGgoodsModel.null");
        }
    }

    private void updateStateGgoodsModelByCode(String tenantCode, String ggoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ggoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ggoodsCode", ggoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGgoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.updateStateGgoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.updateStateGgoodsModelByCode.null");
        }
    }

    private PgGgoods makeGgoods(PgGgoodsDomain pgGgoodsDomain, PgGgoods pgGgoods) {
        if (null == pgGgoodsDomain) {
            return null;
        }
        if (null == pgGgoods) {
            pgGgoods = new PgGgoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgGgoods, (Object)pgGgoodsDomain);
            return pgGgoods;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.makeGgoods", (Throwable)e);
            return null;
        }
    }

    private PgGgoodsReDomain makePgGgoodsReDomain(PgGgoods pgGgoods) {
        if (null == pgGgoods) {
            return null;
        }
        PgGgoodsReDomain pgGgoodsReDomain = new PgGgoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgGgoodsReDomain, (Object)pgGgoods);
            return pgGgoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.makePgGgoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgGgoods> queryGgoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGgoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.queryGgoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countGgoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgGgoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.countGgoods", (Throwable)e);
        }
        return i;
    }

    private PgGgoods createPgGgoods(PgGgoodsDomain pgGgoodsDomain) {
        String msg = this.checkGgoods(pgGgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.saveGgoods.checkGgoods", msg);
        }
        PgGgoods pgGgoods = this.makeGgoods(pgGgoodsDomain, null);
        this.setGgoodsDefault(pgGgoods);
        return pgGgoods;
    }

    @Override
    public String saveGgoods(PgGgoodsDomain pgGgoodsDomain) throws ApiException {
        PgGgoods pgGgoods = this.createPgGgoods(pgGgoodsDomain);
        this.saveGgoodsModel(pgGgoods);
        return pgGgoods.getGgoodsCode();
    }

    @Override
    public String saveGgoodsBatch(List<PgGgoodsDomain> pgGgoodsDomainList) throws ApiException {
        if (null == pgGgoodsDomainList || pgGgoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgGgoods> pgGgoodsList = new ArrayList<PgGgoods>();
        String code = "";
        for (PgGgoodsDomain pgGgoodsDomain : pgGgoodsDomainList) {
            PgGgoods pgGgoods = this.createPgGgoods(pgGgoodsDomain);
            code = pgGgoods.getGgoodsCode();
            pgGgoodsList.add(pgGgoods);
        }
        this.saveGgoodsBatchModel(pgGgoodsList);
        return code;
    }

    @Override
    public void updateGgoodsState(Integer ggoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ggoodsId) {
            return;
        }
        this.updateStateGgoodsModel(ggoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateGgoodsStateByCode(String tenantCode, String ggoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ggoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGgoodsModelByCode(tenantCode, ggoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGgoods(PgGgoodsDomain pgGgoodsDomain) throws ApiException {
        String msg = this.checkGgoods(pgGgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.updateGgoods.checkGgoods", msg);
        }
        PgGgoods oldPgGgoods = this.getGgoodsModelById(pgGgoodsDomain.getGgoodsId());
        if (null == oldPgGgoods) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.updateGgoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgGgoods pgGgoods = this.makeGgoods(pgGgoodsDomain, oldPgGgoods);
        this.setGgoodsUpdataDefault(pgGgoods);
        this.updateGgoodsModel(pgGgoods);
    }

    @Override
    public PgGgoods getGgoods(Integer ggoodsId) {
        if (null == ggoodsId) {
            return null;
        }
        return this.getGgoodsModelById(ggoodsId);
    }

    @Override
    public void deleteGgoods(Integer ggoodsId) throws ApiException {
        if (null == ggoodsId) {
            return;
        }
        this.deleteGgoodsModel(ggoodsId);
    }

    @Override
    public QueryResult<PgGgoods> queryGgoodsPage(Map<String, Object> map) {
        List<PgGgoods> pgGgoodsList = this.queryGgoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGgoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgGgoodsList);
        return queryResult;
    }

    @Override
    public PgGgoods getGgoodsByCode(String tenantCode, String ggoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)ggoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ggoodsCode", ggoodsCode);
        return this.getGgoodsModelByCode(map);
    }

    @Override
    public void deleteGgoodsByCode(String tenantCode, String ggoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)ggoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ggoodsCode", ggoodsCode);
        this.delGgoodsModelByCode(map);
    }

    @Override
    public void deleteGgoodsBatch(String ggoodsIds) throws ApiException {
        if (null == ggoodsIds) {
            return;
        }
        this.deleteGgoodsModelBatch(ggoodsIds);
    }

    @Override
    public String cutoutGoods(Map<String, Object> map) throws ApiException {
        if (EmptyUtil.isEmpty(map) || StringUtils.isNotBlank((String)PgOssUtils.checkParam(map))) {
            return "e";
        }
        String goodsUrl = String.valueOf(map.get("goodsUrl"));
        String bucketName = String.valueOf(map.get("bucketName"));
        String objectName = String.valueOf(map.get("objectName"));
        String realmName = String.valueOf(map.get("realmName"));
        String endPoint = String.valueOf(map.get("endpoint"));
        String accessKeyId = String.valueOf(map.get("accessKeyId"));
        String accessKeySecret = String.valueOf(map.get("accessKeySecret"));
        String labelCode = String.valueOf(map.get("labelCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        String resultUrl = "";
        String[] split = endPoint.split("//");
        String ossUrl = split[split.length - 1];
        if (goodsUrl.indexOf(ossUrl) != -1) {
            resultUrl = goodsUrl;
        } else if (goodsUrl.indexOf(prvUrl) != -1) {
            goodsUrl = realmName + goodsUrl;
        }
        if (StringUtils.isBlank((String)resultUrl)) {
            resultUrl = PgOssUtils.uploadOssFile(endPoint, accessKeyId, accessKeySecret, goodsUrl, bucketName, objectName, ossUrl, false);
        }
        if (StringUtils.isBlank((String)resultUrl)) {
            return "e";
        }
        String cutoutUrl = PgCountImagesUtils.cutoutImages(resultUrl, accessKeyId, accessKeySecret);
        if (StringUtils.isNotBlank((String)cutoutUrl) && cutoutUrl.equals("e")) {
            resultUrl = PgOssUtils.uploadOssFile(endPoint, accessKeyId, accessKeySecret, goodsUrl, bucketName, objectName, ossUrl, true);
            cutoutUrl = PgCountImagesUtils.cutoutImages(resultUrl, accessKeyId, accessKeySecret);
        }
        return this.saveCutoutFile(cutoutUrl, labelCode, tenantCode);
    }

    private String saveCutoutFile(String cutoutImages, String labelCode, String tenantCode) {
        if (StringUtils.isBlank((String)cutoutImages) || StringUtils.isBlank((String)labelCode) || cutoutImages.equals("e")) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.saveCutoutFile", (Object)("cutoutImages=" + cutoutImages + "\uff0clabelCode=" + labelCode));
            return "e";
        }
        String fileUrl = this.getFileStreamOrSaveFile(cutoutImages, tenantCode);
        if (StringUtils.isNotBlank((String)fileUrl) && !fileUrl.equals("e")) {
            this.updatePgLabelDisPcPs(labelCode, tenantCode, fileUrl);
        }
        return fileUrl;
    }

    private void updatePgLabelDisPcPs(String labelCode, String tenantCode, String disPcPs) {
        if (StringUtils.isBlank((String)labelCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)disPcPs)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("labelCode", labelCode);
        map.put("tenantCode", tenantCode);
        map.put("disPcPs", disPcPs);
        try {
            this.pgGgoodsMapper.updatePgLabelDisPcPs(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.updatePgLabelDisPcPs", (Object)("labelCode=" + labelCode + "\uff0cdisPcPs=" + disPcPs));
        }
    }

    private String getFileStreamOrSaveFile(String cutoutImages, String tenantCode) {
        if (StringUtils.isBlank((String)cutoutImages)) {
            return "e";
        }
        try {
            URL httpUrl = new URL(cutoutImages);
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            int contentLength = conn.getContentLength();
            if (contentLength < 0) {
                return "e";
            }
            String contentType = conn.getContentType();
            String type = PgOssUtils.checkFileType(contentType);
            if (StringUtils.isBlank((String)type)) {
                this.logger.error("pg.PICK.PgGgoodsServiceImpl.getFileStreamOrSaveFile-contentType", (Object)contentType);
                return "e";
            }
            type = type.substring(1, type.length());
            InputStream inStream = conn.getInputStream();
            byte[] btImg = PgOssUtils.readInputStream(inStream);
            FmFileDomainBean FmFileDomainBeanBean = new FmFileDomainBean();
            FmFileDomainBeanBean.setFileSize(btImg.length);
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileCtype(type);
            FmFileDomainBeanBean.setFileSort("FILE_02");
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            FileBean fileBean = new FileBean();
            fileBean.setFileType(type);
            fileBean.setSize(Long.valueOf(btImg.length));
            fileBean.setBytes(Base64.encodeBase64((byte[])btImg));
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("fmFileDomainBean", JsonUtil.buildNormalBinder().toJson((Object)FmFileDomainBeanBean));
            paramMap.put("fileBeanList", JsonUtil.buildNormalBinder().toJson(fileBeanList));
            String fmfilestr = (String)this.getInternalRouter().inInvoke("fm.file.saveFile", paramMap);
            if (StringUtils.isBlank((String)fmfilestr)) {
                this.logger.error("pg.PICK.PgGgoodsServiceImplexportWordByIfbRequest.error", (Object)fmfilestr);
                return "e";
            }
            FmFileReDomainBean domainBean = (FmFileReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(fmfilestr, FmFileReDomainBean.class);
            if (null == domainBean) {
                this.logger.error("pg.PICK.PgGgoodsServiceImplexportWordByIfbRequest.domainBean", (Object)domainBean);
                return "e";
            }
            String httpPath = "/paas/shop";
            String fileUrl = domainBean.getFileUrl();
            this.logger.error("pg.PICK.PgGgoodsServiceImplexportWordByIfbRequest.error", (Object)fileUrl);
            if (StringUtils.isNotBlank((String)fileUrl) && !fileUrl.trim().substring(0, 4).equals("http")) {
                String separator = "/";
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fileUrl = httpPath + separator + fileUrl;
            }
            return fileUrl;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGgoodsServiceImpl.getFileStreamOrSaveFile-contentType", (Throwable)e);
            return "e";
        }
    }

    private void deleteGgoodsModelBatch(String ggoodsIds) throws ApiException {
        if (null == ggoodsIds) {
            return;
        }
        List<String> ids = Arrays.asList(ggoodsIds.split(","));
        int i = 0;
        try {
            i = this.pgGgoodsMapper.deleteByIds(ids);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.deleteGgoodsModelBatch.ex", (Throwable)e);
        }
        if (ids.size() != i) {
            throw new ApiException("pg.PICK.PgGgoodsServiceImpl.deleteGgoodsModelBatch.num");
        }
    }
}

