/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPromotionDiscountMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDiscountDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDiscountReDomain;
import com.yqbsoft.laser.service.pm.domain.PmPromotionDiscountlistDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscount;
import com.yqbsoft.laser.service.pm.model.PmPromotionDiscountlist;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountService;
import com.yqbsoft.laser.service.pm.service.PmPromotionDiscountlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmPromotionDiscountServiceImpl
extends BaseServiceImpl
implements PmPromotionDiscountService {
    private static final String SYS_CODE = "pm.PmPromotionDiscountServiceImpl";
    private PmPromotionDiscountMapper pmPromotionDiscountMapper;
    private PmPromotionDiscountlistService pmPromotionDiscountlistService;

    public void setPmPromotionDiscountlistService(PmPromotionDiscountlistService pmPromotionDiscountlistService) {
        this.pmPromotionDiscountlistService = pmPromotionDiscountlistService;
    }

    public void setPmPromotionDiscountMapper(PmPromotionDiscountMapper pmPromotionDiscountMapper) {
        this.pmPromotionDiscountMapper = pmPromotionDiscountMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPromotionDiscountMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionDiscountServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPromotionDiscount(PmPromotionDiscountDomain pmPromotionDiscountDomain) {
        if (null == pmPromotionDiscountDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPromotionDiscountDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPromotionDiscountDefault(PmPromotionDiscount pmPromotionDiscount) {
        if (null == pmPromotionDiscount) {
            return;
        }
        if (null == pmPromotionDiscount.getDataState()) {
            pmPromotionDiscount.setDataState(0);
        }
        if (null == pmPromotionDiscount.getGmtCreate()) {
            pmPromotionDiscount.setGmtCreate(this.getSysDate());
        }
        pmPromotionDiscount.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmPromotionDiscount.getPpdCode())) {
            pmPromotionDiscount.setPpdCode(this.createUUIDString());
        }
    }

    private int getPromotionDiscountMaxCode() {
        int code = 0;
        try {
            return this.pmPromotionDiscountMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionDiscountServiceImpl.getPromotionDiscountMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPromotionDiscountUpdataDefault(PmPromotionDiscount pmPromotionDiscount) {
        if (null == pmPromotionDiscount) {
            return;
        }
        pmPromotionDiscount.setGmtModified(this.getSysDate());
    }

    private void savePromotionDiscountModel(PmPromotionDiscount pmPromotionDiscount) throws ApiException {
        if (null == pmPromotionDiscount) {
            return;
        }
        try {
            this.pmPromotionDiscountMapper.insert(pmPromotionDiscount);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.savePromotionDiscountModel.ex", (Throwable)e);
        }
    }

    private void savePromotionDiscountBatchModel(List<PmPromotionDiscount> pmPromotionDiscountList) throws ApiException {
        if (null == pmPromotionDiscountList || pmPromotionDiscountList.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionDiscountMapper.insertBatch(pmPromotionDiscountList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.savePromotionDiscountBatchModel.ex", (Throwable)e);
        }
    }

    private PmPromotionDiscount getPromotionDiscountModelById(Integer ppdId) {
        if (null == ppdId) {
            return null;
        }
        try {
            return this.pmPromotionDiscountMapper.selectByPrimaryKey(ppdId);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionDiscountServiceImpl.getPromotionDiscountModelById", (Throwable)e);
            return null;
        }
    }

    private PmPromotionDiscount getPromotionDiscountModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPromotionDiscountMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionDiscountServiceImpl.getPromotionDiscountModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPromotionDiscountModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionDiscountMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.delPromotionDiscountModelByCode.ex", (Throwable)e);
        }
    }

    private void delPromotionDiscountModelByPromotionCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.pmPromotionDiscountMapper.delByPromotionCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.delPromotionDiscountModelByPromotionCode.ex", (Throwable)e);
        }
    }

    private void deletePromotionDiscountModel(Integer ppdId) throws ApiException {
        if (null == ppdId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionDiscountMapper.deleteByPrimaryKey(ppdId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.deletePromotionDiscountModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.deletePromotionDiscountModel.num");
        }
    }

    private void updatePromotionDiscountModel(PmPromotionDiscount pmPromotionDiscount) throws ApiException {
        if (null == pmPromotionDiscount) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPromotionDiscountMapper.updateByPrimaryKeySelective(pmPromotionDiscount);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.updatePromotionDiscountModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.updatePromotionDiscountModel.num");
        }
    }

    private void updateStatePromotionDiscountModel(Integer ppdId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ppdId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ppdId", ppdId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionDiscountMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.updateStatePromotionDiscountModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.updateStatePromotionDiscountModel.null");
        }
    }

    private void updateStatePromotionDiscountModelByCode(String tenantCode, String ppdCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)ppdCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppdCode", ppdCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmPromotionDiscountMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.updateStatePromotionDiscountModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.updateStatePromotionDiscountModelByCode.null");
        }
    }

    private PmPromotionDiscount makePromotionDiscount(PmPromotionDiscountDomain pmPromotionDiscountDomain, PmPromotionDiscount pmPromotionDiscount) {
        if (null == pmPromotionDiscountDomain) {
            return null;
        }
        if (null == pmPromotionDiscount) {
            pmPromotionDiscount = new PmPromotionDiscount();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionDiscount, (Object)pmPromotionDiscountDomain);
            return pmPromotionDiscount;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionDiscountServiceImpl.makePromotionDiscount", (Throwable)e);
            return null;
        }
    }

    private PmPromotionDiscountReDomain makePmPromotionDiscountReDomain(PmPromotionDiscount pmPromotionDiscount) {
        if (null == pmPromotionDiscount) {
            return null;
        }
        PmPromotionDiscountReDomain pmPromotionDiscountReDomain = new PmPromotionDiscountReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPromotionDiscountReDomain, (Object)pmPromotionDiscount);
            return pmPromotionDiscountReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionDiscountServiceImpl.makePmPromotionDiscountReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPromotionDiscount> queryPromotionDiscountModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPromotionDiscountMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionDiscountServiceImpl.queryPromotionDiscountModel", (Throwable)e);
            return null;
        }
    }

    private int countPromotionDiscount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPromotionDiscountMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPromotionDiscountServiceImpl.countPromotionDiscount", (Throwable)e);
        }
        return i;
    }

    private PmPromotionDiscount createPmPromotionDiscount(PmPromotionDiscountDomain pmPromotionDiscountDomain) {
        String msg = this.checkPromotionDiscount(pmPromotionDiscountDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.savePromotionDiscount.checkPromotionDiscount", msg);
        }
        PmPromotionDiscount pmPromotionDiscount = this.makePromotionDiscount(pmPromotionDiscountDomain, null);
        this.setPromotionDiscountDefault(pmPromotionDiscount);
        return pmPromotionDiscount;
    }

    @Override
    public String savePromotionDiscount(PmPromotionDiscountDomain pmPromotionDiscountDomain) throws ApiException {
        PmPromotionDiscount pmPromotionDiscount = this.createPmPromotionDiscount(pmPromotionDiscountDomain);
        this.savePromotionDiscountModel(pmPromotionDiscount);
        return pmPromotionDiscount.getPpdCode();
    }

    @Override
    public String savePromotionDiscountBatch(List<PmPromotionDiscountDomain> pmPromotionDiscountDomainList) throws ApiException {
        if (null == pmPromotionDiscountDomainList || pmPromotionDiscountDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPromotionDiscount> pmPromotionDiscountList = new ArrayList<PmPromotionDiscount>();
        String ppdCode = "";
        for (PmPromotionDiscountDomain pmPromotionDiscountDomain : pmPromotionDiscountDomainList) {
            PmPromotionDiscount pmPromotionDiscount = this.createPmPromotionDiscount(pmPromotionDiscountDomain);
            ppdCode = pmPromotionDiscount.getPpdCode();
            pmPromotionDiscountList.add(pmPromotionDiscount);
            List<PmPromotionDiscountlistDomain> discountlistDomainList = pmPromotionDiscountDomain.getPmPromotionDiscountlistList();
            if (null == discountlistDomainList || discountlistDomainList.size() <= 0) continue;
            for (PmPromotionDiscountlistDomain discountlistDomain : discountlistDomainList) {
                discountlistDomain.setAppmanageIcode(pmPromotionDiscountDomain.getAppmanageIcode());
                discountlistDomain.setTenantCode(pmPromotionDiscountDomain.getTenantCode());
                discountlistDomain.setMemberName(pmPromotionDiscountDomain.getMemberName());
                discountlistDomain.setMemberCode(pmPromotionDiscountDomain.getMemberCode());
                discountlistDomain.setPromotionCode(pmPromotionDiscountDomain.getPromotionCode());
                discountlistDomain.setPpdCode(ppdCode);
            }
            this.pmPromotionDiscountlistService.savePromotionDiscountlistBatch(discountlistDomainList);
        }
        this.savePromotionDiscountBatchModel(pmPromotionDiscountList);
        return ppdCode;
    }

    @Override
    public void updatePromotionDiscountState(Integer ppdId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionDiscountModel(ppdId, dataState, oldDataState);
    }

    @Override
    public void updatePromotionDiscountStateByCode(String tenantCode, String ppdCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePromotionDiscountModelByCode(tenantCode, ppdCode, dataState, oldDataState);
    }

    @Override
    public void updatePromotionDiscount(PmPromotionDiscountDomain pmPromotionDiscountDomain) throws ApiException {
        String msg = this.checkPromotionDiscount(pmPromotionDiscountDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.updatePromotionDiscount.checkPromotionDiscount", msg);
        }
        PmPromotionDiscount oldPmPromotionDiscount = this.getPromotionDiscountModelById(pmPromotionDiscountDomain.getPpdId());
        if (null == oldPmPromotionDiscount) {
            throw new ApiException("pm.PmPromotionDiscountServiceImpl.updatePromotionDiscount.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPromotionDiscount pmPromotionDiscount = this.makePromotionDiscount(pmPromotionDiscountDomain, oldPmPromotionDiscount);
        this.setPromotionDiscountUpdataDefault(pmPromotionDiscount);
        this.updatePromotionDiscountModel(pmPromotionDiscount);
    }

    @Override
    public PmPromotionDiscount getPromotionDiscount(Integer ppdId) {
        return this.getPromotionDiscountModelById(ppdId);
    }

    @Override
    public void deletePromotionDiscount(Integer ppdId) throws ApiException {
        this.deletePromotionDiscountModel(ppdId);
    }

    @Override
    public QueryResult<PmPromotionDiscount> queryPromotionDiscountPage(Map<String, Object> map) {
        List<PmPromotionDiscount> pmPromotionDiscountList = this.queryPromotionDiscountModelPage(map);
        if (!EmptyUtil.isEmpty((Object)map.get("childFlg"))) {
            pmPromotionDiscountList = this.makePromotionDiscountList(pmPromotionDiscountList);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        if (ListUtil.isNotEmpty(pmPromotionDiscountList) && !EmptyUtil.isEmpty((Object)map.get("startRow")) && !EmptyUtil.isEmpty((Object)map.get("rows"))) {
            pageTools.setRecordCount(this.countPromotionDiscount(map));
        }
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPromotionDiscountList);
        return queryResult;
    }

    private List<PmPromotionDiscount> makePromotionDiscountList(List<PmPromotionDiscount> pmPromotionDiscountList) {
        if (ListUtil.isNotEmpty(pmPromotionDiscountList)) {
            for (final PmPromotionDiscount pmPromotionDiscount : pmPromotionDiscountList) {
                QueryResult<PmPromotionDiscountlist> queryResult = this.pmPromotionDiscountlistService.queryPromotionDiscountlistPage((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("ppdCode", pmPromotionDiscount.getPpdCode());
                        this.put("tenantCode", pmPromotionDiscount.getTenantCode());
                    }
                });
                if (EmptyUtil.isEmpty(queryResult) || !ListUtil.isNotEmpty((Collection)queryResult.getList())) continue;
                pmPromotionDiscount.setPmPromotionDiscountlistList(queryResult.getList());
            }
        }
        return pmPromotionDiscountList;
    }

    @Override
    public PmPromotionDiscount getPromotionDiscountByCode(String tenantCode, String ppdCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ppdCode", ppdCode);
        return this.getPromotionDiscountModelByCode(map);
    }

    @Override
    public void deletePromotionDiscountByCode(String tenantCode, String promotionCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("promotionCode", promotionCode);
        this.delPromotionDiscountModelByPromotionCode(map);
    }
}

