/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmChannelsendApiMapper;
import com.yqbsoft.laser.service.pm.domain.PmChannelsendApiDomain;
import com.yqbsoft.laser.service.pm.domain.PmChannelsendApiReDomain;
import com.yqbsoft.laser.service.pm.model.PmChannelsendApi;
import com.yqbsoft.laser.service.pm.service.PmChannelApiService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmChannelApiServiceImpl
extends BaseServiceImpl
implements PmChannelApiService {
    private static final String SYS_CODE = "pm.PmChannelsendApiServiceImpl";
    private PmChannelsendApiMapper pmChannelsendApiMapper;

    public void setPmChannelsendApiMapper(PmChannelsendApiMapper pmChannelsendApiMapper) {
        this.pmChannelsendApiMapper = pmChannelsendApiMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmChannelsendApiMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PmChannelsendApiServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannelApi(PmChannelsendApiDomain pmChannelsendApiDomain) {
        if (null == pmChannelsendApiDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmChannelsendApiDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setChannelApiDefault(PmChannelsendApi pmChannelsendApi) {
        if (null == pmChannelsendApi) {
            return;
        }
        if (null == pmChannelsendApi.getDataState()) {
            pmChannelsendApi.setDataState(0);
        }
        if (null == pmChannelsendApi.getGmtCreate()) {
            pmChannelsendApi.setGmtCreate(this.getSysDate());
        }
        pmChannelsendApi.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pmChannelsendApi.getChannelsendApiCode())) {
            pmChannelsendApi.setChannelsendApiCode(this.createUUIDString());
        }
    }

    private int getChannelApiMaxCode() {
        int code = 0;
        try {
            return this.pmChannelsendApiMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PmChannelsendApiServiceImpl.getChannelApiMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelApiUpdataDefault(PmChannelsendApi PmChannelsendApi2) {
        if (null == PmChannelsendApi2) {
            return;
        }
        PmChannelsendApi2.setGmtModified(this.getSysDate());
    }

    private void saveChannelApiModel(PmChannelsendApi pmChannelsendApi) throws ApiException {
        if (null == pmChannelsendApi) {
            return;
        }
        try {
            this.pmChannelsendApiMapper.insert(pmChannelsendApi);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.saveChannelApiModel.ex", (Throwable)e);
        }
    }

    private void saveChannelApiBatchModel(List<PmChannelsendApi> disChannelApiList) throws ApiException {
        if (null == disChannelApiList || disChannelApiList.isEmpty()) {
            return;
        }
        try {
            this.pmChannelsendApiMapper.insertBatch(disChannelApiList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.saveChannelApiBatchModel.ex", (Throwable)e);
        }
    }

    private PmChannelsendApi getChannelApiModelById(Integer channelApiId) {
        if (null == channelApiId) {
            return null;
        }
        try {
            return this.pmChannelsendApiMapper.selectByPrimaryKey(channelApiId);
        }
        catch (Exception e) {
            this.logger.error("pm.PmChannelsendApiServiceImpl.getChannelApiModelById", (Throwable)e);
            return null;
        }
    }

    private PmChannelsendApi getChannelApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmChannelsendApiMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmChannelsendApiServiceImpl.getChannelApiModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delChannelApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmChannelsendApiMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.delChannelApiModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.delChannelApiModelByCode.num");
        }
    }

    private void deleteChannelApiModel(Integer channelApiId) throws ApiException {
        if (null == channelApiId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmChannelsendApiMapper.deleteByPrimaryKey(channelApiId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.deleteChannelApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.deleteChannelApiModel.num");
        }
    }

    private void updateChannelApiModel(PmChannelsendApi PmChannelsendApi2) throws ApiException {
        if (null == PmChannelsendApi2) {
            return;
        }
        int i = 0;
        try {
            i = this.pmChannelsendApiMapper.updateByPrimaryKeySelective(PmChannelsendApi2);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.updateChannelApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.updateChannelApiModel.num");
        }
    }

    private void updateStateChannelApiModel(Integer channelApiId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == channelApiId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelApiId", channelApiId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmChannelsendApiMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.updateStateChannelApiModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.updateStateChannelApiModel.null");
        }
    }

    private void updateStateChannelApiModelByCode(String tenantCode, String channelApiCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)channelApiCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelApiCode", channelApiCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pmChannelsendApiMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.updateStateChannelApiModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.updateStateChannelApiModelByCode.null");
        }
    }

    private PmChannelsendApi makeChannelApi(PmChannelsendApiDomain pmChannelsendApiDomain, PmChannelsendApi pmChannelsendApi) {
        if (null == pmChannelsendApiDomain) {
            return null;
        }
        if (null == pmChannelsendApi) {
            pmChannelsendApi = new PmChannelsendApi();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmChannelsendApi, (Object)pmChannelsendApiDomain);
            return pmChannelsendApi;
        }
        catch (Exception e) {
            this.logger.error("pm.PmChannelsendApiServiceImpl.makeChannelApi", (Throwable)e);
            return null;
        }
    }

    private PmChannelsendApiReDomain makeDisChannelApiReDomain(PmChannelsendApi pmChannelsendApi) {
        if (null == pmChannelsendApi) {
            return null;
        }
        PmChannelsendApiReDomain disChannelApiReDomain = new PmChannelsendApiReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disChannelApiReDomain, (Object)pmChannelsendApi);
            return disChannelApiReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmChannelsendApiServiceImpl.makeDisChannelApiReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmChannelsendApi> queryChannelApiModelPage(Map<String, Object> parammap) {
        try {
            return this.pmChannelsendApiMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmChannelsendApiServiceImpl.queryChannelApiModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelApi(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmChannelsendApiMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmChannelsendApiServiceImpl.countChannelApi", (Throwable)e);
        }
        return i;
    }

    private PmChannelsendApi createDisChannelApi(PmChannelsendApiDomain pmChannelsendApiDomain) {
        String msg = this.checkChannelApi(pmChannelsendApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.saveChannelApi.checkChannelApi", msg);
        }
        PmChannelsendApi pmChannelsendApi = this.makeChannelApi(pmChannelsendApiDomain, null);
        this.setChannelApiDefault(pmChannelsendApi);
        return pmChannelsendApi;
    }

    @Override
    public String savePmChannelsendApi(PmChannelsendApiDomain pmChannelsendApiDomain) throws ApiException {
        PmChannelsendApi pmChannelsendApi = this.createDisChannelApi(pmChannelsendApiDomain);
        this.saveChannelApiModel(pmChannelsendApi);
        return pmChannelsendApi.getChannelsendApiCode();
    }

    @Override
    public String savePmChannelsendApiBatch(List<PmChannelsendApiDomain> disPmChannelsendApiDomainList) throws ApiException {
        if (null == disPmChannelsendApiDomainList || disPmChannelsendApiDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmChannelsendApi> disChannelApiList = new ArrayList<PmChannelsendApi>();
        String code = "";
        for (PmChannelsendApiDomain pmChannelsendApiDomain : disPmChannelsendApiDomainList) {
            PmChannelsendApi pmChannelsendApi = this.createDisChannelApi(pmChannelsendApiDomain);
            code = pmChannelsendApi.getChannelsendApiCode();
            disChannelApiList.add(pmChannelsendApi);
        }
        this.saveChannelApiBatchModel(disChannelApiList);
        return code;
    }

    @Override
    public void updatePmChannelsendApiState(Integer channelApiId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelApiModel(channelApiId, dataState, oldDataState);
    }

    @Override
    public void updatePmChannelsendApiStateByCode(String tenantCode, String channelApiCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelApiModelByCode(tenantCode, channelApiCode, dataState, oldDataState);
    }

    @Override
    public void updatePmChannelsendApi(PmChannelsendApiDomain pmChannelsendApiDomain) throws ApiException {
        String msg = this.checkChannelApi(pmChannelsendApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.updatePmChannelsendApi.checkChannelApi", msg);
        }
        PmChannelsendApi oldDisChannelApi = this.getChannelApiModelById(pmChannelsendApiDomain.getChannelsendApiId());
        if (null == oldDisChannelApi) {
            throw new ApiException("pm.PmChannelsendApiServiceImpl.updateChannelApi.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmChannelsendApi PmChannelsendApi2 = this.makeChannelApi(pmChannelsendApiDomain, oldDisChannelApi);
        this.setChannelApiUpdataDefault(PmChannelsendApi2);
        this.updateChannelApiModel(PmChannelsendApi2);
    }

    @Override
    public PmChannelsendApi getPmChannelsendApi(Integer channelApiId) {
        return this.getChannelApiModelById(channelApiId);
    }

    @Override
    public void deletePmChannelsendApi(Integer channelApiId) throws ApiException {
        this.deleteChannelApiModel(channelApiId);
    }

    @Override
    public QueryResult<PmChannelsendApi> queryPmChannelsendApiPage(Map<String, Object> map) {
        List<PmChannelsendApi> disChannelApiList = this.queryChannelApiModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelApi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disChannelApiList);
        return queryResult;
    }

    @Override
    public PmChannelsendApi getPmChannelsendApiByCode(String tenantCode, String channelApiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelApiCode", channelApiCode);
        return this.getChannelApiModelByCode(map);
    }

    @Override
    public void deletePmChannelsendApiByCode(String tenantCode, String channelApiCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelApiCode", channelApiCode);
        this.delChannelApiModelByCode(map);
    }
}

