/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmRsgiftFileMapper;
import com.yqbsoft.laser.service.pm.domain.PmRsgiftFileDomain;
import com.yqbsoft.laser.service.pm.domain.PmRsgiftFileReDomain;
import com.yqbsoft.laser.service.pm.model.PmRsgiftFile;
import com.yqbsoft.laser.service.pm.service.PmRsgiftFileService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmRsgiftFileServiceImpl
extends BaseServiceImpl
implements PmRsgiftFileService {
    private static final String SYS_CODE = "pm.PROMOTION.PmRsgiftFileServiceImpl";
    private PmRsgiftFileMapper pmRsgiftFileMapper;

    public void setPmRsgiftFileMapper(PmRsgiftFileMapper pmRsgiftFileMapper) {
        this.pmRsgiftFileMapper = pmRsgiftFileMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmRsgiftFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftFileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRsgiftFile(PmRsgiftFileDomain pmRsgiftFileDomain) {
        if (null == pmRsgiftFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmRsgiftFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRsgiftFileDefault(PmRsgiftFile pmRsgiftFile) {
        if (null == pmRsgiftFile) {
            return;
        }
        if (null == pmRsgiftFile.getDataState()) {
            pmRsgiftFile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmRsgiftFile.getGmtCreate()) {
            pmRsgiftFile.setGmtCreate(date);
        }
        pmRsgiftFile.setGmtModified(date);
        if (StringUtils.isBlank((String)pmRsgiftFile.getRsgiftFileCode())) {
            pmRsgiftFile.setRsgiftFileCode(this.getNo(null, "PmRsgiftFile", "pmRsgiftFile", pmRsgiftFile.getTenantCode()));
        }
    }

    private int getRsgiftFileMaxCode() {
        int code = 0;
        try {
            return this.pmRsgiftFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftFileServiceImpl.getRsgiftFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRsgiftFileUpdataDefault(PmRsgiftFile pmRsgiftFile) {
        if (null == pmRsgiftFile) {
            return;
        }
        pmRsgiftFile.setGmtModified(this.getSysDate());
    }

    private void saveRsgiftFileModel(PmRsgiftFile pmRsgiftFile) throws ApiException {
        if (null == pmRsgiftFile) {
            return;
        }
        try {
            this.pmRsgiftFileMapper.insert(pmRsgiftFile);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.saveRsgiftFileModel.ex", (Throwable)e);
        }
    }

    private void saveRsgiftFileBatchModel(List<PmRsgiftFile> pmRsgiftFileList) throws ApiException {
        if (null == pmRsgiftFileList || pmRsgiftFileList.isEmpty()) {
            return;
        }
        try {
            this.pmRsgiftFileMapper.insertBatch(pmRsgiftFileList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.saveRsgiftFileBatchModel.ex", (Throwable)e);
        }
    }

    private PmRsgiftFile getRsgiftFileModelById(Integer rsgiftFileId) {
        if (null == rsgiftFileId) {
            return null;
        }
        try {
            return this.pmRsgiftFileMapper.selectByPrimaryKey(rsgiftFileId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftFileServiceImpl.getRsgiftFileModelById", (Throwable)e);
            return null;
        }
    }

    private PmRsgiftFile getRsgiftFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmRsgiftFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftFileServiceImpl.getRsgiftFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRsgiftFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmRsgiftFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.delRsgiftFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.delRsgiftFileModelByCode.num");
        }
    }

    private void deleteRsgiftFileModel(Integer rsgiftFileId) throws ApiException {
        if (null == rsgiftFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmRsgiftFileMapper.deleteByPrimaryKey(rsgiftFileId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.deleteRsgiftFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.deleteRsgiftFileModel.num");
        }
    }

    private void updateRsgiftFileModel(PmRsgiftFile pmRsgiftFile) throws ApiException {
        if (null == pmRsgiftFile) {
            return;
        }
        int i = 0;
        try {
            i = this.pmRsgiftFileMapper.updateByPrimaryKey(pmRsgiftFile);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.updateRsgiftFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.updateRsgiftFileModel.num");
        }
    }

    private void updateStateRsgiftFileModel(Integer rsgiftFileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rsgiftFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rsgiftFileId", rsgiftFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmRsgiftFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.updateStateRsgiftFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.updateStateRsgiftFileModel.null");
        }
    }

    private void updateStateRsgiftFileModelByCode(String tenantCode, String rsgiftFileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rsgiftFileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsgiftFileCode", rsgiftFileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmRsgiftFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.updateStateRsgiftFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.updateStateRsgiftFileModelByCode.null");
        }
    }

    private PmRsgiftFile makeRsgiftFile(PmRsgiftFileDomain pmRsgiftFileDomain, PmRsgiftFile pmRsgiftFile) {
        if (null == pmRsgiftFileDomain) {
            return null;
        }
        if (null == pmRsgiftFile) {
            pmRsgiftFile = new PmRsgiftFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmRsgiftFile, (Object)pmRsgiftFileDomain);
            return pmRsgiftFile;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftFileServiceImpl.makeRsgiftFile", (Throwable)e);
            return null;
        }
    }

    private PmRsgiftFileReDomain makePmRsgiftFileReDomain(PmRsgiftFile pmRsgiftFile) {
        if (null == pmRsgiftFile) {
            return null;
        }
        PmRsgiftFileReDomain pmRsgiftFileReDomain = new PmRsgiftFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmRsgiftFileReDomain, (Object)pmRsgiftFile);
            return pmRsgiftFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftFileServiceImpl.makePmRsgiftFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmRsgiftFile> queryRsgiftFileModelPage(Map<String, Object> parammap) {
        try {
            return this.pmRsgiftFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftFileServiceImpl.queryRsgiftFileModel", (Throwable)e);
            return null;
        }
    }

    private int countRsgiftFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmRsgiftFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmRsgiftFileServiceImpl.countRsgiftFile", (Throwable)e);
        }
        return i;
    }

    private PmRsgiftFile createPmRsgiftFile(PmRsgiftFileDomain pmRsgiftFileDomain) {
        String msg = this.checkRsgiftFile(pmRsgiftFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.saveRsgiftFile.checkRsgiftFile", msg);
        }
        PmRsgiftFile pmRsgiftFile = this.makeRsgiftFile(pmRsgiftFileDomain, null);
        this.setRsgiftFileDefault(pmRsgiftFile);
        return pmRsgiftFile;
    }

    @Override
    public String saveRsgiftFile(PmRsgiftFileDomain pmRsgiftFileDomain) throws ApiException {
        PmRsgiftFile pmRsgiftFile = this.createPmRsgiftFile(pmRsgiftFileDomain);
        this.saveRsgiftFileModel(pmRsgiftFile);
        return pmRsgiftFile.getRsgiftFileCode();
    }

    @Override
    public String saveRsgiftFileBatch(List<PmRsgiftFileDomain> pmRsgiftFileDomainList) throws ApiException {
        if (null == pmRsgiftFileDomainList || pmRsgiftFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmRsgiftFile> pmRsgiftFileList = new ArrayList<PmRsgiftFile>();
        String code = "";
        for (PmRsgiftFileDomain pmRsgiftFileDomain : pmRsgiftFileDomainList) {
            PmRsgiftFile pmRsgiftFile = this.createPmRsgiftFile(pmRsgiftFileDomain);
            code = pmRsgiftFile.getRsgiftFileCode();
            pmRsgiftFileList.add(pmRsgiftFile);
        }
        this.saveRsgiftFileBatchModel(pmRsgiftFileList);
        return code;
    }

    @Override
    public void updateRsgiftFileState(Integer rsgiftFileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == rsgiftFileId) {
            return;
        }
        this.updateStateRsgiftFileModel(rsgiftFileId, dataState, oldDataState, map);
    }

    @Override
    public void updateRsgiftFileStateByCode(String tenantCode, String rsgiftFileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)rsgiftFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRsgiftFileModelByCode(tenantCode, rsgiftFileCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRsgiftFile(PmRsgiftFileDomain pmRsgiftFileDomain) throws ApiException {
        String msg = this.checkRsgiftFile(pmRsgiftFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.updateRsgiftFile.checkRsgiftFile", msg);
        }
        PmRsgiftFile oldPmRsgiftFile = this.getRsgiftFileModelById(pmRsgiftFileDomain.getRsgiftFileId());
        if (null == oldPmRsgiftFile) {
            throw new ApiException("pm.PROMOTION.PmRsgiftFileServiceImpl.updateRsgiftFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmRsgiftFile pmRsgiftFile = this.makeRsgiftFile(pmRsgiftFileDomain, oldPmRsgiftFile);
        this.setRsgiftFileUpdataDefault(pmRsgiftFile);
        this.updateRsgiftFileModel(pmRsgiftFile);
    }

    @Override
    public PmRsgiftFile getRsgiftFile(Integer rsgiftFileId) {
        if (null == rsgiftFileId) {
            return null;
        }
        return this.getRsgiftFileModelById(rsgiftFileId);
    }

    @Override
    public void deleteRsgiftFile(Integer rsgiftFileId) throws ApiException {
        if (null == rsgiftFileId) {
            return;
        }
        this.deleteRsgiftFileModel(rsgiftFileId);
    }

    @Override
    public QueryResult<PmRsgiftFile> queryRsgiftFilePage(Map<String, Object> map) {
        List<PmRsgiftFile> pmRsgiftFileList = this.queryRsgiftFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRsgiftFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmRsgiftFileList);
        return queryResult;
    }

    @Override
    public PmRsgiftFile getRsgiftFileByCode(String tenantCode, String rsgiftFileCode) throws ApiException {
        if (StringUtils.isBlank((String)rsgiftFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsgiftFileCode", rsgiftFileCode);
        return this.getRsgiftFileModelByCode(map);
    }

    @Override
    public void deleteRsgiftFileByCode(String tenantCode, String rsgiftFileCode) throws ApiException {
        if (StringUtils.isBlank((String)rsgiftFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsgiftFileCode", rsgiftFileCode);
        this.delRsgiftFileModelByCode(map);
    }
}

