/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPtaskDiscountMapper;
import com.yqbsoft.laser.service.pm.domain.PmPtaskDiscountDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskDiscountReDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskDiscountlistDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponDomain;
import com.yqbsoft.laser.service.pm.domain.UpmUpointsClearDomain;
import com.yqbsoft.laser.service.pm.model.PmPromotion;
import com.yqbsoft.laser.service.pm.model.PmPtaskDiscount;
import com.yqbsoft.laser.service.pm.model.PmPtaskDiscountlist;
import com.yqbsoft.laser.service.pm.service.PmPtaskDiscountService;
import com.yqbsoft.laser.service.pm.service.PmPtaskDiscountlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class PmPtaskDiscountServiceImpl
extends BaseServiceImpl
implements PmPtaskDiscountService {
    private static final String SYS_CODE = "pm.PROMOTION.PmPtaskDiscountServiceImpl";
    private PmPtaskDiscountMapper pmPtaskDiscountMapper;
    PmPtaskDiscountlistService pmPtaskDiscountlistService;
    @Autowired
    private PmPtaskDiscountlistService discountlistService;

    public void setPmPtaskDiscountMapper(PmPtaskDiscountMapper pmPtaskDiscountMapper) {
        this.pmPtaskDiscountMapper = pmPtaskDiscountMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPtaskDiscountMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskDiscountServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtaskDiscount(PmPtaskDiscountDomain pmPtaskDiscountDomain) {
        if (null == pmPtaskDiscountDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPtaskDiscountDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtaskDiscountDefault(PmPtaskDiscount pmPtaskDiscount) {
        if (null == pmPtaskDiscount) {
            return;
        }
        if (null == pmPtaskDiscount.getDataState()) {
            pmPtaskDiscount.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPtaskDiscount.getGmtCreate()) {
            pmPtaskDiscount.setGmtCreate(date);
        }
        pmPtaskDiscount.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPtaskDiscount.getPtaskDiscountCode())) {
            pmPtaskDiscount.setPtaskDiscountCode(this.getNo(null, "PmPtaskDiscount", "pmPtaskDiscount", pmPtaskDiscount.getTenantCode()));
        }
    }

    private int getPtaskDiscountMaxCode() {
        int code = 0;
        try {
            return this.pmPtaskDiscountMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskDiscountServiceImpl.getPtaskDiscountMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtaskDiscountUpdataDefault(PmPtaskDiscount pmPtaskDiscount) {
        if (null == pmPtaskDiscount) {
            return;
        }
        pmPtaskDiscount.setGmtModified(this.getSysDate());
    }

    private void savePtaskDiscountModel(PmPtaskDiscount pmPtaskDiscount) throws ApiException {
        if (null == pmPtaskDiscount) {
            return;
        }
        try {
            this.pmPtaskDiscountMapper.insert(pmPtaskDiscount);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.savePtaskDiscountModel.ex", (Throwable)e);
        }
    }

    private void savePtaskDiscountBatchModel(List<PmPtaskDiscount> pmPtaskDiscountList) throws ApiException {
        if (null == pmPtaskDiscountList || pmPtaskDiscountList.isEmpty()) {
            return;
        }
        try {
            this.pmPtaskDiscountMapper.insertBatch(pmPtaskDiscountList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.savePtaskDiscountBatchModel.ex", (Throwable)e);
        }
    }

    private PmPtaskDiscount getPtaskDiscountModelById(Integer ptaskDiscountId) {
        if (null == ptaskDiscountId) {
            return null;
        }
        try {
            return this.pmPtaskDiscountMapper.selectByPrimaryKey(ptaskDiscountId);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskDiscountServiceImpl.getPtaskDiscountModelById", (Throwable)e);
            return null;
        }
    }

    private PmPtaskDiscount getPtaskDiscountModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPtaskDiscountMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskDiscountServiceImpl.getPtaskDiscountModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtaskDiscountModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskDiscountMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.delPtaskDiscountModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.delPtaskDiscountModelByCode.num");
        }
    }

    private void deletePtaskDiscountModel(Integer ptaskDiscountId) throws ApiException {
        if (null == ptaskDiscountId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskDiscountMapper.deleteByPrimaryKey(ptaskDiscountId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.deletePtaskDiscountModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.deletePtaskDiscountModel.num");
        }
    }

    private void updatePtaskDiscountModel(PmPtaskDiscount pmPtaskDiscount) throws ApiException {
        if (null == pmPtaskDiscount) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskDiscountMapper.updateByPrimaryKey(pmPtaskDiscount);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.updatePtaskDiscountModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.updatePtaskDiscountModel.num");
        }
    }

    private void updateStatePtaskDiscountModel(Integer ptaskDiscountId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ptaskDiscountId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptaskDiscountId", ptaskDiscountId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskDiscountMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.updateStatePtaskDiscountModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.updateStatePtaskDiscountModel.null");
        }
    }

    private void updateStatePtaskDiscountModelByCode(String tenantCode, String ptaskDiscountCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ptaskDiscountCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskDiscountCode", ptaskDiscountCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskDiscountMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.updateStatePtaskDiscountModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.updateStatePtaskDiscountModelByCode.null");
        }
    }

    private PmPtaskDiscount makePtaskDiscount(PmPtaskDiscountDomain pmPtaskDiscountDomain, PmPtaskDiscount pmPtaskDiscount) {
        if (null == pmPtaskDiscountDomain) {
            return null;
        }
        if (null == pmPtaskDiscount) {
            pmPtaskDiscount = new PmPtaskDiscount();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskDiscount, (Object)pmPtaskDiscountDomain);
            return pmPtaskDiscount;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskDiscountServiceImpl.makePtaskDiscount", (Throwable)e);
            return null;
        }
    }

    private PmPtaskDiscountReDomain makePmPtaskDiscountReDomain(PmPtaskDiscount pmPtaskDiscount) {
        if (null == pmPtaskDiscount) {
            return null;
        }
        PmPtaskDiscountReDomain pmPtaskDiscountReDomain = new PmPtaskDiscountReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskDiscountReDomain, (Object)pmPtaskDiscount);
            return pmPtaskDiscountReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskDiscountServiceImpl.makePmPtaskDiscountReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPtaskDiscount> queryPtaskDiscountModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPtaskDiscountMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskDiscountServiceImpl.queryPtaskDiscountModel", (Throwable)e);
            return null;
        }
    }

    private int countPtaskDiscount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPtaskDiscountMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PROMOTION.PmPtaskDiscountServiceImpl.countPtaskDiscount", (Throwable)e);
        }
        return i;
    }

    private PmPtaskDiscount createPmPtaskDiscount(PmPtaskDiscountDomain pmPtaskDiscountDomain) {
        String msg = this.checkPtaskDiscount(pmPtaskDiscountDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.savePtaskDiscount.checkPtaskDiscount", msg);
        }
        PmPtaskDiscount pmPtaskDiscount = this.makePtaskDiscount(pmPtaskDiscountDomain, null);
        this.setPtaskDiscountDefault(pmPtaskDiscount);
        return pmPtaskDiscount;
    }

    @Override
    public String savePtaskDiscount(PmPtaskDiscountDomain pmPtaskDiscountDomain) throws ApiException {
        PmPtaskDiscount pmPtaskDiscount = this.createPmPtaskDiscount(pmPtaskDiscountDomain);
        this.savePtaskDiscountModel(pmPtaskDiscount);
        this.saveDiscountlist(pmPtaskDiscountDomain.getPmPtaskDiscountlistDomainList(), pmPtaskDiscount);
        return pmPtaskDiscount.getPtaskDiscountCode();
    }

    private void saveDiscountlist(List<PmPtaskDiscountlistDomain> pmPtaskDiscountlistDomainList, PmPtaskDiscount pmPtaskDiscount) {
        if (ListUtil.isEmpty(pmPtaskDiscountlistDomainList) || null == pmPtaskDiscount) {
            return;
        }
        for (PmPtaskDiscountlistDomain pmPtaskDiscountlistDomain : pmPtaskDiscountlistDomainList) {
            pmPtaskDiscountlistDomain.setAppmanageIcode(pmPtaskDiscount.getAppmanageIcode());
            pmPtaskDiscountlistDomain.setPromotionCode(pmPtaskDiscount.getPromotionCode());
            pmPtaskDiscountlistDomain.setPtaskCode(pmPtaskDiscount.getPtaskCode());
        }
        this.pmPtaskDiscountlistService.savePtaskDiscountlistBatch(pmPtaskDiscountlistDomainList);
    }

    public void setPmPtaskDiscountlistService(PmPtaskDiscountlistService pmPtaskDiscountlistService) {
        this.pmPtaskDiscountlistService = pmPtaskDiscountlistService;
    }

    @Override
    public String savePtaskDiscountBatch(List<PmPtaskDiscountDomain> pmPtaskDiscountDomainList) throws ApiException {
        if (null == pmPtaskDiscountDomainList || pmPtaskDiscountDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (PmPtaskDiscountDomain pmPtaskDiscountDomain : pmPtaskDiscountDomainList) {
            code = this.savePtaskDiscount(pmPtaskDiscountDomain);
        }
        return code;
    }

    @Override
    public void updatePtaskDiscountState(Integer ptaskDiscountId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ptaskDiscountId) {
            return;
        }
        this.updateStatePtaskDiscountModel(ptaskDiscountId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtaskDiscountStateByCode(String tenantCode, String ptaskDiscountCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ptaskDiscountCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtaskDiscountModelByCode(tenantCode, ptaskDiscountCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtaskDiscount(PmPtaskDiscountDomain pmPtaskDiscountDomain) throws ApiException {
        String msg = this.checkPtaskDiscount(pmPtaskDiscountDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.updatePtaskDiscount.checkPtaskDiscount", msg);
        }
        PmPtaskDiscount oldPmPtaskDiscount = this.getPtaskDiscountModelById(pmPtaskDiscountDomain.getPtaskDiscountId());
        if (null == oldPmPtaskDiscount) {
            throw new ApiException("pm.PROMOTION.PmPtaskDiscountServiceImpl.updatePtaskDiscount.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPtaskDiscount pmPtaskDiscount = this.makePtaskDiscount(pmPtaskDiscountDomain, oldPmPtaskDiscount);
        this.setPtaskDiscountUpdataDefault(pmPtaskDiscount);
        this.updatePtaskDiscountModel(pmPtaskDiscount);
    }

    @Override
    public PmPtaskDiscount getPtaskDiscount(Integer ptaskDiscountId) {
        if (null == ptaskDiscountId) {
            return null;
        }
        return this.getPtaskDiscountModelById(ptaskDiscountId);
    }

    @Override
    public void deletePtaskDiscount(Integer ptaskDiscountId) throws ApiException {
        if (null == ptaskDiscountId) {
            return;
        }
        this.deletePtaskDiscountModel(ptaskDiscountId);
    }

    @Override
    public QueryResult<PmPtaskDiscount> queryPtaskDiscountPage(Map<String, Object> map) {
        List<PmPtaskDiscount> pmPtaskDiscountList = this.queryPtaskDiscountModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtaskDiscount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtaskDiscountList);
        return queryResult;
    }

    @Override
    public PmPtaskDiscount getPtaskDiscountByCode(String tenantCode, String ptaskDiscountCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskDiscountCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskDiscountCode", ptaskDiscountCode);
        return this.getPtaskDiscountModelByCode(map);
    }

    @Override
    public void deletePtaskDiscountByCode(String tenantCode, String ptaskDiscountCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskDiscountCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskDiscountCode", ptaskDiscountCode);
        this.delPtaskDiscountModelByCode(map);
    }

    @Override
    public QueryResult<PmPtaskDiscount> sendPtaskDiscount(String userinfoCode, String ptaskDiscountListCode, String tenantCode) {
        if (StringUtils.isEmpty((String)userinfoCode) || StringUtils.isEmpty((String)ptaskDiscountListCode)) {
            return null;
        }
        PmPtaskDiscountlist ptaskDiscountlistByCode = this.discountlistService.getPtaskDiscountlistByCode(ptaskDiscountListCode, tenantCode);
        if (null == ptaskDiscountlistByCode) {
            this.logger.error("pm.PROMOTION.PmPtaskDiscountServiceImpl.sendPtaskDiscount.ptaskDiscountlistByCode.null", (Object)(ptaskDiscountListCode + "=====" + tenantCode));
            return null;
        }
        if ("0".equals(ptaskDiscountlistByCode.getPtaskDiscountType())) {
            UpmUpointsClearDomain upmUpointsClearDomain = this.makeAddUpmDoamin(ptaskDiscountlistByCode, userinfoCode);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("upmUpointsClearDomain", JsonUtil.buildNonNullBinder().toJson((Object)upmUpointsClearDomain));
            this.internalInvoke("upm.upointsClearBase.sendUpointsClear", paramMap);
        }
        if ("1".equals(ptaskDiscountlistByCode.getPtaskDiscountType())) {
            // empty if block
        }
        return null;
    }

    private UpmUpointsClearDomain makeAddUpmDoamin(PmPtaskDiscountlist ptaskDiscountlistByCode, String userinfoCode) {
        UpmUpointsClearDomain upmUpointsClearDomain = new UpmUpointsClearDomain();
        upmUpointsClearDomain.setUpointsClearDirection("7");
        upmUpointsClearDomain.setUpointsClearNum(ptaskDiscountlistByCode.getPtaskDiscountAmount());
        upmUpointsClearDomain.setPointsRuleApi(ptaskDiscountlistByCode.getChannelsendApiCode());
        upmUpointsClearDomain.setUpointsType("0");
        upmUpointsClearDomain.setUpointsListExcode(String.valueOf((long)ptaskDiscountlistByCode.getPtaskDiscountlistId().intValue() + System.currentTimeMillis()));
        upmUpointsClearDomain.setTenantCode(ptaskDiscountlistByCode.getTenantCode());
        upmUpointsClearDomain.setMemberCode(userinfoCode);
        upmUpointsClearDomain.setUpointsClearOpcode(ptaskDiscountlistByCode.getPtaskDiscountCode());
        return upmUpointsClearDomain;
    }

    private PmUserCouponDomain makeAddPmUserDomain(PmPtaskDiscountlist ptaskDiscountlistByCode, String userinfoCode, PmPromotion promotionByCode) {
        PmUserCouponDomain pmUserCouponDomain = new PmUserCouponDomain();
        pmUserCouponDomain.setPbCode(promotionByCode.getPbCode());
        pmUserCouponDomain.setPbName(promotionByCode.getPbName());
        pmUserCouponDomain.setPromotionOrgin(3);
        pmUserCouponDomain.setPromotionOrgin(3);
        pmUserCouponDomain.setPromotionCode(promotionByCode.getPromotionCode());
        pmUserCouponDomain.setPromotionName(promotionByCode.getPromotionName());
        return pmUserCouponDomain;
    }
}

