/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsTginfoConfigMapper;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoConfigDomain;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoConfigReDomain;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoGoodsReDomain;
import com.yqbsoft.laser.service.portal.domain.OcShoppingGoodsDomain;
import com.yqbsoft.laser.service.portal.domain.OcShoppingpackgeDomain;
import com.yqbsoft.laser.service.portal.model.CmsTginfoConfig;
import com.yqbsoft.laser.service.portal.model.CmsTginfoGoods;
import com.yqbsoft.laser.service.portal.service.CmsTginfoConfigService;
import com.yqbsoft.laser.service.portal.service.CmsTginfoGoodsService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CmsTginfoConfigServiceImpl
extends BaseServiceImpl
implements CmsTginfoConfigService {
    private static final String SYS_CODE = "cms.CmsTginfoConfigServiceImpl";
    private CmsTginfoConfigMapper cmsTginfoConfigMapper;
    private CmsTginfoGoodsService cmsTginfoGoodsService;
    private String cacheTginfoConfig = "CmsTginfo-configCode";
    private String cacheTginfoGoods = "CmsTginfo-GoodsCode";

    public void setCmsTginfoConfigMapper(CmsTginfoConfigMapper cmsTginfoConfigMapper) {
        this.cmsTginfoConfigMapper = cmsTginfoConfigMapper;
    }

    public void setCmsTginfoGoodsService(CmsTginfoGoodsService cmsTginfoGoodsService) {
        this.cmsTginfoGoodsService = cmsTginfoGoodsService;
    }

    private Date getSysDate() {
        try {
            return this.cmsTginfoConfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTginfoConfig(CmsTginfoConfigDomain cmsTginfoConfigDomain) {
        if (null == cmsTginfoConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsTginfoConfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTginfoConfigDefault(CmsTginfoConfig cmsTginfoConfig) {
        if (null == cmsTginfoConfig) {
            return;
        }
        if (null == cmsTginfoConfig.getDataState()) {
            cmsTginfoConfig.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cmsTginfoConfig.getGmtCreate()) {
            cmsTginfoConfig.setGmtCreate(date);
        }
        cmsTginfoConfig.setGmtModified(date);
        if (StringUtils.isBlank((String)cmsTginfoConfig.getTginfoConfigCode())) {
            cmsTginfoConfig.setTginfoConfigCode(this.getNo(null, "CmsTginfoConfig", "cmsTginfoConfig", cmsTginfoConfig.getTenantCode()));
        }
    }

    private int getTginfoConfigMaxCode() {
        int code = 0;
        try {
            return this.cmsTginfoConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.getTginfoConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTginfoConfigUpdataDefault(CmsTginfoConfig cmsTginfoConfig) {
        if (null == cmsTginfoConfig) {
            return;
        }
        cmsTginfoConfig.setGmtModified(this.getSysDate());
    }

    private void saveTginfoConfigModel(CmsTginfoConfig cmsTginfoConfig) throws ApiException {
        if (null == cmsTginfoConfig) {
            return;
        }
        try {
            this.cmsTginfoConfigMapper.insert(cmsTginfoConfig);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.saveTginfoConfigModel.ex", (Throwable)e);
        }
    }

    private void saveTginfoConfigBatchModel(List<CmsTginfoConfig> cmsTginfoConfigList) throws ApiException {
        if (null == cmsTginfoConfigList || cmsTginfoConfigList.isEmpty()) {
            return;
        }
        try {
            this.cmsTginfoConfigMapper.insertBatch(cmsTginfoConfigList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.saveTginfoConfigBatchModel.ex", (Throwable)e);
        }
    }

    private CmsTginfoConfig getTginfoConfigModelById(Integer tginfoConfigId) {
        if (null == tginfoConfigId) {
            return null;
        }
        try {
            return this.cmsTginfoConfigMapper.selectByPrimaryKey(tginfoConfigId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.getTginfoConfigModelById", (Throwable)e);
            return null;
        }
    }

    private CmsTginfoConfig getTginfoConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsTginfoConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.getTginfoConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTginfoConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.delTginfoConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.delTginfoConfigModelByCode.num");
        }
    }

    private void deleteTginfoConfigModel(Integer tginfoConfigId) throws ApiException {
        if (null == tginfoConfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoConfigMapper.deleteByPrimaryKey(tginfoConfigId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.deleteTginfoConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.deleteTginfoConfigModel.num");
        }
    }

    private void updateTginfoConfigModel(CmsTginfoConfig cmsTginfoConfig) throws ApiException {
        if (null == cmsTginfoConfig) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoConfigMapper.updateByPrimaryKey(cmsTginfoConfig);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.updateTginfoConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.updateTginfoConfigModel.num");
        }
    }

    private void updateStateTginfoConfigModel(Integer tginfoConfigId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == tginfoConfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tginfoConfigId", tginfoConfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsTginfoConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.updateStateTginfoConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.updateStateTginfoConfigModel.null");
        }
    }

    private void updateStateTginfoConfigModelByCode(String tenantCode, String tginfoConfigCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)tginfoConfigCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoConfigCode", tginfoConfigCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsTginfoConfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.updateStateTginfoConfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.updateStateTginfoConfigModelByCode.null");
        }
    }

    private CmsTginfoConfig makeTginfoConfig(CmsTginfoConfigDomain cmsTginfoConfigDomain, CmsTginfoConfig cmsTginfoConfig) {
        if (null == cmsTginfoConfigDomain) {
            return null;
        }
        if (null == cmsTginfoConfig) {
            cmsTginfoConfig = new CmsTginfoConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoConfig, (Object)cmsTginfoConfigDomain);
            return cmsTginfoConfig;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.makeTginfoConfig", (Throwable)e);
            return null;
        }
    }

    private CmsTginfoConfigReDomain makeCmsTginfoConfigReDomain(CmsTginfoConfig cmsTginfoConfig) {
        if (null == cmsTginfoConfig) {
            return null;
        }
        CmsTginfoConfigReDomain cmsTginfoConfigReDomain = new CmsTginfoConfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoConfigReDomain, (Object)cmsTginfoConfig);
            return cmsTginfoConfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.makeCmsTginfoConfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsTginfoConfig> queryTginfoConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsTginfoConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.queryTginfoConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countTginfoConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsTginfoConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.countTginfoConfig", (Throwable)e);
        }
        return i;
    }

    private CmsTginfoConfig createCmsTginfoConfig(CmsTginfoConfigDomain cmsTginfoConfigDomain) {
        String msg = this.checkTginfoConfig(cmsTginfoConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.saveTginfoConfig.checkTginfoConfig", msg);
        }
        CmsTginfoConfig cmsTginfoConfig = this.makeTginfoConfig(cmsTginfoConfigDomain, null);
        this.setTginfoConfigDefault(cmsTginfoConfig);
        return cmsTginfoConfig;
    }

    @Override
    public String saveTginfoConfig(CmsTginfoConfigDomain cmsTginfoConfigDomain) throws ApiException {
        CmsTginfoConfig cmsTginfoConfig = this.createCmsTginfoConfig(cmsTginfoConfigDomain);
        this.saveTginfoConfigModel(cmsTginfoConfig);
        if (0 == cmsTginfoConfig.getDataState()) {
            this.updateCache(cmsTginfoConfig);
        }
        return cmsTginfoConfig.getTginfoConfigCode();
    }

    @Override
    public String saveTginfoConfigBatch(List<CmsTginfoConfigDomain> cmsTginfoConfigDomainList) throws ApiException {
        if (null == cmsTginfoConfigDomainList || cmsTginfoConfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsTginfoConfig> cmsTginfoConfigList = new ArrayList<CmsTginfoConfig>();
        String code = "";
        for (CmsTginfoConfigDomain cmsTginfoConfigDomain : cmsTginfoConfigDomainList) {
            CmsTginfoConfig cmsTginfoConfig = this.createCmsTginfoConfig(cmsTginfoConfigDomain);
            code = cmsTginfoConfig.getTginfoConfigCode();
            cmsTginfoConfigList.add(cmsTginfoConfig);
        }
        this.saveTginfoConfigBatchModel(cmsTginfoConfigList);
        if (ListUtil.isNotEmpty(cmsTginfoConfigList)) {
            for (CmsTginfoConfig tginfoConfig : cmsTginfoConfigList) {
                if (0 != tginfoConfig.getDataState()) continue;
                this.updateCache(tginfoConfig);
            }
        }
        return code;
    }

    @Override
    public void updateTginfoConfigState(Integer tginfoConfigId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == tginfoConfigId) {
            return;
        }
        this.updateStateTginfoConfigModel(tginfoConfigId, dataState, oldDataState, map);
        if (0 == dataState) {
            CmsTginfoConfig tginfoConfig = this.getTginfoConfig(tginfoConfigId);
            this.updateCache(tginfoConfig);
        } else {
            CmsTginfoConfig tginfoConfig = this.getTginfoConfig(tginfoConfigId);
            this.deleteCache(tginfoConfig);
        }
    }

    @Override
    public void updateTginfoConfigStateByCode(String tenantCode, String tginfoConfigCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)tginfoConfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateTginfoConfigModelByCode(tenantCode, tginfoConfigCode, dataState, oldDataState, map);
        if (0 == dataState) {
            CmsTginfoConfig tginfoConfig = this.getTginfoConfigByCode(tenantCode, tginfoConfigCode);
            this.updateCache(tginfoConfig);
        } else {
            CmsTginfoConfig tginfoConfig = this.getTginfoConfigByCode(tenantCode, tginfoConfigCode);
            this.deleteCache(tginfoConfig);
        }
    }

    @Override
    public void updateTginfoConfig(CmsTginfoConfigDomain cmsTginfoConfigDomain) throws ApiException {
        String msg = this.checkTginfoConfig(cmsTginfoConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.updateTginfoConfig.checkTginfoConfig", msg);
        }
        CmsTginfoConfig oldCmsTginfoConfig = this.getTginfoConfigModelById(cmsTginfoConfigDomain.getTginfoConfigId());
        if (null == oldCmsTginfoConfig) {
            throw new ApiException("cms.CmsTginfoConfigServiceImpl.updateTginfoConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsTginfoConfig cmsTginfoConfig = this.makeTginfoConfig(cmsTginfoConfigDomain, oldCmsTginfoConfig);
        this.setTginfoConfigUpdataDefault(cmsTginfoConfig);
        this.updateTginfoConfigModel(cmsTginfoConfig);
        if (0 == cmsTginfoConfig.getDataState()) {
            this.updateCache(cmsTginfoConfig);
        } else {
            this.deleteCache(cmsTginfoConfig);
        }
    }

    @Override
    public CmsTginfoConfig getTginfoConfig(Integer tginfoConfigId) {
        if (null == tginfoConfigId) {
            return null;
        }
        return this.getTginfoConfigModelById(tginfoConfigId);
    }

    @Override
    public void deleteTginfoConfig(Integer tginfoConfigId) throws ApiException {
        if (null == tginfoConfigId) {
            return;
        }
        CmsTginfoConfig tginfoConfig = this.getTginfoConfig(tginfoConfigId);
        this.deleteTginfoConfigModel(tginfoConfigId);
        this.deleteCache(tginfoConfig);
    }

    @Override
    public QueryResult<CmsTginfoConfig> queryTginfoConfigPage(Map<String, Object> map) {
        List<CmsTginfoConfig> cmsTginfoConfigList = this.queryTginfoConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTginfoConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsTginfoConfigList);
        return queryResult;
    }

    @Override
    public CmsTginfoConfig getTginfoConfigByCode(String tenantCode, String tginfoConfigCode) throws ApiException {
        if (StringUtils.isBlank((String)tginfoConfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoConfigCode", tginfoConfigCode);
        return this.getTginfoConfigModelByCode(map);
    }

    @Override
    public void deleteTginfoConfigByCode(String tenantCode, String tginfoConfigCode) throws ApiException {
        if (StringUtils.isBlank((String)tginfoConfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("tginfoConfigCode", tginfoConfigCode);
        CmsTginfoConfig tginfoConfig = this.getTginfoConfigByCode(tenantCode, tginfoConfigCode);
        this.delTginfoConfigModelByCode(map);
        this.deleteCache(tginfoConfig);
    }

    @Override
    public void queryTginfoConfigCache() throws ApiException {
        List<CmsTginfoConfig> cmsTginfoConfigs;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("dataState", 0);
        DisUtil.delVer((String)this.cacheTginfoConfig);
        Map tginfoConfigs = DisUtil.getRemotMapAll((String)this.cacheTginfoConfig);
        if (MapUtil.isNotEmpty((Map)tginfoConfigs)) {
            for (Map.Entry stringStringEntry : tginfoConfigs.entrySet()) {
                String value = (String)stringStringEntry.getValue();
                CmsTginfoConfig cmsTginfoConfig = (CmsTginfoConfig)JsonUtil.buildNormalBinder().getJsonToObject(value, CmsTginfoConfig.class);
                DisUtil.delVer((String)(this.cacheTginfoGoods + "-" + cmsTginfoConfig.getTginfoConfigCode() + "-" + cmsTginfoConfig.getTenantCode()));
            }
        }
        if (null == (cmsTginfoConfigs = this.queryTginfoConfigModelPage(param)) || cmsTginfoConfigs.isEmpty()) {
            this.logger.info("cms.CmsTginfoConfigServiceImpl.queryTginfoConfigCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> tginfoConfigMap = new ConcurrentHashMap<String, String>();
        for (CmsTginfoConfig cmsTginfoConfig : cmsTginfoConfigs) {
            tginfoConfigMap.put(cmsTginfoConfig.getTginfoCode() + "-" + cmsTginfoConfig.getTenantCode(), JsonUtil.buildNormalBinder().toJson((Object)cmsTginfoConfig));
            this.setCache(cmsTginfoConfig);
        }
        DisUtil.setMapVer((String)this.cacheTginfoConfig, tginfoConfigMap);
    }

    private void updateCache(CmsTginfoConfig cmsTginfoConfig) {
        if (null == cmsTginfoConfig) {
            return;
        }
        DisUtil.delVer((String)(this.cacheTginfoGoods + "-" + cmsTginfoConfig.getTginfoConfigCode() + "-" + cmsTginfoConfig.getTenantCode()));
        DisUtil.setMapVer((String)this.cacheTginfoConfig, (String)(cmsTginfoConfig.getTginfoCode() + "-" + cmsTginfoConfig.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson((Object)cmsTginfoConfig));
        this.setCache(cmsTginfoConfig);
    }

    private void deleteCache(CmsTginfoConfig cmsTginfoConfig) {
        if (null == cmsTginfoConfig) {
            return;
        }
        DisUtil.delVer((String)(this.cacheTginfoGoods + "-" + cmsTginfoConfig.getTginfoConfigCode() + "-" + cmsTginfoConfig.getTenantCode()));
        DisUtil.delMap((String)this.cacheTginfoConfig, (String[])new String[]{cmsTginfoConfig.getTginfoCode() + "-" + cmsTginfoConfig.getTenantCode()});
    }

    private void setCache(CmsTginfoConfig cmsTginfoConfig) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("dataState", 0);
        param.put("tginfoConfigCode", cmsTginfoConfig.getTginfoConfigCode());
        param.put("tenantCode", cmsTginfoConfig.getTenantCode());
        QueryResult<CmsTginfoGoods> cmsTginfoGoodsQueryResult = this.cmsTginfoGoodsService.queryTginfoGoodsPage(param);
        ConcurrentHashMap<String, String> tginfoGoodsMap = new ConcurrentHashMap<String, String>();
        if (ListUtil.isNotEmpty((Collection)cmsTginfoGoodsQueryResult.getList())) {
            for (CmsTginfoGoods cmsTginfoGoods : cmsTginfoGoodsQueryResult.getList()) {
                if (StringUtils.isBlank((String)cmsTginfoGoods.getTginfoGoodsTerm())) {
                    cmsTginfoGoods.setTginfoGoodsTerm("=");
                }
                tginfoGoodsMap.put(cmsTginfoGoods.getTginfoGoodsType() + "-" + cmsTginfoGoods.getTginfoGoodsValue(), JsonUtil.buildNormalBinder().toJson((Object)cmsTginfoGoods));
            }
        }
        DisUtil.setMapVer((String)(this.cacheTginfoGoods + "-" + cmsTginfoConfig.getTginfoConfigCode() + "-" + cmsTginfoConfig.getTenantCode()), tginfoGoodsMap);
    }

    @Override
    public List<OcShoppingpackgeDomain> checkContractGoodsMemo(String tenantCode, String tginfoCode, List<OcShoppingpackgeDomain> shoppingpackageList) throws ApiException {
        if (StringUtils.isBlank((String)tginfoCode)) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.checkContractGoodsMemo tginfoCode is null");
            return shoppingpackageList;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.checkContractGoodsMemo tenantCode is null");
            return shoppingpackageList;
        }
        if (ListUtil.isEmpty(shoppingpackageList)) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.checkContractGoodsMemo shoppingpackageList is null");
            return shoppingpackageList;
        }
        String tginfoConfigJson = SupDisUtil.getRemotMap((String)this.cacheTginfoConfig, (String)(tginfoCode + "-" + tenantCode));
        CmsTginfoConfigReDomain tginfoConfigReDomain = null;
        if (StringUtils.isNotBlank((String)tginfoConfigJson)) {
            tginfoConfigReDomain = (CmsTginfoConfigReDomain)JsonUtil.buildNormalBinder().getJsonToObject(tginfoConfigJson, CmsTginfoConfigReDomain.class);
        }
        if (null == tginfoConfigReDomain) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.checkContractGoodsMemo tginfoConfigReDomain is null");
            return shoppingpackageList;
        }
        Map tginfoGoodsMap = DisUtil.getRemotMapAll((String)(this.cacheTginfoGoods + "-" + tginfoConfigReDomain.getTginfoConfigCode() + "-" + tginfoConfigReDomain.getTenantCode()));
        List<OcShoppingGoodsDomain> shoppingGoodsList = null;
        for (OcShoppingpackgeDomain ocShoppingpackgeDomain : shoppingpackageList) {
            shoppingGoodsList = ocShoppingpackgeDomain.getShoppingGoodsList();
            if (ListUtil.isEmpty(shoppingGoodsList)) continue;
            for (OcShoppingGoodsDomain ocShoppingGoodsDomain : shoppingGoodsList) {
                if (!this.chenckMemoFlag(tginfoConfigReDomain, tginfoGoodsMap, ocShoppingGoodsDomain)) continue;
                ocShoppingGoodsDomain.setMemoFlag(true);
            }
        }
        return shoppingpackageList;
    }

    private boolean chenckMemoFlag(CmsTginfoConfigReDomain tginfoConfigReDomain, Map<String, String> tginfoGoodsMap, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == tginfoConfigReDomain) {
            return false;
        }
        if (0 == tginfoConfigReDomain.getGoodsMemoshow()) {
            return false;
        }
        return 1 != tginfoConfigReDomain.getGoodsMemoshow() || !this.checkGoodsMap(ocShoppingGoodsDomain, tginfoGoodsMap);
    }

    private boolean checkGoodsMap(OcShoppingGoodsDomain ocShoppingGoodsDomain, Map<String, String> tginfoGoodsMap) {
        if (MapUtil.isEmpty(tginfoGoodsMap)) {
            return false;
        }
        HashMap maps = new HashMap();
        String key1 = null;
        String tginfoGoodsJson = null;
        CmsTginfoGoodsReDomain tginfoGoodsReDomain = null;
        for (String key : tginfoGoodsMap.keySet()) {
            Map<String, String> map;
            String[] keys = key.split("-");
            tginfoGoodsJson = tginfoGoodsMap.get(key);
            tginfoGoodsReDomain = (CmsTginfoGoodsReDomain)JsonUtil.buildNormalBinder().getJsonToObject(tginfoGoodsJson, CmsTginfoGoodsReDomain.class);
            if (StringUtils.isBlank((String)tginfoGoodsReDomain.getTginfoGoodsTerm())) {
                tginfoGoodsReDomain.setTginfoGoodsTerm("=");
            }
            if (null == maps.get(key1 = keys[0] + "-" + tginfoGoodsReDomain.getTginfoGoodsTerm())) {
                map = new HashMap<String, String>();
                ((HashMap)map).put(keys[1], tginfoGoodsMap.get(key));
                maps.put(key1, map);
                continue;
            }
            map = (Map)maps.get(key1);
            map.put(keys[1], tginfoGoodsMap.get(key));
        }
        if (MapUtil.isEmpty(maps)) {
            this.logger.error("cms.CmsTginfoConfigServiceImpl.checkGoodsMap maps is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocShoppingGoodsDomain));
            return true;
        }
        tginfoGoodsJson = null;
        Map map = null;
        boolean checkFlag = true;
        for (String type : maps.keySet()) {
            map = (Map)maps.get(type);
            String[] split = type.split("-");
            this.logger.error("cms.CmsTginfoConfigServiceImpl.checkGoodsMap type is ", (Object)type);
            Object obj = BeanUtils.newForceGetProperty((Object)ocShoppingGoodsDomain, (String)split[0]);
            if (null == obj) {
                checkFlag = false;
                this.logger.error("cms.CmsTginfoConfigServiceImpl.checkGoodsMap obj is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocShoppingGoodsDomain));
                break;
            }
            String code = null;
            if (!(obj instanceof String)) {
                this.logger.error("cms.CmsTginfoConfigServiceImpl.checkGoodsMap obj type is error", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocShoppingGoodsDomain));
                checkFlag = false;
                break;
            }
            code = (String)obj;
            if (StringUtils.isBlank((String)code)) {
                this.logger.error("cms.CmsTginfoConfigServiceImpl.checkGoodsMap code  is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocShoppingGoodsDomain));
                checkFlag = false;
                break;
            }
            tginfoGoodsJson = (String)map.get(code);
            if ("=".equals(split[1])) {
                if (!StringUtils.isBlank((String)tginfoGoodsJson)) continue;
                checkFlag = false;
                break;
            }
            if ("!=".equals(split[1])) {
                if (!StringUtils.isNotBlank((String)tginfoGoodsJson)) continue;
                checkFlag = false;
                break;
            }
            checkFlag = false;
            break;
        }
        return !checkFlag;
    }
}

