/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtOpContractMapper;
import com.yqbsoft.laser.service.potential.dao.PtOpContractTaskMapper;
import com.yqbsoft.laser.service.potential.domain.PtOpContractDomain;
import com.yqbsoft.laser.service.potential.domain.PtOpContractTaskDomain;
import com.yqbsoft.laser.service.potential.domain.PtOpContractTaskReDomain;
import com.yqbsoft.laser.service.potential.domain.imports.PtOpContractTaskEngineeringImportDomin;
import com.yqbsoft.laser.service.potential.domain.imports.PtOpContractTaskHomeImportDomin;
import com.yqbsoft.laser.service.potential.domain.imports.PtOpContractTaskImportBaseDomin;
import com.yqbsoft.laser.service.potential.domain.imports.PtOpContractTaskRetailImportDomin;
import com.yqbsoft.laser.service.potential.domain.imports.PtOpContractTaskTripartiteImportDomin;
import com.yqbsoft.laser.service.potential.enums.ContractChannelTypeEnum;
import com.yqbsoft.laser.service.potential.enums.ContractTaskTypeEnum;
import com.yqbsoft.laser.service.potential.model.PtOpContractTask;
import com.yqbsoft.laser.service.potential.service.PtOpContractTaskService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class PtOpContractTaskServiceImpl
extends BaseServiceImpl
implements PtOpContractTaskService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtOpContractTaskServiceImpl";
    private PtOpContractTaskMapper ptOpContractTaskMapper;
    private PtOpContractMapper ptOpContractMapper;

    public void setPtOpContractTaskMapper(PtOpContractTaskMapper ptOpContractTaskMapper) {
        this.ptOpContractTaskMapper = ptOpContractTaskMapper;
    }

    public void setPtOpContractMapper(PtOpContractMapper ptOpContractMapper) {
        this.ptOpContractMapper = ptOpContractMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptOpContractTaskMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtOpContractTask(PtOpContractTaskDomain domain) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getOpcontractCode())) {
            msg = msg + "\u5408\u540c\u7f16\u7801 \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractTkKind())) {
            msg = msg + "\u5408\u540c\u4efb\u52a1\u7c7b\u578b \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractTkType())) {
            msg = msg + "\u5408\u540c\u4efb\u52a1\u79cd\u7c7b \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    private void setPtOpContractTaskDefault(PtOpContractTask ptOpContractTask) {
        if (null == ptOpContractTask) {
            return;
        }
        if (null == ptOpContractTask.getDataState()) {
            ptOpContractTask.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ptOpContractTask.getGmtCreate()) {
            ptOpContractTask.setGmtCreate(date);
        }
        ptOpContractTask.setGmtModified(date);
        if (StringUtils.isBlank((String)ptOpContractTask.getOpcontractTkCode())) {
            ptOpContractTask.setOpcontractTkCode(this.getNo(null, "PtOpContractTask", "ptOpContractTask", ptOpContractTask.getTenantCode()));
        }
    }

    private int getPtOpContractTaskMaxCode() {
        int code = 0;
        try {
            return this.ptOpContractTaskMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.getPtOpContractTaskMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtOpContractTaskUpdataDefault(PtOpContractTask ptOpContractTask) {
        if (null == ptOpContractTask) {
            return;
        }
        ptOpContractTask.setGmtModified(this.getSysDate());
    }

    private void savePtOpContractTaskModel(PtOpContractTask ptOpContractTask) throws ApiException {
        if (null == ptOpContractTask) {
            return;
        }
        try {
            this.ptOpContractTaskMapper.insert(ptOpContractTask);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.savePtOpContractTaskModel.ex", (Throwable)e);
        }
    }

    private void savePtOpContractTaskBatchModel(List<PtOpContractTask> ptOpContractTaskList) throws ApiException {
        if (null == ptOpContractTaskList || ptOpContractTaskList.isEmpty()) {
            return;
        }
        try {
            this.ptOpContractTaskMapper.insertBatch(ptOpContractTaskList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.savePtOpContractTaskBatchModel.ex", (Throwable)e);
        }
    }

    private PtOpContractTask getPtOpContractTaskModelById(Integer opcontractTkId) {
        if (null == opcontractTkId) {
            return null;
        }
        try {
            return this.ptOpContractTaskMapper.selectByPrimaryKey(opcontractTkId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.getPtOpContractTaskModelById", (Throwable)e);
            return null;
        }
    }

    private PtOpContractTask getPtOpContractTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptOpContractTaskMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.getPtOpContractTaskModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtOpContractTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.delPtOpContractTaskModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.delPtOpContractTaskModelByCode.num");
        }
    }

    private void deletePtOpContractTaskModel(Integer opcontractTkId) throws ApiException {
        if (null == opcontractTkId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.deleteByPrimaryKey(opcontractTkId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.deletePtOpContractTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.deletePtOpContractTaskModel.num");
        }
    }

    private void updatePtOpContractTaskModel(PtOpContractTask ptOpContractTask) throws ApiException {
        if (null == ptOpContractTask) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.updateByPrimaryKey(ptOpContractTask);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updatePtOpContractTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updatePtOpContractTaskModel.num");
        }
    }

    private void updateStatePtOpContractTaskModel(Integer opcontractTkId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opcontractTkId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opcontractTkId", opcontractTkId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updateStatePtOpContractTaskModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updateStatePtOpContractTaskModel.null");
        }
    }

    private void updateStatePtOpContractTaskModelByCode(String tenantCode, String opcontractTkCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opcontractTkCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractTkCode", opcontractTkCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updateStatePtOpContractTaskModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updateStatePtOpContractTaskModelByCode.null");
        }
    }

    private PtOpContractTask makePtOpContractTask(PtOpContractTaskDomain ptOpContractTaskDomain, PtOpContractTask ptOpContractTask) {
        if (null == ptOpContractTaskDomain) {
            return null;
        }
        if (null == ptOpContractTask) {
            ptOpContractTask = new PtOpContractTask();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptOpContractTask, (Object)ptOpContractTaskDomain);
            return ptOpContractTask;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.makePtOpContractTask", (Throwable)e);
            return null;
        }
    }

    private PtOpContractTaskReDomain makePtOpContractTaskReDomain(PtOpContractTask ptOpContractTask) {
        if (null == ptOpContractTask) {
            return null;
        }
        PtOpContractTaskReDomain ptOpContractTaskReDomain = new PtOpContractTaskReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptOpContractTaskReDomain, (Object)ptOpContractTask);
            return ptOpContractTaskReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.makePtOpContractTaskReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtOpContractTask> queryPtOpContractTaskModelPage(Map<String, Object> parammap) {
        try {
            return this.ptOpContractTaskMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.queryPtOpContractTaskModel", (Throwable)e);
            return null;
        }
    }

    private int countPtOpContractTask(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.countPtOpContractTask", (Throwable)e);
        }
        return i;
    }

    private PtOpContractTask createPtOpContractTask(PtOpContractTaskDomain ptOpContractTaskDomain) {
        String msg = this.checkPtOpContractTask(ptOpContractTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.savePtOpContractTask.checkPtOpContractTask", msg);
        }
        PtOpContractTask ptOpContractTask = this.makePtOpContractTask(ptOpContractTaskDomain, null);
        this.setPtOpContractTaskDefault(ptOpContractTask);
        return ptOpContractTask;
    }

    @Override
    public String savePtOpContractTask(PtOpContractTaskDomain ptOpContractTaskDomain) throws ApiException {
        PtOpContractTask ptOpContractTask = this.createPtOpContractTask(ptOpContractTaskDomain);
        this.savePtOpContractTaskModel(ptOpContractTask);
        return ptOpContractTask.getOpcontractTkCode();
    }

    @Override
    public String savePtOpContractTaskBatch(List<PtOpContractTaskDomain> ptOpContractTaskDomainList) throws ApiException {
        if (null == ptOpContractTaskDomainList || ptOpContractTaskDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtOpContractTask> ptOpContractTaskList = new ArrayList<PtOpContractTask>();
        String code = "";
        for (PtOpContractTaskDomain ptOpContractTaskDomain : ptOpContractTaskDomainList) {
            PtOpContractTask ptOpContractTask = this.createPtOpContractTask(ptOpContractTaskDomain);
            code = ptOpContractTask.getOpcontractTkCode();
            ptOpContractTaskList.add(ptOpContractTask);
        }
        this.savePtOpContractTaskBatchModel(ptOpContractTaskList);
        return code;
    }

    @Override
    public void updatePtOpContractTaskState(Integer opcontractTkId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opcontractTkId) {
            return;
        }
        this.updateStatePtOpContractTaskModel(opcontractTkId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtOpContractTaskStateByCode(String tenantCode, String opcontractTkCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opcontractTkCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtOpContractTaskModelByCode(tenantCode, opcontractTkCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtOpContractTask(PtOpContractTaskDomain ptOpContractTaskDomain) throws ApiException {
        String msg = this.checkPtOpContractTask(ptOpContractTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updatePtOpContractTask.checkPtOpContractTask", msg);
        }
        PtOpContractTask oldPtOpContractTask = this.getPtOpContractTaskModelById(ptOpContractTaskDomain.getOpcontractTkId());
        if (null == oldPtOpContractTask) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updatePtOpContractTask.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtOpContractTask ptOpContractTask = this.makePtOpContractTask(ptOpContractTaskDomain, oldPtOpContractTask);
        this.setPtOpContractTaskUpdataDefault(ptOpContractTask);
        this.updatePtOpContractTaskModel(ptOpContractTask);
    }

    @Override
    public void updatePtOpContractTaskList(PtOpContractDomain contractDomain) throws ApiException {
        List<PtOpContractTaskDomain> taskDomainList = contractDomain.getContractTaskList();
        if (ListUtil.isEmpty(taskDomainList)) {
            return;
        }
        List idList = taskDomainList.stream().map(PtOpContractTaskDomain::getOpcontractTkId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Integer> dbIdList = this.ptOpContractTaskMapper.queryIdList(contractDomain.getOpcontractCode());
        Collection deleteIdList = CollectionUtils.subtract(dbIdList, idList);
        for (PtOpContractTaskDomain taskDomain : taskDomainList) {
            taskDomain.setOpcontractCode(contractDomain.getOpcontractCode());
            taskDomain.setTenantCode(contractDomain.getTenantCode());
            taskDomain.setChannelCode(contractDomain.getChannelCode());
            taskDomain.setChannelName(contractDomain.getChannelName());
            if (Objects.isNull(taskDomain.getOpcontractTkId())) {
                taskDomain.setOpcontractTkCode(this.getNo(null, "PtOpContractTask", "ptOpContractTask", taskDomain.getTenantCode()));
                taskDomain.setUserCode(contractDomain.getUserCode());
                taskDomain.setUserName(contractDomain.getUserName());
                this.savePtOpContractTask(taskDomain);
                continue;
            }
            taskDomain.setUserEcode(contractDomain.getUserCode());
            taskDomain.setUserEname(contractDomain.getUserName());
            this.updatePtOpContractTask(taskDomain);
        }
        if (ListUtil.isNotEmpty((Collection)deleteIdList)) {
            deleteIdList.forEach(this::deletePtOpContractTask);
        }
    }

    @Override
    public PtOpContractTask getPtOpContractTask(Integer opcontractTkId) {
        if (null == opcontractTkId) {
            return null;
        }
        return this.getPtOpContractTaskModelById(opcontractTkId);
    }

    @Override
    public void deletePtOpContractTask(Integer opcontractTkId) throws ApiException {
        if (null == opcontractTkId) {
            return;
        }
        this.deletePtOpContractTaskModel(opcontractTkId);
    }

    @Override
    public QueryResult<PtOpContractTask> queryPtOpContractTaskPage(Map<String, Object> map) {
        List<PtOpContractTask> ptOpContractTaskList = this.queryPtOpContractTaskModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtOpContractTask(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptOpContractTaskList);
        return queryResult;
    }

    @Override
    public PtOpContractTask getPtOpContractTaskByCode(String tenantCode, String opcontractTkCode) throws ApiException {
        if (StringUtils.isBlank((String)opcontractTkCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractTkCode", opcontractTkCode);
        return this.getPtOpContractTaskModelByCode(map);
    }

    @Override
    public void deletePtOpContractTaskByCode(String tenantCode, String opcontractTkCode) throws ApiException {
        if (StringUtils.isBlank((String)opcontractTkCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractTkCode", opcontractTkCode);
        this.delPtOpContractTaskModelByCode(map);
    }

    @Override
    public JSONObject checkImportList(JSONArray importList, Integer channelType) throws ApiException {
        if (Objects.isNull(importList) || importList.isEmpty() || Objects.isNull(channelType)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.checkImportList.ex \u53c2\u6570\u4e3a\u7a7a");
        }
        ContractChannelTypeEnum type = ContractChannelTypeEnum.fromCode(channelType);
        if (Objects.isNull((Object)type)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.checkImportList.ex \u6e20\u9053\u9519\u8bef", channelType + "");
        }
        switch (type) {
            case RETAIL: {
                return this.checkImportData(importList.toJavaList(PtOpContractTaskRetailImportDomin.class), this::importCheckRetail);
            }
            case HOME_DECORATION: {
                return this.checkImportData(importList.toJavaList(PtOpContractTaskHomeImportDomin.class), this::importCheckHome);
            }
            case ENGINEERING: {
                return this.checkImportData(importList.toJavaList(PtOpContractTaskEngineeringImportDomin.class), this::importCheckEngineering);
            }
            case TRIPARTITE: {
                return this.checkImportData(importList.toJavaList(PtOpContractTaskTripartiteImportDomin.class), this::importCheckTripartite);
            }
        }
        throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.checkImportList.ex \u6e20\u9053\u9519\u8bef", channelType + "");
    }

    private <T> JSONObject checkImportData(List<T> list, BiConsumer<JSONObject, List<T>> checkMethod) {
        JSONObject result = new JSONObject();
        checkMethod.accept(result, list);
        return result;
    }

    private <T extends PtOpContractTaskImportBaseDomin> void checkImportDataCommon(JSONObject result, List<T> list, Predicate<T> checkMethod) {
        ArrayList<PtOpContractTaskDomain> passList = new ArrayList<PtOpContractTaskDomain>(list.size());
        JSONArray failList = new JSONArray();
        for (final PtOpContractTaskImportBaseDomin domin : list) {
            if (StringUtils.isBlank((String)domin.getOpcontractCode())) {
                domin.setMemo("\u5408\u540c\u7f16\u7801 \u4e3a\u7a7a");
                failList.add((Object)domin);
                continue;
            }
            int opcontractCodeCount = this.ptOpContractMapper.count((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("opcontractCode", domin.getOpcontractCode());
                }
            });
            if (opcontractCodeCount < 1) {
                domin.setMemo("\u5408\u540c\u7f16\u7801 \u4e0d\u5b58\u5728");
                failList.add((Object)domin);
                continue;
            }
            if (checkMethod.test(domin)) {
                List<PtOpContractTaskDomain> listDetails = this.convertToTaskList(domin);
                passList.addAll(listDetails);
                continue;
            }
            failList.add((Object)domin);
        }
        result.put("passList", passList);
        result.put("failList", (Object)failList);
    }

    private List<PtOpContractTaskDomain> convertToTaskList(PtOpContractTaskImportBaseDomin domin) {
        ArrayList<PtOpContractTaskDomain> list = new ArrayList<PtOpContractTaskDomain>();
        List<BigDecimal> newStoreCounts = Arrays.asList(domin.getNewStoreCount1(), domin.getNewStoreCount2(), domin.getNewStoreCount3(), domin.getNewStoreCount4(), domin.getNewStoreCount5(), domin.getNewStoreCount6(), domin.getNewStoreCount7(), domin.getNewStoreCount8(), domin.getNewStoreCount9(), domin.getNewStoreCount10(), domin.getNewStoreCount11(), domin.getNewStoreCount12());
        PtOpContractTaskDomain newStore = this.createTaskDomain(domin, this.convertToChannelTypeEnum(domin), ContractTaskTypeEnum.NEW_STORE_COUNT, newStoreCounts);
        list.add(newStore);
        List<BigDecimal> oldStoreCounts = Arrays.asList(domin.getOldStoreRenovationCount1(), domin.getOldStoreRenovationCount2(), domin.getOldStoreRenovationCount3(), domin.getOldStoreRenovationCount4(), domin.getOldStoreRenovationCount5(), domin.getOldStoreRenovationCount6(), domin.getOldStoreRenovationCount7(), domin.getOldStoreRenovationCount8(), domin.getOldStoreRenovationCount9(), domin.getOldStoreRenovationCount10(), domin.getOldStoreRenovationCount11(), domin.getOldStoreRenovationCount12());
        PtOpContractTaskDomain oldStore = this.createTaskDomain(domin, this.convertToChannelTypeEnum(domin), ContractTaskTypeEnum.OLD_STORE_RENOVATION_COUNT, oldStoreCounts);
        list.add(oldStore);
        List<BigDecimal> sinkStoreCounts = Arrays.asList(domin.getSinkStoreCount1(), domin.getSinkStoreCount2(), domin.getSinkStoreCount3(), domin.getSinkStoreCount4(), domin.getSinkStoreCount5(), domin.getSinkStoreCount6(), domin.getSinkStoreCount7(), domin.getSinkStoreCount8(), domin.getSinkStoreCount9(), domin.getSinkStoreCount10(), domin.getSinkStoreCount11(), domin.getSinkStoreCount12());
        PtOpContractTaskDomain sinkStore = this.createTaskDomain(domin, this.convertToChannelTypeEnum(domin), ContractTaskTypeEnum.SINK_STORE_COUNT, sinkStoreCounts);
        list.add(sinkStore);
        if (domin instanceof PtOpContractTaskRetailImportDomin) {
            PtOpContractTaskRetailImportDomin retail = (PtOpContractTaskRetailImportDomin)domin;
            List<BigDecimal> standardProductTaskCounts = Arrays.asList(retail.getStandardProductTask1(), retail.getStandardProductTask2(), retail.getStandardProductTask3(), retail.getStandardProductTask4(), retail.getStandardProductTask5(), retail.getStandardProductTask6(), retail.getStandardProductTask7(), retail.getStandardProductTask8(), retail.getStandardProductTask9(), retail.getStandardProductTask10(), retail.getStandardProductTask11(), retail.getStandardProductTask12());
            PtOpContractTaskDomain standardProductTask = this.createTaskDomain(domin, ContractChannelTypeEnum.RETAIL, ContractTaskTypeEnum.STANDARD_PRODUCT_TASK, standardProductTaskCounts);
            list.add(standardProductTask);
            List<BigDecimal> customShowerCabinetTaskCounts = Arrays.asList(retail.getCustomShowerCabinetTask1(), retail.getCustomShowerCabinetTask2(), retail.getCustomShowerCabinetTask3(), retail.getCustomShowerCabinetTask4(), retail.getCustomShowerCabinetTask5(), retail.getCustomShowerCabinetTask6(), retail.getCustomShowerCabinetTask7(), retail.getCustomShowerCabinetTask8(), retail.getCustomShowerCabinetTask9(), retail.getCustomShowerCabinetTask10(), retail.getCustomShowerCabinetTask11(), retail.getCustomShowerCabinetTask12());
            PtOpContractTaskDomain customShowerCabinetTask = this.createTaskDomain(domin, ContractChannelTypeEnum.RETAIL, ContractTaskTypeEnum.CUSTOM_SHOWER_CABINET_TASK, customShowerCabinetTaskCounts);
            list.add(customShowerCabinetTask);
            List<BigDecimal> customShowerRoomTaskCounts = Arrays.asList(retail.getCustomShowerRoomTask1(), retail.getCustomShowerRoomTask2(), retail.getCustomShowerRoomTask3(), retail.getCustomShowerRoomTask4(), retail.getCustomShowerRoomTask5(), retail.getCustomShowerRoomTask6(), retail.getCustomShowerRoomTask7(), retail.getCustomShowerRoomTask8(), retail.getCustomShowerRoomTask9(), retail.getCustomShowerRoomTask10(), retail.getCustomShowerRoomTask11(), retail.getCustomShowerRoomTask12());
            PtOpContractTaskDomain customShowerRoomTask = this.createTaskDomain(domin, ContractChannelTypeEnum.RETAIL, ContractTaskTypeEnum.CUSTOM_SHOWER_ROOM_TASK, customShowerRoomTaskCounts);
            list.add(customShowerRoomTask);
            List<BigDecimal> customBalconyCabinetTaskCounts = Arrays.asList(retail.getCustomBalconyCabinetTask1(), retail.getCustomBalconyCabinetTask2(), retail.getCustomBalconyCabinetTask3(), retail.getCustomBalconyCabinetTask4(), retail.getCustomBalconyCabinetTask5(), retail.getCustomBalconyCabinetTask6(), retail.getCustomBalconyCabinetTask7(), retail.getCustomBalconyCabinetTask8(), retail.getCustomBalconyCabinetTask9(), retail.getCustomBalconyCabinetTask10(), retail.getCustomBalconyCabinetTask11(), retail.getCustomBalconyCabinetTask12());
            PtOpContractTaskDomain customBalconyCabinetTask = this.createTaskDomain(domin, ContractChannelTypeEnum.RETAIL, ContractTaskTypeEnum.CUSTOM_BALCONY_CABINET_TASK, customBalconyCabinetTaskCounts);
            list.add(customBalconyCabinetTask);
            List<BigDecimal> clothesHangerTaskCounts = Arrays.asList(retail.getClothesHangerTask1(), retail.getClothesHangerTask2(), retail.getClothesHangerTask3(), retail.getClothesHangerTask4(), retail.getClothesHangerTask5(), retail.getClothesHangerTask6(), retail.getClothesHangerTask7(), retail.getClothesHangerTask8(), retail.getClothesHangerTask9(), retail.getClothesHangerTask10(), retail.getClothesHangerTask11(), retail.getClothesHangerTask12());
            PtOpContractTaskDomain clothesHangerTask = this.createTaskDomain(domin, ContractChannelTypeEnum.RETAIL, ContractTaskTypeEnum.CLOTHES_HANGER_TASK, clothesHangerTaskCounts);
            list.add(clothesHangerTask);
            List<Integer> customTypes = Arrays.asList(ContractTaskTypeEnum.CUSTOM_SHOWER_CABINET_TASK.getCode(), ContractTaskTypeEnum.CUSTOM_SHOWER_ROOM_TASK.getCode(), ContractTaskTypeEnum.CUSTOM_BALCONY_CABINET_TASK.getCode(), ContractTaskTypeEnum.CLOTHES_HANGER_TASK.getCode());
            PtOpContractTaskDomain customTotal = new PtOpContractTaskDomain(domin.getOpcontractCode(), ContractChannelTypeEnum.RETAIL.getCode(), ContractTaskTypeEnum.CUSTOM_TOTAL.getCode(), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime1).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime2).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime3).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime4).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime5).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime6).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime7).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime8).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime9).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime10).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime11).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTime12).reduce(BigDecimal.ZERO, BigDecimal::add), list.stream().filter(item -> customTypes.contains(item.getOpcontractTkKind())).map(PtOpContractTaskDomain::getOpcontractTkTimesum).reduce(BigDecimal.ZERO, BigDecimal::add), null, null, null, domin.getChannelCode(), domin.getChannelName(), null, null, null, domin.getUserCode(), domin.getUserName(), null, null, domin.getTenantCode(), null, null, null, null, null, null, null, null);
            list.add(customTotal);
        } else if (domin instanceof PtOpContractTaskHomeImportDomin) {
            PtOpContractTaskHomeImportDomin home = (PtOpContractTaskHomeImportDomin)domin;
            List<BigDecimal> taskCounts = Arrays.asList(home.getTask1(), home.getTask2(), home.getTask3(), home.getTask4(), home.getTask5(), home.getTask6(), home.getTask7(), home.getTask8(), home.getTask9(), home.getTask10(), home.getTask11(), home.getTask12());
            PtOpContractTaskDomain task = this.createTaskDomain(domin, ContractChannelTypeEnum.HOME_DECORATION, ContractTaskTypeEnum.STANDARD_PRODUCT_TASK, taskCounts);
            list.add(task);
        } else if (domin instanceof PtOpContractTaskEngineeringImportDomin) {
            PtOpContractTaskEngineeringImportDomin engineering = (PtOpContractTaskEngineeringImportDomin)domin;
            List<BigDecimal> salesProgressCounts = Arrays.asList(engineering.getSalesProgressQ1(), engineering.getSalesProgressQ2(), engineering.getSalesProgressQ3(), engineering.getSalesProgressQ4());
            PtOpContractTaskDomain salesProgress = this.createTaskDomain(domin, ContractChannelTypeEnum.ENGINEERING, ContractTaskTypeEnum.SALES_PROGRESS_QUARTERLY, salesProgressCounts);
            list.add(salesProgress);
            List<BigDecimal> salesAmountCounts = Arrays.asList(engineering.getSalesAmountQ1(), engineering.getSalesAmountQ2(), engineering.getSalesAmountQ3(), engineering.getSalesAmountQ4());
            PtOpContractTaskDomain salesAmount = this.createTaskDomain(domin, ContractChannelTypeEnum.ENGINEERING, ContractTaskTypeEnum.SALES_AMOUNT_QUARTERLY, salesAmountCounts);
            list.add(salesAmount);
        } else if (domin instanceof PtOpContractTaskTripartiteImportDomin) {
            PtOpContractTaskTripartiteImportDomin tripartite = (PtOpContractTaskTripartiteImportDomin)domin;
            List<BigDecimal> taskCounts = Arrays.asList(tripartite.getTask1(), tripartite.getTask2(), tripartite.getTask3(), tripartite.getTask4(), tripartite.getTask5(), tripartite.getTask6(), tripartite.getTask7(), tripartite.getTask8(), tripartite.getTask9(), tripartite.getTask10(), tripartite.getTask11(), tripartite.getTask12());
            PtOpContractTaskDomain task = this.createTaskDomain(domin, ContractChannelTypeEnum.TRIPARTITE, ContractTaskTypeEnum.STANDARD_PRODUCT_TASK, taskCounts);
            list.add(task);
            PtOpContractTaskDomain thirdPartyShop = new PtOpContractTaskDomain(tripartite.getOpcontractCode(), ContractChannelTypeEnum.TRIPARTITE.getCode(), ContractTaskTypeEnum.THIRD_PARTY_SHOP.getCode(), null, null, null, null, null, null, null, null, null, null, null, null, null, tripartite.getOpcontractTkShopname(), tripartite.getOpcontractTkShopspace(), tripartite.getOpcontractTkShopaddress(), tripartite.getChannelCode(), tripartite.getChannelName(), null, null, null, tripartite.getUserCode(), tripartite.getUserName(), null, null, tripartite.getTenantCode(), tripartite.getOpcontractTkShopprovince(), tripartite.getOpcontractTkShopprovincecode(), tripartite.getOpcontractTkShopcity(), tripartite.getOpcontractTkShopcitycode(), tripartite.getOpcontractTkShoparea(), tripartite.getOpcontractTkShopareacode(), tripartite.getOpcontractTkShopvillage(), tripartite.getOpcontractTkShopvillagecode());
            list.add(thirdPartyShop);
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u5bfc\u5165\u5bf9\u8c61\u7c7b\u578b: " + domin.getClass().getSimpleName());
        }
        return list;
    }

    private ContractChannelTypeEnum convertToChannelTypeEnum(PtOpContractTaskImportBaseDomin domin) {
        if (domin instanceof PtOpContractTaskRetailImportDomin) {
            return ContractChannelTypeEnum.RETAIL;
        }
        if (domin instanceof PtOpContractTaskHomeImportDomin) {
            return ContractChannelTypeEnum.HOME_DECORATION;
        }
        if (domin instanceof PtOpContractTaskEngineeringImportDomin) {
            return ContractChannelTypeEnum.ENGINEERING;
        }
        return ContractChannelTypeEnum.TRIPARTITE;
    }

    private PtOpContractTaskDomain createTaskDomain(PtOpContractTaskImportBaseDomin domin, ContractChannelTypeEnum channelType, ContractTaskTypeEnum taskType, List<BigDecimal> counts) {
        return new PtOpContractTaskDomain(domin.getOpcontractCode(), channelType.getCode(), taskType.getCode(), counts.get(0), counts.get(1), counts.get(2), counts.get(3), counts.get(4), counts.get(5), counts.get(6), counts.get(7), counts.get(8), counts.get(9), counts.get(10), counts.get(11), counts.stream().reduce(BigDecimal.ZERO, BigDecimal::add), null, null, null, domin.getChannelCode(), domin.getChannelName(), null, null, null, domin.getUserCode(), domin.getUserName(), null, null, domin.getTenantCode(), null, null, null, null, null, null, null, null);
    }

    private void importCheckRetail(JSONObject result, List<PtOpContractTaskRetailImportDomin> list) {
        this.checkImportDataCommon(result, list, domin -> {
            if (Objects.isNull(domin.getStandardProductTask1())) {
                domin.setMemo("\u6807\u54c1\u4efb\u52a1\uff081\u6708\uff09 \u4e3a\u7a7a");
                return false;
            }
            return true;
        });
    }

    private void importCheckHome(JSONObject result, List<PtOpContractTaskHomeImportDomin> list) {
        this.checkImportDataCommon(result, list, domin -> {
            if (Objects.isNull(domin.getTask1())) {
                domin.setMemo("\u4efb\u52a1\uff081\u6708\uff09 \u4e3a\u7a7a");
                return false;
            }
            return true;
        });
    }

    private void importCheckEngineering(JSONObject result, List<PtOpContractTaskEngineeringImportDomin> list) {
        this.checkImportDataCommon(result, list, domin -> {
            if (Objects.isNull(domin.getSalesProgressQ1())) {
                domin.setMemo("\u9500\u552e\u8fdb\u5ea6\uff08\u4e00\u5b63\u5ea6\uff09 \u4e3a\u7a7a");
                return false;
            }
            return true;
        });
    }

    private void importCheckTripartite(JSONObject result, List<PtOpContractTaskTripartiteImportDomin> list) {
        this.checkImportDataCommon(result, list, domin -> {
            if (Objects.isNull(domin.getThirdUserinfoName())) {
                domin.setMemo("\u4e09\u65b9\u5ba2\u6237\u540d\u79f0 \u4e3a\u7a7a");
                return false;
            }
            return true;
        });
    }
}

