/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtForecastDemandSummaryMapper;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandMaterialDomain;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandMaterialReDomain;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandSummaryReDomain;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandUserReDomain;
import com.yqbsoft.laser.service.potential.enums.ClosingRequestStatusEnum;
import com.yqbsoft.laser.service.potential.enums.ForecastSummaryStatusEnum;
import com.yqbsoft.laser.service.potential.model.PtForecastDemandMaterial;
import com.yqbsoft.laser.service.potential.model.PtForecastDemandSummary;
import com.yqbsoft.laser.service.potential.model.PtForecastDemandUser;
import com.yqbsoft.laser.service.potential.service.PtForecastDemandMaterialService;
import com.yqbsoft.laser.service.potential.service.PtForecastDemandSummaryService;
import com.yqbsoft.laser.service.potential.service.PtForecastDemandUserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;

public class PtForecastDemandSummaryServiceImpl
extends BaseServiceImpl
implements PtForecastDemandSummaryService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtForecastDemandSummaryServiceImpl";
    @Value(value="${spring.restTemp.isTest:false}")
    private boolean isTest;
    private PtForecastDemandSummaryMapper ptForecastDemandSummaryMapper;
    private PtForecastDemandMaterialService ptForecastDemandMaterialService;
    private PtForecastDemandUserService ptForecastDemandUserService;

    public void setPtForecastDemandSummaryMapper(PtForecastDemandSummaryMapper ptForecastDemandSummaryMapper) {
        this.ptForecastDemandSummaryMapper = ptForecastDemandSummaryMapper;
    }

    public void setPtForecastDemandMaterialService(PtForecastDemandMaterialService ptForecastDemandMaterialService) {
        this.ptForecastDemandMaterialService = ptForecastDemandMaterialService;
    }

    public void setPtForecastDemandUserService(PtForecastDemandUserService ptForecastDemandUserService) {
        this.ptForecastDemandUserService = ptForecastDemandUserService;
    }

    private Date getSysDate() {
        try {
            return this.ptForecastDemandSummaryMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtForecastDemandSummary(PtForecastDemandSummaryReDomain domain) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getFsDataType())) {
            msg = msg + "\u5355\u636e\u6570\u636e\u7c7b\u578b \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    private PtForecastDemandSummary setPtForecastDemandSummaryDefault(PtForecastDemandSummary model) {
        if (null == model) {
            return model;
        }
        if (1 == model.getFsDataType()) {
            model.setFsStatus(ForecastSummaryStatusEnum.DOCUMENT_CREATED.getCode());
        } else if (2 == model.getFsDataType()) {
            String forecastSummaryCode = model.getForecastSummaryCode();
            Integer fsDataType = model.getFsDataType();
            String tenantCode = model.getTenantCode();
            String channelCode = model.getChannelCode();
            String channelName = model.getChannelName();
            String userCode = model.getUserCode();
            String userName = model.getUserName();
            model = new PtForecastDemandSummary();
            model.setForecastSummaryPcode(forecastSummaryCode);
            model.setFsDataType(fsDataType);
            model.setFsStatus(ClosingRequestStatusEnum.PENDING_REVIEW.getCode());
            model.setTenantCode(tenantCode);
            model.setChannelCode(channelCode);
            model.setChannelName(channelName);
            model.setUserCode(userCode);
            model.setUserName(userName);
        }
        Date date = this.getSysDate();
        model.setFsCreator(model.getUserName());
        model.setFsCreateTime(date);
        model.setFsPlatformPushStatus(1);
        model.setFsErpPushStatus(1);
        if (null == model.getDataState()) {
            model.setDataState(0);
        }
        if (null == model.getGmtCreate()) {
            model.setGmtCreate(date);
        }
        model.setGmtModified(date);
        if (StringUtils.isBlank((String)model.getForecastSummaryCode())) {
            model.setForecastSummaryCode(this.getDefaultCode(model.getTenantCode()));
        }
        return model;
    }

    private String getDefaultCode(String tenantCode) {
        if (this.isTest) {
            return this.createUUIDString();
        }
        return this.getNo(null, "PtForecastDemandSummary", "ptForecastDemandSummary", tenantCode);
    }

    private int getPtForecastDemandSummaryMaxCode() {
        int code = 0;
        try {
            return this.ptForecastDemandSummaryMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.getPtForecastDemandSummaryMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtForecastDemandSummaryUpdataDefault(PtForecastDemandSummary ptForecastDemandSummary) {
        if (null == ptForecastDemandSummary) {
            return;
        }
        ptForecastDemandSummary.setGmtModified(this.getSysDate());
    }

    private void savePtForecastDemandSummaryModel(PtForecastDemandSummary ptForecastDemandSummary) throws ApiException {
        if (null == ptForecastDemandSummary) {
            return;
        }
        try {
            this.ptForecastDemandSummaryMapper.insert(ptForecastDemandSummary);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.savePtForecastDemandSummaryModel.ex", (Throwable)e);
        }
    }

    private void savePtForecastDemandSummaryBatchModel(List<PtForecastDemandSummary> ptForecastDemandSummaryList) throws ApiException {
        if (null == ptForecastDemandSummaryList || ptForecastDemandSummaryList.isEmpty()) {
            return;
        }
        try {
            this.ptForecastDemandSummaryMapper.insertBatch(ptForecastDemandSummaryList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.savePtForecastDemandSummaryBatchModel.ex", (Throwable)e);
        }
    }

    private PtForecastDemandSummary getPtForecastDemandSummaryModelById(Integer forecastSummaryId) {
        if (null == forecastSummaryId) {
            return null;
        }
        try {
            return this.ptForecastDemandSummaryMapper.selectByPrimaryKey(forecastSummaryId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.getPtForecastDemandSummaryModelById", (Throwable)e);
            return null;
        }
    }

    private PtForecastDemandSummary getPtForecastDemandSummaryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptForecastDemandSummaryMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.getPtForecastDemandSummaryModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtForecastDemandSummaryModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptForecastDemandSummaryMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.delPtForecastDemandSummaryModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.delPtForecastDemandSummaryModelByCode.num");
        }
    }

    private void deletePtForecastDemandSummaryModel(Integer forecastSummaryId) throws ApiException {
        if (null == forecastSummaryId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptForecastDemandSummaryMapper.deleteByPrimaryKey(forecastSummaryId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.deletePtForecastDemandSummaryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.deletePtForecastDemandSummaryModel.num");
        }
    }

    private void updatePtForecastDemandSummaryModel(PtForecastDemandSummary ptForecastDemandSummary) throws ApiException {
        if (null == ptForecastDemandSummary) {
            return;
        }
        int i = 0;
        try {
            i = this.ptForecastDemandSummaryMapper.updateByPrimaryKeySelective(ptForecastDemandSummary);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updatePtForecastDemandSummaryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updatePtForecastDemandSummaryModel.num");
        }
    }

    private void updateStatePtForecastDemandSummaryModel(Integer forecastSummaryId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == forecastSummaryId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("forecastSummaryId", forecastSummaryId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptForecastDemandSummaryMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updateStatePtForecastDemandSummaryModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updateStatePtForecastDemandSummaryModel.null");
        }
    }

    private void updateStatePtForecastDemandSummaryModelByCode(String tenantCode, String forecastSummaryCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)forecastSummaryCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("forecastSummaryCode", forecastSummaryCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptForecastDemandSummaryMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updateStatePtForecastDemandSummaryModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updateStatePtForecastDemandSummaryModelByCode.null");
        }
    }

    private PtForecastDemandSummary makePtForecastDemandSummary(PtForecastDemandSummaryReDomain ptForecastDemandSummaryDomain, PtForecastDemandSummary ptForecastDemandSummary) {
        if (null == ptForecastDemandSummaryDomain) {
            return null;
        }
        if (null == ptForecastDemandSummary) {
            ptForecastDemandSummary = new PtForecastDemandSummary();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ptForecastDemandSummary, (Object)ptForecastDemandSummaryDomain);
            return ptForecastDemandSummary;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.makePtForecastDemandSummary", (Throwable)e);
            return null;
        }
    }

    private PtForecastDemandSummaryReDomain makePtForecastDemandSummaryReDomain(PtForecastDemandSummary ptForecastDemandSummary) {
        if (null == ptForecastDemandSummary) {
            return null;
        }
        PtForecastDemandSummaryReDomain ptForecastDemandSummaryReDomain = new PtForecastDemandSummaryReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptForecastDemandSummaryReDomain, (Object)ptForecastDemandSummary);
            return ptForecastDemandSummaryReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.makePtForecastDemandSummaryReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtForecastDemandSummary> queryPtForecastDemandSummaryModelPage(Map<String, Object> parammap) {
        try {
            return this.ptForecastDemandSummaryMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.queryPtForecastDemandSummaryModel", (Throwable)e);
            return null;
        }
    }

    private int countPtForecastDemandSummary(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptForecastDemandSummaryMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.countPtForecastDemandSummary", (Throwable)e);
        }
        return i;
    }

    private PtForecastDemandSummary createPtForecastDemandSummary(PtForecastDemandSummaryReDomain ptForecastDemandSummaryDomain) {
        String msg = this.checkPtForecastDemandSummary(ptForecastDemandSummaryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.savePtForecastDemandSummary.checkPtForecastDemandSummary", msg);
        }
        PtForecastDemandSummary ptForecastDemandSummary = this.makePtForecastDemandSummary(ptForecastDemandSummaryDomain, null);
        ptForecastDemandSummary = this.setPtForecastDemandSummaryDefault(ptForecastDemandSummary);
        BigDecimal num = ptForecastDemandSummaryDomain.getMaterialList().stream().map(PtForecastDemandMaterialDomain::getMaterialNum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        ptForecastDemandSummary.setFsTotalQty(num);
        if (null != ptForecastDemandSummaryDomain.getMaterialList() && !ptForecastDemandSummaryDomain.getMaterialList().isEmpty()) {
            for (PtForecastDemandMaterialReDomain materialReDomain : ptForecastDemandSummaryDomain.getMaterialList()) {
                materialReDomain.setForecastMaterialId(null);
                materialReDomain.setForecastMaterialCode(null);
                materialReDomain.setForecastSummaryCode(ptForecastDemandSummary.getForecastSummaryCode());
                materialReDomain.setTenantCode(ptForecastDemandSummary.getTenantCode());
                materialReDomain.setChannelCode(ptForecastDemandSummary.getChannelCode());
                materialReDomain.setChannelName(ptForecastDemandSummary.getChannelName());
                materialReDomain.setUserCode(ptForecastDemandSummary.getUserCode());
                materialReDomain.setUserName(ptForecastDemandSummary.getUserName());
            }
        }
        if (null != ptForecastDemandSummaryDomain.getUserList() && !ptForecastDemandSummaryDomain.getUserList().isEmpty()) {
            for (PtForecastDemandUserReDomain userReDomain : ptForecastDemandSummaryDomain.getUserList()) {
                userReDomain.setForecastUserId(null);
                userReDomain.setForecastUserCode(null);
                userReDomain.setForecastSummaryCode(ptForecastDemandSummary.getForecastSummaryCode());
                userReDomain.setTenantCode(ptForecastDemandSummary.getTenantCode());
                userReDomain.setChannelCode(ptForecastDemandSummary.getChannelCode());
                userReDomain.setChannelName(ptForecastDemandSummary.getChannelName());
                userReDomain.setUserCode(ptForecastDemandSummary.getUserCode());
                userReDomain.setUserName(ptForecastDemandSummary.getUserName());
            }
        }
        return ptForecastDemandSummary;
    }

    @Override
    public String savePtForecastDemandSummary(PtForecastDemandSummaryReDomain ptForecastDemandSummaryDomain) throws ApiException {
        PtForecastDemandSummary ptForecastDemandSummary = this.createPtForecastDemandSummary(ptForecastDemandSummaryDomain);
        this.savePtForecastDemandSummaryModel(ptForecastDemandSummary);
        if (ListUtil.isNotEmpty(ptForecastDemandSummaryDomain.getMaterialList())) {
            this.ptForecastDemandMaterialService.savePtForecastDemandMaterialBatch(ptForecastDemandSummaryDomain.getMaterialList());
        }
        if (ListUtil.isNotEmpty(ptForecastDemandSummaryDomain.getUserList())) {
            this.ptForecastDemandUserService.savePtForecastDemandUserBatch(ptForecastDemandSummaryDomain.getUserList());
        }
        return ptForecastDemandSummary.getForecastSummaryCode();
    }

    @Override
    public String saveClosingRequest(PtForecastDemandSummaryReDomain domain) throws ApiException {
        domain.setFsDataType(2);
        this.savePtForecastDemandSummary(domain);
        return domain.getForecastSummaryCode();
    }

    @Override
    public String savePtForecastDemandSummaryBatch(List<PtForecastDemandSummaryReDomain> ptForecastDemandSummaryDomainList) throws ApiException {
        if (null == ptForecastDemandSummaryDomainList || ptForecastDemandSummaryDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtForecastDemandSummary> ptForecastDemandSummaryList = new ArrayList<PtForecastDemandSummary>();
        String code = "";
        for (PtForecastDemandSummaryReDomain ptForecastDemandSummaryDomain : ptForecastDemandSummaryDomainList) {
            PtForecastDemandSummary ptForecastDemandSummary = this.createPtForecastDemandSummary(ptForecastDemandSummaryDomain);
            code = ptForecastDemandSummary.getForecastSummaryCode();
            ptForecastDemandSummaryList.add(ptForecastDemandSummary);
        }
        this.savePtForecastDemandSummaryBatchModel(ptForecastDemandSummaryList);
        return code;
    }

    @Override
    public void updatePtForecastDemandSummaryState(Integer forecastSummaryId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == forecastSummaryId) {
            return;
        }
        this.updateStatePtForecastDemandSummaryModel(forecastSummaryId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtForecastDemandSummaryStateByCode(String tenantCode, String forecastSummaryCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)forecastSummaryCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtForecastDemandSummaryModelByCode(tenantCode, forecastSummaryCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtForecastDemandSummary(PtForecastDemandSummaryReDomain ptForecastDemandSummaryDomain) throws ApiException {
        String msg = this.checkPtForecastDemandSummary(ptForecastDemandSummaryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updatePtForecastDemandSummary.checkPtForecastDemandSummary", msg);
        }
        PtForecastDemandSummary oldPtForecastDemandSummary = this.getPtForecastDemandSummaryModelById(ptForecastDemandSummaryDomain.getForecastSummaryId());
        if (null == oldPtForecastDemandSummary) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updatePtForecastDemandSummary.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtForecastDemandSummary ptForecastDemandSummary = this.makePtForecastDemandSummary(ptForecastDemandSummaryDomain, oldPtForecastDemandSummary);
        this.setPtForecastDemandSummaryUpdataDefault(ptForecastDemandSummary);
        this.updatePtForecastDemandSummaryModel(ptForecastDemandSummary);
        this.ptForecastDemandMaterialService.updatePtForecastDemandMaterialBatch(ptForecastDemandSummaryDomain);
        this.ptForecastDemandUserService.updatePtForecastDemandUserBatch(ptForecastDemandSummaryDomain);
    }

    @Override
    public void updatePtForecastDemandSummarySelective(PtForecastDemandSummaryReDomain domain) {
        if (Objects.isNull(domain)) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updatePtForecastDemandSummarySelective", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (Objects.isNull(domain.getForecastSummaryId())) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updatePtForecastDemandSummarySelective", "\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            PtForecastDemandSummary forecastDemandSummary = new PtForecastDemandSummary();
            BeanUtils.copyAllPropertysNotNull((Object)forecastDemandSummary, (Object)domain);
            this.ptForecastDemandSummaryMapper.updateByPrimaryKeySelective(forecastDemandSummary);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updatePtForecastDemandSummarySelective", (Throwable)e);
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updatePtForecastDemandSummarySelective", "\u66f4\u65b0\u5f02\u5e38");
        }
    }

    @Override
    public PtForecastDemandSummaryReDomain getPtForecastDemandSummary(Integer forecastSummaryId) {
        if (null == forecastSummaryId) {
            return null;
        }
        PtForecastDemandSummary summary = this.getPtForecastDemandSummaryModelById(forecastSummaryId);
        if (Objects.isNull(summary)) {
            return null;
        }
        PtForecastDemandSummaryReDomain summaryReDomain = this.makePtForecastDemandSummaryReDomain(summary);
        this.setSubdata(summaryReDomain);
        return summaryReDomain;
    }

    private void setSubdata(PtForecastDemandSummaryReDomain summaryReDomain) {
        QueryResult<PtForecastDemandUser> userResult;
        if (summaryReDomain == null || StringUtils.isBlank((String)summaryReDomain.getForecastSummaryCode()) || StringUtils.isBlank((String)summaryReDomain.getTenantCode())) {
            return;
        }
        String forecastSummaryCode = summaryReDomain.getForecastSummaryCode();
        String tenantCode = summaryReDomain.getTenantCode();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("forecastSummaryCode", forecastSummaryCode);
        params.put("tenantCode", tenantCode);
        QueryResult<PtForecastDemandMaterial> materialResult = this.ptForecastDemandMaterialService.queryPtForecastDemandMaterialPage(params);
        if (materialResult != null && ListUtil.isNotEmpty((Collection)materialResult.getList())) {
            ArrayList<PtForecastDemandMaterialReDomain> materialDomains = new ArrayList<PtForecastDemandMaterialReDomain>();
            for (PtForecastDemandMaterial material : materialResult.getList()) {
                PtForecastDemandMaterialReDomain domain = new PtForecastDemandMaterialReDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)domain, (Object)material);
                    materialDomains.add(domain);
                }
                catch (Exception e) {
                    this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.setSubdata.material", (Throwable)e);
                }
            }
            summaryReDomain.setMaterialList(materialDomains);
        }
        if ((userResult = this.ptForecastDemandUserService.queryPtForecastDemandUserPage(params)) != null && ListUtil.isNotEmpty((Collection)userResult.getList())) {
            ArrayList<PtForecastDemandUserReDomain> userDomains = new ArrayList<PtForecastDemandUserReDomain>();
            for (PtForecastDemandUser user : userResult.getList()) {
                PtForecastDemandUserReDomain domain = new PtForecastDemandUserReDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)domain, (Object)user);
                    userDomains.add(domain);
                }
                catch (Exception e) {
                    this.logger.error("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.setSubdata.user", (Throwable)e);
                }
            }
            summaryReDomain.setUserList(userDomains);
        }
    }

    @Override
    public void deletePtForecastDemandSummary(Integer forecastSummaryId) throws ApiException {
        if (null == forecastSummaryId) {
            return;
        }
        this.deletePtForecastDemandSummaryModel(forecastSummaryId);
    }

    @Override
    public QueryResult<PtForecastDemandSummary> queryPtForecastDemandSummaryPage(Map<String, Object> map) {
        List<PtForecastDemandSummary> ptForecastDemandSummaryList = this.queryPtForecastDemandSummaryModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtForecastDemandSummary(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptForecastDemandSummaryList);
        return queryResult;
    }

    @Override
    public PtForecastDemandSummaryReDomain getPtForecastDemandSummaryByCode(String tenantCode, String forecastSummaryCode) throws ApiException {
        if (StringUtils.isBlank((String)forecastSummaryCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("forecastSummaryCode", forecastSummaryCode);
        PtForecastDemandSummary summary = this.getPtForecastDemandSummaryModelByCode(map);
        PtForecastDemandSummaryReDomain summaryReDomain = this.makePtForecastDemandSummaryReDomain(summary);
        this.setSubdata(summaryReDomain);
        return summaryReDomain;
    }

    @Override
    public void deletePtForecastDemandSummaryByCode(String tenantCode, String forecastSummaryCode) throws ApiException {
        if (StringUtils.isBlank((String)forecastSummaryCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("forecastSummaryCode", forecastSummaryCode);
        this.delPtForecastDemandSummaryModelByCode(map);
    }

    @Override
    public void updatePtForecastDemandSummaryReDomain(PtForecastDemandSummaryReDomain ptForecastDemandSummaryDomain) throws ApiException {
        PtForecastDemandSummary oldPtForecastDemandSummary = this.getPtForecastDemandSummaryModelById(ptForecastDemandSummaryDomain.getForecastSummaryId());
        if (null == oldPtForecastDemandSummary) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandSummaryServiceImpl.updatePtForecastDemandSummary.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtForecastDemandSummary ptForecastDemandSummary = this.makePtForecastDemandSummary(ptForecastDemandSummaryDomain, oldPtForecastDemandSummary);
        this.setPtForecastDemandSummaryUpdataDefault(ptForecastDemandSummary);
        this.updatePtForecastDemandSummaryModel(ptForecastDemandSummary);
        List<PtForecastDemandMaterialReDomain> materialList = ptForecastDemandSummaryDomain.getMaterialList();
        if (ListUtil.isNotEmpty(materialList)) {
            this.ptForecastDemandMaterialService.updatePtForecastDemandMaterialByCodeBatch(materialList);
        }
    }
}

