/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.yqbsoft.laser.service.potential.dao.MarginTransferRecordMapper;
import com.yqbsoft.laser.service.potential.domain.margin.MarginTransferRecord;
import com.yqbsoft.laser.service.potential.service.MarginTransferRecordService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="marginTransferRecordService")
public class MarginTransferRecordServiceImpl
implements MarginTransferRecordService {
    private static final Logger log = LoggerFactory.getLogger(MarginTransferRecordServiceImpl.class);
    private final MarginTransferRecordMapper mapper;
    private static final SimpleDateFormat DATE_ONLY = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public SupQueryResult<MarginTransferRecord> pageQuery(Map<String, Object> params) {
        int pageNum = (Integer)(params.get("page") == null ? Integer.valueOf(1) : params.get("page"));
        int pageSize = (Integer)(params.get("rows") == null ? Integer.valueOf(10) : params.get("rows"));
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 20;
        }
        int offset = (pageNum - 1) * pageSize;
        HashMap<String, Object> q = new HashMap<String, Object>();
        q.putAll(params);
        try {
            Object e;
            Object s = q.get("applyStartDate");
            if (s instanceof String && !((String)s).trim().isEmpty()) {
                Date start = DATE_ONLY.parse((String)s);
                Calendar c = Calendar.getInstance();
                c.setTime(start);
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                q.put("startTime", DATETIME.format(c.getTime()));
            }
            if ((e = q.get("applyEndDate")) instanceof String && !((String)e).trim().isEmpty()) {
                Date end = DATE_ONLY.parse((String)e);
                Calendar c2 = Calendar.getInstance();
                c2.setTime(end);
                c2.set(11, 23);
                c2.set(12, 59);
                c2.set(13, 59);
                q.put("endTime", DATETIME.format(c2.getTime()));
            }
        }
        catch (ParseException s) {
            // empty catch block
        }
        q.put("offset", offset);
        q.put("pageSize", pageSize);
        long total = this.mapper.countByParams(q);
        List<MarginTransferRecord> list = this.mapper.selectByPage(q);
        SupQueryResult result = new SupQueryResult();
        result.setTotal(total);
        result.setRows(list);
        return result;
    }

    @Override
    public MarginTransferRecord getById(Long id) {
        return this.mapper.selectById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MarginTransferRecord create(MarginTransferRecord record) {
        if (record.getCreatedAt() == null) {
            record.setCreatedAt(new Date());
        }
        if (record.getStatus() == null || record.getStatus().trim().isEmpty()) {
            record.setStatus("APPLY");
        }
        this.mapper.insert(record);
        return record;
    }

    public MarginTransferRecordServiceImpl(MarginTransferRecordMapper mapper) {
        this.mapper = mapper;
    }
}

