/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.nacos.client.utils.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.potential.dao.MarginPolicySettingMapper;
import com.yqbsoft.laser.service.potential.dao.OrderMarginRelationMapper;
import com.yqbsoft.laser.service.potential.domain.margin.MarginPolicySetting;
import com.yqbsoft.laser.service.potential.domain.margin.OrderMarginRelation;
import com.yqbsoft.laser.service.potential.service.OrderMarginRelationService;
import com.yqbsoft.laser.service.potential.utils.LocalDateHelper;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderMarginRelationService")
public class OrderMarginRelationServiceImpl
implements OrderMarginRelationService {
    private static final Logger log = LoggerFactory.getLogger(OrderMarginRelationServiceImpl.class);
    private final OrderMarginRelationMapper orderMarginRelationMapper;
    private final MarginPolicySettingMapper marginPolicySettingMapper;

    @Override
    public SupQueryResult<OrderMarginRelation> pageQuery(Map<String, Object> params) {
        int pageNum = (Integer)(params.get("page") == null ? Integer.valueOf(1) : params.get("page"));
        int pageSize = (Integer)(params.get("rows") == null ? Integer.valueOf(10) : params.get("rows"));
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 20;
        }
        int offset = (pageNum - 1) * pageSize;
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        long total = this.orderMarginRelationMapper.countByParams(params);
        List<OrderMarginRelation> list = this.orderMarginRelationMapper.selectByPage(params);
        SupQueryResult result = new SupQueryResult();
        result.setTotal(total);
        result.setRows(list);
        return result;
    }

    @Override
    public OrderMarginRelation getById(Long id) {
        return this.orderMarginRelationMapper.selectById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrderMarginRelation create(OrderMarginRelation record) {
        MarginPolicySetting setting = this.resolveSetting(record);
        record.setSettingId(setting.getId());
        record.setMarginAmount(this.calcMarginAmount(record.getOrderAmount(), setting));
        this.fillDefaultFields(record);
        this.orderMarginRelationMapper.insert(record);
        return record;
    }

    @Override
    public void updateByList(List<OrderMarginRelation> recordList) {
        for (OrderMarginRelation record : recordList) {
            this.orderMarginRelationMapper.updateSelective(record);
        }
    }

    private MarginPolicySetting resolveSetting(OrderMarginRelation record) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("channel", record.getChannelCode());
        List<MarginPolicySetting> settingList = this.marginPolicySettingMapper.queryList(params);
        if (settingList == null || settingList.isEmpty()) {
            throw new ApiException("\u6e20\u9053\u53f7\u3010" + record.getChannelCode() + "\u3011\u672a\u8bbe\u7f6e\u653f\u7b56\u4fdd\u8bc1\u91d1\uff01");
        }
        String orderTypeCode = record.getOrderTypeCode();
        LocalDate today = LocalDate.now();
        return settingList.stream().filter(s -> Arrays.asList(s.getOrderTypeCode().split(",")).contains(orderTypeCode)).filter(s -> this.isSettingEffectiveToday((MarginPolicySetting)s, today)).findFirst().orElseThrow(() -> new ApiException("\u6e20\u9053\u53f7\u3010" + record.getChannelCode() + "\u3011\u672a\u4e3a\u8ba2\u5355\u7c7b\u578b\u3010 " + record.getOrderTypeCode() + " \u3011\u8bbe\u7f6e\u653f\u7b56\u4fdd\u8bc1\u91d1\uff08\u65f6\u95f4\u672a\u547d\u4e2d\uff09\uff01"));
    }

    private boolean isSettingEffectiveToday(MarginPolicySetting s, LocalDate today) {
        if (StringUtils.isNotBlank((String)s.getCollectTimes())) {
            try {
                List dates = (List)new ObjectMapper().readValue(s.getCollectTimes(), (TypeReference)new TypeReference<List<String>>(){});
                for (String d : dates) {
                    LocalDate dt = LocalDateHelper.safeParseToLocalDate(d);
                    if (!today.equals(dt)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                log.error("collectTimes parse error: {}", (Object)s.getCollectTimes(), (Object)e);
                return false;
            }
        }
        LocalDate start = LocalDateHelper.safeParseToLocalDate(s.getQuarterStart());
        LocalDate end = LocalDateHelper.safeParseToLocalDate(s.getQuarterEnd());
        if (start != null && end != null) {
            return !today.isBefore(start) && !today.isAfter(end);
        }
        return false;
    }

    private BigDecimal calcMarginAmount(BigDecimal orderAmount, MarginPolicySetting setting) {
        BigDecimal marginAmount = orderAmount.multiply(setting.getRatio());
        return marginAmount.min(setting.getCapAmount());
    }

    private void fillDefaultFields(OrderMarginRelation r) {
        if (r.getRemark() == null) {
            r.setRemark("\u81ea\u52a8\u5173\u8054\u521b\u5efa");
        }
        if (r.getStatus() == null) {
            r.setStatus(0);
        }
        Date now = new Date();
        if (r.getCreatedAt() == null) {
            r.setCreatedAt(now);
        }
        r.setCreatedBy("system");
        r.setUpdatedBy("system");
        r.setUpdatedAt(now);
    }

    public OrderMarginRelationServiceImpl(OrderMarginRelationMapper orderMarginRelationMapper, MarginPolicySettingMapper marginPolicySettingMapper) {
        this.orderMarginRelationMapper = orderMarginRelationMapper;
        this.marginPolicySettingMapper = marginPolicySettingMapper;
    }
}

