/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.potential.dao.MarginBillMapper;
import com.yqbsoft.laser.service.potential.dao.MarginPaymentMapper;
import com.yqbsoft.laser.service.potential.dao.MarginPolicySettingMapper;
import com.yqbsoft.laser.service.potential.dao.MarginTransferPaymentRelMapper;
import com.yqbsoft.laser.service.potential.dao.MarginTransferRecordMapper;
import com.yqbsoft.laser.service.potential.dao.OrderMarginRelationMapper;
import com.yqbsoft.laser.service.potential.domain.margin.MarginBill;
import com.yqbsoft.laser.service.potential.domain.margin.MarginPaymentRecord;
import com.yqbsoft.laser.service.potential.domain.margin.MarginPolicySetting;
import com.yqbsoft.laser.service.potential.domain.margin.MarginTransferPaymentRel;
import com.yqbsoft.laser.service.potential.domain.margin.MarginTransferRecord;
import com.yqbsoft.laser.service.potential.domain.margin.OrderMarginRelation;
import com.yqbsoft.laser.service.potential.enums.MarginBillPayStatusEnum;
import com.yqbsoft.laser.service.potential.enums.MarginTypeEnum;
import com.yqbsoft.laser.service.potential.query.margin.MarginBillPaymentDetail;
import com.yqbsoft.laser.service.potential.request.margin.MarginTransferRequest;
import com.yqbsoft.laser.service.potential.service.MarginBillService;
import com.yqbsoft.laser.service.potential.utils.MarginNoGenerator;
import com.yqbsoft.laser.service.potential.utils.TransferNoGenerator;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="marginBillService")
public class MarginBillServiceImpl
implements MarginBillService {
    private static final Logger log = LoggerFactory.getLogger(MarginBillServiceImpl.class);
    private final MarginBillMapper marginBillMapper;
    private final MarginPaymentMapper marginPaymentMapper;
    private final MarginTransferPaymentRelMapper marginTransferPaymentRelMapper;
    private final MarginTransferRecordMapper marginTransferRecordMapper;
    private final OrderMarginRelationMapper orderMarginRelationMapper;
    private final MarginPolicySettingMapper marginPolicySettingMapper;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final SimpleDateFormat DATE_ONLY = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public SupQueryResult<MarginBill> pageQuery(Map<String, Object> params) {
        int pageNum = (Integer)(params.get("page") == null ? Integer.valueOf(1) : params.get("page"));
        int pageSize = (Integer)(params.get("rows") == null ? Integer.valueOf(10) : params.get("rows"));
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 20;
        }
        int offset = (pageNum - 1) * pageSize;
        HashMap<String, Object> q = new HashMap<String, Object>();
        q.putAll(params);
        try {
            Object e;
            Object s = q.get("billStartDate");
            if (s != null && s instanceof String && !((String)s).trim().isEmpty()) {
                Date start = DATE_ONLY.parse((String)s);
                String startTimeStr = DATETIME.format(start) + " 00:00:00";
                Calendar c = Calendar.getInstance();
                c.setTime(start);
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                q.put("startTime", DATETIME.format(c.getTime()));
            }
            if ((e = q.get("billEndDate")) != null && e instanceof String && !((String)e).trim().isEmpty()) {
                Date end = DATE_ONLY.parse((String)e);
                Calendar c2 = Calendar.getInstance();
                c2.setTime(end);
                c2.set(11, 23);
                c2.set(12, 59);
                c2.set(13, 59);
                q.put("endTime", DATETIME.format(c2.getTime()));
            }
        }
        catch (ParseException s) {
            // empty catch block
        }
        q.put("offset", offset);
        q.put("pageSize", pageSize);
        long total = this.marginBillMapper.countByParams(q);
        List<MarginBill> list = this.marginBillMapper.selectByPage(q);
        SupQueryResult result = new SupQueryResult();
        result.setTotal(total);
        result.setRows(list);
        return result;
    }

    @Override
    public MarginBill getById(Long id) {
        return this.marginBillMapper.selectById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MarginBill create(MarginBill bill) {
        if (bill.getCreatedAt() == null) {
            bill.setCreatedAt(new Date());
        }
        if (bill.getStatus() == null) {
            bill.setStatus("\u5f85\u4ed8\u6b3e");
        }
        this.marginBillMapper.insert(bill);
        return bill;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MarginTransferRecord convertedInfoPayment(MarginTransferRequest transferRequest) throws Exception {
        if (transferRequest.getPaymentIds() == null || transferRequest.getPaymentIds().isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u652f\u4ed8\u6d41\u6c34\u8fdb\u884c\u8f6c\u8d27\u6b3e");
        }
        log.info("\u8f6c\u8d27\u6b3e\u5f00\u59cb: marginId={}, paymentIds={}, operator={}", new Object[]{transferRequest.getMarginId(), transferRequest.getPaymentIds(), transferRequest.getOperator()});
        MarginBill bill = this.getById(transferRequest.getMarginId());
        if (bill == null) {
            throw new ApiException("\u4fdd\u8bc1\u91d1\u5355\u4e0d\u5b58\u5728");
        }
        List<MarginPaymentRecord> paymentRecords = this.marginPaymentMapper.listByPayIds(transferRequest.getPaymentIds());
        if (paymentRecords.size() != transferRequest.getPaymentIds().size()) {
            Set fetchedPayIds = paymentRecords.stream().map(MarginPaymentRecord::getPayNo).collect(Collectors.toSet());
            Set missing = transferRequest.getPaymentIds().stream().map(String::valueOf).filter(id -> !fetchedPayIds.contains(id)).collect(Collectors.toSet());
            throw new ApiException("\u90e8\u5206\u652f\u4ed8\u6d41\u6c34\u4e0d\u5b58\u5728: " + missing);
        }
        List failedPayNos = paymentRecords.stream().filter(r -> !"SUCCESS".equals(r.getPayStatus())).map(MarginPaymentRecord::getPayNo).collect(Collectors.toList());
        if (!failedPayNos.isEmpty()) {
            throw new ApiException("\u4ee5\u4e0b\u652f\u4ed8\u6d41\u6c34\u672a\u652f\u4ed8\u6210\u529f\uff0c\u4e0d\u80fd\u8f6c\u8d27\u6b3e: " + failedPayNos);
        }
        List<MarginTransferPaymentRel> existingRels = this.marginTransferPaymentRelMapper.listByPayNos(paymentRecords.stream().map(MarginPaymentRecord::getPayNo).collect(Collectors.toList()));
        if (!existingRels.isEmpty()) {
            List usedPayNos = existingRels.stream().map(MarginTransferPaymentRel::getPayNo).collect(Collectors.toList());
            throw new ApiException("\u4ee5\u4e0b\u652f\u4ed8\u6d41\u6c34\u5df2\u88ab\u8f6c\u8d27\u6b3e: " + usedPayNos);
        }
        BigDecimal amountPaid = paymentRecords.stream().map(MarginPaymentRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(3, RoundingMode.HALF_UP);
        MarginTransferRecord transferRecord = new MarginTransferRecord();
        transferRecord.setTransferNo(TransferNoGenerator.generateTransferNo());
        transferRecord.setMarginNo(bill.getMarginNo());
        transferRecord.setApplyTime(new Date());
        transferRecord.setMarginType(bill.getMarginType());
        transferRecord.setProjectId(bill.getProjectId());
        transferRecord.setProjectName(bill.getProjectName());
        transferRecord.setCustomerCode(bill.getCustomerCode());
        transferRecord.setCustomerName(bill.getCustomerName());
        transferRecord.setCreatedAt(new Date());
        transferRecord.setCreatedBy(transferRequest.getOperator());
        transferRecord.setStatus("APPLY");
        transferRecord.setAmountPaid(amountPaid);
        this.marginTransferRecordMapper.insert(transferRecord);
        log.info("\u751f\u6210\u8f6c\u8d27\u6b3e\u8bb0\u5f55: transferNo={}, amountPaid={}", (Object)transferRecord.getTransferNo(), (Object)amountPaid);
        List<MarginTransferPaymentRel> rels = paymentRecords.stream().map(record -> {
            MarginTransferPaymentRel rel = new MarginTransferPaymentRel();
            rel.setTransferId(transferRecord.getId());
            rel.setPayNo(record.getPayNo());
            rel.setAmount(record.getAmount().setScale(2, RoundingMode.HALF_UP));
            return rel;
        }).collect(Collectors.toList());
        this.marginTransferPaymentRelMapper.batchInsert(rels);
        log.info("\u521b\u5efa\u652f\u4ed8\u6d41\u6c34\u5173\u8054: count={}", (Object)rels.size());
        CompletableFuture.runAsync(() -> {
            try {
                log.info("ERP\u56de\u586b\u6210\u529f: transferNo={}", (Object)transferRecord.getTransferNo());
            }
            catch (Exception e) {
                log.error("ERP\u56de\u586b\u5931\u8d25: transferNo={}", (Object)transferRecord.getTransferNo(), (Object)e);
            }
        });
        return transferRecord;
    }

    @Override
    public MarginBill getByMarginNo(String marginNo) {
        return this.marginBillMapper.selectByMarginNo(marginNo);
    }

    @Override
    @Transactional
    public MarginBill marginPayment(MarginBillPaymentDetail d) {
        MarginBill bill = this.marginBillMapper.selectByMarginNo(d.getMarginNo());
        if (bill == null) {
            throw new ApiException("\u4fdd\u8bc1\u91d1\u5355\u4e0d\u5b58\u5728\uff01\u5355\u53f7\u3010" + d.getMarginNo() + "\u3011");
        }
        bill.setPayType(d.getPayType());
        bill.setReceiveType(d.getReceiveType());
        bill.setReceiveAccount(d.getReceiveAccount());
        bill.setReceiverName(d.getReceiverName());
        bill.setAccountDept(d.getAccountDept());
        bill.setOperatorName(d.getOperatorName());
        bill.setPayerName(d.getPayerName());
        bill.setPayTime(d.getPayTime());
        bill.setPayTradeNo(d.getPayTradeNo());
        bill.setSettleMethod(d.getSettleMethod());
        BigDecimal paid = Optional.ofNullable(bill.getAmountPaid()).orElse(BigDecimal.ZERO);
        bill.setAmountPaid(paid.add(d.getAmountPaid()));
        bill.setPayStatus(bill.getAmountPayable().compareTo(bill.getAmountPaid()) <= 0 ? MarginBillPayStatusEnum.FULL_PAY.getCode() : MarginBillPayStatusEnum.PART_PAY.getCode());
        bill.setStatus(MarginBillPayStatusEnum.descOf(bill.getPayStatus()));
        this.marginBillMapper.update(bill);
        this.paymentRecord(d);
        return bill;
    }

    private void paymentRecord(MarginBillPaymentDetail detail) {
        MarginPaymentRecord record = new MarginPaymentRecord();
        record.setMarginNo(detail.getMarginNo());
        record.setPayNo(detail.getPayTradeNo());
        record.setPayType(detail.getPayType());
        record.setPayChannel("CBS");
        record.setPayTradeNo(detail.getPayTradeNo());
        record.setAmount(detail.getAmountPaid());
        record.setPayStatus("SUCCESS");
        record.setPayerName(detail.getPayerName());
        record.setPayerAccount(detail.getReceiveAccount());
        record.setReceiverName(detail.getReceiverName());
        record.setReceiveAccount(detail.getReceiveAccount());
        record.setPayTime(detail.getPayTime());
        record.setOperatorName(detail.getOperatorName());
        record.setCreatedBy("SYSTEM");
        record.setUpdatedBy("SYSTEM");
        record.setCreatedAt(new Date());
        record.setUpdatedAt(new Date());
        this.marginPaymentMapper.insert(record);
    }

    @Override
    public MarginBill updateMarginBill(MarginBill bill) {
        this.marginBillMapper.update(bill);
        return bill;
    }

    @Override
    @Transactional
    public void generateBillsIfNeeded() {
        String today = LocalDate.now().toString();
        List<MarginPolicySetting> settings = this.marginPolicySettingMapper.selectAll();
        for (MarginPolicySetting setting : settings) {
            List<String> times = this.parseCollectTimes(setting.getCollectTimes());
            if (times.size() % 2 != 0) {
                log.error("collectTimes \u65f6\u95f4\u6570\u7ec4\u4e0d\u662f\u6210\u5bf9\u51fa\u73b0\uff0csettingId={}", (Object)setting.getId());
                continue;
            }
            for (int i = 0; i < times.size(); i += 2) {
                String startTime = times.get(i);
                String endTime = times.get(i + 1);
                if (!today.equals(endTime)) continue;
                this.processOnePeriod(setting, startTime, endTime);
            }
        }
    }

    private List<String> parseCollectTimes(String collectTimesJson) {
        if (collectTimesJson == null || collectTimesJson.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return (List)MAPPER.readValue(collectTimesJson, (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (Exception e) {
            log.error("collectTimes \u89e3\u6790\u5931\u8d25\uff0cjson={}", (Object)collectTimesJson, (Object)e);
            return Collections.emptyList();
        }
    }

    private void processOnePeriod(MarginPolicySetting setting, String start, String end) {
        log.info("[MarginBillJob] \u5904\u7406\u65f6\u95f4\u6bb5 {} - {} settingId={}", new Object[]{start, end, setting.getId()});
        List<OrderMarginRelation> relations = this.orderMarginRelationMapper.selectBySettingAndDateRange(setting.getId(), start, end);
        if (relations.isEmpty()) {
            log.info("[MarginBillJob] settingId={} \u5728 {} \u5230 {} \u65e0\u8bb0\u5f55\uff0c\u8df3\u8fc7", new Object[]{setting.getId(), start, end});
            return;
        }
        Map<String, List<OrderMarginRelation>> group = relations.stream().collect(Collectors.groupingBy(OrderMarginRelation::getCustomerCode));
        for (Map.Entry<String, List<OrderMarginRelation>> entry : group.entrySet()) {
            this.mergeOneCustomer(setting, entry.getKey(), entry.getValue());
        }
    }

    private void mergeOneCustomer(MarginPolicySetting setting, String customerCode, List<OrderMarginRelation> relations) {
        if (relations.stream().anyMatch(r -> r.getMarginNo() != null)) {
            log.warn("[MarginBillJob] settingId={} customerCode={} \u5df2\u751f\u6210\u8fc7\u4fdd\u8bc1\u91d1\u5355\uff0c\u8df3\u8fc7", (Object)setting.getId(), (Object)customerCode);
            return;
        }
        BigDecimal totalMarginAmount = relations.stream().map(OrderMarginRelation::getMarginAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        String marginNo = MarginNoGenerator.generateUnique(this::existsByMarginNo);
        MarginBill bill = new MarginBill();
        bill.setMarginNo(marginNo);
        bill.setCustomerCode(customerCode);
        bill.setCustomerName(relations.get(0).getCustomerName());
        bill.setChannelCode(setting.getChannel());
        bill.setChannelName(setting.getChannelName());
        bill.setBillTime(new Date());
        bill.setMarginType(MarginTypeEnum.BZJ07.getCode());
        bill.setAmountPayable(totalMarginAmount);
        bill.setNotifyAmount(totalMarginAmount);
        bill.setPayStatus(1);
        bill.setCreatedAt(new Date());
        bill.setCreatedBy("system");
        this.marginBillMapper.insert(bill);
        for (OrderMarginRelation record : relations) {
            record.setMarginNo(marginNo);
            record.setStatus(1);
            this.orderMarginRelationMapper.updateSelective(record);
        }
        log.info("[MarginBillJob] settingId={} customer={} \u6210\u529f\u751f\u6210\u4fdd\u8bc1\u91d1\u5355 marginNo={} \uff0c\u5408\u8ba1\u91d1\u989d={}", new Object[]{setting.getId(), customerCode, marginNo, totalMarginAmount});
    }

    private boolean existsByMarginNo(String marginNo) {
        return this.getByMarginNo(marginNo) != null;
    }

    public MarginBillServiceImpl(MarginBillMapper marginBillMapper, MarginPaymentMapper marginPaymentMapper, MarginTransferPaymentRelMapper marginTransferPaymentRelMapper, MarginTransferRecordMapper marginTransferRecordMapper, OrderMarginRelationMapper orderMarginRelationMapper, MarginPolicySettingMapper marginPolicySettingMapper) {
        this.marginBillMapper = marginBillMapper;
        this.marginPaymentMapper = marginPaymentMapper;
        this.marginTransferPaymentRelMapper = marginTransferPaymentRelMapper;
        this.marginTransferRecordMapper = marginTransferRecordMapper;
        this.orderMarginRelationMapper = orderMarginRelationMapper;
        this.marginPolicySettingMapper = marginPolicySettingMapper;
    }
}

