/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebPointsConfMapper;
import com.yqbsoft.laser.service.reb.dao.RebPointsMapper;
import com.yqbsoft.laser.service.reb.dao.RebPointsRuleMapper;
import com.yqbsoft.laser.service.reb.domain.RebPointsConfDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsConfReDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsReDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsRuleDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsRuleReDomain;
import com.yqbsoft.laser.service.reb.model.RebPoints;
import com.yqbsoft.laser.service.reb.model.RebPointsConf;
import com.yqbsoft.laser.service.reb.model.RebPointsRule;
import com.yqbsoft.laser.service.reb.service.RebPointsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RebPointsServiceImpl
extends BaseServiceImpl
implements RebPointsService {
    private static final String SYS_CODE = "reb.RebPointsServiceImpl";
    private RebPointsMapper rebPointsMapper;
    private RebPointsConfMapper rebPointsConfMapper;
    private RebPointsRuleMapper rebPointsRuleMapper;
    private String cachekey = "RebPoints-type";
    private String cachekeyRule = "REBPointsRule-api";

    public void setRebPointsMapper(RebPointsMapper rebPointsMapper) {
        this.rebPointsMapper = rebPointsMapper;
    }

    public void setRebPointsConfMapper(RebPointsConfMapper rebPointsConfMapper) {
        this.rebPointsConfMapper = rebPointsConfMapper;
    }

    public void setRebPointsRuleMapper(RebPointsRuleMapper rebPointsRuleMapper) {
        this.rebPointsRuleMapper = rebPointsRuleMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebPointsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPoints(RebPointsDomain rebPointsDomain) {
        if (null == rebPointsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsDefault(RebPoints rebPoints) {
        if (null == rebPoints) {
            return;
        }
        if (null == rebPoints.getDataState()) {
            rebPoints.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPoints.getGmtCreate()) {
            rebPoints.setGmtCreate(date);
        }
        rebPoints.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPoints.getPointsCode())) {
            rebPoints.setPointsCode(this.getNo(null, "RebPoints", "rebPoints", rebPoints.getTenantCode()));
        }
    }

    private int getPointsMaxCode() {
        int code = 0;
        try {
            return this.rebPointsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsUpdataDefault(RebPoints rebPoints) {
        if (null == rebPoints) {
            return;
        }
        rebPoints.setGmtModified(this.getSysDate());
    }

    private void savePointsModel(RebPoints rebPoints) throws ApiException {
        if (null == rebPoints) {
            return;
        }
        try {
            this.rebPointsMapper.insert(rebPoints);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsModel.ex", (Throwable)e);
        }
    }

    private void savePointsBatchModel(List<RebPoints> rebPointsList) throws ApiException {
        if (null == rebPointsList || rebPointsList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsMapper.insertBatch(rebPointsList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsBatchModel.ex", (Throwable)e);
        }
    }

    private RebPoints getPointsModelById(Integer pointsId) {
        if (null == pointsId) {
            return null;
        }
        try {
            return this.rebPointsMapper.selectByPrimaryKey(pointsId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsModelById", (Throwable)e);
            return null;
        }
    }

    private RebPoints getPointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsModelByCode.num");
        }
    }

    private void deletePointsModel(Integer pointsId) throws ApiException {
        if (null == pointsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.deleteByPrimaryKey(pointsId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsModel.num");
        }
    }

    private void updatePointsModel(RebPoints rebPoints) throws ApiException {
        if (null == rebPoints) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.updateByPrimaryKey(rebPoints);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsModel.num");
        }
    }

    private void updateStatePointsModel(Integer pointsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsId", pointsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsModel.null");
        }
    }

    private void updateStatePointsModelByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsModelByCode.null");
        }
    }

    private RebPoints makePoints(RebPointsDomain rebPointsDomain, RebPoints rebPoints) {
        if (null == rebPointsDomain) {
            return null;
        }
        if (null == rebPoints) {
            rebPoints = new RebPoints();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPoints, (Object)rebPointsDomain);
            return rebPoints;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makePoints", (Throwable)e);
            return null;
        }
    }

    private RebPointsReDomain makeRebPointsReDomain(RebPoints rebPoints) {
        if (null == rebPoints) {
            return null;
        }
        RebPointsReDomain rebPointsReDomain = new RebPointsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsReDomain, (Object)rebPoints);
            return rebPointsReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makeRebPointsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPoints> queryPointsModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.queryPointsModel", (Throwable)e);
            return null;
        }
    }

    private int countPoints(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.countPoints", (Throwable)e);
        }
        return i;
    }

    private RebPoints createRebPoints(RebPointsDomain rebPointsDomain) {
        String msg = this.checkPoints(rebPointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.savePoints.checkPoints", msg);
        }
        RebPoints rebPoints = this.makePoints(rebPointsDomain, null);
        this.setPointsDefault(rebPoints);
        return rebPoints;
    }

    private String checkPointsConf(RebPointsConfDomain rebPointsConfDomain) {
        if (null == rebPointsConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsConfDefault(RebPointsConf rebPointsConf) {
        if (null == rebPointsConf) {
            return;
        }
        if (null == rebPointsConf.getDataState()) {
            rebPointsConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPointsConf.getGmtCreate()) {
            rebPointsConf.setGmtCreate(date);
        }
        rebPointsConf.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPointsConf.getPointsCode())) {
            rebPointsConf.setPointsCode(this.getNo(null, "RebPointsConf", "rebPointsConf", rebPointsConf.getTenantCode()));
        }
    }

    private int getPointsConfMaxCode() {
        int code = 0;
        try {
            return this.rebPointsConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsConfUpdataDefault(RebPointsConf rebPointsConf) {
        if (null == rebPointsConf) {
            return;
        }
        rebPointsConf.setGmtModified(this.getSysDate());
    }

    private void savePointsConfModel(RebPointsConf rebPointsConf) throws ApiException {
        if (null == rebPointsConf) {
            return;
        }
        try {
            this.rebPointsConfMapper.insert(rebPointsConf);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsConfModel.ex", (Throwable)e);
        }
    }

    private void savePointsConfBatchModel(List<RebPointsConf> rebPointsConfList) throws ApiException {
        if (null == rebPointsConfList || rebPointsConfList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsConfMapper.insertBatch(rebPointsConfList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsConfBatchModel.ex", (Throwable)e);
        }
    }

    private RebPointsConf getPointsConfModelById(Integer pointsConfId) {
        if (null == pointsConfId) {
            return null;
        }
        try {
            return this.rebPointsConfMapper.selectByPrimaryKey(pointsConfId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsConfModelById", (Throwable)e);
            return null;
        }
    }

    private RebPointsConf getPointsConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsConfModelByCode.num");
        }
    }

    private void deletePointsConfModel(Integer pointsConfId) throws ApiException {
        if (null == pointsConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.deleteByPrimaryKey(pointsConfId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsConfModel.num");
        }
    }

    private void updatePointsConfModel(RebPointsConf rebPointsConf) throws ApiException {
        if (null == rebPointsConf) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.updateByPrimaryKey(rebPointsConf);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsConfModel.num");
        }
    }

    private void updateStatePointsConfModel(Integer pointsConfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsConfId", pointsConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsConfModel.null");
        }
    }

    private void updateStatePointsConfModelByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsConfModelByCode.null");
        }
    }

    private RebPointsConf makePointsConf(RebPointsConfDomain rebPointsConfDomain, RebPointsConf rebPointsConf) {
        if (null == rebPointsConfDomain) {
            return null;
        }
        if (null == rebPointsConf) {
            rebPointsConf = new RebPointsConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsConf, (Object)rebPointsConfDomain);
            return rebPointsConf;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makePointsConf", (Throwable)e);
            return null;
        }
    }

    private RebPointsConfReDomain makeRebPointsConfReDomain(RebPointsConf rebPointsConf) {
        if (null == rebPointsConf) {
            return null;
        }
        RebPointsConfReDomain rebPointsConfReDomain = new RebPointsConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsConfReDomain, (Object)rebPointsConf);
            return rebPointsConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makeRebPointsConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPointsConf> queryPointsConfModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.queryPointsConfModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.countPointsConf", (Throwable)e);
        }
        return i;
    }

    private RebPointsConf createRebPointsConf(RebPointsConfDomain rebPointsConfDomain) {
        String msg = this.checkPointsConf(rebPointsConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsConf.checkPointsConf", msg);
        }
        RebPointsConf rebPointsConf = this.makePointsConf(rebPointsConfDomain, null);
        this.setPointsConfDefault(rebPointsConf);
        return rebPointsConf;
    }

    private String checkPointsRule(RebPointsRuleDomain rebPointsRuleDomain) {
        if (null == rebPointsRuleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsRuleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsRuleDefault(RebPointsRule rebPointsRule) {
        if (null == rebPointsRule) {
            return;
        }
        if (null == rebPointsRule.getDataState()) {
            rebPointsRule.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPointsRule.getGmtCreate()) {
            rebPointsRule.setGmtCreate(date);
        }
        rebPointsRule.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPointsRule.getPointsRuleCode())) {
            rebPointsRule.setPointsRuleCode(this.getNo(null, "RebPointsRule", "rebPointsRule", rebPointsRule.getTenantCode()));
        }
    }

    private int getPointsRuleMaxCode() {
        int code = 0;
        try {
            return this.rebPointsRuleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsRuleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsRuleUpdataDefault(RebPointsRule rebPointsRule) {
        if (null == rebPointsRule) {
            return;
        }
        rebPointsRule.setGmtModified(this.getSysDate());
    }

    private void savePointsRuleModel(RebPointsRule rebPointsRule) throws ApiException {
        if (null == rebPointsRule) {
            return;
        }
        try {
            this.rebPointsRuleMapper.insert(rebPointsRule);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsRuleModel.ex", (Throwable)e);
        }
    }

    private void savePointsRuleBatchModel(List<RebPointsRule> rebPointsRuleList) throws ApiException {
        if (null == rebPointsRuleList || rebPointsRuleList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsRuleMapper.insertBatch(rebPointsRuleList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsRuleBatchModel.ex", (Throwable)e);
        }
    }

    private RebPointsRule getPointsRuleModelById(Integer pointsRuleId) {
        if (null == pointsRuleId) {
            return null;
        }
        try {
            return this.rebPointsRuleMapper.selectByPrimaryKey(pointsRuleId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsRuleModelById", (Throwable)e);
            return null;
        }
    }

    private RebPointsRule getPointsRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsRuleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsRuleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsRuleModelByCode.num");
        }
    }

    private void deletePointsRuleModel(Integer pointsRuleId) throws ApiException {
        if (null == pointsRuleId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.deleteByPrimaryKey(pointsRuleId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsRuleModel.num");
        }
    }

    private void updatePointsRuleModel(RebPointsRule rebPointsRule) throws ApiException {
        if (null == rebPointsRule) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.updateByPrimaryKeyWithBLOBs(rebPointsRule);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsRuleModel.num");
        }
    }

    private void updateStatePointsRuleModel(Integer pointsRuleId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsRuleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsRuleId", pointsRuleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsRuleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsRuleModel.null");
        }
    }

    private void updateStatePointsRuleModelByCode(String tenantCode, String pointsRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleCode", pointsRuleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsRuleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsRuleModelByCode.null");
        }
    }

    private RebPointsRule makePointsRule(RebPointsRuleDomain rebPointsRuleDomain, RebPointsRule rebPointsRule) {
        if (null == rebPointsRuleDomain) {
            return null;
        }
        if (null == rebPointsRule) {
            rebPointsRule = new RebPointsRule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsRule, (Object)rebPointsRuleDomain);
            return rebPointsRule;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makePointsRule", (Throwable)e);
            return null;
        }
    }

    private RebPointsRuleReDomain makeRebPointsRuleReDomain(RebPointsRule rebPointsRule) {
        if (null == rebPointsRule) {
            return null;
        }
        RebPointsRuleReDomain rebPointsRuleReDomain = new RebPointsRuleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsRuleReDomain, (Object)rebPointsRule);
            return rebPointsRuleReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makeRebPointsRuleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPointsRule> queryPointsRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.queryPointsRuleModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsRule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.countPointsRule", (Throwable)e);
        }
        return i;
    }

    private RebPointsRule createRebPointsRule(RebPointsRuleDomain rebPointsRuleDomain) {
        String msg = this.checkPointsRule(rebPointsRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsRule.checkPointsRule", msg);
        }
        RebPointsRule rebPointsRule = this.makePointsRule(rebPointsRuleDomain, null);
        this.setPointsRuleDefault(rebPointsRule);
        return rebPointsRule;
    }

    @Override
    public String savePoints(RebPointsDomain rebPointsDomain) throws ApiException {
        RebPoints rebPoints = this.createRebPoints(rebPointsDomain);
        this.savePointsModel(rebPoints);
        return rebPoints.getPointsCode();
    }

    @Override
    public String savePointsBatch(List<RebPointsDomain> rebPointsDomainList) throws ApiException {
        if (null == rebPointsDomainList || rebPointsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPoints> rebPointsList = new ArrayList<RebPoints>();
        String code = "";
        for (RebPointsDomain rebPointsDomain : rebPointsDomainList) {
            RebPoints rebPoints = this.createRebPoints(rebPointsDomain);
            code = rebPoints.getPointsCode();
            rebPointsList.add(rebPoints);
        }
        this.savePointsBatchModel(rebPointsList);
        return code;
    }

    @Override
    public void updatePointsState(Integer pointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsId) {
            return;
        }
        this.updateStatePointsModel(pointsId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsStateByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsModelByCode(tenantCode, pointsCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePoints(RebPointsDomain rebPointsDomain) throws ApiException {
        String msg = this.checkPoints(rebPointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePoints.checkPoints", msg);
        }
        RebPoints oldRebPoints = this.getPointsModelById(rebPointsDomain.getPointsId());
        if (null == oldRebPoints) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePoints.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPoints rebPoints = this.makePoints(rebPointsDomain, oldRebPoints);
        this.setPointsUpdataDefault(rebPoints);
        this.updatePointsModel(rebPoints);
    }

    @Override
    public RebPoints getPoints(Integer pointsId) {
        if (null == pointsId) {
            return null;
        }
        return this.getPointsModelById(pointsId);
    }

    @Override
    public void deletePoints(Integer pointsId) throws ApiException {
        if (null == pointsId) {
            return;
        }
        this.deletePointsModel(pointsId);
    }

    @Override
    public QueryResult<RebPoints> queryPointsPage(Map<String, Object> map) {
        List<RebPoints> rebPointsList = this.queryPointsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsList);
        return queryResult;
    }

    @Override
    public RebPoints getPointsByCode(String tenantCode, String pointsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        return this.getPointsModelByCode(map);
    }

    @Override
    public void deletePointsByCode(String tenantCode, String pointsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        this.delPointsModelByCode(map);
    }

    @Override
    public String savePointsConf(RebPointsConfDomain rebPointsConfDomain) throws ApiException {
        RebPointsConf rebPointsConf = this.createRebPointsConf(rebPointsConfDomain);
        this.savePointsConfModel(rebPointsConf);
        return rebPointsConf.getPointsCode();
    }

    @Override
    public String savePointsConfBatch(List<RebPointsConfDomain> rebPointsConfDomainList) throws ApiException {
        if (null == rebPointsConfDomainList || rebPointsConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPointsConf> rebPointsConfList = new ArrayList<RebPointsConf>();
        String code = "";
        for (RebPointsConfDomain rebPointsConfDomain : rebPointsConfDomainList) {
            RebPointsConf rebPointsConf = this.createRebPointsConf(rebPointsConfDomain);
            code = rebPointsConf.getPointsCode();
            rebPointsConfList.add(rebPointsConf);
        }
        this.savePointsConfBatchModel(rebPointsConfList);
        return code;
    }

    @Override
    public void updatePointsConfState(Integer pointsConfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsConfId) {
            return;
        }
        this.updateStatePointsConfModel(pointsConfId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsConfStateByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsConfModelByCode(tenantCode, pointsCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsConf(RebPointsConfDomain rebPointsConfDomain) throws ApiException {
        String msg = this.checkPointsConf(rebPointsConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsConf.checkPointsConf", msg);
        }
        RebPointsConf oldRebPointsConf = this.getPointsConfModelById(rebPointsConfDomain.getPointsConfId());
        if (null == oldRebPointsConf) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPointsConf rebPointsConf = this.makePointsConf(rebPointsConfDomain, oldRebPointsConf);
        this.setPointsConfUpdataDefault(rebPointsConf);
        this.updatePointsConfModel(rebPointsConf);
    }

    @Override
    public RebPointsConf getPointsConf(Integer pointsConfId) {
        if (null == pointsConfId) {
            return null;
        }
        return this.getPointsConfModelById(pointsConfId);
    }

    @Override
    public void deletePointsConf(Integer pointsConfId) throws ApiException {
        if (null == pointsConfId) {
            return;
        }
        this.deletePointsConfModel(pointsConfId);
    }

    @Override
    public QueryResult<RebPointsConf> queryPointsConfPage(Map<String, Object> map) {
        List<RebPointsConf> rebPointsConfList = this.queryPointsConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsConfList);
        return queryResult;
    }

    @Override
    public RebPointsConf getPointsConfByCode(String tenantCode, String pointsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        return this.getPointsConfModelByCode(map);
    }

    @Override
    public void deletePointsConfByCode(String tenantCode, String pointsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        this.delPointsConfModelByCode(map);
    }

    @Override
    public String savePointsRule(RebPointsRuleDomain rebPointsRuleDomain) throws ApiException {
        RebPointsRule rebPointsRule = this.createRebPointsRule(rebPointsRuleDomain);
        this.savePointsRuleModel(rebPointsRule);
        return rebPointsRule.getPointsRuleCode();
    }

    @Override
    public String savePointsRuleBatch(List<RebPointsRuleDomain> rebPointsRuleDomainList) throws ApiException {
        if (null == rebPointsRuleDomainList || rebPointsRuleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPointsRule> rebPointsRuleList = new ArrayList<RebPointsRule>();
        String code = "";
        for (RebPointsRuleDomain rebPointsRuleDomain : rebPointsRuleDomainList) {
            RebPointsRule rebPointsRule = this.createRebPointsRule(rebPointsRuleDomain);
            code = rebPointsRule.getPointsRuleCode();
            rebPointsRuleList.add(rebPointsRule);
        }
        this.savePointsRuleBatchModel(rebPointsRuleList);
        return code;
    }

    @Override
    public void updatePointsRuleState(Integer pointsRuleId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsRuleId) {
            return;
        }
        this.updateStatePointsRuleModel(pointsRuleId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsRuleStateByCode(String tenantCode, String pointsRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsRuleModelByCode(tenantCode, pointsRuleCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsRule(RebPointsRuleDomain rebPointsRuleDomain) throws ApiException {
        String msg = this.checkPointsRule(rebPointsRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsRule.checkPointsRule", msg);
        }
        RebPointsRule oldRebPointsRule = this.getPointsRuleModelById(rebPointsRuleDomain.getPointsRuleId());
        if (null == oldRebPointsRule) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsRule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPointsRule rebPointsRule = this.makePointsRule(rebPointsRuleDomain, oldRebPointsRule);
        this.setPointsRuleUpdataDefault(rebPointsRule);
        this.updatePointsRuleModel(rebPointsRule);
    }

    @Override
    public RebPointsRule getPointsRule(Integer pointsRuleId) {
        if (null == pointsRuleId) {
            return null;
        }
        return this.getPointsRuleModelById(pointsRuleId);
    }

    @Override
    public void deletePointsRule(Integer pointsRuleId) throws ApiException {
        if (null == pointsRuleId) {
            return;
        }
        this.deletePointsRuleModel(pointsRuleId);
    }

    @Override
    public QueryResult<RebPointsRule> queryPointsRulePage(Map<String, Object> map) {
        List<RebPointsRule> rebPointsRuleList = this.queryPointsRuleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsRule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsRuleList);
        return queryResult;
    }

    @Override
    public RebPointsRule getPointsRuleByCode(String tenantCode, String pointsRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleCode", pointsRuleCode);
        return this.getPointsRuleModelByCode(map);
    }

    @Override
    public void deletePointsRuleByCode(String tenantCode, String pointsRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleCode", pointsRuleCode);
        this.delPointsRuleModelByCode(map);
    }

    @Override
    public void queryPointsCache() {
        this.logger.info("RebPointsServiceImpl.queryPointsCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<RebPoints> list = this.queryPointsModelPage(parammap);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("RebPointsServiceImpl.queryPointsCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (RebPoints rebPoints : list) {
            if (!StringUtils.isNotBlank((String)rebPoints.getUpointsType())) continue;
            String key = rebPoints.getUpointsType() + "-" + rebPoints.getTenantCode();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)rebPoints));
        }
        DisUtil.setMapVer((String)this.cachekey, map);
        this.logger.info("RebPointsServiceImpl.queryPointsCache", (Object)"===========add-end==========");
    }

    @Override
    public void queryPointsRuleCache() {
        this.logger.info("RebPointsRuleServiceImpl.queryPointsRuleCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", "1");
        List<RebPointsRule> list = this.queryPointsRuleModelPage(parammap);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekeyRule);
            this.logger.info("RebPointsRuleServiceImpl.queryPointsRuleCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (RebPointsRule rebPointsRule : list) {
            if (!StringUtils.isNotBlank((String)rebPointsRule.getUpointsType())) continue;
            String key = rebPointsRule.getUpointsType() + "-" + rebPointsRule.getPointsRuleApi() + "-" + rebPointsRule.getTenantCode();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)rebPointsRule));
        }
        DisUtil.setMapVer((String)this.cachekeyRule, map);
        this.logger.info("RebPointsRuleServiceImpl.queryPointsRuleCache", (Object)"===========add-end==========");
    }
}

