/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebPointsuserConfMapper;
import com.yqbsoft.laser.service.reb.dao.RebPointsuserMapper;
import com.yqbsoft.laser.service.reb.dao.RebPointsuserUconfMapper;
import com.yqbsoft.laser.service.reb.domain.RebPointsuserConfDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsuserConfReDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsuserDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsuserReDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsuserUconfDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsuserUconfReDomain;
import com.yqbsoft.laser.service.reb.model.RebPointsuser;
import com.yqbsoft.laser.service.reb.model.RebPointsuserConf;
import com.yqbsoft.laser.service.reb.model.RebPointsuserUconf;
import com.yqbsoft.laser.service.reb.service.RebPointsuserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RebPointsuserServiceImpl
extends BaseServiceImpl
implements RebPointsuserService {
    private static final String SYS_CODE = "reb.RebPointsuserServiceImpl";
    private RebPointsuserMapper rebPointsuserMapper;
    private RebPointsuserConfMapper rebPointsuserConfMapper;
    private RebPointsuserUconfMapper rebPointsuserUconfMapper;

    public void setRebPointsuserMapper(RebPointsuserMapper rebPointsuserMapper) {
        this.rebPointsuserMapper = rebPointsuserMapper;
    }

    public void setRebPointsuserConfMapper(RebPointsuserConfMapper rebPointsuserConfMapper) {
        this.rebPointsuserConfMapper = rebPointsuserConfMapper;
    }

    public void setRebPointsuserUconfMapper(RebPointsuserUconfMapper rebPointsuserUconfMapper) {
        this.rebPointsuserUconfMapper = rebPointsuserUconfMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebPointsuserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPointsuser(RebPointsuserDomain rebPointsuserDomain) {
        if (null == rebPointsuserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsuserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsuserDefault(RebPointsuser rebPointsuser) {
        if (null == rebPointsuser) {
            return;
        }
        if (null == rebPointsuser.getDataState()) {
            rebPointsuser.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPointsuser.getGmtCreate()) {
            rebPointsuser.setGmtCreate(date);
        }
        rebPointsuser.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPointsuser.getPointsuserCode())) {
            rebPointsuser.setPointsuserCode(this.getNo(null, "RebPointsuser", "rebPointsuser", rebPointsuser.getTenantCode()));
        }
    }

    private int getPointsuserMaxCode() {
        int code = 0;
        try {
            return this.rebPointsuserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getPointsuserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsuserUpdataDefault(RebPointsuser rebPointsuser) {
        if (null == rebPointsuser) {
            return;
        }
        rebPointsuser.setGmtModified(this.getSysDate());
    }

    private void savePointsuserModel(RebPointsuser rebPointsuser) throws ApiException {
        if (null == rebPointsuser) {
            return;
        }
        try {
            this.rebPointsuserMapper.insert(rebPointsuser);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.savePointsuserModel.ex", (Throwable)e);
        }
    }

    private void savePointsuserBatchModel(List<RebPointsuser> rebPointsuserList) throws ApiException {
        if (null == rebPointsuserList || rebPointsuserList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsuserMapper.insertBatch(rebPointsuserList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.savePointsuserBatchModel.ex", (Throwable)e);
        }
    }

    private RebPointsuser getPointsuserModelById(Integer pointsuserId) {
        if (null == pointsuserId) {
            return null;
        }
        try {
            return this.rebPointsuserMapper.selectByPrimaryKey(pointsuserId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getPointsuserModelById", (Throwable)e);
            return null;
        }
    }

    private RebPointsuser getPointsuserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsuserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getPointsuserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsuserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsuserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.delPointsuserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsuserServiceImpl.delPointsuserModelByCode.num");
        }
    }

    private void deletePointsuserModel(Integer pointsuserId) throws ApiException {
        if (null == pointsuserId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsuserMapper.deleteByPrimaryKey(pointsuserId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.deletePointsuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsuserServiceImpl.deletePointsuserModel.num");
        }
    }

    private void updatePointsuserModel(RebPointsuser rebPointsuser) throws ApiException {
        if (null == rebPointsuser) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsuserMapper.updateByPrimaryKey(rebPointsuser);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserModel.num");
        }
    }

    private void updateStatePointsuserModel(Integer pointsuserId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsuserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsuserId", pointsuserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsuserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserModel.null");
        }
    }

    private void updateStatePointsuserModelByCode(String tenantCode, String pointsuserCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsuserCode", pointsuserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsuserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserModelByCode.null");
        }
    }

    private RebPointsuser makePointsuser(RebPointsuserDomain rebPointsuserDomain, RebPointsuser rebPointsuser) {
        if (null == rebPointsuserDomain) {
            return null;
        }
        if (null == rebPointsuser) {
            rebPointsuser = new RebPointsuser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsuser, (Object)rebPointsuserDomain);
            return rebPointsuser;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.makePointsuser", (Throwable)e);
            return null;
        }
    }

    private RebPointsuserReDomain makeRebPointsuserReDomain(RebPointsuser rebPointsuser) {
        if (null == rebPointsuser) {
            return null;
        }
        RebPointsuserReDomain rebPointsuserReDomain = new RebPointsuserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsuserReDomain, (Object)rebPointsuser);
            return rebPointsuserReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.makeRebPointsuserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPointsuser> queryPointsuserModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsuserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.queryPointsuserModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsuser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsuserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.countPointsuser", (Throwable)e);
        }
        return i;
    }

    private RebPointsuser createRebPointsuser(RebPointsuserDomain rebPointsuserDomain) {
        String msg = this.checkPointsuser(rebPointsuserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsuserServiceImpl.savePointsuser.checkPointsuser", msg);
        }
        RebPointsuser rebPointsuser = this.makePointsuser(rebPointsuserDomain, null);
        this.setPointsuserDefault(rebPointsuser);
        return rebPointsuser;
    }

    private String checkPointsuserConf(RebPointsuserConfDomain rebPointsuserConfDomain) {
        if (null == rebPointsuserConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsuserConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsuserConfDefault(RebPointsuserConf rebPointsuserConf) {
        if (null == rebPointsuserConf) {
            return;
        }
        if (null == rebPointsuserConf.getDataState()) {
            rebPointsuserConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPointsuserConf.getGmtCreate()) {
            rebPointsuserConf.setGmtCreate(date);
        }
        rebPointsuserConf.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPointsuserConf.getPointsuserConfCode())) {
            rebPointsuserConf.setPointsuserConfCode(this.getNo(null, "RebPointsuserConf", "rebPointsuserConf", rebPointsuserConf.getTenantCode()));
        }
    }

    private int getPointsuserConfMaxCode() {
        int code = 0;
        try {
            return this.rebPointsuserConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getPointsuserConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsuserConfUpdataDefault(RebPointsuserConf rebPointsuserConf) {
        if (null == rebPointsuserConf) {
            return;
        }
        rebPointsuserConf.setGmtModified(this.getSysDate());
    }

    private void savePointsuserConfModel(RebPointsuserConf rebPointsuserConf) throws ApiException {
        if (null == rebPointsuserConf) {
            return;
        }
        try {
            this.rebPointsuserConfMapper.insert(rebPointsuserConf);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.savePointsuserConfModel.ex", (Throwable)e);
        }
    }

    private void savePointsuserConfBatchModel(List<RebPointsuserConf> rebPointsuserConfList) throws ApiException {
        if (null == rebPointsuserConfList || rebPointsuserConfList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsuserConfMapper.insertBatch(rebPointsuserConfList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.savePointsuserConfBatchModel.ex", (Throwable)e);
        }
    }

    private RebPointsuserConf getPointsuserConfModelById(Integer pointsuserConfId) {
        if (null == pointsuserConfId) {
            return null;
        }
        try {
            return this.rebPointsuserConfMapper.selectByPrimaryKey(pointsuserConfId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getPointsuserConfModelById", (Throwable)e);
            return null;
        }
    }

    private RebPointsuserConf getPointsuserConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsuserConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getPointsuserConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsuserConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsuserConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.delPointsuserConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsuserServiceImpl.delPointsuserConfModelByCode.num");
        }
    }

    private void deletePointsuserConfModel(Integer pointsuserConfId) throws ApiException {
        if (null == pointsuserConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsuserConfMapper.deleteByPrimaryKey(pointsuserConfId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.deletePointsuserConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsuserServiceImpl.deletePointsuserConfModel.num");
        }
    }

    private void updatePointsuserConfModel(RebPointsuserConf rebPointsuserConf) throws ApiException {
        if (null == rebPointsuserConf) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsuserConfMapper.updateByPrimaryKey(rebPointsuserConf);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserConfModel.num");
        }
    }

    private void updateStatePointsuserConfModel(Integer pointsuserConfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsuserConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsuserConfId", pointsuserConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsuserConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserConfModel.null");
        }
    }

    private void updateStatePointsuserConfModelByCode(String tenantCode, String pointsuserConfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserConfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsuserConfCode", pointsuserConfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsuserConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserConfModelByCode.null");
        }
    }

    private RebPointsuserConf makePointsuserConf(RebPointsuserConfDomain rebPointsuserConfDomain, RebPointsuserConf rebPointsuserConf) {
        if (null == rebPointsuserConfDomain) {
            return null;
        }
        if (null == rebPointsuserConf) {
            rebPointsuserConf = new RebPointsuserConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsuserConf, (Object)rebPointsuserConfDomain);
            return rebPointsuserConf;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.makePointsuserConf", (Throwable)e);
            return null;
        }
    }

    private RebPointsuserConfReDomain makeRebPointsuserConfReDomain(RebPointsuserConf rebPointsuserConf) {
        if (null == rebPointsuserConf) {
            return null;
        }
        RebPointsuserConfReDomain rebPointsuserConfReDomain = new RebPointsuserConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsuserConfReDomain, (Object)rebPointsuserConf);
            return rebPointsuserConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.makeRebPointsuserConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPointsuserConf> queryPointsuserConfModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsuserConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.queryPointsuserConfModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsuserConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsuserConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.countPointsuserConf", (Throwable)e);
        }
        return i;
    }

    private RebPointsuserConf createRebPointsuserConf(RebPointsuserConfDomain rebPointsuserConfDomain) {
        String msg = this.checkPointsuserConf(rebPointsuserConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsuserServiceImpl.savePointsuserConf.checkPointsuserConf", msg);
        }
        RebPointsuserConf rebPointsuserConf = this.makePointsuserConf(rebPointsuserConfDomain, null);
        this.setPointsuserConfDefault(rebPointsuserConf);
        return rebPointsuserConf;
    }

    private String checkPointsuserUconf(RebPointsuserUconfDomain rebPointsuserUconfDomain) {
        if (null == rebPointsuserUconfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsuserUconfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsuserUconfDefault(RebPointsuserUconf rebPointsuserUconf) {
        if (null == rebPointsuserUconf) {
            return;
        }
        if (null == rebPointsuserUconf.getDataState()) {
            rebPointsuserUconf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPointsuserUconf.getGmtCreate()) {
            rebPointsuserUconf.setGmtCreate(date);
        }
        rebPointsuserUconf.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPointsuserUconf.getPointsuserUconfCode())) {
            rebPointsuserUconf.setPointsuserUconfCode(this.getNo(null, "RebPointsuserUconf", "rebPointsuserUconf", rebPointsuserUconf.getTenantCode()));
        }
    }

    private int getPointsuserUconfMaxCode() {
        int code = 0;
        try {
            return this.rebPointsuserUconfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getPointsuserUconfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsuserUconfUpdataDefault(RebPointsuserUconf rebPointsuserUconf) {
        if (null == rebPointsuserUconf) {
            return;
        }
        rebPointsuserUconf.setGmtModified(this.getSysDate());
    }

    private void savePointsuserUconfModel(RebPointsuserUconf rebPointsuserUconf) throws ApiException {
        if (null == rebPointsuserUconf) {
            return;
        }
        try {
            this.rebPointsuserUconfMapper.insert(rebPointsuserUconf);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.savePointsuserUconfModel.ex", (Throwable)e);
        }
    }

    private void savePointsuserUconfBatchModel(List<RebPointsuserUconf> rebPointsuserUconfList) throws ApiException {
        if (null == rebPointsuserUconfList || rebPointsuserUconfList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsuserUconfMapper.insertBatch(rebPointsuserUconfList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.savePointsuserUconfBatchModel.ex", (Throwable)e);
        }
    }

    private RebPointsuserUconf getPointsuserUconfModelById(Integer pointsuserUconfId) {
        if (null == pointsuserUconfId) {
            return null;
        }
        try {
            return this.rebPointsuserUconfMapper.selectByPrimaryKey(pointsuserUconfId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getPointsuserUconfModelById", (Throwable)e);
            return null;
        }
    }

    private RebPointsuserUconf getPointsuserUconfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsuserUconfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.getPointsuserUconfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsuserUconfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsuserUconfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.delPointsuserUconfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsuserServiceImpl.delPointsuserUconfModelByCode.num");
        }
    }

    private void deletePointsuserUconfModel(Integer pointsuserUconfId) throws ApiException {
        if (null == pointsuserUconfId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsuserUconfMapper.deleteByPrimaryKey(pointsuserUconfId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.deletePointsuserUconfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsuserServiceImpl.deletePointsuserUconfModel.num");
        }
    }

    private void updatePointsuserUconfModel(RebPointsuserUconf rebPointsuserUconf) throws ApiException {
        if (null == rebPointsuserUconf) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsuserUconfMapper.updateByPrimaryKey(rebPointsuserUconf);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserUconfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserUconfModel.num");
        }
    }

    private void updateStatePointsuserUconfModel(Integer pointsuserUconfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsuserUconfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsuserUconfId", pointsuserUconfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsuserUconfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserUconfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserUconfModel.null");
        }
    }

    private void updateStatePointsuserUconfModelByCode(String tenantCode, String pointsuserUconfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserUconfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsuserUconfCode", pointsuserUconfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsuserUconfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserUconfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updateStatePointsuserUconfModelByCode.null");
        }
    }

    private RebPointsuserUconf makePointsuserUconf(RebPointsuserUconfDomain rebPointsuserUconfDomain, RebPointsuserUconf rebPointsuserUconf) {
        if (null == rebPointsuserUconfDomain) {
            return null;
        }
        if (null == rebPointsuserUconf) {
            rebPointsuserUconf = new RebPointsuserUconf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsuserUconf, (Object)rebPointsuserUconfDomain);
            return rebPointsuserUconf;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.makePointsuserUconf", (Throwable)e);
            return null;
        }
    }

    private RebPointsuserUconfReDomain makeRebPointsuserUconfReDomain(RebPointsuserUconf rebPointsuserUconf) {
        if (null == rebPointsuserUconf) {
            return null;
        }
        RebPointsuserUconfReDomain rebPointsuserUconfReDomain = new RebPointsuserUconfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsuserUconfReDomain, (Object)rebPointsuserUconf);
            return rebPointsuserUconfReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.makeRebPointsuserUconfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPointsuserUconf> queryPointsuserUconfModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsuserUconfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.queryPointsuserUconfModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsuserUconf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsuserUconfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsuserServiceImpl.countPointsuserUconf", (Throwable)e);
        }
        return i;
    }

    private RebPointsuserUconf createRebPointsuserUconf(RebPointsuserUconfDomain rebPointsuserUconfDomain) {
        String msg = this.checkPointsuserUconf(rebPointsuserUconfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsuserServiceImpl.savePointsuserUconf.checkPointsuserUconf", msg);
        }
        RebPointsuserUconf rebPointsuserUconf = this.makePointsuserUconf(rebPointsuserUconfDomain, null);
        this.setPointsuserUconfDefault(rebPointsuserUconf);
        return rebPointsuserUconf;
    }

    @Override
    public String savePointsuser(RebPointsuserDomain rebPointsuserDomain) throws ApiException {
        RebPointsuser rebPointsuser = this.createRebPointsuser(rebPointsuserDomain);
        this.savePointsuserModel(rebPointsuser);
        return rebPointsuser.getPointsuserCode();
    }

    @Override
    public String savePointsuserBatch(List<RebPointsuserDomain> rebPointsuserDomainList) throws ApiException {
        if (null == rebPointsuserDomainList || rebPointsuserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPointsuser> rebPointsuserList = new ArrayList<RebPointsuser>();
        String code = "";
        for (RebPointsuserDomain rebPointsuserDomain : rebPointsuserDomainList) {
            RebPointsuser rebPointsuser = this.createRebPointsuser(rebPointsuserDomain);
            code = rebPointsuser.getPointsuserCode();
            rebPointsuserList.add(rebPointsuser);
        }
        this.savePointsuserBatchModel(rebPointsuserList);
        return code;
    }

    @Override
    public void updatePointsuserState(Integer pointsuserId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsuserId) {
            return;
        }
        this.updateStatePointsuserModel(pointsuserId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsuserStateByCode(String tenantCode, String pointsuserCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsuserModelByCode(tenantCode, pointsuserCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsuser(RebPointsuserDomain rebPointsuserDomain) throws ApiException {
        String msg = this.checkPointsuser(rebPointsuserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuser.checkPointsuser", msg);
        }
        RebPointsuser oldRebPointsuser = this.getPointsuserModelById(rebPointsuserDomain.getPointsuserId());
        if (null == oldRebPointsuser) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPointsuser rebPointsuser = this.makePointsuser(rebPointsuserDomain, oldRebPointsuser);
        this.setPointsuserUpdataDefault(rebPointsuser);
        this.updatePointsuserModel(rebPointsuser);
    }

    @Override
    public RebPointsuser getPointsuser(Integer pointsuserId) {
        if (null == pointsuserId) {
            return null;
        }
        return this.getPointsuserModelById(pointsuserId);
    }

    @Override
    public void deletePointsuser(Integer pointsuserId) throws ApiException {
        if (null == pointsuserId) {
            return;
        }
        this.deletePointsuserModel(pointsuserId);
    }

    @Override
    public QueryResult<RebPointsuser> queryPointsuserPage(Map<String, Object> map) {
        List<RebPointsuser> rebPointsuserList = this.queryPointsuserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsuser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsuserList);
        return queryResult;
    }

    @Override
    public RebPointsuser getPointsuserByCode(String tenantCode, String pointsuserCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsuserCode", pointsuserCode);
        return this.getPointsuserModelByCode(map);
    }

    @Override
    public void deletePointsuserByCode(String tenantCode, String pointsuserCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsuserCode", pointsuserCode);
        this.delPointsuserModelByCode(map);
    }

    @Override
    public String savePointsuserConf(RebPointsuserConfDomain rebPointsuserConfDomain) throws ApiException {
        RebPointsuserConf rebPointsuserConf = this.createRebPointsuserConf(rebPointsuserConfDomain);
        this.savePointsuserConfModel(rebPointsuserConf);
        return rebPointsuserConf.getPointsuserConfCode();
    }

    @Override
    public String savePointsuserConfBatch(List<RebPointsuserConfDomain> rebPointsuserConfDomainList) throws ApiException {
        if (null == rebPointsuserConfDomainList || rebPointsuserConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPointsuserConf> rebPointsuserConfList = new ArrayList<RebPointsuserConf>();
        String code = "";
        for (RebPointsuserConfDomain rebPointsuserConfDomain : rebPointsuserConfDomainList) {
            RebPointsuserConf rebPointsuserConf = this.createRebPointsuserConf(rebPointsuserConfDomain);
            code = rebPointsuserConf.getPointsuserConfCode();
            rebPointsuserConfList.add(rebPointsuserConf);
        }
        this.savePointsuserConfBatchModel(rebPointsuserConfList);
        return code;
    }

    @Override
    public void updatePointsuserConfState(Integer pointsuserConfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsuserConfId) {
            return;
        }
        this.updateStatePointsuserConfModel(pointsuserConfId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsuserConfStateByCode(String tenantCode, String pointsuserConfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsuserConfModelByCode(tenantCode, pointsuserConfCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsuserConf(RebPointsuserConfDomain rebPointsuserConfDomain) throws ApiException {
        String msg = this.checkPointsuserConf(rebPointsuserConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserConf.checkPointsuserConf", msg);
        }
        RebPointsuserConf oldRebPointsuserConf = this.getPointsuserConfModelById(rebPointsuserConfDomain.getPointsuserConfId());
        if (null == oldRebPointsuserConf) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPointsuserConf rebPointsuserConf = this.makePointsuserConf(rebPointsuserConfDomain, oldRebPointsuserConf);
        this.setPointsuserConfUpdataDefault(rebPointsuserConf);
        this.updatePointsuserConfModel(rebPointsuserConf);
    }

    @Override
    public RebPointsuserConf getPointsuserConf(Integer pointsuserConfId) {
        if (null == pointsuserConfId) {
            return null;
        }
        return this.getPointsuserConfModelById(pointsuserConfId);
    }

    @Override
    public void deletePointsuserConf(Integer pointsuserConfId) throws ApiException {
        if (null == pointsuserConfId) {
            return;
        }
        this.deletePointsuserConfModel(pointsuserConfId);
    }

    @Override
    public QueryResult<RebPointsuserConf> queryPointsuserConfPage(Map<String, Object> map) {
        List<RebPointsuserConf> rebPointsuserConfList = this.queryPointsuserConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsuserConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsuserConfList);
        return queryResult;
    }

    @Override
    public RebPointsuserConf getPointsuserConfByCode(String tenantCode, String pointsuserConfCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsuserConfCode", pointsuserConfCode);
        return this.getPointsuserConfModelByCode(map);
    }

    @Override
    public void deletePointsuserConfByCode(String tenantCode, String pointsuserConfCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsuserConfCode", pointsuserConfCode);
        this.delPointsuserConfModelByCode(map);
    }

    @Override
    public String savePointsuserUconf(RebPointsuserUconfDomain rebPointsuserUconfDomain) throws ApiException {
        RebPointsuserUconf rebPointsuserUconf = this.createRebPointsuserUconf(rebPointsuserUconfDomain);
        this.savePointsuserUconfModel(rebPointsuserUconf);
        return rebPointsuserUconf.getPointsuserUconfCode();
    }

    @Override
    public String savePointsuserUconfBatch(List<RebPointsuserUconfDomain> rebPointsuserUconfDomainList) throws ApiException {
        if (null == rebPointsuserUconfDomainList || rebPointsuserUconfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPointsuserUconf> rebPointsuserUconfList = new ArrayList<RebPointsuserUconf>();
        String code = "";
        for (RebPointsuserUconfDomain rebPointsuserUconfDomain : rebPointsuserUconfDomainList) {
            RebPointsuserUconf rebPointsuserUconf = this.createRebPointsuserUconf(rebPointsuserUconfDomain);
            code = rebPointsuserUconf.getPointsuserUconfCode();
            rebPointsuserUconfList.add(rebPointsuserUconf);
        }
        this.savePointsuserUconfBatchModel(rebPointsuserUconfList);
        return code;
    }

    @Override
    public void updatePointsuserUconfState(Integer pointsuserUconfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsuserUconfId) {
            return;
        }
        this.updateStatePointsuserUconfModel(pointsuserUconfId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsuserUconfStateByCode(String tenantCode, String pointsuserUconfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserUconfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsuserUconfModelByCode(tenantCode, pointsuserUconfCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsuserUconf(RebPointsuserUconfDomain rebPointsuserUconfDomain) throws ApiException {
        String msg = this.checkPointsuserUconf(rebPointsuserUconfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserUconf.checkPointsuserUconf", msg);
        }
        RebPointsuserUconf oldRebPointsuserUconf = this.getPointsuserUconfModelById(rebPointsuserUconfDomain.getPointsuserUconfId());
        if (null == oldRebPointsuserUconf) {
            throw new ApiException("reb.RebPointsuserServiceImpl.updatePointsuserUconf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPointsuserUconf rebPointsuserUconf = this.makePointsuserUconf(rebPointsuserUconfDomain, oldRebPointsuserUconf);
        this.setPointsuserUconfUpdataDefault(rebPointsuserUconf);
        this.updatePointsuserUconfModel(rebPointsuserUconf);
    }

    @Override
    public RebPointsuserUconf getPointsuserUconf(Integer pointsuserUconfId) {
        if (null == pointsuserUconfId) {
            return null;
        }
        return this.getPointsuserUconfModelById(pointsuserUconfId);
    }

    @Override
    public void deletePointsuserUconf(Integer pointsuserUconfId) throws ApiException {
        if (null == pointsuserUconfId) {
            return;
        }
        this.deletePointsuserUconfModel(pointsuserUconfId);
    }

    @Override
    public QueryResult<RebPointsuserUconf> queryPointsuserUconfPage(Map<String, Object> map) {
        List<RebPointsuserUconf> rebPointsuserUconfList = this.queryPointsuserUconfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsuserUconf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsuserUconfList);
        return queryResult;
    }

    @Override
    public RebPointsuserUconf getPointsuserUconfByCode(String tenantCode, String pointsuserUconfCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserUconfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsuserUconfCode", pointsuserUconfCode);
        return this.getPointsuserUconfModelByCode(map);
    }

    @Override
    public void deletePointsuserUconfByCode(String tenantCode, String pointsuserUconfCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsuserUconfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsuserUconfCode", pointsuserUconfCode);
        this.delPointsuserUconfModelByCode(map);
    }

    @Override
    public void queryPointsuserCache() {
        String cachekey = "RebPointsuser-type";
        this.logger.info("reb.RebPointsuserServiceImpl.queryPointsuserCache.star", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<RebPointsuser> list = this.queryPointsuserModelPage(parammap);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)cachekey);
            this.logger.info("reb.RebPointsuserServiceImpl.queryPointsuserCache.list", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (RebPointsuser rebPointsuser : list) {
            if (StringUtils.isBlank((String)rebPointsuser.getUpointsType())) {
                rebPointsuser.setUpointsType("0");
            }
            if (StringUtils.isBlank((String)rebPointsuser.getChannelCode())) {
                rebPointsuser.setChannelCode("all");
            }
            if (StringUtils.isNotBlank((String)rebPointsuser.getPointsDatetype()) && !rebPointsuser.getPointsDatetype().equals("3")) {
                rebPointsuser.setPointsDatatype("0");
            }
            if (!StringUtils.isNotBlank((String)rebPointsuser.getUpointsType())) continue;
            String key = rebPointsuser.getPointsDatatype() + "-" + rebPointsuser.getUpointsType() + "-" + rebPointsuser.getMemberCode() + "-" + rebPointsuser.getChannelCode() + "-" + rebPointsuser.getTenantCode();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)rebPointsuser));
        }
        DisUtil.setMapVer((String)cachekey, map);
        this.logger.info("reb.RebPointsuserServiceImpl.queryPointsuserCache.end", (Object)"===========del-end==========");
    }
}

