/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.RebConstants;
import com.yqbsoft.laser.service.reb.dao.RebPointsConfMapper;
import com.yqbsoft.laser.service.reb.dao.RebPointsGoodsMapper;
import com.yqbsoft.laser.service.reb.dao.RebPointsMapper;
import com.yqbsoft.laser.service.reb.dao.RebPointsRuleMapper;
import com.yqbsoft.laser.service.reb.dao.RebPointsUsersMapper;
import com.yqbsoft.laser.service.reb.domain.MaiHeRebPoints;
import com.yqbsoft.laser.service.reb.domain.OcContractDomain;
import com.yqbsoft.laser.service.reb.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.reb.domain.OcContractReDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsConfDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsConfReDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsGoodsDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsReDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsRuleDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsRuleReDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsUsersDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsClearDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsCleargoodsDomain;
import com.yqbsoft.laser.service.reb.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.reb.model.RebPoints;
import com.yqbsoft.laser.service.reb.model.RebPointsConf;
import com.yqbsoft.laser.service.reb.model.RebPointsGoods;
import com.yqbsoft.laser.service.reb.model.RebPointsRule;
import com.yqbsoft.laser.service.reb.model.RebPointsUsers;
import com.yqbsoft.laser.service.reb.service.RebPointsService;
import com.yqbsoft.laser.service.reb.service.RebUpointsClearService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class RebPointsServiceImpl
extends BaseServiceImpl
implements RebPointsService {
    private static final String SYS_CODE = "reb.RebPointsServiceImpl";
    private RebPointsMapper rebPointsMapper;
    private RebPointsConfMapper rebPointsConfMapper;
    private RebPointsRuleMapper rebPointsRuleMapper;
    private RebPointsGoodsMapper rebPointsGoodsMapper;
    private RebPointsUsersMapper rebPointsUsersMapper;
    private RebUpointsClearService rebUpointsClearService;
    private String cachekey = "RebPoints-type";
    private String cachekeyRule = "REBPointsRule-api";
    private static String ui_page = "page";
    private static String ui_rows = "rows";
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";

    public RebUpointsClearService getRebUpointsClearService() {
        return this.rebUpointsClearService;
    }

    public void setRebUpointsClearService(RebUpointsClearService rebUpointsClearService) {
        this.rebUpointsClearService = rebUpointsClearService;
    }

    public void setRebPointsGoodsMapper(RebPointsGoodsMapper rebPointsGoodsMapper) {
        this.rebPointsGoodsMapper = rebPointsGoodsMapper;
    }

    public void setRebPointsUsersMapper(RebPointsUsersMapper rebPointsUsersMapper) {
        this.rebPointsUsersMapper = rebPointsUsersMapper;
    }

    public void setRebPointsMapper(RebPointsMapper rebPointsMapper) {
        this.rebPointsMapper = rebPointsMapper;
    }

    public void setRebPointsConfMapper(RebPointsConfMapper rebPointsConfMapper) {
        this.rebPointsConfMapper = rebPointsConfMapper;
    }

    public void setRebPointsRuleMapper(RebPointsRuleMapper rebPointsRuleMapper) {
        this.rebPointsRuleMapper = rebPointsRuleMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebPointsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPoints(RebPointsDomain rebPointsDomain) {
        if (null == rebPointsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsDefault(RebPoints rebPoints) {
        if (null == rebPoints) {
            return;
        }
        if (null == rebPoints.getDataState()) {
            rebPoints.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPoints.getGmtCreate()) {
            rebPoints.setGmtCreate(date);
        }
        rebPoints.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPoints.getPointsCode())) {
            rebPoints.setPointsCode(this.getNo(null, "RebPoints", "rebPoints", rebPoints.getTenantCode()));
        }
    }

    private int getPointsMaxCode() {
        int code = 0;
        try {
            return this.rebPointsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsUpdataDefault(RebPoints rebPoints) {
        if (null == rebPoints) {
            return;
        }
        rebPoints.setGmtModified(this.getSysDate());
    }

    private void savePointsModel(RebPoints rebPoints) throws ApiException {
        if (null == rebPoints) {
            return;
        }
        try {
            this.rebPointsMapper.insert(rebPoints);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsModel.ex", (Throwable)e);
        }
    }

    private void savePointsBatchModel(List<RebPoints> rebPointsList) throws ApiException {
        if (null == rebPointsList || rebPointsList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsMapper.insertBatch(rebPointsList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsBatchModel.ex", (Throwable)e);
        }
    }

    private RebPoints getPointsModelById(Integer pointsId) {
        if (null == pointsId) {
            return null;
        }
        try {
            return this.rebPointsMapper.selectByPrimaryKey(pointsId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsModelById", (Throwable)e);
            return null;
        }
    }

    private RebPoints getPointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsModelByCode.num");
        }
    }

    private void deletePointsModel(Integer pointsId) throws ApiException {
        if (null == pointsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.deleteByPrimaryKey(pointsId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsModel.num");
        }
    }

    private void updatePointsModel(RebPoints rebPoints) throws ApiException {
        if (null == rebPoints) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.updateByPrimaryKeySelective(rebPoints);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsModel.num");
        }
    }

    private void updateStatePointsModel(Integer pointsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsId", pointsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsModel.null");
        }
    }

    private void updateStatePointsModelByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsModelByCode.null");
        }
    }

    private RebPoints makePoints(RebPointsDomain rebPointsDomain, RebPoints rebPoints) {
        if (null == rebPointsDomain) {
            return null;
        }
        if (null == rebPoints) {
            rebPoints = new RebPoints();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPoints, (Object)rebPointsDomain);
            return rebPoints;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makePoints", (Throwable)e);
            return null;
        }
    }

    private RebPointsReDomain makeRebPointsReDomain(RebPoints rebPoints) {
        if (null == rebPoints) {
            return null;
        }
        RebPointsReDomain rebPointsReDomain = new RebPointsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsReDomain, (Object)rebPoints);
            return rebPointsReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makeRebPointsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPoints> queryPointsModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.queryPointsModel", (Throwable)e);
            return null;
        }
    }

    private int countPoints(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.countPoints", (Throwable)e);
        }
        return i;
    }

    private RebPoints createRebPoints(RebPointsDomain rebPointsDomain) {
        String msg = this.checkPoints(rebPointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.savePoints.checkPoints", msg);
        }
        RebPoints rebPoints = this.makePoints(rebPointsDomain, null);
        this.setPointsDefault(rebPoints);
        return rebPoints;
    }

    private String checkPointsConf(RebPointsConfDomain rebPointsConfDomain) {
        if (null == rebPointsConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsConfDefault(RebPointsConf rebPointsConf) {
        if (null == rebPointsConf) {
            return;
        }
        if (null == rebPointsConf.getDataState()) {
            rebPointsConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPointsConf.getGmtCreate()) {
            rebPointsConf.setGmtCreate(date);
        }
        rebPointsConf.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPointsConf.getPointsCode())) {
            rebPointsConf.setPointsCode(this.getNo(null, "RebPointsConf", "rebPointsConf", rebPointsConf.getTenantCode()));
        }
    }

    private int getPointsConfMaxCode() {
        int code = 0;
        try {
            return this.rebPointsConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsConfUpdataDefault(RebPointsConf rebPointsConf) {
        if (null == rebPointsConf) {
            return;
        }
        rebPointsConf.setGmtModified(this.getSysDate());
    }

    private void savePointsConfModel(RebPointsConf rebPointsConf) throws ApiException {
        if (null == rebPointsConf) {
            return;
        }
        try {
            this.rebPointsConfMapper.insert(rebPointsConf);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsConfModel.ex", (Throwable)e);
        }
    }

    private void savePointsConfBatchModel(List<RebPointsConf> rebPointsConfList) throws ApiException {
        if (null == rebPointsConfList || rebPointsConfList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsConfMapper.insertBatch(rebPointsConfList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsConfBatchModel.ex", (Throwable)e);
        }
    }

    private RebPointsConf getPointsConfModelById(Integer pointsConfId) {
        if (null == pointsConfId) {
            return null;
        }
        try {
            return this.rebPointsConfMapper.selectByPrimaryKey(pointsConfId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsConfModelById", (Throwable)e);
            return null;
        }
    }

    private RebPointsConf getPointsConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsConfModelByCode.num");
        }
    }

    private void deletePointsConfModel(Integer pointsConfId) throws ApiException {
        if (null == pointsConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.deleteByPrimaryKey(pointsConfId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsConfModel.num");
        }
    }

    private void updatePointsConfModel(RebPointsConf rebPointsConf) throws ApiException {
        if (null == rebPointsConf) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.updateByPrimaryKeySelective(rebPointsConf);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsConfModel.num");
        }
    }

    private void updateStatePointsConfModel(Integer pointsConfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsConfId", pointsConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsConfModel.null");
        }
    }

    private void updateStatePointsConfModelByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsConfModelByCode.null");
        }
    }

    private RebPointsConf makePointsConf(RebPointsConfDomain rebPointsConfDomain, RebPointsConf rebPointsConf) {
        if (null == rebPointsConfDomain) {
            return null;
        }
        if (null == rebPointsConf) {
            rebPointsConf = new RebPointsConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsConf, (Object)rebPointsConfDomain);
            return rebPointsConf;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makePointsConf", (Throwable)e);
            return null;
        }
    }

    private RebPointsConfReDomain makeRebPointsConfReDomain(RebPointsConf rebPointsConf) {
        if (null == rebPointsConf) {
            return null;
        }
        RebPointsConfReDomain rebPointsConfReDomain = new RebPointsConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsConfReDomain, (Object)rebPointsConf);
            return rebPointsConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makeRebPointsConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPointsConf> queryPointsConfModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.queryPointsConfModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.countPointsConf", (Throwable)e);
        }
        return i;
    }

    private RebPointsConf createRebPointsConf(RebPointsConfDomain rebPointsConfDomain) {
        String msg = this.checkPointsConf(rebPointsConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsConf.checkPointsConf", msg);
        }
        RebPointsConf rebPointsConf = this.makePointsConf(rebPointsConfDomain, null);
        this.setPointsConfDefault(rebPointsConf);
        return rebPointsConf;
    }

    private String checkPointsRule(RebPointsRuleDomain rebPointsRuleDomain) {
        if (null == rebPointsRuleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsRuleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsRuleDefault(RebPointsRule rebPointsRule) {
        if (null == rebPointsRule) {
            return;
        }
        if (null == rebPointsRule.getDataState()) {
            rebPointsRule.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPointsRule.getGmtCreate()) {
            rebPointsRule.setGmtCreate(date);
        }
        rebPointsRule.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPointsRule.getPointsRuleCode())) {
            rebPointsRule.setPointsRuleCode(this.getNo(null, "RebPointsRule", "rebPointsRule", rebPointsRule.getTenantCode()));
        }
    }

    private int getPointsRuleMaxCode() {
        int code = 0;
        try {
            return this.rebPointsRuleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsRuleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsRuleUpdataDefault(RebPointsRule rebPointsRule) {
        if (null == rebPointsRule) {
            return;
        }
        rebPointsRule.setGmtModified(this.getSysDate());
    }

    private void savePointsRuleModel(RebPointsRule rebPointsRule) throws ApiException {
        if (null == rebPointsRule) {
            return;
        }
        try {
            this.rebPointsRuleMapper.insert(rebPointsRule);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsRuleModel.ex", (Throwable)e);
        }
    }

    private void savePointsRuleBatchModel(List<RebPointsRule> rebPointsRuleList) throws ApiException {
        if (null == rebPointsRuleList || rebPointsRuleList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsRuleMapper.insertBatch(rebPointsRuleList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsRuleBatchModel.ex", (Throwable)e);
        }
    }

    private RebPointsRule getPointsRuleModelById(Integer pointsRuleId) {
        if (null == pointsRuleId) {
            return null;
        }
        try {
            return this.rebPointsRuleMapper.selectByPrimaryKey(pointsRuleId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsRuleModelById", (Throwable)e);
            return null;
        }
    }

    private RebPointsRule getPointsRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsRuleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.getPointsRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsRuleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.delPointsRuleModelByCode.num");
        }
    }

    private void deletePointsRuleModel(Integer pointsRuleId) throws ApiException {
        if (null == pointsRuleId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.deleteByPrimaryKey(pointsRuleId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.deletePointsRuleModel.num");
        }
    }

    private void updatePointsRuleModel(RebPointsRule rebPointsRule) throws ApiException {
        if (null == rebPointsRule) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.updateByPrimaryKeyWithBLOBs(rebPointsRule);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsRuleModel.num");
        }
    }

    private void updateStatePointsRuleModel(Integer pointsRuleId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsRuleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsRuleId", pointsRuleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsRuleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsRuleModel.null");
        }
    }

    private void updateStatePointsRuleModelByCode(String tenantCode, String pointsRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleCode", pointsRuleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsRuleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsServiceImpl.updateStatePointsRuleModelByCode.null");
        }
    }

    private RebPointsRule makePointsRule(RebPointsRuleDomain rebPointsRuleDomain, RebPointsRule rebPointsRule) {
        if (null == rebPointsRuleDomain) {
            return null;
        }
        if (null == rebPointsRule) {
            rebPointsRule = new RebPointsRule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsRule, (Object)rebPointsRuleDomain);
            return rebPointsRule;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makePointsRule", (Throwable)e);
            return null;
        }
    }

    private RebPointsRuleReDomain makeRebPointsRuleReDomain(RebPointsRule rebPointsRule) {
        if (null == rebPointsRule) {
            return null;
        }
        RebPointsRuleReDomain rebPointsRuleReDomain = new RebPointsRuleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsRuleReDomain, (Object)rebPointsRule);
            return rebPointsRuleReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.makeRebPointsRuleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPointsRule> queryPointsRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.queryPointsRuleModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsRule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsServiceImpl.countPointsRule", (Throwable)e);
        }
        return i;
    }

    private RebPointsRule createRebPointsRule(RebPointsRuleDomain rebPointsRuleDomain) {
        String msg = this.checkPointsRule(rebPointsRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.savePointsRule.checkPointsRule", msg);
        }
        RebPointsRule rebPointsRule = this.makePointsRule(rebPointsRuleDomain, null);
        this.setPointsRuleDefault(rebPointsRule);
        return rebPointsRule;
    }

    @Override
    public String savePoints(RebPointsDomain rebPointsDomain) throws ApiException {
        RebPoints rebPoints = this.createRebPoints(rebPointsDomain);
        this.savePointsModel(rebPoints);
        return rebPoints.getPointsCode();
    }

    @Override
    public String savePointsBatch(List<RebPointsDomain> rebPointsDomainList) throws ApiException {
        if (null == rebPointsDomainList || rebPointsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPoints> rebPointsList = new ArrayList<RebPoints>();
        String code = "";
        for (RebPointsDomain rebPointsDomain : rebPointsDomainList) {
            RebPoints rebPoints = this.createRebPoints(rebPointsDomain);
            code = rebPoints.getPointsCode();
            rebPointsList.add(rebPoints);
        }
        this.savePointsBatchModel(rebPointsList);
        return code;
    }

    @Override
    public void updatePointsState(Integer pointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsId) {
            return;
        }
        this.updateStatePointsModel(pointsId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsStateByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsModelByCode(tenantCode, pointsCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePoints(RebPointsDomain rebPointsDomain) throws ApiException {
        String msg = this.checkPoints(rebPointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePoints.checkPoints", msg);
        }
        RebPoints oldRebPoints = this.getPointsModelById(rebPointsDomain.getPointsId());
        if (null == oldRebPoints) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePoints.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPoints rebPoints = this.makePoints(rebPointsDomain, oldRebPoints);
        this.setPointsUpdataDefault(rebPoints);
        this.updatePointsModel(rebPoints);
    }

    @Override
    public RebPoints getPoints(Integer pointsId) {
        if (null == pointsId) {
            return null;
        }
        return this.getPointsModelById(pointsId);
    }

    @Override
    public void deletePoints(Integer pointsId) throws ApiException {
        if (null == pointsId) {
            return;
        }
        this.deletePointsModel(pointsId);
    }

    @Override
    public QueryResult<RebPoints> queryPointsPage(Map<String, Object> map) {
        List<RebPoints> rebPointsList = this.queryPointsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsList);
        return queryResult;
    }

    @Override
    public RebPoints getPointsByCode(String tenantCode, String pointsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        return this.getPointsModelByCode(map);
    }

    @Override
    public void deletePointsByCode(String tenantCode, String pointsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        this.delPointsModelByCode(map);
    }

    @Override
    public String savePointsConf(RebPointsConfDomain rebPointsConfDomain) throws ApiException {
        RebPointsConf rebPointsConf = this.createRebPointsConf(rebPointsConfDomain);
        this.savePointsConfModel(rebPointsConf);
        return rebPointsConf.getPointsCode();
    }

    @Override
    public String savePointsConfBatch(List<RebPointsConfDomain> rebPointsConfDomainList) throws ApiException {
        if (null == rebPointsConfDomainList || rebPointsConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPointsConf> rebPointsConfList = new ArrayList<RebPointsConf>();
        String code = "";
        for (RebPointsConfDomain rebPointsConfDomain : rebPointsConfDomainList) {
            RebPointsConf rebPointsConf = this.createRebPointsConf(rebPointsConfDomain);
            code = rebPointsConf.getPointsCode();
            rebPointsConfList.add(rebPointsConf);
        }
        this.savePointsConfBatchModel(rebPointsConfList);
        return code;
    }

    @Override
    public void updatePointsConfState(Integer pointsConfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsConfId) {
            return;
        }
        this.updateStatePointsConfModel(pointsConfId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsConfStateByCode(String tenantCode, String pointsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsConfModelByCode(tenantCode, pointsCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsConf(RebPointsConfDomain rebPointsConfDomain) throws ApiException {
        String msg = this.checkPointsConf(rebPointsConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsConf.checkPointsConf", msg);
        }
        RebPointsConf oldRebPointsConf = this.getPointsConfModelById(rebPointsConfDomain.getPointsConfId());
        if (null == oldRebPointsConf) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPointsConf rebPointsConf = this.makePointsConf(rebPointsConfDomain, oldRebPointsConf);
        this.setPointsConfUpdataDefault(rebPointsConf);
        this.updatePointsConfModel(rebPointsConf);
    }

    @Override
    public RebPointsConf getPointsConf(Integer pointsConfId) {
        if (null == pointsConfId) {
            return null;
        }
        return this.getPointsConfModelById(pointsConfId);
    }

    @Override
    public void deletePointsConf(Integer pointsConfId) throws ApiException {
        if (null == pointsConfId) {
            return;
        }
        this.deletePointsConfModel(pointsConfId);
    }

    @Override
    public QueryResult<RebPointsConf> queryPointsConfPage(Map<String, Object> map) {
        List<RebPointsConf> rebPointsConfList = this.queryPointsConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsConfList);
        return queryResult;
    }

    @Override
    public RebPointsConf getPointsConfByCode(String tenantCode, String pointsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        return this.getPointsConfModelByCode(map);
    }

    @Override
    public void deletePointsConfByCode(String tenantCode, String pointsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsCode", pointsCode);
        this.delPointsConfModelByCode(map);
    }

    @Override
    public String savePointsRule(RebPointsRuleDomain rebPointsRuleDomain) throws ApiException {
        RebPointsRule rebPointsRule = this.createRebPointsRule(rebPointsRuleDomain);
        this.savePointsRuleModel(rebPointsRule);
        return rebPointsRule.getPointsRuleCode();
    }

    @Override
    public String savePointsRuleBatch(List<RebPointsRuleDomain> rebPointsRuleDomainList) throws ApiException {
        if (null == rebPointsRuleDomainList || rebPointsRuleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPointsRule> rebPointsRuleList = new ArrayList<RebPointsRule>();
        String code = "";
        for (RebPointsRuleDomain rebPointsRuleDomain : rebPointsRuleDomainList) {
            RebPointsRule rebPointsRule = this.createRebPointsRule(rebPointsRuleDomain);
            code = rebPointsRule.getPointsRuleCode();
            rebPointsRuleList.add(rebPointsRule);
        }
        this.savePointsRuleBatchModel(rebPointsRuleList);
        return code;
    }

    @Override
    public void updatePointsRuleState(Integer pointsRuleId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsRuleId) {
            return;
        }
        this.updateStatePointsRuleModel(pointsRuleId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsRuleStateByCode(String tenantCode, String pointsRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsRuleModelByCode(tenantCode, pointsRuleCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsRule(RebPointsRuleDomain rebPointsRuleDomain) throws ApiException {
        String msg = this.checkPointsRule(rebPointsRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsRule.checkPointsRule", msg);
        }
        RebPointsRule oldRebPointsRule = this.getPointsRuleModelById(rebPointsRuleDomain.getPointsRuleId());
        if (null == oldRebPointsRule) {
            throw new ApiException("reb.RebPointsServiceImpl.updatePointsRule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPointsRule rebPointsRule = this.makePointsRule(rebPointsRuleDomain, oldRebPointsRule);
        this.setPointsRuleUpdataDefault(rebPointsRule);
        this.updatePointsRuleModel(rebPointsRule);
    }

    @Override
    public RebPointsRule getPointsRule(Integer pointsRuleId) {
        if (null == pointsRuleId) {
            return null;
        }
        return this.getPointsRuleModelById(pointsRuleId);
    }

    @Override
    public void deletePointsRule(Integer pointsRuleId) throws ApiException {
        if (null == pointsRuleId) {
            return;
        }
        this.deletePointsRuleModel(pointsRuleId);
    }

    @Override
    public QueryResult<RebPointsRule> queryPointsRulePage(Map<String, Object> map) {
        List<RebPointsRule> rebPointsRuleList = this.queryPointsRuleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsRule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsRuleList);
        return queryResult;
    }

    @Override
    public RebPointsRule getPointsRuleByCode(String tenantCode, String pointsRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleCode", pointsRuleCode);
        return this.getPointsRuleModelByCode(map);
    }

    @Override
    public void deletePointsRuleByCode(String tenantCode, String pointsRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleCode", pointsRuleCode);
        this.delPointsRuleModelByCode(map);
    }

    @Override
    public void queryPointsCache() {
        this.logger.info("RebPointsServiceImpl.queryPointsCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<RebPoints> list = this.queryPointsModelPage(parammap);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("RebPointsServiceImpl.queryPointsCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (RebPoints rebPoints : list) {
            if (!StringUtils.isNotBlank((String)rebPoints.getUpointsType())) continue;
            String key = rebPoints.getUpointsType() + "-" + rebPoints.getTenantCode();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)rebPoints));
        }
        DisUtil.setMapVer((String)this.cachekey, map);
        this.logger.info("RebPointsServiceImpl.queryPointsCache", (Object)"===========add-end==========");
    }

    @Override
    public void queryPointsRuleCache() {
        this.logger.info("RebPointsRuleServiceImpl.queryPointsRuleCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", "1");
        List<RebPointsRule> list = this.queryPointsRuleModelPage(parammap);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekeyRule);
            this.logger.info("RebPointsRuleServiceImpl.queryPointsRuleCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (RebPointsRule rebPointsRule : list) {
            if (!StringUtils.isNotBlank((String)rebPointsRule.getUpointsType())) continue;
            String key = rebPointsRule.getUpointsType() + "-" + rebPointsRule.getPointsRuleApi() + "-" + rebPointsRule.getTenantCode();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)rebPointsRule));
        }
        DisUtil.setMapVer((String)this.cachekeyRule, map);
        this.logger.info("RebPointsRuleServiceImpl.queryPointsRuleCache", (Object)"===========add-end==========");
    }

    @Override
    public String updateLoadRebPointsStateJob(String tenantCode, String type) throws ApiException {
        if (StringUtils.isBlankLoop((String[])new String[]{tenantCode, type})) {
            this.logger.error("reb.RebPointsServiceImpl.loadRebPointsStateJob.param", (Object)"params is null");
            return "params";
        }
        String dataStateStr = RebConstants.UPOINT_STATE_1 + "," + RebConstants.UPOINT_STATE_4 + "," + RebConstants.UPOINT_STATE_5;
        Map queryParamMap = this.getQueryParamMap("tenantCode,fundType,dataStateStr", new Object[]{tenantCode, type, dataStateStr});
        this.logger.debug("updateLoadRebPointsStateJob.queryPointsPage.queryParamMap", (Object)queryParamMap);
        QueryResult<RebPoints> rebPointsQueryResult = this.queryPointsPage(queryParamMap);
        this.logger.debug("updateLoadRebPointsStateJob.queryPointsPage.rebPointsQueryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)rebPointsQueryResult.getList()));
        if (null != rebPointsQueryResult && ListUtil.isNotEmpty((Collection)rebPointsQueryResult.getList())) {
            this.checkUpointTimeLine(rebPointsQueryResult.getList());
            this.queryPointsCache();
        }
        return "success";
    }

    private void checkUpointTimeLine(List<RebPoints> rebPointsList) {
        if (ListUtil.isEmpty(rebPointsList)) {
            return;
        }
        Map<String, List<RebPoints>> collect = rebPointsList.stream().collect(Collectors.groupingBy(rp -> String.valueOf(rp.getDataState())));
        Date date = new Date();
        int year = DateUtil.getYear((Date)date);
        int day = DateUtil.getDay((Date)date);
        for (String k : collect.keySet()) {
            this.logger.debug("rebPointsList.UPOINT_STATE_4.keySet", (Object)k);
            List<RebPoints> v = collect.get(k);
            Integer currentState = Integer.valueOf(k);
            if (k.equals(String.valueOf(RebConstants.UPOINT_STATE_1)) || k.equals(String.valueOf(RebConstants.UPOINT_STATE_5))) {
                List endList = v.stream().filter(rp -> DateUtils.compareDate((Date)rp.getPointsEstartdate(), (Date)date) == 1).collect(Collectors.toList());
                for (RebPoints el : endList) {
                    if ("1".equals(el.getPointsDatetype())) {
                        if (day < el.getPointsDatenum()) {
                            this.checkUpdatePointsState(el.getPointsId(), RebConstants.UPOINT_STATE_3, currentState);
                            continue;
                        }
                        this.checkUpdatePointsState(el.getPointsId(), RebConstants.UPOINT_STATE_5, currentState);
                        continue;
                    }
                    if (!org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)el.getPointsDatetype(), (CharSequence[])new CharSequence[]{"2", "3"})) continue;
                    if ("1".equals(el.getPointsDatatype()) && DateUtils.compareDate((Date)this.getCurrentSeasonDate(el.getPointsEstartdate()), (Date)el.getPointsEstartdate()) == -1 || "2".equals(el.getPointsDatatype()) && DateUtils.compareDate((Date)el.getPointsEstartdate(), (Date)date) == -1 && DateUtils.getYear((Date)el.getPointsEstartdate()) + 1 > year) {
                        this.checkUpdatePointsState(el.getPointsId(), RebConstants.UPOINT_STATE_3, currentState);
                        continue;
                    }
                    this.checkUpdatePointsState(el.getPointsId(), RebConstants.UPOINT_STATE_5, currentState);
                }
                continue;
            }
            if (!k.equals(String.valueOf(RebConstants.UPOINT_STATE_4))) continue;
            this.logger.debug("rebPointsList.UPOINT_STATE_4.req", (Object)JsonUtil.buildNormalBinder().toJson(v));
            List startList = v.stream().filter(rp -> DateUtils.compareDate((Date)rp.getPointsStartdate(), (Date)date) == 1).collect(Collectors.toList());
            this.logger.debug("rebPointsList.UPOINT_STATE_4.res", (Object)JsonUtil.buildNormalBinder().toJson(startList));
            for (RebPoints sl : startList) {
                this.checkUpdatePointsState(sl.getPointsId(), RebConstants.UPOINT_STATE_1, currentState);
            }
        }
    }

    public void checkUpdatePointsState(Integer pointsId, Integer dataState, Integer oldDataState) {
        if (null != pointsId && dataState != oldDataState && oldDataState != 3) {
            this.updatePointsState(pointsId, dataState, oldDataState, null);
        }
    }

    private Date getCurrentSeasonDate(Date inputDate) {
        LocalDate date = inputDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        YearMonth yearMonth = YearMonth.from(date);
        int month = (yearMonth.getMonthValue() / 3 + 1) * 3;
        if (month > 12) {
            month = 12;
        }
        LocalDate lastMonthOfQuarter = yearMonth.withMonth(month).atEndOfMonth().withDayOfMonth(date.getDayOfMonth());
        return Date.from(lastMonthOfQuarter.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    @Override
    public String insertLoadRebPointsJob(String tenantCode, String type) throws ApiException {
        if (StringUtils.isBlankLoop((String[])new String[]{tenantCode, type})) {
            this.logger.error("reb.RebPointsServiceImpl.loadUpointsJob.param", (Object)"params is null");
            return "params";
        }
        Date date = new Date();
        int day = DateUtils.getDay((Date)date);
        String dataStateStr = RebConstants.UPOINT_STATE_1 + "," + RebConstants.UPOINT_STATE_5;
        Map paramsMap = this.getQueryParamMap("tenantCode,dataStateStr,fundType,pointsDatenum", new Object[]{tenantCode, dataStateStr, type, day});
        this.logger.info("reb.RebPointsServiceImpl.loadUpointsJob.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)paramsMap));
        QueryResult<RebPoints> rebPointsQueryResult = this.queryPointsPage(paramsMap);
        if (null == rebPointsQueryResult || ListUtil.isEmpty((Collection)rebPointsQueryResult.getList())) {
            this.logger.error("reb.RebPointsServiceImpl.loadUpointsJob.query", (Object)JsonUtil.buildNormalBinder().toJson((Object)paramsMap));
            return "query";
        }
        this.logger.info("reb.RebPointsServiceImpl.loadUpointsJob.size", (Object)rebPointsQueryResult.getList().size());
        List<RebPointsDomain> rebPointsDomainList = this.assRebPointsDomainConvert(rebPointsQueryResult.getList());
        return this.insertCalculateRebPointsData(rebPointsDomainList);
    }

    private boolean checkPointsCondit(RebPointsDomain rebPointsDomain) {
        if (null == rebPointsDomain || !org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)rebPointsDomain.getPointsDatetype(), (CharSequence[])new CharSequence[]{"1", "2", "3"})) {
            return false;
        }
        Integer guideDayOfMonth = rebPointsDomain.getPointsDatenum();
        int currentDayOfMonth = DateUtil.getDay((Date)new Date());
        return currentDayOfMonth == guideDayOfMonth;
    }

    @Override
    public String insertCalculateRebPointsData(List<RebPointsDomain> rebPointsDomainList) throws ApiException {
        if (ListUtil.isEmpty(rebPointsDomainList)) {
            this.logger.error("reb.RebPointsServiceImpl.CalculateRebPointsData.params", (Object)"params is null");
            return "CalculateRebPointsData.params";
        }
        ArrayList<RebUpointsClearDomain> resultList = new ArrayList<RebUpointsClearDomain>();
        List<RebPointsDomain> assRebDataList = this.assRebPointsDomain(rebPointsDomainList.stream().filter(rpd -> this.checkPointsCondit((RebPointsDomain)rpd)).collect(Collectors.toList()));
        Map<String, List<RebPointsDomain>> rebPonitCollectMap = assRebDataList.stream().collect(Collectors.groupingBy(rpd -> rpd.getPointsDatetype()));
        rebPonitCollectMap.forEach((k, v) -> {
            List<RebUpointsClearDomain> rebUpointsClearDomainList = this.handleCalculateRebPoints((String)k, (List<RebPointsDomain>)v);
            if (ListUtil.isNotEmpty(rebUpointsClearDomainList)) {
                resultList.addAll(rebUpointsClearDomainList);
            }
        });
        if (ListUtil.isEmpty(resultList)) {
            throw new ApiException("CalculateRebPointsData.resultList");
        }
        return this.rebUpointsClearService.saveUpointsClearBatchNew(resultList);
    }

    private List<RebUpointsClearDomain> handleCalculateRebPoints(String type, List<RebPointsDomain> rebPointsDomainList) {
        List<RebUpointsClearDomain> upointsClearDomainList = this.CalculateRebPoints(rebPointsDomainList, type);
        return this.assRebUpointsUser(upointsClearDomainList);
    }

    private List<RebUpointsClearDomain> CalculateRebPoints(List<RebPointsDomain> rebPointsDomainList, String type) {
        ArrayList<RebUpointsClearDomain> rebUpointsClearDomainList = new ArrayList<RebUpointsClearDomain>();
        for (RebPointsDomain rebPointsDomain : rebPointsDomainList) {
            String tenantCode = rebPointsDomain.getTenantCode();
            String pointsPtype = rebPointsDomain.getPointsPtype();
            String pointsDatatype = "";
            Integer calculateDay = rebPointsDomain.getPointsDatenum();
            if ("3".equals(type)) {
                pointsDatatype = rebPointsDomain.getPointsDatatype();
            }
            Date contractStartdate = this.getCalculateDate(rebPointsDomain.getPointsStartdate(), calculateDay, "start", pointsDatatype);
            Date contractEnddate = this.getCalculateDate(rebPointsDomain.getPointsEstartdate(), calculateDay, "end", pointsDatatype);
            if (null == contractEnddate || null == contractEnddate) {
                this.logger.error("reb.RebPointsServiceImpl.CalculateRebPointsSingle", (Object)(contractStartdate + "==" + contractEnddate));
                continue;
            }
            String dateStartStr = DateUtils.getDateString((Date)contractStartdate, (String)"yyyy-MM-dd");
            String dateEndStr = DateUtils.getDateString((Date)contractEnddate, (String)"yyyy-MM-dd");
            String userinfoCodeStr = rebPointsDomain.getRebPointsUsersDomainList().stream().map(rpu -> rpu.getPointsUserOp()).collect(Collectors.joining(","));
            Map queryParamMap = this.getQueryParamMap("tenantCode,startTime,endTime,memberBcode", new Object[]{tenantCode, dateStartStr, dateEndStr, userinfoCodeStr});
            List<OcContractReDomain> ocContractReDomainList = this.queryContractPageToCalculate(queryParamMap);
            Map<Object, Object> userContractCollect = new HashMap();
            HashMap<Object, String> userNameInfoCollect = new HashMap<Object, String>();
            if ("1".equals(pointsPtype)) {
                String collectUserCode = ocContractReDomainList.stream().map(OcContractDomain::getMemberBcode).collect(Collectors.joining(","));
                userContractCollect.put(collectUserCode, ocContractReDomainList);
                userNameInfoCollect.put(collectUserCode, ocContractReDomainList.stream().map(OcContractDomain::getMemberBname).collect(Collectors.joining(",")));
            } else {
                userContractCollect = ocContractReDomainList.stream().collect(Collectors.groupingBy(oct -> oct.getMemberBcode()));
                for (String string : userContractCollect.keySet()) {
                    userNameInfoCollect.put(string, ((OcContractReDomain)((List)userContractCollect.get(string)).get(0)).getMemberBname());
                }
            }
            Map<String, List<RebPointsGoodsDomain>> rpgMap = rebPointsDomain.getRebPointsGoodsDomainList().stream().collect(Collectors.groupingBy(rpg -> rpg.getPointsGoodsOp()));
            userContractCollect.forEach((k, v) -> {
                RebUpointsClearDomain rebUpointsClearDomain = new RebUpointsClearDomain();
                String upointsClearCode = this.createMaxBillNumber(null, "DaOrderTotal", "daOrderTotal", tenantCode);
                upointsClearCode = "FLJS" + DateUtils.getDateString((Date)new Date(), (String)"yyyyMMdd") + upointsClearCode.substring(upointsClearCode.length() - 4);
                rebUpointsClearDomain.setUpointsClearCode(upointsClearCode);
                ArrayList<RebUpointsCleargoodsDomain> rebUpointsCleargoodsResultList = new ArrayList<RebUpointsCleargoodsDomain>();
                rebUpointsClearDomain.setMemberCcode((String)k);
                rebUpointsClearDomain.setMemberCname((String)userNameInfoCollect.get(k));
                rebUpointsClearDomain.setUpointsListExcode(rebPointsDomain.getPointsCode());
                rebUpointsClearDomain.setUpointsListExname(rebPointsDomain.getUpointsName());
                rebUpointsClearDomain.setUpointsClearOpcode(pointsPtype);
                rebUpointsClearDomain.setUpointsClearOpcode1(dateStartStr);
                rebUpointsClearDomain.setUpointsClearOpcode2(dateEndStr);
                rebUpointsClearDomain.setTenantCode(tenantCode);
                for (OcContractReDomain ocContractReDomain : v) {
                    Map<String, List<OcContractGoodsDomain>> ocGoodsCollect = "2".equals(type) || "3".equals(type) ? ocContractReDomain.getGoodsList().stream().filter(ocg -> rpgMap.containsKey(ocg)).collect(Collectors.groupingBy(ocg -> ocg.getClasstreeCode())) : ocContractReDomain.getGoodsList().stream().filter(ocg -> rpgMap.containsKey(ocg)).collect(Collectors.groupingBy(ocg -> ocg.getSkuNo()));
                    ocGoodsCollect.forEach((ocgK, ocgV) -> {
                        RebPointsGoodsDomain rebPointsGoodsDomain = (RebPointsGoodsDomain)((List)rpgMap.get(ocgK)).get(0);
                        OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocgV.get(0);
                        RebUpointsCleargoodsDomain rebUpointsCleargoodsDomain = new RebUpointsCleargoodsDomain();
                        rebUpointsCleargoodsDomain.setTenantCode(tenantCode);
                        rebUpointsCleargoodsDomain.setMemberBcode((String)k);
                        rebUpointsCleargoodsDomain.setMemberBname((String)userNameInfoCollect.get(k));
                        rebUpointsCleargoodsDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
                        Map<String, Object> skuInfo = this.getSkuInfo(ocContractGoodsDomain);
                        if (MapUtil.isNotEmpty(skuInfo)) {
                            rebUpointsCleargoodsDomain.setBrandCode(String.valueOf(skuInfo.get("brandCode")));
                            rebUpointsCleargoodsDomain.setBrandName(String.valueOf(skuInfo.get("brandName")));
                        }
                        rebUpointsCleargoodsDomain.setGoodsCode(ocContractGoodsDomain.getGoodsCode());
                        rebUpointsCleargoodsDomain.setGoodsNo(ocContractGoodsDomain.getGoodsNo());
                        rebUpointsCleargoodsDomain.setSkuCode(ocContractGoodsDomain.getSkuCode());
                        rebUpointsCleargoodsDomain.setSkuNo(ocContractGoodsDomain.getSkuNo());
                        rebUpointsCleargoodsDomain.setGoodsName(ocContractGoodsDomain.getGoodsName());
                        rebUpointsCleargoodsDomain.setSkuName(ocContractGoodsDomain.getSkuName());
                        rebUpointsCleargoodsDomain.setClasstreeCode(ocContractGoodsDomain.getClasstreeCode());
                        rebUpointsCleargoodsDomain.setClasstreeName(ocContractGoodsDomain.getClasstreeName());
                        rebUpointsCleargoodsDomain.setGoodsSpec(DateUtils.getDateString((Date)ocContractReDomain.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
                        rebUpointsCleargoodsDomain = this.CalculatGoodsAmount((List<OcContractGoodsDomain>)ocgV, rebPointsGoodsDomain, rebUpointsCleargoodsDomain, type, rebPointsDomain);
                        rebUpointsCleargoodsResultList.add(rebUpointsCleargoodsDomain);
                    });
                }
                rebUpointsClearDomain.setRebUpointsCleargoodsDomainList(rebUpointsCleargoodsResultList);
                rebUpointsClearDomainList.add(rebUpointsClearDomain);
            });
        }
        return rebUpointsClearDomainList;
    }

    public String createMaxBillNumber(String type, String tableName, String columnName, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        String apiCode = "nm.no.createMaxBillNumber";
        pmap.put("type", type);
        pmap.put("tableName", tableName);
        pmap.put("columnName", columnName);
        pmap.put("tenantCode", tenantCode);
        String s = this.internalInvoke(apiCode, pmap);
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToObject(s, Map.class);
        return map.get("dataObj").toString();
    }

    private RebUpointsCleargoodsDomain CalculatGoodsAmount(List<OcContractGoodsDomain> ocContractGoodsDomainList, final RebPointsGoodsDomain rebPointsGoodsDomain, RebUpointsCleargoodsDomain rebUpointsCleargoodsDomain, String type, RebPointsDomain rebPointsDomain) {
        BigDecimal pointGoodsRatio = rebPointsGoodsDomain.getPointsuserGoodsRatio().divide(new BigDecimal("100"), 2, 4);
        BigDecimal pointGoodsAmount = BigDecimal.ZERO;
        if (org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"1", "2"})) {
            BigDecimal goodsSumMoney = ocContractGoodsDomainList.stream().map(ocg -> Optional.ofNullable(ocg.getContractGoodsOprice()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
            pointGoodsAmount = goodsSumMoney.multiply(pointGoodsRatio).setScale(2, 4);
            rebUpointsCleargoodsDomain.setContractGoodsMoney(goodsSumMoney);
        } else if ("3".equals(type)) {
            Map<Object, Object> standardModelContractMap;
            String standardLine = rebPointsDomain.getPointsDatatype();
            if ("1".equals(standardLine)) {
                standardModelContractMap = ocContractGoodsDomainList.stream().collect(Collectors.groupingBy(ocg -> String.valueOf((DateUtil.getMonth((Date)ocg.getGmtCreate()) - 1) / 3 + 1)));
            } else {
                standardModelContractMap = new HashMap<String, List<OcContractGoodsDomain>>();
                standardModelContractMap.put("YEAR", ocContractGoodsDomainList);
            }
            HashMap<String, String> standardMap = new HashMap<String, String>(){
                {
                    this.put("Q1", rebPointsGoodsDomain.getPointsGoodsOp1());
                    this.put("Q2", rebPointsGoodsDomain.getPointsGoodsOp2());
                    this.put("Q3", rebPointsGoodsDomain.getPointsGoodsOp3());
                    this.put("Q4", rebPointsGoodsDomain.getPointsGoodsTerm());
                    this.put("YEAR", rebPointsGoodsDomain.getPointsGoodsOp1());
                }
            };
            Set<Object> standardSet = standardModelContractMap.keySet();
            for (String string : standardSet) {
                List v = (List)standardModelContractMap.get(string);
                BigDecimal standardMoney = new BigDecimal((String)standardMap.get("1".equals(standardLine) ? "Q".concat(string) : string));
                BigDecimal goodsMoney = v.stream().map(ocg -> Optional.ofNullable(ocg.getContractGoodsOprice()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.logger.info("reb.RebPointsServiceImpl.CalculatGoodsAmount", (Object)(string + "==" + standardMoney + "==" + goodsMoney + "==" + pointGoodsRatio));
                if (goodsMoney.compareTo(standardMoney) < 0) continue;
                pointGoodsAmount = pointGoodsAmount.add(goodsMoney.multiply(pointGoodsRatio).setScale(2, 4));
            }
        }
        rebUpointsCleargoodsDomain.setBalanceAmount(pointGoodsRatio);
        rebUpointsCleargoodsDomain.setBalanceAmount1(pointGoodsAmount);
        return rebUpointsCleargoodsDomain;
    }

    private Date getCalculateDate(Date date, Integer calculateDay, String type, String standardLineType) {
        if (null == date || null == calculateDay || StringUtils.isBlank((String)type)) {
            return null;
        }
        Date nowDate = new Date();
        if ("start".equals(date)) {
            if (date.getTime() > nowDate.getTime()) {
                this.logger.error("reb.RebPointsServiceImpl.getCalculateDate", (Object)"\u672a\u5230\u542f\u52a8\u65e5\u671f");
                return null;
            }
            if (StringUtils.isBlank((String)standardLineType)) {
                String beforeMonth = DateUtils.getAfterMonth((Date)nowDate, (int)-1, (String)"yyyy-MM-dd");
                return DateUtils.addDays((Date)DateUtils.getDateToString((String)beforeMonth, (String)"yyyy-MM-dd"), (int)1);
            }
            if ("1".equals(standardLineType) && org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)String.valueOf(DateUtils.getMonth((Date)nowDate)), (CharSequence[])new CharSequence[]{"4", "7", "10", "1"})) {
                Date lastQuarterDate = RebPointsServiceImpl.getLastQuarterDate();
                return DateUtil.getDateToString((String)DateUtil.getAfterDate((String)DateUtil.getAfterMonth((Date)lastQuarterDate, (int)-3, (String)"yyyy-MM-dd"), (int)1, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            }
            if ("2".equals(standardLineType) && DateUtils.getMonth((Date)nowDate) == 1) {
                return DateUtil.getDateToString((String)DateUtil.getAfterDate((String)DateUtil.getAfterMonth((Date)nowDate, (int)-12, (String)"yyyy-MM-dd"), (int)1, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            }
        } else if ("end".equals(type)) {
            long betweenDays = DateUtils.getBetweenDays((Date)date, (Date)nowDate);
            if (betweenDays <= 0L) {
                return date;
            }
            if (StringUtils.isBlank((String)standardLineType) || "1".equals(standardLineType) && org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)String.valueOf(DateUtils.getMonth((Date)nowDate)), (CharSequence[])new CharSequence[]{"4", "7", "10", "1"}) || "2".equals(standardLineType) && DateUtils.getMonth((Date)nowDate) == 1) {
                return nowDate;
            }
        }
        return null;
    }

    private static Date getLastQuarterDate() {
        LocalDate date = LocalDate.now();
        int year = date.getYear();
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        if (month <= 3) {
            --year;
            month += 9;
        } else {
            month -= 3;
        }
        LocalDate localDate = LocalDate.of(year, month, day);
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    private List<RebUpointsClearDomain> assRebUpointsUser(List<RebUpointsClearDomain> rebUpointsClearDomainList) {
        if (ListUtil.isEmpty(rebUpointsClearDomainList)) {
            return rebUpointsClearDomainList;
        }
        for (RebUpointsClearDomain rebUpointsClearDomain : rebUpointsClearDomainList) {
            Map queryParamMap;
            Map sendMap;
            QueryResult queryResutl;
            String brandCodeStr = "";
            if (ListUtil.isNotEmpty(rebUpointsClearDomain.getRebUpointsCleargoodsDomainList())) {
                BigDecimal reduceMoney = rebUpointsClearDomain.getRebUpointsCleargoodsDomainList().stream().map(RebUpointsCleargoodsDomain::getContractGoodsMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                brandCodeStr = rebUpointsClearDomain.getRebUpointsCleargoodsDomainList().stream().map(RebUpointsCleargoodsDomain::getBrandCode).collect(Collectors.joining(","));
                rebUpointsClearDomain.setUpointsClearNum(reduceMoney);
            }
            if (null == (queryResutl = this.getQueryResutl("um.userinfoQua.queryUserinfoQuaPage", sendMap = this.getQueryMapParam("map", new Object[]{queryParamMap = this.getQueryParamMap("userinfoCode,userinfoQuaKey,tenantCode", new Object[]{String.valueOf(rebUpointsClearDomain.getMemberCcode()), String.valueOf(brandCodeStr), rebUpointsClearDomain.getTenantCode()})}), UmUserinfoQuaDomain.class)) || !ListUtil.isNotEmpty((Collection)queryResutl.getList())) continue;
            String collectStr = queryResutl.getList().stream().map(UmUserinfoQuaDomain::getUserinfoQuaVaule).collect(Collectors.joining(","));
            rebUpointsClearDomain.setPointsUserqua(collectStr);
        }
        return rebUpointsClearDomainList;
    }

    private Map<String, Object> getSkuInfo(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return null;
        }
        String tenantCode = ocContractGoodsDomain.getTenantCode();
        String skuCode = ocContractGoodsDomain.getSkuCode();
        Map queryParamMap = this.getQueryParamMap("tenantCode,skuCode", new Object[]{tenantCode, skuCode});
        Map sendMap = this.getQueryMapParam("map", new Object[]{queryParamMap});
        Object skuStr = this.getInternalRouter().inInvoke("rs.sku.getSkuDomainByCode", sendMap);
        if (EmptyUtil.isEmpty((Object)skuStr)) {
            this.logger.error("reb.RebPointsServiceImpl.CalculateRebPointsSingle.getSkuInfo.skuStr", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryParamMap));
            return null;
        }
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(skuStr.toString(), String.class, Object.class);
    }

    private List<OcContractReDomain> queryContractPageToCalculate(Map<String, Object> queryParamMap) {
        QueryResult queryResutl;
        int page = 0;
        int rows = 150;
        queryParamMap.put("dataState", RebConstants.CONTRACT_COMPLETE_STATE);
        queryParamMap.put("childFlag", "1");
        queryParamMap.put("rows", String.valueOf(rows));
        ArrayList<OcContractReDomain> ocContractReDomainList = new ArrayList<OcContractReDomain>();
        do {
            queryParamMap.put("page", String.valueOf(++page));
            RebPointsServiceImpl.makePage(queryParamMap);
            Map sendMap = this.getQueryMapParam("map", new Object[]{queryParamMap});
            queryResutl = this.getQueryResutl("oc.contract.queryContractPageReDomain", sendMap, OcContractReDomain.class);
            if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) break;
            ocContractReDomainList.addAll(queryResutl.getList());
        } while (queryResutl.getList().size() >= rows);
        return ocContractReDomainList;
    }

    public static void makePage(Map<String, Object> map) {
        String page;
        if (null != map && !map.isEmpty() && null != (page = (String)map.get(ui_page))) {
            String rows;
            if (StringUtils.isBlank((String)page)) {
                page = "1";
            }
            if (StringUtils.isBlank((String)(rows = (String)map.get(ui_rows))) || "0".equals(rows)) {
                rows = "10";
            }
            map.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
            map.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            map.put(ui_rows, Long.valueOf(rows).intValue());
            map.put(ui_page, Long.valueOf(page).intValue());
        }
    }

    private boolean checkRebPointData(List<RebPointsDomain> rebPointsDomainList) {
        if (ListUtil.isEmpty(rebPointsDomainList)) {
            return true;
        }
        for (RebPointsDomain rebPointsDomain : rebPointsDomainList) {
            if (!ListUtil.isEmpty(rebPointsDomain.getRebPointsGoodsDomainList()) && !ListUtil.isEmpty(rebPointsDomain.getRebPointsUsersDomainList())) continue;
            return true;
        }
        return false;
    }

    private List<RebPointsDomain> assRebPointsDomainConvert(List<RebPoints> rebPointsList) {
        ArrayList<RebPointsDomain> rebPointsDomainList = new ArrayList<RebPointsDomain>();
        if (ListUtil.isEmpty(rebPointsList)) {
            this.logger.error("reb.RebPointsServiceImpl.loadUpointsJob.assRebPointsDomain.param", (Object)"params is null");
            return rebPointsDomainList;
        }
        for (RebPoints rebPoints : rebPointsList) {
            RebPointsDomain rebPointsDomainObj = new RebPointsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)rebPointsDomainObj, (Object)rebPoints);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            rebPointsDomainList.add(rebPointsDomainObj);
        }
        return rebPointsDomainList;
    }

    private List<RebPointsDomain> assRebPointsDomain(List<RebPointsDomain> rebPointsList) {
        if (ListUtil.isEmpty(rebPointsList)) {
            this.logger.error("reb.RebPointsServiceImpl.loadUpointsJob.assRebPointsDomain.param", (Object)"params is null");
            return rebPointsList;
        }
        for (RebPointsDomain rebPoints : rebPointsList) {
            String pointsCode = rebPoints.getPointsCode();
            Map queryParamMap = this.getQueryParamMap("pointsCode,tenantCode", new Object[]{pointsCode, rebPoints.getTenantCode()});
            if (ListUtil.isEmpty(rebPoints.getRebPointsGoodsDomainList())) {
                List<RebPointsGoods> queryRebGoodsList = this.rebPointsGoodsMapper.query(queryParamMap);
                if (ListUtil.isEmpty(queryRebGoodsList)) {
                    this.logger.error("reb.RebPointsServiceImpl.loadUpointsJob.assRebPointsDomain.queryRebGoodsList", (Object)pointsCode);
                    throw new ApiException("assRebPointsDomain.queryRebGoodsList:" + pointsCode);
                }
                String queryRebGoodsListJson = JsonUtil.buildNormalBinder().toJson(queryRebGoodsList);
                List rebPointsGoodsDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(queryRebGoodsListJson, RebPointsGoodsDomain.class);
                rebPoints.setRebPointsGoodsDomainList(rebPointsGoodsDomainList);
            }
            if (!ListUtil.isEmpty(rebPoints.getRebPointsUsersDomainList())) continue;
            List<RebPointsUsers> queryRebUsersList = this.rebPointsUsersMapper.query(queryParamMap);
            if (ListUtil.isEmpty(queryRebUsersList)) {
                this.logger.error("reb.RebPointsServiceImpl.loadUpointsJob.assRebPointsDomain.queryRebUsersList", (Object)pointsCode);
                throw new ApiException("assRebPointsDomain.queryRebUsersList:" + pointsCode);
            }
            String queryRebUsersListJson = JsonUtil.buildNormalBinder().toJson(queryRebUsersList);
            List rebPointsUsersDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(queryRebUsersListJson, RebPointsUsersDomain.class);
            rebPoints.setRebPointsUsersDomainList(rebPointsUsersDomainList);
        }
        return rebPointsList;
    }

    @Override
    public QueryResult<MaiHeRebPoints> queryPointsPageDetailes(Map<String, Object> map) {
        List<MaiHeRebPoints> rebPointsList = this.rebPointsMapper.queryMaiHeRebPoints(map);
        this.logger.info(".queryPointsPageDetailes.rebPointsList", (Object)JsonUtil.buildNormalBinder().toJson(rebPointsList));
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.rebPointsMapper.countMaiHeRebPoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsList);
        this.logger.info(".queryPointsPageDetailes.queryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryResult));
        return queryResult;
    }
}

