/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebMemjobMapper;
import com.yqbsoft.laser.service.reb.domain.RebMemjobDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobReDomain;
import com.yqbsoft.laser.service.reb.model.RebMemjob;
import com.yqbsoft.laser.service.reb.service.RebMemjobService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebMemjobServiceImpl
extends BaseServiceImpl
implements RebMemjobService {
    private static final String SYS_CODE = "reb.RebMemjobServiceImpl";
    private RebMemjobMapper rebMemjobMapper;

    public void setRebMemjobMapper(RebMemjobMapper rebMemjobMapper) {
        this.rebMemjobMapper = rebMemjobMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebMemjobMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMemjob(RebMemjobDomain rebMemjobDomain) {
        if (null == rebMemjobDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebMemjobDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMemjobDefault(RebMemjob rebMemjob) {
        if (null == rebMemjob) {
            return;
        }
        if (null == rebMemjob.getDataState()) {
            rebMemjob.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebMemjob.getGmtCreate()) {
            rebMemjob.setGmtCreate(date);
        }
        rebMemjob.setGmtModified(date);
        if (StringUtils.isBlank((String)rebMemjob.getMemjobCode())) {
            rebMemjob.setMemjobCode(this.getNo(null, "RebMemjob", "rebMemjob", rebMemjob.getTenantCode()));
        }
    }

    private int getMemjobMaxCode() {
        int code = 0;
        try {
            return this.rebMemjobMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getMemjobMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMemjobUpdataDefault(RebMemjob rebMemjob) {
        if (null == rebMemjob) {
            return;
        }
        rebMemjob.setGmtModified(this.getSysDate());
    }

    private void saveMemjobModel(RebMemjob rebMemjob) throws ApiException {
        if (null == rebMemjob) {
            return;
        }
        try {
            this.rebMemjobMapper.insert(rebMemjob);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.saveMemjobModel.ex", (Throwable)e);
        }
    }

    private void saveMemjobBatchModel(List<RebMemjob> rebMemjobList) throws ApiException {
        if (null == rebMemjobList || rebMemjobList.isEmpty()) {
            return;
        }
        try {
            this.rebMemjobMapper.insertBatch(rebMemjobList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.saveMemjobBatchModel.ex", (Throwable)e);
        }
    }

    private RebMemjob getMemjobModelById(Integer memjobId) {
        if (null == memjobId) {
            return null;
        }
        try {
            return this.rebMemjobMapper.selectByPrimaryKey(memjobId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getMemjobModelById", (Throwable)e);
            return null;
        }
    }

    private RebMemjob getMemjobModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebMemjobMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getMemjobModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMemjobModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.delMemjobModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobServiceImpl.delMemjobModelByCode.num");
        }
    }

    private void deleteMemjobModel(Integer memjobId) throws ApiException {
        if (null == memjobId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.deleteByPrimaryKey(memjobId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.deleteMemjobModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobServiceImpl.deleteMemjobModel.num");
        }
    }

    private void updateMemjobModel(RebMemjob rebMemjob) throws ApiException {
        if (null == rebMemjob) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.updateByPrimaryKey(rebMemjob);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjobModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjobModel.num");
        }
    }

    private void updateStateMemjobModel(Integer memjobId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == memjobId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memjobId", memjobId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModel.null");
        }
    }

    private void updateStateMemjobModelByCode(String tenantCode, String memjobCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobCode", memjobCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModelByCode.null");
        }
    }

    private RebMemjob makeMemjob(RebMemjobDomain rebMemjobDomain, RebMemjob rebMemjob) {
        if (null == rebMemjobDomain) {
            return null;
        }
        if (null == rebMemjob) {
            rebMemjob = new RebMemjob();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjob, (Object)rebMemjobDomain);
            return rebMemjob;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.makeMemjob", (Throwable)e);
            return null;
        }
    }

    private RebMemjobReDomain makeRebMemjobReDomain(RebMemjob rebMemjob) {
        if (null == rebMemjob) {
            return null;
        }
        RebMemjobReDomain rebMemjobReDomain = new RebMemjobReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjobReDomain, (Object)rebMemjob);
            return rebMemjobReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.makeRebMemjobReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebMemjob> queryMemjobModelPage(Map<String, Object> parammap) {
        try {
            return this.rebMemjobMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.queryMemjobModel", (Throwable)e);
            return null;
        }
    }

    private int countMemjob(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebMemjobMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.countMemjob", (Throwable)e);
        }
        return i;
    }

    private RebMemjob createRebMemjob(RebMemjobDomain rebMemjobDomain) {
        String msg = this.checkMemjob(rebMemjobDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebMemjobServiceImpl.saveMemjob.checkMemjob", msg);
        }
        RebMemjob rebMemjob = this.makeMemjob(rebMemjobDomain, null);
        this.setMemjobDefault(rebMemjob);
        return rebMemjob;
    }

    @Override
    public String saveMemjob(RebMemjobDomain rebMemjobDomain) throws ApiException {
        RebMemjob rebMemjob = this.createRebMemjob(rebMemjobDomain);
        this.saveMemjobModel(rebMemjob);
        return rebMemjob.getMemjobCode();
    }

    @Override
    public String saveMemjobBatch(List<RebMemjobDomain> rebMemjobDomainList) throws ApiException {
        if (null == rebMemjobDomainList || rebMemjobDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebMemjob> rebMemjobList = new ArrayList<RebMemjob>();
        String code = "";
        for (RebMemjobDomain rebMemjobDomain : rebMemjobDomainList) {
            RebMemjob rebMemjob = this.createRebMemjob(rebMemjobDomain);
            code = rebMemjob.getMemjobCode();
            rebMemjobList.add(rebMemjob);
        }
        this.saveMemjobBatchModel(rebMemjobList);
        return code;
    }

    @Override
    public void updateMemjobState(Integer memjobId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == memjobId) {
            return;
        }
        this.updateStateMemjobModel(memjobId, dataState, oldDataState, map);
    }

    @Override
    public void updateMemjobStateByCode(String tenantCode, String memjobCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMemjobModelByCode(tenantCode, memjobCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMemjob(RebMemjobDomain rebMemjobDomain) throws ApiException {
        String msg = this.checkMemjob(rebMemjobDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjob.checkMemjob", msg);
        }
        RebMemjob oldRebMemjob = this.getMemjobModelById(rebMemjobDomain.getMemjobId());
        if (null == oldRebMemjob) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjob.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebMemjob rebMemjob = this.makeMemjob(rebMemjobDomain, oldRebMemjob);
        this.setMemjobUpdataDefault(rebMemjob);
        this.updateMemjobModel(rebMemjob);
    }

    @Override
    public RebMemjob getMemjob(Integer memjobId) {
        if (null == memjobId) {
            return null;
        }
        return this.getMemjobModelById(memjobId);
    }

    @Override
    public void deleteMemjob(Integer memjobId) throws ApiException {
        if (null == memjobId) {
            return;
        }
        this.deleteMemjobModel(memjobId);
    }

    @Override
    public QueryResult<RebMemjob> queryMemjobPage(Map<String, Object> map) {
        List<RebMemjob> rebMemjobList = this.queryMemjobModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMemjob(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebMemjobList);
        return queryResult;
    }

    @Override
    public RebMemjob getMemjobByCode(String tenantCode, String memjobCode) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobCode", memjobCode);
        return this.getMemjobModelByCode(map);
    }

    @Override
    public void deleteMemjobByCode(String tenantCode, String memjobCode) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobCode", memjobCode);
        this.delMemjobModelByCode(map);
    }
}

