/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebMemjobMapper;
import com.yqbsoft.laser.service.reb.domain.RebChannelsendDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobListDomain;
import com.yqbsoft.laser.service.reb.domain.RebMemjobReDomain;
import com.yqbsoft.laser.service.reb.domain.RebUpointsClearDomain;
import com.yqbsoft.laser.service.reb.model.RebChannelsend;
import com.yqbsoft.laser.service.reb.model.RebMemjob;
import com.yqbsoft.laser.service.reb.model.RebMemjobList;
import com.yqbsoft.laser.service.reb.service.RebChannelsendService;
import com.yqbsoft.laser.service.reb.service.RebMemjobListService;
import com.yqbsoft.laser.service.reb.service.RebMemjobService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebMemjobServiceImpl
extends BaseServiceImpl
implements RebMemjobService {
    private static final String SYS_CODE = "reb.RebMemjobServiceImpl";
    private RebMemjobMapper rebMemjobMapper;
    private RebChannelsendService rebChannelsendService;
    private RebMemjobListService rebMemjobListService;

    public void setRebMemjobMapper(RebMemjobMapper rebMemjobMapper) {
        this.rebMemjobMapper = rebMemjobMapper;
    }

    public void setRebChannelsendService(RebChannelsendService rebChannelsendService) {
        this.rebChannelsendService = rebChannelsendService;
    }

    public RebMemjobListService getRebMemjobListService() {
        return this.rebMemjobListService;
    }

    public void setRebMemjobListService(RebMemjobListService rebMemjobListService) {
        this.rebMemjobListService = rebMemjobListService;
    }

    private Date getSysDate() {
        try {
            return this.rebMemjobMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMemjob(RebMemjobDomain rebMemjobDomain) {
        if (null == rebMemjobDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebMemjobDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMemjobDefault(RebMemjob rebMemjob) {
        if (null == rebMemjob) {
            return;
        }
        if (null == rebMemjob.getDataState()) {
            rebMemjob.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebMemjob.getGmtCreate()) {
            rebMemjob.setGmtCreate(date);
        }
        rebMemjob.setGmtModified(date);
        if (StringUtils.isBlank((String)rebMemjob.getMemjobCode())) {
            rebMemjob.setMemjobCode(this.getNo(null, "RebMemjob", "rebMemjob", rebMemjob.getTenantCode()));
        }
    }

    private int getMemjobMaxCode() {
        int code = 0;
        try {
            return this.rebMemjobMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getMemjobMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMemjobUpdataDefault(RebMemjob rebMemjob) {
        if (null == rebMemjob) {
            return;
        }
        rebMemjob.setGmtModified(this.getSysDate());
    }

    private void saveMemjobModel(RebMemjob rebMemjob) throws ApiException {
        if (null == rebMemjob) {
            return;
        }
        try {
            this.rebMemjobMapper.insert(rebMemjob);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.saveMemjobModel.ex", (Throwable)e);
        }
    }

    private void saveMemjobBatchModel(List<RebMemjob> rebMemjobList) throws ApiException {
        if (null == rebMemjobList || rebMemjobList.isEmpty()) {
            return;
        }
        try {
            this.rebMemjobMapper.insertBatch(rebMemjobList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.saveMemjobBatchModel.ex", (Throwable)e);
        }
    }

    private RebMemjob getMemjobModelById(Integer memjobId) {
        if (null == memjobId) {
            return null;
        }
        try {
            return this.rebMemjobMapper.selectByPrimaryKey(memjobId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getMemjobModelById", (Throwable)e);
            return null;
        }
    }

    private RebMemjob getMemjobModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebMemjobMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.getMemjobModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMemjobModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.delMemjobModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobServiceImpl.delMemjobModelByCode.num");
        }
    }

    private void deleteMemjobModel(Integer memjobId) throws ApiException {
        if (null == memjobId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.deleteByPrimaryKey(memjobId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.deleteMemjobModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobServiceImpl.deleteMemjobModel.num");
        }
    }

    private void updateMemjobModel(RebMemjob rebMemjob) throws ApiException {
        if (null == rebMemjob) {
            return;
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.updateByPrimaryKey(rebMemjob);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjobModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjobModel.num");
        }
    }

    private void updateStateMemjobModel(Integer memjobId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == memjobId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memjobId", memjobId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModel.null");
        }
    }

    private void updateStateMemjobModelByCode(String tenantCode, String memjobCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobCode", memjobCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebMemjobMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateStateMemjobModelByCode.null");
        }
    }

    private RebMemjob makeMemjob(RebMemjobDomain rebMemjobDomain, RebMemjob rebMemjob) {
        if (null == rebMemjobDomain) {
            return null;
        }
        if (null == rebMemjob) {
            rebMemjob = new RebMemjob();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjob, (Object)rebMemjobDomain);
            return rebMemjob;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.makeMemjob", (Throwable)e);
            return null;
        }
    }

    private RebMemjobReDomain makeRebMemjobReDomain(RebMemjob rebMemjob) {
        if (null == rebMemjob) {
            return null;
        }
        RebMemjobReDomain rebMemjobReDomain = new RebMemjobReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjobReDomain, (Object)rebMemjob);
            return rebMemjobReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.makeRebMemjobReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebMemjob> queryMemjobModelPage(Map<String, Object> parammap) {
        try {
            return this.rebMemjobMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.queryMemjobModel", (Throwable)e);
            return null;
        }
    }

    private int countMemjob(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebMemjobMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.countMemjob", (Throwable)e);
        }
        return i;
    }

    private RebMemjob createRebMemjob(RebMemjobDomain rebMemjobDomain) {
        String msg = this.checkMemjob(rebMemjobDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebMemjobServiceImpl.saveMemjob.checkMemjob", msg);
        }
        RebMemjob rebMemjob = this.makeMemjob(rebMemjobDomain, null);
        this.setMemjobDefault(rebMemjob);
        return rebMemjob;
    }

    @Override
    public String saveMemjob(RebMemjobDomain rebMemjobDomain) throws ApiException {
        RebMemjob rebMemjob = this.createRebMemjob(rebMemjobDomain);
        this.saveMemjobModel(rebMemjob);
        return rebMemjob.getMemjobCode();
    }

    @Override
    public String saveMemjobBatch(List<RebMemjobDomain> rebMemjobDomainList) throws ApiException {
        if (null == rebMemjobDomainList || rebMemjobDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebMemjob> rebMemjobList = new ArrayList<RebMemjob>();
        String code = "";
        for (RebMemjobDomain rebMemjobDomain : rebMemjobDomainList) {
            RebMemjob rebMemjob = this.createRebMemjob(rebMemjobDomain);
            code = rebMemjob.getMemjobCode();
            rebMemjobList.add(rebMemjob);
        }
        this.saveMemjobBatchModel(rebMemjobList);
        return code;
    }

    @Override
    public void updateMemjobState(Integer memjobId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == memjobId) {
            return;
        }
        this.updateStateMemjobModel(memjobId, dataState, oldDataState, map);
    }

    @Override
    public void updateMemjobStateByCode(String tenantCode, String memjobCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMemjobModelByCode(tenantCode, memjobCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMemjob(RebMemjobDomain rebMemjobDomain) throws ApiException {
        String msg = this.checkMemjob(rebMemjobDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjob.checkMemjob", msg);
        }
        RebMemjob oldRebMemjob = this.getMemjobModelById(rebMemjobDomain.getMemjobId());
        if (null == oldRebMemjob) {
            throw new ApiException("reb.RebMemjobServiceImpl.updateMemjob.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebMemjob rebMemjob = this.makeMemjob(rebMemjobDomain, oldRebMemjob);
        this.setMemjobUpdataDefault(rebMemjob);
        this.updateMemjobModel(rebMemjob);
    }

    @Override
    public RebMemjob getMemjob(Integer memjobId) {
        if (null == memjobId) {
            return null;
        }
        return this.getMemjobModelById(memjobId);
    }

    @Override
    public void deleteMemjob(Integer memjobId) throws ApiException {
        if (null == memjobId) {
            return;
        }
        this.deleteMemjobModel(memjobId);
    }

    @Override
    public QueryResult<RebMemjob> queryMemjobPage(Map<String, Object> map) {
        List<RebMemjob> rebMemjobList = this.queryMemjobModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMemjob(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebMemjobList);
        return queryResult;
    }

    @Override
    public RebMemjob getMemjobByCode(String tenantCode, String memjobCode) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobCode", memjobCode);
        return this.getMemjobModelByCode(map);
    }

    @Override
    public void deleteMemjobByCode(String tenantCode, String memjobCode) throws ApiException {
        if (StringUtils.isBlank((String)memjobCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memjobCode", memjobCode);
        this.delMemjobModelByCode(map);
    }

    @Override
    public List<RebChannelsend> saveSendMemjob(RebUpointsClearDomain rebUpointsClearDomain) throws ApiException {
        if (null == rebUpointsClearDomain) {
            this.logger.error("reb.RebMemjobServiceImpl.saveSendMemjob", (Object)"rebUpointsClearDomain is null");
            return null;
        }
        if (StringUtils.isBlank((String)rebUpointsClearDomain.getUpointsClearOpcode1()) || StringUtils.isBlank((String)rebUpointsClearDomain.getMemberCode())) {
            this.logger.error("reb.RebMemjobServiceImpl.saveSendMemjob", (Object)"upointsClearOpcode1 is null");
            return null;
        }
        Date da = null;
        try {
            da = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(rebUpointsClearDomain.getUpointsClearOpcode1());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList memjobsList = new ArrayList();
        Integer month = da.getMonth();
        Integer year = da.getYear();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", "0");
        map.put("memjobDatatype", month);
        map.put("memjobDatetype", "1");
        map.put("memberCode", rebUpointsClearDomain.getMemberCode());
        map.put("memjobListDatetype", "3");
        map.put("memjobListDatatype", year);
        QueryResult<RebMemjobList> monthMemjobs = this.rebMemjobListService.queryMemjobListPage(map);
        if (null != monthMemjobs && ListUtil.isNotEmpty((Collection)monthMemjobs.getList())) {
            memjobsList.addAll(monthMemjobs.getList());
        }
        map.put("memjobDatatype", year);
        map.put("memjobDatetype", "2");
        QueryResult<RebMemjobList> yearMemjobs = this.rebMemjobListService.queryMemjobListPage(map);
        if (null != monthMemjobs && ListUtil.isNotEmpty((Collection)monthMemjobs.getList())) {
            memjobsList.addAll(yearMemjobs.getList());
        }
        if (ListUtil.isEmpty(memjobsList)) {
            this.logger.error("reb.RebMemjobServiceImpl.saveSendMemjob", (Object)"memjobsList is null");
            return null;
        }
        RebMemjobListDomain memjobListDomain = null;
        ArrayList<RebMemjobListDomain> joblistList = new ArrayList<RebMemjobListDomain>();
        for (RebMemjobList mem : memjobsList) {
            memjobListDomain = this.makeMemjobListDomain(null, mem);
            if (null == memjobListDomain) {
                this.logger.error("reb.RebMemjobServiceImpl.saveSendMemjob", (Object)"memjobListDomain is null");
                return null;
            }
            memjobListDomain.setMemjobListLimit(rebUpointsClearDomain.getUpointsClearNum2());
            memjobListDomain.setMemjobListExlimit(rebUpointsClearDomain.getUpointsClearNum2());
            memjobListDomain.setMemjobListExnum(rebUpointsClearDomain.getUpointsClearNum1());
            this.rebMemjobListService.updateMemjobListNum(memjobListDomain);
            joblistList.add(memjobListDomain);
        }
        return this.buidChannelsendList(joblistList, "insert");
    }

    private RebMemjobListDomain makeMemjobListDomain(RebMemjobListDomain rebMemjobListDomain, RebMemjobList rebMemjobList) {
        if (null == rebMemjobList) {
            return null;
        }
        if (null == rebMemjobListDomain) {
            rebMemjobListDomain = new RebMemjobListDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebMemjobListDomain, (Object)rebMemjobList);
            return rebMemjobListDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebMemjobServiceImpl.makeMemjobListDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebChannelsend> buidChannelsendList(List<RebMemjobListDomain> rebUpointsOpList, String dri) {
        if (ListUtil.isEmpty(rebUpointsOpList)) {
            return null;
        }
        ArrayList<RebChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<RebChannelsendDomain> disChannelsendDomainList = new ArrayList<RebChannelsendDomain>();
        for (RebMemjobListDomain rebUpointsOp : rebUpointsOpList) {
            RebChannelsendDomain pmChannelsendDomain = new RebChannelsendDomain();
            pmChannelsendDomain.setChannelsendType("rebUpointsOp-new");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)rebUpointsOp));
            pmChannelsendDomain.setTenantCode(rebUpointsOp.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.rebChannelsendService.saveSendRebChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }
}

