/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.reb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.reb.dao.RebPointsGoodsMapper;
import com.yqbsoft.laser.service.reb.domain.RebPointsGoodsDomain;
import com.yqbsoft.laser.service.reb.domain.RebPointsGoodsReDomain;
import com.yqbsoft.laser.service.reb.model.RebPointsGoods;
import com.yqbsoft.laser.service.reb.service.RebPointsGoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RebPointsGoodsServiceImpl
extends BaseServiceImpl
implements RebPointsGoodsService {
    private static final String SYS_CODE = "reb.RebPointsGoodsServiceImpl";
    private RebPointsGoodsMapper rebPointsGoodsMapper;

    public void setRebPointsGoodsMapper(RebPointsGoodsMapper rebPointsGoodsMapper) {
        this.rebPointsGoodsMapper = rebPointsGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.rebPointsGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPointsGoods(RebPointsGoodsDomain rebPointsGoodsDomain) {
        if (null == rebPointsGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rebPointsGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsGoodsDefault(RebPointsGoods rebPointsGoods) {
        if (null == rebPointsGoods) {
            return;
        }
        if (null == rebPointsGoods.getDataState()) {
            rebPointsGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rebPointsGoods.getGmtCreate()) {
            rebPointsGoods.setGmtCreate(date);
        }
        rebPointsGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)rebPointsGoods.getPointsGoodsCode())) {
            rebPointsGoods.setPointsGoodsCode(this.getNo(null, "RebPointsGoods", "rebPointsGoods", rebPointsGoods.getTenantCode()));
        }
    }

    private int getPointsGoodsMaxCode() {
        int code = 0;
        try {
            return this.rebPointsGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsGoodsServiceImpl.getPointsGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsGoodsUpdataDefault(RebPointsGoods rebPointsGoods) {
        if (null == rebPointsGoods) {
            return;
        }
        rebPointsGoods.setGmtModified(this.getSysDate());
    }

    private void savePointsGoodsModel(RebPointsGoods rebPointsGoods) throws ApiException {
        if (null == rebPointsGoods) {
            return;
        }
        try {
            this.rebPointsGoodsMapper.insert(rebPointsGoods);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.savePointsGoodsModel.ex", (Throwable)e);
        }
    }

    private void savePointsGoodsBatchModel(List<RebPointsGoods> rebPointsGoodsList) throws ApiException {
        if (null == rebPointsGoodsList || rebPointsGoodsList.isEmpty()) {
            return;
        }
        try {
            this.rebPointsGoodsMapper.insertBatch(rebPointsGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.savePointsGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private RebPointsGoods getPointsGoodsModelById(Integer pointsGoodsId) {
        if (null == pointsGoodsId) {
            return null;
        }
        try {
            return this.rebPointsGoodsMapper.selectByPrimaryKey(pointsGoodsId);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsGoodsServiceImpl.getPointsGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private RebPointsGoods getPointsGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rebPointsGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsGoodsServiceImpl.getPointsGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.delPointsGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.delPointsGoodsModelByCode.num");
        }
    }

    private void deletePointsGoodsModel(Integer pointsGoodsId) throws ApiException {
        if (null == pointsGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsGoodsMapper.deleteByPrimaryKey(pointsGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.deletePointsGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.deletePointsGoodsModel.num");
        }
    }

    private void updatePointsGoodsModel(RebPointsGoods rebPointsGoods) throws ApiException {
        if (null == rebPointsGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.rebPointsGoodsMapper.updateByPrimaryKey(rebPointsGoods);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.updatePointsGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.updatePointsGoodsModel.num");
        }
    }

    private void updateStatePointsGoodsModel(Integer pointsGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsGoodsId", pointsGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.updateStatePointsGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.updateStatePointsGoodsModel.null");
        }
    }

    private void updateStatePointsGoodsModelByCode(String tenantCode, String pointsGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsGoodsCode", pointsGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rebPointsGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.updateStatePointsGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.updateStatePointsGoodsModelByCode.null");
        }
    }

    private RebPointsGoods makePointsGoods(RebPointsGoodsDomain rebPointsGoodsDomain, RebPointsGoods rebPointsGoods) {
        if (null == rebPointsGoodsDomain) {
            return null;
        }
        if (null == rebPointsGoods) {
            rebPointsGoods = new RebPointsGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsGoods, (Object)rebPointsGoodsDomain);
            return rebPointsGoods;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsGoodsServiceImpl.makePointsGoods", (Throwable)e);
            return null;
        }
    }

    private RebPointsGoodsReDomain makeRebPointsGoodsReDomain(RebPointsGoods rebPointsGoods) {
        if (null == rebPointsGoods) {
            return null;
        }
        RebPointsGoodsReDomain rebPointsGoodsReDomain = new RebPointsGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rebPointsGoodsReDomain, (Object)rebPointsGoods);
            return rebPointsGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsGoodsServiceImpl.makeRebPointsGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RebPointsGoods> queryPointsGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rebPointsGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsGoodsServiceImpl.queryPointsGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rebPointsGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("reb.RebPointsGoodsServiceImpl.countPointsGoods", (Throwable)e);
        }
        return i;
    }

    private RebPointsGoods createRebPointsGoods(RebPointsGoodsDomain rebPointsGoodsDomain) {
        String msg = this.checkPointsGoods(rebPointsGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.savePointsGoods.checkPointsGoods", msg);
        }
        RebPointsGoods rebPointsGoods = this.makePointsGoods(rebPointsGoodsDomain, null);
        this.setPointsGoodsDefault(rebPointsGoods);
        return rebPointsGoods;
    }

    @Override
    public String savePointsGoods(RebPointsGoodsDomain rebPointsGoodsDomain) throws ApiException {
        RebPointsGoods rebPointsGoods = this.createRebPointsGoods(rebPointsGoodsDomain);
        this.savePointsGoodsModel(rebPointsGoods);
        return rebPointsGoods.getPointsGoodsCode();
    }

    @Override
    public String savePointsGoodsBatch(List<RebPointsGoodsDomain> rebPointsGoodsDomainList) throws ApiException {
        if (null == rebPointsGoodsDomainList || rebPointsGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RebPointsGoods> rebPointsGoodsList = new ArrayList<RebPointsGoods>();
        String code = "";
        for (RebPointsGoodsDomain rebPointsGoodsDomain : rebPointsGoodsDomainList) {
            RebPointsGoods rebPointsGoods = this.createRebPointsGoods(rebPointsGoodsDomain);
            code = rebPointsGoods.getPointsGoodsCode();
            rebPointsGoodsList.add(rebPointsGoods);
        }
        this.savePointsGoodsBatchModel(rebPointsGoodsList);
        return code;
    }

    @Override
    public void updatePointsGoodsState(Integer pointsGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsGoodsId) {
            return;
        }
        this.updateStatePointsGoodsModel(pointsGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsGoodsStateByCode(String tenantCode, String pointsGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsGoodsModelByCode(tenantCode, pointsGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePointsGoods(RebPointsGoodsDomain rebPointsGoodsDomain) throws ApiException {
        String msg = this.checkPointsGoods(rebPointsGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.updatePointsGoods.checkPointsGoods", msg);
        }
        RebPointsGoods oldRebPointsGoods = this.getPointsGoodsModelById(rebPointsGoodsDomain.getPointsGoodsId());
        if (null == oldRebPointsGoods) {
            throw new ApiException("reb.RebPointsGoodsServiceImpl.updatePointsGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RebPointsGoods rebPointsGoods = this.makePointsGoods(rebPointsGoodsDomain, oldRebPointsGoods);
        this.setPointsGoodsUpdataDefault(rebPointsGoods);
        this.updatePointsGoodsModel(rebPointsGoods);
    }

    @Override
    public RebPointsGoods getPointsGoods(Integer pointsGoodsId) {
        if (null == pointsGoodsId) {
            return null;
        }
        return this.getPointsGoodsModelById(pointsGoodsId);
    }

    @Override
    public void deletePointsGoods(Integer pointsGoodsId) throws ApiException {
        if (null == pointsGoodsId) {
            return;
        }
        this.deletePointsGoodsModel(pointsGoodsId);
    }

    @Override
    public QueryResult<RebPointsGoods> queryPointsGoodsPage(Map<String, Object> map) {
        List<RebPointsGoods> rebPointsGoodsList = this.queryPointsGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPointsGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rebPointsGoodsList);
        return queryResult;
    }

    @Override
    public RebPointsGoods getPointsGoodsByCode(String tenantCode, String pointsGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsGoodsCode", pointsGoodsCode);
        return this.getPointsGoodsModelByCode(map);
    }

    @Override
    public void deletePointsGoodsByCode(String tenantCode, String pointsGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsGoodsCode", pointsGoodsCode);
        this.delPointsGoodsModelByCode(map);
    }
}

