/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsClasstreeColorMapper;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeColorDomain;
import com.yqbsoft.laser.service.resources.domain.RsClasstreeColorReDomain;
import com.yqbsoft.laser.service.resources.model.RsClasstreeColor;
import com.yqbsoft.laser.service.resources.service.RsClasstreeColorService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsClasstreeColorServiceImpl
extends BaseServiceImpl
implements RsClasstreeColorService {
    private static final String SYS_CODE = "rs.RsClasstreeColorServiceImpl";
    private RsClasstreeColorMapper rsClasstreeColorMapper;

    public void setRsClasstreeColorMapper(RsClasstreeColorMapper rsClasstreeColorMapper) {
        this.rsClasstreeColorMapper = rsClasstreeColorMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsClasstreeColorMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeColorServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRsClasstreeColor(RsClasstreeColorDomain rsClasstreeColorDomain) {
        if (null == rsClasstreeColorDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsClasstreeColorDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRsClasstreeColorDefault(RsClasstreeColor rsClasstreeColor) {
        if (null == rsClasstreeColor) {
            return;
        }
        if (null == rsClasstreeColor.getDataState()) {
            rsClasstreeColor.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsClasstreeColor.getGmtCreate()) {
            rsClasstreeColor.setGmtCreate(date);
        }
        rsClasstreeColor.setGmtModified(date);
        if (StringUtils.isBlank((String)rsClasstreeColor.getClasstreeCode())) {
            rsClasstreeColor.setClasstreeCode(this.getNo(null, "RsClasstreeColor", "rsClasstreeColor", rsClasstreeColor.getTenantCode()));
        }
    }

    private int getRsClasstreeColorMaxCode() {
        int code = 0;
        try {
            return this.rsClasstreeColorMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeColorServiceImpl.getRsClasstreeColorMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRsClasstreeColorUpdataDefault(RsClasstreeColor rsClasstreeColor) {
        if (null == rsClasstreeColor) {
            return;
        }
        rsClasstreeColor.setGmtModified(this.getSysDate());
    }

    private void saveRsClasstreeColorModel(RsClasstreeColor rsClasstreeColor) throws ApiException {
        if (null == rsClasstreeColor) {
            return;
        }
        try {
            this.rsClasstreeColorMapper.insert(rsClasstreeColor);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.saveRsClasstreeColorModel.ex", (Throwable)e);
        }
    }

    private void saveRsClasstreeColorBatchModel(List<RsClasstreeColor> rsClasstreeColorList) throws ApiException {
        if (null == rsClasstreeColorList || rsClasstreeColorList.isEmpty()) {
            return;
        }
        try {
            this.rsClasstreeColorMapper.insertBatch(rsClasstreeColorList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.saveRsClasstreeColorBatchModel.ex", (Throwable)e);
        }
    }

    private RsClasstreeColor getRsClasstreeColorModelById(Integer classtreeId) {
        if (null == classtreeId) {
            return null;
        }
        try {
            return this.rsClasstreeColorMapper.selectByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeColorServiceImpl.getRsClasstreeColorModelById", (Throwable)e);
            return null;
        }
    }

    private RsClasstreeColor getRsClasstreeColorModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsClasstreeColorMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeColorServiceImpl.getRsClasstreeColorModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRsClasstreeColorModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeColorMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.delRsClasstreeColorModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.delRsClasstreeColorModelByCode.num");
        }
    }

    private void deleteRsClasstreeColorModel(Integer classtreeId) throws ApiException {
        if (null == classtreeId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeColorMapper.deleteByPrimaryKey(classtreeId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.deleteRsClasstreeColorModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.deleteRsClasstreeColorModel.num");
        }
    }

    private void updateRsClasstreeColorModel(RsClasstreeColor rsClasstreeColor) throws ApiException {
        if (null == rsClasstreeColor) {
            return;
        }
        int i = 0;
        try {
            i = this.rsClasstreeColorMapper.updateByPrimaryKey(rsClasstreeColor);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.updateRsClasstreeColorModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.updateRsClasstreeColorModel.num");
        }
    }

    private void updateStateRsClasstreeColorModel(Integer classtreeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == classtreeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classtreeId", classtreeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsClasstreeColorMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.updateStateRsClasstreeColorModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.updateStateRsClasstreeColorModel.null");
        }
    }

    private void updateStateRsClasstreeColorModelByCode(String tenantCode, String classtreeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)classtreeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("classtreeCode", classtreeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsClasstreeColorMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.updateStateRsClasstreeColorModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.updateStateRsClasstreeColorModelByCode.null");
        }
    }

    private RsClasstreeColor makeRsClasstreeColor(RsClasstreeColorDomain rsClasstreeColorDomain, RsClasstreeColor rsClasstreeColor) {
        if (null == rsClasstreeColorDomain) {
            return null;
        }
        if (null == rsClasstreeColor) {
            rsClasstreeColor = new RsClasstreeColor();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeColor, (Object)rsClasstreeColorDomain);
            return rsClasstreeColor;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeColorServiceImpl.makeRsClasstreeColor", (Throwable)e);
            return null;
        }
    }

    private RsClasstreeColorReDomain makeRsClasstreeColorReDomain(RsClasstreeColor rsClasstreeColor) {
        if (null == rsClasstreeColor) {
            return null;
        }
        RsClasstreeColorReDomain rsClasstreeColorReDomain = new RsClasstreeColorReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeColorReDomain, (Object)rsClasstreeColor);
            return rsClasstreeColorReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeColorServiceImpl.makeRsClasstreeColorReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsClasstreeColor> queryRsClasstreeColorModelPage(Map<String, Object> parammap) {
        try {
            return this.rsClasstreeColorMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeColorServiceImpl.queryRsClasstreeColorModel", (Throwable)e);
            return null;
        }
    }

    private int countRsClasstreeColor(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsClasstreeColorMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsClasstreeColorServiceImpl.countRsClasstreeColor", (Throwable)e);
        }
        return i;
    }

    private RsClasstreeColor createRsClasstreeColor(RsClasstreeColorDomain rsClasstreeColorDomain) {
        String msg = this.checkRsClasstreeColor(rsClasstreeColorDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.saveRsClasstreeColor.checkRsClasstreeColor", msg);
        }
        RsClasstreeColor rsClasstreeColor = this.makeRsClasstreeColor(rsClasstreeColorDomain, null);
        this.setRsClasstreeColorDefault(rsClasstreeColor);
        return rsClasstreeColor;
    }

    @Override
    public String saveRsClasstreeColor(RsClasstreeColorDomain rsClasstreeColorDomain) throws ApiException {
        RsClasstreeColor rsClasstreeColor = this.createRsClasstreeColor(rsClasstreeColorDomain);
        this.saveRsClasstreeColorModel(rsClasstreeColor);
        return rsClasstreeColor.getClasstreeCode();
    }

    @Override
    public String saveRsClasstreeColorBatch(List<RsClasstreeColorDomain> rsClasstreeColorDomainList) throws ApiException {
        if (null == rsClasstreeColorDomainList || rsClasstreeColorDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsClasstreeColor> rsClasstreeColorList = new ArrayList<RsClasstreeColor>();
        String code = "";
        for (RsClasstreeColorDomain rsClasstreeColorDomain : rsClasstreeColorDomainList) {
            RsClasstreeColor rsClasstreeColor = this.createRsClasstreeColor(rsClasstreeColorDomain);
            code = rsClasstreeColor.getClasstreeCode();
            rsClasstreeColorList.add(rsClasstreeColor);
        }
        this.saveRsClasstreeColorBatchModel(rsClasstreeColorList);
        return code;
    }

    @Override
    public void updateRsClasstreeColorState(Integer classtreeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == classtreeId) {
            return;
        }
        this.updateStateRsClasstreeColorModel(classtreeId, dataState, oldDataState, map);
    }

    @Override
    public void updateRsClasstreeColorStateByCode(String tenantCode, String classtreeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRsClasstreeColorModelByCode(tenantCode, classtreeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRsClasstreeColor(RsClasstreeColorDomain rsClasstreeColorDomain) throws ApiException {
        String msg = this.checkRsClasstreeColor(rsClasstreeColorDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.updateRsClasstreeColor.checkRsClasstreeColor", msg);
        }
        RsClasstreeColor oldRsClasstreeColor = this.getRsClasstreeColorModelById(rsClasstreeColorDomain.getClasstreeId());
        if (null == oldRsClasstreeColor) {
            throw new ApiException("rs.RsClasstreeColorServiceImpl.updateRsClasstreeColor.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsClasstreeColor rsClasstreeColor = this.makeRsClasstreeColor(rsClasstreeColorDomain, oldRsClasstreeColor);
        this.setRsClasstreeColorUpdataDefault(rsClasstreeColor);
        this.updateRsClasstreeColorModel(rsClasstreeColor);
    }

    @Override
    public RsClasstreeColor getRsClasstreeColor(Integer classtreeId) {
        if (null == classtreeId) {
            return null;
        }
        return this.getRsClasstreeColorModelById(classtreeId);
    }

    @Override
    public void deleteRsClasstreeColor(Integer classtreeId) throws ApiException {
        if (null == classtreeId) {
            return;
        }
        this.deleteRsClasstreeColorModel(classtreeId);
    }

    @Override
    public QueryResult<RsClasstreeColor> queryRsClasstreeColorPage(Map<String, Object> map) {
        List<RsClasstreeColor> rsClasstreeColorList = this.queryRsClasstreeColorModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRsClasstreeColor(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsClasstreeColorList);
        return queryResult;
    }

    @Override
    public RsClasstreeColor getRsClasstreeColorByCode(String tenantCode, String classtreeCode) throws ApiException {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("classtreeCode", classtreeCode);
        return this.getRsClasstreeColorModelByCode(map);
    }

    @Override
    public void deleteRsClasstreeColorByCode(String tenantCode, String classtreeCode) throws ApiException {
        if (StringUtils.isBlank((String)classtreeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("classtreeCode", classtreeCode);
        this.delRsClasstreeColorModelByCode(map);
    }
}

