/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.ResourcesConstants;
import com.yqbsoft.laser.service.resources.dao.RsSkuMapper;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisDgnumDomain;
import com.yqbsoft.laser.service.resources.domain.DisDgnumList;
import com.yqbsoft.laser.service.resources.domain.EditSkuDomain;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsBuyDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsPriceDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddataDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuOneDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsGoodsBuy;
import com.yqbsoft.laser.service.resources.model.RsGoodsFile;
import com.yqbsoft.laser.service.resources.model.RsGoodsPrice;
import com.yqbsoft.laser.service.resources.model.RsGoodsRel;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.model.RsSkuOne;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsGoodsBuyService;
import com.yqbsoft.laser.service.resources.service.RsGoodsOtherService;
import com.yqbsoft.laser.service.resources.service.RsGoodsPriceService;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.resources.service.RsSkuOneService;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.FileType;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;
import org.springframework.util.CollectionUtils;

public class RsSkuServiceImpl
extends BaseServiceImpl
implements RsSkuService {
    public static final String SYS_CODE = "rs.RsSkuServiceImpl";
    private RsSkuMapper rsSkuMapper;
    private RsSpecValueService rsSpecValueService;
    private RsGoodsOtherService rsGoodsOtherService;
    private RsSenddataBaseService rsSenddataBaseService;
    private RsSkuOneService rsSkuOneService;
    RsResourceGoodsService rsResourceGoodsService;
    private RsGoodsPriceService rsGoodsPriceService;
    private RsGoodsBuyService rsGoodsBuyService;

    public void setRsSkuOneService(RsSkuOneService rsSkuOneService) {
        this.rsSkuOneService = rsSkuOneService;
    }

    public RsResourceGoodsService getRsResourceGoodsService() {
        if (null == this.rsResourceGoodsService) {
            this.rsResourceGoodsService = (RsResourceGoodsService)ApplicationContextUtil.getService((String)"rsResourceGoodsService");
        }
        return this.rsResourceGoodsService;
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public void setRsGoodsOtherService(RsGoodsOtherService rsGoodsOtherService) {
        this.rsGoodsOtherService = rsGoodsOtherService;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsSkuMapper(RsSkuMapper rsSkuMapper) {
        this.rsSkuMapper = rsSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSkuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSku(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (null == rsSkuDomain.getPricesetNprice() || rsSkuDomain.getPricesetNprice().compareTo(BigDecimal.ZERO) < 0) {
            return "\u4ef7\u683c\u4fe1\u606f\u6709\u8bef";
        }
        if (null == rsSkuDomain.getGoodsNum() || rsSkuDomain.getGoodsNum().compareTo(BigDecimal.ZERO) < 0) {
            return "\u5e93\u5b58\u4fe1\u606f\u6709\u8bef";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSpuCode())) {
            msg = msg + "spu\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getSkuName())) {
            msg = msg + "sku\u540d\u79f0\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getGoodsCode())) {
            msg = msg + "\u5546\u54c1\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuDefault(RsSku rsSku) {
        String falg;
        if (null == rsSku) {
            return;
        }
        if (null == rsSku.getDataState()) {
            rsSku.setDataState(0);
        }
        if (null == rsSku.getDataOpbillstate()) {
            rsSku.setDataOpbillstate(0);
        }
        if (null == rsSku.getDataOpnextbillstate()) {
            rsSku.setDataOpnextbillstate(0);
        }
        Date date = this.getSysDate();
        if (null == rsSku.getGmtCreate()) {
            rsSku.setGmtCreate(date);
        }
        if (null == rsSku.getGoodsNum()) {
            rsSku.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == rsSku.getGoodsWeight()) {
            rsSku.setGoodsWeight(BigDecimal.ZERO);
        }
        rsSku.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSku.getSkuCode())) {
            String skuCode = this.getNo(null, RsSku.class.getSimpleName(), "skuCode", rsSku.getTenantCode());
            rsSku.setSkuCode(skuCode);
        }
        if (StringUtils.isBlank((String)(falg = this.checkSkuShowno(rsSku.getTenantCode(), "skuShowno", "skuShowno"))) && StringUtils.isBlank((String)rsSku.getSkuShowno())) {
            rsSku.setSkuShowno(rsSku.getSkuNo());
        }
        this.makeDefSku(rsSku);
        if (ResourcesConstants.DATA_OPBILLSTATE_1.intValue() == rsSku.getDataOpbillstate().intValue()) {
            this.setAuditModel(rsSku, false);
        }
        if (null == rsSku.getPricesetChannenprice()) {
            rsSku.setPricesetChannenprice(rsSku.getPricesetNprice1());
        }
        if (StringUtils.isBlank((String)rsSku.getGoodsOldcode())) {
            rsSku.setGoodsOldcode("-1");
        }
        if (StringUtils.isBlank((String)rsSku.getSkuOldcode())) {
            rsSku.setSkuOldcode("-1");
        }
    }

    protected String checkSkuShowno(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    private void makeInfo(RsSkuDomain rsSkuDomain) {
        List disFile;
        String[] skuShownoS;
        if (null == rsSkuDomain) {
            return;
        }
        if (StringUtils.isBlank((String)rsSkuDomain.getChannelCode())) {
            return;
        }
        String showInfo = DisUtil.getMap((String)"DisDgoodsuplist-No-channelCode", (String)(rsSkuDomain.getChannelCode() + "-1-" + rsSkuDomain.getSkuNo() + "-" + rsSkuDomain.getTenantCode()));
        if (StringUtils.isNotBlank((String)showInfo) && null != (skuShownoS = showInfo.split("\\|")) && skuShownoS.length > 0 && StringUtils.isNotBlank((String)skuShownoS[0])) {
            rsSkuDomain.setSkuShowno(skuShownoS[0]);
        }
        if (ListUtil.isNotEmpty((Collection)(disFile = DisUtil.getMapListJson((String)"DisDgoodsuplistFile-No-channelCode", (String)(rsSkuDomain.getChannelCode() + "-1-" + rsSkuDomain.getSkuNo() + "-" + rsSkuDomain.getTenantCode()), RsGoodsFileDomain.class)))) {
            ArrayList<RsGoodsFileDomain> goodsFile = new ArrayList<RsGoodsFileDomain>();
            for (RsGoodsFileDomain rsGoodsFileDomain1 : disFile) {
                RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFileDomain1);
                    rsGoodsFileDomain.setGoodsFileCode(null);
                    goodsFile.add(rsGoodsFileDomain);
                }
                catch (Exception exception) {}
            }
            rsSkuDomain.setRsGoodsFileDomainList(goodsFile);
        }
    }

    private int getSkuMaxCode() {
        int code = 0;
        try {
            return this.rsSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuUpdataDefault(RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        rsSku.setGmtModified(this.getSysDate());
    }

    private void saveSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            this.rsSkuMapper.insert(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSkuModel.ex", (Throwable)e);
        }
    }

    private RsSku getSkuModelById(Integer skuId) {
        if (null == skuId) {
            return null;
        }
        try {
            return this.rsSkuMapper.selectByPrimaryKey(skuId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuModelById", (Throwable)e);
            return null;
        }
    }

    private boolean lockGoodsData(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.lockDataByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.lockGoodsData", map.toString(), (Throwable)e);
        }
        return i > 0;
    }

    @Override
    public boolean lockSkuData(Map<String, Object> map) {
        return this.lockGoodsData(map);
    }

    public RsSku getSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuModelByCode", (Object)map.toString(), (Throwable)e);
            return null;
        }
    }

    public void delSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuModelByCode.num");
        }
    }

    public void updateSkuEocodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuEocode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocodeModelByCode.ex", (Throwable)e);
        }
        if (1 > i) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocodeModelByCode.num");
        }
    }

    private void updateSkuNextModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuNextByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuNextModelByCode.ex", (Throwable)e);
        }
        if (1 > i) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuNextModelByCode.num", map.toString());
        }
    }

    public void updateGoodsEocodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateGoodsEocode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsEocodeModelByCode.ex", (Throwable)e);
        }
        if (1 > i) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsEocodeModelByCode.num");
        }
    }

    private void deleteSkuModel(Integer skuId) throws ApiException {
        if (null == skuId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.deleteByPrimaryKey(skuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModel.ex", skuId + "", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModel.num");
        }
    }

    private void updateSkuModel(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            this.rsSkuMapper.updateByPrimaryKeySelective(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModel.ex", (Throwable)e);
        }
    }

    private void updateSkuModelWithNull(RsSku rsSku) throws ApiException {
        if (null == rsSku) {
            return;
        }
        try {
            this.rsSkuMapper.updateByPrimaryKey(rsSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuModelWithNull.ex", (Throwable)e);
        }
    }

    @Override
    public boolean updateNum(String skuNo, String tenantCode, BigDecimal num) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode) || null == num) {
            this.logger.error("rs.RsSkuServiceImpl.updateNum", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        boolean flag = false;
        Map map = this.getQueryMapParam("skuNo,tenantCode", new Object[]{skuNo, tenantCode});
        List<RsSku> skus = this.rsSkuMapper.query(map);
        if (null == skus || ListUtil.isEmpty(skus)) {
            this.logger.error("rs.RsSkuServiceImpl.updateNum", (Object)"\u65e0\u6570\u636e");
            return false;
        }
        Integer dataOpbillstate = skus.get(0).getDataOpbillstate();
        if (dataOpbillstate == 1) {
            map.put("goodsSupplynum", num);
        } else {
            map.put("goodsNum", num);
        }
        map.put("dataOpbillstate", dataOpbillstate);
        int i = this.rsSkuMapper.updateNum(map);
        if (i > 0) {
            flag = true;
        }
        return flag;
    }

    private void updateStateSkuModel(Integer skuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == skuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuId", skuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateStateSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateStateSkuModel.null");
        }
    }

    private RsSku makeSku(RsSkuDomain rsSkuDomain, RsSku rsSku) {
        if (null == rsSkuDomain) {
            return null;
        }
        if (null == rsSku) {
            rsSku = new RsSku();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSku, (Object)rsSkuDomain);
            return rsSku;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.makeSku", (Throwable)e);
            if (null == rsSku.getGoodsNum()) {
                rsSku.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsWeight()) {
                rsSku.setGoodsWeight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsSupplynum()) {
                rsSku.setGoodsSupplynum(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsSupplyweight()) {
                rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsOneweight()) {
                rsSku.setGoodsOneweight(BigDecimal.ZERO);
            }
            if (null == rsSku.getGoodsMinnum() || rsSku.getGoodsMinnum().compareTo(BigDecimal.ZERO) == 0) {
                rsSku.setGoodsMinnum(new BigDecimal("1"));
            }
            if (rsSku.getGoodsNum().compareTo(BigDecimal.ZERO) != 0 && rsSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) == 0) {
                rsSku.setGoodsSupplynum(rsSku.getGoodsNum());
                rsSku.setGoodsSupplyweight(rsSku.getGoodsWeight());
            }
            if (rsSku.getGoodsNum().compareTo(BigDecimal.ZERO) == 0 && rsSku.getGoodsSupplynum().compareTo(BigDecimal.ZERO) != 0) {
                rsSku.setGoodsNum(rsSku.getGoodsSupplynum());
                rsSku.setGoodsWeight(rsSku.getGoodsSupplyweight());
            }
            if (rsSku.getGoodsWeight().compareTo(BigDecimal.ZERO) == 0 && rsSku.getGoodsOneweight().compareTo(BigDecimal.ZERO) != 0) {
                rsSku.setGoodsWeight(rsSku.getGoodsNum().multiply(rsSku.getGoodsOneweight()));
                rsSku.setGoodsSupplyweight(rsSku.getGoodsWeight());
            }
            return null;
        }
    }

    private List<RsSku> querySkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private List<RsSku> queryAppointPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryAppoint(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.queryAppointSkuPage", (Throwable)e);
            return null;
        }
    }

    private int countSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    private int countSkuRecord(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.countRecord(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveSku(RsSkuDomain rsSkuDomain) throws ApiException {
        RsSku rsSku = this.saveSkuDomain(rsSkuDomain);
        if (null != rsSku) {
            return rsSku.getSkuCode();
        }
        return null;
    }

    private RsSku saveSkuMode(RsSkuDomain rsSkuDomain) {
        RsSku oldRsSku;
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSku.checkSku", msg);
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, null);
        if (null != rsSkuDomain.getOldDataState()) {
            rsSku.setDataState(rsSkuDomain.getOldDataState());
        }
        this.setSkuDefault(rsSku);
        if (StringUtils.isNotBlank((String)rsSkuDomain.getSkuCode()) && null != (oldRsSku = this.getSkuModelByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{rsSkuDomain.getSkuCode(), rsSkuDomain.getTenantCode()})))) {
            rsSku.setSkuId(oldRsSku.getSkuId());
        }
        if (null != rsSku.getSkuId()) {
            this.updateSkuModel(rsSku);
        } else {
            this.saveSkuModel(rsSku);
        }
        this.saveSpecList(rsSkuDomain.getSpecList(), rsSkuDomain.getGoodsCode());
        return rsSku;
    }

    @Override
    public List<RsSenddataDomain> saveSkuListOne(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods) throws ApiException {
        return this.saveSkuListRe(rsSkuList, rsResourceGoods, false, false);
    }

    @Override
    public List<RsSenddataDomain> updateSkuListOne(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods) throws ApiException {
        return this.saveSkuListRe(rsSkuList, rsResourceGoods, false, true);
    }

    public List<RsSenddataDomain> saveSkuListRe(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods, boolean flag, boolean upflag) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty() || null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.saveSkuListRe.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<RsSenddataDomain> rsSenddataList = new ArrayList<RsSenddataDomain>();
        ArrayList<RsSku> rsSkuListsend = new ArrayList<RsSku>();
        boolean skuadd = false;
        String senddataParentcode = null;
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            skuadd = false;
            senddataParentcode = null;
            if (StringUtils.isBlank((String)rsSkuDomain.getSkuCode())) {
                skuadd = true;
            }
            Integer dataOpbillstate = rsSkuDomain.getDataOpbillstate();
            if (null != rsSkuDomain.getOldDataState() && null != rsSkuDomain.getDataOpbillstate()) {
                if (ResourcesConstants.DATA_OPBILLSTATE_1.intValue() == rsSkuDomain.getDataOpbillstate().intValue()) {
                    rsSkuDomain.setOldDataState(ResourcesConstants.GOODS_DATA_STATE_2);
                } else if (ResourcesConstants.DATA_OPBILLSTATE_1.intValue() != rsSkuDomain.getDataOpbillstate().intValue() && ResourcesConstants.GOODS_DATA_STATE_2.intValue() == rsSkuDomain.getOldDataState().intValue()) {
                    if (ResourcesConstants.GOODS_DATA_STATE_2.intValue() != rsResourceGoods.getDataState().intValue()) {
                        rsSkuDomain.setOldDataState(rsResourceGoods.getDataState());
                    } else {
                        rsSkuDomain.setOldDataState(ResourcesConstants.GOODS_DATA_STATE_0);
                    }
                }
            }
            this.logger.info("rs.RsSkuServiceImpl.saveSkuListRe.saveSkuDomain.start", (Object)JSONObject.toJSONString((Object)rsSkuDomain));
            RsSku rsSku = this.saveSkuDomain(rsSkuDomain);
            this.logger.info("rs.RsSkuServiceImpl.saveSkuListRe.saveSkuDomain.end", (Object)JSONObject.toJSONString((Object)rsSku));
            if (!upflag || skuadd) {
                List<RsSenddataDomain> downList;
                rsSkuListsend.add(rsSku);
                if (!flag && ListUtil.isNotEmpty(downList = this.saveSenddata(rsSkuListsend, "skuadd", rsResourceGoods.getGoodsEocode(), null))) {
                    rsSenddataList.addAll(downList);
                }
            }
            if (flag) {
                List<RsSenddataDomain> skuRsSenddataList;
                if (ResourcesConstants.DATA_OPBILLSTATE_1 != dataOpbillstate || !ListUtil.isNotEmpty(skuRsSenddataList = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_2, ResourcesConstants.GOODS_DATA_STATE_0, rsSku.getSkuCode(), rsSku.getTenantCode(), rsResourceGoods))) continue;
                senddataParentcode = skuRsSenddataList.get(0).getSenddataCode();
                rsSenddataList.addAll(skuRsSenddataList);
                continue;
            }
            if (upflag && ResourcesConstants.DATA_OPBILLSTATE_1.intValue() == dataOpbillstate.intValue()) {
                this.saveMinNum(rsResourceGoods, rsSku, rsSenddataList, senddataParentcode);
                continue;
            }
            if (!upflag || ResourcesConstants.GOODS_DATA_STATE_4.intValue() != rsSku.getDataState().intValue()) continue;
            this.saveMinNum(rsResourceGoods, rsSku, rsSenddataList, senddataParentcode);
        }
        return rsSenddataList;
    }

    @Override
    public List<RsSenddataDomain> saveSkuList(List<RsSkuDomain> rsSkuList, RsResourceGoods rsResourceGoods) throws ApiException {
        return this.saveSkuListRe(rsSkuList, rsResourceGoods, true, false);
    }

    private RsSku saveSkuDomain(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return null;
        }
        this.makeInfo(rsSkuDomain);
        List<RsGoodsFileDomain> rsGoodsFileDomainList = rsSkuDomain.getRsGoodsFileDomainList();
        String dataPic = "";
        this.makePic(rsSkuDomain, rsGoodsFileDomainList, dataPic);
        RsSku rsSku = this.saveSkuMode(rsSkuDomain);
        rsSkuDomain.setSkuCode(rsSku.getSkuCode());
        this.saveSkufile(rsSkuDomain.getRsGoodsFileDomainList(), rsSku);
        if (rsSkuDomain.isRsGoodsBuyDomainFlag()) {
            this.saveSkuBuy(rsSkuDomain.getRsGoodsBuyDomainList(), rsSku);
        }
        this.saveSkuPrice(rsSkuDomain.getRsGoodsPriceDomainList(), rsSku);
        this.saveSkuRel(rsSkuDomain);
        if (null != rsSkuDomain.getRsSkuOneDomain()) {
            this.logger.info("rs.RsSkuServiceImpl.saveSkuDomain.rsSkuOneDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuDomain.getRsSkuOneDomain()));
            rsSkuDomain.getRsSkuOneDomain().setTenantCode(rsSkuDomain.getTenantCode());
            rsSkuDomain.getRsSkuOneDomain().setGoodsName(rsSkuDomain.getGoodsName());
            rsSkuDomain.getRsSkuOneDomain().setGoodsNo(rsSkuDomain.getGoodsNo());
            rsSkuDomain.getRsSkuOneDomain().setChannelCode(rsSkuDomain.getChannelCode());
            rsSkuDomain.getRsSkuOneDomain().setChannelName(rsSkuDomain.getChannelName());
            rsSkuDomain.getRsSkuOneDomain().setSkuOneValueno(rsSkuDomain.getSkuCode());
            rsSkuDomain.getRsSkuOneDomain().setSkuNo(rsSkuDomain.getSkuNo());
            this.rsSkuOneService.saveOrUpdateSkuOneAndSkuOneList(rsSkuDomain.getRsSkuOneDomain());
        }
        return rsSku;
    }

    private void saveSkufile(List<RsGoodsFileDomain> rsGoodsFileDomainList, RsSku rsSku) {
        if (null == rsSku || ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return;
        }
        Map paramMap = this.getQueryParamMap("skuCode,tenantCode", new Object[]{rsSku.getSkuCode(), rsSku.getTenantCode()});
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        if (ListUtil.isNotEmpty(rsGoodsFileDomainList)) {
            ArrayList<RsGoodsFileDomain> rsskuGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
            for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
                if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
                rsGoodsFileDomain.setSkuCode(rsSku.getSkuCode());
                rsGoodsFileDomain.setGoodsCode(null);
                rsGoodsFileDomain.setTenantCode(rsSku.getTenantCode());
                rsGoodsFileDomain.setMemberCode(rsSku.getMemberCode());
                rsGoodsFileDomain.setMemberName(rsSku.getMemberName());
                rsGoodsFileDomain.setGoodsFileCode(null);
                rsskuGoodsFileDomainList.add(rsGoodsFileDomain);
                rsGoodsFileDomain.setGoodsFileId(null);
            }
            this.rsGoodsOtherService.saveGoodsFileList(rsskuGoodsFileDomainList);
        }
    }

    private void saveSkuPrice(List<RsGoodsPriceDomain> rsGoodsPriceDomainList, RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        Map paramMap = this.getQueryParamMap("goodsPriceType,skuCode,tenantCode", new Object[]{"1", rsSku.getSkuCode(), rsSku.getTenantCode()});
        this.rsGoodsPriceService.deleteRsGoodsPriceByMap(paramMap);
        if (ListUtil.isNotEmpty(rsGoodsPriceDomainList)) {
            ArrayList<RsGoodsPriceDomain> rsskuGoodsPriceDomainList = new ArrayList<RsGoodsPriceDomain>();
            for (RsGoodsPriceDomain rsGoodsPriceDomain : rsGoodsPriceDomainList) {
                rsGoodsPriceDomain.setSkuCode(rsSku.getSkuCode());
                rsGoodsPriceDomain.setGoodsCode(rsSku.getGoodsCode());
                rsGoodsPriceDomain.setTenantCode(rsSku.getTenantCode());
                rsGoodsPriceDomain.setMemberCode(rsSku.getMemberCode());
                rsGoodsPriceDomain.setMemberName(rsSku.getMemberName());
                rsGoodsPriceDomain.setGoodsPriceCode(null);
                rsskuGoodsPriceDomainList.add(rsGoodsPriceDomain);
                rsGoodsPriceDomain.setGoodsPriceId(null);
                rsGoodsPriceDomain.setMemberCode(rsSku.getMemberCode());
                rsGoodsPriceDomain.setMemberName(rsSku.getMemberName());
                rsGoodsPriceDomain.setChannelCode(rsSku.getChannelCode());
                rsGoodsPriceDomain.setChannelName(rsSku.getChannelName());
            }
            this.rsGoodsPriceService.saveRsGoodsPriceBatch(rsskuGoodsPriceDomainList);
        }
    }

    private void saveSkuBuy(List<RsGoodsBuyDomain> rsGoodsBuyDomainList, RsSku rsSku) {
        if (null == rsSku) {
            return;
        }
        Map paramMap = this.getQueryParamMap("goodsBuyType,skuCode,tenantCode", new Object[]{"1", rsSku.getSkuCode(), rsSku.getTenantCode()});
        this.rsGoodsBuyService.deleteGoodsBuyBySkuCode(paramMap);
        if (ListUtil.isNotEmpty(rsGoodsBuyDomainList)) {
            ArrayList<RsGoodsBuyDomain> rsskuGoodsBuyDomainList = new ArrayList<RsGoodsBuyDomain>();
            for (RsGoodsBuyDomain rsGoodsBuyDomain : rsGoodsBuyDomainList) {
                rsGoodsBuyDomain.setSkuCode(rsSku.getSkuCode());
                rsGoodsBuyDomain.setGoodsCode(rsSku.getGoodsCode());
                rsGoodsBuyDomain.setTenantCode(rsSku.getTenantCode());
                rsGoodsBuyDomain.setMemberCode(rsSku.getMemberCode());
                rsGoodsBuyDomain.setMemberName(rsSku.getMemberName());
                rsGoodsBuyDomain.setGoodsBuyCode(null);
                rsskuGoodsBuyDomainList.add(rsGoodsBuyDomain);
                rsGoodsBuyDomain.setGoodsBuyId(null);
                rsGoodsBuyDomain.setMemberCode(rsSku.getMemberCode());
                rsGoodsBuyDomain.setMemberName(rsSku.getMemberName());
                rsGoodsBuyDomain.setChannelCode(rsSku.getChannelCode());
                rsGoodsBuyDomain.setChannelName(rsSku.getChannelName());
                rsGoodsBuyDomain.setGoodsClass(rsSku.getGoodsClass());
            }
            this.rsGoodsBuyService.saveGoodsBuyBatch(rsskuGoodsBuyDomainList);
        }
    }

    private void makePic(RsSkuDomain rsSkuDomain, List<RsGoodsFileDomain> rsGoodsFileDomainList, String dataPic) {
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return;
        }
        dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (null == rsGoodsFileDomain || StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            if (rsGoodsFileDomain.getDefaultState() == null || rsGoodsFileDomain.getDefaultState() != 1) continue;
            dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            break;
        }
        rsSkuDomain.setDataPic(dataPic);
    }

    protected String sortSkuName(String skuName) {
        if (StringUtils.isBlank((String)skuName)) {
            return null;
        }
        List<String> spcList = Arrays.asList(skuName.split("\\/"));
        return this.sortSpcList(spcList);
    }

    private String sortSpcList(List<String> spcList) {
        if (null == spcList || spcList.isEmpty()) {
            return null;
        }
        Collections.sort(spcList);
        String result = "";
        for (String spc : spcList) {
            result = result + "/" + spc;
        }
        return result.substring(1);
    }

    private void saveSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        for (RsSpecValueDomain rsSpecValueDomain : valueList) {
            rsSpecValueDomain.setSpecValueBillno(goodsCode);
        }
        this.rsSpecValueService.saveSpecValueList(valueList);
    }

    @Override
    public void updateSkuState(RsSku rsSku, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == rsSku || null == dataState) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuState", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateStateSkuModel(rsSku.getSkuId(), dataState, oldDataState);
        RsSkuDomain rsSkuDomain = this.makeSkuDomain(rsSku, null);
        if (null == rsSkuDomain) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuState", (Object)"rsSkuDomain is null");
            return;
        }
        if (ResourcesConstants.GOODS_DATA_STATE_NO.equals(dataState)) {
            // empty if block
        }
        if (ResourcesConstants.GOODS_DATA_STATE_0.equals(dataState)) {
            // empty if block
        }
    }

    @Override
    public void updateSku(RsSkuDomain rsSkuDomain) throws ApiException {
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku) {
            oldRsSku = this.getSkuModelByCode(this.getQueryParamMap("tenantCode,skuCode", new Object[]{rsSkuDomain.getTenantCode(), rsSkuDomain.getSkuCode()}));
            if (oldRsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.updateSku.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            rsSkuDomain.setSkuId(oldRsSku.getSkuId());
            rsSkuDomain.setDataOpbillstate(oldRsSku.getDataOpbillstate());
        }
        this.updateComSku(rsSkuDomain, oldRsSku);
    }

    @Override
    public void updateSkuSelective(RsSku rsSku) throws ApiException {
        try {
            if (rsSku.getSkuId() == null) {
                this.logger.error("rs.RsSkuServiceImpl.updateSkuSelective.params.ex", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSku));
                return;
            }
            rsSku.setGmtModified(this.getSysDate());
            this.rsSkuMapper.updateByPrimaryKeySelective(rsSku);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateByPrimaryKeySelective.ex", (Throwable)e);
            throw new ApiException("rs.RsSkuServiceImpl.updateByPrimaryKeySelective.ex", (Throwable)e);
        }
    }

    @Override
    public String updateSkuDataOpnextbillstate(Map<String, Object> map, String dataOpnextbillstate) {
        if (StringUtils.isBlank((String)dataOpnextbillstate) || MapUtil.isEmpty(map) || null == map.get("channelCode") || null == map.get("tenantCode") || null == map.get("skuEocode")) {
            this.logger.error("rs.RsSkuServiceImpl.updateGoodsDataOpbilistState", (Object)(map.toString() + "-" + dataOpnextbillstate));
            return "error";
        }
        String channelCode = (String)map.get("channelCode");
        String tenantCode = (String)map.get("tenantCode");
        Integer state = Integer.valueOf(dataOpnextbillstate);
        List<RsSku> rsSkus = this.querySkuModelPage(map);
        if (ListUtil.isEmpty(rsSkus)) {
            this.logger.error("rs.RsSkuServiceImpl.updateGoodsDataOpbilistState", (Object)(map.toString() + "-" + dataOpnextbillstate));
            return "error";
        }
        for (RsSku rsSku : rsSkus) {
            String s = rsSku.getSkuEocode().split("\\|")[0] + "|";
            if (!tenantCode.equals(rsSku.getTenantCode()) || !channelCode.equals(rsSku.getChannelCode()) || !s.equals(map.get("skuEocode").toString()) || state.equals(rsSku.getDataOpnextbillstate())) continue;
            rsSku.setDataOpnextbillstate(state);
            this.updateSkuModel(rsSku);
        }
        return "success";
    }

    private RsSku updateComSku(RsSkuDomain rsSkuDomain, RsSku oldRsSku) {
        if (null == rsSkuDomain || null == oldRsSku) {
            return null;
        }
        this.makeInfo(rsSkuDomain);
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuUpdataDefault(rsSku);
        this.updateSkuModel(rsSku);
        this.setSkuFile(rsSkuDomain.getRsGoodsFileDomainList(), rsSku);
        this.saveSkuRel(rsSkuDomain);
        this.deltaUpdateSpecList(rsSkuDomain.getSpecList(), rsSku.getGoodsCode());
        return rsSku;
    }

    private void saveSkuRel(RsSkuDomain rsSkuDomain) {
        if (null != rsSkuDomain.getRsGoodsRelDomainList() && rsSkuDomain.getRsGoodsRelDomainList().size() > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsSkuCode", rsSkuDomain.getSkuCode());
            map.put("tenantCode", rsSkuDomain.getTenantCode());
            QueryResult<RsGoodsRel> qrellist = this.rsGoodsOtherService.queryGoodsRelPage(map);
            if (null != qrellist && ListUtil.isNotEmpty((Collection)qrellist.getList())) {
                for (RsGoodsRel rsGoodsRel : qrellist.getList()) {
                    this.rsGoodsOtherService.deleteGoodsRel(rsGoodsRel.getGoodsRelId());
                }
            }
            for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsCode("");
                rsGoodsRelDomain.setGoodsRelId(null);
                rsGoodsRelDomain.setGoodsRelCode(null);
                rsGoodsRelDomain.setGoodsSkuCode(rsSkuDomain.getSkuCode());
                rsGoodsRelDomain.setTenantCode(rsSkuDomain.getTenantCode());
                rsGoodsRelDomain.setMemberCode(rsSkuDomain.getMemberCode());
                rsGoodsRelDomain.setMemberName(rsSkuDomain.getMemberName());
                rsGoodsRelDomain.setMemberCcode(rsSkuDomain.getMemberCcode());
                rsGoodsRelDomain.setMemberCname(rsSkuDomain.getMemberCname());
                rsGoodsRelDomain.setMemberMcode(rsSkuDomain.getMemberMcode());
                rsGoodsRelDomain.setMemberMname(rsSkuDomain.getMemberMname());
                rsGoodsRelDomain.setChannelCode(rsSkuDomain.getChannelCode());
                rsGoodsRelDomain.setChannelName(rsSkuDomain.getChannelName());
                rsGoodsRelDomain.setGoodsClass(rsSkuDomain.getGoodsClass());
            }
            this.rsGoodsOtherService.saveGoodsRelList(rsSkuDomain.getRsGoodsRelDomainList());
        }
    }

    @Override
    public void updateSkuFile(String skuCode, String tenantCode, List<RsGoodsFileDomain> rsGoodsFileDomainList) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || CollectionUtils.isEmpty(rsGoodsFileDomainList)) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuFile param null");
            return;
        }
        Map paramMap = this.getQueryParamMap("skuCode,tenantCode", new Object[]{skuCode, tenantCode});
        RsSku rsSku = this.getSkuModelByCode(paramMap);
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuFile rsSku null");
            return;
        }
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
        String dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            if (null == rsGoodsFileDomain.getDefaultState() || rsGoodsFileDomain.getDefaultState() != ResourcesConstants.FILE_DEFAULTSTATE_1 || !FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            break;
        }
        rsSku.setDataPic(dataPic);
        this.updateSkuModel(rsSku);
    }

    private void deltaUpdateSpecList(List<RsSpecValueDomain> valueList, String goodsCode) {
        if (CollectionUtils.isEmpty(valueList)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Iterator<RsSpecValueDomain> i = valueList.iterator();
        while (i.hasNext()) {
            RsSpecValueDomain valueDomain = i.next();
            valueDomain.setSpecValueBillno(goodsCode);
            params.put("tenantCode", valueDomain.getTenantCode());
            params.put("specValueCode", valueDomain.getSpecValueCode());
            RsSpecValue exist = this.rsSpecValueService.getSpecValueByCode(params);
            if (exist == null) continue;
            this.rsSpecValueService.updateSpecValue(valueDomain);
            i.remove();
        }
        this.saveSpecList(valueList, goodsCode);
    }

    @Override
    public RsSku getSku(Integer skuId) {
        return this.getSkuModelById(skuId);
    }

    @Override
    public void deleteSkuSyn(Integer skuId) {
        RsSku rsSku = this.getSku(skuId);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.rsSku");
        }
        this.deleteSkuModel(skuId);
    }

    @Override
    public void deleteSku(Integer skuId) throws ApiException {
        RsSku rsSku = this.getSku(skuId);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.rsSku");
        }
        this.deleteSkuModel(skuId);
        this.deleteSkuData(rsSku.getSkuCode(), rsSku.getTenantCode());
    }

    private RsSkuDomain makeRsSkuNofileDomain(RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsSkuDomain;
    }

    private List<RsGoodsBuyDomain> makeBuyDomainList(List<RsGoodsBuy> rsGoodsBuylist) {
        if (ListUtil.isEmpty(rsGoodsBuylist)) {
            return null;
        }
        ArrayList<RsGoodsBuyDomain> rsGoodsBuyDomainList = new ArrayList<RsGoodsBuyDomain>();
        for (RsGoodsBuy rsGoodsBuy : rsGoodsBuylist) {
            rsGoodsBuyDomainList.add(this.makeRsGoodsBuyDomain(rsGoodsBuy));
        }
        return rsGoodsBuyDomainList;
    }

    @Override
    public void updateGoodsSupplynum(Map<String, Object> map) throws ApiException {
        if (null == map.get("skuCode")) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSupplynum.skuCode is null");
        }
        try {
            this.rsSkuMapper.updateGoodsSupplynum(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSupplynum.ex", (Throwable)e);
        }
    }

    private RsGoodsBuyDomain makeRsGoodsBuyDomain(RsGoodsBuy rsGoodsBuy) {
        if (null == rsGoodsBuy) {
            return null;
        }
        RsGoodsBuyDomain rsGoodsBuyDomain = new RsGoodsBuyDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsBuyDomain, (Object)rsGoodsBuy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsBuyDomain;
    }

    private RsSkuOneDomain makeRsSKuOneDomain(RsSkuOne rsSkuOne) {
        if (null == rsSkuOne) {
            return null;
        }
        RsSkuOneDomain rsSkuOneDomain = new RsSkuOneDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuOneDomain, (Object)rsSkuOne);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsSkuOneDomain;
    }

    private List<RsGoodsPriceDomain> makePriceDomainList(List<RsGoodsPrice> rsGoodsPricelist) {
        if (ListUtil.isEmpty(rsGoodsPricelist)) {
            return null;
        }
        ArrayList<RsGoodsPriceDomain> rsGoodsPriceDomainList = new ArrayList<RsGoodsPriceDomain>();
        for (RsGoodsPrice rsGoodsPrice : rsGoodsPricelist) {
            rsGoodsPriceDomainList.add(this.makeRsGoodsPriceDomain(rsGoodsPrice));
        }
        return rsGoodsPriceDomainList;
    }

    private RsGoodsPriceDomain makeRsGoodsPriceDomain(RsGoodsPrice rsGoodsPrice) {
        if (null == rsGoodsPrice) {
            return null;
        }
        RsGoodsPriceDomain rsGoodsPriceDomain = new RsGoodsPriceDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsPriceDomain, (Object)rsGoodsPrice);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsPriceDomain;
    }

    private RsSkuDomain makeRsSkuDomain(RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rsSkuDomain.setOldDataState(rsSku.getDataState());
        String falg = this.checkGoodsSku(rsSkuDomain.getTenantCode(), "goodsSku", "goodsSku");
        String goodsSkuNo = this.checkGoodsSku(rsSkuDomain.getTenantCode(), "goodsSkuNo", "goodsSkuNo");
        if (StringUtils.isNotBlank((String)falg) && StringUtils.isNotBlank((String)goodsSkuNo)) {
            this.logger.info("====================>makeRsSkuDomain==");
            return rsSkuDomain;
        }
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("skuOneValueno", rsSku.getSkuCode());
        map3.put("tenantCode", rsSku.getTenantCode());
        QueryResult<RsSkuOne> rone = this.rsSkuOneService.querySkuOnePage(map3);
        if (null != rone && ListUtil.isNotEmpty((Collection)rone.getList())) {
            rsSkuDomain.setRsSkuOneDomain(this.makeRsSKuOneDomain((RsSkuOne)rone.getList().get(0)));
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("skuCode", rsSku.getSkuCode());
        map1.put("tenantCode", rsSku.getTenantCode());
        map1.put("goodsBuyType", "1");
        QueryResult<RsGoodsBuy> qRsGoodsBuyList = this.rsGoodsBuyService.queryGoodsBuyPage(map1);
        if (null != qRsGoodsBuyList && ListUtil.isNotEmpty((Collection)qRsGoodsBuyList.getList())) {
            rsSkuDomain.setRsGoodsBuyDomainList(this.makeBuyDomainList(qRsGoodsBuyList.getList()));
        }
        map1.remove("goodsBuyType");
        map1.put("goodsPriceType", "1");
        QueryResult<RsGoodsPrice> qRsGoodsPriceList = this.rsGoodsPriceService.queryRsGoodsPricePage(map1);
        if (null != qRsGoodsPriceList && ListUtil.isNotEmpty((Collection)qRsGoodsPriceList.getList())) {
            rsSkuDomain.setRsGoodsPriceDomainList(this.makePriceDomainList(qRsGoodsPriceList.getList()));
        }
        map1.remove("goodsPriceType");
        map1.put("order", true);
        map1.put("orderStr", "GOODS_FILE_ID asc");
        QueryResult<RsGoodsFile> rsSkuFileList = this.rsGoodsOtherService.queryGoodsFilePage(map1);
        if (null != rsSkuFileList) {
            rsSkuDomain.setRsGoodsFileDomainList(this.makeFileDomainList(rsSkuFileList.getList()));
        }
        map1.remove("order");
        map1.remove("orderStr");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("goodsSkuCode", rsSku.getSkuCode());
        map2.put("tenantCode", rsSku.getTenantCode());
        QueryResult<RsGoodsRel> rsSkuRelList = this.rsGoodsOtherService.queryGoodsRelPage(map2);
        if (null != rsSkuRelList) {
            rsSkuDomain.setRsGoodsRelDomainList(this.makeRsGoodsRelDomainList(rsSkuRelList.getList()));
        }
        return rsSkuDomain;
    }

    protected String checkGoodsSku(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    private List<RsSkuDomain> makeRsSkuDomainList(List<RsSku> rsSkuList) {
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        for (RsSku rsSku : rsSkuList) {
            RsSkuDomain rsSkuDomain = this.makeRsSkuDomain(rsSku);
            rsSkuDomainList.add(rsSkuDomain);
        }
        return rsSkuDomainList;
    }

    private List<RsSkuReDomain> makeRsSkuDomainListToYS(List<RsSku> rsSkuList) {
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        ArrayList<RsSkuReDomain> rsSkuDomainList = new ArrayList<RsSkuReDomain>();
        for (RsSku rsSku : rsSkuList) {
            RsSkuReDomain rsSkuDomain = this.makeSkuReDomian(rsSku);
            rsSkuDomainList.add(rsSkuDomain);
        }
        return rsSkuDomainList;
    }

    private List<RsGoodsFileDomain> makeFileDomainList(List<RsGoodsFile> rsGoodsFileList) {
        if (ListUtil.isEmpty(rsGoodsFileList)) {
            return null;
        }
        ArrayList<RsGoodsFileDomain> rsGoodsFileDomainList = new ArrayList<RsGoodsFileDomain>();
        for (RsGoodsFile rsGoodsFile : rsGoodsFileList) {
            rsGoodsFileDomainList.add(this.makeRsGoodsFileDomain(rsGoodsFile));
        }
        return rsGoodsFileDomainList;
    }

    private RsGoodsFileDomain makeRsGoodsFileDomain(RsGoodsFile rsGoodsFile) {
        if (null == rsGoodsFile) {
            return null;
        }
        RsGoodsFileDomain rsGoodsFileDomain = new RsGoodsFileDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain, (Object)rsGoodsFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsGoodsFileDomain;
    }

    private List<RsGoodsRelDomain> makeRsGoodsRelDomainList(List<RsGoodsRel> rsGoodsRelList) {
        if (ListUtil.isEmpty(rsGoodsRelList)) {
            return null;
        }
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        for (RsGoodsRel rsGoodsRel : rsGoodsRelList) {
            rsGoodsRelDomainList.add(this.makeRsGoodsRelDomain(rsGoodsRel));
        }
        return rsGoodsRelDomainList;
    }

    private RsGoodsRelDomain makeRsGoodsRelDomain(RsGoodsRel rsGoodsRel) {
        if (null == rsGoodsRel) {
            return null;
        }
        RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain, (Object)rsGoodsRel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RsSku rsSku = this.rsSkuMapper.getByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{rsGoodsRelDomain.getSkuCode(), rsGoodsRelDomain.getTenantCode()}));
        if (null != rsSku) {
            rsGoodsRelDomain.setSkuNo(rsSku.getSkuNo());
        }
        return rsGoodsRelDomain;
    }

    public void setRsGoodsPriceService(RsGoodsPriceService rsGoodsPriceService) {
        this.rsGoodsPriceService = rsGoodsPriceService;
    }

    public RsGoodsBuyService getRsGoodsBuyService() {
        return this.rsGoodsBuyService;
    }

    public void setRsGoodsBuyService(RsGoodsBuyService rsGoodsBuyService) {
        this.rsGoodsBuyService = rsGoodsBuyService;
    }

    @Override
    public QueryResult<RsSkuDomain> querySkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        List<RsSkuDomain> rsSkuDomainList = this.makeRsSkuDomainList(rsSkuList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(ListUtil.isEmpty(rsSkuList) ? 0 : this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuDomainList);
        return queryResult;
    }

    @Override
    public boolean lockGoodsDataByNo(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.lockDataByNo(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.lockGoodsDataByNo", map.toString(), (Throwable)e);
        }
        return i > 0;
    }

    @Override
    public QueryResult<RsSkuReDomain> querySkuPageToYS() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2020050600004084");
        map.put("goodsType", "00");
        map.put("goodsOrigin", "11");
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        List<RsSkuReDomain> rsSkuDomainList = this.makeRsSkuDomainListToYS(rsSkuList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuDomainList);
        return queryResult;
    }

    @Override
    public void updateSkuStockJst(Map<String, Object> map) throws ApiException {
        this.updateSkuStockModelJst(map);
    }

    @Override
    public void updateSkuStockBackJst(Map<String, Object> map) throws ApiException {
        this.updateSkuStockModeBackJst(map);
    }

    @Override
    public List<RsSku> querySkuBomsPageToYS() {
        return null;
    }

    @Override
    public RsSkuDomain getSkuBySkuEocode(String skuEocode, String memberCcode, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCcode) && StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("skuEocode", skuEocode);
        if (StringUtils.isNotBlank((String)memberCcode)) {
            parammap.put("memberCcode", memberCcode);
        } else {
            parammap.put("memberCode", memberCode);
        }
        List<RsSku> rsSkuList = this.querySkuModelPage(parammap);
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        return this.makeRsSkuNofileDomain(rsSkuList.get(0));
    }

    private void updateSkuStockModelJst(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStockJst(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModelJst.ex", map.toString(), (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModelJst.null", map.toString());
        }
    }

    private void updateSkuStockModeBackJst(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStockBackJst(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModeBackJst.ex", map.toString(), (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModeBackJst.null", map.toString());
        }
    }

    @Override
    public QueryResult<RsSku> querySkuOnePage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map) || StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            throw new ApiException("rs.RsSkuServiceImpl.querySkuOnePage.param is null or tenantCode is null ");
        }
        this.logger.info("rs.RsSkuServiceImpl.querySkuOnePage", (Object)JsonUtil.buildNormalBinder().toJson(map));
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        map.remove("startRow");
        map.remove("rows");
        pageTools.setRecordCount(this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public QueryResult<RsSku> querySkuByPage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map) || StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            throw new ApiException("rs.RsSkuServiceImpl.querySkuByPage.param is null or tenantCode is null ");
        }
        this.logger.info("rs.RsSkuServiceImpl.querySkuByPage", (Object)JsonUtil.buildNormalBinder().toJson(map));
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        map.remove("startRow");
        map.remove("rows");
        pageTools.setRecordCount(this.countSkuRecord(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public RsSku getSkuBySpec(List<String> spcList, String goodsCode, String tenantCode) {
        if (null == spcList || spcList.isEmpty() || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String skuName = this.sortSpcList(spcList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuName", skuName);
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("order", true);
        map.put("orderStr", " GOODS_SUPPLYNUM desc");
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (null == rsSkuList || rsSkuList.isEmpty()) {
            return null;
        }
        return rsSkuList.get(0);
    }

    @Override
    public RsSku getSkuBySkuName(String skuName, String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuName) || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuName", skuName);
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (null == rsSkuList || rsSkuList.isEmpty()) {
            return null;
        }
        return rsSkuList.get(0);
    }

    @Override
    public RsSku getSkuByCode(Map<String, Object> map) {
        RsSku rsSku = this.getSkuModelByCode(map);
        return rsSku;
    }

    @Override
    public RsSkuDomain getSkuDomainByCode(Map<String, Object> map) {
        RsSku rsSku = this.getSkuModelByCode(map);
        return this.makeRsSkuDomain(rsSku);
    }

    @Override
    public List<RsSku> checkSkuNo(String skuNo, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.checkSkuNo.param.null");
        }
        return this.rsSkuMapper.query(this.getQueryMapParam("skuNo,tenantCode", new Object[]{skuNo, tenantCode}));
    }

    @Override
    public void delSkuByCode(Map<String, Object> map) throws ApiException {
        RsSku rsSku = this.getSkuModelByCode(map);
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.delSkuByCode.rsSku");
        }
        this.delSkuModelByCode(map);
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        map.put("goodsSkuCode", rsSku.getSkuCode());
        map.remove("skuCode");
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
    }

    @Override
    public void deleteSkuList(List<Integer> skuIds) throws ApiException {
        if (skuIds == null || skuIds.isEmpty()) {
            return;
        }
        for (Integer skuId : skuIds) {
            this.deleteSku(skuId);
        }
    }

    @Override
    public void updateAhSkuList(List<RsSkuDomain> skuList) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        ArrayList<RsSku> rsSkus = new ArrayList<RsSku>();
        for (RsSkuDomain rsSkuDomain : skuList) {
            RsSku rsSku = new RsSku();
            this.makeSku(rsSkuDomain, rsSku);
            rsSkus.add(rsSku);
        }
        this.updateAh(rsSkus);
    }

    public void updateAhSku(RsSkuDomain rsSkuDomain) {
        String msg = this.checkSku(rsSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhSku.checkSku", msg);
        }
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_0 && oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_3 && oldRsSku.getDataState() != ResourcesConstants.GOODS_DATA_STATE_4) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhResource.dataState error", "\u72b6\u6001\u9519\u8bef");
        }
        RsSku rsSku = this.makeSku(rsSkuDomain, oldRsSku);
        this.setSkuUpdataDefault(rsSku);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_1);
        rsSku.setSkuSort(null);
        this.updateSkuModelWithNull(rsSku);
    }

    @Override
    public void updateCannelSkuList(List<Integer> skuIds) throws ApiException {
        this.updateCannelSkuList(skuIds, false);
    }

    @Override
    public void updateGoodsCannelSkuList(List<Integer> skuIds) throws ApiException {
        this.updateCannelSkuList(skuIds, true);
    }

    public void updateCannelSkuList(List<Integer> skuIds, boolean disflag) throws ApiException {
        if (ListUtil.isEmpty(skuIds)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateAhResource.dataState error", "skuIds is null");
        }
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (ListUtil.isEmpty(skuList)) {
            return;
        }
        this.updateCannel(skuList);
    }

    public RsResourceGoodsReDomain makeReDomian(RsResourceGoods rsResourceGoods) {
        if (null == rsResourceGoods) {
            return null;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = new RsResourceGoodsReDomain();
        try {
            BeanUtils.copyImplPropertys((Object)rsResourceGoodsReDomain, (Object)rsResourceGoods);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsResourceGoodsReDomain;
    }

    public RsSkuReDomain makeSkuReDomian(RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        RsSkuReDomain rsSkuReDomain = new RsSkuReDomain();
        try {
            BeanUtils.copyImplPropertys((Object)rsSkuReDomain, (Object)rsSku);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsSkuReDomain;
    }

    private void updateCannel(List<RsSku> skuList) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateCannelMode(rsSku, false);
        }
    }

    private void updateCannelMode(RsSku rsSku, boolean dataState) {
        if (null == rsSku) {
            return;
        }
        BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
        BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
        rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsSupplynum));
        if (goodsSupplyweight != null) {
            rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsSupplyweight));
        }
        rsSku.setGoodsHangnum(rsSku.getGoodsHangnum().subtract(goodsSupplynum));
        if (goodsSupplyweight != null) {
            rsSku.setGoodsHangweight(rsSku.getGoodsHangweight().subtract(goodsSupplyweight));
        }
        rsSku.setGoodsSupplynum(BigDecimal.ZERO);
        rsSku.setGoodsSupplyweight(BigDecimal.ZERO);
        rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
        if (dataState) {
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_3);
        }
        rsSku.setDataOpbillstate(ResourcesConstants.DATA_OPBILLSTATE_0);
        this.updateSkuModel(rsSku);
    }

    @Override
    public void updateAuditSkuPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, false);
    }

    private void updateAuditPass(List<RsSku> skuList, boolean put) {
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateAuditModel(rsSku, put);
        }
    }

    @Override
    public void updateDisCannelSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        List<RsSku> skuList;
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("skuOldcode", skuOldcode);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (null == (skuList = this.querySkuModelPage(parammap)) || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            this.updateCannelMode(rsSku, true);
        }
    }

    private void updateAuditModel(RsSku rsSku, boolean put) {
        this.setAuditModel(rsSku, put);
        this.updateSkuModel(rsSku);
    }

    private void setAuditModel(RsSku rsSku, boolean put) {
        if (null == rsSku) {
            return;
        }
        rsSku.setSkuHdate(this.getSysDate());
    }

    @Override
    public void updateAuditSkuNoPass(List<Integer> skuIds) {
        List<RsSku> skuList = this.checkAuditSku(skuIds);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        for (RsSku rsSku : skuList) {
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            rsSku.setGoodsNum(rsSku.getGoodsNum().add(goodsAhnum));
            if (goodsAhweight == null) {
                rsSku.setGoodsWeight(rsSku.getGoodsWeight().add(goodsAhweight));
            }
            rsSku.setGoodsAhnum(BigDecimal.ZERO);
            rsSku.setGoodsAhweight(BigDecimal.ZERO);
            rsSku.setDataState(ResourcesConstants.GOODS_DATA_STATE_0);
            this.updateSkuModel(rsSku);
        }
    }

    private List<RsSku> checkAuditSku(List<Integer> skuIds) {
        if (skuIds == null || skuIds.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsSku> skuList = new ArrayList<RsSku>();
        for (Integer skuId : skuIds) {
            RsSku rsSku = this.getSkuModelById(skuId);
            if (rsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.getSkuModelById.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            skuList.add(rsSku);
        }
        return skuList;
    }

    private List<RsSku> checkAuditSku(String goodsCode, String tenantCode) {
        if (goodsCode == null || goodsCode.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.goodsCode", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", 0);
        List<RsSku> skuList = this.rsSkuMapper.query(map);
        if (ListUtil.isEmpty(skuList)) {
            throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.skuList", "\u6570\u636e\u4e3a\u7a7a:" + ((Object)map).toString());
        }
        String mschannelName = null;
        String mschannelCode = null;
        map.remove("dataOpbillstate");
        for (RsSku rsSku : skuList) {
            if (rsSku == null) {
                throw new ApiException("rs.RsSkuServiceImpl.checkAuditSku.rsSku", "\u6570\u636e\u4e3a\u7a7a");
            }
            BigDecimal goodsNum = rsSku.getGoodsNum();
            BigDecimal goodsWeight = rsSku.getGoodsWeight();
            BigDecimal goodsAhnum = rsSku.getGoodsAhnum();
            BigDecimal goodsAhweight = rsSku.getGoodsAhweight();
            BigDecimal goodsSupplynum = rsSku.getGoodsSupplynum();
            BigDecimal goodsSupplyweight = rsSku.getGoodsSupplyweight();
            BigDecimal goodsHangnum = rsSku.getGoodsHangnum();
            BigDecimal goodsHangweight = rsSku.getGoodsHangweight();
            rsSku.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
            rsSku.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
            rsSku.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
            rsSku.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
            rsSku.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
            rsSku.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
            rsSku.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
            rsSku.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
            rsSku.setMschannelCode(mschannelCode);
            rsSku.setMschannelName(mschannelName);
        }
        return skuList;
    }

    @Override
    public void querySkuAll(Map<String, Object> map) {
        if (map != null) {
            map.put("dataOpbillstate", 1);
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType("insert");
        storeDomain.setBizType("sku");
        storeDomain.setStoreObj((Object)JsonUtil.buildNormalBinder().jsonObject(this.queryforEs(map)));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        this.getInternalRouter().inAsyncInvoke("es.searchengine.store", "1.0", "0", paramMap);
    }

    private List<EsSku> queryforEs(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return this.rsSkuMapper.queryForEs(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.queryforEs.error", e.getMessage());
        }
    }

    @Override
    public void updateAhSkuListByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("tenantCode", tenantCode);
        parammap.put("goodsCode", goodsCode);
        parammap.put("dataState", 0);
        List<RsSku> skuList = this.querySkuModelPage(parammap);
        this.updateAh(skuList);
    }

    private void updateAh(List<RsSku> skuList) {
        if (null == skuList || skuList.isEmpty()) {
            return;
        }
        List skuDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(skuList), RsSkuDomain.class);
        for (RsSkuDomain rsSkuDomain : skuDomainList) {
            this.updateAhModel(rsSkuDomain);
        }
    }

    protected void updateAhModel(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            return;
        }
        BigDecimal goodsNum = rsSkuDomain.getGoodsNum();
        BigDecimal goodsWeight = rsSkuDomain.getGoodsWeight();
        goodsNum = goodsNum == null ? BigDecimal.ZERO : goodsNum;
        goodsWeight = goodsWeight == null ? BigDecimal.ZERO : goodsWeight;
        rsSkuDomain.setGoodsAhnum(goodsNum);
        rsSkuDomain.setGoodsAhweight(goodsWeight);
        rsSkuDomain.setGoodsNum(goodsNum.subtract(goodsNum));
        rsSkuDomain.setGoodsWeight(goodsWeight.subtract(goodsWeight));
        this.updateAhSku(rsSkuDomain);
    }

    @Override
    public void updateAuditSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        List<RsSku> skuList = this.checkAuditSku(goodsCode, tenantCode);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, false);
    }

    @Override
    public void updatetSkuPassByGoodsCode(String goodsCode, String tenantCode) {
        List<RsSku> skuList = this.checkAuditSku(goodsCode, tenantCode);
        if (skuList == null || skuList.isEmpty()) {
            return;
        }
        this.updateAuditPass(skuList, true);
    }

    @Override
    public void updateSkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuByGoodsCode.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            this.rsSkuMapper.updateByGoods(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode}));
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuByGoodsCode.ex", (Throwable)e);
        }
    }

    @Override
    public void updateSkuGoodsNumByGoodsCode(BigDecimal goodsNum, String goodsCode, String tenantCode) {
        if (goodsNum == null || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.ex", "param is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsNum", goodsNum);
        map.put("skuCode", goodsCode);
        map.put("tenantCode", tenantCode);
        this.updateSkuGoodsNumByGoodsCode(map);
    }

    private void updateSkuGoodsNumByGoodsCode(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuGoodsNumByGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuGoodsNumByGoodsCode.null");
        }
    }

    private List<RsSku> queryDisSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int countDisSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.countDisSku(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<RsSku> queryDisSkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.queryDisSku(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDisSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuList);
        return queryResult;
    }

    @Override
    public QueryResult<RsSku> queryDisAndSkuPage(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.queryDisAndSkuCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(this.queryDisAndSku(map));
        return queryResult;
    }

    private List<RsSku> queryDisAndSku(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.queryDisAndSku(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuModel", (Throwable)e);
            return null;
        }
    }

    private int queryDisAndSkuCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.queryDisAndSkuCount(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSku", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateSkuList(List<RsSkuDomain> rsSkuList) throws ApiException {
        if (rsSkuList == null || rsSkuList.isEmpty()) {
            return;
        }
        for (RsSkuDomain rsSkuDomain : rsSkuList) {
            this.updateSku(rsSkuDomain);
        }
    }

    @Override
    public List<RsSku> querySkuByPntreeCode(Map<String, Object> map) {
        try {
            return this.rsSkuMapper.querySkuByPntree(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuByPntreeCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateSkuSortNo(String tenantCode, String goodsCode, String skuCode, Integer sortNo) {
        this.updateSortNoSkuModel(tenantCode, goodsCode, skuCode, sortNo);
    }

    private void updateSortNoSkuModel(String tenantCode, String goodsCode, String skuCode, Integer sortNo) throws ApiException {
        if (StringUtil.isBlank((String)tenantCode) || StringUtil.isBlank((String)goodsCode) && StringUtil.isBlank((String)skuCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", goodsCode);
        map.put("skuCode", skuCode);
        map.put("gmtModified", this.getSysDate());
        map.put("sortNo", sortNo);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSortNoSku(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSortNoSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSortNoSkuModel.null");
        }
    }

    private void updateSkuStockModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStock(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.ex", map.toString(), (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.null", map.toString());
        }
    }

    private int updateSkuStock1BatchModel(List<ResourceStockDomain> newResourceGoodsList) {
        if (ListUtil.isEmpty(newResourceGoodsList)) {
            return -1;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStock1Batch(newResourceGoodsList, newResourceGoodsList.get(0).getEditWay(), newResourceGoodsList.get(0).getType(), newResourceGoodsList.get(0).getTenantCode());
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockModel.null");
        }
        return i;
    }

    @Override
    public void updateSkuStock(Map<String, Object> map) throws ApiException {
        this.updateSkuStockModel(map);
    }

    @Override
    public void updateSkuStockBatch(List<ResourceStockDomain> newResourceGoodsList) throws ApiException {
        if (ListUtil.isEmpty(newResourceGoodsList)) {
            return;
        }
        int i = this.updateSkuStock1BatchModel(newResourceGoodsList);
        if (i != newResourceGoodsList.size()) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStockBatch.null");
        }
    }

    @Override
    public List<RsSku> querySkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        return this.querySkuModelPage(map);
    }

    @Override
    public void updateSkuEditOne(EditSkuDomain editSkuDomain) {
        if (null == editSkuDomain) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit", "editSkuDomain/oldRsSku is null");
        }
        String msg = this.checkSkuEdit(editSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit.checkSku", msg);
        }
        this.updateEditSku(editSkuDomain);
    }

    @Override
    public List<RsSenddataDomain> updateSkuEdit(EditSkuDomain editSkuDomain, RsResourceGoods rsResourceGoods) {
        if (null == editSkuDomain || null == rsResourceGoods) {
            return null;
        }
        this.updateSkuEditOne(editSkuDomain);
        RsSku oldRsSku = StringUtils.isBlank((String)editSkuDomain.getSkuCode()) ? this.getSku(editSkuDomain.getSkuId()) : this.getSkuByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{editSkuDomain.getSkuCode(), editSkuDomain.getTenantCode()}));
        if (oldRsSku == null) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit.RsSku", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.saveSkufile(editSkuDomain.getRsSkuFileDomainList(), oldRsSku);
        this.saveSkuBuy(editSkuDomain.getRsGoodsBuyDomainList(), oldRsSku);
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        rsSkuList.add(oldRsSku);
        List<RsSenddataDomain> rsSenddataList = this.saveSenddata(rsSkuList, "edit", editSkuDomain.getGoodsEocode(), null, editSkuDomain.getSkuEdit(), editSkuDomain.getGoodsEdit());
        String parentCode = null;
        if (null == rsSenddataList) {
            rsSenddataList = new ArrayList<RsSenddataDomain>();
        } else if (ListUtil.isNotEmpty(rsSenddataList)) {
            parentCode = rsSenddataList.get(0).getSenddataCode();
        }
        this.saveMinNum(rsResourceGoods, oldRsSku, rsSenddataList, parentCode);
        return rsSenddataList;
    }

    @Override
    public List<RsSenddataDomain> updateSkuEditNew(EditSkuDomain editSkuDomain, RsResourceGoods rsResourceGoods, RsSku oldRsSku) {
        if (null == editSkuDomain || null == rsResourceGoods) {
            return null;
        }
        this.updateSkuEditOne(editSkuDomain);
        if (oldRsSku == null) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEdit.RsSku", "\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        rsSkuList.add(oldRsSku);
        List<RsSenddataDomain> rsSenddataList = this.saveSenddata(rsSkuList, "edit", editSkuDomain.getGoodsEocode(), null, editSkuDomain.getSkuEdit(), editSkuDomain.getGoodsEdit());
        String parentCode = null;
        if (null == rsSenddataList) {
            rsSenddataList = new ArrayList<RsSenddataDomain>();
        } else if (ListUtil.isNotEmpty(rsSenddataList)) {
            parentCode = rsSenddataList.get(0).getSenddataCode();
        }
        this.saveMinNum(rsResourceGoods, oldRsSku, rsSenddataList, parentCode);
        return rsSenddataList;
    }

    private void saveMinNum(RsResourceGoods rsResourceGoods, RsSku oldRsSku, List<RsSenddataDomain> rsSenddataList, String senddataParentcode) {
        List<RsSenddataDomain> rlist;
        if (null == rsSenddataList || null == rsResourceGoods || null == oldRsSku || null == oldRsSku.getDataOpbillstate()) {
            return;
        }
        DisChannel disChannel = this.getChannel(oldRsSku.getChannelCode(), oldRsSku.getTenantCode());
        if (null == disChannel) {
            return;
        }
        if (oldRsSku.getDataOpbillstate().intValue() == ResourcesConstants.DATA_OPBILLSTATE_1.intValue()) {
            List<RsSenddataDomain> rlist2;
            if (this.makeNum(rsResourceGoods, oldRsSku, disChannel, false) && ListUtil.isNotEmpty(rlist2 = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_4, oldRsSku.getDataState(), oldRsSku.getSkuCode(), oldRsSku.getTenantCode(), rsResourceGoods, false, senddataParentcode))) {
                rsSenddataList.addAll(rlist2);
            }
        } else if (ResourcesConstants.GOODS_DATA_STATE_4.intValue() == oldRsSku.getDataState().intValue() && this.makeNum(rsResourceGoods, oldRsSku, disChannel, true) && ListUtil.isNotEmpty(rlist = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_2, oldRsSku.getDataState(), oldRsSku.getSkuCode(), oldRsSku.getTenantCode(), rsResourceGoods, false, senddataParentcode))) {
            rsSenddataList.addAll(rlist);
        }
    }

    private RsSkuDomain makeSkuDomain(RsSku oldRsSku, RsSkuDomain rsSkuDomain) {
        if (null == oldRsSku) {
            return null;
        }
        if (null == rsSkuDomain) {
            rsSkuDomain = new RsSkuDomain();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)rsSkuDomain, (Object)oldRsSku);
            return rsSkuDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.makeRsSkuDomain", (Throwable)e);
            return rsSkuDomain;
        }
    }

    private void updateEditSku(EditSkuDomain editSkuDomain) throws ApiException {
        if (null == editSkuDomain) {
            return;
        }
        try {
            this.rsSkuMapper.updateEditSku(editSkuDomain);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateEditSku.ex", (Throwable)e);
        }
    }

    private String checkSkuEdit(EditSkuDomain editSkuDomain) {
        if (null == editSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)editSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getSkuCode())) {
            msg = msg + "skuCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)editSkuDomain.getGoodsCode())) {
            msg = msg + "goodsCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    @Override
    public RsSku getRsSkuModelByOldCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.getByOldCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.getRsSkuModelByOldCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<RsSenddataDomain> updateDisAuditSku(RsSkuDomain rsSkuDomain, RsResourceGoods rsResourceGoods, String dgoodsPut) throws ApiException {
        if (null == rsSkuDomain || null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.updateDisAuditSku.rsSkuDomain.null");
        }
        RsSku oldRsSku = this.getSkuModelById(rsSkuDomain.getSkuId());
        if (null == oldRsSku && (oldRsSku = this.getSkuModelByCode(this.getQueryParamMap("tenantCode,skuCode", new Object[]{rsSkuDomain.getTenantCode(), rsSkuDomain.getSkuCode()}))) == null) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        rsSkuDomain.setDataOpnextbillstate(0);
        rsSkuDomain.setGoodsSp(oldRsSku.getGoodsSp());
        rsSkuDomain.setSkuId(oldRsSku.getSkuId());
        rsSkuDomain.setOldDataState(oldRsSku.getDataState());
        rsSkuDomain.setDataOpbillstate(oldRsSku.getDataOpbillstate());
        Integer oldDataState = oldRsSku.getDataState();
        oldRsSku = this.updateComSku(rsSkuDomain, oldRsSku);
        List<RsSenddataDomain> skuRsSenddataList = null;
        this.logger.debug("rs.RsSkuServiceImpl.updateDisAuditSku", (Object)("dgoodsPut" + dgoodsPut + "skuCode" + oldRsSku.getSkuCode()));
        if ("1".equals(dgoodsPut) && oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_3.intValue()) {
            skuRsSenddataList = this.updatetSkuPassBySkuCodeNew(ResourcesConstants.GOODS_DATA_STATE_2, oldDataState, oldRsSku.getSkuCode(), oldRsSku.getTenantCode(), rsResourceGoods);
        }
        return skuRsSenddataList;
    }

    private void setSkuFile(List<RsGoodsFileDomain> rsGoodsFileDomainList, RsSku rsSku) {
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.setSkuFile.param.null");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("skuCode", rsSku.getSkuCode());
        paramMap.put("tenantCode", rsSku.getTenantCode());
        this.rsGoodsOtherService.delGoodsFileBySkuCode(paramMap);
        if (ListUtil.isEmpty(rsGoodsFileDomainList)) {
            return;
        }
        String dataPic = rsGoodsFileDomainList.get(0).getGoodsFileUrl();
        boolean picflag = false;
        if (!FileType.fileTypepic((String)dataPic)) {
            picflag = true;
        }
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            if (StringUtils.isBlank((String)rsGoodsFileDomain.getGoodsFileUrl())) continue;
            if (picflag && FileType.fileTypepic((String)rsGoodsFileDomain.getGoodsFileUrl())) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
                picflag = false;
            }
            rsGoodsFileDomain.setTenantCode(rsSku.getTenantCode());
            rsGoodsFileDomain.setMemberCode(rsSku.getMemberCode());
            rsGoodsFileDomain.setMemberName(rsSku.getMemberName());
            rsGoodsFileDomain.setSkuCode(rsSku.getSkuCode());
            rsGoodsFileDomain.setGoodsCode(null);
            rsGoodsFileDomain.setGoodsFileId(null);
            rsGoodsFileDomain.setGoodsFileCode(null);
            if (rsGoodsFileDomain.getDefaultState() != null && rsGoodsFileDomain.getDefaultState() == 1) {
                dataPic = rsGoodsFileDomain.getGoodsFileUrl();
            }
            rsSku.setDataPic(dataPic);
        }
        this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
    }

    @Override
    public void updateSoldOutSku(RsSku rsSku) {
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSoldOutSku.null");
        }
        this.updateCannelSku(rsSku.getSkuCode(), rsSku.getTenantCode());
        rsSku = this.getSku(rsSku.getSkuId());
    }

    @Override
    public void updateShelveSku(RsSku rsSku) {
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.updateShelveSku.null");
        }
        this.updatetSkuShelveBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
        rsSku = this.getSkuByCode(this.getQueryParamMap("skuCode,tenantCode", new Object[]{rsSku.getSkuCode(), rsSku.getTenantCode()}));
        if (rsSku == null) {
            throw new ApiException("rs.RsSkuServiceImpl.updateShelveSku.null");
        }
    }

    @Override
    public void updateSkuStateBySkuId(RsSku rsSku, Integer dataState, Integer oldState) {
        if (null == rsSku || null == dataState) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateBySkuId.null");
        }
        this.updateSkuStateBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode(), dataState, null, null);
        rsSku.setDataState(dataState);
    }

    @Override
    public void deleteSkuByCode(RsSku rsSku) {
        if (null == rsSku) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSku.null");
        }
        this.deleteSkuBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
    }

    @Override
    public List<RsSkuDomain> queryHotSkuList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        return this.queryHotGoods(map);
    }

    public List<RsSkuDomain> queryHotGoods(Map<String, Object> map) {
        String rsSkuDomainrList = "";
        try {
            rsSkuDomainrList = (String)this.getInternalRouter().inInvoke("omns.mb.sendqueryGoodsList", map);
            if (StringUtils.isBlank((String)rsSkuDomainrList)) {
                this.logger.error("rs.RsSkuServiceImpl.queryHotSkuList.queryHotGoods.getInternalRouter", (Object)("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map\uff1a" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.queryHotSkuList.queryHotGoods.getInternalRouter.e", (Object)("\u8c03\u7528\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570map\uff1a" + map));
            return null;
        }
        List rsSkuDomainList = JsonUtil.buildNonDefaultBinder().getJsonToList(rsSkuDomainrList, RsSkuDomain.class);
        return rsSkuDomainList;
    }

    @Override
    public void updatetSkuSoldOutByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.RsSkuServiceImpl.updateShelveSku", (Object)"goodsCode is null");
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_1);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(map);
        if (ListUtil.isEmpty(rsSkus)) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.updateCannelSku(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
    }

    @Override
    public void updatetSkuShelveByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuShelveByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(map);
        if (ListUtil.isEmpty(rsSkus)) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuSoldOutByGoodsCode.", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.updatetSkuShelveBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
    }

    @Override
    public void updateSkuStateByGoodsCode(Map<String, Object> parammap) {
        if (null == parammap || parammap.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "parammap is null");
        }
        Integer dataState = (Integer)parammap.remove("dataState");
        if (null == dataState) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "dataState is null");
        }
        parammap.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(parammap);
        if (ListUtil.isEmpty(rsSkus)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.updateSkuStateBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode(), dataState, null, null);
        }
    }

    @Override
    public void deleteSkuByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", ResourcesConstants.DATA_OPBILLSTATE_0);
        List<RsSku> rsSkus = this.querySkuByGoodsCodeAndState(map);
        if (ListUtil.isEmpty(rsSkus)) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuByGoodsCode.", "rsSkus is null");
        }
        for (RsSku rsSku : rsSkus) {
            this.deleteSkuBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
    }

    private boolean deleteSkuBySkuCode(String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuBySkuCode", "skuCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.rsSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuBySkuCode", ((Object)map).toString(), (Throwable)e);
        }
        return i > 0;
    }

    private boolean deleteSkuModelByGoodsCode(String goodsCode, String tenantCode) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModelByGoodsCode", "goodsCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.rsSkuMapper.delByGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.deleteSkuModelByGoodsCode", ((Object)map).toString(), (Throwable)e);
        }
        return i > 0;
    }

    private boolean updateSkuStateBySkuCode(String skuCode, String tenantCode, Integer dataState, Integer dataOpbillstate, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateBySkuCode", "parammap is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("dataOpbillstate", dataOpbillstate);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStateBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateBySkuCode", (Throwable)e);
        }
        return i > 0;
    }

    public boolean updateSkuStateByGoodsCode(String goodsCode, String tenantCode, Integer dataState, Integer dataOpbillstate, Integer oldDataState, String oldDataStateStr) {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", "parammap is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("dataOpbillstate", dataOpbillstate);
        map.put("oldDataStateStr", oldDataStateStr);
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSkuStateByGoodsCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuStateByGoodsCode", (Throwable)e);
        }
        return i > 0;
    }

    private void updatetSkuShelveBySkuCode(String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuShelveBySkuCode.null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.updatetSkuPassBySkuCode(map);
    }

    private void updatetSkuPassBySkuCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeMap is null");
        }
        try {
            this.rsSkuMapper.updatetSkuPassBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImplupdatetSkuShelveBySkuCode.", (Throwable)e);
        }
    }

    private void updateCannelSku(String skuCode, String tenantCode) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateCannelSku.null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.updateCannelSkuBySkuCode(map);
    }

    private void updateCannelSkuBySkuCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuCannel.map is null");
        }
        try {
            this.rsSkuMapper.updateCannelSkuBySkuCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.updateSkuCannel", (Throwable)e);
        }
    }

    private List<RsSku> querySkuByGoodsCodeAndState(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuMapper.querySkuByGoodsCodeAndState(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuByGoodsCodeAndState", (Throwable)e);
            return null;
        }
    }

    private void makeDefSku(RsSku rsResourceGoods) {
        if (null == rsResourceGoods) {
            return;
        }
        BigDecimal goodsNum = rsResourceGoods.getGoodsNum();
        BigDecimal goodsWeight = rsResourceGoods.getGoodsWeight();
        BigDecimal goodsAhnum = rsResourceGoods.getGoodsAhnum();
        BigDecimal goodsAhweight = rsResourceGoods.getGoodsAhweight();
        BigDecimal goodsSupplynum = rsResourceGoods.getGoodsSupplynum();
        BigDecimal goodsSupplyweight = rsResourceGoods.getGoodsSupplyweight();
        BigDecimal goodsHangnum = rsResourceGoods.getGoodsHangnum();
        BigDecimal goodsHangweight = rsResourceGoods.getGoodsHangweight();
        rsResourceGoods.setPricesetMakeprice(rsResourceGoods.getPricesetMakeprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetMakeprice());
        rsResourceGoods.setPricesetBaseprice(rsResourceGoods.getPricesetBaseprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetBaseprice());
        rsResourceGoods.setPricesetAsprice(rsResourceGoods.getPricesetAsprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetAsprice());
        rsResourceGoods.setPricesetPrefprice(rsResourceGoods.getPricesetPrefprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetPrefprice());
        rsResourceGoods.setPricesetRefrice(rsResourceGoods.getPricesetRefrice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetRefrice());
        rsResourceGoods.setPricesetInsideprice(rsResourceGoods.getPricesetInsideprice() == null ? BigDecimal.ZERO : rsResourceGoods.getPricesetInsideprice());
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsNum(goodsNum == null ? BigDecimal.ZERO : goodsNum);
        rsResourceGoods.setGoodsWeight(goodsWeight == null ? BigDecimal.ZERO : goodsWeight);
        rsResourceGoods.setGoodsAhnum(goodsAhnum == null ? BigDecimal.ZERO : goodsAhnum);
        rsResourceGoods.setGoodsAhweight(goodsAhweight == null ? BigDecimal.ZERO : goodsAhweight);
        rsResourceGoods.setGoodsSupplynum(goodsSupplynum == null ? BigDecimal.ZERO : goodsSupplynum);
        rsResourceGoods.setGoodsSupplyweight(goodsSupplyweight == null ? BigDecimal.ZERO : goodsSupplyweight);
        rsResourceGoods.setGoodsHangnum(goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum);
        rsResourceGoods.setGoodsHangweight(goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight);
    }

    @Override
    public RsSku getSkuBySkuNo(String skuNo, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        return this.getSkuBySkuNoType(skuNo, memberCode, memberCcode, channelCode, null, tenantCode);
    }

    @Override
    public RsSku getSkuByMcodeSkuNo(String skuNo, String memberMcode, String memberCode, String memberCcode, String channelCode, String tenantCode) {
        return this.getSkuBySkuNoType(skuNo, memberMcode, memberCode, memberCcode, channelCode, null, tenantCode);
    }

    @Override
    public RsSku getSkuBySkuNoType(String skuNo, String memberCode, String memberCcode, String channelCode, String goodsType, String tenantCode) {
        return this.getSkuBySkuNoType(skuNo, null, memberCode, memberCcode, channelCode, goodsType, tenantCode);
    }

    public RsSku getSkuBySkuNoType(String skuNo, String memberMcode, String memberCode, String memberCcode, String channelCode, String goodsType, String tenantCode) {
        Map map = this.getQueryParamMap("skuNo,memberMcode,memberCcode,memberCode,channelCode,goodsType,tenantCode", new Object[]{skuNo, memberMcode, memberCcode, memberCode, channelCode, goodsType, tenantCode});
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (ListUtil.isEmpty(rsSkuList)) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuBySkuNoType,rsSkuList", (Object)map.toString());
            return null;
        }
        if (null == channelCode) {
            channelCode = "";
        }
        for (RsSku rsSku : rsSkuList) {
            if (null == rsSku.getChannelCode()) {
                rsSku.setChannelCode("");
            }
            if (!channelCode.equals(rsSku.getChannelCode())) continue;
            return rsSku;
        }
        return null;
    }

    @Override
    public RsSku getSkuBySkuNoAndMemberCode(String skuNo, String memberCode, String tenantCode) {
        List<RsSku> rsSkuList = this.querySkuModelPage(this.getQueryParamMap("skuNo,memberCode,tenantCode", new Object[]{skuNo, memberCode, tenantCode}));
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        for (RsSku rsSku : rsSkuList) {
            if ("18".equals(rsSku.getGoodsOrigin())) continue;
            return rsSku;
        }
        return null;
    }

    @Override
    public void updateSkuEocode(String skuCode, String skuEocode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocode.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("skuEocode", skuEocode);
        map.put("tenantCode", tenantCode);
        this.updateSkuEocodeModelByCode(map);
    }

    @Override
    public void updateSkuEocodeByNo(String skuNo, String memberCcode, String skuEocode, String channelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)skuEocode) || StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuEocodeByNo.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuNo", skuNo);
        map.put("skuEocode", skuEocode);
        map.put("memberCcode", memberCcode);
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        this.updateSkuEocodeModelByCode(map);
    }

    @Override
    public void updateVerByNo(String skuNo, String memberCcode, Integer channelTver, String channelCode, String tenantCode) throws ApiException {
        if (null == channelTver || StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateVerByNo.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuNo", skuNo);
        map.put("channelTver", channelTver);
        map.put("memberCcode", memberCcode);
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        this.updateSkuEocodeModelByCode(map);
    }

    @Override
    public List<RsSenddataDomain> deleteSkuByGoodsCodeNew(String goodsCode, String tenantCode, List<RsSku> rsSkuList) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode) || ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        if (!this.deleteSkuModelByGoodsCode(goodsCode, tenantCode)) {
            return null;
        }
        for (RsSku rsSku : rsSkuList) {
            this.deleteSkuData(rsSku.getSkuCode(), tenantCode);
        }
        return null;
    }

    @Override
    public List<RsSenddataDomain> deleteSkuByGoodsCodeNoNew(String goodsCode, String tenantCode, String goodsEocode, Map<String, String> skuCodeMap) {
        if (StringUtil.isBlank((String)goodsCode) || StringUtil.isBlank((String)tenantCode)) {
            return null;
        }
        List<RsSku> rsSkuList = this.querySkuByGoodsCode(goodsCode, tenantCode);
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        ArrayList<RsSenddataDomain> relist = new ArrayList<RsSenddataDomain>();
        for (RsSku rsSku : rsSkuList) {
            if (MapUtil.isNotEmpty(skuCodeMap) && StringUtils.isNotBlank((String)skuCodeMap.get(rsSku.getSkuCode()))) continue;
            this.deleteSkuModel(rsSku.getSkuId());
            this.deleteSkuData(rsSku.getSkuCode(), rsSku.getTenantCode());
        }
        return relist;
    }

    @Override
    public List<RsSenddataDomain> deleteSkuBySkuCodeNew(RsSkuDomain rsSkuDomain, RsResourceGoods rsResourceGoods) {
        if (null == rsSkuDomain || null == rsResourceGoods) {
            return null;
        }
        RsSku rsSku = new RsSku();
        try {
            BeanUtils.copyAllPropertys((Object)rsSku, (Object)rsSkuDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.deleteSkuBySkuCode(rsSku.getSkuCode(), rsSku.getTenantCode())) {
            this.logger.error("rs.RsSkuServiceImpl.deleteSkuBySkuCodeNew.false", (Object)(rsSku.getSkuCode() + "=" + rsSku.getTenantCode()));
            return null;
        }
        this.deleteSkuData(rsSku.getSkuCode(), rsSku.getTenantCode());
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        rsSkuList.add(rsSku);
        this.logger.error("rs.RsSkuServiceImpl==ES_SKUDELE2==", (Object)(rsSku.getSkuCode() + "=" + rsSku.getTenantCode()));
        return this.saveSenddata(rsSkuList, "skudelete", rsResourceGoods.getGoodsEocode(), rsSkuDomain, null, false, false);
    }

    private void deleteSkuData(String skuCode, String tenantCode) {
        if (StringUtil.isBlank((String)skuCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.rsGoodsOtherService.delGoodsFileBySkuCode(map);
        map.put("goodsSkuCode", skuCode);
        map.remove("skuCode");
        this.rsGoodsOtherService.delGoodsRelByGoodsCode(map);
    }

    @Override
    public List<RsSenddataDomain> updatetSkuPassByGoodsCodeNew(Integer dataState, Integer oldDataState, RsResourceGoods rsResourceGoods, String senddataParentcode) {
        if (null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.rsResourceGoods", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.updatetSkuPassByGoodsCodeNew(dataState, oldDataState, rsResourceGoods, true, senddataParentcode);
    }

    private boolean checkDataState(Integer dataState, Integer oldDataState, Integer dataOpbillstate) {
        if (null == dataState) {
            dataState = 0;
        }
        if (null == oldDataState) {
            oldDataState = 0;
        }
        if (null == dataOpbillstate) {
            dataOpbillstate = 0;
        }
        if (oldDataState.intValue() == dataState.intValue()) {
            return true;
        }
        if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_3.intValue() && dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_4.intValue() && dataOpbillstate.intValue() == ResourcesConstants.DATA_OPBILLSTATE_1.intValue()) {
            return true;
        }
        if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_0.intValue() && dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_4.intValue() && dataOpbillstate.intValue() == ResourcesConstants.DATA_OPBILLSTATE_1.intValue()) {
            return true;
        }
        return oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_0.intValue() && dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_3.intValue() && dataOpbillstate.intValue() == ResourcesConstants.DATA_OPBILLSTATE_1.intValue();
    }

    private List<RsSenddataDomain> updatetSkuPassByGoodsCodeNew(Integer dataState, Integer oldDataState, RsResourceGoods rsResourceGoods, boolean minnum, String senddataParentcode) {
        if (null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.rsResourceGoods", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String goodsCode = rsResourceGoods.getGoodsCode();
        String tenantCode = rsResourceGoods.getTenantCode();
        if (null == dataState || StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String requestType = "";
        if (null == oldDataState) {
            oldDataState = rsResourceGoods.getDataState();
        }
        Integer dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_0;
        if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "insert";
            dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_1;
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "down";
        } else if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "deleteop";
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "add";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsResourceGoods.getGoodsCode());
        map.put("tenantCode", rsResourceGoods.getTenantCode());
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (ListUtil.isEmpty(rsSkuList)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.rsSkuList", (Object)(goodsCode + "=" + tenantCode + "=" + dataState + "=" + dataOpbillstate + "=" + oldDataState));
            return null;
        }
        for (RsSku rsSku : rsSkuList) {
            if (!this.checkDataState(rsSku.getDataState(), oldDataState, dataOpbillstate)) {
                this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.updateSkuStateBySkuCode1", (Object)(rsSku.getSkuCode() + "=" + rsSku.getDataState() + "=" + tenantCode + "=" + dataState + "=" + dataOpbillstate + "=" + oldDataState + "=" + ((Object)map).toString()));
                continue;
            }
            Integer oldOldDataState = rsSku.getDataState();
            if (this.updateSkuStateBySkuCode(rsSku.getSkuCode(), tenantCode, dataState, dataOpbillstate, oldOldDataState)) continue;
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.updateSkuStateBySkuCode", (Object)(rsSku.getSkuCode() + "=" + tenantCode + "=" + dataState + "=" + dataOpbillstate + "=" + oldDataState + "=" + ((Object)map).toString()));
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.updateSkuStateBySkuCode");
        }
        if (StringUtils.isBlank((String)requestType)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassByGoodsCodeNew.requestType", (Object)(goodsCode + "=" + tenantCode + "=" + dataState + "=" + dataOpbillstate + "=" + oldDataState));
            return null;
        }
        return this.saveSkuSend(dataState, oldDataState, rsResourceGoods, requestType, rsSkuList, minnum, senddataParentcode, false);
    }

    private List<RsSenddataDomain> saveSkuSend(Integer dataState, Integer oldDataState, RsResourceGoods rsResourceGoods, String requestType, List<RsSku> rsSkuList, boolean minnum, String senddataParentcode, boolean skuflag) {
        List<RsSenddataDomain> downList;
        if (null == rsResourceGoods || null == dataState) {
            return null;
        }
        if (null == rsSkuList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsResourceGoods.getGoodsCode());
            map.put("tenantCode", rsResourceGoods.getTenantCode());
            rsSkuList = this.querySkuModelPage(map);
        }
        List<Object> rsSkuListsend = new ArrayList();
        String goodsEocode = rsResourceGoods.getGoodsEocode();
        ArrayList<RsSku> rsSkuDownListsend = new ArrayList<RsSku>();
        if (minnum && dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            DisChannel disChannel = this.getChannel(rsResourceGoods.getChannelCode(), rsResourceGoods.getTenantCode());
            if (null != disChannel) {
                Date skuHdate = this.getSysDate();
                for (RsSku rsSku2 : rsSkuList) {
                    rsSku2.setSkuHdate(skuHdate);
                    if (this.makeNum(rsResourceGoods, rsSku2, disChannel, false)) {
                        this.updateSkuStateBySkuCode(rsSku2.getSkuCode(), rsSku2.getTenantCode(), ResourcesConstants.GOODS_DATA_STATE_4, ResourcesConstants.DATA_OPBILLSTATE_0, dataState);
                        rsSkuDownListsend.add(rsSku2);
                        continue;
                    }
                    rsSkuListsend.add(rsSku2);
                }
            } else {
                rsSkuListsend = rsSkuList;
            }
        } else {
            rsSkuListsend = rsSkuList;
        }
        ArrayList<RsSenddataDomain> reList = new ArrayList<RsSenddataDomain>();
        if (skuflag) {
            List<RsSenddataDomain> upList = this.saveSenddata(rsSkuListsend, requestType, goodsEocode, senddataParentcode);
            if (ListUtil.isNotEmpty(upList)) {
                reList.addAll(upList);
                senddataParentcode = upList.get(0).getSenddataCode();
            } else {
                this.logger.error("rs.RsSkuServiceImpl.saveSkuSend.upList", (Object)(skuflag + "=" + rsSkuListsend.size() + "=" + requestType + "=" + rsResourceGoods.getGoodsCode()));
            }
        }
        if (ListUtil.isNotEmpty(downList = this.saveSenddata(rsSkuDownListsend, "skudown", goodsEocode, senddataParentcode))) {
            reList.addAll(downList);
        }
        return reList;
    }

    private DisChannel getChannel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisChannel memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        return memchannel;
    }

    private boolean makeNum(RsResourceGoods rsResourceGoods, RsSku rsSku, DisChannel disChannel, boolean up) {
        if (null == rsSku || null == rsResourceGoods || null == disChannel) {
            return false;
        }
        List disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        boolean flag = false;
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            flag = true;
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
        }
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            return false;
        }
        if (this.makeNum(disDpriceList, rsResourceGoods, rsSku, up)) {
            return true;
        }
        if (!flag) {
            disDpriceList = DisUtil.getMapListJson((String)"DisDgnumList-channelCode", (String)("all-" + disChannel.getTenantCode()), DisDgnumDomain.class);
            return this.makeNum(disDpriceList, rsResourceGoods, rsSku, up);
        }
        return false;
    }

    private Map<String, Object> makeObject(RsResourceGoods rsResourceGoods, RsSku rsSku) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (null != rsResourceGoods) {
            obj.putAll(JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoods), String.class, Object.class));
        }
        if (null != rsSku) {
            obj.putAll(JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)rsSku), String.class, Object.class));
        }
        return obj;
    }

    private boolean makeNum(List<DisDgnumDomain> disDgnumDomainList, RsResourceGoods rsResourceGoods, RsSku rsSku, boolean up) {
        if (ListUtil.isEmpty(disDgnumDomainList) || null == rsResourceGoods || null == rsSku) {
            return false;
        }
        if (null == rsSku.getGoodsSupplynum()) {
            rsSku.setGoodsSupplynum(BigDecimal.ZERO);
        }
        Map<String, Object> mapobj = this.makeObject(rsResourceGoods, rsSku);
        for (DisDgnumDomain disDgnumDomain : disDgnumDomainList) {
            Map<String, List<String>> map = this.makeDgnumlist(disDgnumDomain.getDisDgnumListList());
            if (!this.checkConf(map, mapobj)) continue;
            this.makeListNum(disDgnumDomain, mapobj);
            if (null == disDgnumDomain.getDgnumMin()) {
                disDgnumDomain.setDgnumMin(BigDecimal.ZERO);
            }
            if (!up && rsSku.getGoodsSupplynum().compareTo(disDgnumDomain.getDgnumMin()) <= 0) {
                return true;
            }
            return up && rsSku.getGoodsSupplynum().compareTo(disDgnumDomain.getDgnumMin()) > 0;
        }
        return false;
    }

    private void makeListNum(DisDgnumDomain disDgnumDomain, Object mapobj) {
        if (null == disDgnumDomain || ListUtil.isEmpty(disDgnumDomain.getDisDgnumListList())) {
            return;
        }
        String confList = disDgnumDomain.getDisDgnumListList().get(0).getDgnumListType();
        if ("2".equals(disDgnumDomain.getDgnumPro()) || "goodsNo".equals(confList) || "skuNo".equals(confList)) {
            for (DisDgnumList disDgnumList : disDgnumDomain.getDisDgnumListList()) {
                Object objValue = BeanUtils.newForceGetProperty((Object)mapobj, (String)disDgnumList.getDgnumListType());
                ArrayList<String> relist = new ArrayList<String>();
                relist.add(disDgnumList.getDgnumListValue());
                if (!this.cond(relist, disDgnumList.getDgnumListTerm(), objValue)) continue;
                if (null != disDgnumList.getDgnumListPrice() && disDgnumList.getDgnumListPrice().compareTo(BigDecimal.ZERO) > 0) {
                    disDgnumDomain.setDgnumPrice(disDgnumList.getDgnumListPrice());
                } else if (StringUtils.isNotBlank((String)disDgnumList.getDgnumListValuename())) {
                    try {
                        disDgnumDomain.setDgnumPrice(new BigDecimal(disDgnumList.getDgnumListValuename()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (null != disDgnumList.getDgnumListMax() && disDgnumList.getDgnumListMax().compareTo(BigDecimal.ZERO) > 0) {
                    disDgnumDomain.setDgnumMax(disDgnumList.getDgnumListMax());
                }
                if (null == disDgnumList.getDgnumListMinx() || disDgnumList.getDgnumListMinx().compareTo(BigDecimal.ZERO) <= 0) break;
                disDgnumDomain.setDgnumMin(disDgnumList.getDgnumListMinx());
                break;
            }
        }
    }

    private Map<String, List<String>> makeDgnumlist(List<DisDgnumList> disDgnumListList) {
        if (ListUtil.isEmpty(disDgnumListList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgnumList disDpriceConf : disDgnumListList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)disDpriceConf.getDgnumListTerm())) {
                disDpriceConf.setDgnumListTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(disDpriceConf.getDgnumListType() + "|" + disDpriceConf.getDgnumListTerm()))) {
                list = new ArrayList<String>();
                map.put(disDpriceConf.getDgnumListType() + "|" + disDpriceConf.getDgnumListTerm(), list);
            }
            list.add(disDpriceConf.getDgnumListValue());
        }
        return map;
    }

    private boolean checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs;
                for (String o : otrs = objValue.toString().split("\\,")) {
                    if (this.cond(valueList, term, o)) break;
                }
                continue;
            }
            if (this.cond(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = false;
            }
        }
        return flag;
    }

    private List<RsSenddataDomain> saveSenddata(List<RsSku> rsSkuList, String requestType, String goodsEocode, String senddataParentcode) {
        return this.saveSenddata(rsSkuList, requestType, goodsEocode, senddataParentcode, false, false);
    }

    private List<RsSenddataDomain> saveSenddata(List<RsSku> rsSkuList, String requestType, String goodsEocode, String senddataParentcode, Boolean isSkuEdit, Boolean goodsEdit) {
        return this.saveSenddata(rsSkuList, requestType, goodsEocode, null, senddataParentcode, isSkuEdit, goodsEdit);
    }

    protected List<RsSenddataDomain> saveSenddata(List<RsSku> rsSkuList, String requestType, String goodsEocode, RsSkuDomain rsSkuDomain, String senddataParentcode) {
        return this.saveSenddata(rsSkuList, requestType, goodsEocode, null, senddataParentcode, false, false);
    }

    private List<RsSenddataDomain> saveSenddata(List<RsSku> rsSkuList, String requestType, String goodsEocode, RsSkuDomain rsSkuDomain, String senddataParentcode, Boolean isSkuEdit, Boolean goodsEdit) {
        if (ListUtil.isEmpty(rsSkuList) || StringUtils.isBlank((String)requestType)) {
            return null;
        }
        ArrayList<RsSenddataDomain> rsSenddataDomainList = new ArrayList<RsSenddataDomain>();
        for (RsSku rsSku : rsSkuList) {
            String fdBizcodestr = "";
            if ("skudelete".equals(requestType)) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.getRsResourceGoodsService().getResourceGoodsByCode(this.getQueryMapParam("goodsCode,tenantCode", new Object[]{rsSku.getGoodsCode(), rsSku.getTenantCode()}));
                if (null == rsResourceGoodsReDomain.getRsSkuDomainList()) {
                    rsResourceGoodsReDomain.setRsSkuDomainList(new ArrayList<RsSkuDomain>());
                }
                if (null == rsSkuDomain) {
                    rsSkuDomain = new RsSkuDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rsResourceGoodsReDomain.getRsSkuDomainList().add(rsSkuDomain);
                }
                if (ListUtil.isEmpty(rsResourceGoodsReDomain.getRsSkuDomainList())) {
                    rsResourceGoodsReDomain.getRsSkuDomainList().add(rsSkuDomain);
                }
                fdBizcodestr = JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain);
            }
            RsSenddataDomain rsSenddataDomain = new RsSenddataDomain();
            rsSenddataDomain.setSenddataParentcode(senddataParentcode);
            rsSenddataDomain.setEsrequestType(requestType);
            rsSenddataDomain.setMemberCode(rsSku.getMemberCode());
            rsSenddataDomain.setChannelCode(rsSku.getChannelCode());
            rsSenddataDomain.setTenantCode(rsSku.getTenantCode());
            rsSenddataDomain.setAppmanageIcode(rsSku.getAppmanageIcode());
            rsSenddataDomain.setFdBizcode(rsSku.getSkuCode());
            rsSenddataDomain.setFdBiztype("RsSku");
            rsSenddataDomain.setFdBizcodestr(fdBizcodestr);
            rsSenddataDomain.setFdState(rsSku.getDataState());
            rsSenddataDomain.setFdBizid(rsSku.getSkuId());
            rsSenddataDomainList.add(rsSenddataDomain);
            RsSenddataDomain rsSenddata1Domain = new RsSenddataDomain();
            rsSenddata1Domain.setSenddataParentcode(senddataParentcode);
            rsSenddata1Domain.setEsrequestType(requestType);
            rsSenddata1Domain.setChannelCode(rsSku.getChannelCode());
            rsSenddata1Domain.setTenantCode(rsSku.getTenantCode());
            rsSenddata1Domain.setAppmanageIcode(rsSku.getAppmanageIcode());
            rsSenddata1Domain.setFdBizcode(rsSku.getSkuCode());
            rsSenddata1Domain.setFdBiztype("RcRsSku");
            rsSenddata1Domain.setFdBizcodestr(fdBizcodestr);
            rsSenddata1Domain.setFdState(rsSku.getDataState());
            rsSenddata1Domain.setFdBizid(rsSku.getSkuId());
            rsSenddataDomainList.add(rsSenddata1Domain);
        }
        return rsSenddataDomainList;
    }

    @Override
    public List<RsSenddataDomain> updatetSkuPassBySkuCodeNew(Integer dataState, Integer oldDataState, String skuCode, String tenantCode, RsResourceGoods rsResourceGoods) {
        if (null == dataState || StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.updatetSkuPassBySkuCodeNew(dataState, oldDataState, skuCode, tenantCode, rsResourceGoods, true, null);
    }

    @Override
    public List<RsSenddataDomain> updatetSkuPassBySkuCodeNew(Integer dataState, Integer oldDataState, String skuCode, String tenantCode, RsResourceGoods rsResourceGoods, boolean minnum, String senddataParentcode) {
        if (null == dataState || StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode) || null == rsResourceGoods) {
            throw new ApiException("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        RsSku rsSku = this.getSkuModelByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{skuCode, tenantCode}));
        if (null == rsSku) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.rsSku", (Object)(skuCode + "-" + tenantCode + "-" + dataState + "+" + oldDataState));
            return null;
        }
        if (null == oldDataState) {
            oldDataState = rsSku.getDataState();
        }
        String requestType = "";
        Integer dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_0;
        if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "skuinsert";
            dataOpbillstate = ResourcesConstants.DATA_OPBILLSTATE_1;
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_2.intValue()) {
            requestType = "skudown";
        } else if (dataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "skudeleteop";
        } else if (oldDataState.intValue() == ResourcesConstants.GOODS_DATA_STATE_NO.intValue()) {
            requestType = "skuadd";
        }
        if (!this.updateSkuStateBySkuCode(skuCode, tenantCode, dataState, dataOpbillstate, rsSku.getDataState())) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.dataState", (Object)(skuCode + "-" + tenantCode + "-" + dataState + "-" + dataOpbillstate + "-" + oldDataState));
            return null;
        }
        if (StringUtils.isBlank((String)requestType)) {
            this.logger.error("rs.RsSkuServiceImpl.updatetSkuPassBySkuCodeNew.requestType", (Object)(skuCode + "=" + tenantCode + "=" + dataState + "=" + dataOpbillstate + "=" + oldDataState));
            return null;
        }
        rsSku.setDataOpbillstate(dataOpbillstate);
        rsSku.setDataState(dataState);
        ArrayList<RsSku> rsSkuList = new ArrayList<RsSku>();
        rsSkuList.add(rsSku);
        return this.saveSkuSend(dataState, oldDataState, rsResourceGoods, requestType, rsSkuList, minnum, senddataParentcode, true);
    }

    @Override
    public void updateGoodsEocodeByNo(String goodsCode, String goodsEocode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsEocodeByNo.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", goodsCode);
        map.put("goodsEocode", goodsEocode);
        map.put("tenantCode", tenantCode);
        this.updateGoodsEocodeModelByCode(map);
    }

    @Override
    public void updateGoodsSpByNo(String goodsSp, String skuNo, String memberCcode, String tenantCode, String channelCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsSp) || StringUtils.isBlank((String)skuNo) || StringUtils.isBlank((String)memberCcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSpByNo.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsSp", goodsSp);
        map.put("skuNo", skuNo);
        map.put("memberCcode", memberCcode);
        map.put("tenantCode", tenantCode);
        map.put("channelCode", channelCode);
        this.updateGoodsSpModelByNo(map);
    }

    @Override
    public void updateGoodsSpByCode(String goodsSp, String skuCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)goodsSp) || StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSpByCode.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsSp", goodsSp);
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        this.updateGoodsSpModelByNo(map);
    }

    @Override
    public void updateSkuNprice(RsSkuDomain rsSkuDomain) {
        if (rsSkuDomain == null) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSkuNprice.param.null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuNo", rsSkuDomain.getSkuNo());
        map.put("goodsOrigin", "17");
        map.put("memberCode", rsSkuDomain.getMemberCode());
        map.put("tenantCode", rsSkuDomain.getTenantCode());
        map.put("pricesetNprice", rsSkuDomain.getPricesetNprice());
        this.updateSkuNewNprice(map);
    }

    public void updateSkuNewNprice(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateSKuPriceBySku(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSKuPriceBySku.ex", (Throwable)e);
        }
        if (1 > i) {
            throw new ApiException("rs.RsSkuServiceImpl.updateSKuPriceBySku.num");
        }
    }

    public void updateGoodsSpModelByNo(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuMapper.updateGoodsSp(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSpModelByNo.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuServiceImpl.updateGoodsSpModelByNo.num");
        }
    }

    @Override
    public void updateSkuNextState(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        this.updateSkuNextModelByCode(map);
    }

    @Override
    public String updateSkuDataOpbilistStateProcess(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        this.loadDb(channelCode, tenantCode);
        return "success";
    }

    private void loadDb(String channelCode, String tenantCode) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            map.put("channelCode", channelCode);
            map.put("tenantCode", tenantCode);
            map.put("colName0", "DATA_OPNEXTBILLSTATE");
            map.put("colValue0", "1,2,3,4,5,-1");
            int startRow = -100;
            int page = 100;
            boolean flag = true;
            QueryResult<RsSku> result = null;
            int xh = 0;
            String apiCode = "cmc.disGoods.getgoodswarehouse";
            do {
                map.put("startRow", startRow += page);
                map.put("rows", page);
                result = this.queryDisAndSkuPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    for (RsSku rsSku : result.getList()) {
                        String skuEocode = rsSku.getSkuEocode();
                        if (StringUtils.isBlank((String)skuEocode)) continue;
                        String[] split = skuEocode.split("|");
                        ids.add(Integer.parseInt(split[0]));
                    }
                    if (ListUtil.isNotEmpty(ids)) {
                        HashMap<String, Object> param = new HashMap<String, Object>();
                        param.put("channelCode", channelCode);
                        param.put("tenantCode", tenantCode);
                        param.put("goods_ids", ids);
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(param));
                        paramMap.put("channelCode", channelCode);
                        paramMap.put("tenantCode", tenantCode);
                        String json = (String)this.getInternalRouter().inInvoke(apiCode, "1.0", "0", paramMap);
                        if (StringUtils.isBlank((String)json) || !"SUCCESS".equals(json)) {
                            this.logger.error("rs.RsSkuServiceImpl.sendLevelClearByDis  json", (Object)((Object)paramMap).toString());
                            flag = false;
                        }
                    }
                    if (result.getRows().size() != page) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
                if (++xh <= 10) continue;
                flag = false;
            } while (flag);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public QueryResult<RsSkuDomain> querySkuSensitPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.querySkuSensitModelPage(map);
        List<RsSkuDomain> rsSkuDomainList = this.makeRsSkuDomainList(rsSkuList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSkuSensit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuDomainList);
        return queryResult;
    }

    private List<RsSku> querySkuSensitModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuMapper.querySkuSensit(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuSensitModelPage", (Throwable)e);
            return null;
        }
    }

    private int countSkuSensit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuMapper.countSkuSensit(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.countSkuSensit", (Throwable)e);
        }
        return i;
    }

    @Override
    public String countSkuByMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("rs.RsSkuServiceImpl.countSkuByMap.", (Object)"param is null");
            return null;
        }
        int count = this.countSku(map);
        return String.valueOf(count);
    }

    @Override
    public RsSku getSkuBySkuNo(String skuNo, String tenantCode, String goodsType) {
        Map map = this.getQueryParamMap("skuNo,tenantCode,skuOldcode,goodsType", new Object[]{skuNo, tenantCode, "-1", goodsType});
        List<RsSku> rsSkuList = this.querySkuModelPage(map);
        if (ListUtil.isEmpty(rsSkuList) && ListUtil.isEmpty(rsSkuList = this.querySkuModelPage(map = this.getQueryParamMap("skuNo,tenantCode,goodsType", new Object[]{skuNo, tenantCode, goodsType})))) {
            this.logger.error("rs.RsSkuServiceImpl.getSkuBySkuNoType,rsSkuList", (Object)map.toString());
            return null;
        }
        return rsSkuList.get(0);
    }

    @Override
    public QueryResult<RsSkuDomain> queryAppointSkuPage(Map<String, Object> map) {
        List<RsSku> rsSkuList = this.queryAppointPage(map);
        List<RsSkuDomain> rsSkuDomainList = this.makeAppointRsSkuDomainList(rsSkuList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(ListUtil.isEmpty(rsSkuList) ? 0 : this.countSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuDomainList);
        return queryResult;
    }

    private List<RsSkuDomain> makeAppointRsSkuDomainList(List<RsSku> rsSkuList) {
        if (ListUtil.isEmpty(rsSkuList)) {
            return null;
        }
        ArrayList<RsSkuDomain> rsSkuDomainList = new ArrayList<RsSkuDomain>();
        for (RsSku rsSku : rsSkuList) {
            RsSkuDomain rsSkuDomain = this.makeAppointRsSkuDomain(rsSku);
            rsSkuDomainList.add(rsSkuDomain);
        }
        return rsSkuDomainList;
    }

    private RsSkuDomain makeAppointRsSkuDomain(RsSku rsSku) {
        if (null == rsSku) {
            return null;
        }
        RsSkuDomain rsSkuDomain = new RsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuDomain, (Object)rsSku);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rsSkuDomain;
    }

    @Override
    public List<String> queryGoodsNoByRsSku(Map<String, Object> parameters) {
        try {
            return this.rsSkuMapper.queryGoodsNoByRsSku(parameters);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuServiceImpl.querySkuSensitModelPage", (Throwable)e);
            return null;
        }
    }
}

