/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsGoodsPriceMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsPriceDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsPriceReDomain;
import com.yqbsoft.laser.service.resources.model.RsGoodsPrice;
import com.yqbsoft.laser.service.resources.service.RsGoodsPriceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsPriceServiceImpl
extends BaseServiceImpl
implements RsGoodsPriceService {
    private static final String SYS_CODE = "rs.RsGoodsPriceServiceImpl";
    private RsGoodsPriceMapper rsGoodsPriceMapper;

    public void setRsGoodsPriceMapper(RsGoodsPriceMapper rsGoodsPriceMapper) {
        this.rsGoodsPriceMapper = rsGoodsPriceMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsGoodsPriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsPriceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRsGoodsPrice(RsGoodsPriceDomain rsGoodsPriceDomain) {
        if (null == rsGoodsPriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsGoodsPriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRsGoodsPriceDefault(RsGoodsPrice rsGoodsPrice) {
        if (null == rsGoodsPrice) {
            return;
        }
        if (null == rsGoodsPrice.getDataState()) {
            rsGoodsPrice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsGoodsPrice.getGmtCreate()) {
            rsGoodsPrice.setGmtCreate(date);
        }
        rsGoodsPrice.setGmtModified(date);
        if (StringUtils.isBlank((String)rsGoodsPrice.getGoodsPriceCode())) {
            rsGoodsPrice.setGoodsPriceCode(this.getNo(null, "RsGoodsPrice", "rsGoodsPrice", rsGoodsPrice.getTenantCode()));
        }
    }

    private int getRsGoodsPriceMaxCode() {
        int code = 0;
        try {
            return this.rsGoodsPriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsPriceServiceImpl.getRsGoodsPriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRsGoodsPriceUpdataDefault(RsGoodsPrice rsGoodsPrice) {
        if (null == rsGoodsPrice) {
            return;
        }
        rsGoodsPrice.setGmtModified(this.getSysDate());
    }

    private void saveRsGoodsPriceModel(RsGoodsPrice rsGoodsPrice) throws ApiException {
        if (null == rsGoodsPrice) {
            return;
        }
        try {
            this.rsGoodsPriceMapper.insert(rsGoodsPrice);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.saveRsGoodsPriceModel.ex", (Throwable)e);
        }
    }

    private void saveRsGoodsPriceBatchModel(List<RsGoodsPrice> rsGoodsPriceList) throws ApiException {
        if (null == rsGoodsPriceList || rsGoodsPriceList.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsPriceMapper.insertBatch(rsGoodsPriceList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.saveRsGoodsPriceBatchModel.ex", (Throwable)e);
        }
    }

    private RsGoodsPrice getRsGoodsPriceModelById(Integer GoodsPriceId) {
        if (null == GoodsPriceId) {
            return null;
        }
        try {
            return this.rsGoodsPriceMapper.selectByPrimaryKey(GoodsPriceId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsPriceServiceImpl.getRsGoodsPriceModelById", (Throwable)e);
            return null;
        }
    }

    private RsGoodsPrice getRsGoodsPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsPriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsPriceServiceImpl.getRsGoodsPriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRsGoodsPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsPriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.delRsGoodsPriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.delRsGoodsPriceModelByCode.num");
        }
    }

    private void deleteRsGoodsPriceModel(Integer GoodsPriceId) throws ApiException {
        if (null == GoodsPriceId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsPriceMapper.deleteByPrimaryKey(GoodsPriceId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.deleteRsGoodsPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.deleteRsGoodsPriceModel.num");
        }
    }

    private void updateRsGoodsPriceModel(RsGoodsPrice rsGoodsPrice) throws ApiException {
        if (null == rsGoodsPrice) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsPriceMapper.updateByPrimaryKey(rsGoodsPrice);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.updateRsGoodsPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.updateRsGoodsPriceModel.num");
        }
    }

    private void updateStateRsGoodsPriceModel(Integer GoodsPriceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == GoodsPriceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GoodsPriceId", GoodsPriceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsPriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.updateStateRsGoodsPriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.updateStateRsGoodsPriceModel.null");
        }
    }

    private void updateStateRsGoodsPriceModelByCode(String tenantCode, String GoodsPriceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)GoodsPriceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("GoodsPriceCode", GoodsPriceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsGoodsPriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.updateStateRsGoodsPriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.updateStateRsGoodsPriceModelByCode.null");
        }
    }

    private RsGoodsPrice makeRsGoodsPrice(RsGoodsPriceDomain rsGoodsPriceDomain, RsGoodsPrice rsGoodsPrice) {
        if (null == rsGoodsPriceDomain) {
            return null;
        }
        if (null == rsGoodsPrice) {
            rsGoodsPrice = new RsGoodsPrice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsPrice, (Object)rsGoodsPriceDomain);
            return rsGoodsPrice;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsPriceServiceImpl.makeRsGoodsPrice", (Throwable)e);
            return null;
        }
    }

    private RsGoodsPriceReDomain makeRsGoodsPriceReDomain(RsGoodsPrice rsGoodsPrice) {
        if (null == rsGoodsPrice) {
            return null;
        }
        RsGoodsPriceReDomain rsGoodsPriceReDomain = new RsGoodsPriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsPriceReDomain, (Object)rsGoodsPrice);
            return rsGoodsPriceReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsPriceServiceImpl.makeRsGoodsPriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsGoodsPrice> queryRsGoodsPriceModelPage(Map<String, Object> parammap) {
        try {
            return this.rsGoodsPriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsPriceServiceImpl.queryRsGoodsPriceModel", (Throwable)e);
            return null;
        }
    }

    private int countRsGoodsPrice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsGoodsPriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsPriceServiceImpl.countRsGoodsPrice", (Throwable)e);
        }
        return i;
    }

    private RsGoodsPrice createRsGoodsPrice(RsGoodsPriceDomain rsGoodsPriceDomain) {
        String msg = this.checkRsGoodsPrice(rsGoodsPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.saveRsGoodsPrice.checkRsGoodsPrice", msg);
        }
        RsGoodsPrice rsGoodsPrice = this.makeRsGoodsPrice(rsGoodsPriceDomain, null);
        this.setRsGoodsPriceDefault(rsGoodsPrice);
        return rsGoodsPrice;
    }

    @Override
    public String saveRsGoodsPrice(RsGoodsPriceDomain rsGoodsPriceDomain) throws ApiException {
        RsGoodsPrice rsGoodsPrice = this.createRsGoodsPrice(rsGoodsPriceDomain);
        this.saveRsGoodsPriceModel(rsGoodsPrice);
        return rsGoodsPrice.getGoodsPriceCode();
    }

    @Override
    public String saveRsGoodsPriceBatch(List<RsGoodsPriceDomain> rsGoodsPriceDomainList) throws ApiException {
        if (null == rsGoodsPriceDomainList || rsGoodsPriceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsGoodsPrice> rsGoodsPriceList = new ArrayList<RsGoodsPrice>();
        String code = "";
        for (RsGoodsPriceDomain rsGoodsPriceDomain : rsGoodsPriceDomainList) {
            RsGoodsPrice rsGoodsPrice = this.createRsGoodsPrice(rsGoodsPriceDomain);
            code = rsGoodsPrice.getGoodsPriceCode();
            rsGoodsPriceList.add(rsGoodsPrice);
        }
        this.saveRsGoodsPriceBatchModel(rsGoodsPriceList);
        return code;
    }

    @Override
    public void updateRsGoodsPriceState(Integer GoodsPriceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == GoodsPriceId) {
            return;
        }
        this.updateStateRsGoodsPriceModel(GoodsPriceId, dataState, oldDataState, map);
    }

    @Override
    public void updateRsGoodsPriceStateByCode(String tenantCode, String GoodsPriceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)GoodsPriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRsGoodsPriceModelByCode(tenantCode, GoodsPriceCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRsGoodsPrice(RsGoodsPriceDomain rsGoodsPriceDomain) throws ApiException {
        String msg = this.checkRsGoodsPrice(rsGoodsPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.updateRsGoodsPrice.checkRsGoodsPrice", msg);
        }
        RsGoodsPrice oldRsGoodsPrice = this.getRsGoodsPriceModelById(rsGoodsPriceDomain.getGoodsPriceId());
        if (null == oldRsGoodsPrice) {
            throw new ApiException("rs.RsGoodsPriceServiceImpl.updateRsGoodsPrice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsGoodsPrice rsGoodsPrice = this.makeRsGoodsPrice(rsGoodsPriceDomain, oldRsGoodsPrice);
        this.setRsGoodsPriceUpdataDefault(rsGoodsPrice);
        this.updateRsGoodsPriceModel(rsGoodsPrice);
    }

    @Override
    public RsGoodsPrice getRsGoodsPrice(Integer GoodsPriceId) {
        if (null == GoodsPriceId) {
            return null;
        }
        return this.getRsGoodsPriceModelById(GoodsPriceId);
    }

    @Override
    public void deleteRsGoodsPrice(Integer GoodsPriceId) throws ApiException {
        if (null == GoodsPriceId) {
            return;
        }
        this.deleteRsGoodsPriceModel(GoodsPriceId);
    }

    @Override
    public QueryResult<RsGoodsPrice> queryRsGoodsPricePage(Map<String, Object> map) {
        List<RsGoodsPrice> rsGoodsPriceList = this.queryRsGoodsPriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRsGoodsPrice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsGoodsPriceList);
        return queryResult;
    }

    @Override
    public RsGoodsPrice getRsGoodsPriceByCode(String tenantCode, String GoodsPriceCode) throws ApiException {
        if (StringUtils.isBlank((String)GoodsPriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("GoodsPriceCode", GoodsPriceCode);
        return this.getRsGoodsPriceModelByCode(map);
    }

    @Override
    public void deleteRsGoodsPriceByCode(String tenantCode, String GoodsPriceCode) throws ApiException {
        if (StringUtils.isBlank((String)GoodsPriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("GoodsPriceCode", GoodsPriceCode);
        this.delRsGoodsPriceModelByCode(map);
    }

    @Override
    public void deleteRsGoodsPriceByMap(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        List<RsGoodsPrice> priceList = this.queryRsGoodsPriceModelPage(map);
        if (ListUtil.isEmpty(priceList)) {
            return;
        }
        for (RsGoodsPrice rsGoodsPrice : priceList) {
            this.deleteRsGoodsPrice(rsGoodsPrice.getGoodsPriceId());
        }
    }
}

