/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.service.impl;

import com.yqbsoft.laser.service.esb.annotation.ApiMethod;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.log.performance.OpenPerfLogUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.searchengine.SearchengineConstants;
import com.yqbsoft.laser.service.searchengine.domain.AccurateQueryDomain;
import com.yqbsoft.laser.service.searchengine.domain.DataHits;
import com.yqbsoft.laser.service.searchengine.domain.EsBean;
import com.yqbsoft.laser.service.searchengine.domain.PmPromotionDomain;
import com.yqbsoft.laser.service.searchengine.domain.PmPromotionInDomain;
import com.yqbsoft.laser.service.searchengine.domain.PmPromotionRangelistDomain;
import com.yqbsoft.laser.service.searchengine.domain.RestBean;
import com.yqbsoft.laser.service.searchengine.domain.ReturnBean;
import com.yqbsoft.laser.service.searchengine.domain.SearchDomain;
import com.yqbsoft.laser.service.searchengine.domain.SortDomain;
import com.yqbsoft.laser.service.searchengine.domain.StoreDomain;
import com.yqbsoft.laser.service.searchengine.enums.ConstantEnums;
import com.yqbsoft.laser.service.searchengine.es.EsEnginePollThread;
import com.yqbsoft.laser.service.searchengine.es.EsEnginePutThread;
import com.yqbsoft.laser.service.searchengine.es.EsEngineService;
import com.yqbsoft.laser.service.searchengine.index.StoreEnum;
import com.yqbsoft.laser.service.searchengine.service.SearchengineService;
import com.yqbsoft.laser.service.searchengine.util.EsUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchengineServiceImpl
extends BaseServiceImpl
implements SearchengineService {
    private static final String SYS_CODE = "es.SearchengineServiceImpl";
    @Autowired
    EsUtil esUtil;
    private static EsEngineService esEngineService;
    private static Object lock;

    private static String list2string(List<String> params, boolean flag) {
        String result = "";
        String res = "";
        for (String s : params) {
            if (!flag && null != s) {
                s = s.toLowerCase();
            }
            res = res + "\"" + s + "\",";
        }
        result = "[" + res.substring(0, res.length() - 1) + "]";
        return result;
    }

    @Override
    public boolean storeBatch(List<StoreDomain> storeDomainList) throws ApiException {
        if (ListUtil.isEmpty(storeDomainList)) {
            return false;
        }
        for (StoreDomain storeDomain : storeDomainList) {
            if (this.store(storeDomain)) continue;
            return false;
        }
        return false;
    }

    @Override
    @ApiMethod(code="es.searchengine.store", name="\u6570\u636e\u5b58\u50a8", paramStr="storeDomain", description="")
    public boolean store(StoreDomain storeDomain) throws ApiException {
        if (null == storeDomain || StringUtils.isBlank((String)storeDomain.getTenantCode()) || StringUtils.isBlank((String)storeDomain.getRequestType())) {
            return false;
        }
        String id = storeDomain.getBizId();
        if (StringUtils.isBlank((String)id)) {
            return false;
        }
        String type = storeDomain.getBizType();
        if (StringUtils.isBlank((String)type)) {
            return false;
        }
        String requestType = storeDomain.getRequestType();
        String method = "POST";
        String data = storeDomain.getTenantCode();
        if (StoreEnum.INSERT.getType().equals(requestType) || StoreEnum.SKUINSERT.getType().equals(requestType) || StoreEnum.SKUADD.getType().equals(requestType)) {
            method = "POST";
        } else if (StoreEnum.ESUPDATE.getType().equals(requestType) || StoreEnum.UPDATE.getType().equals(requestType) || StoreEnum.EDIT.getType().equals(requestType)) {
            method = "UPDATE";
        } else if (StoreEnum.DELETE.getType().equals(requestType) || StoreEnum.DELETEOP.getType().equals(requestType) || StoreEnum.SKUDELETE.getType().equals(requestType) || StoreEnum.SKUDELETEOP.getType().equals(requestType) || StoreEnum.SKUDOWN.getType().equals(requestType) || StoreEnum.DOWN.getType().equals(requestType)) {
            method = "DELETE";
        } else {
            this.logger.error("es.SearchengineServiceImpl.requestType.return", (Object)(requestType + "=" + storeDomain.getBizId()));
            return true;
        }
        String queryParamJson = "";
        if (null != storeDomain.getStoreObj()) {
            queryParamJson = storeDomain.getStoreObj().toString();
        }
        try {
            long start = System.currentTimeMillis();
            this.esUtil.httpUrlInsert(queryParamJson, method, data, type, id);
            this.logger.info("es.SearchengineServiceImpl.httpUrlInsert.\u8017\u65f6", (Object)(System.currentTimeMillis() - start));
            return true;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.store", (Throwable)e);
            return false;
        }
    }

    @Override
    public Map<String, Object> findByCode(String opcode, String bizType, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)opcode) || StringUtils.isBlank((String)bizType) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.null", (Object)"null");
            return null;
        }
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGetByCode(tenantCode, bizType, opcode);
            this.logger.info("es.SearchengineServiceImpl.findByCode.find", (Object)(opcode + "=" + (System.currentTimeMillis() - times)));
            if (StringUtils.isBlank((String)str)) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.str", (Object)opcode);
                return null;
            }
            DataHits remap = (DataHits)JsonUtil.buildNormalBinder().getJsonToObject(str, DataHits.class);
            if (null == remap || MapUtil.isEmpty(remap.get_source())) {
                this.logger.error("es.SearchengineServiceImpl.findByCode.remap", (Object)str);
                return null;
            }
            return remap.get_source();
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.findByCode.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public ReturnBean newFind(SearchDomain searchDomain) throws ApiException {
        int from;
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"null");
            return null;
        }
        this.logger.debug(SYS_CODE, (Object)("searchDomain info:" + searchDomain));
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.find.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 1;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 1;
        }
        if ((from = (Integer.valueOf(page) - 1) * Integer.valueOf(rows)) < 0) {
            from = 0;
        }
        String queryJson = "";
        String sortStr = "\"sort\":[";
        String sortList = "";
        if (null != searchDomain.getSortDomain()) {
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getOrder())) {
                searchDomain.getSortDomain().setOrder(searchDomain.getSortDomain().getOrder().toLowerCase());
            }
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getSortField())) {
                sortList = sortList + " { \"" + searchDomain.getSortDomain().getSortField() + "\": { \"order\": \"" + searchDomain.getSortDomain().getOrder() + "\" }}";
            }
            if (ListUtil.isEmpty(searchDomain.getSortDomain().getSortDomainList())) {
                for (SortDomain sortDomain : searchDomain.getSortDomain().getSortDomainList()) {
                    if (StringUtils.isNotBlank((String)sortList)) {
                        sortList = sortList + ",";
                    }
                    sortList = sortList + " { \"" + sortDomain.getSortField() + "\": { \"order\": \"" + sortDomain.getOrder() + "\" }}";
                }
            }
            sortStr = sortStr + sortList;
        } else {
            sortStr = sortStr + " { \"_score\": { \"order\": \"desc\" }}";
        }
        sortStr = sortStr + "]";
        String musQueryStr = "";
        String mustNotQueryStr = "";
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                boolean flag;
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if ("must_not".equals(accurateQueryDomain.getAccurateFieType())) {
                    if (StringUtils.isNotBlank((String)mustNotQueryStr)) {
                        mustNotQueryStr = mustNotQueryStr + ",";
                    }
                    if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                        mustNotQueryStr = mustNotQueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag) + "}}";
                        continue;
                    }
                    if (!flag) {
                        accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                    }
                    mustNotQueryStr = mustNotQueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
                    continue;
                }
                if (StringUtils.isNotBlank((String)musQueryStr)) {
                    musQueryStr = musQueryStr + ",";
                }
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    musQueryStr = musQueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag) + "}}";
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                musQueryStr = musQueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
            }
        }
        String aggregationsStr = "";
        if (MapUtil.isNotEmpty(searchDomain.getGroupListMap()) || MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
            aggregationsStr = aggregationsStr + "\"aggregations\":{";
            String px = "";
            if (MapUtil.isNotEmpty(searchDomain.getGroupListMap())) {
                String liststr = "";
                Object value = "20";
                for (String key : searchDomain.getGroupListMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    value = String.valueOf(searchDomain.getGroupListMap().get(key));
                    liststr = liststr + "\"" + key + "\":{\"terms\":{\"field\":\"" + key + ".keyword\",\"size\":" + (String)value + "}}";
                }
                aggregationsStr = aggregationsStr + liststr;
                px = ",";
            }
            if (MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
                String liststr = "";
                for (String key : searchDomain.getGroupNumMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    liststr = liststr + "\"" + key + "min\":{\"min\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "max\":{\"max\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "avg\":{\"avg\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "sum\":{\"sum\":{\"field\":\"" + key + "\"}}";
                }
                aggregationsStr = aggregationsStr + px + liststr;
            }
            aggregationsStr = aggregationsStr + "}";
        }
        if (StringUtils.isNotBlank((String)aggregationsStr)) {
            aggregationsStr = "," + aggregationsStr;
        }
        String headStr = "{\"query\":{\"bool\":{\"";
        String endStr = "}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + aggregationsStr + "}";
        if (StringUtils.isNotBlank((String)musQueryStr)) {
            queryJson = headStr + "must\":[" + musQueryStr + "]";
        }
        if (StringUtils.isNotBlank((String)mustNotQueryStr)) {
            queryJson = queryJson + ",\"must_not\":[" + mustNotQueryStr + "]";
        }
        queryJson = queryJson + endStr;
        this.logger.error("es.SearchengineServiceImpl.newFind.queryJson", (Object)queryJson);
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGet(data, searchDomain.getBizType(), queryJson);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - times));
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            RestBean restBean = (RestBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RestBean.class);
            if (null == restBean || null == restBean.getHits() || null == restBean.getHits().getHits()) {
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            List<DataHits> list = restBean.getHits().getHits();
            if (null == list || list.isEmpty()) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (DataHits dataHits : list) {
                HashMap<String, Double> dataHit = new HashMap<String, Double>();
                try {
                    BeanUtils.copyAllPropertys(dataHit, dataHits.get_source());
                    dataHit.put("score", dataHits.get_score());
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"search response convert exception:", (Throwable)e);
                }
                sourcelist.add(dataHit);
            }
            returnBean.setAggregations(restBean.getAggregations());
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(restBean.getHits().getTotal());
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (IOException e) {
            this.logger.error("es.SearchengineServiceImpl.find.e", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ApiMethod(code="es.searchengine.find", name="\u83b7\u53d6\u6570\u636e", paramStr="searchDomain", description="")
    public ReturnBean find(SearchDomain searchDomain) throws ApiException {
        void var17_37;
        void var13_18;
        void var17_35;
        int from;
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"null");
            return null;
        }
        this.logger.debug(SYS_CODE, (Object)("searchDomain info:" + searchDomain));
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.find.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 1;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 1;
        }
        if ((from = (Integer.valueOf(page) - 1) * Integer.valueOf(rows)) < 0) {
            from = 0;
        }
        String queryStr = "";
        String matchQuery = "";
        String queryJson = "";
        String sortStr = "\"sort\":[";
        String sortList = "";
        if (null != searchDomain.getSortDomain()) {
            if (StringUtils.isNotBlank((String)searchDomain.getSortDomain().getSortField())) {
                sortList = sortList + " { \"" + searchDomain.getSortDomain().getSortField() + "\": { \"order\": \"" + searchDomain.getSortDomain().getOrder() + "\" }}";
            }
            if (null != searchDomain.getSortDomain() && ListUtil.isNotEmpty(searchDomain.getSortDomain().getSortDomainList())) {
                for (SortDomain sortDomain : searchDomain.getSortDomain().getSortDomainList()) {
                    if (StringUtils.isNotBlank((String)sortList)) {
                        sortList = sortList + ",";
                    }
                    sortList = sortList + " { \"" + sortDomain.getSortField() + "\": { \"order\": \"" + sortDomain.getOrder() + "\" }}";
                }
            }
            sortStr = sortStr + sortList;
        } else {
            sortStr = sortStr + " { \"_score\": { \"order\": \"desc\" }}";
        }
        sortStr = sortStr + "]";
        if (null != searchDomain.getBoolMap() && !searchDomain.getBoolMap().isEmpty()) {
            Object obj = null;
            for (String key : searchDomain.getBoolMap().keySet()) {
                if (StringUtils.isNotBlank((String)matchQuery)) {
                    matchQuery = matchQuery + ",";
                }
                obj = searchDomain.getBoolMap().get(key);
                if ("match_phrase".equals(searchDomain.getSearchType())) {
                    matchQuery = matchQuery + "{\"match_phrase\":{\"" + key + "\":{\"query\":\"" + obj + "\"}}}";
                    continue;
                }
                matchQuery = matchQuery + "{\"wildcard\": { \"" + key + ".keyword\":\"*" + obj + "*\"}},";
                matchQuery = matchQuery + "{\"match\": { \"" + key + "\":\"" + obj + "\"}}";
            }
            queryStr = "match_phrase".equals(searchDomain.getSearchType()) ? matchQuery : "{\"bool\":{\"should\":[" + matchQuery + "]}}";
        }
        if (null == searchDomain.getMinPrice()) {
            searchDomain.setMinPrice(Double.valueOf("0"));
        }
        String range = "{      \"pricesetNprice\": {        \"gte\": " + searchDomain.getMinPrice() + "      }}";
        if (null != searchDomain.getMaxPrice()) {
            range = "      {\"pricesetNprice\": {        \"gte\": " + searchDomain.getMinPrice() + ",        \"lte\": " + searchDomain.getMaxPrice() + "      }}";
        }
        String string = ",{\"range\":" + range + "}";
        String rangenum = "";
        if (null != searchDomain.getMinNum() || null != searchDomain.getMaxNum()) {
            rangenum = rangenum + "{      \"goodsSupplynum\": {";
            if (null != searchDomain.getMinNum()) {
                rangenum = rangenum + "        \"gt\": " + searchDomain.getMinNum() + "";
            }
            if (null != searchDomain.getMaxNum()) {
                if (null != searchDomain.getMinNum()) {
                    rangenum = rangenum + ",";
                }
                rangenum = rangenum + "        \"lt\": " + searchDomain.getMaxNum() + "";
            }
            rangenum = rangenum + "      }    }";
        }
        if (StringUtils.isNotBlank((String)rangenum)) {
            String string2 = string + ",{\"range\":" + rangenum + "}";
        }
        String accqueryStr = "";
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                boolean flag;
                if (StringUtils.isNotBlank((String)accqueryStr)) {
                    accqueryStr = accqueryStr + ",";
                }
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    accqueryStr = accqueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag) + "}}";
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                accqueryStr = accqueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
            }
        }
        String notaccqueryStr = "";
        if (null != searchDomain.getNotaccurateQueryList() && !searchDomain.getNotaccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getNotaccurateQueryList()) {
                boolean flag;
                if (StringUtils.isNotBlank((String)notaccqueryStr)) {
                    notaccqueryStr = notaccqueryStr + ",";
                }
                boolean bl = flag = accurateQueryDomain.getAccurateField().indexOf(".keyword") > 0;
                if (ListUtil.isNotEmpty(accurateQueryDomain.getAccurateFieldValues())) {
                    notaccqueryStr = notaccqueryStr + "{\"terms\" : {\"" + accurateQueryDomain.getAccurateField() + "\":" + SearchengineServiceImpl.list2string(accurateQueryDomain.getAccurateFieldValues(), flag) + "}}";
                    continue;
                }
                if (!flag) {
                    accurateQueryDomain.setAccurateFieldValue(accurateQueryDomain.getAccurateFieldValue().toLowerCase());
                }
                notaccqueryStr = notaccqueryStr + "{\"term\" : {\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"}}";
            }
        }
        String string3 = "";
        if (MapUtil.isNotEmpty(searchDomain.getGroupListMap()) || MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
            void var17_33;
            String string4 = string3 + "\"aggregations\":{";
            String px = "";
            if (MapUtil.isNotEmpty(searchDomain.getGroupListMap())) {
                String liststr = "";
                String value = "20";
                for (String key : searchDomain.getGroupListMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    value = String.valueOf(searchDomain.getGroupListMap().get(key));
                    liststr = liststr + "\"" + key + "\":{\"terms\":{\"field\":\"" + key + ".keyword\",\"size\":" + value + "}}";
                }
                String string5 = string4 + liststr;
                px = ",";
            }
            if (MapUtil.isNotEmpty(searchDomain.getGroupNumMap())) {
                void var17_31;
                String liststr = "";
                for (String key : searchDomain.getGroupNumMap().keySet()) {
                    if (StringUtils.isNotBlank((String)liststr)) {
                        liststr = liststr + ",";
                    }
                    liststr = liststr + "\"" + key + "min\":{\"min\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "max\":{\"max\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "avg\":{\"avg\":{\"field\":\"" + key + "\"}}";
                    liststr = liststr + ",\"" + key + "sum\":{\"sum\":{\"field\":\"" + key + "\"}}";
                }
                String string6 = (String)var17_31 + px + liststr;
            }
            String string7 = (String)var17_33 + "}";
        }
        if (StringUtils.isNotBlank((String)var17_35)) {
            String string8 = "," + (String)var17_35;
        }
        String queryWay = ConstantEnums.must.getCode();
        if (StringUtils.isNotBlank((String)searchDomain.getQueryType())) {
            queryWay = searchDomain.getQueryType();
        }
        if (StringUtils.isNotBlank((String)accqueryStr)) {
            if (StringUtils.isNotBlank((String)queryStr)) {
                queryStr = "," + queryStr;
            }
            queryJson = "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + accqueryStr + queryStr + (String)var13_18 + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var17_37 + "}";
            if (StringUtils.isNotBlank((String)notaccqueryStr)) {
                queryJson = "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + accqueryStr + queryStr + (String)var13_18 + "],\"must_not\":[" + notaccqueryStr + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var17_37 + "}";
            }
        } else {
            void var13_21;
            if (!StringUtils.isNotBlank((String)queryStr)) {
                String string10 = var13_18.trim();
                string10 = string10.substring(1);
            }
            queryJson = "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + queryStr + (String)var13_21 + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var17_37 + "}";
            if (StringUtils.isNotBlank((String)notaccqueryStr)) {
                queryJson = "{\"query\":{\"bool\":{\"" + queryWay + "\":[" + queryStr + (String)var13_21 + "],\"must_not\":[" + notaccqueryStr + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + (String)var17_37 + "}";
            }
        }
        try {
            long times = System.currentTimeMillis();
            String str = this.esUtil.httpUrlPoolGet(data, searchDomain.getBizType(), queryJson);
            OpenPerfLogUtil.info((String)("[find]htt:{},api:" + searchDomain.getBizType()), (long)(System.currentTimeMillis() - times));
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            RestBean restBean = (RestBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RestBean.class);
            if (null == restBean || null == restBean.getHits() || null == restBean.getHits().getHits()) {
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            List<DataHits> list = restBean.getHits().getHits();
            if (null == list || list.isEmpty()) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (DataHits dataHits : list) {
                HashMap<String, Double> dataHit = new HashMap<String, Double>();
                try {
                    BeanUtils.copyAllPropertys(dataHit, dataHits.get_source());
                    dataHit.put("score", dataHits.get_score());
                }
                catch (Exception e) {
                    this.logger.error(SYS_CODE, (Object)"search response convert exception:", (Throwable)e);
                }
                sourcelist.add(dataHit);
            }
            returnBean.setAggregations(restBean.getAggregations());
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(restBean.getHits().getTotal());
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (IOException e) {
            this.logger.error("es.SearchengineServiceImpl.find.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public void refresh(SearchDomain searchDomain) throws ApiException {
    }

    @Override
    public String deletePm(PmPromotionDomain pmPromotionDomain) {
        if (null == pmPromotionDomain) {
            return "error";
        }
        return this.makePm(pmPromotionDomain, true);
    }

    @Override
    public String updatePm(PmPromotionDomain pmPromotionDomain) {
        if (null == pmPromotionDomain) {
            return "error";
        }
        return this.makePm(pmPromotionDomain, false);
    }

    @Override
    public String insertPm(PmPromotionDomain pmPromotionDomain) {
        if (null == pmPromotionDomain) {
            return "error";
        }
        return this.makePm(pmPromotionDomain, false);
    }

    public String makePm(PmPromotionDomain pmPromotionDomain, boolean delflag) {
        if (null == pmPromotionDomain) {
            return "error";
        }
        String tenantCode = pmPromotionDomain.getTenantCode();
        Integer rows = 50;
        Integer page = 1;
        SearchDomain searchDomain = new SearchDomain();
        searchDomain.setTenantCode(tenantCode);
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        pageMap.put("rows", rows);
        pageMap.put("page", page);
        searchDomain.setPageMap(pageMap);
        this.makeEsquery(pmPromotionDomain, searchDomain);
        searchDomain.setBizType("goods");
        this.query(rows, searchDomain, pmPromotionDomain, delflag);
        searchDomain.setBizType("sku");
        this.query(rows, searchDomain, pmPromotionDomain, delflag);
        return "success";
    }

    private void query(Integer rows, SearchDomain searchDomain, PmPromotionDomain pmPromotionDomain, boolean delflag) {
        boolean flag = true;
        Integer page = 1;
        do {
            try {
                HashMap<String, Object> pageMap = new HashMap<String, Object>();
                pageMap.put("rows", rows);
                pageMap.put("page", page);
                searchDomain.setPageMap(pageMap);
                ReturnBean returnBean = this.find(searchDomain);
                if (null == returnBean || ListUtil.isEmpty(returnBean.getSourcelist())) {
                    this.logger.error("es.SearchengineServiceImpl.query.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)searchDomain));
                    flag = false;
                } else {
                    SearchengineServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(SearchengineServiceImpl.getEsEngineService(), returnBean.getSourcelist(), pmPromotionDomain, delflag, searchDomain.getBizType()));
                    if (returnBean.getSourcelist().size() != SearchengineServiceImpl.getEsEngineService().getPage()) {
                        flag = false;
                    }
                }
                Integer n = page;
                Integer n2 = page = Integer.valueOf(page + 1);
            }
            catch (Exception e) {
                this.logger.error("es.SearchengineServiceImpl.query.e", (Throwable)e);
            }
        } while (flag);
        SearchengineServiceImpl.getEsEngineService().initStartRow();
    }

    private SearchDomain makeEsquery(PmPromotionDomain pmPromotionDomain, SearchDomain searchDomain) {
        List<PmPromotionRangelistDomain> pmPromotionRangeList;
        AccurateQueryDomain accurateQueryDomain;
        if (null == pmPromotionDomain || null == searchDomain) {
            this.logger.error("es.SearchengineServiceImpl.makeEsquery.pmPromotionInDomain");
            return searchDomain;
        }
        String memberCcode = pmPromotionDomain.getMemberCcode();
        String channelCode = pmPromotionDomain.getChannelCode();
        List<AccurateQueryDomain> accurateQueryList = new ArrayList<AccurateQueryDomain>();
        searchDomain.setAccurateQueryList(accurateQueryList);
        if (StringUtils.isNotBlank((String)memberCcode)) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("memberCcode.keyword");
            accurateQueryDomain.setAccurateFieldValue(memberCcode);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("channelCode.keyword");
            accurateQueryDomain.setAccurateFieldValue(memberCcode);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (ListUtil.isEmpty(pmPromotionRangeList = pmPromotionDomain.getPmPromotionRangeList())) {
            this.logger.error("es.SearchengineServiceImpl.makeEsquery.pmPromotionRangeList");
            return searchDomain;
        }
        String value = "";
        String valueList = "";
        if (pmPromotionDomain.getRangeType().intValue() != SearchengineConstants.RANGE_TYPE_1.intValue()) {
            if (pmPromotionDomain.getRangeType().intValue() == SearchengineConstants.RANGE_TYPE_2.intValue()) {
                value = "pntreeCode";
            } else if (pmPromotionDomain.getRangeType().intValue() == SearchengineConstants.RANGE_TYPE_3.intValue()) {
                value = "brandCode";
            } else if (pmPromotionDomain.getRangeType().intValue() == SearchengineConstants.RANGE_TYPE_4.intValue()) {
                value = "classtreeCode";
            } else if (pmPromotionDomain.getRangeType().intValue() == SearchengineConstants.RANGE_TYPE_5.intValue()) {
                value = "skuNo";
                valueList = "skuNoList";
            }
        }
        String term = "";
        ArrayList<String> accurateFieldValues = new ArrayList<String>();
        ArrayList<String> notaccurateFieldValues = new ArrayList<String>();
        for (PmPromotionRangelistDomain pmPromotionRangelistDomain : pmPromotionRangeList) {
            if (1 == pmPromotionRangelistDomain.getPprlType()) continue;
            term = pmPromotionRangelistDomain.getPprlTerm();
            if (StringUtils.isBlank((String)term)) {
                term = "=";
            }
            if ("=".equals(term)) {
                accurateFieldValues.add(pmPromotionRangelistDomain.getRangeCode());
                continue;
            }
            notaccurateFieldValues.add(pmPromotionRangelistDomain.getRangeCode());
        }
        if (ListUtil.isNotEmpty(accurateFieldValues)) {
            accurateQueryList = searchDomain.getAccurateQueryList();
            if (null == accurateQueryList) {
                accurateQueryList = new ArrayList();
                searchDomain.setAccurateQueryList(accurateQueryList);
            }
            AccurateQueryDomain accurateQueryDomain2 = new AccurateQueryDomain();
            accurateQueryDomain2.setAccurateField(value);
            accurateQueryList.add(accurateQueryDomain2);
            accurateQueryDomain2.setAccurateFieldValues(accurateFieldValues);
            if (StringUtils.isNotBlank((String)valueList)) {
                AccurateQueryDomain accurateQueryDomain1 = new AccurateQueryDomain();
                accurateQueryDomain1.setAccurateField(valueList);
                accurateQueryList.add(accurateQueryDomain1);
                accurateQueryDomain2.setAccurateFieldValues(accurateFieldValues);
            }
        }
        if (ListUtil.isNotEmpty(notaccurateFieldValues)) {
            ArrayList<AccurateQueryDomain> notaccurateQueryList = new ArrayList<AccurateQueryDomain>();
            AccurateQueryDomain accurateQueryDomain3 = new AccurateQueryDomain();
            accurateQueryDomain3.setAccurateField(value);
            notaccurateQueryList.add(accurateQueryDomain3);
            searchDomain.setNotaccurateQueryList(notaccurateQueryList);
            accurateQueryDomain3.setAccurateFieldValues(notaccurateFieldValues);
            if (StringUtils.isNotBlank((String)valueList)) {
                AccurateQueryDomain accurateQueryDomain1 = new AccurateQueryDomain();
                accurateQueryDomain1.setAccurateField(valueList);
                notaccurateQueryList.add(accurateQueryDomain1);
                accurateQueryDomain3.setAccurateFieldValues(accurateFieldValues);
            }
        }
        return searchDomain;
    }

    @Override
    public String updateStore(EsBean esBean) throws ApiException {
        if (null == esBean || null == esBean.getPmPromotionDomain() || null == esBean.getRsData()) {
            this.logger.error("es.SearchengineServiceImpl.updateStore.null");
            return null;
        }
        try {
            return this.updateStoreEs(esBean);
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.updateStore.e", (Throwable)e);
            return null;
        }
    }

    public String updateStoreEs(EsBean esBean) throws ApiException {
        if (null == esBean || null == esBean.getPmPromotionDomain() || null == esBean.getRsData()) {
            this.logger.error("es.SearchengineServiceImpl.updateStore.null");
            return null;
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setBizType(esBean.getBizType());
        storeDomain.setTenantCode(esBean.getPmPromotionDomain().getTenantCode());
        storeDomain.setRequestType(StoreEnum.ESUPDATE.getType());
        if ("goods".equals(storeDomain.getBizType())) {
            storeDomain.setBizId(esBean.getPmPromotionDomain().getTenantCode() + (String)esBean.getRsData().get("goodsCode"));
        } else {
            storeDomain.setBizId(esBean.getPmPromotionDomain().getTenantCode() + (String)esBean.getRsData().get("skuCode"));
        }
        this.logger.error("es.SearchengineServiceImpl.updateStore.storeDomain", (Object)storeDomain.getBizId());
        if (!esBean.isDelflag()) {
            List<PmPromotionRangelistDomain> pmPromotionRangeList;
            if ("5".equals(esBean.getPmPromotionDomain().getPromotionInType()) && ListUtil.isNotEmpty(esBean.getPmPromotionDomain().getPmPromotionDiscountList()) && ListUtil.isNotEmpty(pmPromotionRangeList = esBean.getPmPromotionDomain().getPmPromotionRangeList())) {
                BigDecimal pricesetNprice = new BigDecimal(String.valueOf(esBean.getRsData().get("pricesetNprice")));
                for (PmPromotionRangelistDomain pmPromotionDiscountlistDomain : pmPromotionRangeList) {
                    if (null == pmPromotionDiscountlistDomain.getDiscountAmount1()) {
                        pmPromotionDiscountlistDomain.setDiscountAmount1(BigDecimal.ZERO);
                    }
                    if (pricesetNprice.compareTo(pmPromotionDiscountlistDomain.getDiscountAmount1()) <= 0) continue;
                    esBean.getRsData().put("minPricesetNprice", pmPromotionDiscountlistDomain.getDiscountAmount1());
                    esBean.getRsData().put("pricesetNprice", pmPromotionDiscountlistDomain.getDiscountAmount1());
                }
            }
            List pmListdata = (List)esBean.getRsData().get("pmPromotionDomainList");
            ArrayList<Map> newpmListdata = new ArrayList<Map>();
            HashMap<String, String> pb = new HashMap<String, String>();
            boolean add = false;
            if (ListUtil.isNotEmpty((Collection)pmListdata)) {
                for (Map map2 : pmListdata) {
                    if (((String)map2.get("promotionCode")).equals(esBean.getPmPromotionDomain().getPromotionCode())) {
                        add = true;
                        PmPromotionInDomain pmPromotionInDomain = new PmPromotionInDomain();
                        try {
                            BeanUtils.copyAllPropertys((Object)pmPromotionInDomain, (Object)esBean.getPmPromotionDomain());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        map2 = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)pmPromotionInDomain), String.class, Object.class);
                    }
                    newpmListdata.add(map2);
                    pb.put((String)map2.get("pbCode"), (String)map2.get("pbName"));
                }
            }
            if (!add) {
                Map map2;
                PmPromotionInDomain pmPromotionInDomain = new PmPromotionInDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)pmPromotionInDomain, (Object)esBean.getPmPromotionDomain());
                }
                catch (Exception map2) {
                    // empty catch block
                }
                map2 = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)pmPromotionInDomain), String.class, Object.class);
                newpmListdata.add(map2);
            }
            if (ListUtil.isEmpty(newpmListdata)) {
                esBean.getRsData().put("pmflag", 0);
            } else {
                esBean.getRsData().put("pmflag", 1);
            }
            ArrayList pmbaseFlag = new ArrayList();
            if (MapUtil.isNotEmpty(pb)) {
                for (String key : pb.keySet()) {
                    HashMap<String, String> pmap = new HashMap<String, String>();
                    pmap.put("pbCode", key);
                    pmap.put("pbName", (String)pb.get(key));
                    pmbaseFlag.add(pmap);
                }
            }
            esBean.getRsData().put("pmbaseFlag", pmbaseFlag);
            esBean.getRsData().put("pmPromotionDomainList", newpmListdata);
        } else {
            List pmListdata = (List)esBean.getRsData().get("pmPromotionDomainList");
            if (ListUtil.isNotEmpty((Collection)pmListdata)) {
                ArrayList<Map> newpmListdata = new ArrayList<Map>();
                HashMap<String, String> pb = new HashMap<String, String>();
                for (Map map : pmListdata) {
                    if (((String)map.get("promotionCode")).equals(esBean.getPmPromotionDomain().getPromotionCode())) continue;
                    newpmListdata.add(map);
                    pb.put((String)map.get("pbCode"), (String)map.get("pbName"));
                }
                if (ListUtil.isEmpty(newpmListdata)) {
                    esBean.getRsData().put("pmflag", 0);
                }
                ArrayList pmbaseFlag = new ArrayList();
                if (MapUtil.isNotEmpty(pb)) {
                    for (String key : pb.keySet()) {
                        HashMap<String, String> pmap = new HashMap<String, String>();
                        pmap.put("pbCode", key);
                        pmap.put("pbName", (String)pb.get(key));
                        pmbaseFlag.add(pmap);
                    }
                }
                esBean.getRsData().put("pmbaseFlag", pmbaseFlag);
                esBean.getRsData().put("pmPromotionDomainList", newpmListdata);
            }
        }
        storeDomain.setStoreObj(JsonUtil.buildNormalBinder().toJson(esBean.getRsData()));
        if (!this.store(storeDomain)) {
            this.logger.error("es.SearchengineServiceImpl.updateStore.store", storeDomain.getStoreObj());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 100; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    static {
        lock = new Object();
    }
}

