/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.share.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.share.dao.ShShparamMapper;
import com.yqbsoft.laser.service.share.domain.ShShparamDomain;
import com.yqbsoft.laser.service.share.domain.ShShparamReDomain;
import com.yqbsoft.laser.service.share.model.ShShparam;
import com.yqbsoft.laser.service.share.service.ShShparamService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShShparamServiceImpl
extends BaseServiceImpl
implements ShShparamService {
    private static final String SYS_CODE = "sh.ShShparamServiceImpl";
    private ShShparamMapper shShparamMapper;

    public void setShShparamMapper(ShShparamMapper shShparamMapper) {
        this.shShparamMapper = shShparamMapper;
    }

    private Date getSysDate() {
        try {
            return this.shShparamMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("sh.ShShparamServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkShparam(ShShparamDomain shShparamDomain) {
        if (null == shShparamDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)shShparamDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setShparamDefault(ShShparam shShparam) {
        if (null == shShparam) {
            return;
        }
        if (null == shShparam.getDataState()) {
            shShparam.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == shShparam.getGmtCreate()) {
            shShparam.setGmtCreate(date);
        }
        shShparam.setGmtModified(date);
        if (StringUtils.isBlank((String)shShparam.getShparamCode())) {
            shShparam.setShparamCode(this.getNo(null, "ShShparam", "shShparam", shShparam.getTenantCode()));
        }
    }

    private int getShparamMaxCode() {
        int code = 0;
        try {
            return this.shShparamMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("sh.ShShparamServiceImpl.getShparamMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setShparamUpdataDefault(ShShparam shShparam) {
        if (null == shShparam) {
            return;
        }
        shShparam.setGmtModified(this.getSysDate());
    }

    private void saveShparamModel(ShShparam shShparam) throws ApiException {
        if (null == shShparam) {
            return;
        }
        try {
            this.shShparamMapper.insert(shShparam);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShparamServiceImpl.saveShparamModel.ex", (Throwable)e);
        }
    }

    private void saveShparamBatchModel(List<ShShparam> shShparamList) throws ApiException {
        if (null == shShparamList || shShparamList.isEmpty()) {
            return;
        }
        try {
            this.shShparamMapper.insertBatch(shShparamList);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShparamServiceImpl.saveShparamBatchModel.ex", (Throwable)e);
        }
    }

    private ShShparam getShparamModelById(Integer shparamId) {
        if (null == shparamId) {
            return null;
        }
        try {
            return this.shShparamMapper.selectByPrimaryKey(shparamId);
        }
        catch (Exception e) {
            this.logger.error("sh.ShShparamServiceImpl.getShparamModelById", (Throwable)e);
            return null;
        }
    }

    private ShShparam getShparamModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.shShparamMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("sh.ShShparamServiceImpl.getShparamModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delShparamModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.shShparamMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShparamServiceImpl.delShparamModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sh.ShShparamServiceImpl.delShparamModelByCode.num");
        }
    }

    private void deleteShparamModel(Integer shparamId) throws ApiException {
        if (null == shparamId) {
            return;
        }
        int i = 0;
        try {
            i = this.shShparamMapper.deleteByPrimaryKey(shparamId);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShparamServiceImpl.deleteShparamModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sh.ShShparamServiceImpl.deleteShparamModel.num");
        }
    }

    private void updateShparamModel(ShShparam shShparam) throws ApiException {
        if (null == shShparam) {
            return;
        }
        int i = 0;
        try {
            i = this.shShparamMapper.updateByPrimaryKey(shShparam);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShparamServiceImpl.updateShparamModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("sh.ShShparamServiceImpl.updateShparamModel.num");
        }
    }

    private void updateStateShparamModel(Integer shparamId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == shparamId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shparamId", shparamId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.shShparamMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShparamServiceImpl.updateStateShparamModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sh.ShShparamServiceImpl.updateStateShparamModel.null");
        }
    }

    private void updateStateShparamModelByCode(String tenantCode, String shparamCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)shparamCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shparamCode", shparamCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.shShparamMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("sh.ShShparamServiceImpl.updateStateShparamModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("sh.ShShparamServiceImpl.updateStateShparamModelByCode.null");
        }
    }

    private ShShparam makeShparam(ShShparamDomain shShparamDomain, ShShparam shShparam) {
        if (null == shShparamDomain) {
            return null;
        }
        if (null == shShparam) {
            shShparam = new ShShparam();
        }
        try {
            BeanUtils.copyAllPropertys((Object)shShparam, (Object)shShparamDomain);
            return shShparam;
        }
        catch (Exception e) {
            this.logger.error("sh.ShShparamServiceImpl.makeShparam", (Throwable)e);
            return null;
        }
    }

    private ShShparamReDomain makeShShparamReDomain(ShShparam shShparam) {
        if (null == shShparam) {
            return null;
        }
        ShShparamReDomain shShparamReDomain = new ShShparamReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)shShparamReDomain, (Object)shShparam);
            return shShparamReDomain;
        }
        catch (Exception e) {
            this.logger.error("sh.ShShparamServiceImpl.makeShShparamReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ShShparam> queryShparamModelPage(Map<String, Object> parammap) {
        try {
            return this.shShparamMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("sh.ShShparamServiceImpl.queryShparamModel", (Throwable)e);
            return null;
        }
    }

    private int countShparam(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.shShparamMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("sh.ShShparamServiceImpl.countShparam", (Throwable)e);
        }
        return i;
    }

    private ShShparam createShShparam(ShShparamDomain shShparamDomain) {
        String msg = this.checkShparam(shShparamDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sh.ShShparamServiceImpl.saveShparam.checkShparam", msg);
        }
        ShShparam shShparam = this.makeShparam(shShparamDomain, null);
        this.setShparamDefault(shShparam);
        return shShparam;
    }

    @Override
    public String saveShparam(ShShparamDomain shShparamDomain) throws ApiException {
        ShShparam shShparam = this.createShShparam(shShparamDomain);
        this.saveShparamModel(shShparam);
        return shShparam.getShparamCode();
    }

    @Override
    public String saveShparamBatch(List<ShShparamDomain> shShparamDomainList) throws ApiException {
        if (null == shShparamDomainList || shShparamDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ShShparam> shShparamList = new ArrayList<ShShparam>();
        String code = "";
        for (ShShparamDomain shShparamDomain : shShparamDomainList) {
            ShShparam shShparam = this.createShShparam(shShparamDomain);
            code = shShparam.getShparamCode();
            shShparamList.add(shShparam);
        }
        this.saveShparamBatchModel(shShparamList);
        return code;
    }

    @Override
    public void updateShparamState(Integer shparamId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == shparamId) {
            return;
        }
        this.updateStateShparamModel(shparamId, dataState, oldDataState, map);
    }

    @Override
    public void updateShparamStateByCode(String tenantCode, String shparamCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)shparamCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateShparamModelByCode(tenantCode, shparamCode, dataState, oldDataState, map);
    }

    @Override
    public void updateShparam(ShShparamDomain shShparamDomain) throws ApiException {
        String msg = this.checkShparam(shShparamDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("sh.ShShparamServiceImpl.updateShparam.checkShparam", msg);
        }
        ShShparam oldShShparam = this.getShparamModelById(shShparamDomain.getShparamId());
        if (null == oldShShparam) {
            throw new ApiException("sh.ShShparamServiceImpl.updateShparam.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ShShparam shShparam = this.makeShparam(shShparamDomain, oldShShparam);
        this.setShparamUpdataDefault(shShparam);
        this.updateShparamModel(shShparam);
    }

    @Override
    public ShShparam getShparam(Integer shparamId) {
        if (null == shparamId) {
            return null;
        }
        return this.getShparamModelById(shparamId);
    }

    @Override
    public void deleteShparam(Integer shparamId) throws ApiException {
        if (null == shparamId) {
            return;
        }
        this.deleteShparamModel(shparamId);
    }

    @Override
    public QueryResult<ShShparam> queryShparamPage(Map<String, Object> map) {
        List<ShShparam> shShparamList = this.queryShparamModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countShparam(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(shShparamList);
        return queryResult;
    }

    @Override
    public ShShparam getShparamByCode(String tenantCode, String shparamCode) throws ApiException {
        if (StringUtils.isBlank((String)shparamCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shparamCode", shparamCode);
        return this.getShparamModelByCode(map);
    }

    @Override
    public void deleteShparamByCode(String tenantCode, String shparamCode) throws ApiException {
        if (StringUtils.isBlank((String)shparamCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("shparamCode", shparamCode);
        this.delShparamModelByCode(map);
    }
}

