/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.tenantmanag.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tenantmanag.dao.TmSceneSproappMapper;
import com.yqbsoft.laser.service.tenantmanag.domain.TmSceneSproappDomain;
import com.yqbsoft.laser.service.tenantmanag.domain.TmSceneSproappReDomain;
import com.yqbsoft.laser.service.tenantmanag.model.TmSceneSproapp;
import com.yqbsoft.laser.service.tenantmanag.service.TmSceneSproappService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TmSceneSproappServiceImpl
extends BaseServiceImpl
implements TmSceneSproappService {
    private static final String SYS_CODE = "tm.TmSceneSproappServiceImpl";
    private TmSceneSproappMapper tmSceneSproappMapper;

    public void setTmSceneSproappMapper(TmSceneSproappMapper tmSceneSproappMapper) {
        this.tmSceneSproappMapper = tmSceneSproappMapper;
    }

    private Date getSysDate() {
        try {
            return this.tmSceneSproappMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("tm.TmSceneSproappServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSceneSproapp(TmSceneSproappDomain tmSceneSproappDomain) {
        if (null == tmSceneSproappDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)tmSceneSproappDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSceneSproappDefault(TmSceneSproapp tmSceneSproapp) {
        if (null == tmSceneSproapp) {
            return;
        }
        if (null == tmSceneSproapp.getDataState()) {
            tmSceneSproapp.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == tmSceneSproapp.getGmtCreate()) {
            tmSceneSproapp.setGmtCreate(date);
        }
        tmSceneSproapp.setGmtModified(date);
        if (StringUtils.isBlank((String)tmSceneSproapp.getSceneSproappCode())) {
            tmSceneSproapp.setSceneSproappCode(this.getNo(null, "TmSceneSproapp", "tmSceneSproapp", tmSceneSproapp.getTenantCode()));
        }
    }

    private int getSceneSproappMaxCode() {
        int code = 0;
        try {
            return this.tmSceneSproappMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("tm.TmSceneSproappServiceImpl.getSceneSproappMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSceneSproappUpdataDefault(TmSceneSproapp tmSceneSproapp) {
        if (null == tmSceneSproapp) {
            return;
        }
        tmSceneSproapp.setGmtModified(this.getSysDate());
    }

    private void saveSceneSproappModel(TmSceneSproapp tmSceneSproapp) throws ApiException {
        if (null == tmSceneSproapp) {
            return;
        }
        try {
            this.tmSceneSproappMapper.insert(tmSceneSproapp);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.saveSceneSproappModel.ex", (Throwable)e);
        }
    }

    private void saveSceneSproappBatchModel(List<TmSceneSproapp> tmSceneSproappList) throws ApiException {
        if (null == tmSceneSproappList || tmSceneSproappList.isEmpty()) {
            return;
        }
        try {
            this.tmSceneSproappMapper.insertBatch(tmSceneSproappList);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.saveSceneSproappBatchModel.ex", (Throwable)e);
        }
    }

    private TmSceneSproapp getSceneSproappModelById(Integer sceneSproappId) {
        if (null == sceneSproappId) {
            return null;
        }
        try {
            return this.tmSceneSproappMapper.selectByPrimaryKey(sceneSproappId);
        }
        catch (Exception e) {
            this.logger.error("tm.TmSceneSproappServiceImpl.getSceneSproappModelById", (Throwable)e);
            return null;
        }
    }

    private TmSceneSproapp getSceneSproappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.tmSceneSproappMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmSceneSproappServiceImpl.getSceneSproappModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSceneSproappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.tmSceneSproappMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.delSceneSproappModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.delSceneSproappModelByCode.num");
        }
    }

    private void deleteSceneSproappModel(Integer sceneSproappId) throws ApiException {
        if (null == sceneSproappId) {
            return;
        }
        int i = 0;
        try {
            i = this.tmSceneSproappMapper.deleteByPrimaryKey(sceneSproappId);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.deleteSceneSproappModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.deleteSceneSproappModel.num");
        }
    }

    private void updateSceneSproappModel(TmSceneSproapp tmSceneSproapp) throws ApiException {
        if (null == tmSceneSproapp) {
            return;
        }
        int i = 0;
        try {
            i = this.tmSceneSproappMapper.updateByPrimaryKey(tmSceneSproapp);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.updateSceneSproappModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.updateSceneSproappModel.num");
        }
    }

    private void updateStateSceneSproappModel(Integer sceneSproappId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sceneSproappId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sceneSproappId", sceneSproappId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmSceneSproappMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.updateStateSceneSproappModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.updateStateSceneSproappModel.null");
        }
    }

    private void updateStateSceneSproappModelByCode(String tenantCode, String sceneSproappCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sceneSproappCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sceneSproappCode", sceneSproappCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.tmSceneSproappMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.updateStateSceneSproappModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.updateStateSceneSproappModelByCode.null");
        }
    }

    private TmSceneSproapp makeSceneSproapp(TmSceneSproappDomain tmSceneSproappDomain, TmSceneSproapp tmSceneSproapp) {
        if (null == tmSceneSproappDomain) {
            return null;
        }
        if (null == tmSceneSproapp) {
            tmSceneSproapp = new TmSceneSproapp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)tmSceneSproapp, (Object)tmSceneSproappDomain);
            return tmSceneSproapp;
        }
        catch (Exception e) {
            this.logger.error("tm.TmSceneSproappServiceImpl.makeSceneSproapp", (Throwable)e);
            return null;
        }
    }

    private TmSceneSproappReDomain makeTmSceneSproappReDomain(TmSceneSproapp tmSceneSproapp) {
        if (null == tmSceneSproapp) {
            return null;
        }
        TmSceneSproappReDomain tmSceneSproappReDomain = new TmSceneSproappReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)tmSceneSproappReDomain, (Object)tmSceneSproapp);
            return tmSceneSproappReDomain;
        }
        catch (Exception e) {
            this.logger.error("tm.TmSceneSproappServiceImpl.makeTmSceneSproappReDomain", (Throwable)e);
            return null;
        }
    }

    private List<TmSceneSproapp> querySceneSproappModelPage(Map<String, Object> parammap) {
        try {
            return this.tmSceneSproappMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("tm.TmSceneSproappServiceImpl.querySceneSproappModel", (Throwable)e);
            return null;
        }
    }

    private int countSceneSproapp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.tmSceneSproappMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("tm.TmSceneSproappServiceImpl.countSceneSproapp", (Throwable)e);
        }
        return i;
    }

    private TmSceneSproapp createTmSceneSproapp(TmSceneSproappDomain tmSceneSproappDomain) {
        String msg = this.checkSceneSproapp(tmSceneSproappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.saveSceneSproapp.checkSceneSproapp", msg);
        }
        TmSceneSproapp tmSceneSproapp = this.makeSceneSproapp(tmSceneSproappDomain, null);
        this.setSceneSproappDefault(tmSceneSproapp);
        return tmSceneSproapp;
    }

    @Override
    public String saveSceneSproapp(TmSceneSproappDomain tmSceneSproappDomain) throws ApiException {
        TmSceneSproapp tmSceneSproapp = this.createTmSceneSproapp(tmSceneSproappDomain);
        this.saveSceneSproappModel(tmSceneSproapp);
        return tmSceneSproapp.getSceneSproappCode();
    }

    @Override
    public String saveSceneSproappBatch(List<TmSceneSproappDomain> tmSceneSproappDomainList) throws ApiException {
        if (null == tmSceneSproappDomainList || tmSceneSproappDomainList.isEmpty()) {
            return null;
        }
        ArrayList<TmSceneSproapp> tmSceneSproappList = new ArrayList<TmSceneSproapp>();
        String code = "";
        for (TmSceneSproappDomain tmSceneSproappDomain : tmSceneSproappDomainList) {
            TmSceneSproapp tmSceneSproapp = this.createTmSceneSproapp(tmSceneSproappDomain);
            code = tmSceneSproapp.getSceneSproappCode();
            tmSceneSproappList.add(tmSceneSproapp);
        }
        this.saveSceneSproappBatchModel(tmSceneSproappList);
        return code;
    }

    @Override
    public void updateSceneSproappState(Integer sceneSproappId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == sceneSproappId) {
            return;
        }
        this.updateStateSceneSproappModel(sceneSproappId, dataState, oldDataState, map);
    }

    @Override
    public void updateSceneSproappStateByCode(String tenantCode, String sceneSproappCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)sceneSproappCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSceneSproappModelByCode(tenantCode, sceneSproappCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSceneSproapp(TmSceneSproappDomain tmSceneSproappDomain) throws ApiException {
        String msg = this.checkSceneSproapp(tmSceneSproappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.updateSceneSproapp.checkSceneSproapp", msg);
        }
        TmSceneSproapp oldTmSceneSproapp = this.getSceneSproappModelById(tmSceneSproappDomain.getSceneSproappId());
        if (null == oldTmSceneSproapp) {
            throw new ApiException("tm.TmSceneSproappServiceImpl.updateSceneSproapp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        TmSceneSproapp tmSceneSproapp = this.makeSceneSproapp(tmSceneSproappDomain, oldTmSceneSproapp);
        this.setSceneSproappUpdataDefault(tmSceneSproapp);
        this.updateSceneSproappModel(tmSceneSproapp);
    }

    @Override
    public TmSceneSproapp getSceneSproapp(Integer sceneSproappId) {
        if (null == sceneSproappId) {
            return null;
        }
        return this.getSceneSproappModelById(sceneSproappId);
    }

    @Override
    public void deleteSceneSproapp(Integer sceneSproappId) throws ApiException {
        if (null == sceneSproappId) {
            return;
        }
        this.deleteSceneSproappModel(sceneSproappId);
    }

    @Override
    public QueryResult<TmSceneSproapp> querySceneSproappPage(Map<String, Object> map) {
        List<TmSceneSproapp> tmSceneSproappList = this.querySceneSproappModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSceneSproapp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(tmSceneSproappList);
        return queryResult;
    }

    @Override
    public TmSceneSproapp getSceneSproappByCode(String tenantCode, String sceneSproappCode) throws ApiException {
        if (StringUtils.isBlank((String)sceneSproappCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sceneSproappCode", sceneSproappCode);
        return this.getSceneSproappModelByCode(map);
    }

    @Override
    public void deleteSceneSproappByCode(String tenantCode, String sceneSproappCode) throws ApiException {
        if (StringUtils.isBlank((String)sceneSproappCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sceneSproappCode", sceneSproappCode);
        this.delSceneSproappModelByCode(map);
    }
}

