/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ul.dao.UlLevelListMapper;
import com.yqbsoft.laser.service.ul.dao.UlLevelMapper;
import com.yqbsoft.laser.service.ul.dao.UlLevelRuleMapper;
import com.yqbsoft.laser.service.ul.domain.UlLevelDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelListReDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelRuleDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.ul.model.UlLevel;
import com.yqbsoft.laser.service.ul.model.UlLevelList;
import com.yqbsoft.laser.service.ul.model.UlLevelRule;
import com.yqbsoft.laser.service.ul.service.UlLevelBaseService;
import com.yqbsoft.laser.service.ul.service.UlLevelRuleService;
import com.yqbsoft.laser.service.ul.service.UlLevelService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class UlLevelBaseServiceImpl
extends BaseServiceImpl
implements UlLevelBaseService {
    private static final String SYS_CODE = "ul.UlLevelBaseServiceImpl";
    private UlLevelMapper ulLevelMapper;
    private UlLevelListMapper ulLevelListMapper;
    private UlLevelRuleMapper ulLevelRuleMapper;
    private UlLevelService ulLevelService;
    private UlLevelRuleService ulLevelRuleService;

    public void setUlLevelRuleMapper(UlLevelRuleMapper ulLevelRuleMapper) {
        this.ulLevelRuleMapper = ulLevelRuleMapper;
    }

    public void setUlLevelMapper(UlLevelMapper ulLevelMapper) {
        this.ulLevelMapper = ulLevelMapper;
    }

    public void setUlLevelService(UlLevelService ulLevelService) {
        this.ulLevelService = ulLevelService;
    }

    public void setUlLevelListMapper(UlLevelListMapper ulLevelListMapper) {
        this.ulLevelListMapper = ulLevelListMapper;
    }

    public void setUlLevelRuleService(UlLevelRuleService ulLevelRuleService) {
        this.ulLevelRuleService = ulLevelRuleService;
    }

    private List<UlLevel> queryUlLevelModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelBaseServiceImpl.queryUlLevelModel", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelList> queryUlLevelListModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelBaseServiceImpl.queryUlLevelListModelPage", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelRule> queryUlLevelRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelBaseServiceImpl.queryUlLevelRuleModelPage", (Throwable)e);
            return null;
        }
    }

    @Override
    public String saveUlLevelInitialization(Map<String, Object> map) throws ApiException {
        if (MapUtils.isEmpty(map) || null == map.get("tenantCode")) {
            this.logger.error("ul.UlLevelBaseServiceImpl.saveUlLevelInitialization", (Object)map.toString());
            return "error";
        }
        List<UlLevel> ulLevels = this.queryUlLevelModelPage(map);
        if (ListUtil.isNotEmpty(ulLevels)) {
            return "success";
        }
        HashMap<String, Object> parem = new HashMap<String, Object>();
        parem.put("tenantCode", "00000000");
        ulLevels = this.queryUlLevelModelPage(parem);
        if (ListUtil.isEmpty(ulLevels)) {
            this.logger.error("ul.UlLevelBaseServiceImpl.saveUlLevelInitialization.ulLevels", (Object)map.toString());
            return "error";
        }
        String code = "";
        ArrayList<UlLevelListReDomain> ulLevelListReDomains = new ArrayList<UlLevelListReDomain>();
        for (UlLevel ulLevel : ulLevels) {
            UlLevelDomain ulLevelDomain = this.makeLevelDomain(ulLevel, map);
            HashMap<String, Object> mapJson = new HashMap<String, Object>();
            mapJson.put("tenantCode", ulLevel.getTenantCode());
            mapJson.put("levelCode", ulLevel.getLevelCode());
            List<UlLevelList> ulLevelLists = this.queryUlLevelListModelPage(mapJson);
            if (ListUtil.isEmpty(ulLevelLists)) continue;
            for (UlLevelList ulLevelList : ulLevelLists) {
                ulLevelListReDomains.add(this.makeUlLevelListReDomain(ulLevelList));
            }
            ulLevelDomain.setUlLevelListReDomainList(ulLevelListReDomains);
            code = this.ulLevelService.saveUlLevel(ulLevelDomain);
            if (StringUtils.isNotBlank((String)code)) {
                List<UlLevelList> ulLevelListList = this.queryUlLevelListModelPage(this.getQueryParamMap("tenantCode,levelCode", new Object[]{map.get("tenantCode"), code}));
                if (ListUtil.isEmpty(ulLevelListList)) continue;
                this.logger.error("ul.UlLevelBaseServiceImpl.saveUlLevelInitialization.ulLevelListList", (Object)JsonUtil.buildNormalBinder().toJson(ulLevelListList));
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("ulLevelListList", JsonUtil.buildNonNullBinder().toJson(ulLevelListList));
                String s = this.internalInvoke("ur.userrule.saveUrByDefault", paramMap);
                this.logger.error("ul.UlLevelBaseServiceImpl.saveUlLevelInitialization.s", (Object)s);
                if (StringUtils.isBlank((String)s) || !"success".equals(s)) {
                    throw new ApiException("ul.UlLevelBaseServiceImpl.savePackageList.e", "\u64cd\u4f5c\u5931\u8d25");
                }
            }
            HashMap<String, Object> ulLevelRulejson = new HashMap<String, Object>();
            ulLevelRulejson.put("tenantCode", ulLevel.getTenantCode());
            ulLevelRulejson.put("levelCode", ulLevel.getLevelCode());
            List<UlLevelRule> ulLevelRules = this.queryUlLevelRuleModelPage(ulLevelRulejson);
            if (ListUtil.isEmpty(ulLevelRules)) continue;
            for (UlLevelRule levelRule : ulLevelRules) {
                UlLevelRuleDomain ulLevelRuleDomain = this.makeUlLevelRuleReDomain(levelRule);
                ulLevelRuleDomain.setLevelCode(code);
                this.ulLevelRuleService.saveUlLevelRule(ulLevelRuleDomain);
            }
        }
        this.logger.error("ul.UlLevelBaseServiceImpl.saveUlLevelInitialization.ulLevels", (Object)map.toString());
        return "success";
    }

    private UlLevelDomain makeLevelDomain(UlLevel ulLevel, Map<String, Object> map) {
        if (null == ulLevel || MapUtils.isEmpty(map) || null == map.get("tenantCode")) {
            return null;
        }
        UlLevelDomain ulLevelDomain = new UlLevelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelDomain, (Object)ulLevel);
            ulLevelDomain.setLevelId(null);
            ulLevelDomain.setLevelCode(null);
            if (null != map.get("tenantCode")) {
                ulLevelDomain.setTenantCode(map.get("tenantCode").toString());
            }
            if (null != map.get("goodsClass")) {
                ulLevelDomain.setGoodsClass(map.get("goodsClass").toString());
            }
            if (null != map.get("memberMcode") && null != map.get("memberMname")) {
                ulLevelDomain.setMemberMcode(map.get("memberMcode").toString());
                ulLevelDomain.setMemberMname(map.get("memberMname").toString());
            }
            if (null != map.get("channelCode") && null != map.get("channelName")) {
                ulLevelDomain.setChannelCode(map.get("channelCode").toString());
                ulLevelDomain.setChannelName(map.get("channelName").toString());
            }
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelBaseServiceImpl.savePackageList.e", (Throwable)e);
        }
        return ulLevelDomain;
    }

    private UlLevelListReDomain makeUlLevelListReDomain(UlLevelList ulLevelList) {
        if (null == ulLevelList) {
            return null;
        }
        UlLevelListReDomain ulLevelListReDomain = new UlLevelListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelListReDomain, (Object)ulLevelList);
            ulLevelListReDomain.setLevelListId(null);
            ulLevelListReDomain.setLevelListCode(null);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelBaseServiceImpl.savePackageList.e", (Throwable)e);
        }
        return ulLevelListReDomain;
    }

    private UlLevelRuleDomain makeUlLevelRuleReDomain(UlLevelRule levelRule) {
        if (null == levelRule) {
            return null;
        }
        UlLevelRuleDomain ulLevelRuleDomain = new UlLevelRuleDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelRuleDomain, (Object)levelRule);
            ulLevelRuleDomain.setLevelRuleId(null);
            ulLevelRuleDomain.setLevelRuleCode(null);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelBaseServiceImpl.savePackageList.e", (Throwable)e);
        }
        return ulLevelRuleDomain;
    }

    public List<UlLevelListReDomain> queryUlLevelModelPage(UlLevel ulLevel) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ulLevel.getTenantCode());
        map.put("levelCode", ulLevel.getLevelCode());
        List<UlLevelList> ulLevelLists = this.queryUlLevelListModelPage(map);
        if (ListUtil.isEmpty(ulLevelLists)) {
            return null;
        }
        ArrayList<UlLevelListReDomain> ulLevelListReDomains = new ArrayList<UlLevelListReDomain>();
        for (UlLevelList ulLevelList : ulLevelLists) {
            ulLevelListReDomains.add(this.makeUlLevelListReDomain(ulLevelList));
        }
        return ulLevelListReDomains;
    }

    public List<UlLevelListReDomain> queryUlLevelRuleModelPage(UlLevel ulLevel, String code) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ulLevel.getTenantCode());
        map.put("levelCode", ulLevel.getLevelCode());
        List<UlLevelRule> ulLevelRules = this.queryUlLevelRuleModelPage(map);
        if (ListUtil.isEmpty(ulLevelRules)) {
            return null;
        }
        ArrayList<UlLevelListReDomain> ulLevelListReDomains = new ArrayList<UlLevelListReDomain>();
        for (UlLevelRule levelRule : ulLevelRules) {
            UlLevelRuleDomain ulLevelRuleDomain = this.makeUlLevelRuleReDomain(levelRule);
            ulLevelRuleDomain.setLevelCode(code);
            this.ulLevelRuleService.saveUlLevelRule(ulLevelRuleDomain);
        }
        return ulLevelListReDomains;
    }

    @Override
    public String saveInitializationByUser(UmUserinfoDomain umUserinfo, UmUserDomain umUser, String optype) throws ApiException {
        if (null == umUserinfo) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberMcode", umUserinfo.getUserinfoCode());
        map.put("memberMname", umUserinfo.getCompanyCode());
        map.put("tenantCode", umUserinfo.getTenantCode());
        String goodsClass = this.getUrl(umUserinfo.getTenantCode(), "ul_goodsClass", "ul_goodsClass");
        if (StringUtils.isNotBlank((String)goodsClass)) {
            map.put("goodsClass", goodsClass);
        }
        String channelCode = this.getUrl(umUserinfo.getTenantCode(), "ul_channelCode", "ul_channelCode");
        String channelName = this.getUrl(umUserinfo.getTenantCode(), "ul_channelName", "ul_channelName");
        if (StringUtils.isNotBlank((String)channelCode) && StringUtils.isNotBlank((String)channelName)) {
            map.put("channelCode", channelCode);
            map.put("channelName", channelName);
        }
        return this.saveUlLevelInitialization(map);
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isBlank((String)value)) {
            field = "00000000".concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
            value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        }
        this.logger.error("ul.UlLevelBaseServiceImpl.getUrl", (Object)value);
        return value;
    }
}

