/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ul.dao.UlLevelUllistMapper;
import com.yqbsoft.laser.service.ul.dao.UlLevelUpointsMapper;
import com.yqbsoft.laser.service.ul.domain.UlLevelUllistDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelUllistReDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelUpointsDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelUpointsReDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserinfoQua;
import com.yqbsoft.laser.service.ul.model.UlLevel;
import com.yqbsoft.laser.service.ul.model.UlLevelList;
import com.yqbsoft.laser.service.ul.model.UlLevelListconf;
import com.yqbsoft.laser.service.ul.model.UlLevelUllist;
import com.yqbsoft.laser.service.ul.model.UlLevelUpoints;
import com.yqbsoft.laser.service.ul.service.UlLevelListconfService;
import com.yqbsoft.laser.service.ul.service.UlLevelService;
import com.yqbsoft.laser.service.ul.service.UlLevelUllistService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UlLevelUllistServiceImpl
extends BaseServiceImpl
implements UlLevelUllistService {
    private static final String SYS_CODE = "ul.UlLevelUllistServiceImpl";
    private UlLevelUllistMapper ulLevelUllistMapper;
    private UlLevelUpointsMapper ulLevelUpointsMapper;
    private UlLevelService ulLevelService;
    private UlLevelListconfService ulLevelListconfService;

    public void setUlLevelUllistMapper(UlLevelUllistMapper ulLevelUllistMapper) {
        this.ulLevelUllistMapper = ulLevelUllistMapper;
    }

    public void setUlLevelUpointsMapper(UlLevelUpointsMapper ulLevelUpointsMapper) {
        this.ulLevelUpointsMapper = ulLevelUpointsMapper;
    }

    public UlLevelService getUlLevelService() {
        return this.ulLevelService;
    }

    public void setUlLevelService(UlLevelService ulLevelService) {
        this.ulLevelService = ulLevelService;
    }

    public void setUlLevelListconfService(UlLevelListconfService ulLevelListconfService) {
        this.ulLevelListconfService = ulLevelListconfService;
    }

    private Date getSysDate() {
        try {
            return this.ulLevelUllistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain) {
        if (null == ulLevelUllistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelUllistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelUllistDefault(UlLevelUllist ulLevelUllist) {
        if (null == ulLevelUllist) {
            return;
        }
        if (null == ulLevelUllist.getDataState()) {
            ulLevelUllist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulLevelUllist.getGmtCreate()) {
            ulLevelUllist.setGmtCreate(date);
        }
        ulLevelUllist.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevelUllist.getLevelListCode())) {
            ulLevelUllist.setLevelListCode(this.getNo(null, "UlLevelUllist", "ulLevelUllist", ulLevelUllist.getTenantCode()));
        }
    }

    private int getUlLevelUllistMaxCode() {
        int code = 0;
        try {
            return this.ulLevelUllistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUllistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelUllistUpdataDefault(UlLevelUllist ulLevelUllist) {
        if (null == ulLevelUllist) {
            return;
        }
        ulLevelUllist.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelUllistModel(UlLevelUllist ulLevelUllist) throws ApiException {
        if (null == ulLevelUllist) {
            return;
        }
        try {
            this.ulLevelUllistMapper.insert(ulLevelUllist);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUllistModel.ex", (Throwable)e);
        }
    }

    private void saveUlLevelUllistBatchModel(List<UlLevelUllist> ulLevelUllistList) throws ApiException {
        if (null == ulLevelUllistList || ulLevelUllistList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelUllistMapper.insertBatch(ulLevelUllistList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUllistBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevelUllist getUlLevelUllistModelById(Integer levelListId) {
        if (null == levelListId) {
            return null;
        }
        try {
            return this.ulLevelUllistMapper.selectByPrimaryKey(levelListId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUllistModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevelUllist getUlLevelUllistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelUllistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUllistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelUllistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.delUlLevelUllistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.delUlLevelUllistModelByCode.num");
        }
    }

    private void deleteUlLevelUllistModel(Integer levelListId) throws ApiException {
        if (null == levelListId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.deleteByPrimaryKey(levelListId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.deleteUlLevelUllistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.deleteUlLevelUllistModel.num");
        }
    }

    private void updateUlLevelUllistModel(UlLevelUllist ulLevelUllist) throws ApiException {
        if (null == ulLevelUllist) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.updateByPrimaryKey(ulLevelUllist);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUllistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUllistModel.num");
        }
    }

    private void updateStateUlLevelUllistModel(Integer levelListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == levelListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelListId", levelListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUllistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUllistModel.null");
        }
    }

    private void updateStateUlLevelUllistModelByCode(String tenantCode, String levelListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListCode", levelListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUllistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUllistModelByCode.null");
        }
    }

    private UlLevelUllist makeUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain, UlLevelUllist ulLevelUllist) {
        if (null == ulLevelUllistDomain) {
            return null;
        }
        if (null == ulLevelUllist) {
            ulLevelUllist = new UlLevelUllist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUllist, (Object)ulLevelUllistDomain);
            return ulLevelUllist;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUlLevelUllist", (Throwable)e);
            return null;
        }
    }

    private UlLevelUllistReDomain makeUlLevelUllistReDomain(UlLevelUllist ulLevelUllist) {
        if (null == ulLevelUllist) {
            return null;
        }
        UlLevelUllistReDomain ulLevelUllistReDomain = new UlLevelUllistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUllistReDomain, (Object)ulLevelUllist);
            return ulLevelUllistReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUlLevelUllistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelUllist> queryUlLevelUllistModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelUllistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.queryUlLevelUllistModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevelUllist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.countUlLevelUllist", (Throwable)e);
        }
        return i;
    }

    private UlLevelUllist createUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain) {
        String msg = this.checkUlLevelUllist(ulLevelUllistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUllist.checkUlLevelUllist", msg);
        }
        UlLevelUllist ulLevelUllist = this.makeUlLevelUllist(ulLevelUllistDomain, null);
        this.setUlLevelUllistDefault(ulLevelUllist);
        return ulLevelUllist;
    }

    private String checkUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain) {
        if (null == ulLevelUpointsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelUpointsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelUpointsDefault(UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUpoints) {
            return;
        }
        if (null == ulLevelUpoints.getDataState()) {
            ulLevelUpoints.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulLevelUpoints.getGmtCreate()) {
            ulLevelUpoints.setGmtCreate(date);
        }
        ulLevelUpoints.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevelUpoints.getLevelUpointsCode())) {
            ulLevelUpoints.setLevelUpointsCode(this.getNo(null, "UlLevelUpoints", "ulLevelUpoints", ulLevelUpoints.getTenantCode()));
        }
    }

    private int getUlLevelUpointsMaxCode() {
        int code = 0;
        try {
            return this.ulLevelUpointsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUpointsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelUpointsUpdataDefault(UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUpoints) {
            return;
        }
        ulLevelUpoints.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelUpointsModel(UlLevelUpoints ulLevelUpoints) throws ApiException {
        if (null == ulLevelUpoints) {
            return;
        }
        try {
            this.ulLevelUpointsMapper.insert(ulLevelUpoints);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsModel.ex", (Throwable)e);
        }
    }

    private void saveUlLevelUpointsBatchModel(List<UlLevelUpoints> ulLevelUpointsList) throws ApiException {
        if (null == ulLevelUpointsList || ulLevelUpointsList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelUpointsMapper.insertBatch(ulLevelUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevelUpoints getUlLevelUpointsModelById(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        try {
            return this.ulLevelUpointsMapper.selectByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUpointsModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevelUpoints getUlLevelUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelUpointsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUpointsModelByCode", (Throwable)e);
            return null;
        }
    }

    private UlLevelUpoints getUlLevelUpointsModelByMember(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelUpointsMapper.getByMember(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUpointsModelByMember", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.delUlLevelUpointsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.delUlLevelUpointsModelByCode.num");
        }
    }

    private void deleteUlLevelUpointsModel(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.deleteByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.deleteUlLevelUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.deleteUlLevelUpointsModel.num");
        }
    }

    private void updateUlLevelUpointsModel(UlLevelUpoints ulLevelUpoints) throws ApiException {
        if (null == ulLevelUpoints) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.updateByPrimaryKey(ulLevelUpoints);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUpointsModel.num");
        }
    }

    private void updateStateUlLevelUpointsModel(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upointsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelUpointsId", upointsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUpointsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUpointsModel.null");
        }
    }

    private void updateStateUlLevelUpointsModelByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUpointsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUpointsModelByCode.null");
        }
    }

    private UlLevelUpoints makeUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain, UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUpointsDomain) {
            return null;
        }
        if (null == ulLevelUpoints) {
            ulLevelUpoints = new UlLevelUpoints();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUpoints, (Object)ulLevelUpointsDomain);
            return ulLevelUpoints;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUlLevelUpoints", (Throwable)e);
            return null;
        }
    }

    private UlLevelUpointsDomain makeUlLevelUpointsDomain(UlLevelUpointsDomain ulLevelUpointsDomain, UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUpoints) {
            return null;
        }
        if (null == ulLevelUpointsDomain) {
            ulLevelUpointsDomain = new UlLevelUpointsDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUpointsDomain, (Object)ulLevelUpoints);
            return ulLevelUpointsDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUlLevelUpointsDomain", (Throwable)e);
            return null;
        }
    }

    private UlLevelUpointsReDomain makeUlLevelUpointsReDomain(UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUpoints) {
            return null;
        }
        UlLevelUpointsReDomain ulLevelUpointsReDomain = new UlLevelUpointsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUpointsReDomain, (Object)ulLevelUpoints);
            return ulLevelUpointsReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUlLevelUpointsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelUpoints> queryUlLevelUpointsModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelUpointsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.queryUlLevelUpointsModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevelUpoints(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.countUlLevelUpoints", (Throwable)e);
        }
        return i;
    }

    private UlLevelUpoints createUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain) {
        String msg = this.checkUlLevelUpoints(ulLevelUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpoints.checkUlLevelUpoints", msg);
        }
        UlLevelUpoints ulLevelUpoints = this.makeUlLevelUpoints(ulLevelUpointsDomain, null);
        this.setUlLevelUpointsDefault(ulLevelUpoints);
        return ulLevelUpoints;
    }

    @Override
    public String saveUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain) throws ApiException {
        UlLevelUllist ulLevelUllist = this.createUlLevelUllist(ulLevelUllistDomain);
        this.saveUlLevelUllistModel(ulLevelUllist);
        return ulLevelUllist.getLevelListCode();
    }

    public UlLevelUllist saveUllist(UlLevelUllistDomain ulLevelUllistDomain) throws ApiException {
        UlLevelUllist ulLevelUllist = this.createUlLevelUllist(ulLevelUllistDomain);
        this.saveUlLevelUllistModel(ulLevelUllist);
        return ulLevelUllist;
    }

    @Override
    public synchronized UlLevelUllist saveUlLevelUpointsByUllist(UlLevelUllistDomain ulLevelUllistDomain) throws ApiException {
        String msg = this.checkUlLevelUllist(ulLevelUllistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsByUllist.checkUlLevelUllist", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelType", ulLevelUllistDomain.getLevelType());
        map.put("memberCode", ulLevelUllistDomain.getMemberCode());
        map.put("tenantCode", ulLevelUllistDomain.getTenantCode());
        map.put("levelUserqua", ulLevelUllistDomain.getLevelUserqua());
        UlLevelUpoints ulLevelUpoints = this.getUlLevelUpointsByMember(map);
        UlLevelUpointsDomain ulLevelUpointsDomain = null;
        if (null == ulLevelUpoints || null == ulLevelUpoints.getLevelUpointsId()) {
            if (!"0".equals(ulLevelUllistDomain.getLevelListDirection())) {
                throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsByUllist.upmUpoints");
            }
            ulLevelUpointsDomain = this.makeSaveUlLevelUpoints(ulLevelUllistDomain, ulLevelUpoints);
        } else {
            this.updateStateUlLevelUpointsModel(ulLevelUpoints.getLevelUpointsId(), ulLevelUpoints.getDataState(), ulLevelUpoints.getDataState(), null);
            ulLevelUpoints = this.getUlLevelUpointsByMember(map);
        }
        UlLevelUllistDomain ullistDomain = this.makeUmUlLevelListDomain(ulLevelUpoints, ulLevelUllistDomain);
        if (null == ullistDomain) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsByUllist.ullistDomain");
        }
        if (null != ulLevelUpointsDomain) {
            this.saveUlLevelUpoints(ulLevelUpointsDomain);
        } else {
            ulLevelUpoints.setLevelLnum(ullistDomain.getLevelAflnum());
            ulLevelUpoints.setLevelNum(ullistDomain.getLevelAfnum());
            ulLevelUpoints.setLevelOnum(ullistDomain.getLevelAfonum());
            this.updateUlLevelUpointsModel(ulLevelUpoints);
        }
        UlLevelUllist ulLevelUllist = this.saveUllist(ullistDomain);
        return ulLevelUllist;
    }

    private UlLevelUpointsDomain makeSaveUlLevelUpoints(UlLevelUllistDomain ulLevelUllistDomain, UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUllistDomain) {
            return null;
        }
        UlLevelUpointsDomain ulLevelUpointsDomain = new UlLevelUpointsDomain();
        ulLevelUpointsDomain.setMemberName(ulLevelUllistDomain.getMemberName());
        if ("dis".equals(ulLevelUllistDomain.getLevelUserqua())) {
            return this.makeUlLevelUpointsDomain(ulLevelUpointsDomain, ulLevelUpoints);
        }
        ulLevelUpointsDomain.setLevelLnum(BigDecimal.ZERO);
        ulLevelUpointsDomain.setLevelNum(ulLevelUllistDomain.getLevelListNum());
        ulLevelUpointsDomain.setLevelOnum(BigDecimal.ZERO);
        ulLevelUpointsDomain.setMemberCode(ulLevelUllistDomain.getMemberCode());
        ulLevelUpointsDomain.setTenantCode(ulLevelUllistDomain.getTenantCode());
        ulLevelUpointsDomain.setLevelType(ulLevelUllistDomain.getLevelType());
        ulLevelUpointsDomain.setLevelUserqua(ulLevelUllistDomain.getLevelUserqua());
        ulLevelUpointsDomain.setLevelDatatype("levelListCode");
        HashMap<String, Object> ulMap = new HashMap<String, Object>();
        ulMap.put("tenantCode", ulLevelUllistDomain.getTenantCode());
        QueryResult<UlLevel> ulLevelQueryResult = this.ulLevelService.queryUlLevelPage(ulMap);
        if (null == ulLevelQueryResult || ListUtil.isEmpty((Collection)ulLevelQueryResult.getList())) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.makeSaveUlLevelUpoints.ulLevelQueryResult", "ulLevelQueryResult is null" + ulMap);
        }
        ulLevelUpointsDomain.setLevelUpointsState(new Date());
        if (null != ((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk() || !"".equals(((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk()) || ((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk() > 0) {
            ulLevelUpointsDomain.setLevelUpointsState(new Date());
            ulLevelUpointsDomain.setLevelUpointsState(DateUtils.addDays((Date)ulLevelUpointsDomain.getLevelUpointsState(), (int)((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk()));
        }
        this.logger.error("ulLevelUpointsDomain--2", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ulLevelUpointsDomain));
        return ulLevelUpointsDomain;
    }

    private UlLevelUllistDomain makeDisUlLevelUllist(UlLevelUpoints ulLevelUpointsByMember, UlLevelUllistDomain ulLevelUllistDomain) {
        List<UlLevelList> ulLevelLists = this.ulLevelService.queryLevelListByLevelNum(this.getQueryMapParam("levelType,levelUserqua,levelDatatype,tenantCode,levelDatavalue", new Object[]{"0", "dis", "levelListParentCode", ulLevelUpointsByMember.getTenantCode(), ulLevelUpointsByMember.getLevelDatavalue()}));
        if (ListUtil.isEmpty(ulLevelLists)) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeDisLevelClear.ulLevelLists", (Object)(ulLevelUpointsByMember.getTenantCode() + "-" + ulLevelUpointsByMember.getLevelDatavalue()));
            return null;
        }
        String key = ulLevelUllistDomain.getLevelRuleApi() + "-" + ulLevelUllistDomain.getTenantCode() + "-" + ulLevelUllistDomain.getLevelUserqua() + "-" + ulLevelLists.get(0).getLevelListCode();
        UlLevelListconf ulLevelListconf = (UlLevelListconf)DisUtil.getMapJson((String)"UlLevelListConft-type", (String)key, UlLevelListconf.class);
        if (null == ulLevelListconf) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeDisLevelUllisByClear.ulLevelListconf", (Object)key);
            return null;
        }
        List<UlLevelUllist> ulLevelUllists = this.queryUlLevelUllistModelPage(this.getQueryParamMap("memberCode,levelUserqua,tenantCode,levelRuleApi,levelType,order", new Object[]{ulLevelUllistDomain.getMemberCode(), ulLevelUllistDomain.getLevelUserqua(), ulLevelUllistDomain.getTenantCode(), ulLevelUllistDomain.getLevelRuleApi(), ulLevelUllistDomain.getLevelType(), true}));
        if (ListUtil.isNotEmpty(ulLevelUllists)) {
            ulLevelUllistDomain.setLevelBfnum(ulLevelUllists.get(0).getLevelAfnum());
        }
        return ulLevelUllistDomain;
    }

    private UlLevelUllistDomain makeUmUlLevelListDomain(UlLevelUpoints ulLevelUpoints, UlLevelUllistDomain ulLevelUllistDomain) {
        if (null == ulLevelUllistDomain) {
            return null;
        }
        UlLevelUllistDomain levelUllistDomain = new UlLevelUllistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)levelUllistDomain, (Object)ulLevelUllistDomain);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUmUlLevelListDomain.e", (Throwable)e);
            return null;
        }
        levelUllistDomain.setLevelAflnum(BigDecimal.ZERO);
        levelUllistDomain.setLevelAfnum(BigDecimal.ZERO);
        levelUllistDomain.setLevelAfonum(BigDecimal.ZERO);
        levelUllistDomain.setLevelBflnum(BigDecimal.ZERO);
        levelUllistDomain.setLevelBfnum(BigDecimal.ZERO);
        levelUllistDomain.setLevelBfonum(BigDecimal.ZERO);
        if (null != ulLevelUpoints) {
            if ("dis".equals(ulLevelUllistDomain.getLevelUserqua())) {
                this.makeDisUlLevelUllist(ulLevelUpoints, levelUllistDomain);
            } else {
                levelUllistDomain.setLevelAflnum(ulLevelUpoints.getLevelLnum());
                levelUllistDomain.setLevelAfnum(ulLevelUpoints.getLevelNum());
                levelUllistDomain.setLevelAfonum(ulLevelUpoints.getLevelOnum());
                levelUllistDomain.setLevelBflnum(ulLevelUpoints.getLevelLnum());
                levelUllistDomain.setLevelBfnum(ulLevelUpoints.getLevelNum());
                levelUllistDomain.setLevelBfonum(ulLevelUpoints.getLevelOnum());
            }
        }
        if ("0".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().add(levelUllistDomain.getLevelListNum()));
        } else if ("1".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().subtract(levelUllistDomain.getLevelListNum()));
        } else if ("2".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().subtract(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAfonum(levelUllistDomain.getLevelBfonum().add(levelUllistDomain.getLevelListNum()));
        } else if ("3".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().subtract(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAflnum(levelUllistDomain.getLevelBflnum().add(levelUllistDomain.getLevelListNum()));
        } else if ("4".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().add(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAflnum(levelUllistDomain.getLevelBflnum().subtract(levelUllistDomain.getLevelListNum()));
        } else if ("5".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfonum(levelUllistDomain.getLevelBfonum().add(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAflnum(levelUllistDomain.getLevelBflnum().subtract(levelUllistDomain.getLevelListNum()));
        } else if ("6".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfonum(levelUllistDomain.getLevelBfonum().subtract(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().add(levelUllistDomain.getLevelListNum()));
        } else if ("7".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().add(levelUllistDomain.getLevelListNum()));
        }
        if (levelUllistDomain.getLevelAfnum().compareTo(BigDecimal.ZERO) == -1 || levelUllistDomain.getLevelAflnum().compareTo(BigDecimal.ZERO) == -1 || levelUllistDomain.getLevelAfonum().compareTo(BigDecimal.ZERO) == -1) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.makeUmUpointsListDomain.num");
        }
        return levelUllistDomain;
    }

    @Override
    public String saveUlLevelUllistBatch(List<UlLevelUllistDomain> ulLevelUllistDomainList) throws ApiException {
        if (null == ulLevelUllistDomainList || ulLevelUllistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevelUllist> ulLevelUllistList = new ArrayList<UlLevelUllist>();
        String code = "";
        for (UlLevelUllistDomain ulLevelUllistDomain : ulLevelUllistDomainList) {
            UlLevelUllist ulLevelUllist = this.createUlLevelUllist(ulLevelUllistDomain);
            code = ulLevelUllist.getLevelListCode();
            ulLevelUllistList.add(ulLevelUllist);
        }
        this.saveUlLevelUllistBatchModel(ulLevelUllistList);
        return code;
    }

    @Override
    public void updateUlLevelUllistState(Integer levelListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == levelListId) {
            return;
        }
        this.updateStateUlLevelUllistModel(levelListId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelUllistStateByCode(String tenantCode, String levelListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlLevelUllistModelByCode(tenantCode, levelListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain) throws ApiException {
        String msg = this.checkUlLevelUllist(ulLevelUllistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUllist.checkUlLevelUllist", msg);
        }
        UlLevelUllist oldUlLevelUllist = this.getUlLevelUllistModelById(ulLevelUllistDomain.getLevelListId());
        if (null == oldUlLevelUllist) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUllist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlLevelUllist ulLevelUllist = this.makeUlLevelUllist(ulLevelUllistDomain, oldUlLevelUllist);
        this.setUlLevelUllistUpdataDefault(ulLevelUllist);
        this.updateUlLevelUllistModel(ulLevelUllist);
    }

    @Override
    public UlLevelUllist getUlLevelUllist(Integer levelListId) {
        if (null == levelListId) {
            return null;
        }
        return this.getUlLevelUllistModelById(levelListId);
    }

    @Override
    public void deleteUlLevelUllist(Integer levelListId) throws ApiException {
        if (null == levelListId) {
            return;
        }
        this.deleteUlLevelUllistModel(levelListId);
    }

    @Override
    public QueryResult<UlLevelUllist> queryUlLevelUllistPage(Map<String, Object> map) {
        List<UlLevelUllist> ulLevelUllistList = this.queryUlLevelUllistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlLevelUllist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulLevelUllistList);
        return queryResult;
    }

    @Override
    public UlLevelUllist getUlLevelUllistByCode(String tenantCode, String levelListCode) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListCode", levelListCode);
        return this.getUlLevelUllistModelByCode(map);
    }

    @Override
    public void deleteUlLevelUllistByCode(String tenantCode, String levelListCode) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListCode", levelListCode);
        this.delUlLevelUllistModelByCode(map);
    }

    @Override
    public String saveUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain) throws ApiException {
        if (null != ulLevelUpointsDomain.getLevelUpointsCode()) {
            this.updateUlLevelUpoints(ulLevelUpointsDomain);
            return ulLevelUpointsDomain.getLevelUpointsCode();
        }
        UlLevelUpoints ulLevelUpoints = this.createUlLevelUpoints(ulLevelUpointsDomain);
        this.saveUlLevelUpointsModel(ulLevelUpoints);
        return ulLevelUpoints.getLevelUpointsCode();
    }

    @Override
    public String saveUlLevelUpointsBatch(List<UlLevelUpointsDomain> ulLevelUpointsDomainList) throws ApiException {
        if (null == ulLevelUpointsDomainList || ulLevelUpointsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevelUpoints> ulLevelUpointsList = new ArrayList<UlLevelUpoints>();
        String code = "";
        for (UlLevelUpointsDomain ulLevelUpointsDomain : ulLevelUpointsDomainList) {
            UlLevelUpoints ulLevelUpoints = this.createUlLevelUpoints(ulLevelUpointsDomain);
            code = ulLevelUpoints.getLevelUpointsCode();
            ulLevelUpointsList.add(ulLevelUpoints);
        }
        this.saveUlLevelUpointsBatchModel(ulLevelUpointsList);
        return code;
    }

    @Override
    public void updateUlLevelUpointsState(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.updateStateUlLevelUpointsModel(upointsId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelUpointsStateByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlLevelUpointsModelByCode(tenantCode, upointsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain) throws ApiException {
        String msg = this.checkUlLevelUpoints(ulLevelUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUpoints.checkUlLevelUpoints", msg);
        }
        UlLevelUpoints oldUlLevelUpoints = this.getUlLevelUpointsByCode(ulLevelUpointsDomain.getTenantCode(), ulLevelUpointsDomain.getLevelUpointsCode());
        if (null == oldUlLevelUpoints) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUpoints.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlLevelUpoints ulLevelUpoints = this.makeUlLevelUpoints(ulLevelUpointsDomain, oldUlLevelUpoints);
        this.setUlLevelUpointsUpdataDefault(ulLevelUpoints);
        this.updateUlLevelUpointsModel(ulLevelUpoints);
    }

    @Override
    public UlLevelUpoints getUlLevelUpoints(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        return this.getUlLevelUpointsModelById(upointsId);
    }

    @Override
    public void deleteUlLevelUpoints(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.deleteUlLevelUpointsModel(upointsId);
    }

    @Override
    public QueryResult<UlLevelUpoints> queryUlLevelUpointsPage(Map<String, Object> map) {
        List<UlLevelUpoints> ulLevelUpointsList = this.queryUlLevelUpointsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlLevelUpoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulLevelUpointsList);
        return queryResult;
    }

    @Override
    public UlLevelUpoints getUlLevelUpointsByCode(String tenantCode, String levelUpointsCode) throws ApiException {
        if (StringUtils.isBlank((String)levelUpointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelUpointsCode", levelUpointsCode);
        return this.getUlLevelUpointsModelByCode(map);
    }

    @Override
    public UlLevelUpoints getUlLevelUpointsByMember(Map<String, Object> map) throws ApiException {
        List<UlLevelUpoints> ulLevelUpointsList = this.queryUlLevelUpointsModelPage(map);
        UlLevelUpoints ulLevelUpoints = null;
        if (ListUtil.isNotEmpty(ulLevelUpointsList)) {
            ulLevelUpoints = ulLevelUpointsList.get(0);
        }
        return ulLevelUpoints;
    }

    @Override
    public UlLevelUpoints getUlLevelUpointsByMemberToStr(Map<String, Object> map) throws ApiException {
        List<UlLevelUpoints> ulLevelUpointsList = this.queryUlLevelUpointsModelPage(map);
        UlLevelUpoints ulLevelUpoints = null;
        if (ListUtil.isNotEmpty(ulLevelUpointsList)) {
            ulLevelUpoints = ulLevelUpointsList.get(0);
        } else {
            ulLevelUpoints = new UlLevelUpoints();
            ulLevelUpoints.setLevelUpointsCode("-1");
            ulLevelUpoints.setLevelLnum(new BigDecimal(0));
            ulLevelUpoints.setLevelLnum(new BigDecimal(0));
            ulLevelUpoints.setLevelOnum(new BigDecimal(0));
            ulLevelUpoints.setLevelListName("Default");
            ulLevelUpoints.setLevelListLevel(0);
        }
        return ulLevelUpoints;
    }

    private UlLevelUpoints defaultDisUlLevelUpoints(Map<String, Object> map) {
        if (MapUtil.isEmpty(map) || null == map.get("levelUserqua") || null == map.get("memberCode")) {
            this.logger.error("ul.UlLevelUllistServiceImpl.defaultDisUlLevelUpointsmap", (Object)map.toString());
            return null;
        }
        String tenantCode = map.get("tenantCode").toString();
        UlLevelUpoints ulLevelUpoints = new UlLevelUpoints();
        ulLevelUpoints.setLevelLnum(BigDecimal.ZERO);
        ulLevelUpoints.setLevelNum(BigDecimal.ZERO);
        ulLevelUpoints.setLevelOnum(BigDecimal.ZERO);
        ulLevelUpoints.setMemberCode((String)map.get("memberCode"));
        ulLevelUpoints.setMemberMcode((String)map.get("memberMcode"));
        ulLevelUpoints.setMemberMname((String)map.get("memberMname"));
        ulLevelUpoints.setTenantCode(tenantCode);
        ulLevelUpoints.setLevelType(null == map.get("levelType") ? "0" : map.get("levelType").toString());
        ulLevelUpoints.setLevelUserqua((String)map.get("levelUserqua"));
        HashMap<String, Object> ulLevelmap = new HashMap<String, Object>();
        ulLevelmap.put("levelType", "0");
        ulLevelmap.put("tenantCode", tenantCode);
        ulLevelmap.put("levelUserqua", (String)map.get("levelUserqua"));
        ulLevelmap.put("levelDatatype", "levelListParentCode");
        ulLevelmap.put("levelDatavalue", "0");
        List<UlLevelList> ulLevelLists = this.ulLevelService.queryLevelListByLevelNum(ulLevelmap);
        if (null == ulLevelLists || ListUtil.isEmpty(ulLevelLists)) {
            this.logger.error("ul.UlLevelUllistServiceImpl.defaultDisUlLevelUpoints!!!!", (Object)((Object)ulLevelmap).toString());
            return null;
        }
        UlLevelList ulLevelList = ulLevelLists.get(0);
        ulLevelUpoints.setLevelDatatype("levelListCode");
        ulLevelUpoints.setLevelDatavalue(ulLevelList.getLevelListCode());
        ulLevelUpoints.setLevelListName(ulLevelList.getLevelListName());
        ulLevelUpoints.setLevelListLevel(ulLevelList.getLevelListLevel());
        this.logger.error("ulLevelUpoints----8");
        this.makeUpdateDate(ulLevelUpoints);
        return ulLevelUpoints;
    }

    private void makeUpdateDate(UlLevelUpoints ulLevelUpoints) {
        HashMap<String, Object> ulMap = new HashMap<String, Object>();
        ulMap.put("tenantCode", ulLevelUpoints.getTenantCode());
        QueryResult<UlLevel> ulLevelQueryResult = this.ulLevelService.queryUlLevelPage(ulMap);
        if (null == ulLevelQueryResult || ListUtil.isEmpty((Collection)ulLevelQueryResult.getList())) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.makeSaveUlLevelUpoints.ulLevelQueryResult", "ulLevelQueryResult is null" + ulMap);
        }
        ulLevelUpoints.setLevelUpointsState(new Date());
        if (null != ((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk() || !"".equals(((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk()) || ((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk() > 0) {
            ulLevelUpoints.setLevelUpointsState(new Date());
            ulLevelUpoints.setLevelUpointsState(DateUtils.addDays((Date)ulLevelUpoints.getLevelUpointsState(), (int)((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk()));
        }
    }

    @Override
    public void deleteUlLevelUpointsByCode(String tenantCode, String upointsCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        this.delUlLevelUpointsModelByCode(map);
    }

    @Override
    public String saveLevelGrant(UlLevelUllist ulLevelUllist) throws ApiException {
        UlLevelUpoints levelUpoints;
        if (null == ulLevelUllist) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelType", ulLevelUllist.getLevelType());
        map.put("memberCode", ulLevelUllist.getMemberCode());
        map.put("tenantCode", ulLevelUllist.getTenantCode());
        map.put("levelUserqua", ulLevelUllist.getLevelUserqua());
        if (StringUtils.isNotBlank((String)ulLevelUllist.getMemberMcode()) && !ulLevelUllist.getMemberMcode().equals("all")) {
            map.put("memberMcode", ulLevelUllist.getMemberMcode());
        }
        if (null == (levelUpoints = this.getUlLevelUpointsByMember(map))) {
            this.logger.error("ul.UlLevelUllistServiceImpl.saveLevelGrantStr", (Object)((Object)map).toString());
            return "error";
        }
        String oldlevelCode = levelUpoints.getLevelDatavalue();
        this.currentLevel(levelUpoints);
        if (!levelUpoints.getLevelDatavalue().equals(oldlevelCode)) {
            UlLevelUpointsDomain ulLevelUpointsDomain = new UlLevelUpointsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ulLevelUpointsDomain, (Object)levelUpoints);
            }
            catch (Exception e) {
                this.logger.error("ul.UlLevelUllistServiceImpl.ulLevelUpointsDomain.e", (Throwable)e);
                return "error";
            }
            this.saveUlLevelUpoints(ulLevelUpointsDomain);
            if (this.updateUserInfoLevel(levelUpoints)) {
                return "error";
            }
            return "success";
        }
        return "error";
    }

    private UlLevelUpoints currentLevel(UlLevelUpoints levelUpoints) {
        boolean updateLevelUpoints = true;
        UlLevelList ulLevelList = null;
        while (updateLevelUpoints) {
            UlLevelList partUlLevelList;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("levelType", levelUpoints.getLevelType());
            map.put("tenantCode", levelUpoints.getTenantCode());
            map.put("levelUserqua", levelUpoints.getLevelUserqua());
            map.put("levelDatavalue", levelUpoints.getLevelDatavalue());
            map.put("memberMcode", levelUpoints.getMemberMcode());
            List<UlLevelList> ulLevelLists = this.ulLevelService.queryLevelListByLevelNum(map);
            if (null == ulLevelLists || ListUtil.isEmpty(ulLevelLists)) {
                UlLevelList oldLevelList = this.ulLevelService.getUlLevelListByCode(levelUpoints.getTenantCode(), levelUpoints.getLevelDatavalue());
                if (null == oldLevelList) {
                    this.logger.error("ul.UlLevelUllistServiceImpl.levelUpoints", (Object)"\u7b49\u7ea7\u6570\u636e\u9519\u8bef");
                    return levelUpoints;
                }
                if (levelUpoints.getLevelNum().intValue() >= oldLevelList.getLevelListStart()) {
                    this.logger.error("ul.UlLevelUllistServiceImpl.levelUpoints", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)levelUpoints));
                    return levelUpoints;
                }
                ulLevelLists = new ArrayList<UlLevelList>();
                ulLevelLists.add(oldLevelList);
            }
            if ("dis".equals((ulLevelList = ulLevelLists.get(0)).getLevelUserqua())) {
                boolean boo = this.upDisLevelUpoints(ulLevelList, levelUpoints);
                if (!boo) {
                    updateLevelUpoints = false;
                }
            } else if (levelUpoints.getLevelNum().intValue() < ulLevelList.getLevelListStart()) {
                updateLevelUpoints = false;
            }
            if (updateLevelUpoints) {
                this.makeUpdateDate(levelUpoints);
                levelUpoints.setLevelListLevel(ulLevelList.getLevelListLevel());
                levelUpoints.setLevelListName(ulLevelList.getLevelListName());
                levelUpoints.setLevelDatavalue(ulLevelList.getLevelListCode());
                continue;
            }
            UlLevelList oldUlLevelList = this.ulLevelService.getUlLevelListByCode(levelUpoints.getTenantCode(), levelUpoints.getLevelDatavalue());
            if (null == oldUlLevelList || null == (partUlLevelList = this.ulLevelService.getUlLevelListByCode(levelUpoints.getTenantCode(), oldUlLevelList.getLevelDatavalue())) || levelUpoints.getLevelNum().intValue() > partUlLevelList.getLevelListEnd()) continue;
            this.makeUpdateDate(levelUpoints);
            levelUpoints.setLevelListLevel(partUlLevelList.getLevelListLevel());
            levelUpoints.setLevelListName(partUlLevelList.getLevelListName());
            levelUpoints.setLevelDatavalue(partUlLevelList.getLevelListCode());
        }
        return levelUpoints;
    }

    public static void main(String[] args) {
        boolean updateLevelUpoints = true;
        int i = 0;
        while (updateLevelUpoints) {
            if (i == 10) {
                updateLevelUpoints = false;
                return;
            }
            System.out.println(++i);
        }
    }

    private boolean upDisLevelUpoints(UlLevelList ulLevelList, UlLevelUpoints levelUpoints) {
        QueryResult<UlLevelListconf> ulLevelListconfQueryResult = this.ulLevelListconfService.queryUlLevelListconfPage(this.getQueryParamMap("levelListCode,tenantCode,levelUserqua", new Object[]{ulLevelList.getLevelListCode(), ulLevelList.getTenantCode(), ulLevelList.getLevelUserqua()}));
        if (null == ulLevelListconfQueryResult || ListUtil.isEmpty((Collection)ulLevelListconfQueryResult.getList())) {
            this.logger.error("ul.UlLevelUllistServiceImplupDisLevelUpoints.ulLevelListconfQueryResult", (Object)(ulLevelList.getLevelListCode() + "-" + ulLevelList.getTenantCode() + "-" + ulLevelList.getLevelUserqua()));
            return false;
        }
        for (UlLevelListconf ulLevelListconf : ulLevelListconfQueryResult.getList()) {
            List<UlLevelUllist> ulLevelUllists = this.queryUlLevelUllistModelPage(this.getQueryParamMap("memberCode,levelUserqua,tenantCode,levelRuleApi,levelType,order", new Object[]{levelUpoints.getMemberCode(), levelUpoints.getLevelUserqua(), levelUpoints.getTenantCode(), ulLevelListconf.getLevelDatatype(), ulLevelListconf.getLevelType(), true}));
            if (null == ulLevelUllists || ListUtil.isEmpty(ulLevelUllists)) {
                this.logger.error("ul.UlLevelUllistServiceImplupDisLevelUpoints.ulLevelUllistQueryResult", (Object)(levelUpoints.getMemberCode() + "-" + levelUpoints.getTenantCode() + "-" + ulLevelListconf.getLevelDatatype()));
                return false;
            }
            UlLevelUllist ulLevelUllist = ulLevelUllists.get(0);
            this.logger.error("ul.UlLevelUllistServiceImpl.upDisLevelUpoints.ulLevelUllist", (Object)JsonUtil.buildNormalBinder().toJson((Object)ulLevelUllist));
            this.logger.error("ul.UlLevelUllistServiceImpl.upDisLevelUpoints.ulLevelListconf", (Object)JsonUtil.buildNormalBinder().toJson((Object)ulLevelListconf));
            if (ulLevelUllist.getLevelAfnum().intValue() >= ulLevelListconf.getLevelListStart()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String saveDisUlLevelUpointsByUserInfo(UmUserinfoDomain umUserinfo, UmUserDomain umUser, String optype) {
        if (null == umUserinfo) {
            return "error";
        }
        boolean boo = true;
        if (ListUtil.isNotEmpty(umUserinfo.getUmUserinfoQuaList())) {
            for (UmUserinfoQua umUserinfoQua : umUserinfo.getUmUserinfoQuaList()) {
                if ("levelListCode_dis".equals(umUserinfoQua.getUserinfoQuaKey())) {
                    this.addUlLevelUpoints(umUserinfo, umUserinfoQua, "dis");
                    boo = false;
                    continue;
                }
                if (!umUserinfoQua.getUserinfoQuaKey().contains("levelListCode")) continue;
                String[] s = umUserinfoQua.getUserinfoQuaKey().split("_");
                this.addUlLevelUpoints(umUserinfo, umUserinfoQua, s[1]);
            }
        }
        if (boo && null != umUserinfo.getUserinfoQuality() && umUserinfo.getUserinfoQuality().contains("dis")) {
            this.addUlLevelUpoints(umUserinfo, null, "dis");
        }
        return "success";
    }

    @Override
    public String saveUlLevelDefault(UmUserinfoDomain umUserinfo, UmUserDomain umUser, String optype) {
        String[] split;
        if (null == umUserinfo || StringUtils.isBlank((String)umUserinfo.getUserinfoQuality())) {
            return "error";
        }
        for (String quality : split = umUserinfo.getUserinfoQuality().split(",")) {
            this.addUlLevelUpointsDefault(umUserinfo, quality);
        }
        return "success";
    }

    private void addUlLevelUpointsDefault(UmUserinfoDomain umUserinfo, String levelUserqua) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelType", "0");
        map.put("levelUserqua", levelUserqua);
        map.put("tenantCode", umUserinfo.getTenantCode());
        map.put("memberMcode", umUserinfo.getUserinfoParentCode());
        map.put("memberCode", umUserinfo.getUserinfoCode());
        UlLevelUpoints levelUpoints = this.getUlLevelUpointsByMember(map);
        if (null != levelUpoints) {
            return;
        }
        levelUpoints = this.defaultDisUlLevelUpoints(map);
        if (null == levelUpoints) {
            return;
        }
        UlLevelUpointsDomain ulLevelUpointsDomain = new UlLevelUpointsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUpointsDomain, (Object)levelUpoints);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveUlLevelUpoints(ulLevelUpointsDomain);
        this.updateUserInfoLevel(levelUpoints);
    }

    private void addUlLevelUpoints(UmUserinfoDomain umUserinfo, UmUserinfoQua userinfoQua, String levelUserqua) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelType", "0");
        map.put("levelUserqua", levelUserqua);
        map.put("tenantCode", umUserinfo.getTenantCode());
        map.put("memberMcode", umUserinfo.getUserinfoParentCode());
        map.put("memberCode", umUserinfo.getUserinfoCode());
        UlLevelUpoints levelUpoints = this.getUlLevelUpointsByMember(map);
        if (null == levelUpoints) {
            return;
        }
        UlLevelUpointsDomain ulLevelUpointsDomain = new UlLevelUpointsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUpointsDomain, (Object)levelUpoints);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != userinfoQua) {
            if (userinfoQua.getUserinfoQuaVaule().equals(ulLevelUpointsDomain.getLevelDatavalue()) && userinfoQua.getUserinfoQuaVaule1().equals(ulLevelUpointsDomain.getLevelListName())) {
                return;
            }
            ulLevelUpointsDomain.setLevelDatatype("levelListCode");
            ulLevelUpointsDomain.setLevelDatavalue(userinfoQua.getUserinfoQuaVaule());
            ulLevelUpointsDomain.setLevelListName(userinfoQua.getUserinfoQuaVaule1());
            ulLevelUpointsDomain.setLevelListLevel(Integer.getInteger(userinfoQua.getUserinfoQuaUrl2()));
            HashMap<String, Object> ulMap = new HashMap<String, Object>();
            ulMap.put("tenantCode", umUserinfo.getTenantCode());
            QueryResult<UlLevel> ulLevelQueryResult = this.ulLevelService.queryUlLevelPage(ulMap);
            if (null == ulLevelQueryResult || ListUtil.isEmpty((Collection)ulLevelQueryResult.getList())) {
                throw new ApiException("ul.UlLevelUllistServiceImpl.makeSaveUlLevelUpoints.ulLevelQueryResult", "ulLevelQueryResult is null" + ulMap);
            }
            ulLevelUpointsDomain.setLevelUpointsState(new Date());
            if (null != ((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk() || !"".equals(((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk()) || ((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk() > 0) {
                ulLevelUpointsDomain.setLevelUpointsState(new Date());
                ulLevelUpointsDomain.setLevelUpointsState(DateUtils.addDays((Date)ulLevelUpointsDomain.getLevelUpointsState(), (int)((UlLevel)ulLevelQueryResult.getList().get(0)).getLevelOk()));
            }
            ulLevelUpointsDomain.setMemberMcode(umUserinfo.getUserinfoParentCode());
            ulLevelUpointsDomain.setMemberMname(umUserinfo.getUserinfoParentName());
            this.saveUlLevelUpoints(ulLevelUpointsDomain);
        } else if (null == userinfoQua && null == ulLevelUpointsDomain.getLevelUpointsCode()) {
            this.saveUlLevelUpoints(ulLevelUpointsDomain);
            this.updateUserInfoLevel(levelUpoints);
        }
    }

    private boolean updateUserInfoLevel(UlLevelUpoints levelUpoints) throws ApiException {
        HashMap<String, Object> umInfoMapStr = new HashMap<String, Object>();
        umInfoMapStr.put("userinfoCode", levelUpoints.getMemberCode());
        umInfoMapStr.put("tenantCode", levelUpoints.getTenantCode());
        umInfoMapStr.put("userinfoQuaKey", "levelListCode_" + levelUpoints.getLevelUserqua());
        umInfoMapStr.put("levelDatavalue", levelUpoints.getLevelDatavalue());
        umInfoMapStr.put("levelListName", levelUpoints.getLevelListName());
        umInfoMapStr.put("levelListLevel", levelUpoints.getLevelListLevel());
        HashMap<String, String> umUserParamMap = new HashMap<String, String>();
        umUserParamMap.put("map", JsonUtil.buildNormalBinder().toJson(umInfoMapStr));
        try {
            this.getInternalRouter().inInvoke("um.user.updateLevel", umUserParamMap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.updateUserInfoLevel.updateLevel.e", (Object)("\u4fee\u6539\u7528\u6237\u4f1a\u5458\u5f02\u5e38\uff01\uff01\uff01umUserParamMap:" + JsonUtil.buildNormalBinder().toJson(umUserParamMap)));
            return false;
        }
        return true;
    }
}

