/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ul.domain.UlLevelDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelListReDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelRuleDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.ul.model.UlLevel;
import com.yqbsoft.laser.service.ul.model.UlLevelList;
import com.yqbsoft.laser.service.ul.model.UlLevelRule;
import com.yqbsoft.laser.service.ul.service.UlLevelBaseService;
import com.yqbsoft.laser.service.ul.service.UlLevelRuleService;
import com.yqbsoft.laser.service.ul.service.UlLevelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class UlLevelBaseServiceImpl
extends BaseServiceImpl
implements UlLevelBaseService {
    private static final String SYS_CODE = "ul.UlLevelBaseServiceImpl";
    private UlLevelService ulLevelService;
    private UlLevelRuleService ulLevelRuleService;

    public void setUlLevelService(UlLevelService ulLevelService) {
        this.ulLevelService = ulLevelService;
    }

    public void setUlLevelRuleService(UlLevelRuleService ulLevelRuleService) {
        this.ulLevelRuleService = ulLevelRuleService;
    }

    @Override
    public String saveUlLevelInitialization(Map<String, Object> map) throws ApiException {
        if (MapUtils.isEmpty(map) || null == map.get("tenantCode")) {
            this.logger.error("ul.UlLevelBaseServiceImpl.saveUlLevelInitialization", (Object)map.toString());
            return "error";
        }
        QueryResult<UlLevel> qulist = this.ulLevelService.queryUlLevelPage(map);
        if (null != qulist && ListUtil.isNotEmpty((Collection)qulist.getList())) {
            return "success";
        }
        HashMap<String, Object> parem = new HashMap<String, Object>();
        parem.put("tenantCode", "00000000");
        qulist = this.ulLevelService.queryUlLevelPage(parem);
        if (null == qulist || ListUtil.isEmpty((Collection)qulist.getList())) {
            this.logger.error("ul.UlLevelBaseServiceImpl.saveUlLevelInitialization.ulLevels", (Object)map.toString());
            return "error";
        }
        String code = "";
        for (UlLevel ulLevel : qulist.getList()) {
            UlLevelDomain ulLevelDomain = this.makeLevelDomain(ulLevel, map);
            code = this.ulLevelService.saveUlLevel(ulLevelDomain);
            this.queryUlLevelRuleModelPage(ulLevel, code, (String)map.get("tenantCode"));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("ulLevelListList", JsonUtil.buildNonNullBinder().toJson(ulLevelDomain.getUlLevelListReDomainList()));
            String s = this.internalInvoke("ur.userrule.saveUrByDefault", paramMap);
            if (!StringUtils.isBlank((String)s) && "success".equals(s)) continue;
            throw new ApiException("ul.UlLevelBaseServiceImpl.saveUlLevelInitialization.s", ulLevel.getLevelCode());
        }
        return "success";
    }

    private UlLevelDomain makeLevelDomain(UlLevel ulLevel, Map<String, Object> map) {
        if (null == ulLevel || MapUtils.isEmpty(map) || null == map.get("tenantCode")) {
            return null;
        }
        UlLevelDomain ulLevelDomain = new UlLevelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelDomain, (Object)ulLevel);
            BeanUtils.copyAllPropertys((Object)ulLevelDomain, map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelBaseServiceImpl.savePackageList.e", (Throwable)e);
        }
        ulLevelDomain.setLevelId(null);
        ulLevelDomain.setLevelCode(null);
        if (null != map.get("tenantCode")) {
            ulLevelDomain.setTenantCode(map.get("tenantCode").toString());
        }
        if (null != map.get("goodsClass")) {
            ulLevelDomain.setGoodsClass(map.get("goodsClass").toString());
        }
        if (null != map.get("memberMcode") && null != map.get("memberMname")) {
            ulLevelDomain.setMemberMcode(map.get("memberMcode").toString());
            ulLevelDomain.setMemberMname(map.get("memberMname").toString());
        }
        if (null != map.get("channelCode") && null != map.get("channelName")) {
            ulLevelDomain.setChannelCode(map.get("channelCode").toString());
            ulLevelDomain.setChannelName(map.get("channelName").toString());
        }
        HashMap<String, Object> listmap = new HashMap<String, Object>();
        listmap.put("tenantCode", map.get("tenantCode").toString());
        listmap.put("levelCode", ulLevel.getLevelCode());
        QueryResult<UlLevelList> rlist = this.ulLevelService.queryUlLevelListPage(listmap);
        if (null != rlist && ListUtil.isNotEmpty((Collection)rlist.getList())) {
            ArrayList<UlLevelListReDomain> ulLevelListReDomainList = new ArrayList<UlLevelListReDomain>();
            for (UlLevelList ulLevelList : rlist.getList()) {
                UlLevelListReDomain ulLevelListDomain = new UlLevelListReDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)ulLevelListDomain, (Object)ulLevelList);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ulLevelListDomain.setLevelCode(null);
                ulLevelListDomain.setLevelListCode(null);
                ulLevelListDomain.setLevelListId(null);
                ulLevelListDomain.setDataState(null);
                ulLevelListDomain.setGmtCreate(null);
                ulLevelListDomain.setGmtModified(null);
                ulLevelListReDomainList.add(ulLevelListDomain);
            }
            ulLevelDomain.setUlLevelListReDomainList(ulLevelListReDomainList);
        }
        return ulLevelDomain;
    }

    private UlLevelListReDomain makeUlLevelListReDomain(UlLevelList ulLevelList) {
        if (null == ulLevelList) {
            return null;
        }
        UlLevelListReDomain ulLevelListReDomain = new UlLevelListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelListReDomain, (Object)ulLevelList);
            ulLevelListReDomain.setLevelListId(null);
            ulLevelListReDomain.setLevelListCode(null);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelBaseServiceImpl.savePackageList.e", (Throwable)e);
        }
        return ulLevelListReDomain;
    }

    private UlLevelRuleDomain makeUlLevelRuleReDomain(UlLevelRule levelRule) {
        if (null == levelRule) {
            return null;
        }
        UlLevelRuleDomain ulLevelRuleDomain = new UlLevelRuleDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelRuleDomain, (Object)levelRule);
            ulLevelRuleDomain.setLevelRuleId(null);
            ulLevelRuleDomain.setLevelRuleCode(null);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelBaseServiceImpl.savePackageList.e", (Throwable)e);
        }
        return ulLevelRuleDomain;
    }

    public List<UlLevelListReDomain> queryUlLevelModelPage(UlLevel ulLevel) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ulLevel.getTenantCode());
        map.put("levelCode", ulLevel.getLevelCode());
        QueryResult<UlLevelList> ulLevelLists = this.ulLevelService.queryUlLevelListPage(map);
        if (null == ulLevelLists || ListUtil.isEmpty((Collection)ulLevelLists.getList())) {
            return null;
        }
        ArrayList<UlLevelListReDomain> ulLevelListReDomains = new ArrayList<UlLevelListReDomain>();
        for (UlLevelList ulLevelList : ulLevelLists.getList()) {
            ulLevelListReDomains.add(this.makeUlLevelListReDomain(ulLevelList));
        }
        return ulLevelListReDomains;
    }

    public List<UlLevelRuleDomain> queryUlLevelRuleModelPage(UlLevel ulLevel, String code, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ulLevel.getTenantCode());
        map.put("levelCode", ulLevel.getLevelCode());
        QueryResult<UlLevelRule> ulLevelRules = this.ulLevelRuleService.queryUlLevelRulePage(map);
        ulLevelRules = this.ulLevelRuleService.queryUlLevelRulePage(map);
        if (null == ulLevelRules || ListUtil.isEmpty((Collection)ulLevelRules.getList())) {
            return null;
        }
        for (UlLevelRule levelRule : ulLevelRules.getList()) {
            UlLevelRuleDomain ulLevelRuleDomain = this.makeUlLevelRuleReDomain(levelRule);
            ulLevelRuleDomain.setLevelCode(code);
            ulLevelRuleDomain.setTenantCode(tenantCode);
            this.ulLevelRuleService.saveUlLevelRule(ulLevelRuleDomain);
        }
        return null;
    }

    @Override
    public String saveInitializationByUser(UmUserinfoDomain umUserinfo, UmUserDomain umUser, String optype) throws ApiException {
        if (null == umUserinfo) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberMcode", umUserinfo.getUserinfoCode());
        map.put("memberMname", umUserinfo.getCompanyCode());
        map.put("tenantCode", umUserinfo.getTenantCode());
        String goodsClass = this.getUrl(umUserinfo.getTenantCode(), "ul_goodsClass", "ul_goodsClass");
        if (StringUtils.isNotBlank((String)goodsClass)) {
            map.put("goodsClass", goodsClass);
        }
        String channelCode = this.getUrl(umUserinfo.getTenantCode(), "ul_channelCode", "ul_channelCode");
        String channelName = this.getUrl(umUserinfo.getTenantCode(), "ul_channelName", "ul_channelName");
        if (StringUtils.isNotBlank((String)channelCode) && StringUtils.isNotBlank((String)channelName)) {
            map.put("channelCode", channelCode);
            map.put("channelName", channelName);
        }
        return this.saveUlLevelInitialization(map);
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        if (StringUtils.isBlank((String)value)) {
            field = "00000000".concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
            value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        }
        this.logger.error("ul.UlLevelBaseServiceImpl.getUrl", (Object)value);
        return value;
    }
}

