/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ula.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ula.dao.UlaLabelMapper;
import com.yqbsoft.laser.service.ula.domain.UlaLabelDomain;
import com.yqbsoft.laser.service.ula.domain.UlaLabelReDomain;
import com.yqbsoft.laser.service.ula.model.UlaLabel;
import com.yqbsoft.laser.service.ula.service.UlaLabelService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UlaLabelServiceImpl
extends BaseServiceImpl
implements UlaLabelService {
    private static final String SYS_CODE = "ula.UlaLabelServiceImpl";
    private UlaLabelMapper ulaLabelMapper;

    public void setUlaLabelMapper(UlaLabelMapper ulaLabelMapper) {
        this.ulaLabelMapper = ulaLabelMapper;
    }

    private Date getSysDate() {
        try {
            return this.ulaLabelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLabelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlaLabel(UlaLabelDomain ulaLabelDomain) {
        if (null == ulaLabelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulaLabelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlaLabelDefault(UlaLabel ulaLabel) {
        if (null == ulaLabel) {
            return;
        }
        if (null == ulaLabel.getDataState()) {
            ulaLabel.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulaLabel.getGmtCreate()) {
            ulaLabel.setGmtCreate(date);
        }
        ulaLabel.setGmtModified(date);
        if (StringUtils.isBlank((String)ulaLabel.getLableCode())) {
            ulaLabel.setLableCode(this.getNo(null, "UlaLabel", "ulaLabel", ulaLabel.getTenantCode()));
        }
    }

    private int getUlaLabelMaxCode() {
        int code = 0;
        try {
            return this.ulaLabelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLabelServiceImpl.getUlaLabelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlaLabelUpdataDefault(UlaLabel ulaLabel) {
        if (null == ulaLabel) {
            return;
        }
        ulaLabel.setGmtModified(this.getSysDate());
    }

    private void saveUlaLabelModel(UlaLabel ulaLabel) throws ApiException {
        if (null == ulaLabel) {
            return;
        }
        try {
            this.ulaLabelMapper.insert(ulaLabel);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLabelServiceImpl.saveUlaLabelModel.ex", (Throwable)e);
        }
    }

    private void saveUlaLabelBatchModel(List<UlaLabel> ulaLabelList) throws ApiException {
        if (null == ulaLabelList || ulaLabelList.isEmpty()) {
            return;
        }
        try {
            this.ulaLabelMapper.insertBatch(ulaLabelList);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLabelServiceImpl.saveUlaLabelBatchModel.ex", (Throwable)e);
        }
    }

    private UlaLabel getUlaLabelModelById(Integer lableId) {
        if (null == lableId) {
            return null;
        }
        try {
            return this.ulaLabelMapper.selectByPrimaryKey(lableId);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLabelServiceImpl.getUlaLabelModelById", (Throwable)e);
            return null;
        }
    }

    private UlaLabel getUlaLabelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulaLabelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLabelServiceImpl.getUlaLabelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlaLabelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLabelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLabelServiceImpl.delUlaLabelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLabelServiceImpl.delUlaLabelModelByCode.num");
        }
    }

    private void deleteUlaLabelModel(Integer lableId) throws ApiException {
        if (null == lableId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLabelMapper.deleteByPrimaryKey(lableId);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLabelServiceImpl.deleteUlaLabelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLabelServiceImpl.deleteUlaLabelModel.num");
        }
    }

    private void updateUlaLabelModel(UlaLabel ulaLabel) throws ApiException {
        if (null == ulaLabel) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLabelMapper.updateByPrimaryKeySelective(ulaLabel);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLabelServiceImpl.updateUlaLabelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLabelServiceImpl.updateUlaLabelModel.num");
        }
    }

    private void updateStateUlaLabelModel(Integer lableId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == lableId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lableId", lableId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulaLabelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLabelServiceImpl.updateStateUlaLabelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ula.UlaLabelServiceImpl.updateStateUlaLabelModel.null");
        }
    }

    private void updateStateUlaLabelModelByCode(String tenantCode, String lableCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)lableCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lableCode", lableCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulaLabelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLabelServiceImpl.updateStateUlaLabelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ula.UlaLabelServiceImpl.updateStateUlaLabelModelByCode.null");
        }
    }

    private UlaLabel makeUlaLabel(UlaLabelDomain ulaLabelDomain, UlaLabel ulaLabel) {
        if (null == ulaLabelDomain) {
            return null;
        }
        if (null == ulaLabel) {
            ulaLabel = new UlaLabel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulaLabel, (Object)ulaLabelDomain);
            return ulaLabel;
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLabelServiceImpl.makeUlaLabel", (Throwable)e);
            return null;
        }
    }

    private UlaLabelReDomain makeUlaLabelReDomain(UlaLabel ulaLabel) {
        if (null == ulaLabel) {
            return null;
        }
        UlaLabelReDomain ulaLabelReDomain = new UlaLabelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulaLabelReDomain, (Object)ulaLabel);
            return ulaLabelReDomain;
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLabelServiceImpl.makeUlaLabelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlaLabel> queryUlaLabelModelPage(Map<String, Object> parammap) {
        try {
            return this.ulaLabelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLabelServiceImpl.queryUlaLabelModel", (Throwable)e);
            return null;
        }
    }

    private int countUlaLabel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulaLabelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLabelServiceImpl.countUlaLabel", (Throwable)e);
        }
        return i;
    }

    private UlaLabel createUlaLabel(UlaLabelDomain ulaLabelDomain) {
        String msg = this.checkUlaLabel(ulaLabelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ula.UlaLabelServiceImpl.saveUlaLabel.checkUlaLabel", msg);
        }
        UlaLabel ulaLabel = this.makeUlaLabel(ulaLabelDomain, null);
        this.setUlaLabelDefault(ulaLabel);
        return ulaLabel;
    }

    @Override
    public String saveUlaLabel(UlaLabelDomain ulaLabelDomain) throws ApiException {
        UlaLabel ulaLabel = this.createUlaLabel(ulaLabelDomain);
        this.saveUlaLabelModel(ulaLabel);
        return ulaLabel.getLableCode();
    }

    @Override
    public String saveUlaLabelBatch(List<UlaLabelDomain> ulaLabelDomainList) throws ApiException {
        if (null == ulaLabelDomainList || ulaLabelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlaLabel> ulaLabelList = new ArrayList<UlaLabel>();
        String code = "";
        for (UlaLabelDomain ulaLabelDomain : ulaLabelDomainList) {
            UlaLabel ulaLabel = this.createUlaLabel(ulaLabelDomain);
            code = ulaLabel.getLableCode();
            ulaLabelList.add(ulaLabel);
        }
        this.saveUlaLabelBatchModel(ulaLabelList);
        return code;
    }

    @Override
    public void updateUlaLabelState(Integer lableId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == lableId) {
            return;
        }
        this.updateStateUlaLabelModel(lableId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlaLabelStateByCode(String tenantCode, String lableCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)lableCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlaLabelModelByCode(tenantCode, lableCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlaLabel(UlaLabelDomain ulaLabelDomain) throws ApiException {
        String msg = this.checkUlaLabel(ulaLabelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ula.UlaLabelServiceImpl.updateUlaLabel.checkUlaLabel", msg);
        }
        UlaLabel oldUlaLabel = this.getUlaLabelModelById(ulaLabelDomain.getLableId());
        if (null == oldUlaLabel) {
            throw new ApiException("ula.UlaLabelServiceImpl.updateUlaLabel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlaLabel ulaLabel = this.makeUlaLabel(ulaLabelDomain, oldUlaLabel);
        this.setUlaLabelUpdataDefault(ulaLabel);
        this.updateUlaLabelModel(ulaLabel);
    }

    @Override
    public UlaLabel getUlaLabel(Integer lableId) {
        if (null == lableId) {
            return null;
        }
        return this.getUlaLabelModelById(lableId);
    }

    @Override
    public void deleteUlaLabel(Integer lableId) throws ApiException {
        if (null == lableId) {
            return;
        }
        this.deleteUlaLabelModel(lableId);
    }

    @Override
    public QueryResult<UlaLabel> queryUlaLabelPage(Map<String, Object> map) {
        List<UlaLabel> ulaLabelList = this.queryUlaLabelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlaLabel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulaLabelList);
        return queryResult;
    }

    @Override
    public UlaLabel getUlaLabelByCode(String tenantCode, String lableCode) throws ApiException {
        if (StringUtils.isBlank((String)lableCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lableCode", lableCode);
        return this.getUlaLabelModelByCode(map);
    }

    @Override
    public void deleteUlaLabelByCode(String tenantCode, String lableCode) throws ApiException {
        if (StringUtils.isBlank((String)lableCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lableCode", lableCode);
        this.delUlaLabelModelByCode(map);
    }
}

