/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ula.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ula.dao.UlaLgroupMapper;
import com.yqbsoft.laser.service.ula.domain.UlaLgroupDomain;
import com.yqbsoft.laser.service.ula.domain.UlaLgroupReDomain;
import com.yqbsoft.laser.service.ula.model.UlaLgroup;
import com.yqbsoft.laser.service.ula.service.UlaLgroupService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UlaLgroupServiceImpl
extends BaseServiceImpl
implements UlaLgroupService {
    private static final String SYS_CODE = "ula.UlaLgroupServiceImpl";
    private UlaLgroupMapper ulaLgroupMapper;

    public void setUlaLgroupMapper(UlaLgroupMapper ulaLgroupMapper) {
        this.ulaLgroupMapper = ulaLgroupMapper;
    }

    private Date getSysDate() {
        try {
            return this.ulaLgroupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLgroupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlaLgroup(UlaLgroupDomain ulaLgroupDomain) {
        if (null == ulaLgroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulaLgroupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlaLgroupDefault(UlaLgroup ulaLgroup) {
        if (null == ulaLgroup) {
            return;
        }
        if (null == ulaLgroup.getDataState()) {
            ulaLgroup.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulaLgroup.getGmtCreate()) {
            ulaLgroup.setGmtCreate(date);
        }
        ulaLgroup.setGmtModified(date);
        if (StringUtils.isBlank((String)ulaLgroup.getLgroupCode())) {
            ulaLgroup.setLgroupCode(this.getNo(null, "UlaLgroup", "ulaLgroup", ulaLgroup.getTenantCode()));
        }
    }

    private int getUlaLgroupMaxCode() {
        int code = 0;
        try {
            return this.ulaLgroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLgroupServiceImpl.getUlaLgroupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlaLgroupUpdataDefault(UlaLgroup ulaLgroup) {
        if (null == ulaLgroup) {
            return;
        }
        ulaLgroup.setGmtModified(this.getSysDate());
    }

    private void saveUlaLgroupModel(UlaLgroup ulaLgroup) throws ApiException {
        if (null == ulaLgroup) {
            return;
        }
        try {
            this.ulaLgroupMapper.insert(ulaLgroup);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLgroupServiceImpl.saveUlaLgroupModel.ex", (Throwable)e);
        }
    }

    private void saveUlaLgroupBatchModel(List<UlaLgroup> ulaLgroupList) throws ApiException {
        if (null == ulaLgroupList || ulaLgroupList.isEmpty()) {
            return;
        }
        try {
            this.ulaLgroupMapper.insertBatch(ulaLgroupList);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLgroupServiceImpl.saveUlaLgroupBatchModel.ex", (Throwable)e);
        }
    }

    private UlaLgroup getUlaLgroupModelById(Integer lgroupId) {
        if (null == lgroupId) {
            return null;
        }
        try {
            return this.ulaLgroupMapper.selectByPrimaryKey(lgroupId);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLgroupServiceImpl.getUlaLgroupModelById", (Throwable)e);
            return null;
        }
    }

    private UlaLgroup getUlaLgroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulaLgroupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLgroupServiceImpl.getUlaLgroupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlaLgroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLgroupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLgroupServiceImpl.delUlaLgroupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLgroupServiceImpl.delUlaLgroupModelByCode.num");
        }
    }

    private void deleteUlaLgroupModel(Integer lgroupId) throws ApiException {
        if (null == lgroupId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLgroupMapper.deleteByPrimaryKey(lgroupId);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLgroupServiceImpl.deleteUlaLgroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLgroupServiceImpl.deleteUlaLgroupModel.num");
        }
    }

    private void updateUlaLgroupModel(UlaLgroup ulaLgroup) throws ApiException {
        if (null == ulaLgroup) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLgroupMapper.updateByPrimaryKeySelective(ulaLgroup);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLgroupServiceImpl.updateUlaLgroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLgroupServiceImpl.updateUlaLgroupModel.num");
        }
    }

    private void updateStateUlaLgroupModel(Integer lgroupId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == lgroupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lgroupId", lgroupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulaLgroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLgroupServiceImpl.updateStateUlaLgroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ula.UlaLgroupServiceImpl.updateStateUlaLgroupModel.null");
        }
    }

    private void updateStateUlaLgroupModelByCode(String tenantCode, String lgroupCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)lgroupCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lgroupCode", lgroupCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulaLgroupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLgroupServiceImpl.updateStateUlaLgroupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ula.UlaLgroupServiceImpl.updateStateUlaLgroupModelByCode.null");
        }
    }

    private UlaLgroup makeUlaLgroup(UlaLgroupDomain ulaLgroupDomain, UlaLgroup ulaLgroup) {
        if (null == ulaLgroupDomain) {
            return null;
        }
        if (null == ulaLgroup) {
            ulaLgroup = new UlaLgroup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulaLgroup, (Object)ulaLgroupDomain);
            return ulaLgroup;
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLgroupServiceImpl.makeUlaLgroup", (Throwable)e);
            return null;
        }
    }

    private UlaLgroupReDomain makeUlaLgroupReDomain(UlaLgroup ulaLgroup) {
        if (null == ulaLgroup) {
            return null;
        }
        UlaLgroupReDomain ulaLgroupReDomain = new UlaLgroupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulaLgroupReDomain, (Object)ulaLgroup);
            return ulaLgroupReDomain;
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLgroupServiceImpl.makeUlaLgroupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlaLgroup> queryUlaLgroupModelPage(Map<String, Object> parammap) {
        try {
            return this.ulaLgroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLgroupServiceImpl.queryUlaLgroupModel", (Throwable)e);
            return null;
        }
    }

    private int countUlaLgroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulaLgroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLgroupServiceImpl.countUlaLgroup", (Throwable)e);
        }
        return i;
    }

    private UlaLgroup createUlaLgroup(UlaLgroupDomain ulaLgroupDomain) {
        String msg = this.checkUlaLgroup(ulaLgroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ula.UlaLgroupServiceImpl.saveUlaLgroup.checkUlaLgroup", msg);
        }
        UlaLgroup ulaLgroup = this.makeUlaLgroup(ulaLgroupDomain, null);
        this.setUlaLgroupDefault(ulaLgroup);
        return ulaLgroup;
    }

    @Override
    public String saveUlaLgroup(UlaLgroupDomain ulaLgroupDomain) throws ApiException {
        UlaLgroup ulaLgroup = this.createUlaLgroup(ulaLgroupDomain);
        this.saveUlaLgroupModel(ulaLgroup);
        return ulaLgroup.getLgroupCode();
    }

    @Override
    public String saveUlaLgroupBatch(List<UlaLgroupDomain> ulaLgroupDomainList) throws ApiException {
        if (null == ulaLgroupDomainList || ulaLgroupDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlaLgroup> ulaLgroupList = new ArrayList<UlaLgroup>();
        String code = "";
        for (UlaLgroupDomain ulaLgroupDomain : ulaLgroupDomainList) {
            UlaLgroup ulaLgroup = this.createUlaLgroup(ulaLgroupDomain);
            code = ulaLgroup.getLgroupCode();
            ulaLgroupList.add(ulaLgroup);
        }
        this.saveUlaLgroupBatchModel(ulaLgroupList);
        return code;
    }

    @Override
    public void updateUlaLgroupState(Integer lgroupId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == lgroupId) {
            return;
        }
        this.updateStateUlaLgroupModel(lgroupId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlaLgroupStateByCode(String tenantCode, String lgroupCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)lgroupCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlaLgroupModelByCode(tenantCode, lgroupCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlaLgroup(UlaLgroupDomain ulaLgroupDomain) throws ApiException {
        String msg = this.checkUlaLgroup(ulaLgroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ula.UlaLgroupServiceImpl.updateUlaLgroup.checkUlaLgroup", msg);
        }
        UlaLgroup oldUlaLgroup = this.getUlaLgroupModelById(ulaLgroupDomain.getLgroupId());
        if (null == oldUlaLgroup) {
            throw new ApiException("ula.UlaLgroupServiceImpl.updateUlaLgroup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlaLgroup ulaLgroup = this.makeUlaLgroup(ulaLgroupDomain, oldUlaLgroup);
        this.setUlaLgroupUpdataDefault(ulaLgroup);
        this.updateUlaLgroupModel(ulaLgroup);
    }

    @Override
    public UlaLgroup getUlaLgroup(Integer lgroupId) {
        if (null == lgroupId) {
            return null;
        }
        return this.getUlaLgroupModelById(lgroupId);
    }

    @Override
    public void deleteUlaLgroup(Integer lgroupId) throws ApiException {
        if (null == lgroupId) {
            return;
        }
        this.deleteUlaLgroupModel(lgroupId);
    }

    @Override
    public QueryResult<UlaLgroup> queryUlaLgroupPage(Map<String, Object> map) {
        List<UlaLgroup> ulaLgroupList = this.queryUlaLgroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlaLgroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulaLgroupList);
        return queryResult;
    }

    @Override
    public UlaLgroup getUlaLgroupByCode(String tenantCode, String lgroupCode) throws ApiException {
        if (StringUtils.isBlank((String)lgroupCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lgroupCode", lgroupCode);
        return this.getUlaLgroupModelByCode(map);
    }

    @Override
    public void deleteUlaLgroupByCode(String tenantCode, String lgroupCode) throws ApiException {
        if (StringUtils.isBlank((String)lgroupCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("lgroupCode", lgroupCode);
        this.delUlaLgroupModelByCode(map);
    }
}

