/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ula.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ula.dao.UlaLtypeMapper;
import com.yqbsoft.laser.service.ula.domain.UlaLtypeColDomain;
import com.yqbsoft.laser.service.ula.domain.UlaLtypeDomain;
import com.yqbsoft.laser.service.ula.domain.UlaLtypeReDomain;
import com.yqbsoft.laser.service.ula.model.UlaLtype;
import com.yqbsoft.laser.service.ula.service.UlaLtypeService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class UlaLtypeServiceImpl
extends BaseServiceImpl
implements UlaLtypeService {
    private static final String SYS_CODE = "ula.UlaLtypeServiceImpl";
    private UlaLtypeMapper ulaLtypeMapper;

    public void setUlaLtypeMapper(UlaLtypeMapper ulaLtypeMapper) {
        this.ulaLtypeMapper = ulaLtypeMapper;
    }

    private Date getSysDate() {
        try {
            return this.ulaLtypeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlaLtype(UlaLtypeDomain ulaLtypeDomain) {
        if (null == ulaLtypeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulaLtypeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlaLtypeDefault(UlaLtype ulaLtype) {
        if (null == ulaLtype) {
            return;
        }
        if (null == ulaLtype.getDataState()) {
            ulaLtype.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulaLtype.getGmtCreate()) {
            ulaLtype.setGmtCreate(date);
        }
        ulaLtype.setGmtModified(date);
        if (StringUtils.isBlank((String)ulaLtype.getLtypeCode())) {
            ulaLtype.setLtypeCode(this.getNo(null, "UlaLtype", "ulaLtype", ulaLtype.getTenantCode()));
        }
    }

    private int getUlaLtypeMaxCode() {
        int code = 0;
        try {
            return this.ulaLtypeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeServiceImpl.getUlaLtypeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlaLtypeUpdataDefault(UlaLtype ulaLtype) {
        if (null == ulaLtype) {
            return;
        }
        ulaLtype.setGmtModified(this.getSysDate());
    }

    private void saveUlaLtypeModel(UlaLtype ulaLtype) throws ApiException {
        if (null == ulaLtype) {
            return;
        }
        try {
            this.ulaLtypeMapper.insert(ulaLtype);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeServiceImpl.saveUlaLtypeModel.ex", (Throwable)e);
        }
    }

    private void saveUlaLtypeBatchModel(List<UlaLtype> ulaLtypeList) throws ApiException {
        if (null == ulaLtypeList || ulaLtypeList.isEmpty()) {
            return;
        }
        try {
            this.ulaLtypeMapper.insertBatch(ulaLtypeList);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeServiceImpl.saveUlaLtypeBatchModel.ex", (Throwable)e);
        }
    }

    private UlaLtype getUlaLtypeModelById(Integer ltypeId) {
        if (null == ltypeId) {
            return null;
        }
        try {
            return this.ulaLtypeMapper.selectByPrimaryKey(ltypeId);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeServiceImpl.getUlaLtypeModelById", (Throwable)e);
            return null;
        }
    }

    private UlaLtype getUlaLtypeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulaLtypeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeServiceImpl.getUlaLtypeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlaLtypeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLtypeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeServiceImpl.delUlaLtypeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLtypeServiceImpl.delUlaLtypeModelByCode.num");
        }
    }

    private void deleteUlaLtypeModel(Integer ltypeId) throws ApiException {
        if (null == ltypeId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLtypeMapper.deleteByPrimaryKey(ltypeId);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeServiceImpl.deleteUlaLtypeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLtypeServiceImpl.deleteUlaLtypeModel.num");
        }
    }

    private void updateUlaLtypeModel(UlaLtype ulaLtype) throws ApiException {
        if (null == ulaLtype) {
            return;
        }
        int i = 0;
        try {
            i = this.ulaLtypeMapper.updateByPrimaryKeySelective(ulaLtype);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeServiceImpl.updateUlaLtypeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ula.UlaLtypeServiceImpl.updateUlaLtypeModel.num");
        }
    }

    private void updateStateUlaLtypeModel(Integer ltypeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ltypeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ltypeId", ltypeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulaLtypeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeServiceImpl.updateStateUlaLtypeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ula.UlaLtypeServiceImpl.updateStateUlaLtypeModel.null");
        }
    }

    private void updateStateUlaLtypeModelByCode(String tenantCode, String ltypeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ltypeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltypeCode", ltypeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulaLtypeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ula.UlaLtypeServiceImpl.updateStateUlaLtypeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ula.UlaLtypeServiceImpl.updateStateUlaLtypeModelByCode.null");
        }
    }

    private UlaLtype makeUlaLtype(UlaLtypeDomain ulaLtypeDomain, UlaLtype ulaLtype) {
        if (null == ulaLtypeDomain) {
            return null;
        }
        if (null == ulaLtype) {
            ulaLtype = new UlaLtype();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulaLtype, (Object)ulaLtypeDomain);
            return ulaLtype;
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeServiceImpl.makeUlaLtype", (Throwable)e);
            return null;
        }
    }

    private UlaLtypeReDomain makeUlaLtypeReDomain(UlaLtype ulaLtype) {
        if (null == ulaLtype) {
            return null;
        }
        UlaLtypeReDomain ulaLtypeReDomain = new UlaLtypeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulaLtypeReDomain, (Object)ulaLtype);
            return ulaLtypeReDomain;
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeServiceImpl.makeUlaLtypeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlaLtype> queryUlaLtypeModelPage(Map<String, Object> parammap) {
        try {
            return this.ulaLtypeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeServiceImpl.queryUlaLtypeModel", (Throwable)e);
            return null;
        }
    }

    private int countUlaLtype(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulaLtypeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ula.UlaLtypeServiceImpl.countUlaLtype", (Throwable)e);
        }
        return i;
    }

    private UlaLtype createUlaLtype(UlaLtypeDomain ulaLtypeDomain) {
        String msg = this.checkUlaLtype(ulaLtypeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ula.UlaLtypeServiceImpl.saveUlaLtype.checkUlaLtype", msg);
        }
        UlaLtype ulaLtype = this.makeUlaLtype(ulaLtypeDomain, null);
        this.setUlaLtypeDefault(ulaLtype);
        return ulaLtype;
    }

    @Override
    public String saveUlaLtype(UlaLtypeDomain ulaLtypeDomain) throws ApiException {
        UlaLtype ulaLtype = this.createUlaLtype(ulaLtypeDomain);
        this.saveUlaLtypeModel(ulaLtype);
        return ulaLtype.getLtypeCode();
    }

    @Override
    public String saveUlaLtypeBatch(List<UlaLtypeDomain> ulaLtypeDomainList) throws ApiException {
        if (null == ulaLtypeDomainList || ulaLtypeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlaLtype> ulaLtypeList = new ArrayList<UlaLtype>();
        String code = "";
        for (UlaLtypeDomain ulaLtypeDomain : ulaLtypeDomainList) {
            UlaLtype ulaLtype = this.createUlaLtype(ulaLtypeDomain);
            code = ulaLtype.getLtypeCode();
            ulaLtypeList.add(ulaLtype);
        }
        this.saveUlaLtypeBatchModel(ulaLtypeList);
        return code;
    }

    @Override
    public void updateUlaLtypeState(Integer ltypeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ltypeId) {
            return;
        }
        this.updateStateUlaLtypeModel(ltypeId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlaLtypeStateByCode(String tenantCode, String ltypeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ltypeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlaLtypeModelByCode(tenantCode, ltypeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlaLtype(UlaLtypeDomain ulaLtypeDomain) throws ApiException {
        String msg = this.checkUlaLtype(ulaLtypeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ula.UlaLtypeServiceImpl.updateUlaLtype.checkUlaLtype", msg);
        }
        UlaLtype oldUlaLtype = this.getUlaLtypeModelById(ulaLtypeDomain.getLtypeId());
        if (null == oldUlaLtype) {
            throw new ApiException("ula.UlaLtypeServiceImpl.updateUlaLtype.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlaLtype ulaLtype = this.makeUlaLtype(ulaLtypeDomain, oldUlaLtype);
        this.setUlaLtypeUpdataDefault(ulaLtype);
        this.updateUlaLtypeModel(ulaLtype);
    }

    @Override
    public UlaLtype getUlaLtype(Integer ltypeId) {
        if (null == ltypeId) {
            return null;
        }
        return this.getUlaLtypeModelById(ltypeId);
    }

    @Override
    public void deleteUlaLtype(Integer ltypeId) throws ApiException {
        if (null == ltypeId) {
            return;
        }
        this.deleteUlaLtypeModel(ltypeId);
    }

    @Override
    public QueryResult<UlaLtype> queryUlaLtypePage(Map<String, Object> map) {
        List<UlaLtype> ulaLtypeList = this.queryUlaLtypeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlaLtype(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulaLtypeList);
        return queryResult;
    }

    @Override
    public UlaLtype getUlaLtypeByCode(String tenantCode, String ltypeCode) throws ApiException {
        if (StringUtils.isBlank((String)ltypeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltypeCode", ltypeCode);
        return this.getUlaLtypeModelByCode(map);
    }

    @Override
    public void deleteUlaLtypeByCode(String tenantCode, String ltypeCode) throws ApiException {
        if (StringUtils.isBlank((String)ltypeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltypeCode", ltypeCode);
        this.delUlaLtypeModelByCode(map);
    }

    @Override
    public List<UlaLtypeColDomain> queryUlaLtype(Map<String, Object> map) throws Exception {
        ArrayList<UlaLtypeColDomain> ulaLtypeColDomains = new ArrayList();
        List<UlaLtype> list = this.ulaLtypeMapper.query(map);
        this.logger.info("queryUlaLtype", (Object)JsonUtil.buildNonDefaultBinder().toJson(list));
        List<UlaLtype> rootList = UlaLtypeServiceImpl.getRootNodes(list);
        ulaLtypeColDomains = UlaLtypeServiceImpl.buildTree(rootList, list);
        this.logger.info("queryUlaLtype", (Object)("\u8fd4\u56de\u503c\uff1a" + JsonUtil.buildNonDefaultBinder().toJson(ulaLtypeColDomains)));
        return ulaLtypeColDomains;
    }

    public static void main(String[] args) {
        List<Object> ulaLtypeColDomains = new ArrayList();
        ArrayList<UlaLtype> list = new ArrayList<UlaLtype>();
        UlaLtype ulaLtype1 = new UlaLtype();
        ulaLtype1.setLtypePcode("0");
        ulaLtype1.setLtypeCode("001");
        ulaLtype1.setLtypeName("\u5ba2\u89c2\u6807\u7b7e");
        ulaLtype1.setLtypeLevel(0);
        list.add(ulaLtype1);
        UlaLtype ulaLtype2 = new UlaLtype();
        ulaLtype2.setLtypePcode("0");
        ulaLtype2.setLtypeCode("002");
        ulaLtype2.setLtypeName("\u4e3b\u89c2\u6807\u7b7e");
        ulaLtype2.setLtypeLevel(0);
        list.add(ulaLtype2);
        UlaLtype ulaLtype3 = new UlaLtype();
        ulaLtype3.setLtypePcode("001");
        ulaLtype3.setLtypeCode("008");
        ulaLtype3.setLtypeName("\u4e3b\u89c2\u6807\u7b7e1");
        ulaLtype3.setLtypeLevel(0);
        list.add(ulaLtype3);
        List<UlaLtype> rootList = UlaLtypeServiceImpl.getRootNodes(list);
        try {
            ulaLtypeColDomains = UlaLtypeServiceImpl.buildTree(rootList, list);
            System.out.println(JSONObject.toJSONString(ulaLtypeColDomains));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<UlaLtypeColDomain> buildTree(List<UlaLtype> rootList, List<UlaLtype> list) throws Exception {
        ArrayList<UlaLtypeColDomain> ulaLtypeColDomains = new ArrayList<UlaLtypeColDomain>();
        for (int i = 0; i < rootList.size(); ++i) {
            UlaLtype ulaLtype = rootList.get(i);
            UlaLtypeColDomain ulaLtypeColDomain = new UlaLtypeColDomain();
            BeanUtils.copyAllPropertys((Object)ulaLtypeColDomain, (Object)ulaLtype);
            ulaLtypeColDomains.add(UlaLtypeServiceImpl.buildChildTree(ulaLtypeColDomain, list));
        }
        return ulaLtypeColDomains;
    }

    private static UlaLtypeColDomain buildChildTree(UlaLtypeColDomain pNodde, List<UlaLtype> allList) throws Exception {
        ArrayList<UlaLtypeColDomain> list = new ArrayList<UlaLtypeColDomain>();
        for (UlaLtype ulaLtype : allList) {
            if (!pNodde.getLtypeCode().equals(ulaLtype.getLtypePcode())) continue;
            UlaLtypeColDomain ulaLtypeColDomain = new UlaLtypeColDomain();
            BeanUtils.copyAllPropertys((Object)ulaLtypeColDomain, (Object)ulaLtype);
            list.add(UlaLtypeServiceImpl.buildChildTree(ulaLtypeColDomain, allList));
        }
        if (!CollectionUtils.isEmpty(list)) {
            pNodde.setList(list);
        }
        return pNodde;
    }

    private static List<UlaLtype> getRootNodes(List<UlaLtype> list) {
        return list.stream().filter(u -> "0".equals(u.getLtypePcode())).collect(Collectors.toList());
    }
}

