/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmReportFormsMapper;
import com.yqbsoft.laser.service.user.domain.OcContractReDomain;
import com.yqbsoft.laser.service.user.domain.UmReportFormsDomain;
import com.yqbsoft.laser.service.user.domain.UmReportFormsReDomain;
import com.yqbsoft.laser.service.user.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.user.model.UmReportForms;
import com.yqbsoft.laser.service.user.service.UmReportFormsService;
import com.yqbsoft.laser.service.user.service.UserBaseService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmReportFormsServiceImpl
extends BaseServiceImpl
implements UmReportFormsService {
    private static final String SYS_CODE = "um.USER.UmReportFormsServiceImpl";
    private UmReportFormsMapper umReportFormsMapper;
    private UserBaseService userBaseService;

    public void setUserBaseService(UserBaseService userBaseService) {
        this.userBaseService = userBaseService;
    }

    public void setUmReportFormsMapper(UmReportFormsMapper umReportFormsMapper) {
        this.umReportFormsMapper = umReportFormsMapper;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmReportFormsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkReportForms(UmReportFormsDomain umReportFormsDomain) {
        if (null == umReportFormsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umReportFormsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setReportFormsDefault(UmReportForms umReportForms) {
        if (null == umReportForms) {
            return;
        }
        if (null == umReportForms.getDataState()) {
            umReportForms.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umReportForms.getGmtCreate()) {
            umReportForms.setGmtCreate(date);
        }
        umReportForms.setGmtModified(date);
        if (StringUtils.isBlank((String)umReportForms.getSheetCode())) {
            umReportForms.setSheetCode(this.getNo(null, "UmReportForms", "umReportForms", umReportForms.getTenantCode()));
        }
    }

    private int getReportFormsMaxCode() {
        int code = 0;
        try {
            return this.umReportFormsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmReportFormsServiceImpl.getReportFormsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setReportFormsUpdataDefault(UmReportForms umReportForms) {
        if (null == umReportForms) {
            return;
        }
        umReportForms.setGmtModified(this.getSysDate());
    }

    private void saveReportFormsModel(UmReportForms umReportForms) throws ApiException {
        if (null == umReportForms) {
            return;
        }
        try {
            this.umReportFormsMapper.insert(umReportForms);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.saveReportFormsModel.ex", (Throwable)e);
        }
    }

    private void saveReportFormsBatchModel(List<UmReportForms> umReportFormsList) throws ApiException {
        if (null == umReportFormsList || umReportFormsList.isEmpty()) {
            return;
        }
        try {
            this.umReportFormsMapper.insertBatch(umReportFormsList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.saveReportFormsBatchModel.ex", (Throwable)e);
        }
    }

    private UmReportForms getReportFormsModelById(Integer sheetId) {
        if (null == sheetId) {
            return null;
        }
        try {
            return this.umReportFormsMapper.selectByPrimaryKey(sheetId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmReportFormsServiceImpl.getReportFormsModelById", (Throwable)e);
            return null;
        }
    }

    private UmReportForms getReportFormsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umReportFormsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmReportFormsServiceImpl.getReportFormsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delReportFormsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umReportFormsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.delReportFormsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.delReportFormsModelByCode.num");
        }
    }

    private void deleteReportFormsModel(Integer sheetId) throws ApiException {
        if (null == sheetId) {
            return;
        }
        int i = 0;
        try {
            i = this.umReportFormsMapper.deleteByPrimaryKey(sheetId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.deleteReportFormsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.deleteReportFormsModel.num");
        }
    }

    private void updateReportFormsModel(UmReportForms umReportForms) throws ApiException {
        if (null == umReportForms) {
            return;
        }
        int i = 0;
        try {
            i = this.umReportFormsMapper.updateByPrimaryKey(umReportForms);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.updateReportFormsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.updateReportFormsModel.num");
        }
    }

    private void updateStateReportFormsModel(Integer sheetId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sheetId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sheetId", sheetId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umReportFormsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.updateStateReportFormsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.updateStateReportFormsModel.null");
        }
    }

    private void updateStateReportFormsModelByCode(String tenantCode, String sheetCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sheetCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sheetCode", sheetCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umReportFormsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.updateStateReportFormsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.updateStateReportFormsModelByCode.null");
        }
    }

    private UmReportForms makeReportForms(UmReportFormsDomain umReportFormsDomain, UmReportForms umReportForms) {
        if (null == umReportFormsDomain) {
            return null;
        }
        if (null == umReportForms) {
            umReportForms = new UmReportForms();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umReportForms, (Object)umReportFormsDomain);
            return umReportForms;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmReportFormsServiceImpl.makeReportForms", (Throwable)e);
            return null;
        }
    }

    private UmReportFormsReDomain makeUmReportFormsReDomain(UmReportForms umReportForms) {
        if (null == umReportForms) {
            return null;
        }
        UmReportFormsReDomain umReportFormsReDomain = new UmReportFormsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umReportFormsReDomain, (Object)umReportForms);
            return umReportFormsReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmReportFormsServiceImpl.makeUmReportFormsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmReportForms> queryReportFormsModelPage(Map<String, Object> parammap) {
        try {
            return this.umReportFormsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmReportFormsServiceImpl.queryReportFormsModel", (Throwable)e);
            return null;
        }
    }

    private int countReportForms(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umReportFormsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmReportFormsServiceImpl.countReportForms", (Throwable)e);
        }
        return i;
    }

    private UmReportForms createUmReportForms(UmReportFormsDomain umReportFormsDomain) {
        String msg = this.checkReportForms(umReportFormsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.saveReportForms.checkReportForms", msg);
        }
        UmReportForms umReportForms = this.makeReportForms(umReportFormsDomain, null);
        this.setReportFormsDefault(umReportForms);
        return umReportForms;
    }

    @Override
    public String saveReportForms(UmReportFormsDomain umReportFormsDomain) throws ApiException {
        UmReportForms umReportForms = this.createUmReportForms(umReportFormsDomain);
        this.saveReportFormsModel(umReportForms);
        return umReportForms.getSheetCode();
    }

    @Override
    public String saveReportFormsBatch(List<UmReportFormsDomain> umReportFormsDomainList) throws ApiException {
        if (null == umReportFormsDomainList || umReportFormsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmReportForms> umReportFormsList = new ArrayList<UmReportForms>();
        String code = "";
        for (UmReportFormsDomain umReportFormsDomain : umReportFormsDomainList) {
            UmReportForms umReportForms = this.createUmReportForms(umReportFormsDomain);
            code = umReportForms.getSheetCode();
            umReportFormsList.add(umReportForms);
        }
        this.saveReportFormsBatchModel(umReportFormsList);
        return code;
    }

    @Override
    public void updateReportFormsState(Integer sheetId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == sheetId) {
            return;
        }
        this.updateStateReportFormsModel(sheetId, dataState, oldDataState, map);
    }

    @Override
    public void updateReportFormsStateByCode(String tenantCode, String sheetCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)sheetCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateReportFormsModelByCode(tenantCode, sheetCode, dataState, oldDataState, map);
    }

    @Override
    public void updateReportForms(UmReportFormsDomain umReportFormsDomain) throws ApiException {
        String msg = this.checkReportForms(umReportFormsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.updateReportForms.checkReportForms", msg);
        }
        UmReportForms oldUmReportForms = this.getReportFormsModelById(umReportFormsDomain.getSheetId());
        if (null == oldUmReportForms) {
            throw new ApiException("um.USER.UmReportFormsServiceImpl.updateReportForms.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmReportForms umReportForms = this.makeReportForms(umReportFormsDomain, oldUmReportForms);
        this.setReportFormsUpdataDefault(umReportForms);
        this.updateReportFormsModel(umReportForms);
    }

    @Override
    public UmReportForms getReportForms(Integer sheetId) {
        if (null == sheetId) {
            return null;
        }
        return this.getReportFormsModelById(sheetId);
    }

    @Override
    public void deleteReportForms(Integer sheetId) throws ApiException {
        if (null == sheetId) {
            return;
        }
        this.deleteReportFormsModel(sheetId);
    }

    @Override
    public QueryResult<UmReportForms> queryReportFormsPage(Map<String, Object> map) {
        List<UmReportForms> umReportFormsList = this.queryReportFormsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countReportForms(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umReportFormsList);
        return queryResult;
    }

    @Override
    public UmReportForms getReportFormsByCode(String tenantCode, String sheetCode) throws ApiException {
        if (StringUtils.isBlank((String)sheetCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sheetCode", sheetCode);
        return this.getReportFormsModelByCode(map);
    }

    @Override
    public void deleteReportFormsByCode(String tenantCode, String sheetCode) throws ApiException {
        if (StringUtils.isBlank((String)sheetCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sheetCode", sheetCode);
        this.delReportFormsModelByCode(map);
    }

    @Override
    public void generateAndUpdateReportForms(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.logger.info("um.USER.UmReportFormsServiceImpl.GENERATEANDUPDATEREPORTFORMS.START");
        HashMap<String, Object> userParam = new HashMap<String, Object>();
        HashMap<String, Object> conParam = new HashMap<String, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        conParam.put("contractType", "07");
        conParam.put("dataState", 1);
        conParam.put("tenantCode", tenantCode);
        userParam.put("tenantCode", tenantCode);
        userParam.put("qualityQtypeName", "\u52a0\u76df\u5546");
        QueryResult<UmUserinfoReDomainBean> userinfoPage = this.userBaseService.queryUserinfoPage(userParam);
        if (userinfoPage == null || ListUtil.isEmpty((Collection)userinfoPage.getList())) {
            return;
        }
        HashMap<String, String> cmap = new HashMap<String, String>();
        String queryContractApi = "oc.contract.queryContractPageReDomain";
        ArrayList<UmReportFormsDomain> formsDomains = new ArrayList<UmReportFormsDomain>();
        Date nowTime = new Date();
        for (UmUserinfoReDomainBean userinfo : userinfoPage.getList()) {
            if (null == userinfo) continue;
            String userinfoCode = userinfo.getUserinfoCode();
            conParam.put("memberBcode", userinfoCode);
            cmap.put("map", JsonUtil.buildNormalBinder().toJson(conParam));
            QueryResult queryResult = this.getQueryResutl(queryContractApi, cmap, OcContractReDomain.class);
            if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) continue;
            this.logger.info("um.USER.UmReportFormsServiceImpl.generateAndUpdateReportForms.queryResult", (Object)queryResult.getTotal());
            map.put("userinfoCode", userinfoCode);
            QueryResult<UmReportForms> formsPage = this.queryReportFormsPage(map);
            UmReportFormsDomain umReportFormsDomain = new UmReportFormsDomain();
            if (formsPage != null && ListUtil.isNotEmpty((Collection)formsPage.getList())) {
                try {
                    BeanUtils.copyAllPropertys((Object)umReportFormsDomain, formsPage.getList().get(0));
                }
                catch (Exception e) {
                    this.logger.error("um.USER.UmReportFormsServiceImpl.generateAndUpdateReportForms.e", (Object)e.getMessage());
                }
            }
            List contracts = queryResult.getList();
            umReportFormsDomain.setAreaName(userinfo.getAreaName());
            umReportFormsDomain.setUserinfoCode(userinfoCode);
            umReportFormsDomain.setUserinfoOcode(userinfo.getUserinfoOcode());
            umReportFormsDomain.setUserinfoCompname(userinfo.getUserinfoCompname());
            umReportFormsDomain.setStoreState(userinfo.getDataState().toString());
            BigDecimal glfSubTotalMoney = new BigDecimal(0);
            BigDecimal xtfSubTotalMoney = new BigDecimal(0);
            BigDecimal glf_1_30 = new BigDecimal(0);
            BigDecimal glf_31_90 = new BigDecimal(0);
            BigDecimal glf_91_180 = new BigDecimal(0);
            BigDecimal glf_181_365 = new BigDecimal(0);
            BigDecimal glf_365 = new BigDecimal(0);
            BigDecimal xtf_1_30 = new BigDecimal(0);
            BigDecimal xtf_31_90 = new BigDecimal(0);
            BigDecimal xtf_91_180 = new BigDecimal(0);
            BigDecimal xtf_181_365 = new BigDecimal(0);
            BigDecimal xtf_365 = new BigDecimal(0);
            for (OcContractReDomain contract : contracts) {
                if (null == contract) continue;
                BigDecimal contractMoney = contract.getContractMoney();
                Date gmtCreate = contract.getGmtCreate();
                long day = (nowTime.getTime() - gmtCreate.getTime()) / 86400000L;
                this.logger.info("um.USER.UmReportFormsServiceImpl.generateAndUpdateReportForms.date", (Object)(nowTime.getTime() + " - " + gmtCreate.getTime() + " = " + day));
                if ("1".equals(contract.getContractProperty())) {
                    glfSubTotalMoney = glfSubTotalMoney.add(contractMoney);
                    if (day >= 0L && day <= 30L) {
                        glf_1_30 = glf_1_30.add(contractMoney);
                        continue;
                    }
                    if (day >= 31L && day <= 90L) {
                        glf_31_90 = glf_31_90.add(contractMoney);
                        continue;
                    }
                    if (day >= 91L && day <= 180L) {
                        glf_91_180 = glf_91_180.add(contractMoney);
                        continue;
                    }
                    if (day >= 181L && day <= 365L) {
                        glf_181_365 = glf_181_365.add(contractMoney);
                        continue;
                    }
                    if (day <= 365L) continue;
                    glf_365 = glf_365.add(contractMoney);
                    continue;
                }
                if (!"2".equals(contract.getContractProperty())) continue;
                xtfSubTotalMoney = xtfSubTotalMoney.add(contractMoney);
                if (day >= 0L && day <= 30L) {
                    xtf_1_30 = xtf_1_30.add(contractMoney);
                    continue;
                }
                if (day >= 31L && day <= 90L) {
                    xtf_31_90 = xtf_31_90.add(contractMoney);
                    continue;
                }
                if (day >= 91L && day <= 180L) {
                    xtf_91_180 = xtf_91_180.add(contractMoney);
                    continue;
                }
                if (day >= 181L && day <= 365L) {
                    xtf_181_365 = xtf_181_365.add(contractMoney);
                    continue;
                }
                if (day <= 365L) continue;
                xtf_365 = xtf_365.add(contractMoney);
            }
            umReportFormsDomain.setGlf130(glf_1_30);
            umReportFormsDomain.setGlf3190(glf_31_90);
            umReportFormsDomain.setGlf91180(glf_91_180);
            umReportFormsDomain.setGlf181365(glf_181_365);
            umReportFormsDomain.setGlf365(glf_365);
            umReportFormsDomain.setXtf130(xtf_1_30);
            umReportFormsDomain.setXtf3190(xtf_31_90);
            umReportFormsDomain.setXtf91180(xtf_91_180);
            umReportFormsDomain.setXtf181365(xtf_181_365);
            umReportFormsDomain.setXtf365(xtf_365);
            umReportFormsDomain.setXtfSubtotalMoney(xtfSubTotalMoney);
            umReportFormsDomain.setGlfSubtotalMoney(glfSubTotalMoney);
            umReportFormsDomain.setTotalMoney(glfSubTotalMoney.add(xtfSubTotalMoney));
            umReportFormsDomain.setTenantCode(tenantCode);
            if (StringUtils.isBlank((Integer)umReportFormsDomain.getSheetId())) {
                formsDomains.add(umReportFormsDomain);
                continue;
            }
            this.updateReportForms(umReportFormsDomain);
        }
        this.saveReportFormsBatch(formsDomains);
    }
}

