/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.user.dao.UmUQualityMapper;
import com.yqbsoft.laser.service.user.domain.UmUQualityDomain;
import com.yqbsoft.laser.service.user.domain.UmUQualityReDomain;
import com.yqbsoft.laser.service.user.model.UmUQuality;
import com.yqbsoft.laser.service.user.service.UmUQualityService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class UmUQualityServiceImpl
extends BaseServiceImpl
implements UmUQualityService {
    private static final String SYS_CODE = "um.USER.UmUQualityServiceImpl";
    private UmUQualityMapper umUQualityMapper;

    public void setUmUQualityMapper(UmUQualityMapper umUQualityMapper) {
        this.umUQualityMapper = umUQualityMapper;
    }

    private Date getSysDate() {
        try {
            return this.umUQualityMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUQualityServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUQuality(UmUQualityDomain umUQualityDomain) {
        if (null == umUQualityDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)umUQualityDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUQualityDefault(UmUQuality umUQuality) {
        if (null == umUQuality) {
            return;
        }
        if (null == umUQuality.getDataState()) {
            umUQuality.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umUQuality.getGmtCreate()) {
            umUQuality.setGmtCreate(date);
        }
        umUQuality.setGmtModified(date);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)umUQuality.getUqualityCode())) {
            umUQuality.setUqualityCode(this.getNo(null, "UmUQuality", "umUQuality", umUQuality.getTenantCode()));
        }
    }

    private int getUQualityMaxCode() {
        int code = 0;
        try {
            return this.umUQualityMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUQualityServiceImpl.getUQualityMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUQualityUpdataDefault(UmUQuality umUQuality) {
        if (null == umUQuality) {
            return;
        }
        umUQuality.setGmtModified(this.getSysDate());
    }

    private void saveUQualityModel(UmUQuality umUQuality) throws ApiException {
        if (null == umUQuality) {
            return;
        }
        try {
            this.umUQualityMapper.insert(umUQuality);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.saveUQualityModel.ex", (Throwable)e);
        }
    }

    private void saveUQualityBatchModel(List<UmUQuality> umUQualityList) throws ApiException {
        if (null == umUQualityList || umUQualityList.isEmpty()) {
            return;
        }
        try {
            this.umUQualityMapper.insertBatch(umUQualityList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.saveUQualityBatchModel.ex", (Throwable)e);
        }
    }

    private UmUQuality getUQualityModelById(Integer uqualityId) {
        if (null == uqualityId) {
            return null;
        }
        try {
            return this.umUQualityMapper.selectByPrimaryKey(uqualityId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUQualityServiceImpl.getUQualityModelById", (Throwable)e);
            return null;
        }
    }

    private UmUQuality getUQualityModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umUQualityMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUQualityServiceImpl.getUQualityModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUQualityModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umUQualityMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.delUQualityModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.delUQualityModelByCode.num");
        }
    }

    private void deleteUQualityModel(Integer uqualityId) throws ApiException {
        if (null == uqualityId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUQualityMapper.deleteByPrimaryKey(uqualityId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.deleteUQualityModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.deleteUQualityModel.num");
        }
    }

    private void updateUQualityModel(UmUQuality umUQuality) throws ApiException {
        if (null == umUQuality) {
            return;
        }
        int i = 0;
        try {
            i = this.umUQualityMapper.updateByPrimaryKeySelective(umUQuality);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.updateUQualityModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.updateUQualityModel.num");
        }
    }

    private void updateStateUQualityModel(Integer uqualityId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == uqualityId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uqualityId", uqualityId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUQualityMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.updateStateUQualityModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.updateStateUQualityModel.null");
        }
    }

    private void updateStateUQualityModelByCode(String tenantCode, String uqualityCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)uqualityCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("uqualityCode", uqualityCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUQualityMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.updateStateUQualityModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.updateStateUQualityModelByCode.null");
        }
    }

    private UmUQuality makeUQuality(UmUQualityDomain umUQualityDomain, UmUQuality umUQuality) {
        if (null == umUQualityDomain) {
            return null;
        }
        if (null == umUQuality) {
            umUQuality = new UmUQuality();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUQuality, (Object)umUQualityDomain);
            return umUQuality;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUQualityServiceImpl.makeUQuality", (Throwable)e);
            return null;
        }
    }

    private UmUQualityReDomain makeUmUQualityReDomain(UmUQuality umUQuality) {
        if (null == umUQuality) {
            return null;
        }
        UmUQualityReDomain umUQualityReDomain = new UmUQualityReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umUQualityReDomain, (Object)umUQuality);
            return umUQualityReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUQualityServiceImpl.makeUmUQualityReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmUQuality> queryUQualityModelPage(Map<String, Object> parammap) {
        try {
            return this.umUQualityMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUQualityServiceImpl.queryUQualityModel", (Throwable)e);
            return null;
        }
    }

    private int countUQuality(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUQualityMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUQualityServiceImpl.countUQuality", (Throwable)e);
        }
        return i;
    }

    private UmUQuality createUmUQuality(UmUQualityDomain umUQualityDomain) {
        String msg = this.checkUQuality(umUQualityDomain);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.saveUQuality.checkUQuality", msg);
        }
        UmUQuality umUQuality = this.makeUQuality(umUQualityDomain, null);
        this.setUQualityDefault(umUQuality);
        return umUQuality;
    }

    @Override
    public String saveUQuality(UmUQualityDomain umUQualityDomain) throws ApiException {
        UmUQuality umUQuality = this.createUmUQuality(umUQualityDomain);
        this.saveUQualityModel(umUQuality);
        return umUQuality.getUqualityCode();
    }

    @Override
    public String saveUQualityBatch(List<UmUQualityDomain> umUQualityDomainList) throws ApiException {
        if (null == umUQualityDomainList || umUQualityDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmUQuality> umUQualityList = new ArrayList<UmUQuality>();
        String code = "";
        for (UmUQualityDomain umUQualityDomain : umUQualityDomainList) {
            UmUQuality umUQuality = this.createUmUQuality(umUQualityDomain);
            code = umUQuality.getUqualityCode();
            umUQualityList.add(umUQuality);
        }
        this.saveUQualityBatchModel(umUQualityList);
        return code;
    }

    @Override
    public void updateUQualityState(Integer uqualityId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == uqualityId) {
            return;
        }
        this.updateStateUQualityModel(uqualityId, dataState, oldDataState, map);
    }

    @Override
    public void updateUQualityStateByCode(String tenantCode, String uqualityCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)uqualityCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUQualityModelByCode(tenantCode, uqualityCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUQuality(UmUQualityDomain umUQualityDomain) throws ApiException {
        String msg = this.checkUQuality(umUQualityDomain);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.updateUQuality.checkUQuality", msg);
        }
        UmUQuality oldUmUQuality = this.getUQualityModelById(umUQualityDomain.getUqualityId());
        if (null == oldUmUQuality) {
            throw new ApiException("um.USER.UmUQualityServiceImpl.updateUQuality.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUQuality umUQuality = this.makeUQuality(umUQualityDomain, oldUmUQuality);
        this.setUQualityUpdataDefault(umUQuality);
        if (!StringUtils.isEmpty((Object)umUQualityDomain.getQualityQtypeCode())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("qualityCode", umUQualityDomain.getQualityQtypeCode());
            List<UmUQuality> query = this.umUQualityMapper.query(map);
            if (!ListUtil.isEmpty(query)) {
                UmUQuality uQuality = query.get(0);
                umUQuality.setQualityQtypeName(uQuality.getQualityQtypeName());
            }
        }
        this.updateUQualityModel(umUQuality);
    }

    @Override
    public UmUQuality getUQuality(Integer uqualityId) {
        if (null == uqualityId) {
            return null;
        }
        return this.getUQualityModelById(uqualityId);
    }

    @Override
    public void deleteUQuality(Integer uqualityId) throws ApiException {
        if (null == uqualityId) {
            return;
        }
        this.deleteUQualityModel(uqualityId);
    }

    @Override
    public QueryResult<UmUQuality> queryUQualityPage(Map<String, Object> map) {
        List<UmUQuality> umUQualityList = this.queryUQualityModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUQuality(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUQualityList);
        return queryResult;
    }

    @Override
    public UmUQuality getUQualityByCode(String tenantCode, String uqualityCode) throws ApiException {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)uqualityCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("uqualityCode", uqualityCode);
        return this.getUQualityModelByCode(map);
    }

    @Override
    public void deleteUQualityByCode(String tenantCode, String uqualityCode) throws ApiException {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)uqualityCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("uqualityCode", uqualityCode);
        this.delUQualityModelByCode(map);
    }
}

