/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmMemauMapper;
import com.yqbsoft.laser.service.user.domain.UmMemauDomain;
import com.yqbsoft.laser.service.user.domain.UmMemauReDomain;
import com.yqbsoft.laser.service.user.model.UmMemau;
import com.yqbsoft.laser.service.user.service.UmMemauService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmMemauServiceImpl
extends BaseServiceImpl
implements UmMemauService {
    private static final String SYS_CODE = SYS_CODE + ".UmMemauServiceImpl";
    private UmMemauMapper umMemauMapper;

    public void setUmMemauMapper(UmMemauMapper umMemauMapper) {
        this.umMemauMapper = umMemauMapper;
    }

    private Date getSysDate() {
        return null;
    }

    private String checkMemau(UmMemauDomain umMemauDomain) {
        if (null == umMemauDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umMemauDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMemauDefault(UmMemau umMemau) {
        if (null == umMemau) {
            return;
        }
        if (null == umMemau.getDataState()) {
            umMemau.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umMemau.getGmtCreate()) {
            umMemau.setGmtCreate(date);
        }
        umMemau.setGmtModified(date);
        if (StringUtils.isBlank((String)umMemau.getMemauCode())) {
            umMemau.setMemauCode(this.getNo(null, "UmMemau", "umMemau", umMemau.getTenantCode()));
        }
    }

    private int getMemauMaxCode() {
        int code = 0;
        try {
            return this.umMemauMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getMemauMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMemauUpdataDefault(UmMemau umMemau) {
        if (null == umMemau) {
            return;
        }
        umMemau.setGmtModified(this.getSysDate());
    }

    private void saveMemauModel(UmMemau umMemau) throws ApiException {
        if (null == umMemau) {
            return;
        }
        try {
            this.umMemauMapper.insert(umMemau);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveMemauModel.ex", (Throwable)e);
        }
    }

    private void saveMemauBatchModel(List<UmMemau> umMemauList) throws ApiException {
        if (null == umMemauList || umMemauList.isEmpty()) {
            return;
        }
        try {
            this.umMemauMapper.insertBatch(umMemauList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveMemauBatchModel.ex", (Throwable)e);
        }
    }

    private UmMemau getMemauModelById(Integer memauId) {
        if (null == memauId) {
            return null;
        }
        try {
            return this.umMemauMapper.selectByPrimaryKey(memauId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getMemauModelById", (Throwable)e);
            return null;
        }
    }

    private UmMemau getMemauModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umMemauMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getMemauModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMemauModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umMemauMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delMemauModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delMemauModelByCode.num");
        }
    }

    private void deleteMemauModel(Integer memauId) throws ApiException {
        if (null == memauId) {
            return;
        }
        int i = 0;
        try {
            i = this.umMemauMapper.deleteByPrimaryKey(memauId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteMemauModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteMemauModel.num");
        }
    }

    private void updateMemauModel(UmMemau umMemau) throws ApiException {
        if (null == umMemau) {
            return;
        }
        int i = 0;
        try {
            i = this.umMemauMapper.updateByPrimaryKey(umMemau);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateMemauModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateMemauModel.num");
        }
    }

    private void updateStateMemauModel(Integer memauId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == memauId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memauId", memauId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umMemauMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateMemauModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateMemauModel.null");
        }
    }

    private void updateStateMemauModelByCode(String tenantCode, String memauCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)memauCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memauCode", memauCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umMemauMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateMemauModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateMemauModelByCode.null");
        }
    }

    private UmMemau makeMemau(UmMemauDomain umMemauDomain, UmMemau umMemau) {
        if (null == umMemauDomain) {
            return null;
        }
        if (null == umMemau) {
            umMemau = new UmMemau();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umMemau, (Object)umMemauDomain);
            return umMemau;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeMemau", (Throwable)e);
            return null;
        }
    }

    private UmMemauReDomain makeUmMemauReDomain(UmMemau umMemau) {
        if (null == umMemau) {
            return null;
        }
        UmMemauReDomain umMemauReDomain = new UmMemauReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umMemauReDomain, (Object)umMemau);
            return umMemauReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeUmMemauReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmMemau> queryMemauModelPage(Map<String, Object> parammap) {
        try {
            return this.umMemauMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryMemauModel", (Throwable)e);
            return null;
        }
    }

    private int countMemau(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umMemauMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countMemau", (Throwable)e);
        }
        return i;
    }

    private UmMemau createUmMemau(UmMemauDomain umMemauDomain) {
        String msg = this.checkMemau(umMemauDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveMemau.checkMemau", msg);
        }
        UmMemau umMemau = this.makeMemau(umMemauDomain, null);
        this.setMemauDefault(umMemau);
        return umMemau;
    }

    @Override
    public String saveMemau(UmMemauDomain umMemauDomain) throws ApiException {
        UmMemau umMemau = this.createUmMemau(umMemauDomain);
        this.saveMemauModel(umMemau);
        return umMemau.getMemauCode();
    }

    @Override
    public String saveMemauBatch(List<UmMemauDomain> umMemauDomainList) throws ApiException {
        if (null == umMemauDomainList || umMemauDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmMemau> umMemauList = new ArrayList<UmMemau>();
        String code = "";
        for (UmMemauDomain umMemauDomain : umMemauDomainList) {
            UmMemau umMemau = this.createUmMemau(umMemauDomain);
            code = umMemau.getMemauCode();
            umMemauList.add(umMemau);
        }
        this.saveMemauBatchModel(umMemauList);
        return code;
    }

    @Override
    public void updateMemauState(Integer memauId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == memauId) {
            return;
        }
        this.updateStateMemauModel(memauId, dataState, oldDataState, map);
    }

    @Override
    public void updateMemauStateByCode(String tenantCode, String memauCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)memauCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMemauModelByCode(tenantCode, memauCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMemau(UmMemauDomain umMemauDomain) throws ApiException {
        String msg = this.checkMemau(umMemauDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateMemau.checkMemau", msg);
        }
        UmMemau oldUmMemau = this.getMemauModelById(umMemauDomain.getMemauId());
        if (null == oldUmMemau) {
            throw new ApiException(SYS_CODE + ".updateMemau.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmMemau umMemau = this.makeMemau(umMemauDomain, oldUmMemau);
        this.setMemauUpdataDefault(umMemau);
        this.updateMemauModel(umMemau);
    }

    @Override
    public UmMemau getMemau(Integer memauId) {
        if (null == memauId) {
            return null;
        }
        return this.getMemauModelById(memauId);
    }

    @Override
    public void deleteMemau(Integer memauId) throws ApiException {
        if (null == memauId) {
            return;
        }
        this.deleteMemauModel(memauId);
    }

    @Override
    public QueryResult<UmMemau> queryMemauPage(Map<String, Object> map) {
        List<UmMemau> umMemauList = this.queryMemauModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMemau(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umMemauList);
        return queryResult;
    }

    @Override
    public UmMemau getMemauByCode(String tenantCode, String memauCode) throws ApiException {
        if (StringUtils.isBlank((String)memauCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memauCode", memauCode);
        return this.getMemauModelByCode(map);
    }

    @Override
    public void deleteMemauByCode(String tenantCode, String memauCode) throws ApiException {
        if (StringUtils.isBlank((String)memauCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memauCode", memauCode);
        this.delMemauModelByCode(map);
    }

    private void updateMemauEnableModel() throws ApiException {
        try {
            this.umMemauMapper.updateMemauEnable();
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateMemauModel.ex", (Throwable)e);
        }
    }

    private void updateMemauDiscontinueModel() throws ApiException {
        try {
            this.umMemauMapper.updateMemauDiscontinue();
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateMemauModel.ex", (Throwable)e);
        }
    }

    @Override
    public void updateMemauEnable() throws ApiException {
        this.updateMemauEnableModel();
    }

    @Override
    public void updateMemauDiscontinue() throws ApiException {
        this.updateMemauDiscontinueModel();
    }

    @Override
    public String getMemauDatastate(Map<String, Object> map) throws ApiException {
        List<UmMemau> umMemaus = this.queryMemauModelPage(map);
        if (ListUtil.isEmpty(umMemaus)) {
            return "0";
        }
        UmMemau umMemau = umMemaus.get(0);
        if (umMemau.getDataState() == 0) {
            return "0";
        }
        return "1";
    }

    @Override
    public Boolean queryAuditDateState(String memberCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", "1");
        List<UmMemau> umMemaus = this.queryMemauModelPage(map);
        if (ListUtil.isEmpty(umMemaus)) {
            return false;
        }
        return true;
    }
}

